/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.commands;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.scientific.py.tables.panel.datawrangler.DSSummaryCreationSettings;
import com.intellij.scientific.py.tables.panel.datawrangler.SummaryTreePart;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J!\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/scientific/py/tables/commands/DSTableCommands;", "", "<init>", "()V", "PYDEV_COMMAND_PREFIX", "", "PYDEV_TABLE_EXCEPTION_PREFIX", "commandTemplate", "tableVariable", "functionsDefinitionsAndCommandToExecute", "formatPythonCommands", "commands", "", "([Ljava/lang/String;)Ljava/lang/String;", "infoCommands", "getInfoCommands", "()Ljava/lang/String;", "describeCommands", "getDescribeCommands", "visualizationCommands", "getVisualizationCommands", "summarizeCommand", "settings", "Lcom/intellij/scientific/py/tables/panel/datawrangler/DSSummaryCreationSettings;", "action", "commandColumnSummarize", "columnName", "commandTotalSummarize", "intellij.scientific.py.tables"})
public final class DSTableCommands {
    @NotNull
    public static final DSTableCommands INSTANCE = new DSTableCommands();
    @NotNull
    public static final String PYDEV_COMMAND_PREFIX = "# pydev_util_command\n";
    @NotNull
    public static final String PYDEV_TABLE_EXCEPTION_PREFIX = "_jb_get_info_command got exception: ";
    @NotNull
    private static final String infoCommands;
    @NotNull
    private static final String describeCommands;
    @NotNull
    private static final String visualizationCommands;

    private DSTableCommands() {
    }

    @NotNull
    public final String commandTemplate(@NotNull String tableVariable, @NotNull String functionsDefinitionsAndCommandToExecute) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)functionsDefinitionsAndCommandToExecute, (String)"functionsDefinitionsAndCommandToExecute");
        return "\n# pydev_util_command\n\ndef _jb_get_info_command():\n    initCommandResult = eval(compile(\"" + StringUtil.escapeStringCharacters((String)tableVariable) + "\", '<input>', 'eval'), globals(), None)\n" + StringsKt.prependIndent((String)functionsDefinitionsAndCommandToExecute, (String)"    ") + "\ntry:\n    _jb_get_info_command()\nexcept (RuntimeError, Exception) as e:\n    print('_jb_get_info_command got exception: ', e)\nfinally:\n    del _jb_get_info_command\n";
    }

    private final String formatPythonCommands(String ... commands) {
        return ArraysKt.joinToString$default((Object[])commands, (CharSequence)"\n", null, null, (int)0, null, DSTableCommands::formatPythonCommands$lambda$0, (int)30, null);
    }

    @NotNull
    public final String getInfoCommands() {
        return infoCommands;
    }

    @NotNull
    public final String getDescribeCommands() {
        return describeCommands;
    }

    @NotNull
    public final String getVisualizationCommands() {
        return visualizationCommands;
    }

    private final String summarizeCommand(DSSummaryCreationSettings settings, String action) {
        return StringsKt.trimIndent((String)("\n" + settings.getCodeForSummarizeProperty().get() + "\ntry:\n    " + action + "\nexcept:\n    print(" + SummaryTreePart.Companion.getVALUE_NOT_TO_SHOW() + ")\n"));
    }

    @NotNull
    public final String commandColumnSummarize(@NotNull DSSummaryCreationSettings settings, @NotNull String columnName) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        return this.summarizeCommand(settings, "print(summarize(initCommandResult, '" + columnName + "'))");
    }

    @NotNull
    public final String commandTotalSummarize(@NotNull DSSummaryCreationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return this.summarizeCommand(settings, "print(summarize_total(initCommandResult))");
    }

    private static final CharSequence formatPythonCommands$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "print(" + it + ")";
    }

    static {
        String[] stringArray = new String[]{"get_type(initCommandResult)", "'__pydev_val__'", "get_shape(initCommandResult)", "'__pydev_val__'", "get_head(initCommandResult)", "'__pydev_val__'", "get_column_types(initCommandResult)"};
        infoCommands = INSTANCE.formatPythonCommands(stringArray);
        stringArray = new String[]{"get_column_descriptions(initCommandResult)"};
        describeCommands = INSTANCE.formatPythonCommands(stringArray);
        stringArray = new String[]{"get_value_occurrences_count(initCommandResult)", "'__pydev_val__'"};
        visualizationCommands = INSTANCE.formatPythonCommands(stringArray);
    }
}

