/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.BandGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintsCollection;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BandGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "isVertical", "", "(Z)V", "flipHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "wontRender", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getWontRender", "()Ljava/util/List;", "yMaxAes", "", "yMinAes", "buildHints", "", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "viewPort", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "buildIntern", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "resample", "range", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBandGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BandGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/BandGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1549#2:120\n1620#2,3:121\n1549#2:125\n1620#2,3:126\n1#3:124\n*S KotlinDebug\n*F\n+ 1 BandGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/BandGeom\n*L\n32#1:120\n32#1:121,3\n110#1:125\n110#1:126,3\n*E\n"})
public final class BandGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    @NotNull
    private final FlippableGeomHelper flipHelper;
    @NotNull
    private final Aes<Double> yMinAes;
    @NotNull
    private final Aes<Double> yMaxAes;
    public static final int TOOLTIP_SAMPLE_SIZE = 512;
    public static final boolean HANDLES_GROUPS = false;

    public BandGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.flipHelper = new FlippableGeomHelper(this.isVertical);
        this.yMinAes = this.flipHelper.getEffectiveAes(Aes.Companion.getYMIN());
        this.yMaxAes = this.flipHelper.getEffectiveAes(Aes.Companion.getYMAX());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new Aes[]{Aes.Companion.getXMIN(), Aes.Companion.getXMAX()};
        object = CollectionsKt.listOf((Object[])object);
        FlippableGeomHelper flippableGeomHelper = this.flipHelper;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(flippableGeomHelper.getEffectiveAes((Aes<Double>)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper.SvgElementHelper svgHelper = new GeomHelper(pos, coord, ctx2).createSvgElementHelper().setStrokeAlphaEnabled(true).setResamplingEnabled(!coord.isLinear());
        DoubleRectangle viewPort = GeomBase.Companion.overallAesBounds(ctx2).flipIf(!this.isVertical);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            Double d = p.finiteOrNull(this.yMinAes);
            if (d == null) {
                continue;
            }
            double yMin = d;
            Double d2 = p.finiteOrNull(this.yMaxAes);
            if (d2 == null) {
                continue;
            }
            double yMax = d2;
            if (yMin > yMax) continue;
            DoubleRectangle rect2 = DoubleRectangle.Companion.hvRange(viewPort.xRange(), new DoubleSpan(yMin, yMax));
            List list2 = CollectionsKt.toList(rect2.getParts());
            DoubleSegment topSide = (DoubleSegment)list2.get(0);
            DoubleSegment bottomSide = (DoubleSegment)list2.get(3);
            Pair<SvgNode, List<DoubleVector>> pair2 = svgHelper.createRectangle(rect2.flipIf(!this.isVertical), p, (Function1<? super DataPointAesthetics, Double>)((Function1)buildIntern.1.INSTANCE));
            if (pair2 == null) continue;
            SvgNode rectSvg = (SvgNode)pair2.component1();
            Pair pair3 = GeomHelper.SvgElementHelper.createLine$default(svgHelper, topSide.flipIf(!this.isVertical), p, null, 4, null);
            if (pair3 == null) continue;
            SvgNode topSvg = (SvgNode)pair3.component1();
            Pair pair4 = GeomHelper.SvgElementHelper.createLine$default(svgHelper, bottomSide.flipIf(!this.isVertical), p, null, 4, null);
            if (pair4 == null) continue;
            SvgNode bottomSvg = (SvgNode)pair4.component1();
            root.add(rectSvg);
            root.add(topSvg);
            root.add(bottomSvg);
        }
        this.buildHints(aesthetics2, pos, coord, ctx2, viewPort);
    }

    private final void buildHints(Aesthetics aesthetics2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2, DoubleRectangle viewPort) {
        boolean bl;
        GeomHelper helper2 = new GeomHelper(pos, coord, ctx2);
        Function1<DataPointAesthetics, List<Color>> colorMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.BAND, ctx2);
        boolean bl2 = this.isVertical;
        if (bl2) {
            bl = !ctx2.getFlipped();
        } else if (!bl2) {
            bl = ctx2.getFlipped();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isVerticallyOriented = bl;
        TipLayoutHint.Kind kind = TipLayoutHint.Kind.VERTICAL_TOOLTIP;
        Object object = kind;
        HintsCollection.HintConfigFactory hintConfigFactory = new HintsCollection.HintConfigFactory().defaultObjectRadius(0.0);
        boolean bl3 = false;
        boolean bl4 = isVerticallyOriented;
        TipLayoutHint.Kind kind2 = bl4 ? kind : null;
        if (kind2 == null) {
            kind2 = TipLayoutHint.Kind.HORIZONTAL_TOOLTIP;
        }
        HintsCollection.HintConfigFactory hint = hintConfigFactory.defaultKind(kind2);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            object = this.resample(viewPort.xRange()).iterator();
            while (object.hasNext()) {
                double x2 = ((Number)object.next()).doubleValue();
                Object[] objectArray = new Aes[]{this.yMinAes, this.yMaxAes};
                for (Aes aes2 : CollectionsKt.listOf((Object[])objectArray)) {
                    DoubleVector point2;
                    Color defaultColor;
                    Double d = (Double)p.get(aes2);
                    if (d == null) {
                        continue;
                    }
                    double value2 = d;
                    if (p.fill() == null) continue;
                    hint.defaultCoord(x2).defaultColor(defaultColor, null);
                    HintsCollection hintsCollection = new HintsCollection(p, helper2).addHint(hint.create(aes2));
                    GeomTargetCollector.TooltipParams tooltipParams = new GeomTargetCollector.TooltipParams(hintsCollection.getHints(), null, null, (List)colorMapper.invoke((Object)p), 6, null);
                    if (helper2.toClient(new DoubleVector(x2, value2).flipIf(!this.isVertical), p) == null) continue;
                    boolean bl5 = false;
                    GeomTargetCollector.DefaultImpls.addPoint$default(ctx2.getTargetCollector(), p.index(), point2, 0.0, tooltipParams, null, 16, null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Double> resample(DoubleSpan range) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)512);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(range.getLowerEnd() + (double)i / (double)511 * (range.getUpperEnd() - range.getLowerEnd()));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BandGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "TOOLTIP_SAMPLE_SIZE", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

