/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.css.engine.value.svg12;

import org.jetbrains.relocated.apache.batik.css.engine.CSSEngine;
import org.jetbrains.relocated.apache.batik.css.engine.CSSStylableElement;
import org.jetbrains.relocated.apache.batik.css.engine.StyleMap;
import org.jetbrains.relocated.apache.batik.css.engine.value.FloatValue;
import org.jetbrains.relocated.apache.batik.css.engine.value.LengthManager;
import org.jetbrains.relocated.apache.batik.css.engine.value.Value;
import org.jetbrains.relocated.apache.batik.css.engine.value.svg12.LineHeightValue;
import org.jetbrains.relocated.apache.batik.css.engine.value.svg12.SVG12ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class LineHeightManager
extends LengthManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 43;
    }

    @Override
    public String getPropertyName() {
        return "line-height";
    }

    @Override
    public Value getDefaultValue() {
        return SVG12ValueConstants.NORMAL_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine2) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 12: {
                return SVG12ValueConstants.INHERIT_VALUE;
            }
            case 35: {
                String s = lu.getStringValue().toLowerCase();
                if ("normal".equals(s)) {
                    return SVG12ValueConstants.NORMAL_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lu.getStringValue());
            }
        }
        return super.createValue(lu, engine2);
    }

    @Override
    protected int getOrientation() {
        return 1;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine2, int idx, StyleMap sm, Value value2) {
        if (value2.getCssValueType() != 1) {
            return value2;
        }
        switch (value2.getPrimitiveType()) {
            case 1: {
                return new LineHeightValue(1, value2.getFloatValue(), true);
            }
            case 2: {
                float v = value2.getFloatValue();
                int fsidx = engine2.getFontSizeIndex();
                float fs = engine2.getComputedStyle(elt, pseudo, fsidx).getFloatValue();
                return new FloatValue(1, v * fs * 0.01f);
            }
        }
        return super.computeValue(elt, pseudo, engine2, idx, sm, value2);
    }
}

