/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.view.details.DockerDetailsTab;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.EdtNoGetDataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u001cJ\u0012\u0010\u001d\u001a\u00020\u00002\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0014\u0010 \u001a\u00020\u00182\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0003J\u0014\u0010\"\u001a\u00020\u00182\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0007J$\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0016\u0010$\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u00120%J\b\u0010&\u001a\u00020\u0018H\u0007J\b\u0010'\u001a\u00020\u0018H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u001fH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR)\u0010\f\u001a\u001d\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u000f*\b\u0012\u0002\b\u0003\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lcom/intellij/docker/view/details/DockerTabManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "getContentManager", "()Lcom/intellij/ui/content/ContentManager;", "myTabs", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/docker/view/details/DockerDetailsTab;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "myIsDisposed", "", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "selectContent", "", "content", "Lcom/intellij/ui/content/Content;", "getTabs", "", "withHelpTopicId", "topicId", "", "insertTabContent", "tab", "addTab", "findTab", "condition", "Lkotlin/Function1;", "refreshTabs", "dispose", "selectTab", "tabDisplayName", "MyContentManager", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerTabManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerTabManager.kt\ncom/intellij/docker/view/details/DockerTabManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n967#2,7:164\n1863#2,2:172\n295#2,2:174\n1#3:171\n*S KotlinDebug\n*F\n+ 1 DockerTabManager.kt\ncom/intellij/docker/view/details/DockerTabManager\n*L\n89#1:164,7\n133#1:172,2\n149#1:174,2\n*E\n"})
public final class DockerTabManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ContentManager contentManager;
    @NotNull
    private final ConcurrentList<DockerDetailsTab<?>> myTabs;
    private volatile boolean myIsDisposed;

    public DockerTabManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.contentManager = (ContentManager)new MyContentManager(this.project);
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.myTabs = concurrentList;
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.contentManager));
        this.contentManager.addContentManagerListener(new ContentManagerListener(){

            public void selectionChanged(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    ((DockerDetailsTab)myTabs.get(event.getIndex())).refreshTab(true);
                }
            }

            public void contentRemoved(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DockerDetailsTab tab2 = (DockerDetailsTab)myTabs.get(event.getIndex());
                Disposer.dispose((Disposable)tab2);
                if (event.getContent().isCloseable()) {
                    myTabs.remove((Object)tab2);
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ContentManager getContentManager() {
        return this.contentManager;
    }

    @RequiresEdt
    @NotNull
    public final JComponent getComponent() {
        Content selectedContent = this.contentManager.getSelectedContent();
        if (selectedContent == null) {
            DockerDetailsTab dockerDetailsTab = (DockerDetailsTab)CollectionsKt.firstOrNull((List)((List)this.myTabs));
            if (dockerDetailsTab != null) {
                DockerDetailsTab it = dockerDetailsTab;
                boolean bl = false;
                this.contentManager.setSelectedContent(it.getContent());
            }
        }
        JComponent jComponent = this.contentManager.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @RequiresEdt
    public final void selectContent(@NotNull Content content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.contentManager.setSelectedContent(content2, true);
    }

    @NotNull
    public final List<DockerDetailsTab<?>> getTabs() {
        return CollectionsKt.toList((Iterable)((Iterable)this.myTabs));
    }

    @NotNull
    public final DockerTabManager withHelpTopicId(@NonNls @Nullable String topicId) {
        if (topicId != null) {
            this.contentManager.addDataProvider((DataProvider)((EdtNoGetDataProvider)arg_0 -> DockerTabManager.withHelpTopicId$lambda$1(topicId, arg_0)));
        }
        return this;
    }

    @RequiresEdt
    private final void insertTabContent(DockerDetailsTab<?> tab2) {
        int n;
        DockerDetailsTab dockerDetailsTab;
        if (this.myIsDisposed) {
            return;
        }
        Iterable $this$takeWhile$iv = (Iterable)this.myTabs;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            DockerDetailsTab it = (DockerDetailsTab)item$iv;
            boolean bl = false;
            if (!(it != tab2)) break;
            list$iv.add(item$iv);
        }
        if ((dockerDetailsTab = (DockerDetailsTab)CollectionsKt.lastOrNull((List)list$iv)) != null && (dockerDetailsTab = dockerDetailsTab.getContent()) != null) {
            DockerDetailsTab it = dockerDetailsTab;
            boolean bl = false;
            n = this.contentManager.getIndexOfContent((Content)it);
        } else {
            n = -1;
        }
        int anchorIndex = n;
        this.contentManager.addContent(tab2.getContent(), anchorIndex + 1);
    }

    @RequiresEdt
    public final void addTab(@NotNull DockerDetailsTab<?> tab2) {
        Intrinsics.checkNotNullParameter(tab2, (String)"tab");
        if (this.myIsDisposed) {
            return;
        }
        if (tab2.getPreferredPosition() != null) {
            int tabPosition = tab2.getPreferredPosition() < 0 ? 0 : (tab2.getPreferredPosition() > this.myTabs.size() ? this.myTabs.size() : tab2.getPreferredPosition().intValue());
            this.myTabs.add(tabPosition, tab2);
        } else {
            this.myTabs.add(tab2);
        }
        this.insertTabContent(tab2);
        Container container = tab2.getContent().getComponent().getParent();
        TabbedPaneWrapper.TabWrapper tabWrapper = container instanceof TabbedPaneWrapper.TabWrapper ? (TabbedPaneWrapper.TabWrapper)container : null;
        if (tabWrapper != null) {
            Container it = container = tabWrapper;
            boolean bl = false;
            DockerUiUtilsKt.withoutBorder((JComponent)it);
            it.setMinimumSize(new Dimension(0, 0));
        }
        Disposer.register((Disposable)this, (Disposable)tab2);
    }

    @Nullable
    public final DockerDetailsTab<?> findTab(@NotNull Function1<? super DockerDetailsTab<?>, Boolean> condition) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Iterable iterable = (Iterable)this.myTabs;
            for (Object t : iterable) {
                if (!((Boolean)condition.invoke(t)).booleanValue()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @RequiresEdt
    public final void refreshTabs() {
        if (this.myIsDisposed) {
            return;
        }
        Iterable $this$forEach$iv = (Iterable)this.myTabs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DockerDetailsTab it = (DockerDetailsTab)element$iv;
            boolean bl = false;
            it.refreshTab(it.isContentSelected());
        }
    }

    public void dispose() {
        this.myIsDisposed = true;
        this.myTabs.clear();
    }

    @RequiresEdt
    public final void selectTab(@NotNull String tabDisplayName) {
        Content contentByDisplayName;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)tabDisplayName, (String)"tabDisplayName");
            if (this.myIsDisposed) {
                return;
            }
            Iterable $this$firstOrNull$iv = (Iterable)this.myTabs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DockerDetailsTab it = (DockerDetailsTab)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTitle().get(), (Object)tabDisplayName)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        DockerDetailsTab dockerDetailsTab = v0;
        Object object = contentByDisplayName = dockerDetailsTab != null ? dockerDetailsTab.getContent() : null;
        if (contentByDisplayName != null) {
            this.contentManager.setSelectedContent(contentByDisplayName, true);
        }
    }

    private static final void withHelpTopicId$lambda$1(String $topicId, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"HELP_ID");
        sink.set(dataKey, (Object)$topicId);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/view/details/DockerTabManager$MyContentManager;", "Lcom/intellij/ui/content/impl/ContentManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "canCloseAllContents", "", "intellij.clouds.docker"})
    private static final class MyContentManager
    extends ContentManagerImpl {
        public MyContentManager(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(ServiceViewUIUtils.getServicesAlignedTabbedPaneContentUI(), true, project);
        }

        public boolean canCloseAllContents() {
            return false;
        }
    }
}

