/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxMessageDecoder;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxVm;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.debugger.StandaloneVmHelper;
import org.jetbrains.debugger.Vm;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.MessageProcessor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/firefox/StandaloneFirefoxVm;", "Lcom/jetbrains/firefox/FirefoxVm;", "Lorg/jetbrains/debugger/StandaloneVmHelper$VmEx;", "tabListener", "Lorg/jetbrains/debugger/DebugEventListener;", "channel", "Lio/netty/channel/Channel;", "debugMessageQueue", "Lorg/jetbrains/debugger/MessagingLogger;", "<init>", "(Lorg/jetbrains/debugger/DebugEventListener;Lio/netty/channel/Channel;Lorg/jetbrains/debugger/MessagingLogger;)V", "vmHelper", "Lorg/jetbrains/debugger/StandaloneVmHelper;", "attachStateManager", "getAttachStateManager", "()Lorg/jetbrains/debugger/StandaloneVmHelper;", "writeMessage", "", "content", "Lio/netty/buffer/ByteBuf;", "createDisconnectRequest", "Lcom/jetbrains/firefox/FirefoxRequest;", "Ljava/lang/Void;", "intellij.javascript.firefox.connector"})
public final class StandaloneFirefoxVm
extends FirefoxVm
implements StandaloneVmHelper.VmEx {
    @Nullable
    private final MessagingLogger debugMessageQueue;
    @NotNull
    private final StandaloneVmHelper vmHelper;
    @NotNull
    private final StandaloneVmHelper attachStateManager;

    public StandaloneFirefoxVm(@NotNull DebugEventListener tabListener, @NotNull Channel channel, @Nullable MessagingLogger debugMessageQueue) {
        Intrinsics.checkNotNullParameter((Object)tabListener, (String)"tabListener");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(tabListener);
        this.debugMessageQueue = debugMessageQueue;
        this.attachStateManager = this.vmHelper = new StandaloneVmHelper((Vm)this, (MessageProcessor)this.getCommandProcessor(), channel);
        MessagingLogger messagingLogger = this.debugMessageQueue;
        if (messagingLogger != null) {
            messagingLogger.closeOnChannelClose(channel);
        }
        ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new FirefoxMessageDecoder(){

            @Override
            protected void processMessage(CharSequence response, ChannelHandlerContext context) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                try {
                    MessagingLogger messagingLogger = debugMessageQueue;
                    if (messagingLogger != null) {
                        messagingLogger.add(response, "IN");
                    }
                    this.getCommandProcessor().processIncomingJson(new JsonReaderEx(response));
                }
                catch (Exception e) {
                    CommandProcessorKt.getLOG().error((Throwable)e);
                }
            }
        }, ChannelExceptionHandler.getInstance()};
        channel.pipeline().addLast(channelHandlerArray);
    }

    public /* synthetic */ StandaloneFirefoxVm(DebugEventListener debugEventListener, Channel channel, MessagingLogger messagingLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            messagingLogger = null;
        }
        this(debugEventListener, channel, messagingLogger);
    }

    @NotNull
    public StandaloneVmHelper getAttachStateManager() {
        return this.attachStateManager;
    }

    @Override
    protected boolean writeMessage(@NotNull ByteBuf content) {
        Channel channel;
        block0: {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            channel = this.vmHelper.getChannelIfActive();
            MessagingLogger messagingLogger = this.debugMessageQueue;
            if (messagingLogger == null) break block0;
            messagingLogger.add(content, "OUT");
        }
        return channel != null && !FirefoxCommandProcessor.Companion.write(content, channel).isCancelled();
    }

    @Nullable
    public FirefoxRequest<Void> createDisconnectRequest() {
        FirefoxRequest<Void> firefoxRequest;
        if (this.getTabActor() == null) {
            firefoxRequest = null;
        } else {
            String string = this.getTabActor();
            Intrinsics.checkNotNull((Object)string);
            firefoxRequest = FirefoxRequest.Companion.detach(string);
        }
        return firefoxRequest;
    }
}

