// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafka

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchAssociateScramSecret = "BatchAssociateScramSecret"

// BatchAssociateScramSecretRequest generates a "aws/request.Request" representing the
// client's request for the BatchAssociateScramSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchAssociateScramSecret for more information on using the BatchAssociateScramSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchAssociateScramSecretRequest method.
//	req, resp := client.BatchAssociateScramSecretRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchAssociateScramSecret
func (c *Kafka) BatchAssociateScramSecretRequest(input *BatchAssociateScramSecretInput) (req *request.Request, output *BatchAssociateScramSecretOutput) {
	op := &request.Operation{
		Name:       opBatchAssociateScramSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/clusters/{clusterArn}/scram-secrets",
	}

	if input == nil {
		input = &BatchAssociateScramSecretInput{}
	}

	output = &BatchAssociateScramSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchAssociateScramSecret API operation for Managed Streaming for Kafka.
//
// Associates one or more Scram Secrets with an Amazon MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation BatchAssociateScramSecret for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchAssociateScramSecret
func (c *Kafka) BatchAssociateScramSecret(input *BatchAssociateScramSecretInput) (*BatchAssociateScramSecretOutput, error) {
	req, out := c.BatchAssociateScramSecretRequest(input)
	return out, req.Send()
}

// BatchAssociateScramSecretWithContext is the same as BatchAssociateScramSecret with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAssociateScramSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) BatchAssociateScramSecretWithContext(ctx aws.Context, input *BatchAssociateScramSecretInput, opts ...request.Option) (*BatchAssociateScramSecretOutput, error) {
	req, out := c.BatchAssociateScramSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisassociateScramSecret = "BatchDisassociateScramSecret"

// BatchDisassociateScramSecretRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisassociateScramSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisassociateScramSecret for more information on using the BatchDisassociateScramSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDisassociateScramSecretRequest method.
//	req, resp := client.BatchDisassociateScramSecretRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchDisassociateScramSecret
func (c *Kafka) BatchDisassociateScramSecretRequest(input *BatchDisassociateScramSecretInput) (req *request.Request, output *BatchDisassociateScramSecretOutput) {
	op := &request.Operation{
		Name:       opBatchDisassociateScramSecret,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v1/clusters/{clusterArn}/scram-secrets",
	}

	if input == nil {
		input = &BatchDisassociateScramSecretInput{}
	}

	output = &BatchDisassociateScramSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisassociateScramSecret API operation for Managed Streaming for Kafka.
//
// Disassociates one or more Scram Secrets from an Amazon MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation BatchDisassociateScramSecret for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchDisassociateScramSecret
func (c *Kafka) BatchDisassociateScramSecret(input *BatchDisassociateScramSecretInput) (*BatchDisassociateScramSecretOutput, error) {
	req, out := c.BatchDisassociateScramSecretRequest(input)
	return out, req.Send()
}

// BatchDisassociateScramSecretWithContext is the same as BatchDisassociateScramSecret with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisassociateScramSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) BatchDisassociateScramSecretWithContext(ctx aws.Context, input *BatchDisassociateScramSecretInput, opts ...request.Option) (*BatchDisassociateScramSecretOutput, error) {
	req, out := c.BatchDisassociateScramSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClusterRequest method.
//	req, resp := client.CreateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateCluster
func (c *Kafka) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/clusters",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Managed Streaming for Kafka.
//
// Creates a new MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
//   - ConflictException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateCluster
func (c *Kafka) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClusterV2 = "CreateClusterV2"

// CreateClusterV2Request generates a "aws/request.Request" representing the
// client's request for the CreateClusterV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClusterV2 for more information on using the CreateClusterV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClusterV2Request method.
//	req, resp := client.CreateClusterV2Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateClusterV2
func (c *Kafka) CreateClusterV2Request(input *CreateClusterV2Input) (req *request.Request, output *CreateClusterV2Output) {
	op := &request.Operation{
		Name:       opCreateClusterV2,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v2/clusters",
	}

	if input == nil {
		input = &CreateClusterV2Input{}
	}

	output = &CreateClusterV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClusterV2 API operation for Managed Streaming for Kafka.
//
// Creates a new Amazon MSK cluster of either the provisioned or the serverless
// type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation CreateClusterV2 for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
//   - ConflictException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateClusterV2
func (c *Kafka) CreateClusterV2(input *CreateClusterV2Input) (*CreateClusterV2Output, error) {
	req, out := c.CreateClusterV2Request(input)
	return out, req.Send()
}

// CreateClusterV2WithContext is the same as CreateClusterV2 with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClusterV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) CreateClusterV2WithContext(ctx aws.Context, input *CreateClusterV2Input, opts ...request.Option) (*CreateClusterV2Output, error) {
	req, out := c.CreateClusterV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfiguration = "CreateConfiguration"

// CreateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfiguration for more information on using the CreateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConfigurationRequest method.
//	req, resp := client.CreateConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfiguration
func (c *Kafka) CreateConfigurationRequest(input *CreateConfigurationInput) (req *request.Request, output *CreateConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/configurations",
	}

	if input == nil {
		input = &CreateConfigurationInput{}
	}

	output = &CreateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfiguration API operation for Managed Streaming for Kafka.
//
// Creates a new MSK configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation CreateConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
//   - ConflictException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfiguration
func (c *Kafka) CreateConfiguration(input *CreateConfigurationInput) (*CreateConfigurationOutput, error) {
	req, out := c.CreateConfigurationRequest(input)
	return out, req.Send()
}

// CreateConfigurationWithContext is the same as CreateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) CreateConfigurationWithContext(ctx aws.Context, input *CreateConfigurationInput, opts ...request.Option) (*CreateConfigurationOutput, error) {
	req, out := c.CreateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcConnection = "CreateVpcConnection"

// CreateVpcConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcConnection for more information on using the CreateVpcConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpcConnectionRequest method.
//	req, resp := client.CreateVpcConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateVpcConnection
func (c *Kafka) CreateVpcConnectionRequest(input *CreateVpcConnectionInput) (req *request.Request, output *CreateVpcConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpcConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/vpc-connection",
	}

	if input == nil {
		input = &CreateVpcConnectionInput{}
	}

	output = &CreateVpcConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcConnection API operation for Managed Streaming for Kafka.
//
// Creates a new Amazon MSK VPC connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation CreateVpcConnection for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
//   - ConflictException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateVpcConnection
func (c *Kafka) CreateVpcConnection(input *CreateVpcConnectionInput) (*CreateVpcConnectionOutput, error) {
	req, out := c.CreateVpcConnectionRequest(input)
	return out, req.Send()
}

// CreateVpcConnectionWithContext is the same as CreateVpcConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) CreateVpcConnectionWithContext(ctx aws.Context, input *CreateVpcConnectionInput, opts ...request.Option) (*CreateVpcConnectionOutput, error) {
	req, out := c.CreateVpcConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClusterRequest method.
//	req, resp := client.DeleteClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster
func (c *Kafka) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/clusters/{clusterArn}",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Managed Streaming for Kafka.
//
// Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster
func (c *Kafka) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClusterPolicy = "DeleteClusterPolicy"

// DeleteClusterPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClusterPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClusterPolicy for more information on using the DeleteClusterPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClusterPolicyRequest method.
//	req, resp := client.DeleteClusterPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteClusterPolicy
func (c *Kafka) DeleteClusterPolicyRequest(input *DeleteClusterPolicyInput) (req *request.Request, output *DeleteClusterPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/clusters/{clusterArn}/policy",
	}

	if input == nil {
		input = &DeleteClusterPolicyInput{}
	}

	output = &DeleteClusterPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteClusterPolicy API operation for Managed Streaming for Kafka.
//
// Deletes the MSK cluster policy specified by the Amazon Resource Name (ARN)
// in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DeleteClusterPolicy for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteClusterPolicy
func (c *Kafka) DeleteClusterPolicy(input *DeleteClusterPolicyInput) (*DeleteClusterPolicyOutput, error) {
	req, out := c.DeleteClusterPolicyRequest(input)
	return out, req.Send()
}

// DeleteClusterPolicyWithContext is the same as DeleteClusterPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClusterPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DeleteClusterPolicyWithContext(ctx aws.Context, input *DeleteClusterPolicyInput, opts ...request.Option) (*DeleteClusterPolicyOutput, error) {
	req, out := c.DeleteClusterPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfiguration = "DeleteConfiguration"

// DeleteConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfiguration for more information on using the DeleteConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfigurationRequest method.
//	req, resp := client.DeleteConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteConfiguration
func (c *Kafka) DeleteConfigurationRequest(input *DeleteConfigurationInput) (req *request.Request, output *DeleteConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/configurations/{arn}",
	}

	if input == nil {
		input = &DeleteConfigurationInput{}
	}

	output = &DeleteConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConfiguration API operation for Managed Streaming for Kafka.
//
// Deletes the specified MSK configuration. The configuration must be in the
// ACTIVE or DELETE_FAILED state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DeleteConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteConfiguration
func (c *Kafka) DeleteConfiguration(input *DeleteConfigurationInput) (*DeleteConfigurationOutput, error) {
	req, out := c.DeleteConfigurationRequest(input)
	return out, req.Send()
}

// DeleteConfigurationWithContext is the same as DeleteConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DeleteConfigurationWithContext(ctx aws.Context, input *DeleteConfigurationInput, opts ...request.Option) (*DeleteConfigurationOutput, error) {
	req, out := c.DeleteConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcConnection = "DeleteVpcConnection"

// DeleteVpcConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcConnection for more information on using the DeleteVpcConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpcConnectionRequest method.
//	req, resp := client.DeleteVpcConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteVpcConnection
func (c *Kafka) DeleteVpcConnectionRequest(input *DeleteVpcConnectionInput) (req *request.Request, output *DeleteVpcConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/vpc-connection/{arn}",
	}

	if input == nil {
		input = &DeleteVpcConnectionInput{}
	}

	output = &DeleteVpcConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcConnection API operation for Managed Streaming for Kafka.
//
// Deletes the Amazon MSK VPC connection specified in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DeleteVpcConnection for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteVpcConnection
func (c *Kafka) DeleteVpcConnection(input *DeleteVpcConnectionInput) (*DeleteVpcConnectionOutput, error) {
	req, out := c.DeleteVpcConnectionRequest(input)
	return out, req.Send()
}

// DeleteVpcConnectionWithContext is the same as DeleteVpcConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DeleteVpcConnectionWithContext(ctx aws.Context, input *DeleteVpcConnectionInput, opts ...request.Option) (*DeleteVpcConnectionOutput, error) {
	req, out := c.DeleteVpcConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCluster for more information on using the DescribeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClusterRequest method.
//	req, resp := client.DescribeClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeCluster
func (c *Kafka) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	output = &DescribeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCluster API operation for Managed Streaming for Kafka.
//
// Returns a description of the MSK cluster whose Amazon Resource Name (ARN)
// is specified in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeCluster
func (c *Kafka) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	return out, req.Send()
}

// DescribeClusterWithContext is the same as DescribeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeClusterWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.Option) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClusterOperation = "DescribeClusterOperation"

// DescribeClusterOperationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterOperation for more information on using the DescribeClusterOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClusterOperationRequest method.
//	req, resp := client.DescribeClusterOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperation
func (c *Kafka) DescribeClusterOperationRequest(input *DescribeClusterOperationInput) (req *request.Request, output *DescribeClusterOperationOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterOperation,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/operations/{clusterOperationArn}",
	}

	if input == nil {
		input = &DescribeClusterOperationInput{}
	}

	output = &DescribeClusterOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterOperation API operation for Managed Streaming for Kafka.
//
// Returns a description of the cluster operation specified by the ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeClusterOperation for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperation
func (c *Kafka) DescribeClusterOperation(input *DescribeClusterOperationInput) (*DescribeClusterOperationOutput, error) {
	req, out := c.DescribeClusterOperationRequest(input)
	return out, req.Send()
}

// DescribeClusterOperationWithContext is the same as DescribeClusterOperation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeClusterOperationWithContext(ctx aws.Context, input *DescribeClusterOperationInput, opts ...request.Option) (*DescribeClusterOperationOutput, error) {
	req, out := c.DescribeClusterOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClusterOperationV2 = "DescribeClusterOperationV2"

// DescribeClusterOperationV2Request generates a "aws/request.Request" representing the
// client's request for the DescribeClusterOperationV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterOperationV2 for more information on using the DescribeClusterOperationV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClusterOperationV2Request method.
//	req, resp := client.DescribeClusterOperationV2Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperationV2
func (c *Kafka) DescribeClusterOperationV2Request(input *DescribeClusterOperationV2Input) (req *request.Request, output *DescribeClusterOperationV2Output) {
	op := &request.Operation{
		Name:       opDescribeClusterOperationV2,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v2/operations/{clusterOperationArn}",
	}

	if input == nil {
		input = &DescribeClusterOperationV2Input{}
	}

	output = &DescribeClusterOperationV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterOperationV2 API operation for Managed Streaming for Kafka.
//
// Returns a description of the cluster operation specified by the ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeClusterOperationV2 for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperationV2
func (c *Kafka) DescribeClusterOperationV2(input *DescribeClusterOperationV2Input) (*DescribeClusterOperationV2Output, error) {
	req, out := c.DescribeClusterOperationV2Request(input)
	return out, req.Send()
}

// DescribeClusterOperationV2WithContext is the same as DescribeClusterOperationV2 with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterOperationV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeClusterOperationV2WithContext(ctx aws.Context, input *DescribeClusterOperationV2Input, opts ...request.Option) (*DescribeClusterOperationV2Output, error) {
	req, out := c.DescribeClusterOperationV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClusterV2 = "DescribeClusterV2"

// DescribeClusterV2Request generates a "aws/request.Request" representing the
// client's request for the DescribeClusterV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterV2 for more information on using the DescribeClusterV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClusterV2Request method.
//	req, resp := client.DescribeClusterV2Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterV2
func (c *Kafka) DescribeClusterV2Request(input *DescribeClusterV2Input) (req *request.Request, output *DescribeClusterV2Output) {
	op := &request.Operation{
		Name:       opDescribeClusterV2,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v2/clusters/{clusterArn}",
	}

	if input == nil {
		input = &DescribeClusterV2Input{}
	}

	output = &DescribeClusterV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterV2 API operation for Managed Streaming for Kafka.
//
// Returns a description of the MSK cluster of either the provisioned or the
// serverless type whose Amazon Resource Name (ARN) is specified in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeClusterV2 for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterV2
func (c *Kafka) DescribeClusterV2(input *DescribeClusterV2Input) (*DescribeClusterV2Output, error) {
	req, out := c.DescribeClusterV2Request(input)
	return out, req.Send()
}

// DescribeClusterV2WithContext is the same as DescribeClusterV2 with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeClusterV2WithContext(ctx aws.Context, input *DescribeClusterV2Input, opts ...request.Option) (*DescribeClusterV2Output, error) {
	req, out := c.DescribeClusterV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfiguration = "DescribeConfiguration"

// DescribeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfiguration for more information on using the DescribeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeConfigurationRequest method.
//	req, resp := client.DescribeConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfiguration
func (c *Kafka) DescribeConfigurationRequest(input *DescribeConfigurationInput) (req *request.Request, output *DescribeConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{arn}",
	}

	if input == nil {
		input = &DescribeConfigurationInput{}
	}

	output = &DescribeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfiguration API operation for Managed Streaming for Kafka.
//
// Returns a description of this MSK configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfiguration
func (c *Kafka) DescribeConfiguration(input *DescribeConfigurationInput) (*DescribeConfigurationOutput, error) {
	req, out := c.DescribeConfigurationRequest(input)
	return out, req.Send()
}

// DescribeConfigurationWithContext is the same as DescribeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeConfigurationWithContext(ctx aws.Context, input *DescribeConfigurationInput, opts ...request.Option) (*DescribeConfigurationOutput, error) {
	req, out := c.DescribeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationRevision = "DescribeConfigurationRevision"

// DescribeConfigurationRevisionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationRevision for more information on using the DescribeConfigurationRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeConfigurationRevisionRequest method.
//	req, resp := client.DescribeConfigurationRevisionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfigurationRevision
func (c *Kafka) DescribeConfigurationRevisionRequest(input *DescribeConfigurationRevisionInput) (req *request.Request, output *DescribeConfigurationRevisionOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationRevision,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{arn}/revisions/{revision}",
	}

	if input == nil {
		input = &DescribeConfigurationRevisionInput{}
	}

	output = &DescribeConfigurationRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationRevision API operation for Managed Streaming for Kafka.
//
// Returns a description of this revision of the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeConfigurationRevision for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfigurationRevision
func (c *Kafka) DescribeConfigurationRevision(input *DescribeConfigurationRevisionInput) (*DescribeConfigurationRevisionOutput, error) {
	req, out := c.DescribeConfigurationRevisionRequest(input)
	return out, req.Send()
}

// DescribeConfigurationRevisionWithContext is the same as DescribeConfigurationRevision with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeConfigurationRevisionWithContext(ctx aws.Context, input *DescribeConfigurationRevisionInput, opts ...request.Option) (*DescribeConfigurationRevisionOutput, error) {
	req, out := c.DescribeConfigurationRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVpcConnection = "DescribeVpcConnection"

// DescribeVpcConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVpcConnection for more information on using the DescribeVpcConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVpcConnectionRequest method.
//	req, resp := client.DescribeVpcConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeVpcConnection
func (c *Kafka) DescribeVpcConnectionRequest(input *DescribeVpcConnectionInput) (req *request.Request, output *DescribeVpcConnectionOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcConnection,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/vpc-connection/{arn}",
	}

	if input == nil {
		input = &DescribeVpcConnectionInput{}
	}

	output = &DescribeVpcConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcConnection API operation for Managed Streaming for Kafka.
//
// Displays information about the specified Amazon MSK VPC connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeVpcConnection for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeVpcConnection
func (c *Kafka) DescribeVpcConnection(input *DescribeVpcConnectionInput) (*DescribeVpcConnectionOutput, error) {
	req, out := c.DescribeVpcConnectionRequest(input)
	return out, req.Send()
}

// DescribeVpcConnectionWithContext is the same as DescribeVpcConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVpcConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeVpcConnectionWithContext(ctx aws.Context, input *DescribeVpcConnectionInput, opts ...request.Option) (*DescribeVpcConnectionOutput, error) {
	req, out := c.DescribeVpcConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBootstrapBrokers = "GetBootstrapBrokers"

// GetBootstrapBrokersRequest generates a "aws/request.Request" representing the
// client's request for the GetBootstrapBrokers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBootstrapBrokers for more information on using the GetBootstrapBrokers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBootstrapBrokersRequest method.
//	req, resp := client.GetBootstrapBrokersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetBootstrapBrokers
func (c *Kafka) GetBootstrapBrokersRequest(input *GetBootstrapBrokersInput) (req *request.Request, output *GetBootstrapBrokersOutput) {
	op := &request.Operation{
		Name:       opGetBootstrapBrokers,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/bootstrap-brokers",
	}

	if input == nil {
		input = &GetBootstrapBrokersInput{}
	}

	output = &GetBootstrapBrokersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBootstrapBrokers API operation for Managed Streaming for Kafka.
//
// A list of brokers that a client application can use to bootstrap.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation GetBootstrapBrokers for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ConflictException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetBootstrapBrokers
func (c *Kafka) GetBootstrapBrokers(input *GetBootstrapBrokersInput) (*GetBootstrapBrokersOutput, error) {
	req, out := c.GetBootstrapBrokersRequest(input)
	return out, req.Send()
}

// GetBootstrapBrokersWithContext is the same as GetBootstrapBrokers with the addition of
// the ability to pass a context and additional request options.
//
// See GetBootstrapBrokers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) GetBootstrapBrokersWithContext(ctx aws.Context, input *GetBootstrapBrokersInput, opts ...request.Option) (*GetBootstrapBrokersOutput, error) {
	req, out := c.GetBootstrapBrokersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetClusterPolicy = "GetClusterPolicy"

// GetClusterPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetClusterPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetClusterPolicy for more information on using the GetClusterPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetClusterPolicyRequest method.
//	req, resp := client.GetClusterPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetClusterPolicy
func (c *Kafka) GetClusterPolicyRequest(input *GetClusterPolicyInput) (req *request.Request, output *GetClusterPolicyOutput) {
	op := &request.Operation{
		Name:       opGetClusterPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/policy",
	}

	if input == nil {
		input = &GetClusterPolicyInput{}
	}

	output = &GetClusterPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetClusterPolicy API operation for Managed Streaming for Kafka.
//
// Retrieves the contents of the specified MSK cluster policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation GetClusterPolicy for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetClusterPolicy
func (c *Kafka) GetClusterPolicy(input *GetClusterPolicyInput) (*GetClusterPolicyOutput, error) {
	req, out := c.GetClusterPolicyRequest(input)
	return out, req.Send()
}

// GetClusterPolicyWithContext is the same as GetClusterPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetClusterPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) GetClusterPolicyWithContext(ctx aws.Context, input *GetClusterPolicyInput, opts ...request.Option) (*GetClusterPolicyOutput, error) {
	req, out := c.GetClusterPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCompatibleKafkaVersions = "GetCompatibleKafkaVersions"

// GetCompatibleKafkaVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetCompatibleKafkaVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCompatibleKafkaVersions for more information on using the GetCompatibleKafkaVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCompatibleKafkaVersionsRequest method.
//	req, resp := client.GetCompatibleKafkaVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetCompatibleKafkaVersions
func (c *Kafka) GetCompatibleKafkaVersionsRequest(input *GetCompatibleKafkaVersionsInput) (req *request.Request, output *GetCompatibleKafkaVersionsOutput) {
	op := &request.Operation{
		Name:       opGetCompatibleKafkaVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/compatible-kafka-versions",
	}

	if input == nil {
		input = &GetCompatibleKafkaVersionsInput{}
	}

	output = &GetCompatibleKafkaVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCompatibleKafkaVersions API operation for Managed Streaming for Kafka.
//
// Gets the Apache Kafka versions to which you can update the MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation GetCompatibleKafkaVersions for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetCompatibleKafkaVersions
func (c *Kafka) GetCompatibleKafkaVersions(input *GetCompatibleKafkaVersionsInput) (*GetCompatibleKafkaVersionsOutput, error) {
	req, out := c.GetCompatibleKafkaVersionsRequest(input)
	return out, req.Send()
}

// GetCompatibleKafkaVersionsWithContext is the same as GetCompatibleKafkaVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetCompatibleKafkaVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) GetCompatibleKafkaVersionsWithContext(ctx aws.Context, input *GetCompatibleKafkaVersionsInput, opts ...request.Option) (*GetCompatibleKafkaVersionsOutput, error) {
	req, out := c.GetCompatibleKafkaVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClientVpcConnections = "ListClientVpcConnections"

// ListClientVpcConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListClientVpcConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClientVpcConnections for more information on using the ListClientVpcConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClientVpcConnectionsRequest method.
//	req, resp := client.ListClientVpcConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClientVpcConnections
func (c *Kafka) ListClientVpcConnectionsRequest(input *ListClientVpcConnectionsInput) (req *request.Request, output *ListClientVpcConnectionsOutput) {
	op := &request.Operation{
		Name:       opListClientVpcConnections,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/client-vpc-connections",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClientVpcConnectionsInput{}
	}

	output = &ListClientVpcConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClientVpcConnections API operation for Managed Streaming for Kafka.
//
// Displays a list of client VPC connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListClientVpcConnections for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClientVpcConnections
func (c *Kafka) ListClientVpcConnections(input *ListClientVpcConnectionsInput) (*ListClientVpcConnectionsOutput, error) {
	req, out := c.ListClientVpcConnectionsRequest(input)
	return out, req.Send()
}

// ListClientVpcConnectionsWithContext is the same as ListClientVpcConnections with the addition of
// the ability to pass a context and additional request options.
//
// See ListClientVpcConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClientVpcConnectionsWithContext(ctx aws.Context, input *ListClientVpcConnectionsInput, opts ...request.Option) (*ListClientVpcConnectionsOutput, error) {
	req, out := c.ListClientVpcConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClientVpcConnectionsPages iterates over the pages of a ListClientVpcConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClientVpcConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClientVpcConnections operation.
//	pageNum := 0
//	err := client.ListClientVpcConnectionsPages(params,
//	    func(page *kafka.ListClientVpcConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListClientVpcConnectionsPages(input *ListClientVpcConnectionsInput, fn func(*ListClientVpcConnectionsOutput, bool) bool) error {
	return c.ListClientVpcConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClientVpcConnectionsPagesWithContext same as ListClientVpcConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClientVpcConnectionsPagesWithContext(ctx aws.Context, input *ListClientVpcConnectionsInput, fn func(*ListClientVpcConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClientVpcConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClientVpcConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClientVpcConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusterOperations = "ListClusterOperations"

// ListClusterOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListClusterOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusterOperations for more information on using the ListClusterOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClusterOperationsRequest method.
//	req, resp := client.ListClusterOperationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations
func (c *Kafka) ListClusterOperationsRequest(input *ListClusterOperationsInput) (req *request.Request, output *ListClusterOperationsOutput) {
	op := &request.Operation{
		Name:       opListClusterOperations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/operations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClusterOperationsInput{}
	}

	output = &ListClusterOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusterOperations API operation for Managed Streaming for Kafka.
//
// Returns a list of all the operations that have been performed on the specified
// MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListClusterOperations for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations
func (c *Kafka) ListClusterOperations(input *ListClusterOperationsInput) (*ListClusterOperationsOutput, error) {
	req, out := c.ListClusterOperationsRequest(input)
	return out, req.Send()
}

// ListClusterOperationsWithContext is the same as ListClusterOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusterOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClusterOperationsWithContext(ctx aws.Context, input *ListClusterOperationsInput, opts ...request.Option) (*ListClusterOperationsOutput, error) {
	req, out := c.ListClusterOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClusterOperationsPages iterates over the pages of a ListClusterOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusterOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClusterOperations operation.
//	pageNum := 0
//	err := client.ListClusterOperationsPages(params,
//	    func(page *kafka.ListClusterOperationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListClusterOperationsPages(input *ListClusterOperationsInput, fn func(*ListClusterOperationsOutput, bool) bool) error {
	return c.ListClusterOperationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClusterOperationsPagesWithContext same as ListClusterOperationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClusterOperationsPagesWithContext(ctx aws.Context, input *ListClusterOperationsInput, fn func(*ListClusterOperationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClusterOperationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClusterOperationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClusterOperationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusterOperationsV2 = "ListClusterOperationsV2"

// ListClusterOperationsV2Request generates a "aws/request.Request" representing the
// client's request for the ListClusterOperationsV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusterOperationsV2 for more information on using the ListClusterOperationsV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClusterOperationsV2Request method.
//	req, resp := client.ListClusterOperationsV2Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperationsV2
func (c *Kafka) ListClusterOperationsV2Request(input *ListClusterOperationsV2Input) (req *request.Request, output *ListClusterOperationsV2Output) {
	op := &request.Operation{
		Name:       opListClusterOperationsV2,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v2/clusters/{clusterArn}/operations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClusterOperationsV2Input{}
	}

	output = &ListClusterOperationsV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusterOperationsV2 API operation for Managed Streaming for Kafka.
//
// Returns a list of all the operations that have been performed on the specified
// MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListClusterOperationsV2 for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperationsV2
func (c *Kafka) ListClusterOperationsV2(input *ListClusterOperationsV2Input) (*ListClusterOperationsV2Output, error) {
	req, out := c.ListClusterOperationsV2Request(input)
	return out, req.Send()
}

// ListClusterOperationsV2WithContext is the same as ListClusterOperationsV2 with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusterOperationsV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClusterOperationsV2WithContext(ctx aws.Context, input *ListClusterOperationsV2Input, opts ...request.Option) (*ListClusterOperationsV2Output, error) {
	req, out := c.ListClusterOperationsV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClusterOperationsV2Pages iterates over the pages of a ListClusterOperationsV2 operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusterOperationsV2 method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClusterOperationsV2 operation.
//	pageNum := 0
//	err := client.ListClusterOperationsV2Pages(params,
//	    func(page *kafka.ListClusterOperationsV2Output, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListClusterOperationsV2Pages(input *ListClusterOperationsV2Input, fn func(*ListClusterOperationsV2Output, bool) bool) error {
	return c.ListClusterOperationsV2PagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClusterOperationsV2PagesWithContext same as ListClusterOperationsV2Pages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClusterOperationsV2PagesWithContext(ctx aws.Context, input *ListClusterOperationsV2Input, fn func(*ListClusterOperationsV2Output, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClusterOperationsV2Input
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClusterOperationsV2Request(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClusterOperationsV2Output), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClustersRequest method.
//	req, resp := client.ListClustersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters
func (c *Kafka) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Managed Streaming for Kafka.
//
// Returns a list of all the MSK clusters in the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters
func (c *Kafka) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClusters operation.
//	pageNum := 0
//	err := client.ListClustersPages(params,
//	    func(page *kafka.ListClustersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListClustersPages(input *ListClustersInput, fn func(*ListClustersOutput, bool) bool) error {
	return c.ListClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersPagesWithContext same as ListClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClustersPagesWithContext(ctx aws.Context, input *ListClustersInput, fn func(*ListClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClustersV2 = "ListClustersV2"

// ListClustersV2Request generates a "aws/request.Request" representing the
// client's request for the ListClustersV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClustersV2 for more information on using the ListClustersV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClustersV2Request method.
//	req, resp := client.ListClustersV2Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClustersV2
func (c *Kafka) ListClustersV2Request(input *ListClustersV2Input) (req *request.Request, output *ListClustersV2Output) {
	op := &request.Operation{
		Name:       opListClustersV2,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v2/clusters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersV2Input{}
	}

	output = &ListClustersV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// ListClustersV2 API operation for Managed Streaming for Kafka.
//
// Returns a list of all the MSK clusters in the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListClustersV2 for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClustersV2
func (c *Kafka) ListClustersV2(input *ListClustersV2Input) (*ListClustersV2Output, error) {
	req, out := c.ListClustersV2Request(input)
	return out, req.Send()
}

// ListClustersV2WithContext is the same as ListClustersV2 with the addition of
// the ability to pass a context and additional request options.
//
// See ListClustersV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClustersV2WithContext(ctx aws.Context, input *ListClustersV2Input, opts ...request.Option) (*ListClustersV2Output, error) {
	req, out := c.ListClustersV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersV2Pages iterates over the pages of a ListClustersV2 operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClustersV2 method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClustersV2 operation.
//	pageNum := 0
//	err := client.ListClustersV2Pages(params,
//	    func(page *kafka.ListClustersV2Output, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListClustersV2Pages(input *ListClustersV2Input, fn func(*ListClustersV2Output, bool) bool) error {
	return c.ListClustersV2PagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersV2PagesWithContext same as ListClustersV2Pages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClustersV2PagesWithContext(ctx aws.Context, input *ListClustersV2Input, fn func(*ListClustersV2Output, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersV2Input
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersV2Request(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersV2Output), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfigurationRevisions = "ListConfigurationRevisions"

// ListConfigurationRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurationRevisions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurationRevisions for more information on using the ListConfigurationRevisions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConfigurationRevisionsRequest method.
//	req, resp := client.ListConfigurationRevisionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions
func (c *Kafka) ListConfigurationRevisionsRequest(input *ListConfigurationRevisionsInput) (req *request.Request, output *ListConfigurationRevisionsOutput) {
	op := &request.Operation{
		Name:       opListConfigurationRevisions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{arn}/revisions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigurationRevisionsInput{}
	}

	output = &ListConfigurationRevisionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurationRevisions API operation for Managed Streaming for Kafka.
//
// Returns a list of all the revisions of an MSK configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListConfigurationRevisions for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions
func (c *Kafka) ListConfigurationRevisions(input *ListConfigurationRevisionsInput) (*ListConfigurationRevisionsOutput, error) {
	req, out := c.ListConfigurationRevisionsRequest(input)
	return out, req.Send()
}

// ListConfigurationRevisionsWithContext is the same as ListConfigurationRevisions with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurationRevisions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListConfigurationRevisionsWithContext(ctx aws.Context, input *ListConfigurationRevisionsInput, opts ...request.Option) (*ListConfigurationRevisionsOutput, error) {
	req, out := c.ListConfigurationRevisionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfigurationRevisionsPages iterates over the pages of a ListConfigurationRevisions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfigurationRevisions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConfigurationRevisions operation.
//	pageNum := 0
//	err := client.ListConfigurationRevisionsPages(params,
//	    func(page *kafka.ListConfigurationRevisionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListConfigurationRevisionsPages(input *ListConfigurationRevisionsInput, fn func(*ListConfigurationRevisionsOutput, bool) bool) error {
	return c.ListConfigurationRevisionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfigurationRevisionsPagesWithContext same as ListConfigurationRevisionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListConfigurationRevisionsPagesWithContext(ctx aws.Context, input *ListConfigurationRevisionsInput, fn func(*ListConfigurationRevisionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfigurationRevisionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfigurationRevisionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfigurationRevisionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfigurations = "ListConfigurations"

// ListConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurations for more information on using the ListConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConfigurationsRequest method.
//	req, resp := client.ListConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations
func (c *Kafka) ListConfigurationsRequest(input *ListConfigurationsInput) (req *request.Request, output *ListConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigurationsInput{}
	}

	output = &ListConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurations API operation for Managed Streaming for Kafka.
//
// Returns a list of all the MSK configurations in this Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations
func (c *Kafka) ListConfigurations(input *ListConfigurationsInput) (*ListConfigurationsOutput, error) {
	req, out := c.ListConfigurationsRequest(input)
	return out, req.Send()
}

// ListConfigurationsWithContext is the same as ListConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListConfigurationsWithContext(ctx aws.Context, input *ListConfigurationsInput, opts ...request.Option) (*ListConfigurationsOutput, error) {
	req, out := c.ListConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfigurationsPages iterates over the pages of a ListConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConfigurations operation.
//	pageNum := 0
//	err := client.ListConfigurationsPages(params,
//	    func(page *kafka.ListConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListConfigurationsPages(input *ListConfigurationsInput, fn func(*ListConfigurationsOutput, bool) bool) error {
	return c.ListConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfigurationsPagesWithContext same as ListConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListConfigurationsPagesWithContext(ctx aws.Context, input *ListConfigurationsInput, fn func(*ListConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKafkaVersions = "ListKafkaVersions"

// ListKafkaVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListKafkaVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKafkaVersions for more information on using the ListKafkaVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKafkaVersionsRequest method.
//	req, resp := client.ListKafkaVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions
func (c *Kafka) ListKafkaVersionsRequest(input *ListKafkaVersionsInput) (req *request.Request, output *ListKafkaVersionsOutput) {
	op := &request.Operation{
		Name:       opListKafkaVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/kafka-versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKafkaVersionsInput{}
	}

	output = &ListKafkaVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKafkaVersions API operation for Managed Streaming for Kafka.
//
// Returns a list of Apache Kafka versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListKafkaVersions for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions
func (c *Kafka) ListKafkaVersions(input *ListKafkaVersionsInput) (*ListKafkaVersionsOutput, error) {
	req, out := c.ListKafkaVersionsRequest(input)
	return out, req.Send()
}

// ListKafkaVersionsWithContext is the same as ListKafkaVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListKafkaVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListKafkaVersionsWithContext(ctx aws.Context, input *ListKafkaVersionsInput, opts ...request.Option) (*ListKafkaVersionsOutput, error) {
	req, out := c.ListKafkaVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKafkaVersionsPages iterates over the pages of a ListKafkaVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKafkaVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKafkaVersions operation.
//	pageNum := 0
//	err := client.ListKafkaVersionsPages(params,
//	    func(page *kafka.ListKafkaVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListKafkaVersionsPages(input *ListKafkaVersionsInput, fn func(*ListKafkaVersionsOutput, bool) bool) error {
	return c.ListKafkaVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKafkaVersionsPagesWithContext same as ListKafkaVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListKafkaVersionsPagesWithContext(ctx aws.Context, input *ListKafkaVersionsInput, fn func(*ListKafkaVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKafkaVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKafkaVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKafkaVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNodes = "ListNodes"

// ListNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodes for more information on using the ListNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNodesRequest method.
//	req, resp := client.ListNodesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes
func (c *Kafka) ListNodesRequest(input *ListNodesInput) (req *request.Request, output *ListNodesOutput) {
	op := &request.Operation{
		Name:       opListNodes,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/nodes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNodesInput{}
	}

	output = &ListNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodes API operation for Managed Streaming for Kafka.
//
// Returns a list of the broker nodes in the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListNodes for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes
func (c *Kafka) ListNodes(input *ListNodesInput) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	return out, req.Send()
}

// ListNodesWithContext is the same as ListNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListNodesWithContext(ctx aws.Context, input *ListNodesInput, opts ...request.Option) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNodesPages iterates over the pages of a ListNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNodes operation.
//	pageNum := 0
//	err := client.ListNodesPages(params,
//	    func(page *kafka.ListNodesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListNodesPages(input *ListNodesInput, fn func(*ListNodesOutput, bool) bool) error {
	return c.ListNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNodesPagesWithContext same as ListNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListNodesPagesWithContext(ctx aws.Context, input *ListNodesInput, fn func(*ListNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListScramSecrets = "ListScramSecrets"

// ListScramSecretsRequest generates a "aws/request.Request" representing the
// client's request for the ListScramSecrets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListScramSecrets for more information on using the ListScramSecrets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListScramSecretsRequest method.
//	req, resp := client.ListScramSecretsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListScramSecrets
func (c *Kafka) ListScramSecretsRequest(input *ListScramSecretsInput) (req *request.Request, output *ListScramSecretsOutput) {
	op := &request.Operation{
		Name:       opListScramSecrets,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/scram-secrets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListScramSecretsInput{}
	}

	output = &ListScramSecretsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListScramSecrets API operation for Managed Streaming for Kafka.
//
// Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListScramSecrets for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListScramSecrets
func (c *Kafka) ListScramSecrets(input *ListScramSecretsInput) (*ListScramSecretsOutput, error) {
	req, out := c.ListScramSecretsRequest(input)
	return out, req.Send()
}

// ListScramSecretsWithContext is the same as ListScramSecrets with the addition of
// the ability to pass a context and additional request options.
//
// See ListScramSecrets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListScramSecretsWithContext(ctx aws.Context, input *ListScramSecretsInput, opts ...request.Option) (*ListScramSecretsOutput, error) {
	req, out := c.ListScramSecretsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListScramSecretsPages iterates over the pages of a ListScramSecrets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListScramSecrets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListScramSecrets operation.
//	pageNum := 0
//	err := client.ListScramSecretsPages(params,
//	    func(page *kafka.ListScramSecretsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListScramSecretsPages(input *ListScramSecretsInput, fn func(*ListScramSecretsOutput, bool) bool) error {
	return c.ListScramSecretsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListScramSecretsPagesWithContext same as ListScramSecretsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListScramSecretsPagesWithContext(ctx aws.Context, input *ListScramSecretsInput, fn func(*ListScramSecretsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListScramSecretsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListScramSecretsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListScramSecretsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListTagsForResource
func (c *Kafka) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Managed Streaming for Kafka.
//
// Returns a list of the tags associated with the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListTagsForResource
func (c *Kafka) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVpcConnections = "ListVpcConnections"

// ListVpcConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListVpcConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVpcConnections for more information on using the ListVpcConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVpcConnectionsRequest method.
//	req, resp := client.ListVpcConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListVpcConnections
func (c *Kafka) ListVpcConnectionsRequest(input *ListVpcConnectionsInput) (req *request.Request, output *ListVpcConnectionsOutput) {
	op := &request.Operation{
		Name:       opListVpcConnections,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/vpc-connections",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVpcConnectionsInput{}
	}

	output = &ListVpcConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVpcConnections API operation for Managed Streaming for Kafka.
//
// Displays a list of Amazon MSK VPC connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListVpcConnections for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListVpcConnections
func (c *Kafka) ListVpcConnections(input *ListVpcConnectionsInput) (*ListVpcConnectionsOutput, error) {
	req, out := c.ListVpcConnectionsRequest(input)
	return out, req.Send()
}

// ListVpcConnectionsWithContext is the same as ListVpcConnections with the addition of
// the ability to pass a context and additional request options.
//
// See ListVpcConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListVpcConnectionsWithContext(ctx aws.Context, input *ListVpcConnectionsInput, opts ...request.Option) (*ListVpcConnectionsOutput, error) {
	req, out := c.ListVpcConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVpcConnectionsPages iterates over the pages of a ListVpcConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVpcConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVpcConnections operation.
//	pageNum := 0
//	err := client.ListVpcConnectionsPages(params,
//	    func(page *kafka.ListVpcConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kafka) ListVpcConnectionsPages(input *ListVpcConnectionsInput, fn func(*ListVpcConnectionsOutput, bool) bool) error {
	return c.ListVpcConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVpcConnectionsPagesWithContext same as ListVpcConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListVpcConnectionsPagesWithContext(ctx aws.Context, input *ListVpcConnectionsInput, fn func(*ListVpcConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVpcConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVpcConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVpcConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutClusterPolicy = "PutClusterPolicy"

// PutClusterPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutClusterPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutClusterPolicy for more information on using the PutClusterPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutClusterPolicyRequest method.
//	req, resp := client.PutClusterPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/PutClusterPolicy
func (c *Kafka) PutClusterPolicyRequest(input *PutClusterPolicyInput) (req *request.Request, output *PutClusterPolicyOutput) {
	op := &request.Operation{
		Name:       opPutClusterPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/policy",
	}

	if input == nil {
		input = &PutClusterPolicyInput{}
	}

	output = &PutClusterPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutClusterPolicy API operation for Managed Streaming for Kafka.
//
// Creates or updates the specified MSK cluster policy. If updating the policy,
// the currentVersion field is required in the request payload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation PutClusterPolicy for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/PutClusterPolicy
func (c *Kafka) PutClusterPolicy(input *PutClusterPolicyInput) (*PutClusterPolicyOutput, error) {
	req, out := c.PutClusterPolicyRequest(input)
	return out, req.Send()
}

// PutClusterPolicyWithContext is the same as PutClusterPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutClusterPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) PutClusterPolicyWithContext(ctx aws.Context, input *PutClusterPolicyInput, opts ...request.Option) (*PutClusterPolicyOutput, error) {
	req, out := c.PutClusterPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootBroker = "RebootBroker"

// RebootBrokerRequest generates a "aws/request.Request" representing the
// client's request for the RebootBroker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootBroker for more information on using the RebootBroker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RebootBrokerRequest method.
//	req, resp := client.RebootBrokerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RebootBroker
func (c *Kafka) RebootBrokerRequest(input *RebootBrokerInput) (req *request.Request, output *RebootBrokerOutput) {
	op := &request.Operation{
		Name:       opRebootBroker,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/reboot-broker",
	}

	if input == nil {
		input = &RebootBrokerInput{}
	}

	output = &RebootBrokerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootBroker API operation for Managed Streaming for Kafka.
//
// Executes a reboot on a broker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation RebootBroker for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RebootBroker
func (c *Kafka) RebootBroker(input *RebootBrokerInput) (*RebootBrokerOutput, error) {
	req, out := c.RebootBrokerRequest(input)
	return out, req.Send()
}

// RebootBrokerWithContext is the same as RebootBroker with the addition of
// the ability to pass a context and additional request options.
//
// See RebootBroker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) RebootBrokerWithContext(ctx aws.Context, input *RebootBrokerInput, opts ...request.Option) (*RebootBrokerOutput, error) {
	req, out := c.RebootBrokerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectClientVpcConnection = "RejectClientVpcConnection"

// RejectClientVpcConnectionRequest generates a "aws/request.Request" representing the
// client's request for the RejectClientVpcConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectClientVpcConnection for more information on using the RejectClientVpcConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RejectClientVpcConnectionRequest method.
//	req, resp := client.RejectClientVpcConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RejectClientVpcConnection
func (c *Kafka) RejectClientVpcConnectionRequest(input *RejectClientVpcConnectionInput) (req *request.Request, output *RejectClientVpcConnectionOutput) {
	op := &request.Operation{
		Name:       opRejectClientVpcConnection,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/client-vpc-connection",
	}

	if input == nil {
		input = &RejectClientVpcConnectionInput{}
	}

	output = &RejectClientVpcConnectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectClientVpcConnection API operation for Managed Streaming for Kafka.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation RejectClientVpcConnection for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RejectClientVpcConnection
func (c *Kafka) RejectClientVpcConnection(input *RejectClientVpcConnectionInput) (*RejectClientVpcConnectionOutput, error) {
	req, out := c.RejectClientVpcConnectionRequest(input)
	return out, req.Send()
}

// RejectClientVpcConnectionWithContext is the same as RejectClientVpcConnection with the addition of
// the ability to pass a context and additional request options.
//
// See RejectClientVpcConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) RejectClientVpcConnectionWithContext(ctx aws.Context, input *RejectClientVpcConnectionInput, opts ...request.Option) (*RejectClientVpcConnectionOutput, error) {
	req, out := c.RejectClientVpcConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/TagResource
func (c *Kafka) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Managed Streaming for Kafka.
//
// Adds tags to the specified MSK resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/TagResource
func (c *Kafka) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UntagResource
func (c *Kafka) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Managed Streaming for Kafka.
//
// Removes the tags associated with the keys that are provided in the query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UntagResource
func (c *Kafka) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBrokerCount = "UpdateBrokerCount"

// UpdateBrokerCountRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBrokerCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBrokerCount for more information on using the UpdateBrokerCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBrokerCountRequest method.
//	req, resp := client.UpdateBrokerCountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerCount
func (c *Kafka) UpdateBrokerCountRequest(input *UpdateBrokerCountInput) (req *request.Request, output *UpdateBrokerCountOutput) {
	op := &request.Operation{
		Name:       opUpdateBrokerCount,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/nodes/count",
	}

	if input == nil {
		input = &UpdateBrokerCountInput{}
	}

	output = &UpdateBrokerCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBrokerCount API operation for Managed Streaming for Kafka.
//
// Updates the number of broker nodes in the cluster. You can use this operation
// to increase the number of brokers in an existing cluster. You can't decrease
// the number of brokers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateBrokerCount for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerCount
func (c *Kafka) UpdateBrokerCount(input *UpdateBrokerCountInput) (*UpdateBrokerCountOutput, error) {
	req, out := c.UpdateBrokerCountRequest(input)
	return out, req.Send()
}

// UpdateBrokerCountWithContext is the same as UpdateBrokerCount with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBrokerCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateBrokerCountWithContext(ctx aws.Context, input *UpdateBrokerCountInput, opts ...request.Option) (*UpdateBrokerCountOutput, error) {
	req, out := c.UpdateBrokerCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBrokerStorage = "UpdateBrokerStorage"

// UpdateBrokerStorageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBrokerStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBrokerStorage for more information on using the UpdateBrokerStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBrokerStorageRequest method.
//	req, resp := client.UpdateBrokerStorageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerStorage
func (c *Kafka) UpdateBrokerStorageRequest(input *UpdateBrokerStorageInput) (req *request.Request, output *UpdateBrokerStorageOutput) {
	op := &request.Operation{
		Name:       opUpdateBrokerStorage,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/nodes/storage",
	}

	if input == nil {
		input = &UpdateBrokerStorageInput{}
	}

	output = &UpdateBrokerStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBrokerStorage API operation for Managed Streaming for Kafka.
//
// Updates the EBS storage associated with MSK brokers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateBrokerStorage for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerStorage
func (c *Kafka) UpdateBrokerStorage(input *UpdateBrokerStorageInput) (*UpdateBrokerStorageOutput, error) {
	req, out := c.UpdateBrokerStorageRequest(input)
	return out, req.Send()
}

// UpdateBrokerStorageWithContext is the same as UpdateBrokerStorage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBrokerStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateBrokerStorageWithContext(ctx aws.Context, input *UpdateBrokerStorageInput, opts ...request.Option) (*UpdateBrokerStorageOutput, error) {
	req, out := c.UpdateBrokerStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBrokerType = "UpdateBrokerType"

// UpdateBrokerTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBrokerType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBrokerType for more information on using the UpdateBrokerType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBrokerTypeRequest method.
//	req, resp := client.UpdateBrokerTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerType
func (c *Kafka) UpdateBrokerTypeRequest(input *UpdateBrokerTypeInput) (req *request.Request, output *UpdateBrokerTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateBrokerType,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/nodes/type",
	}

	if input == nil {
		input = &UpdateBrokerTypeInput{}
	}

	output = &UpdateBrokerTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBrokerType API operation for Managed Streaming for Kafka.
//
// Updates all the brokers in the cluster to the specified type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateBrokerType for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerType
func (c *Kafka) UpdateBrokerType(input *UpdateBrokerTypeInput) (*UpdateBrokerTypeOutput, error) {
	req, out := c.UpdateBrokerTypeRequest(input)
	return out, req.Send()
}

// UpdateBrokerTypeWithContext is the same as UpdateBrokerType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBrokerType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateBrokerTypeWithContext(ctx aws.Context, input *UpdateBrokerTypeInput, opts ...request.Option) (*UpdateBrokerTypeOutput, error) {
	req, out := c.UpdateBrokerTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterConfiguration = "UpdateClusterConfiguration"

// UpdateClusterConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterConfiguration for more information on using the UpdateClusterConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateClusterConfigurationRequest method.
//	req, resp := client.UpdateClusterConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterConfiguration
func (c *Kafka) UpdateClusterConfigurationRequest(input *UpdateClusterConfigurationInput) (req *request.Request, output *UpdateClusterConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/configuration",
	}

	if input == nil {
		input = &UpdateClusterConfigurationInput{}
	}

	output = &UpdateClusterConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterConfiguration API operation for Managed Streaming for Kafka.
//
// Updates the cluster with the configuration that is specified in the request
// body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateClusterConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterConfiguration
func (c *Kafka) UpdateClusterConfiguration(input *UpdateClusterConfigurationInput) (*UpdateClusterConfigurationOutput, error) {
	req, out := c.UpdateClusterConfigurationRequest(input)
	return out, req.Send()
}

// UpdateClusterConfigurationWithContext is the same as UpdateClusterConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateClusterConfigurationWithContext(ctx aws.Context, input *UpdateClusterConfigurationInput, opts ...request.Option) (*UpdateClusterConfigurationOutput, error) {
	req, out := c.UpdateClusterConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterKafkaVersion = "UpdateClusterKafkaVersion"

// UpdateClusterKafkaVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterKafkaVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterKafkaVersion for more information on using the UpdateClusterKafkaVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateClusterKafkaVersionRequest method.
//	req, resp := client.UpdateClusterKafkaVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterKafkaVersion
func (c *Kafka) UpdateClusterKafkaVersionRequest(input *UpdateClusterKafkaVersionInput) (req *request.Request, output *UpdateClusterKafkaVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterKafkaVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/version",
	}

	if input == nil {
		input = &UpdateClusterKafkaVersionInput{}
	}

	output = &UpdateClusterKafkaVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterKafkaVersion API operation for Managed Streaming for Kafka.
//
// Updates the Apache Kafka version for the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateClusterKafkaVersion for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterKafkaVersion
func (c *Kafka) UpdateClusterKafkaVersion(input *UpdateClusterKafkaVersionInput) (*UpdateClusterKafkaVersionOutput, error) {
	req, out := c.UpdateClusterKafkaVersionRequest(input)
	return out, req.Send()
}

// UpdateClusterKafkaVersionWithContext is the same as UpdateClusterKafkaVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterKafkaVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateClusterKafkaVersionWithContext(ctx aws.Context, input *UpdateClusterKafkaVersionInput, opts ...request.Option) (*UpdateClusterKafkaVersionOutput, error) {
	req, out := c.UpdateClusterKafkaVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfiguration = "UpdateConfiguration"

// UpdateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfiguration for more information on using the UpdateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfigurationRequest method.
//	req, resp := client.UpdateConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConfiguration
func (c *Kafka) UpdateConfigurationRequest(input *UpdateConfigurationInput) (req *request.Request, output *UpdateConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/configurations/{arn}",
	}

	if input == nil {
		input = &UpdateConfigurationInput{}
	}

	output = &UpdateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfiguration API operation for Managed Streaming for Kafka.
//
// Updates an existing MSK configuration. The configuration must be in the Active
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConfiguration
func (c *Kafka) UpdateConfiguration(input *UpdateConfigurationInput) (*UpdateConfigurationOutput, error) {
	req, out := c.UpdateConfigurationRequest(input)
	return out, req.Send()
}

// UpdateConfigurationWithContext is the same as UpdateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateConfigurationWithContext(ctx aws.Context, input *UpdateConfigurationInput, opts ...request.Option) (*UpdateConfigurationOutput, error) {
	req, out := c.UpdateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnectivity = "UpdateConnectivity"

// UpdateConnectivityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnectivity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnectivity for more information on using the UpdateConnectivity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConnectivityRequest method.
//	req, resp := client.UpdateConnectivityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConnectivity
func (c *Kafka) UpdateConnectivityRequest(input *UpdateConnectivityInput) (req *request.Request, output *UpdateConnectivityOutput) {
	op := &request.Operation{
		Name:       opUpdateConnectivity,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/connectivity",
	}

	if input == nil {
		input = &UpdateConnectivityInput{}
	}

	output = &UpdateConnectivityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConnectivity API operation for Managed Streaming for Kafka.
//
// Updates the connectivity configuration for the MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateConnectivity for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConnectivity
func (c *Kafka) UpdateConnectivity(input *UpdateConnectivityInput) (*UpdateConnectivityOutput, error) {
	req, out := c.UpdateConnectivityRequest(input)
	return out, req.Send()
}

// UpdateConnectivityWithContext is the same as UpdateConnectivity with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnectivity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateConnectivityWithContext(ctx aws.Context, input *UpdateConnectivityInput, opts ...request.Option) (*UpdateConnectivityOutput, error) {
	req, out := c.UpdateConnectivityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMonitoring = "UpdateMonitoring"

// UpdateMonitoringRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMonitoring operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMonitoring for more information on using the UpdateMonitoring
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMonitoringRequest method.
//	req, resp := client.UpdateMonitoringRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateMonitoring
func (c *Kafka) UpdateMonitoringRequest(input *UpdateMonitoringInput) (req *request.Request, output *UpdateMonitoringOutput) {
	op := &request.Operation{
		Name:       opUpdateMonitoring,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/monitoring",
	}

	if input == nil {
		input = &UpdateMonitoringInput{}
	}

	output = &UpdateMonitoringOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMonitoring API operation for Managed Streaming for Kafka.
//
// Updates the monitoring settings for the cluster. You can use this operation
// to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon
// CloudWatch. You can also specify settings for open monitoring with Prometheus.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateMonitoring for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateMonitoring
func (c *Kafka) UpdateMonitoring(input *UpdateMonitoringInput) (*UpdateMonitoringOutput, error) {
	req, out := c.UpdateMonitoringRequest(input)
	return out, req.Send()
}

// UpdateMonitoringWithContext is the same as UpdateMonitoring with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMonitoring for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateMonitoringWithContext(ctx aws.Context, input *UpdateMonitoringInput, opts ...request.Option) (*UpdateMonitoringOutput, error) {
	req, out := c.UpdateMonitoringRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecurity = "UpdateSecurity"

// UpdateSecurityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecurity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecurity for more information on using the UpdateSecurity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSecurityRequest method.
//	req, resp := client.UpdateSecurityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateSecurity
func (c *Kafka) UpdateSecurityRequest(input *UpdateSecurityInput) (req *request.Request, output *UpdateSecurityOutput) {
	op := &request.Operation{
		Name:       opUpdateSecurity,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v1/clusters/{clusterArn}/security",
	}

	if input == nil {
		input = &UpdateSecurityInput{}
	}

	output = &UpdateSecurityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSecurity API operation for Managed Streaming for Kafka.
//
// You can use this operation to update the encrypting and authentication settings
// for an existing cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateSecurity for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateSecurity
func (c *Kafka) UpdateSecurity(input *UpdateSecurityInput) (*UpdateSecurityOutput, error) {
	req, out := c.UpdateSecurityRequest(input)
	return out, req.Send()
}

// UpdateSecurityWithContext is the same as UpdateSecurity with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecurity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateSecurityWithContext(ctx aws.Context, input *UpdateSecurityInput, opts ...request.Option) (*UpdateSecurityOutput, error) {
	req, out := c.UpdateSecurityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStorage = "UpdateStorage"

// UpdateStorageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStorage for more information on using the UpdateStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStorageRequest method.
//	req, resp := client.UpdateStorageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateStorage
func (c *Kafka) UpdateStorageRequest(input *UpdateStorageInput) (req *request.Request, output *UpdateStorageOutput) {
	op := &request.Operation{
		Name:       opUpdateStorage,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/storage",
	}

	if input == nil {
		input = &UpdateStorageInput{}
	}

	output = &UpdateStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStorage API operation for Managed Streaming for Kafka.
//
// Updates cluster broker volume size (or) sets cluster storage mode to TIERED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateStorage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Returns information about an error.
//
//   - UnauthorizedException
//     Returns information about an error.
//
//   - InternalServerErrorException
//     Returns information about an error.
//
//   - ForbiddenException
//     Returns information about an error.
//
//   - NotFoundException
//     Returns information about an error.
//
//   - ServiceUnavailableException
//     Returns information about an error.
//
//   - TooManyRequestsException
//     Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateStorage
func (c *Kafka) UpdateStorage(input *UpdateStorageInput) (*UpdateStorageOutput, error) {
	req, out := c.UpdateStorageRequest(input)
	return out, req.Send()
}

// UpdateStorageWithContext is the same as UpdateStorage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateStorageWithContext(ctx aws.Context, input *UpdateStorageInput, opts ...request.Option) (*UpdateStorageOutput, error) {
	req, out := c.UpdateStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Returns information about an error.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request body for BatchAssociateScramSecret.
type BatchAssociateScramSecretInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// List of AWS Secrets Manager secret ARNs.
	//
	// SecretArnList is a required field
	SecretArnList []*string `locationName:"secretArnList" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateScramSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateScramSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateScramSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAssociateScramSecretInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.SecretArnList == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArnList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *BatchAssociateScramSecretInput) SetClusterArn(v string) *BatchAssociateScramSecretInput {
	s.ClusterArn = &v
	return s
}

// SetSecretArnList sets the SecretArnList field's value.
func (s *BatchAssociateScramSecretInput) SetSecretArnList(v []*string) *BatchAssociateScramSecretInput {
	s.SecretArnList = v
	return s
}

// Response body for BatchAssociateScramSecret.
type BatchAssociateScramSecretOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// List of errors when associating secrets to cluster.
	UnprocessedScramSecrets []*UnprocessedScramSecret `locationName:"unprocessedScramSecrets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateScramSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateScramSecretOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *BatchAssociateScramSecretOutput) SetClusterArn(v string) *BatchAssociateScramSecretOutput {
	s.ClusterArn = &v
	return s
}

// SetUnprocessedScramSecrets sets the UnprocessedScramSecrets field's value.
func (s *BatchAssociateScramSecretOutput) SetUnprocessedScramSecrets(v []*UnprocessedScramSecret) *BatchAssociateScramSecretOutput {
	s.UnprocessedScramSecrets = v
	return s
}

// Request body for BatchDisassociateScramSecret.
type BatchDisassociateScramSecretInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// List of AWS Secrets Manager secret ARNs.
	//
	// SecretArnList is a required field
	SecretArnList []*string `locationName:"secretArnList" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateScramSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateScramSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisassociateScramSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisassociateScramSecretInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.SecretArnList == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArnList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *BatchDisassociateScramSecretInput) SetClusterArn(v string) *BatchDisassociateScramSecretInput {
	s.ClusterArn = &v
	return s
}

// SetSecretArnList sets the SecretArnList field's value.
func (s *BatchDisassociateScramSecretInput) SetSecretArnList(v []*string) *BatchDisassociateScramSecretInput {
	s.SecretArnList = v
	return s
}

// Response body for BatchDisassociateScramSecret.
type BatchDisassociateScramSecretOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// List of errors when disassociating secrets to cluster.
	UnprocessedScramSecrets []*UnprocessedScramSecret `locationName:"unprocessedScramSecrets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateScramSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateScramSecretOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *BatchDisassociateScramSecretOutput) SetClusterArn(v string) *BatchDisassociateScramSecretOutput {
	s.ClusterArn = &v
	return s
}

// SetUnprocessedScramSecrets sets the UnprocessedScramSecrets field's value.
func (s *BatchDisassociateScramSecretOutput) SetUnprocessedScramSecrets(v []*UnprocessedScramSecret) *BatchDisassociateScramSecretOutput {
	s.UnprocessedScramSecrets = v
	return s
}

// Specifies the EBS volume upgrade information. The broker identifier must
// be set to the keyword ALL. This means the changes apply to all the brokers
// in the cluster.
type BrokerEBSVolumeInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the broker to update.
	//
	// KafkaBrokerNodeId is a required field
	KafkaBrokerNodeId *string `locationName:"kafkaBrokerNodeId" type:"string" required:"true"`

	// EBS volume provisioned throughput information.
	ProvisionedThroughput *ProvisionedThroughput `locationName:"provisionedThroughput" type:"structure"`

	// Size of the EBS volume to update.
	VolumeSizeGB *int64 `locationName:"volumeSizeGB" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrokerEBSVolumeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrokerEBSVolumeInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BrokerEBSVolumeInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BrokerEBSVolumeInfo"}
	if s.KafkaBrokerNodeId == nil {
		invalidParams.Add(request.NewErrParamRequired("KafkaBrokerNodeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKafkaBrokerNodeId sets the KafkaBrokerNodeId field's value.
func (s *BrokerEBSVolumeInfo) SetKafkaBrokerNodeId(v string) *BrokerEBSVolumeInfo {
	s.KafkaBrokerNodeId = &v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *BrokerEBSVolumeInfo) SetProvisionedThroughput(v *ProvisionedThroughput) *BrokerEBSVolumeInfo {
	s.ProvisionedThroughput = v
	return s
}

// SetVolumeSizeGB sets the VolumeSizeGB field's value.
func (s *BrokerEBSVolumeInfo) SetVolumeSizeGB(v int64) *BrokerEBSVolumeInfo {
	s.VolumeSizeGB = &v
	return s
}

// The broker logs configuration for this MSK cluster.
type BrokerLogs struct {
	_ struct{} `type:"structure"`

	// Details of the CloudWatch Logs destination for broker logs.
	CloudWatchLogs *CloudWatchLogs `locationName:"cloudWatchLogs" type:"structure"`

	// Details of the Kinesis Data Firehose delivery stream that is the destination
	// for broker logs.
	Firehose *Firehose `locationName:"firehose" type:"structure"`

	// Details of the Amazon S3 destination for broker logs.
	S3 *S3 `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrokerLogs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrokerLogs) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BrokerLogs) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BrokerLogs"}
	if s.CloudWatchLogs != nil {
		if err := s.CloudWatchLogs.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.Firehose != nil {
		if err := s.Firehose.Validate(); err != nil {
			invalidParams.AddNested("Firehose", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *BrokerLogs) SetCloudWatchLogs(v *CloudWatchLogs) *BrokerLogs {
	s.CloudWatchLogs = v
	return s
}

// SetFirehose sets the Firehose field's value.
func (s *BrokerLogs) SetFirehose(v *Firehose) *BrokerLogs {
	s.Firehose = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *BrokerLogs) SetS3(v *S3) *BrokerLogs {
	s.S3 = v
	return s
}

// Describes the setup to be used for Apache Kafka broker nodes in the cluster.
type BrokerNodeGroupInfo struct {
	_ struct{} `type:"structure"`

	// The distribution of broker nodes across Availability Zones.
	BrokerAZDistribution *string `locationName:"brokerAZDistribution" type:"string" enum:"BrokerAZDistribution"`

	// The list of subnets to connect to in the client virtual private cloud (VPC).
	// AWS creates elastic network interfaces inside these subnets. Client applications
	// use elastic network interfaces to produce and consume data. Client subnets
	// can't occupy the Availability Zone with ID use use1-az3.
	//
	// ClientSubnets is a required field
	ClientSubnets []*string `locationName:"clientSubnets" type:"list" required:"true"`

	// Information about the broker access configuration.
	ConnectivityInfo *ConnectivityInfo `locationName:"connectivityInfo" type:"structure"`

	// The type of broker used in the Amazon MSK cluster.
	//
	// InstanceType is a required field
	InstanceType *string `locationName:"instanceType" min:"5" type:"string" required:"true"`

	// The AWS security groups to associate with the elastic network interfaces
	// in order to specify who can connect to and communicate with the Amazon MSK
	// cluster. If you don't specify a security group, Amazon MSK uses the default
	// security group associated with the VPC. If you specify security groups that
	// were shared with you, you must ensure that you have permissions to them.
	// Specifically, you need the ec2:DescribeSecurityGroups permission.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// Contains information about storage volumes attached to MSK broker nodes.
	StorageInfo *StorageInfo `locationName:"storageInfo" type:"structure"`

	// The zoneIds for the cluster.
	ZoneIds []*string `locationName:"zoneIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrokerNodeGroupInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrokerNodeGroupInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BrokerNodeGroupInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BrokerNodeGroupInfo"}
	if s.ClientSubnets == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSubnets"))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 5))
	}
	if s.StorageInfo != nil {
		if err := s.StorageInfo.Validate(); err != nil {
			invalidParams.AddNested("StorageInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerAZDistribution sets the BrokerAZDistribution field's value.
func (s *BrokerNodeGroupInfo) SetBrokerAZDistribution(v string) *BrokerNodeGroupInfo {
	s.BrokerAZDistribution = &v
	return s
}

// SetClientSubnets sets the ClientSubnets field's value.
func (s *BrokerNodeGroupInfo) SetClientSubnets(v []*string) *BrokerNodeGroupInfo {
	s.ClientSubnets = v
	return s
}

// SetConnectivityInfo sets the ConnectivityInfo field's value.
func (s *BrokerNodeGroupInfo) SetConnectivityInfo(v *ConnectivityInfo) *BrokerNodeGroupInfo {
	s.ConnectivityInfo = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *BrokerNodeGroupInfo) SetInstanceType(v string) *BrokerNodeGroupInfo {
	s.InstanceType = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *BrokerNodeGroupInfo) SetSecurityGroups(v []*string) *BrokerNodeGroupInfo {
	s.SecurityGroups = v
	return s
}

// SetStorageInfo sets the StorageInfo field's value.
func (s *BrokerNodeGroupInfo) SetStorageInfo(v *StorageInfo) *BrokerNodeGroupInfo {
	s.StorageInfo = v
	return s
}

// SetZoneIds sets the ZoneIds field's value.
func (s *BrokerNodeGroupInfo) SetZoneIds(v []*string) *BrokerNodeGroupInfo {
	s.ZoneIds = v
	return s
}

// BrokerNodeInfo
type BrokerNodeInfo struct {
	_ struct{} `type:"structure"`

	// The attached elastic network interface of the broker.
	AttachedENIId *string `locationName:"attachedENIId" type:"string"`

	// The ID of the broker.
	BrokerId *float64 `locationName:"brokerId" type:"double"`

	// The client subnet to which this broker node belongs.
	ClientSubnet *string `locationName:"clientSubnet" type:"string"`

	// The virtual private cloud (VPC) of the client.
	ClientVpcIpAddress *string `locationName:"clientVpcIpAddress" type:"string"`

	// Information about the version of software currently deployed on the Apache
	// Kafka brokers in the cluster.
	CurrentBrokerSoftwareInfo *BrokerSoftwareInfo `locationName:"currentBrokerSoftwareInfo" type:"structure"`

	// Endpoints for accessing the broker.
	Endpoints []*string `locationName:"endpoints" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrokerNodeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrokerNodeInfo) GoString() string {
	return s.String()
}

// SetAttachedENIId sets the AttachedENIId field's value.
func (s *BrokerNodeInfo) SetAttachedENIId(v string) *BrokerNodeInfo {
	s.AttachedENIId = &v
	return s
}

// SetBrokerId sets the BrokerId field's value.
func (s *BrokerNodeInfo) SetBrokerId(v float64) *BrokerNodeInfo {
	s.BrokerId = &v
	return s
}

// SetClientSubnet sets the ClientSubnet field's value.
func (s *BrokerNodeInfo) SetClientSubnet(v string) *BrokerNodeInfo {
	s.ClientSubnet = &v
	return s
}

// SetClientVpcIpAddress sets the ClientVpcIpAddress field's value.
func (s *BrokerNodeInfo) SetClientVpcIpAddress(v string) *BrokerNodeInfo {
	s.ClientVpcIpAddress = &v
	return s
}

// SetCurrentBrokerSoftwareInfo sets the CurrentBrokerSoftwareInfo field's value.
func (s *BrokerNodeInfo) SetCurrentBrokerSoftwareInfo(v *BrokerSoftwareInfo) *BrokerNodeInfo {
	s.CurrentBrokerSoftwareInfo = v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *BrokerNodeInfo) SetEndpoints(v []*string) *BrokerNodeInfo {
	s.Endpoints = v
	return s
}

// Information about the current software installed on the cluster.
type BrokerSoftwareInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration used for the cluster.
	// This field isn't visible in this preview release.
	ConfigurationArn *string `locationName:"configurationArn" type:"string"`

	// The revision of the configuration to use. This field isn't visible in this
	// preview release.
	ConfigurationRevision *int64 `locationName:"configurationRevision" type:"long"`

	// The version of Apache Kafka.
	KafkaVersion *string `locationName:"kafkaVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrokerSoftwareInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrokerSoftwareInfo) GoString() string {
	return s.String()
}

// SetConfigurationArn sets the ConfigurationArn field's value.
func (s *BrokerSoftwareInfo) SetConfigurationArn(v string) *BrokerSoftwareInfo {
	s.ConfigurationArn = &v
	return s
}

// SetConfigurationRevision sets the ConfigurationRevision field's value.
func (s *BrokerSoftwareInfo) SetConfigurationRevision(v int64) *BrokerSoftwareInfo {
	s.ConfigurationRevision = &v
	return s
}

// SetKafkaVersion sets the KafkaVersion field's value.
func (s *BrokerSoftwareInfo) SetKafkaVersion(v string) *BrokerSoftwareInfo {
	s.KafkaVersion = &v
	return s
}

// Includes all client authentication information.
type ClientAuthentication struct {
	_ struct{} `type:"structure"`

	Sasl *Sasl `locationName:"sasl" type:"structure"`

	// Details for ClientAuthentication using TLS.
	Tls *Tls `locationName:"tls" type:"structure"`

	// Contains information about unauthenticated traffic to the cluster.
	Unauthenticated *Unauthenticated `locationName:"unauthenticated" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientAuthentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientAuthentication) GoString() string {
	return s.String()
}

// SetSasl sets the Sasl field's value.
func (s *ClientAuthentication) SetSasl(v *Sasl) *ClientAuthentication {
	s.Sasl = v
	return s
}

// SetTls sets the Tls field's value.
func (s *ClientAuthentication) SetTls(v *Tls) *ClientAuthentication {
	s.Tls = v
	return s
}

// SetUnauthenticated sets the Unauthenticated field's value.
func (s *ClientAuthentication) SetUnauthenticated(v *Unauthenticated) *ClientAuthentication {
	s.Unauthenticated = v
	return s
}

// The client VPC connection object.
type ClientVpcConnection struct {
	_ struct{} `type:"structure"`

	// The VPC connection authentication type.
	Authentication *string `locationName:"authentication" type:"string"`

	// The creation time of the VPC connection.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The owner of the VPC connection.
	Owner *string `locationName:"owner" type:"string"`

	// The state of a configuration.
	State *string `locationName:"state" type:"string" enum:"VpcConnectionState"`

	// The Amazon Resource Name (ARN) of the VPC connection.
	//
	// VpcConnectionArn is a required field
	VpcConnectionArn *string `locationName:"vpcConnectionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientVpcConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientVpcConnection) GoString() string {
	return s.String()
}

// SetAuthentication sets the Authentication field's value.
func (s *ClientVpcConnection) SetAuthentication(v string) *ClientVpcConnection {
	s.Authentication = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ClientVpcConnection) SetCreationTime(v time.Time) *ClientVpcConnection {
	s.CreationTime = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ClientVpcConnection) SetOwner(v string) *ClientVpcConnection {
	s.Owner = &v
	return s
}

// SetState sets the State field's value.
func (s *ClientVpcConnection) SetState(v string) *ClientVpcConnection {
	s.State = &v
	return s
}

// SetVpcConnectionArn sets the VpcConnectionArn field's value.
func (s *ClientVpcConnection) SetVpcConnectionArn(v string) *ClientVpcConnection {
	s.VpcConnectionArn = &v
	return s
}

// Details of the CloudWatch Logs destination for broker logs.
type CloudWatchLogs struct {
	_ struct{} `type:"structure"`

	// Specifies whether broker logs get sent to the specified CloudWatch Logs destination.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The CloudWatch log group that is the destination for broker logs.
	LogGroup *string `locationName:"logGroup" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogs) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogs) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogs"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CloudWatchLogs) SetEnabled(v bool) *CloudWatchLogs {
	s.Enabled = &v
	return s
}

// SetLogGroup sets the LogGroup field's value.
func (s *CloudWatchLogs) SetLogGroup(v string) *CloudWatchLogs {
	s.LogGroup = &v
	return s
}

// Returns information about a cluster of either the provisioned or the serverless
// type.
type Cluster struct {
	_ struct{} `type:"structure"`

	ActiveOperationArn *string `locationName:"activeOperationArn" type:"string"`

	ClusterArn *string `locationName:"clusterArn" type:"string"`

	ClusterName *string `locationName:"clusterName" type:"string"`

	ClusterType *string `locationName:"clusterType" type:"string" enum:"ClusterType"`

	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	CurrentVersion *string `locationName:"currentVersion" type:"string"`

	// Information about the provisioned cluster.
	Provisioned *Provisioned `locationName:"provisioned" type:"structure"`

	// Information about the serverless cluster.
	Serverless *Serverless `locationName:"serverless" type:"structure"`

	// The state of an Apache Kafka cluster.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`

	// Contains information about the state of the Amazon MSK cluster.
	StateInfo *StateInfo `locationName:"stateInfo" type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) GoString() string {
	return s.String()
}

// SetActiveOperationArn sets the ActiveOperationArn field's value.
func (s *Cluster) SetActiveOperationArn(v string) *Cluster {
	s.ActiveOperationArn = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *Cluster) SetClusterArn(v string) *Cluster {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *Cluster) SetClusterName(v string) *Cluster {
	s.ClusterName = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *Cluster) SetClusterType(v string) *Cluster {
	s.ClusterType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Cluster) SetCreationTime(v time.Time) *Cluster {
	s.CreationTime = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *Cluster) SetCurrentVersion(v string) *Cluster {
	s.CurrentVersion = &v
	return s
}

// SetProvisioned sets the Provisioned field's value.
func (s *Cluster) SetProvisioned(v *Provisioned) *Cluster {
	s.Provisioned = v
	return s
}

// SetServerless sets the Serverless field's value.
func (s *Cluster) SetServerless(v *Serverless) *Cluster {
	s.Serverless = v
	return s
}

// SetState sets the State field's value.
func (s *Cluster) SetState(v string) *Cluster {
	s.State = &v
	return s
}

// SetStateInfo sets the StateInfo field's value.
func (s *Cluster) SetStateInfo(v *StateInfo) *Cluster {
	s.StateInfo = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Cluster) SetTags(v map[string]*string) *Cluster {
	s.Tags = v
	return s
}

// Returns information about a cluster.
type ClusterInfo struct {
	_ struct{} `type:"structure"`

	// Arn of active cluster operation.
	ActiveOperationArn *string `locationName:"activeOperationArn" type:"string"`

	// Information about the brokers.
	BrokerNodeGroupInfo *BrokerNodeGroupInfo `locationName:"brokerNodeGroupInfo" type:"structure"`

	// Includes all client authentication information.
	ClientAuthentication *ClientAuthentication `locationName:"clientAuthentication" type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The name of the cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The time when the cluster was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Information about the version of software currently deployed on the Apache
	// Kafka brokers in the cluster.
	CurrentBrokerSoftwareInfo *BrokerSoftwareInfo `locationName:"currentBrokerSoftwareInfo" type:"structure"`

	// The current version of the MSK cluster. Cluster versions aren't simple integers.
	// You can obtain the current version by describing the cluster. An example
	// version is KTVPDKIKX0DER.
	CurrentVersion *string `locationName:"currentVersion" type:"string"`

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo `locationName:"encryptionInfo" type:"structure"`

	// Specifies which metrics are gathered for the MSK cluster. This property has
	// the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER,
	// and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each
	// of these levels of monitoring, see Monitoring (https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html).
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	// You can configure your MSK cluster to send broker logs to different destination
	// types. This is a container for the configuration details related to broker
	// logs.
	LoggingInfo *LoggingInfo `locationName:"loggingInfo" type:"structure"`

	// The number of broker nodes in the cluster.
	NumberOfBrokerNodes *int64 `locationName:"numberOfBrokerNodes" type:"integer"`

	// Settings for open monitoring using Prometheus.
	OpenMonitoring *OpenMonitoring `locationName:"openMonitoring" type:"structure"`

	// The state of the cluster. The possible states are ACTIVE, CREATING, DELETING,
	// FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`

	// Contains information about the state of the Amazon MSK cluster.
	StateInfo *StateInfo `locationName:"stateInfo" type:"structure"`

	// This controls storage mode for supported storage tiers.
	StorageMode *string `locationName:"storageMode" type:"string" enum:"StorageMode"`

	// Tags attached to the cluster.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The connection string to use to connect to the Apache ZooKeeper cluster.
	ZookeeperConnectString *string `locationName:"zookeeperConnectString" type:"string"`

	// The connection string to use to connect to zookeeper cluster on Tls port.
	ZookeeperConnectStringTls *string `locationName:"zookeeperConnectStringTls" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterInfo) GoString() string {
	return s.String()
}

// SetActiveOperationArn sets the ActiveOperationArn field's value.
func (s *ClusterInfo) SetActiveOperationArn(v string) *ClusterInfo {
	s.ActiveOperationArn = &v
	return s
}

// SetBrokerNodeGroupInfo sets the BrokerNodeGroupInfo field's value.
func (s *ClusterInfo) SetBrokerNodeGroupInfo(v *BrokerNodeGroupInfo) *ClusterInfo {
	s.BrokerNodeGroupInfo = v
	return s
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *ClusterInfo) SetClientAuthentication(v *ClientAuthentication) *ClusterInfo {
	s.ClientAuthentication = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterInfo) SetClusterArn(v string) *ClusterInfo {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *ClusterInfo) SetClusterName(v string) *ClusterInfo {
	s.ClusterName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ClusterInfo) SetCreationTime(v time.Time) *ClusterInfo {
	s.CreationTime = &v
	return s
}

// SetCurrentBrokerSoftwareInfo sets the CurrentBrokerSoftwareInfo field's value.
func (s *ClusterInfo) SetCurrentBrokerSoftwareInfo(v *BrokerSoftwareInfo) *ClusterInfo {
	s.CurrentBrokerSoftwareInfo = v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *ClusterInfo) SetCurrentVersion(v string) *ClusterInfo {
	s.CurrentVersion = &v
	return s
}

// SetEncryptionInfo sets the EncryptionInfo field's value.
func (s *ClusterInfo) SetEncryptionInfo(v *EncryptionInfo) *ClusterInfo {
	s.EncryptionInfo = v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *ClusterInfo) SetEnhancedMonitoring(v string) *ClusterInfo {
	s.EnhancedMonitoring = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *ClusterInfo) SetLoggingInfo(v *LoggingInfo) *ClusterInfo {
	s.LoggingInfo = v
	return s
}

// SetNumberOfBrokerNodes sets the NumberOfBrokerNodes field's value.
func (s *ClusterInfo) SetNumberOfBrokerNodes(v int64) *ClusterInfo {
	s.NumberOfBrokerNodes = &v
	return s
}

// SetOpenMonitoring sets the OpenMonitoring field's value.
func (s *ClusterInfo) SetOpenMonitoring(v *OpenMonitoring) *ClusterInfo {
	s.OpenMonitoring = v
	return s
}

// SetState sets the State field's value.
func (s *ClusterInfo) SetState(v string) *ClusterInfo {
	s.State = &v
	return s
}

// SetStateInfo sets the StateInfo field's value.
func (s *ClusterInfo) SetStateInfo(v *StateInfo) *ClusterInfo {
	s.StateInfo = v
	return s
}

// SetStorageMode sets the StorageMode field's value.
func (s *ClusterInfo) SetStorageMode(v string) *ClusterInfo {
	s.StorageMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClusterInfo) SetTags(v map[string]*string) *ClusterInfo {
	s.Tags = v
	return s
}

// SetZookeeperConnectString sets the ZookeeperConnectString field's value.
func (s *ClusterInfo) SetZookeeperConnectString(v string) *ClusterInfo {
	s.ZookeeperConnectString = &v
	return s
}

// SetZookeeperConnectStringTls sets the ZookeeperConnectStringTls field's value.
func (s *ClusterInfo) SetZookeeperConnectStringTls(v string) *ClusterInfo {
	s.ZookeeperConnectStringTls = &v
	return s
}

// Returns information about a cluster operation.
type ClusterOperationInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the API request that triggered this operation.
	ClientRequestId *string `locationName:"clientRequestId" type:"string"`

	// ARN of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The time at which operation was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The time at which the operation finished.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// Describes the error if the operation fails.
	ErrorInfo *ErrorInfo `locationName:"errorInfo" type:"structure"`

	// ARN of the cluster operation.
	OperationArn *string `locationName:"operationArn" type:"string"`

	// State of the cluster operation.
	OperationState *string `locationName:"operationState" type:"string"`

	// Steps completed during the operation.
	OperationSteps []*ClusterOperationStep `locationName:"operationSteps" type:"list"`

	// Type of the cluster operation.
	OperationType *string `locationName:"operationType" type:"string"`

	// Information about cluster attributes before a cluster is updated.
	SourceClusterInfo *MutableClusterInfo `locationName:"sourceClusterInfo" type:"structure"`

	// Information about cluster attributes after a cluster is updated.
	TargetClusterInfo *MutableClusterInfo `locationName:"targetClusterInfo" type:"structure"`

	// Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection
	// operations.
	VpcConnectionInfo *VpcConnectionInfo `locationName:"vpcConnectionInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationInfo) GoString() string {
	return s.String()
}

// SetClientRequestId sets the ClientRequestId field's value.
func (s *ClusterOperationInfo) SetClientRequestId(v string) *ClusterOperationInfo {
	s.ClientRequestId = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterOperationInfo) SetClusterArn(v string) *ClusterOperationInfo {
	s.ClusterArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ClusterOperationInfo) SetCreationTime(v time.Time) *ClusterOperationInfo {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ClusterOperationInfo) SetEndTime(v time.Time) *ClusterOperationInfo {
	s.EndTime = &v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *ClusterOperationInfo) SetErrorInfo(v *ErrorInfo) *ClusterOperationInfo {
	s.ErrorInfo = v
	return s
}

// SetOperationArn sets the OperationArn field's value.
func (s *ClusterOperationInfo) SetOperationArn(v string) *ClusterOperationInfo {
	s.OperationArn = &v
	return s
}

// SetOperationState sets the OperationState field's value.
func (s *ClusterOperationInfo) SetOperationState(v string) *ClusterOperationInfo {
	s.OperationState = &v
	return s
}

// SetOperationSteps sets the OperationSteps field's value.
func (s *ClusterOperationInfo) SetOperationSteps(v []*ClusterOperationStep) *ClusterOperationInfo {
	s.OperationSteps = v
	return s
}

// SetOperationType sets the OperationType field's value.
func (s *ClusterOperationInfo) SetOperationType(v string) *ClusterOperationInfo {
	s.OperationType = &v
	return s
}

// SetSourceClusterInfo sets the SourceClusterInfo field's value.
func (s *ClusterOperationInfo) SetSourceClusterInfo(v *MutableClusterInfo) *ClusterOperationInfo {
	s.SourceClusterInfo = v
	return s
}

// SetTargetClusterInfo sets the TargetClusterInfo field's value.
func (s *ClusterOperationInfo) SetTargetClusterInfo(v *MutableClusterInfo) *ClusterOperationInfo {
	s.TargetClusterInfo = v
	return s
}

// SetVpcConnectionInfo sets the VpcConnectionInfo field's value.
func (s *ClusterOperationInfo) SetVpcConnectionInfo(v *VpcConnectionInfo) *ClusterOperationInfo {
	s.VpcConnectionInfo = v
	return s
}

// Step taken during a cluster operation.
type ClusterOperationStep struct {
	_ struct{} `type:"structure"`

	// Information about the step and its status.
	StepInfo *ClusterOperationStepInfo `locationName:"stepInfo" type:"structure"`

	// The name of the step.
	StepName *string `locationName:"stepName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationStep) GoString() string {
	return s.String()
}

// SetStepInfo sets the StepInfo field's value.
func (s *ClusterOperationStep) SetStepInfo(v *ClusterOperationStepInfo) *ClusterOperationStep {
	s.StepInfo = v
	return s
}

// SetStepName sets the StepName field's value.
func (s *ClusterOperationStep) SetStepName(v string) *ClusterOperationStep {
	s.StepName = &v
	return s
}

// State information about the operation step.
type ClusterOperationStepInfo struct {
	_ struct{} `type:"structure"`

	// The steps current status.
	StepStatus *string `locationName:"stepStatus" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationStepInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationStepInfo) GoString() string {
	return s.String()
}

// SetStepStatus sets the StepStatus field's value.
func (s *ClusterOperationStepInfo) SetStepStatus(v string) *ClusterOperationStepInfo {
	s.StepStatus = &v
	return s
}

// Returns information about a cluster operation.
type ClusterOperationV2 struct {
	_ struct{} `type:"structure"`

	ClusterArn *string `locationName:"clusterArn" type:"string"`

	ClusterType *string `locationName:"clusterType" type:"string" enum:"ClusterType"`

	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	OperationArn *string `locationName:"operationArn" type:"string"`

	OperationState *string `locationName:"operationState" type:"string"`

	OperationType *string `locationName:"operationType" type:"string"`

	// Properties of a provisioned cluster.
	Provisioned *ClusterOperationV2Provisioned `locationName:"provisioned" type:"structure"`

	// Properties of a serverless cluster.
	Serverless *ClusterOperationV2Serverless `locationName:"serverless" type:"structure"`

	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationV2) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterOperationV2) SetClusterArn(v string) *ClusterOperationV2 {
	s.ClusterArn = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *ClusterOperationV2) SetClusterType(v string) *ClusterOperationV2 {
	s.ClusterType = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ClusterOperationV2) SetEndTime(v time.Time) *ClusterOperationV2 {
	s.EndTime = &v
	return s
}

// SetOperationArn sets the OperationArn field's value.
func (s *ClusterOperationV2) SetOperationArn(v string) *ClusterOperationV2 {
	s.OperationArn = &v
	return s
}

// SetOperationState sets the OperationState field's value.
func (s *ClusterOperationV2) SetOperationState(v string) *ClusterOperationV2 {
	s.OperationState = &v
	return s
}

// SetOperationType sets the OperationType field's value.
func (s *ClusterOperationV2) SetOperationType(v string) *ClusterOperationV2 {
	s.OperationType = &v
	return s
}

// SetProvisioned sets the Provisioned field's value.
func (s *ClusterOperationV2) SetProvisioned(v *ClusterOperationV2Provisioned) *ClusterOperationV2 {
	s.Provisioned = v
	return s
}

// SetServerless sets the Serverless field's value.
func (s *ClusterOperationV2) SetServerless(v *ClusterOperationV2Serverless) *ClusterOperationV2 {
	s.Serverless = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ClusterOperationV2) SetStartTime(v time.Time) *ClusterOperationV2 {
	s.StartTime = &v
	return s
}

// Returns information about a provisioned cluster operation.
type ClusterOperationV2Provisioned struct {
	_ struct{} `type:"structure"`

	OperationSteps []*ClusterOperationStep `locationName:"operationSteps" type:"list"`

	// Information about cluster attributes that can be updated via update APIs.
	SourceClusterInfo *MutableClusterInfo `locationName:"sourceClusterInfo" type:"structure"`

	// Information about cluster attributes that can be updated via update APIs.
	TargetClusterInfo *MutableClusterInfo `locationName:"targetClusterInfo" type:"structure"`

	// Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection
	// operations.
	VpcConnectionInfo *VpcConnectionInfo `locationName:"vpcConnectionInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationV2Provisioned) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationV2Provisioned) GoString() string {
	return s.String()
}

// SetOperationSteps sets the OperationSteps field's value.
func (s *ClusterOperationV2Provisioned) SetOperationSteps(v []*ClusterOperationStep) *ClusterOperationV2Provisioned {
	s.OperationSteps = v
	return s
}

// SetSourceClusterInfo sets the SourceClusterInfo field's value.
func (s *ClusterOperationV2Provisioned) SetSourceClusterInfo(v *MutableClusterInfo) *ClusterOperationV2Provisioned {
	s.SourceClusterInfo = v
	return s
}

// SetTargetClusterInfo sets the TargetClusterInfo field's value.
func (s *ClusterOperationV2Provisioned) SetTargetClusterInfo(v *MutableClusterInfo) *ClusterOperationV2Provisioned {
	s.TargetClusterInfo = v
	return s
}

// SetVpcConnectionInfo sets the VpcConnectionInfo field's value.
func (s *ClusterOperationV2Provisioned) SetVpcConnectionInfo(v *VpcConnectionInfo) *ClusterOperationV2Provisioned {
	s.VpcConnectionInfo = v
	return s
}

// Returns information about a serverless cluster operation.
type ClusterOperationV2Serverless struct {
	_ struct{} `type:"structure"`

	// Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection
	// operations.
	VpcConnectionInfo *VpcConnectionInfoServerless `locationName:"vpcConnectionInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationV2Serverless) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationV2Serverless) GoString() string {
	return s.String()
}

// SetVpcConnectionInfo sets the VpcConnectionInfo field's value.
func (s *ClusterOperationV2Serverless) SetVpcConnectionInfo(v *VpcConnectionInfoServerless) *ClusterOperationV2Serverless {
	s.VpcConnectionInfo = v
	return s
}

// Returns information about a cluster operation.
type ClusterOperationV2Summary struct {
	_ struct{} `type:"structure"`

	ClusterArn *string `locationName:"clusterArn" type:"string"`

	ClusterType *string `locationName:"clusterType" type:"string" enum:"ClusterType"`

	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	OperationArn *string `locationName:"operationArn" type:"string"`

	OperationState *string `locationName:"operationState" type:"string"`

	OperationType *string `locationName:"operationType" type:"string"`

	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationV2Summary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterOperationV2Summary) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterOperationV2Summary) SetClusterArn(v string) *ClusterOperationV2Summary {
	s.ClusterArn = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *ClusterOperationV2Summary) SetClusterType(v string) *ClusterOperationV2Summary {
	s.ClusterType = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ClusterOperationV2Summary) SetEndTime(v time.Time) *ClusterOperationV2Summary {
	s.EndTime = &v
	return s
}

// SetOperationArn sets the OperationArn field's value.
func (s *ClusterOperationV2Summary) SetOperationArn(v string) *ClusterOperationV2Summary {
	s.OperationArn = &v
	return s
}

// SetOperationState sets the OperationState field's value.
func (s *ClusterOperationV2Summary) SetOperationState(v string) *ClusterOperationV2Summary {
	s.OperationState = &v
	return s
}

// SetOperationType sets the OperationType field's value.
func (s *ClusterOperationV2Summary) SetOperationType(v string) *ClusterOperationV2Summary {
	s.OperationType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ClusterOperationV2Summary) SetStartTime(v time.Time) *ClusterOperationV2Summary {
	s.StartTime = &v
	return s
}

// Contains source Apache Kafka versions and compatible target Apache Kafka
// versions.
type CompatibleKafkaVersion struct {
	_ struct{} `type:"structure"`

	SourceVersion *string `locationName:"sourceVersion" type:"string"`

	TargetVersions []*string `locationName:"targetVersions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleKafkaVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleKafkaVersion) GoString() string {
	return s.String()
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *CompatibleKafkaVersion) SetSourceVersion(v string) *CompatibleKafkaVersion {
	s.SourceVersion = &v
	return s
}

// SetTargetVersions sets the TargetVersions field's value.
func (s *CompatibleKafkaVersion) SetTargetVersions(v []*string) *CompatibleKafkaVersion {
	s.TargetVersions = v
	return s
}

// Represents an MSK Configuration.
type Configuration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the configuration was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the configuration.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// An array of the versions of Apache Kafka with which you can use this MSK
	// configuration. You can use this configuration for an MSK cluster only if
	// the Apache Kafka version specified for the cluster appears in this array.
	//
	// KafkaVersions is a required field
	KafkaVersions []*string `locationName:"kafkaVersions" type:"list" required:"true"`

	// Latest revision of the configuration.
	//
	// LatestRevision is a required field
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure" required:"true"`

	// The name of the configuration. Configuration names are strings that match
	// the regex "^[0-9A-Za-z-]+$".
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The state of a configuration.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"ConfigurationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Configuration) SetArn(v string) *Configuration {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Configuration) SetCreationTime(v time.Time) *Configuration {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Configuration) SetDescription(v string) *Configuration {
	s.Description = &v
	return s
}

// SetKafkaVersions sets the KafkaVersions field's value.
func (s *Configuration) SetKafkaVersions(v []*string) *Configuration {
	s.KafkaVersions = v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *Configuration) SetLatestRevision(v *ConfigurationRevision) *Configuration {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *Configuration) SetName(v string) *Configuration {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Configuration) SetState(v string) *Configuration {
	s.State = &v
	return s
}

// Specifies the configuration to use for the brokers.
type ConfigurationInfo struct {
	_ struct{} `type:"structure"`

	// ARN of the configuration to use.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The revision of the configuration to use.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationInfo"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ConfigurationInfo) SetArn(v string) *ConfigurationInfo {
	s.Arn = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *ConfigurationInfo) SetRevision(v int64) *ConfigurationInfo {
	s.Revision = &v
	return s
}

// Describes a configuration revision.
type ConfigurationRevision struct {
	_ struct{} `type:"structure"`

	// The time when the configuration revision was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the configuration revision.
	Description *string `locationName:"description" type:"string"`

	// The revision number.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationRevision) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ConfigurationRevision) SetCreationTime(v time.Time) *ConfigurationRevision {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfigurationRevision) SetDescription(v string) *ConfigurationRevision {
	s.Description = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *ConfigurationRevision) SetRevision(v int64) *ConfigurationRevision {
	s.Revision = &v
	return s
}

// Returns information about an error.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the broker access configuration.
type ConnectivityInfo struct {
	_ struct{} `type:"structure"`

	// Public access control for brokers.
	PublicAccess *PublicAccess `locationName:"publicAccess" type:"structure"`

	// VpcConnectivity control for brokers.
	VpcConnectivity *VpcConnectivity `locationName:"vpcConnectivity" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectivityInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectivityInfo) GoString() string {
	return s.String()
}

// SetPublicAccess sets the PublicAccess field's value.
func (s *ConnectivityInfo) SetPublicAccess(v *PublicAccess) *ConnectivityInfo {
	s.PublicAccess = v
	return s
}

// SetVpcConnectivity sets the VpcConnectivity field's value.
func (s *ConnectivityInfo) SetVpcConnectivity(v *VpcConnectivity) *ConnectivityInfo {
	s.VpcConnectivity = v
	return s
}

// Creates a cluster.
type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// Information about the brokers.
	//
	// BrokerNodeGroupInfo is a required field
	BrokerNodeGroupInfo *BrokerNodeGroupInfo `locationName:"brokerNodeGroupInfo" type:"structure" required:"true"`

	// Includes all client authentication related information.
	ClientAuthentication *ClientAuthentication `locationName:"clientAuthentication" type:"structure"`

	// The name of the cluster.
	//
	// ClusterName is a required field
	ClusterName *string `locationName:"clusterName" min:"1" type:"string" required:"true"`

	// Represents the configuration that you want MSK to use for the cluster.
	ConfigurationInfo *ConfigurationInfo `locationName:"configurationInfo" type:"structure"`

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo `locationName:"encryptionInfo" type:"structure"`

	// Specifies the level of monitoring for the MSK cluster. The possible values
	// are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	// The version of Apache Kafka.
	//
	// KafkaVersion is a required field
	KafkaVersion *string `locationName:"kafkaVersion" min:"1" type:"string" required:"true"`

	// LoggingInfo details.
	LoggingInfo *LoggingInfo `locationName:"loggingInfo" type:"structure"`

	// The number of Apache Kafka broker nodes in the Amazon MSK cluster.
	//
	// NumberOfBrokerNodes is a required field
	NumberOfBrokerNodes *int64 `locationName:"numberOfBrokerNodes" min:"1" type:"integer" required:"true"`

	// The settings for open monitoring.
	OpenMonitoring *OpenMonitoringInfo `locationName:"openMonitoring" type:"structure"`

	// This controls storage mode for supported storage tiers.
	StorageMode *string `locationName:"storageMode" type:"string" enum:"StorageMode"`

	// Create tags when creating the cluster.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.BrokerNodeGroupInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerNodeGroupInfo"))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.KafkaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("KafkaVersion"))
	}
	if s.KafkaVersion != nil && len(*s.KafkaVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KafkaVersion", 1))
	}
	if s.NumberOfBrokerNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfBrokerNodes"))
	}
	if s.NumberOfBrokerNodes != nil && *s.NumberOfBrokerNodes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBrokerNodes", 1))
	}
	if s.BrokerNodeGroupInfo != nil {
		if err := s.BrokerNodeGroupInfo.Validate(); err != nil {
			invalidParams.AddNested("BrokerNodeGroupInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.ConfigurationInfo != nil {
		if err := s.ConfigurationInfo.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionInfo != nil {
		if err := s.EncryptionInfo.Validate(); err != nil {
			invalidParams.AddNested("EncryptionInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.LoggingInfo != nil {
		if err := s.LoggingInfo.Validate(); err != nil {
			invalidParams.AddNested("LoggingInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.OpenMonitoring != nil {
		if err := s.OpenMonitoring.Validate(); err != nil {
			invalidParams.AddNested("OpenMonitoring", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerNodeGroupInfo sets the BrokerNodeGroupInfo field's value.
func (s *CreateClusterInput) SetBrokerNodeGroupInfo(v *BrokerNodeGroupInfo) *CreateClusterInput {
	s.BrokerNodeGroupInfo = v
	return s
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *CreateClusterInput) SetClientAuthentication(v *ClientAuthentication) *CreateClusterInput {
	s.ClientAuthentication = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterInput) SetClusterName(v string) *CreateClusterInput {
	s.ClusterName = &v
	return s
}

// SetConfigurationInfo sets the ConfigurationInfo field's value.
func (s *CreateClusterInput) SetConfigurationInfo(v *ConfigurationInfo) *CreateClusterInput {
	s.ConfigurationInfo = v
	return s
}

// SetEncryptionInfo sets the EncryptionInfo field's value.
func (s *CreateClusterInput) SetEncryptionInfo(v *EncryptionInfo) *CreateClusterInput {
	s.EncryptionInfo = v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *CreateClusterInput) SetEnhancedMonitoring(v string) *CreateClusterInput {
	s.EnhancedMonitoring = &v
	return s
}

// SetKafkaVersion sets the KafkaVersion field's value.
func (s *CreateClusterInput) SetKafkaVersion(v string) *CreateClusterInput {
	s.KafkaVersion = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *CreateClusterInput) SetLoggingInfo(v *LoggingInfo) *CreateClusterInput {
	s.LoggingInfo = v
	return s
}

// SetNumberOfBrokerNodes sets the NumberOfBrokerNodes field's value.
func (s *CreateClusterInput) SetNumberOfBrokerNodes(v int64) *CreateClusterInput {
	s.NumberOfBrokerNodes = &v
	return s
}

// SetOpenMonitoring sets the OpenMonitoring field's value.
func (s *CreateClusterInput) SetOpenMonitoring(v *OpenMonitoringInfo) *CreateClusterInput {
	s.OpenMonitoring = v
	return s
}

// SetStorageMode sets the StorageMode field's value.
func (s *CreateClusterInput) SetStorageMode(v string) *CreateClusterInput {
	s.StorageMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v map[string]*string) *CreateClusterInput {
	s.Tags = v
	return s
}

// Returns information about the created cluster.
type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The name of the MSK cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The state of the cluster. The possible states are ACTIVE, CREATING, DELETING,
	// FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *CreateClusterOutput) SetClusterArn(v string) *CreateClusterOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterOutput) SetClusterName(v string) *CreateClusterOutput {
	s.ClusterName = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateClusterOutput) SetState(v string) *CreateClusterOutput {
	s.State = &v
	return s
}

// Creates a new Amazon MSK cluster of either the provisioned or the serverless
// type.
type CreateClusterV2Input struct {
	_ struct{} `type:"structure"`

	// ClusterName is a required field
	ClusterName *string `locationName:"clusterName" min:"1" type:"string" required:"true"`

	// Creates a provisioned cluster.
	Provisioned *ProvisionedRequest `locationName:"provisioned" type:"structure"`

	// Creates a serverless cluster.
	Serverless *ServerlessRequest `locationName:"serverless" type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterV2Input"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.Provisioned != nil {
		if err := s.Provisioned.Validate(); err != nil {
			invalidParams.AddNested("Provisioned", err.(request.ErrInvalidParams))
		}
	}
	if s.Serverless != nil {
		if err := s.Serverless.Validate(); err != nil {
			invalidParams.AddNested("Serverless", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterV2Input) SetClusterName(v string) *CreateClusterV2Input {
	s.ClusterName = &v
	return s
}

// SetProvisioned sets the Provisioned field's value.
func (s *CreateClusterV2Input) SetProvisioned(v *ProvisionedRequest) *CreateClusterV2Input {
	s.Provisioned = v
	return s
}

// SetServerless sets the Serverless field's value.
func (s *CreateClusterV2Input) SetServerless(v *ServerlessRequest) *CreateClusterV2Input {
	s.Serverless = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterV2Input) SetTags(v map[string]*string) *CreateClusterV2Input {
	s.Tags = v
	return s
}

// Returns information about the created cluster of either the provisioned or
// the serverless type.
type CreateClusterV2Output struct {
	_ struct{} `type:"structure"`

	ClusterArn *string `locationName:"clusterArn" type:"string"`

	ClusterName *string `locationName:"clusterName" type:"string"`

	ClusterType *string `locationName:"clusterType" type:"string" enum:"ClusterType"`

	// The state of the cluster. The possible states are ACTIVE, CREATING, DELETING,
	// FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterV2Output) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *CreateClusterV2Output) SetClusterArn(v string) *CreateClusterV2Output {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterV2Output) SetClusterName(v string) *CreateClusterV2Output {
	s.ClusterName = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *CreateClusterV2Output) SetClusterType(v string) *CreateClusterV2Output {
	s.ClusterType = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateClusterV2Output) SetState(v string) *CreateClusterV2Output {
	s.State = &v
	return s
}

// Request body for CreateConfiguration.
type CreateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The description of the configuration.
	Description *string `locationName:"description" type:"string"`

	// The versions of Apache Kafka with which you can use this MSK configuration.
	KafkaVersions []*string `locationName:"kafkaVersions" type:"list"`

	// The name of the configuration. Configuration names are strings that match
	// the regex "^[0-9A-Za-z-]+$".
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// ServerProperties is automatically base64 encoded/decoded by the SDK.
	//
	// ServerProperties is a required field
	ServerProperties []byte `locationName:"serverProperties" type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ServerProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateConfigurationInput) SetDescription(v string) *CreateConfigurationInput {
	s.Description = &v
	return s
}

// SetKafkaVersions sets the KafkaVersions field's value.
func (s *CreateConfigurationInput) SetKafkaVersions(v []*string) *CreateConfigurationInput {
	s.KafkaVersions = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfigurationInput) SetName(v string) *CreateConfigurationInput {
	s.Name = &v
	return s
}

// SetServerProperties sets the ServerProperties field's value.
func (s *CreateConfigurationInput) SetServerProperties(v []byte) *CreateConfigurationInput {
	s.ServerProperties = v
	return s
}

// Response body for CreateConfiguration
type CreateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The time when the configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Latest revision of the configuration.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`

	// The name of the configuration. Configuration names are strings that match
	// the regex "^[0-9A-Za-z-]+$".
	Name *string `locationName:"name" type:"string"`

	// The state of the configuration. The possible states are ACTIVE, DELETING
	// and DELETE_FAILED.
	State *string `locationName:"state" type:"string" enum:"ConfigurationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateConfigurationOutput) SetArn(v string) *CreateConfigurationOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateConfigurationOutput) SetCreationTime(v time.Time) *CreateConfigurationOutput {
	s.CreationTime = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *CreateConfigurationOutput) SetLatestRevision(v *ConfigurationRevision) *CreateConfigurationOutput {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfigurationOutput) SetName(v string) *CreateConfigurationOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateConfigurationOutput) SetState(v string) *CreateConfigurationOutput {
	s.State = &v
	return s
}

// Request body for CreateVpcConnection.
type CreateVpcConnectionInput struct {
	_ struct{} `type:"structure"`

	// Authentication is a required field
	Authentication *string `locationName:"authentication" type:"string" required:"true"`

	// The list of subnets in the client VPC.
	//
	// ClientSubnets is a required field
	ClientSubnets []*string `locationName:"clientSubnets" type:"list" required:"true"`

	// The list of security groups to attach to the VPC connection.
	//
	// SecurityGroups is a required field
	SecurityGroups []*string `locationName:"securityGroups" type:"list" required:"true"`

	// Create tags when creating the VPC connection.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Amazon Resource Name (ARN) of the cluster.
	//
	// TargetClusterArn is a required field
	TargetClusterArn *string `locationName:"targetClusterArn" type:"string" required:"true"`

	// The VPC ID of the VPC connection.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcConnectionInput"}
	if s.Authentication == nil {
		invalidParams.Add(request.NewErrParamRequired("Authentication"))
	}
	if s.ClientSubnets == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSubnets"))
	}
	if s.SecurityGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroups"))
	}
	if s.TargetClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetClusterArn"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthentication sets the Authentication field's value.
func (s *CreateVpcConnectionInput) SetAuthentication(v string) *CreateVpcConnectionInput {
	s.Authentication = &v
	return s
}

// SetClientSubnets sets the ClientSubnets field's value.
func (s *CreateVpcConnectionInput) SetClientSubnets(v []*string) *CreateVpcConnectionInput {
	s.ClientSubnets = v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *CreateVpcConnectionInput) SetSecurityGroups(v []*string) *CreateVpcConnectionInput {
	s.SecurityGroups = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVpcConnectionInput) SetTags(v map[string]*string) *CreateVpcConnectionInput {
	s.Tags = v
	return s
}

// SetTargetClusterArn sets the TargetClusterArn field's value.
func (s *CreateVpcConnectionInput) SetTargetClusterArn(v string) *CreateVpcConnectionInput {
	s.TargetClusterArn = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateVpcConnectionInput) SetVpcId(v string) *CreateVpcConnectionInput {
	s.VpcId = &v
	return s
}

// Response body for CreateVpcConnection
type CreateVpcConnectionOutput struct {
	_ struct{} `type:"structure"`

	Authentication *string `locationName:"authentication" type:"string"`

	// The list of subnets in the client VPC.
	ClientSubnets []*string `locationName:"clientSubnets" type:"list"`

	// The time when the VPC connection was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The list of security groups attached to the VPC connection.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// The state of the VPC connection. The only possible state is CREATING.
	State *string `locationName:"state" type:"string" enum:"VpcConnectionState"`

	// Tags attached to the VPC connection.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Amazon Resource Name (ARN) of the VPC connection.
	VpcConnectionArn *string `locationName:"vpcConnectionArn" type:"string"`

	// The VPC ID of the VPC connection.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcConnectionOutput) GoString() string {
	return s.String()
}

// SetAuthentication sets the Authentication field's value.
func (s *CreateVpcConnectionOutput) SetAuthentication(v string) *CreateVpcConnectionOutput {
	s.Authentication = &v
	return s
}

// SetClientSubnets sets the ClientSubnets field's value.
func (s *CreateVpcConnectionOutput) SetClientSubnets(v []*string) *CreateVpcConnectionOutput {
	s.ClientSubnets = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateVpcConnectionOutput) SetCreationTime(v time.Time) *CreateVpcConnectionOutput {
	s.CreationTime = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *CreateVpcConnectionOutput) SetSecurityGroups(v []*string) *CreateVpcConnectionOutput {
	s.SecurityGroups = v
	return s
}

// SetState sets the State field's value.
func (s *CreateVpcConnectionOutput) SetState(v string) *CreateVpcConnectionOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVpcConnectionOutput) SetTags(v map[string]*string) *CreateVpcConnectionOutput {
	s.Tags = v
	return s
}

// SetVpcConnectionArn sets the VpcConnectionArn field's value.
func (s *CreateVpcConnectionOutput) SetVpcConnectionArn(v string) *CreateVpcConnectionOutput {
	s.VpcConnectionArn = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateVpcConnectionOutput) SetVpcId(v string) *CreateVpcConnectionOutput {
	s.VpcId = &v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	CurrentVersion *string `location:"querystring" locationName:"currentVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DeleteClusterInput) SetClusterArn(v string) *DeleteClusterInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *DeleteClusterInput) SetCurrentVersion(v string) *DeleteClusterInput {
	s.CurrentVersion = &v
	return s
}

// Returns information about the deleted cluster.
type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The state of the cluster. The possible states are ACTIVE, CREATING, DELETING,
	// FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DeleteClusterOutput) SetClusterArn(v string) *DeleteClusterOutput {
	s.ClusterArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteClusterOutput) SetState(v string) *DeleteClusterOutput {
	s.State = &v
	return s
}

// Request body for DeleteClusterPolicy.
type DeleteClusterPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterPolicyInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DeleteClusterPolicyInput) SetClusterArn(v string) *DeleteClusterPolicyInput {
	s.ClusterArn = &v
	return s
}

// Response body for DeleteClusterPolicy.
type DeleteClusterPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterPolicyOutput) GoString() string {
	return s.String()
}

// Request body for DeleteConfiguration.
type DeleteConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the configuration.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteConfigurationInput) SetArn(v string) *DeleteConfigurationInput {
	s.Arn = &v
	return s
}

// Response body for DeleteConfiguration.
type DeleteConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The state of the configuration. The possible states are ACTIVE, DELETING
	// and DELETE_FAILED.
	State *string `locationName:"state" type:"string" enum:"ConfigurationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteConfigurationOutput) SetArn(v string) *DeleteConfigurationOutput {
	s.Arn = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteConfigurationOutput) SetState(v string) *DeleteConfigurationOutput {
	s.State = &v
	return s
}

// Request body for DeleteVpcConnection.
type DeleteVpcConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcConnectionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteVpcConnectionInput) SetArn(v string) *DeleteVpcConnectionInput {
	s.Arn = &v
	return s
}

// Response body for DeleteVpcConnection.
type DeleteVpcConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The state of the VPC connection. The only possible state is DELETING.
	State *string `locationName:"state" type:"string" enum:"VpcConnectionState"`

	// The Amazon Resource Name (ARN) of the VPC connection.
	VpcConnectionArn *string `locationName:"vpcConnectionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcConnectionOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *DeleteVpcConnectionOutput) SetState(v string) *DeleteVpcConnectionOutput {
	s.State = &v
	return s
}

// SetVpcConnectionArn sets the VpcConnectionArn field's value.
func (s *DeleteVpcConnectionOutput) SetVpcConnectionArn(v string) *DeleteVpcConnectionOutput {
	s.VpcConnectionArn = &v
	return s
}

type DescribeClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DescribeClusterInput) SetClusterArn(v string) *DescribeClusterInput {
	s.ClusterArn = &v
	return s
}

type DescribeClusterOperationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterOperationArn is a required field
	ClusterOperationArn *string `location:"uri" locationName:"clusterOperationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterOperationInput"}
	if s.ClusterOperationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterOperationArn"))
	}
	if s.ClusterOperationArn != nil && len(*s.ClusterOperationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterOperationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *DescribeClusterOperationInput) SetClusterOperationArn(v string) *DescribeClusterOperationInput {
	s.ClusterOperationArn = &v
	return s
}

// Information about a cluster operation.
type DescribeClusterOperationOutput struct {
	_ struct{} `type:"structure"`

	// Cluster operation information
	ClusterOperationInfo *ClusterOperationInfo `locationName:"clusterOperationInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOperationOutput) GoString() string {
	return s.String()
}

// SetClusterOperationInfo sets the ClusterOperationInfo field's value.
func (s *DescribeClusterOperationOutput) SetClusterOperationInfo(v *ClusterOperationInfo) *DescribeClusterOperationOutput {
	s.ClusterOperationInfo = v
	return s
}

type DescribeClusterOperationV2Input struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterOperationArn is a required field
	ClusterOperationArn *string `location:"uri" locationName:"clusterOperationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOperationV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOperationV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterOperationV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterOperationV2Input"}
	if s.ClusterOperationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterOperationArn"))
	}
	if s.ClusterOperationArn != nil && len(*s.ClusterOperationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterOperationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *DescribeClusterOperationV2Input) SetClusterOperationArn(v string) *DescribeClusterOperationV2Input {
	s.ClusterOperationArn = &v
	return s
}

// Information about a cluster operation.
type DescribeClusterOperationV2Output struct {
	_ struct{} `type:"structure"`

	// Cluster operation information
	ClusterOperationInfo *ClusterOperationV2 `locationName:"clusterOperationInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOperationV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOperationV2Output) GoString() string {
	return s.String()
}

// SetClusterOperationInfo sets the ClusterOperationInfo field's value.
func (s *DescribeClusterOperationV2Output) SetClusterOperationInfo(v *ClusterOperationV2) *DescribeClusterOperationV2Output {
	s.ClusterOperationInfo = v
	return s
}

// Returns information about a cluster.
type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// The cluster information.
	ClusterInfo *ClusterInfo `locationName:"clusterInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// SetClusterInfo sets the ClusterInfo field's value.
func (s *DescribeClusterOutput) SetClusterInfo(v *ClusterInfo) *DescribeClusterOutput {
	s.ClusterInfo = v
	return s
}

type DescribeClusterV2Input struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterV2Input"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DescribeClusterV2Input) SetClusterArn(v string) *DescribeClusterV2Input {
	s.ClusterArn = &v
	return s
}

// Returns information about a cluster of either the provisioned or the serverless
// type.
type DescribeClusterV2Output struct {
	_ struct{} `type:"structure"`

	// The cluster information.
	ClusterInfo *Cluster `locationName:"clusterInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterV2Output) GoString() string {
	return s.String()
}

// SetClusterInfo sets the ClusterInfo field's value.
func (s *DescribeClusterV2Output) SetClusterInfo(v *Cluster) *DescribeClusterV2Output {
	s.ClusterInfo = v
	return s
}

type DescribeConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DescribeConfigurationInput) SetArn(v string) *DescribeConfigurationInput {
	s.Arn = &v
	return s
}

// Response body for DescribeConfiguration.
type DescribeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The time when the configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the configuration.
	Description *string `locationName:"description" type:"string"`

	// The versions of Apache Kafka with which you can use this MSK configuration.
	KafkaVersions []*string `locationName:"kafkaVersions" type:"list"`

	// Latest revision of the configuration.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`

	// The name of the configuration. Configuration names are strings that match
	// the regex "^[0-9A-Za-z-]+$".
	Name *string `locationName:"name" type:"string"`

	// The state of the configuration. The possible states are ACTIVE, DELETING
	// and DELETE_FAILED.
	State *string `locationName:"state" type:"string" enum:"ConfigurationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeConfigurationOutput) SetArn(v string) *DescribeConfigurationOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeConfigurationOutput) SetCreationTime(v time.Time) *DescribeConfigurationOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeConfigurationOutput) SetDescription(v string) *DescribeConfigurationOutput {
	s.Description = &v
	return s
}

// SetKafkaVersions sets the KafkaVersions field's value.
func (s *DescribeConfigurationOutput) SetKafkaVersions(v []*string) *DescribeConfigurationOutput {
	s.KafkaVersions = v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *DescribeConfigurationOutput) SetLatestRevision(v *ConfigurationRevision) *DescribeConfigurationOutput {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeConfigurationOutput) SetName(v string) *DescribeConfigurationOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeConfigurationOutput) SetState(v string) *DescribeConfigurationOutput {
	s.State = &v
	return s
}

type DescribeConfigurationRevisionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	// Revision is a required field
	Revision *int64 `location:"uri" locationName:"revision" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationRevisionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DescribeConfigurationRevisionInput) SetArn(v string) *DescribeConfigurationRevisionInput {
	s.Arn = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *DescribeConfigurationRevisionInput) SetRevision(v int64) *DescribeConfigurationRevisionInput {
	s.Revision = &v
	return s
}

// Response body for DescribeConfigurationRevision.
type DescribeConfigurationRevisionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The time when the configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the configuration.
	Description *string `locationName:"description" type:"string"`

	// The revision number.
	Revision *int64 `locationName:"revision" type:"long"`

	// ServerProperties is automatically base64 encoded/decoded by the SDK.
	ServerProperties []byte `locationName:"serverProperties" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRevisionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeConfigurationRevisionOutput) SetArn(v string) *DescribeConfigurationRevisionOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeConfigurationRevisionOutput) SetCreationTime(v time.Time) *DescribeConfigurationRevisionOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeConfigurationRevisionOutput) SetDescription(v string) *DescribeConfigurationRevisionOutput {
	s.Description = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *DescribeConfigurationRevisionOutput) SetRevision(v int64) *DescribeConfigurationRevisionOutput {
	s.Revision = &v
	return s
}

// SetServerProperties sets the ServerProperties field's value.
func (s *DescribeConfigurationRevisionOutput) SetServerProperties(v []byte) *DescribeConfigurationRevisionOutput {
	s.ServerProperties = v
	return s
}

type DescribeVpcConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVpcConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVpcConnectionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DescribeVpcConnectionInput) SetArn(v string) *DescribeVpcConnectionInput {
	s.Arn = &v
	return s
}

// Response body for DescribeVpcConnection.
type DescribeVpcConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The authentication type of the VPC connection.
	Authentication *string `locationName:"authentication" type:"string"`

	// The creation time of the VPC connection.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The list of security groups attached to the VPC connection.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// The state of the VPC connection. The possible states are AVAILABLE, INACTIVE,
	// DEACTIVATING, DELETING, CREATING, REJECTING, REJECTED and FAILED.
	State *string `locationName:"state" type:"string" enum:"VpcConnectionState"`

	// The list of subnets in the client VPC.
	Subnets []*string `locationName:"subnets" type:"list"`

	// Tags attached to the VPC connection.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Amazon Resource Name (ARN) of the cluster.
	TargetClusterArn *string `locationName:"targetClusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the VPC connection.
	VpcConnectionArn *string `locationName:"vpcConnectionArn" type:"string"`

	// The VPC ID of the VPC connection.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcConnectionOutput) GoString() string {
	return s.String()
}

// SetAuthentication sets the Authentication field's value.
func (s *DescribeVpcConnectionOutput) SetAuthentication(v string) *DescribeVpcConnectionOutput {
	s.Authentication = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeVpcConnectionOutput) SetCreationTime(v time.Time) *DescribeVpcConnectionOutput {
	s.CreationTime = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *DescribeVpcConnectionOutput) SetSecurityGroups(v []*string) *DescribeVpcConnectionOutput {
	s.SecurityGroups = v
	return s
}

// SetState sets the State field's value.
func (s *DescribeVpcConnectionOutput) SetState(v string) *DescribeVpcConnectionOutput {
	s.State = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *DescribeVpcConnectionOutput) SetSubnets(v []*string) *DescribeVpcConnectionOutput {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeVpcConnectionOutput) SetTags(v map[string]*string) *DescribeVpcConnectionOutput {
	s.Tags = v
	return s
}

// SetTargetClusterArn sets the TargetClusterArn field's value.
func (s *DescribeVpcConnectionOutput) SetTargetClusterArn(v string) *DescribeVpcConnectionOutput {
	s.TargetClusterArn = &v
	return s
}

// SetVpcConnectionArn sets the VpcConnectionArn field's value.
func (s *DescribeVpcConnectionOutput) SetVpcConnectionArn(v string) *DescribeVpcConnectionOutput {
	s.VpcConnectionArn = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DescribeVpcConnectionOutput) SetVpcId(v string) *DescribeVpcConnectionOutput {
	s.VpcId = &v
	return s
}

// Contains information about the EBS storage volumes attached to Apache Kafka
// broker nodes.
type EBSStorageInfo struct {
	_ struct{} `type:"structure"`

	// EBS volume provisioned throughput information.
	ProvisionedThroughput *ProvisionedThroughput `locationName:"provisionedThroughput" type:"structure"`

	// The size in GiB of the EBS volume for the data drive on each broker node.
	VolumeSize *int64 `locationName:"volumeSize" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSStorageInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSStorageInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EBSStorageInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EBSStorageInfo"}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VolumeSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *EBSStorageInfo) SetProvisionedThroughput(v *ProvisionedThroughput) *EBSStorageInfo {
	s.ProvisionedThroughput = v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EBSStorageInfo) SetVolumeSize(v int64) *EBSStorageInfo {
	s.VolumeSize = &v
	return s
}

// The data-volume encryption details.
type EncryptionAtRest struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS KMS key for encrypting data at rest. If you don't specify
	// a KMS key, MSK creates one for you and uses it.
	//
	// DataVolumeKMSKeyId is a required field
	DataVolumeKMSKeyId *string `locationName:"dataVolumeKMSKeyId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionAtRest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionAtRest"}
	if s.DataVolumeKMSKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataVolumeKMSKeyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataVolumeKMSKeyId sets the DataVolumeKMSKeyId field's value.
func (s *EncryptionAtRest) SetDataVolumeKMSKeyId(v string) *EncryptionAtRest {
	s.DataVolumeKMSKeyId = &v
	return s
}

// The settings for encrypting data in transit.
type EncryptionInTransit struct {
	_ struct{} `type:"structure"`

	// Indicates the encryption setting for data in transit between clients and
	// brokers. You must set it to one of the following values.
	//
	// TLS means that client-broker communication is enabled with TLS only.
	//
	// TLS_PLAINTEXT means that client-broker communication is enabled for both
	// TLS-encrypted, as well as plaintext data.
	//
	// PLAINTEXT means that client-broker communication is enabled in plaintext
	// only.
	//
	// The default value is TLS.
	ClientBroker *string `locationName:"clientBroker" type:"string" enum:"ClientBroker"`

	// When set to true, it indicates that data communication among the broker nodes
	// of the cluster is encrypted. When set to false, the communication happens
	// in plaintext.
	//
	// The default value is true.
	InCluster *bool `locationName:"inCluster" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionInTransit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionInTransit) GoString() string {
	return s.String()
}

// SetClientBroker sets the ClientBroker field's value.
func (s *EncryptionInTransit) SetClientBroker(v string) *EncryptionInTransit {
	s.ClientBroker = &v
	return s
}

// SetInCluster sets the InCluster field's value.
func (s *EncryptionInTransit) SetInCluster(v bool) *EncryptionInTransit {
	s.InCluster = &v
	return s
}

// Includes encryption-related information, such as the AWS KMS key used for
// encrypting data at rest and whether you want MSK to encrypt your data in
// transit.
type EncryptionInfo struct {
	_ struct{} `type:"structure"`

	// The data-volume encryption details.
	EncryptionAtRest *EncryptionAtRest `locationName:"encryptionAtRest" type:"structure"`

	// The details for encryption in transit.
	EncryptionInTransit *EncryptionInTransit `locationName:"encryptionInTransit" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionInfo"}
	if s.EncryptionAtRest != nil {
		if err := s.EncryptionAtRest.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionAtRest sets the EncryptionAtRest field's value.
func (s *EncryptionInfo) SetEncryptionAtRest(v *EncryptionAtRest) *EncryptionInfo {
	s.EncryptionAtRest = v
	return s
}

// SetEncryptionInTransit sets the EncryptionInTransit field's value.
func (s *EncryptionInfo) SetEncryptionInTransit(v *EncryptionInTransit) *EncryptionInfo {
	s.EncryptionInTransit = v
	return s
}

// Returns information about an error state of the cluster.
type ErrorInfo struct {
	_ struct{} `type:"structure"`

	// A number describing the error programmatically.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// An optional field to provide more details about the error.
	ErrorString *string `locationName:"errorString" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorInfo) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorInfo) SetErrorCode(v string) *ErrorInfo {
	s.ErrorCode = &v
	return s
}

// SetErrorString sets the ErrorString field's value.
func (s *ErrorInfo) SetErrorString(v string) *ErrorInfo {
	s.ErrorString = &v
	return s
}

// Firehose details for BrokerLogs.
type Firehose struct {
	_ struct{} `type:"structure"`

	// The Kinesis Data Firehose delivery stream that is the destination for broker
	// logs.
	DeliveryStream *string `locationName:"deliveryStream" type:"string"`

	// Specifies whether broker logs get sent to the specified Kinesis Data Firehose
	// delivery stream.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Firehose) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Firehose) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Firehose) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Firehose"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStream sets the DeliveryStream field's value.
func (s *Firehose) SetDeliveryStream(v string) *Firehose {
	s.DeliveryStream = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *Firehose) SetEnabled(v bool) *Firehose {
	s.Enabled = &v
	return s
}

// Returns information about an error.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetBootstrapBrokersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBootstrapBrokersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBootstrapBrokersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBootstrapBrokersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBootstrapBrokersInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *GetBootstrapBrokersInput) SetClusterArn(v string) *GetBootstrapBrokersInput {
	s.ClusterArn = &v
	return s
}

// Returns a string containing one or more hostname:port pairs.
type GetBootstrapBrokersOutput struct {
	_ struct{} `type:"structure"`

	// A string containing one or more hostname:port pairs.
	BootstrapBrokerString *string `locationName:"bootstrapBrokerString" type:"string"`

	// A string that contains one or more DNS names (or IP addresses) and SASL IAM
	// port pairs. The following is an example.
	//  { "BootstrapBrokerStringSaslIam": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198"}
	BootstrapBrokerStringPublicSaslIam *string `locationName:"bootstrapBrokerStringPublicSaslIam" type:"string"`

	// A string containing one or more DNS names (or IP addresses) and SASL SCRAM
	// port pairs. The following is an example.
	//  { "BootstrapBrokerStringSaslScram": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196"}
	BootstrapBrokerStringPublicSaslScram *string `locationName:"bootstrapBrokerStringPublicSaslScram" type:"string"`

	// A string containing one or more DNS names (or IP addresses) and TLS port
	// pairs. The following is an example.
	//  { "BootstrapBrokerStringTls": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194"}
	BootstrapBrokerStringPublicTls *string `locationName:"bootstrapBrokerStringPublicTls" type:"string"`

	// A string that contains one or more DNS names (or IP addresses) and SASL IAM
	// port pairs. The following is an example.
	//  { "BootstrapBrokerStringSaslIam": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098"}
	BootstrapBrokerStringSaslIam *string `locationName:"bootstrapBrokerStringSaslIam" type:"string"`

	// A string containing one or more DNS names (or IP addresses) and SASL SCRAM
	// port pairs. The following is an example.
	//  { "BootstrapBrokerStringSaslScram": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096"}
	BootstrapBrokerStringSaslScram *string `locationName:"bootstrapBrokerStringSaslScram" type:"string"`

	// A string containing one or more DNS names (or IP addresses) and TLS port
	// pairs. The following is an example.
	//  { "BootstrapBrokerStringTls": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094"}
	BootstrapBrokerStringTls *string `locationName:"bootstrapBrokerStringTls" type:"string"`

	// A string containing one or more dns name (or IP) and SASL IAM port pairs
	// for VPC connectivity.
	BootstrapBrokerStringVpcConnectivitySaslIam *string `locationName:"bootstrapBrokerStringVpcConnectivitySaslIam" type:"string"`

	// A string containing one or more dns name (or IP) and SASL SCRAM port pairs
	// for VPC connectivity.
	BootstrapBrokerStringVpcConnectivitySaslScram *string `locationName:"bootstrapBrokerStringVpcConnectivitySaslScram" type:"string"`

	// A string containing one or more dns name (or IP) and Tls port pairs for VPC
	// connectivity.
	BootstrapBrokerStringVpcConnectivityTls *string `locationName:"bootstrapBrokerStringVpcConnectivityTls" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBootstrapBrokersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBootstrapBrokersOutput) GoString() string {
	return s.String()
}

// SetBootstrapBrokerString sets the BootstrapBrokerString field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerString(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerString = &v
	return s
}

// SetBootstrapBrokerStringPublicSaslIam sets the BootstrapBrokerStringPublicSaslIam field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerStringPublicSaslIam(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerStringPublicSaslIam = &v
	return s
}

// SetBootstrapBrokerStringPublicSaslScram sets the BootstrapBrokerStringPublicSaslScram field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerStringPublicSaslScram(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerStringPublicSaslScram = &v
	return s
}

// SetBootstrapBrokerStringPublicTls sets the BootstrapBrokerStringPublicTls field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerStringPublicTls(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerStringPublicTls = &v
	return s
}

// SetBootstrapBrokerStringSaslIam sets the BootstrapBrokerStringSaslIam field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerStringSaslIam(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerStringSaslIam = &v
	return s
}

// SetBootstrapBrokerStringSaslScram sets the BootstrapBrokerStringSaslScram field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerStringSaslScram(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerStringSaslScram = &v
	return s
}

// SetBootstrapBrokerStringTls sets the BootstrapBrokerStringTls field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerStringTls(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerStringTls = &v
	return s
}

// SetBootstrapBrokerStringVpcConnectivitySaslIam sets the BootstrapBrokerStringVpcConnectivitySaslIam field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerStringVpcConnectivitySaslIam(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerStringVpcConnectivitySaslIam = &v
	return s
}

// SetBootstrapBrokerStringVpcConnectivitySaslScram sets the BootstrapBrokerStringVpcConnectivitySaslScram field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerStringVpcConnectivitySaslScram(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerStringVpcConnectivitySaslScram = &v
	return s
}

// SetBootstrapBrokerStringVpcConnectivityTls sets the BootstrapBrokerStringVpcConnectivityTls field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerStringVpcConnectivityTls(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerStringVpcConnectivityTls = &v
	return s
}

// Request body for GetClusterPolicy.
type GetClusterPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClusterPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetClusterPolicyInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *GetClusterPolicyInput) SetClusterArn(v string) *GetClusterPolicyInput {
	s.ClusterArn = &v
	return s
}

// Returns information about the specified cluster policy.
type GetClusterPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Cluster policy version.
	CurrentVersion *string `locationName:"currentVersion" type:"string"`

	// Cluster policy attached to the MSK cluster.
	Policy *string `locationName:"policy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterPolicyOutput) GoString() string {
	return s.String()
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *GetClusterPolicyOutput) SetCurrentVersion(v string) *GetClusterPolicyOutput {
	s.CurrentVersion = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *GetClusterPolicyOutput) SetPolicy(v string) *GetClusterPolicyOutput {
	s.Policy = &v
	return s
}

type GetCompatibleKafkaVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	ClusterArn *string `location:"querystring" locationName:"clusterArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleKafkaVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleKafkaVersionsInput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *GetCompatibleKafkaVersionsInput) SetClusterArn(v string) *GetCompatibleKafkaVersionsInput {
	s.ClusterArn = &v
	return s
}

// Response body for GetCompatibleKafkaVersions.
type GetCompatibleKafkaVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of CompatibleKafkaVersion objects.
	CompatibleKafkaVersions []*CompatibleKafkaVersion `locationName:"compatibleKafkaVersions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleKafkaVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleKafkaVersionsOutput) GoString() string {
	return s.String()
}

// SetCompatibleKafkaVersions sets the CompatibleKafkaVersions field's value.
func (s *GetCompatibleKafkaVersionsOutput) SetCompatibleKafkaVersions(v []*CompatibleKafkaVersion) *GetCompatibleKafkaVersionsOutput {
	s.CompatibleKafkaVersions = v
	return s
}

type Iam struct {
	_ struct{} `type:"structure"`

	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Iam) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Iam) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *Iam) SetEnabled(v bool) *Iam {
	s.Enabled = &v
	return s
}

// Returns information about an error.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates whether you want to enable or disable the JMX Exporter.
type JmxExporter struct {
	_ struct{} `type:"structure"`

	// Indicates whether you want to enable or disable the JMX Exporter.
	//
	// EnabledInBroker is a required field
	EnabledInBroker *bool `locationName:"enabledInBroker" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JmxExporter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JmxExporter) GoString() string {
	return s.String()
}

// SetEnabledInBroker sets the EnabledInBroker field's value.
func (s *JmxExporter) SetEnabledInBroker(v bool) *JmxExporter {
	s.EnabledInBroker = &v
	return s
}

// Indicates whether you want to enable or disable the JMX Exporter.
type JmxExporterInfo struct {
	_ struct{} `type:"structure"`

	// JMX Exporter being enabled in broker.
	//
	// EnabledInBroker is a required field
	EnabledInBroker *bool `locationName:"enabledInBroker" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JmxExporterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JmxExporterInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JmxExporterInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JmxExporterInfo"}
	if s.EnabledInBroker == nil {
		invalidParams.Add(request.NewErrParamRequired("EnabledInBroker"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabledInBroker sets the EnabledInBroker field's value.
func (s *JmxExporterInfo) SetEnabledInBroker(v bool) *JmxExporterInfo {
	s.EnabledInBroker = &v
	return s
}

// Information about a Apache Kafka version.
type KafkaVersion struct {
	_ struct{} `type:"structure"`

	// The status of the Apache Kafka version.
	Status *string `locationName:"status" type:"string" enum:"KafkaVersionStatus"`

	// The Apache Kafka version.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaVersion) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *KafkaVersion) SetStatus(v string) *KafkaVersion {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *KafkaVersion) SetVersion(v string) *KafkaVersion {
	s.Version = &v
	return s
}

// Request body for ListClientVpcConnections.
type ListClientVpcConnectionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClientVpcConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClientVpcConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClientVpcConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClientVpcConnectionsInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ListClientVpcConnectionsInput) SetClusterArn(v string) *ListClientVpcConnectionsInput {
	s.ClusterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClientVpcConnectionsInput) SetMaxResults(v int64) *ListClientVpcConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClientVpcConnectionsInput) SetNextToken(v string) *ListClientVpcConnectionsInput {
	s.NextToken = &v
	return s
}

// The response contains an array of client VPC connections and a next token
// if the response is truncated.
type ListClientVpcConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// List containing a ClientVpcConnection object.
	ClientVpcConnections []*ClientVpcConnection `locationName:"clientVpcConnections" type:"list"`

	// If the response of ListClientVpcConnections is truncated, it returns a NextToken
	// in the response. This Nexttoken should be sent in the subsequent request
	// to ListClientVpcConnections.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClientVpcConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClientVpcConnectionsOutput) GoString() string {
	return s.String()
}

// SetClientVpcConnections sets the ClientVpcConnections field's value.
func (s *ListClientVpcConnectionsOutput) SetClientVpcConnections(v []*ClientVpcConnection) *ListClientVpcConnectionsOutput {
	s.ClientVpcConnections = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClientVpcConnectionsOutput) SetNextToken(v string) *ListClientVpcConnectionsOutput {
	s.NextToken = &v
	return s
}

type ListClusterOperationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClusterOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClusterOperationsInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ListClusterOperationsInput) SetClusterArn(v string) *ListClusterOperationsInput {
	s.ClusterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClusterOperationsInput) SetMaxResults(v int64) *ListClusterOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterOperationsInput) SetNextToken(v string) *ListClusterOperationsInput {
	s.NextToken = &v
	return s
}

// The response contains an array containing cluster operation information and
// a next token if the response is truncated.
type ListClusterOperationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of cluster operation information objects.
	ClusterOperationInfoList []*ClusterOperationInfo `locationName:"clusterOperationInfoList" type:"list"`

	// If the response of ListClusterOperations is truncated, it returns a NextToken
	// in the response. This Nexttoken should be sent in the subsequent request
	// to ListClusterOperations.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterOperationsOutput) GoString() string {
	return s.String()
}

// SetClusterOperationInfoList sets the ClusterOperationInfoList field's value.
func (s *ListClusterOperationsOutput) SetClusterOperationInfoList(v []*ClusterOperationInfo) *ListClusterOperationsOutput {
	s.ClusterOperationInfoList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterOperationsOutput) SetNextToken(v string) *ListClusterOperationsOutput {
	s.NextToken = &v
	return s
}

type ListClusterOperationsV2Input struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterOperationsV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterOperationsV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClusterOperationsV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClusterOperationsV2Input"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ListClusterOperationsV2Input) SetClusterArn(v string) *ListClusterOperationsV2Input {
	s.ClusterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClusterOperationsV2Input) SetMaxResults(v int64) *ListClusterOperationsV2Input {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterOperationsV2Input) SetNextToken(v string) *ListClusterOperationsV2Input {
	s.NextToken = &v
	return s
}

// The response contains an array containing cluster operation information and
// a next token if the response is truncated.
type ListClusterOperationsV2Output struct {
	_ struct{} `type:"structure"`

	ClusterOperationInfoList []*ClusterOperationV2Summary `locationName:"clusterOperationInfoList" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterOperationsV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterOperationsV2Output) GoString() string {
	return s.String()
}

// SetClusterOperationInfoList sets the ClusterOperationInfoList field's value.
func (s *ListClusterOperationsV2Output) SetClusterOperationInfoList(v []*ClusterOperationV2Summary) *ListClusterOperationsV2Output {
	s.ClusterOperationInfoList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterOperationsV2Output) SetNextToken(v string) *ListClusterOperationsV2Output {
	s.NextToken = &v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	ClusterNameFilter *string `location:"querystring" locationName:"clusterNameFilter" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterNameFilter sets the ClusterNameFilter field's value.
func (s *ListClustersInput) SetClusterNameFilter(v string) *ListClustersInput {
	s.ClusterNameFilter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

// The response contains an array containing cluster information and a next
// token if the response is truncated.
type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// Information on each of the MSK clusters in the response.
	ClusterInfoList []*ClusterInfo `locationName:"clusterInfoList" type:"list"`

	// The paginated results marker. When the result of a ListClusters operation
	// is truncated, the call returns NextToken in the response. To get another
	// batch of clusters, provide this token in your next request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusterInfoList sets the ClusterInfoList field's value.
func (s *ListClustersOutput) SetClusterInfoList(v []*ClusterInfo) *ListClustersOutput {
	s.ClusterInfoList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListClustersV2Input struct {
	_ struct{} `type:"structure" nopayload:"true"`

	ClusterNameFilter *string `location:"querystring" locationName:"clusterNameFilter" type:"string"`

	ClusterTypeFilter *string `location:"querystring" locationName:"clusterTypeFilter" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersV2Input"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterNameFilter sets the ClusterNameFilter field's value.
func (s *ListClustersV2Input) SetClusterNameFilter(v string) *ListClustersV2Input {
	s.ClusterNameFilter = &v
	return s
}

// SetClusterTypeFilter sets the ClusterTypeFilter field's value.
func (s *ListClustersV2Input) SetClusterTypeFilter(v string) *ListClustersV2Input {
	s.ClusterTypeFilter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersV2Input) SetMaxResults(v int64) *ListClustersV2Input {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersV2Input) SetNextToken(v string) *ListClustersV2Input {
	s.NextToken = &v
	return s
}

// The response contains an array containing cluster information and a next
// token if the response is truncated.
type ListClustersV2Output struct {
	_ struct{} `type:"structure"`

	// Information on each of the MSK clusters in the response.
	ClusterInfoList []*Cluster `locationName:"clusterInfoList" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersV2Output) GoString() string {
	return s.String()
}

// SetClusterInfoList sets the ClusterInfoList field's value.
func (s *ListClustersV2Output) SetClusterInfoList(v []*Cluster) *ListClustersV2Output {
	s.ClusterInfoList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersV2Output) SetNextToken(v string) *ListClustersV2Output {
	s.NextToken = &v
	return s
}

type ListConfigurationRevisionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationRevisionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationRevisionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationRevisionsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListConfigurationRevisionsInput) SetArn(v string) *ListConfigurationRevisionsInput {
	s.Arn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationRevisionsInput) SetMaxResults(v int64) *ListConfigurationRevisionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationRevisionsInput) SetNextToken(v string) *ListConfigurationRevisionsInput {
	s.NextToken = &v
	return s
}

// Information about revisions of an MSK configuration.
type ListConfigurationRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// Paginated results marker.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of ConfigurationRevision objects.
	Revisions []*ConfigurationRevision `locationName:"revisions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationRevisionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationRevisionsOutput) SetNextToken(v string) *ListConfigurationRevisionsOutput {
	s.NextToken = &v
	return s
}

// SetRevisions sets the Revisions field's value.
func (s *ListConfigurationRevisionsOutput) SetRevisions(v []*ConfigurationRevision) *ListConfigurationRevisionsOutput {
	s.Revisions = v
	return s
}

type ListConfigurationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationsInput) SetMaxResults(v int64) *ListConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationsInput) SetNextToken(v string) *ListConfigurationsInput {
	s.NextToken = &v
	return s
}

// The response contains an array of Configuration and a next token if the response
// is truncated.
type ListConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of MSK configurations.
	Configurations []*Configuration `locationName:"configurations" type:"list"`

	// The paginated results marker. When the result of a ListConfigurations operation
	// is truncated, the call returns NextToken in the response. To get another
	// batch of configurations, provide this token in your next request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationsOutput) GoString() string {
	return s.String()
}

// SetConfigurations sets the Configurations field's value.
func (s *ListConfigurationsOutput) SetConfigurations(v []*Configuration) *ListConfigurationsOutput {
	s.Configurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationsOutput) SetNextToken(v string) *ListConfigurationsOutput {
	s.NextToken = &v
	return s
}

type ListKafkaVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKafkaVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKafkaVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKafkaVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKafkaVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKafkaVersionsInput) SetMaxResults(v int64) *ListKafkaVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKafkaVersionsInput) SetNextToken(v string) *ListKafkaVersionsInput {
	s.NextToken = &v
	return s
}

// Response for ListKafkaVersions.
type ListKafkaVersionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Apache Kafka version objects.
	KafkaVersions []*KafkaVersion `locationName:"kafkaVersions" type:"list"`

	// Paginated results marker.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKafkaVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKafkaVersionsOutput) GoString() string {
	return s.String()
}

// SetKafkaVersions sets the KafkaVersions field's value.
func (s *ListKafkaVersionsOutput) SetKafkaVersions(v []*KafkaVersion) *ListKafkaVersionsOutput {
	s.KafkaVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKafkaVersionsOutput) SetNextToken(v string) *ListKafkaVersionsOutput {
	s.NextToken = &v
	return s
}

type ListNodesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodesInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ListNodesInput) SetClusterArn(v string) *ListNodesInput {
	s.ClusterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodesInput) SetMaxResults(v int64) *ListNodesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesInput) SetNextToken(v string) *ListNodesInput {
	s.NextToken = &v
	return s
}

// Information about nodes in the cluster.
type ListNodesOutput struct {
	_ struct{} `type:"structure"`

	// The paginated results marker. When the result of a ListNodes operation is
	// truncated, the call returns NextToken in the response. To get another batch
	// of nodes, provide this token in your next request.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List containing a NodeInfo object.
	NodeInfoList []*NodeInfo `locationName:"nodeInfoList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesOutput) SetNextToken(v string) *ListNodesOutput {
	s.NextToken = &v
	return s
}

// SetNodeInfoList sets the NodeInfoList field's value.
func (s *ListNodesOutput) SetNodeInfoList(v []*NodeInfo) *ListNodesOutput {
	s.NodeInfoList = v
	return s
}

type ListScramSecretsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScramSecretsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScramSecretsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListScramSecretsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListScramSecretsInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ListScramSecretsInput) SetClusterArn(v string) *ListScramSecretsInput {
	s.ClusterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListScramSecretsInput) SetMaxResults(v int64) *ListScramSecretsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListScramSecretsInput) SetNextToken(v string) *ListScramSecretsInput {
	s.NextToken = &v
	return s
}

// Information about scram secrets associated to the cluster.
type ListScramSecretsOutput struct {
	_ struct{} `type:"structure"`

	// Paginated results marker.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of scram secrets associated with the cluster.
	SecretArnList []*string `locationName:"secretArnList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScramSecretsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScramSecretsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListScramSecretsOutput) SetNextToken(v string) *ListScramSecretsOutput {
	s.NextToken = &v
	return s
}

// SetSecretArnList sets the SecretArnList field's value.
func (s *ListScramSecretsOutput) SetSecretArnList(v []*string) *ListScramSecretsOutput {
	s.SecretArnList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// Response of listing tags for a resource.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Request body for ListVpcConnections.
type ListVpcConnectionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVpcConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVpcConnectionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVpcConnectionsInput) SetMaxResults(v int64) *ListVpcConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVpcConnectionsInput) SetNextToken(v string) *ListVpcConnectionsInput {
	s.NextToken = &v
	return s
}

// The response contains an array of MSK VPC connections and a next token if
// the response is truncated.
type ListVpcConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// If the response of ListVpcConnections is truncated, it returns a NextToken
	// in the response. This NextToken should be sent in the subsequent request
	// to ListVpcConnections.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List containing a VpcConnection object.
	VpcConnections []*VpcConnection `locationName:"vpcConnections" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcConnectionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVpcConnectionsOutput) SetNextToken(v string) *ListVpcConnectionsOutput {
	s.NextToken = &v
	return s
}

// SetVpcConnections sets the VpcConnections field's value.
func (s *ListVpcConnectionsOutput) SetVpcConnections(v []*VpcConnection) *ListVpcConnectionsOutput {
	s.VpcConnections = v
	return s
}

// You can configure your MSK cluster to send broker logs to different destination
// types. This is a container for the configuration details related to broker
// logs.
type LoggingInfo struct {
	_ struct{} `type:"structure"`

	// You can configure your MSK cluster to send broker logs to different destination
	// types. This configuration specifies the details of these destinations.
	//
	// BrokerLogs is a required field
	BrokerLogs *BrokerLogs `locationName:"brokerLogs" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingInfo"}
	if s.BrokerLogs == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerLogs"))
	}
	if s.BrokerLogs != nil {
		if err := s.BrokerLogs.Validate(); err != nil {
			invalidParams.AddNested("BrokerLogs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerLogs sets the BrokerLogs field's value.
func (s *LoggingInfo) SetBrokerLogs(v *BrokerLogs) *LoggingInfo {
	s.BrokerLogs = v
	return s
}

// Information about cluster attributes that can be updated via update APIs.
type MutableClusterInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the size of the EBS volume and the ID of the associated broker.
	BrokerEBSVolumeInfo []*BrokerEBSVolumeInfo `locationName:"brokerEBSVolumeInfo" type:"list"`

	// Includes all client authentication related information.
	ClientAuthentication *ClientAuthentication `locationName:"clientAuthentication" type:"structure"`

	// Information about the changes in the configuration of the brokers.
	ConfigurationInfo *ConfigurationInfo `locationName:"configurationInfo" type:"structure"`

	// Information about the broker access configuration.
	ConnectivityInfo *ConnectivityInfo `locationName:"connectivityInfo" type:"structure"`

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo `locationName:"encryptionInfo" type:"structure"`

	// Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon
	// CloudWatch for this cluster.
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	InstanceType *string `locationName:"instanceType" type:"string"`

	// The Apache Kafka version.
	KafkaVersion *string `locationName:"kafkaVersion" type:"string"`

	// LoggingInfo details.
	LoggingInfo *LoggingInfo `locationName:"loggingInfo" type:"structure"`

	// The number of broker nodes in the cluster.
	NumberOfBrokerNodes *int64 `locationName:"numberOfBrokerNodes" type:"integer"`

	// Settings for open monitoring using Prometheus.
	OpenMonitoring *OpenMonitoring `locationName:"openMonitoring" type:"structure"`

	// This controls storage mode for supported storage tiers.
	StorageMode *string `locationName:"storageMode" type:"string" enum:"StorageMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MutableClusterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MutableClusterInfo) GoString() string {
	return s.String()
}

// SetBrokerEBSVolumeInfo sets the BrokerEBSVolumeInfo field's value.
func (s *MutableClusterInfo) SetBrokerEBSVolumeInfo(v []*BrokerEBSVolumeInfo) *MutableClusterInfo {
	s.BrokerEBSVolumeInfo = v
	return s
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *MutableClusterInfo) SetClientAuthentication(v *ClientAuthentication) *MutableClusterInfo {
	s.ClientAuthentication = v
	return s
}

// SetConfigurationInfo sets the ConfigurationInfo field's value.
func (s *MutableClusterInfo) SetConfigurationInfo(v *ConfigurationInfo) *MutableClusterInfo {
	s.ConfigurationInfo = v
	return s
}

// SetConnectivityInfo sets the ConnectivityInfo field's value.
func (s *MutableClusterInfo) SetConnectivityInfo(v *ConnectivityInfo) *MutableClusterInfo {
	s.ConnectivityInfo = v
	return s
}

// SetEncryptionInfo sets the EncryptionInfo field's value.
func (s *MutableClusterInfo) SetEncryptionInfo(v *EncryptionInfo) *MutableClusterInfo {
	s.EncryptionInfo = v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *MutableClusterInfo) SetEnhancedMonitoring(v string) *MutableClusterInfo {
	s.EnhancedMonitoring = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *MutableClusterInfo) SetInstanceType(v string) *MutableClusterInfo {
	s.InstanceType = &v
	return s
}

// SetKafkaVersion sets the KafkaVersion field's value.
func (s *MutableClusterInfo) SetKafkaVersion(v string) *MutableClusterInfo {
	s.KafkaVersion = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *MutableClusterInfo) SetLoggingInfo(v *LoggingInfo) *MutableClusterInfo {
	s.LoggingInfo = v
	return s
}

// SetNumberOfBrokerNodes sets the NumberOfBrokerNodes field's value.
func (s *MutableClusterInfo) SetNumberOfBrokerNodes(v int64) *MutableClusterInfo {
	s.NumberOfBrokerNodes = &v
	return s
}

// SetOpenMonitoring sets the OpenMonitoring field's value.
func (s *MutableClusterInfo) SetOpenMonitoring(v *OpenMonitoring) *MutableClusterInfo {
	s.OpenMonitoring = v
	return s
}

// SetStorageMode sets the StorageMode field's value.
func (s *MutableClusterInfo) SetStorageMode(v string) *MutableClusterInfo {
	s.StorageMode = &v
	return s
}

// Indicates whether you want to enable or disable the Node Exporter.
type NodeExporter struct {
	_ struct{} `type:"structure"`

	// Indicates whether you want to enable or disable the Node Exporter.
	//
	// EnabledInBroker is a required field
	EnabledInBroker *bool `locationName:"enabledInBroker" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeExporter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeExporter) GoString() string {
	return s.String()
}

// SetEnabledInBroker sets the EnabledInBroker field's value.
func (s *NodeExporter) SetEnabledInBroker(v bool) *NodeExporter {
	s.EnabledInBroker = &v
	return s
}

// Indicates whether you want to enable or disable the Node Exporter.
type NodeExporterInfo struct {
	_ struct{} `type:"structure"`

	// Node Exporter being enabled in broker.
	//
	// EnabledInBroker is a required field
	EnabledInBroker *bool `locationName:"enabledInBroker" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeExporterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeExporterInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeExporterInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodeExporterInfo"}
	if s.EnabledInBroker == nil {
		invalidParams.Add(request.NewErrParamRequired("EnabledInBroker"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabledInBroker sets the EnabledInBroker field's value.
func (s *NodeExporterInfo) SetEnabledInBroker(v bool) *NodeExporterInfo {
	s.EnabledInBroker = &v
	return s
}

// The node information object.
type NodeInfo struct {
	_ struct{} `type:"structure"`

	// The start time.
	AddedToClusterTime *string `locationName:"addedToClusterTime" type:"string"`

	// The broker node info.
	BrokerNodeInfo *BrokerNodeInfo `locationName:"brokerNodeInfo" type:"structure"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The Amazon Resource Name (ARN) of the node.
	NodeARN *string `locationName:"nodeARN" type:"string"`

	// The node type.
	NodeType *string `locationName:"nodeType" type:"string" enum:"NodeType"`

	// The ZookeeperNodeInfo.
	ZookeeperNodeInfo *ZookeeperNodeInfo `locationName:"zookeeperNodeInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeInfo) GoString() string {
	return s.String()
}

// SetAddedToClusterTime sets the AddedToClusterTime field's value.
func (s *NodeInfo) SetAddedToClusterTime(v string) *NodeInfo {
	s.AddedToClusterTime = &v
	return s
}

// SetBrokerNodeInfo sets the BrokerNodeInfo field's value.
func (s *NodeInfo) SetBrokerNodeInfo(v *BrokerNodeInfo) *NodeInfo {
	s.BrokerNodeInfo = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *NodeInfo) SetInstanceType(v string) *NodeInfo {
	s.InstanceType = &v
	return s
}

// SetNodeARN sets the NodeARN field's value.
func (s *NodeInfo) SetNodeARN(v string) *NodeInfo {
	s.NodeARN = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *NodeInfo) SetNodeType(v string) *NodeInfo {
	s.NodeType = &v
	return s
}

// SetZookeeperNodeInfo sets the ZookeeperNodeInfo field's value.
func (s *NodeInfo) SetZookeeperNodeInfo(v *ZookeeperNodeInfo) *NodeInfo {
	s.ZookeeperNodeInfo = v
	return s
}

// Returns information about an error.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// JMX and Node monitoring for the MSK cluster.
type OpenMonitoring struct {
	_ struct{} `type:"structure"`

	// Prometheus settings.
	//
	// Prometheus is a required field
	Prometheus *Prometheus `locationName:"prometheus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenMonitoring) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenMonitoring) GoString() string {
	return s.String()
}

// SetPrometheus sets the Prometheus field's value.
func (s *OpenMonitoring) SetPrometheus(v *Prometheus) *OpenMonitoring {
	s.Prometheus = v
	return s
}

// JMX and Node monitoring for the MSK cluster.
type OpenMonitoringInfo struct {
	_ struct{} `type:"structure"`

	// Prometheus settings.
	//
	// Prometheus is a required field
	Prometheus *PrometheusInfo `locationName:"prometheus" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenMonitoringInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenMonitoringInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenMonitoringInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenMonitoringInfo"}
	if s.Prometheus == nil {
		invalidParams.Add(request.NewErrParamRequired("Prometheus"))
	}
	if s.Prometheus != nil {
		if err := s.Prometheus.Validate(); err != nil {
			invalidParams.AddNested("Prometheus", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrometheus sets the Prometheus field's value.
func (s *OpenMonitoringInfo) SetPrometheus(v *PrometheusInfo) *OpenMonitoringInfo {
	s.Prometheus = v
	return s
}

// Prometheus settings for open monitoring.
type Prometheus struct {
	_ struct{} `type:"structure"`

	// Indicates whether you want to enable or disable the JMX Exporter.
	JmxExporter *JmxExporter `locationName:"jmxExporter" type:"structure"`

	// Indicates whether you want to enable or disable the Node Exporter.
	NodeExporter *NodeExporter `locationName:"nodeExporter" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Prometheus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Prometheus) GoString() string {
	return s.String()
}

// SetJmxExporter sets the JmxExporter field's value.
func (s *Prometheus) SetJmxExporter(v *JmxExporter) *Prometheus {
	s.JmxExporter = v
	return s
}

// SetNodeExporter sets the NodeExporter field's value.
func (s *Prometheus) SetNodeExporter(v *NodeExporter) *Prometheus {
	s.NodeExporter = v
	return s
}

// Prometheus settings.
type PrometheusInfo struct {
	_ struct{} `type:"structure"`

	// JMX Exporter settings.
	JmxExporter *JmxExporterInfo `locationName:"jmxExporter" type:"structure"`

	// Node Exporter settings.
	NodeExporter *NodeExporterInfo `locationName:"nodeExporter" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrometheusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrometheusInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrometheusInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrometheusInfo"}
	if s.JmxExporter != nil {
		if err := s.JmxExporter.Validate(); err != nil {
			invalidParams.AddNested("JmxExporter", err.(request.ErrInvalidParams))
		}
	}
	if s.NodeExporter != nil {
		if err := s.NodeExporter.Validate(); err != nil {
			invalidParams.AddNested("NodeExporter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJmxExporter sets the JmxExporter field's value.
func (s *PrometheusInfo) SetJmxExporter(v *JmxExporterInfo) *PrometheusInfo {
	s.JmxExporter = v
	return s
}

// SetNodeExporter sets the NodeExporter field's value.
func (s *PrometheusInfo) SetNodeExporter(v *NodeExporterInfo) *PrometheusInfo {
	s.NodeExporter = v
	return s
}

// Describes the provisioned cluster.
type Provisioned struct {
	_ struct{} `type:"structure"`

	// Information about the brokers.
	//
	// BrokerNodeGroupInfo is a required field
	BrokerNodeGroupInfo *BrokerNodeGroupInfo `locationName:"brokerNodeGroupInfo" type:"structure" required:"true"`

	// Includes all client authentication information.
	ClientAuthentication *ClientAuthentication `locationName:"clientAuthentication" type:"structure"`

	// Information about the version of software currently deployed on the Apache
	// Kafka brokers in the cluster.
	CurrentBrokerSoftwareInfo *BrokerSoftwareInfo `locationName:"currentBrokerSoftwareInfo" type:"structure"`

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo `locationName:"encryptionInfo" type:"structure"`

	// Specifies which metrics are gathered for the MSK cluster. This property has
	// the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER,
	// and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each
	// of these levels of monitoring, see Monitoring (https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html).
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	// You can configure your MSK cluster to send broker logs to different destination
	// types. This is a container for the configuration details related to broker
	// logs.
	LoggingInfo *LoggingInfo `locationName:"loggingInfo" type:"structure"`

	// NumberOfBrokerNodes is a required field
	NumberOfBrokerNodes *int64 `locationName:"numberOfBrokerNodes" min:"1" type:"integer" required:"true"`

	// JMX and Node monitoring for the MSK cluster.
	OpenMonitoring *OpenMonitoringInfo `locationName:"openMonitoring" type:"structure"`

	// This controls storage mode for supported storage tiers.
	StorageMode *string `locationName:"storageMode" type:"string" enum:"StorageMode"`

	ZookeeperConnectString *string `locationName:"zookeeperConnectString" type:"string"`

	ZookeeperConnectStringTls *string `locationName:"zookeeperConnectStringTls" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Provisioned) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Provisioned) GoString() string {
	return s.String()
}

// SetBrokerNodeGroupInfo sets the BrokerNodeGroupInfo field's value.
func (s *Provisioned) SetBrokerNodeGroupInfo(v *BrokerNodeGroupInfo) *Provisioned {
	s.BrokerNodeGroupInfo = v
	return s
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *Provisioned) SetClientAuthentication(v *ClientAuthentication) *Provisioned {
	s.ClientAuthentication = v
	return s
}

// SetCurrentBrokerSoftwareInfo sets the CurrentBrokerSoftwareInfo field's value.
func (s *Provisioned) SetCurrentBrokerSoftwareInfo(v *BrokerSoftwareInfo) *Provisioned {
	s.CurrentBrokerSoftwareInfo = v
	return s
}

// SetEncryptionInfo sets the EncryptionInfo field's value.
func (s *Provisioned) SetEncryptionInfo(v *EncryptionInfo) *Provisioned {
	s.EncryptionInfo = v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *Provisioned) SetEnhancedMonitoring(v string) *Provisioned {
	s.EnhancedMonitoring = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *Provisioned) SetLoggingInfo(v *LoggingInfo) *Provisioned {
	s.LoggingInfo = v
	return s
}

// SetNumberOfBrokerNodes sets the NumberOfBrokerNodes field's value.
func (s *Provisioned) SetNumberOfBrokerNodes(v int64) *Provisioned {
	s.NumberOfBrokerNodes = &v
	return s
}

// SetOpenMonitoring sets the OpenMonitoring field's value.
func (s *Provisioned) SetOpenMonitoring(v *OpenMonitoringInfo) *Provisioned {
	s.OpenMonitoring = v
	return s
}

// SetStorageMode sets the StorageMode field's value.
func (s *Provisioned) SetStorageMode(v string) *Provisioned {
	s.StorageMode = &v
	return s
}

// SetZookeeperConnectString sets the ZookeeperConnectString field's value.
func (s *Provisioned) SetZookeeperConnectString(v string) *Provisioned {
	s.ZookeeperConnectString = &v
	return s
}

// SetZookeeperConnectStringTls sets the ZookeeperConnectStringTls field's value.
func (s *Provisioned) SetZookeeperConnectStringTls(v string) *Provisioned {
	s.ZookeeperConnectStringTls = &v
	return s
}

// Creates a provisioned cluster.
type ProvisionedRequest struct {
	_ struct{} `type:"structure"`

	// Information about the brokers.
	//
	// BrokerNodeGroupInfo is a required field
	BrokerNodeGroupInfo *BrokerNodeGroupInfo `locationName:"brokerNodeGroupInfo" type:"structure" required:"true"`

	// Includes all client authentication related information.
	ClientAuthentication *ClientAuthentication `locationName:"clientAuthentication" type:"structure"`

	// Represents the configuration that you want MSK to use for the cluster.
	ConfigurationInfo *ConfigurationInfo `locationName:"configurationInfo" type:"structure"`

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo `locationName:"encryptionInfo" type:"structure"`

	// Specifies the level of monitoring for the MSK cluster. The possible values
	// are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	// KafkaVersion is a required field
	KafkaVersion *string `locationName:"kafkaVersion" min:"1" type:"string" required:"true"`

	// LoggingInfo details.
	LoggingInfo *LoggingInfo `locationName:"loggingInfo" type:"structure"`

	// NumberOfBrokerNodes is a required field
	NumberOfBrokerNodes *int64 `locationName:"numberOfBrokerNodes" min:"1" type:"integer" required:"true"`

	// The settings for open monitoring.
	OpenMonitoring *OpenMonitoringInfo `locationName:"openMonitoring" type:"structure"`

	// This controls storage mode for supported storage tiers.
	StorageMode *string `locationName:"storageMode" type:"string" enum:"StorageMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionedRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionedRequest"}
	if s.BrokerNodeGroupInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerNodeGroupInfo"))
	}
	if s.KafkaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("KafkaVersion"))
	}
	if s.KafkaVersion != nil && len(*s.KafkaVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KafkaVersion", 1))
	}
	if s.NumberOfBrokerNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfBrokerNodes"))
	}
	if s.NumberOfBrokerNodes != nil && *s.NumberOfBrokerNodes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBrokerNodes", 1))
	}
	if s.BrokerNodeGroupInfo != nil {
		if err := s.BrokerNodeGroupInfo.Validate(); err != nil {
			invalidParams.AddNested("BrokerNodeGroupInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.ConfigurationInfo != nil {
		if err := s.ConfigurationInfo.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionInfo != nil {
		if err := s.EncryptionInfo.Validate(); err != nil {
			invalidParams.AddNested("EncryptionInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.LoggingInfo != nil {
		if err := s.LoggingInfo.Validate(); err != nil {
			invalidParams.AddNested("LoggingInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.OpenMonitoring != nil {
		if err := s.OpenMonitoring.Validate(); err != nil {
			invalidParams.AddNested("OpenMonitoring", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerNodeGroupInfo sets the BrokerNodeGroupInfo field's value.
func (s *ProvisionedRequest) SetBrokerNodeGroupInfo(v *BrokerNodeGroupInfo) *ProvisionedRequest {
	s.BrokerNodeGroupInfo = v
	return s
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *ProvisionedRequest) SetClientAuthentication(v *ClientAuthentication) *ProvisionedRequest {
	s.ClientAuthentication = v
	return s
}

// SetConfigurationInfo sets the ConfigurationInfo field's value.
func (s *ProvisionedRequest) SetConfigurationInfo(v *ConfigurationInfo) *ProvisionedRequest {
	s.ConfigurationInfo = v
	return s
}

// SetEncryptionInfo sets the EncryptionInfo field's value.
func (s *ProvisionedRequest) SetEncryptionInfo(v *EncryptionInfo) *ProvisionedRequest {
	s.EncryptionInfo = v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *ProvisionedRequest) SetEnhancedMonitoring(v string) *ProvisionedRequest {
	s.EnhancedMonitoring = &v
	return s
}

// SetKafkaVersion sets the KafkaVersion field's value.
func (s *ProvisionedRequest) SetKafkaVersion(v string) *ProvisionedRequest {
	s.KafkaVersion = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *ProvisionedRequest) SetLoggingInfo(v *LoggingInfo) *ProvisionedRequest {
	s.LoggingInfo = v
	return s
}

// SetNumberOfBrokerNodes sets the NumberOfBrokerNodes field's value.
func (s *ProvisionedRequest) SetNumberOfBrokerNodes(v int64) *ProvisionedRequest {
	s.NumberOfBrokerNodes = &v
	return s
}

// SetOpenMonitoring sets the OpenMonitoring field's value.
func (s *ProvisionedRequest) SetOpenMonitoring(v *OpenMonitoringInfo) *ProvisionedRequest {
	s.OpenMonitoring = v
	return s
}

// SetStorageMode sets the StorageMode field's value.
func (s *ProvisionedRequest) SetStorageMode(v string) *ProvisionedRequest {
	s.StorageMode = &v
	return s
}

// Contains information about provisioned throughput for EBS storage volumes
// attached to kafka broker nodes.
type ProvisionedThroughput struct {
	_ struct{} `type:"structure"`

	// Provisioned throughput is enabled or not.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// Throughput value of the EBS volumes for the data drive on each kafka broker
	// node in MiB per second.
	VolumeThroughput *int64 `locationName:"volumeThroughput" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedThroughput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedThroughput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *ProvisionedThroughput) SetEnabled(v bool) *ProvisionedThroughput {
	s.Enabled = &v
	return s
}

// SetVolumeThroughput sets the VolumeThroughput field's value.
func (s *ProvisionedThroughput) SetVolumeThroughput(v int64) *ProvisionedThroughput {
	s.VolumeThroughput = &v
	return s
}

// Broker public access control.
type PublicAccess struct {
	_ struct{} `type:"structure"`

	// The value DISABLED indicates that public access is disabled. SERVICE_PROVIDED_EIPS
	// indicates that public access is enabled.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicAccess) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *PublicAccess) SetType(v string) *PublicAccess {
	s.Type = &v
	return s
}

// Request body for PutClusterPolicy.
type PutClusterPolicyInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	CurrentVersion *string `locationName:"currentVersion" type:"string"`

	// Policy is a required field
	Policy *string `locationName:"policy" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutClusterPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutClusterPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutClusterPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutClusterPolicyInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *PutClusterPolicyInput) SetClusterArn(v string) *PutClusterPolicyInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *PutClusterPolicyInput) SetCurrentVersion(v string) *PutClusterPolicyInput {
	s.CurrentVersion = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutClusterPolicyInput) SetPolicy(v string) *PutClusterPolicyInput {
	s.Policy = &v
	return s
}

// Response body for PutClusterPolicy.
type PutClusterPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Cluster policy version.
	CurrentVersion *string `locationName:"currentVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutClusterPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutClusterPolicyOutput) GoString() string {
	return s.String()
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *PutClusterPolicyOutput) SetCurrentVersion(v string) *PutClusterPolicyOutput {
	s.CurrentVersion = &v
	return s
}

// Request body for RebootBrokerNode action.
type RebootBrokerInput struct {
	_ struct{} `type:"structure"`

	// The list of broker ids to be rebooted.
	//
	// BrokerIds is a required field
	BrokerIds []*string `locationName:"brokerIds" type:"list" required:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootBrokerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootBrokerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootBrokerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootBrokerInput"}
	if s.BrokerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerIds"))
	}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerIds sets the BrokerIds field's value.
func (s *RebootBrokerInput) SetBrokerIds(v []*string) *RebootBrokerInput {
	s.BrokerIds = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *RebootBrokerInput) SetClusterArn(v string) *RebootBrokerInput {
	s.ClusterArn = &v
	return s
}

// Response body for RebootBrokers action.
type RebootBrokerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootBrokerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootBrokerOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *RebootBrokerOutput) SetClusterArn(v string) *RebootBrokerOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *RebootBrokerOutput) SetClusterOperationArn(v string) *RebootBrokerOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request body for RejectClientVpcConnection.
type RejectClientVpcConnectionInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// VpcConnectionArn is a required field
	VpcConnectionArn *string `locationName:"vpcConnectionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectClientVpcConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectClientVpcConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectClientVpcConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectClientVpcConnectionInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.VpcConnectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcConnectionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *RejectClientVpcConnectionInput) SetClusterArn(v string) *RejectClientVpcConnectionInput {
	s.ClusterArn = &v
	return s
}

// SetVpcConnectionArn sets the VpcConnectionArn field's value.
func (s *RejectClientVpcConnectionInput) SetVpcConnectionArn(v string) *RejectClientVpcConnectionInput {
	s.VpcConnectionArn = &v
	return s
}

// Response body for RejectClientVpcConnection.
type RejectClientVpcConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectClientVpcConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectClientVpcConnectionOutput) GoString() string {
	return s.String()
}

// The details of the Amazon S3 destination for broker logs.
type S3 struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket that is the destination for broker logs.
	Bucket *string `locationName:"bucket" type:"string"`

	// Specifies whether broker logs get sent to the specified Amazon S3 destination.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The S3 prefix that is the destination for broker logs.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3) SetBucket(v string) *S3 {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *S3) SetEnabled(v bool) *S3 {
	s.Enabled = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3) SetPrefix(v string) *S3 {
	s.Prefix = &v
	return s
}

type Sasl struct {
	_ struct{} `type:"structure"`

	Iam *Iam `locationName:"iam" type:"structure"`

	Scram *Scram `locationName:"scram" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sasl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sasl) GoString() string {
	return s.String()
}

// SetIam sets the Iam field's value.
func (s *Sasl) SetIam(v *Iam) *Sasl {
	s.Iam = v
	return s
}

// SetScram sets the Scram field's value.
func (s *Sasl) SetScram(v *Scram) *Sasl {
	s.Scram = v
	return s
}

type Scram struct {
	_ struct{} `type:"structure"`

	// SASL/SCRAM authentication is enabled or not.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Scram) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Scram) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *Scram) SetEnabled(v bool) *Scram {
	s.Enabled = &v
	return s
}

// Describes the serverless cluster.
type Serverless struct {
	_ struct{} `type:"structure"`

	// Information about the serverless cluster client authentication.
	ClientAuthentication *ServerlessClientAuthentication `locationName:"clientAuthentication" type:"structure"`

	// Information on vpc config for the serverless cluster.
	//
	// VpcConfigs is a required field
	VpcConfigs []*VpcConfig `locationName:"vpcConfigs" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Serverless) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Serverless) GoString() string {
	return s.String()
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *Serverless) SetClientAuthentication(v *ServerlessClientAuthentication) *Serverless {
	s.ClientAuthentication = v
	return s
}

// SetVpcConfigs sets the VpcConfigs field's value.
func (s *Serverless) SetVpcConfigs(v []*VpcConfig) *Serverless {
	s.VpcConfigs = v
	return s
}

// Describes the serverless cluster client authentication.
type ServerlessClientAuthentication struct {
	_ struct{} `type:"structure"`

	// Serverless cluster SASL information.
	Sasl *ServerlessSasl `locationName:"sasl" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerlessClientAuthentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerlessClientAuthentication) GoString() string {
	return s.String()
}

// SetSasl sets the Sasl field's value.
func (s *ServerlessClientAuthentication) SetSasl(v *ServerlessSasl) *ServerlessClientAuthentication {
	s.Sasl = v
	return s
}

// Creates serverless cluster.
type ServerlessRequest struct {
	_ struct{} `type:"structure"`

	// Information about the serverless cluster client authentication.
	ClientAuthentication *ServerlessClientAuthentication `locationName:"clientAuthentication" type:"structure"`

	// Information on vpc config for the serverless cluster.
	//
	// VpcConfigs is a required field
	VpcConfigs []*VpcConfig `locationName:"vpcConfigs" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerlessRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerlessRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerlessRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerlessRequest"}
	if s.VpcConfigs == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcConfigs"))
	}
	if s.VpcConfigs != nil {
		for i, v := range s.VpcConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VpcConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *ServerlessRequest) SetClientAuthentication(v *ServerlessClientAuthentication) *ServerlessRequest {
	s.ClientAuthentication = v
	return s
}

// SetVpcConfigs sets the VpcConfigs field's value.
func (s *ServerlessRequest) SetVpcConfigs(v []*VpcConfig) *ServerlessRequest {
	s.VpcConfigs = v
	return s
}

// Describes the serverless cluster SASL information.
type ServerlessSasl struct {
	_ struct{} `type:"structure"`

	Iam *Iam `locationName:"iam" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerlessSasl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerlessSasl) GoString() string {
	return s.String()
}

// SetIam sets the Iam field's value.
func (s *ServerlessSasl) SetIam(v *Iam) *ServerlessSasl {
	s.Iam = v
	return s
}

// Returns information about an error.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the state of the Amazon MSK cluster.
type StateInfo struct {
	_ struct{} `type:"structure"`

	// If the cluster is in an unusable state, this field contains the code that
	// describes the issue.
	Code *string `locationName:"code" type:"string"`

	// If the cluster is in an unusable state, this field contains a message that
	// describes the issue.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StateInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StateInfo) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *StateInfo) SetCode(v string) *StateInfo {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *StateInfo) SetMessage(v string) *StateInfo {
	s.Message = &v
	return s
}

// Contains information about storage volumes attached to MSK broker nodes.
type StorageInfo struct {
	_ struct{} `type:"structure"`

	// EBS volume information.
	EbsStorageInfo *EBSStorageInfo `locationName:"ebsStorageInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageInfo"}
	if s.EbsStorageInfo != nil {
		if err := s.EbsStorageInfo.Validate(); err != nil {
			invalidParams.AddNested("EbsStorageInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEbsStorageInfo sets the EbsStorageInfo field's value.
func (s *StorageInfo) SetEbsStorageInfo(v *EBSStorageInfo) *StorageInfo {
	s.EbsStorageInfo = v
	return s
}

// Tag a resource.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The key-value pair for the resource tag.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Details for client authentication using TLS.
type Tls struct {
	_ struct{} `type:"structure"`

	// List of ACM Certificate Authority ARNs.
	CertificateAuthorityArnList []*string `locationName:"certificateAuthorityArnList" type:"list"`

	// TLS authentication is enabled or not.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tls) GoString() string {
	return s.String()
}

// SetCertificateAuthorityArnList sets the CertificateAuthorityArnList field's value.
func (s *Tls) SetCertificateAuthorityArnList(v []*string) *Tls {
	s.CertificateAuthorityArnList = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *Tls) SetEnabled(v bool) *Tls {
	s.Enabled = &v
	return s
}

// Returns information about an error.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about unauthenticated traffic to the cluster.
type Unauthenticated struct {
	_ struct{} `type:"structure"`

	// Specifies whether you want to enable or disable unauthenticated traffic to
	// your cluster.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Unauthenticated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Unauthenticated) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *Unauthenticated) SetEnabled(v bool) *Unauthenticated {
	s.Enabled = &v
	return s
}

// Returns information about an error.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UnprocessedScramSecret struct {
	_ struct{} `type:"structure"`

	ErrorCode *string `locationName:"errorCode" type:"string"`

	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	SecretArn *string `locationName:"secretArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessedScramSecret) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessedScramSecret) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedScramSecret) SetErrorCode(v string) *UnprocessedScramSecret {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UnprocessedScramSecret) SetErrorMessage(v string) *UnprocessedScramSecret {
	s.ErrorMessage = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *UnprocessedScramSecret) SetSecretArn(v string) *UnprocessedScramSecret {
	s.SecretArn = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Request body for UpdateBrokerCount.
type UpdateBrokerCountInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// The current version of the cluster.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// The number of broker nodes that you want the cluster to have after this operation
	// completes successfully.
	//
	// TargetNumberOfBrokerNodes is a required field
	TargetNumberOfBrokerNodes *int64 `locationName:"targetNumberOfBrokerNodes" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerCountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBrokerCountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBrokerCountInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.TargetNumberOfBrokerNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetNumberOfBrokerNodes"))
	}
	if s.TargetNumberOfBrokerNodes != nil && *s.TargetNumberOfBrokerNodes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TargetNumberOfBrokerNodes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateBrokerCountInput) SetClusterArn(v string) *UpdateBrokerCountInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateBrokerCountInput) SetCurrentVersion(v string) *UpdateBrokerCountInput {
	s.CurrentVersion = &v
	return s
}

// SetTargetNumberOfBrokerNodes sets the TargetNumberOfBrokerNodes field's value.
func (s *UpdateBrokerCountInput) SetTargetNumberOfBrokerNodes(v int64) *UpdateBrokerCountInput {
	s.TargetNumberOfBrokerNodes = &v
	return s
}

// Response body for UpdateBrokerCount.
type UpdateBrokerCountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerCountOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateBrokerCountOutput) SetClusterArn(v string) *UpdateBrokerCountOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateBrokerCountOutput) SetClusterOperationArn(v string) *UpdateBrokerCountOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request object for UpdateBrokerStorage.
type UpdateBrokerStorageInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// The version of cluster to update from. A successful operation will then generate
	// a new version.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// Describes the target volume size and the ID of the broker to apply the update
	// to.
	//
	// The value you specify for Target-Volume-in-GiB must be a whole number that
	// is greater than 100 GiB.
	//
	// The storage per broker after the update operation can't exceed 16384 GiB.
	//
	// TargetBrokerEBSVolumeInfo is a required field
	TargetBrokerEBSVolumeInfo []*BrokerEBSVolumeInfo `locationName:"targetBrokerEBSVolumeInfo" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBrokerStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBrokerStorageInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.TargetBrokerEBSVolumeInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetBrokerEBSVolumeInfo"))
	}
	if s.TargetBrokerEBSVolumeInfo != nil {
		for i, v := range s.TargetBrokerEBSVolumeInfo {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetBrokerEBSVolumeInfo", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateBrokerStorageInput) SetClusterArn(v string) *UpdateBrokerStorageInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateBrokerStorageInput) SetCurrentVersion(v string) *UpdateBrokerStorageInput {
	s.CurrentVersion = &v
	return s
}

// SetTargetBrokerEBSVolumeInfo sets the TargetBrokerEBSVolumeInfo field's value.
func (s *UpdateBrokerStorageInput) SetTargetBrokerEBSVolumeInfo(v []*BrokerEBSVolumeInfo) *UpdateBrokerStorageInput {
	s.TargetBrokerEBSVolumeInfo = v
	return s
}

// Response body for UpdateBrokerStorage.
type UpdateBrokerStorageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerStorageOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateBrokerStorageOutput) SetClusterArn(v string) *UpdateBrokerStorageOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateBrokerStorageOutput) SetClusterOperationArn(v string) *UpdateBrokerStorageOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request body for UpdateBrokerType.
type UpdateBrokerTypeInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// The current version of the cluster.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// The Amazon MSK broker type that you want all of the brokers in this cluster
	// to be.
	//
	// TargetInstanceType is a required field
	TargetInstanceType *string `locationName:"targetInstanceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBrokerTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBrokerTypeInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.TargetInstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetInstanceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateBrokerTypeInput) SetClusterArn(v string) *UpdateBrokerTypeInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateBrokerTypeInput) SetCurrentVersion(v string) *UpdateBrokerTypeInput {
	s.CurrentVersion = &v
	return s
}

// SetTargetInstanceType sets the TargetInstanceType field's value.
func (s *UpdateBrokerTypeInput) SetTargetInstanceType(v string) *UpdateBrokerTypeInput {
	s.TargetInstanceType = &v
	return s
}

// Response body for UpdateBrokerType.
type UpdateBrokerTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrokerTypeOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateBrokerTypeOutput) SetClusterArn(v string) *UpdateBrokerTypeOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateBrokerTypeOutput) SetClusterOperationArn(v string) *UpdateBrokerTypeOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request body for UpdateClusterConfiguration.
type UpdateClusterConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// Represents the configuration that you want MSK to use for the cluster.
	//
	// ConfigurationInfo is a required field
	ConfigurationInfo *ConfigurationInfo `locationName:"configurationInfo" type:"structure" required:"true"`

	// The version of the cluster that you want to update.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterConfigurationInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.ConfigurationInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationInfo"))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.ConfigurationInfo != nil {
		if err := s.ConfigurationInfo.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateClusterConfigurationInput) SetClusterArn(v string) *UpdateClusterConfigurationInput {
	s.ClusterArn = &v
	return s
}

// SetConfigurationInfo sets the ConfigurationInfo field's value.
func (s *UpdateClusterConfigurationInput) SetConfigurationInfo(v *ConfigurationInfo) *UpdateClusterConfigurationInput {
	s.ConfigurationInfo = v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateClusterConfigurationInput) SetCurrentVersion(v string) *UpdateClusterConfigurationInput {
	s.CurrentVersion = &v
	return s
}

// Response body for UpdateClusterConfiguration.
type UpdateClusterConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigurationOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateClusterConfigurationOutput) SetClusterArn(v string) *UpdateClusterConfigurationOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateClusterConfigurationOutput) SetClusterOperationArn(v string) *UpdateClusterConfigurationOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request body for UpdateClusterKafkaVersion.
type UpdateClusterKafkaVersionInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// Specifies the configuration to use for the brokers.
	ConfigurationInfo *ConfigurationInfo `locationName:"configurationInfo" type:"structure"`

	// Current cluster version.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// Target Apache Kafka version.
	//
	// TargetKafkaVersion is a required field
	TargetKafkaVersion *string `locationName:"targetKafkaVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterKafkaVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterKafkaVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterKafkaVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterKafkaVersionInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.TargetKafkaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetKafkaVersion"))
	}
	if s.ConfigurationInfo != nil {
		if err := s.ConfigurationInfo.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateClusterKafkaVersionInput) SetClusterArn(v string) *UpdateClusterKafkaVersionInput {
	s.ClusterArn = &v
	return s
}

// SetConfigurationInfo sets the ConfigurationInfo field's value.
func (s *UpdateClusterKafkaVersionInput) SetConfigurationInfo(v *ConfigurationInfo) *UpdateClusterKafkaVersionInput {
	s.ConfigurationInfo = v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateClusterKafkaVersionInput) SetCurrentVersion(v string) *UpdateClusterKafkaVersionInput {
	s.CurrentVersion = &v
	return s
}

// SetTargetKafkaVersion sets the TargetKafkaVersion field's value.
func (s *UpdateClusterKafkaVersionInput) SetTargetKafkaVersion(v string) *UpdateClusterKafkaVersionInput {
	s.TargetKafkaVersion = &v
	return s
}

// Response body for UpdateClusterKafkaVersion.
type UpdateClusterKafkaVersionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterKafkaVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterKafkaVersionOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateClusterKafkaVersionOutput) SetClusterArn(v string) *UpdateClusterKafkaVersionOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateClusterKafkaVersionOutput) SetClusterOperationArn(v string) *UpdateClusterKafkaVersionOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request body for UpdateConfiguration.
type UpdateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	// The description of the configuration.
	Description *string `locationName:"description" type:"string"`

	// ServerProperties is automatically base64 encoded/decoded by the SDK.
	//
	// ServerProperties is a required field
	ServerProperties []byte `locationName:"serverProperties" type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.ServerProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateConfigurationInput) SetArn(v string) *UpdateConfigurationInput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConfigurationInput) SetDescription(v string) *UpdateConfigurationInput {
	s.Description = &v
	return s
}

// SetServerProperties sets the ServerProperties field's value.
func (s *UpdateConfigurationInput) SetServerProperties(v []byte) *UpdateConfigurationInput {
	s.ServerProperties = v
	return s
}

// Response body for UpdateConfiguration.
type UpdateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// Latest revision of the configuration.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateConfigurationOutput) SetArn(v string) *UpdateConfigurationOutput {
	s.Arn = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *UpdateConfigurationOutput) SetLatestRevision(v *ConfigurationRevision) *UpdateConfigurationOutput {
	s.LatestRevision = v
	return s
}

// Request body for UpdateConnectivity.
type UpdateConnectivityInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// Information about the broker access configuration.
	//
	// ConnectivityInfo is a required field
	ConnectivityInfo *ConnectivityInfo `locationName:"connectivityInfo" type:"structure" required:"true"`

	// The current version of the cluster.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectivityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectivityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectivityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectivityInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.ConnectivityInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectivityInfo"))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateConnectivityInput) SetClusterArn(v string) *UpdateConnectivityInput {
	s.ClusterArn = &v
	return s
}

// SetConnectivityInfo sets the ConnectivityInfo field's value.
func (s *UpdateConnectivityInput) SetConnectivityInfo(v *ConnectivityInfo) *UpdateConnectivityInput {
	s.ConnectivityInfo = v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateConnectivityInput) SetCurrentVersion(v string) *UpdateConnectivityInput {
	s.CurrentVersion = &v
	return s
}

// Response body for UpdateConnectivity.
type UpdateConnectivityOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectivityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectivityOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateConnectivityOutput) SetClusterArn(v string) *UpdateConnectivityOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateConnectivityOutput) SetClusterOperationArn(v string) *UpdateConnectivityOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request body for UpdateMonitoring.
type UpdateMonitoringInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// The version of cluster to update from. A successful operation will then generate
	// a new version.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon
	// CloudWatch for this cluster.
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	// LoggingInfo details.
	LoggingInfo *LoggingInfo `locationName:"loggingInfo" type:"structure"`

	// The settings for open monitoring.
	OpenMonitoring *OpenMonitoringInfo `locationName:"openMonitoring" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitoringInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitoringInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMonitoringInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMonitoringInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.LoggingInfo != nil {
		if err := s.LoggingInfo.Validate(); err != nil {
			invalidParams.AddNested("LoggingInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.OpenMonitoring != nil {
		if err := s.OpenMonitoring.Validate(); err != nil {
			invalidParams.AddNested("OpenMonitoring", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateMonitoringInput) SetClusterArn(v string) *UpdateMonitoringInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateMonitoringInput) SetCurrentVersion(v string) *UpdateMonitoringInput {
	s.CurrentVersion = &v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *UpdateMonitoringInput) SetEnhancedMonitoring(v string) *UpdateMonitoringInput {
	s.EnhancedMonitoring = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *UpdateMonitoringInput) SetLoggingInfo(v *LoggingInfo) *UpdateMonitoringInput {
	s.LoggingInfo = v
	return s
}

// SetOpenMonitoring sets the OpenMonitoring field's value.
func (s *UpdateMonitoringInput) SetOpenMonitoring(v *OpenMonitoringInfo) *UpdateMonitoringInput {
	s.OpenMonitoring = v
	return s
}

// Response body for UpdateMonitoring.
type UpdateMonitoringOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitoringOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitoringOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateMonitoringOutput) SetClusterArn(v string) *UpdateMonitoringOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateMonitoringOutput) SetClusterOperationArn(v string) *UpdateMonitoringOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request body for UpdateSecurity.
type UpdateSecurityInput struct {
	_ struct{} `type:"structure"`

	// Includes all client authentication related information.
	ClientAuthentication *ClientAuthentication `locationName:"clientAuthentication" type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// You can use the DescribeCluster operation to get the current version of the
	// cluster. After the security update is complete, the cluster will have a new
	// version.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo `locationName:"encryptionInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSecurityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSecurityInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.EncryptionInfo != nil {
		if err := s.EncryptionInfo.Validate(); err != nil {
			invalidParams.AddNested("EncryptionInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *UpdateSecurityInput) SetClientAuthentication(v *ClientAuthentication) *UpdateSecurityInput {
	s.ClientAuthentication = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateSecurityInput) SetClusterArn(v string) *UpdateSecurityInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateSecurityInput) SetCurrentVersion(v string) *UpdateSecurityInput {
	s.CurrentVersion = &v
	return s
}

// SetEncryptionInfo sets the EncryptionInfo field's value.
func (s *UpdateSecurityInput) SetEncryptionInfo(v *EncryptionInfo) *UpdateSecurityInput {
	s.EncryptionInfo = v
	return s
}

// Response body for UpdateSecurity.
type UpdateSecurityOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateSecurityOutput) SetClusterArn(v string) *UpdateSecurityOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateSecurityOutput) SetClusterOperationArn(v string) *UpdateSecurityOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request object for UpdateStorageApi.
type UpdateStorageInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// The version of cluster to update from. A successful operation will then generate
	// a new version.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// EBS volume provisioned throughput information.
	ProvisionedThroughput *ProvisionedThroughput `locationName:"provisionedThroughput" type:"structure"`

	// Controls storage mode for supported storage tiers.
	StorageMode *string `locationName:"storageMode" type:"string" enum:"StorageMode"`

	// size of the EBS volume to update.
	VolumeSizeGB *int64 `locationName:"volumeSizeGB" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStorageInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateStorageInput) SetClusterArn(v string) *UpdateStorageInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateStorageInput) SetCurrentVersion(v string) *UpdateStorageInput {
	s.CurrentVersion = &v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *UpdateStorageInput) SetProvisionedThroughput(v *ProvisionedThroughput) *UpdateStorageInput {
	s.ProvisionedThroughput = v
	return s
}

// SetStorageMode sets the StorageMode field's value.
func (s *UpdateStorageInput) SetStorageMode(v string) *UpdateStorageInput {
	s.StorageMode = &v
	return s
}

// SetVolumeSizeGB sets the VolumeSizeGB field's value.
func (s *UpdateStorageInput) SetVolumeSizeGB(v int64) *UpdateStorageInput {
	s.VolumeSizeGB = &v
	return s
}

// Response body for UpdateStorageResponse Api.
type UpdateStorageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStorageOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateStorageOutput) SetClusterArn(v string) *UpdateStorageOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateStorageOutput) SetClusterOperationArn(v string) *UpdateStorageOutput {
	s.ClusterOperationArn = &v
	return s
}

// Description of the requester that calls the API operation.
type UserIdentity struct {
	_ struct{} `type:"structure"`

	PrincipalId *string `locationName:"principalId" type:"string"`

	// The identity type of the requester that calls the API operation.
	Type *string `locationName:"type" type:"string" enum:"UserIdentityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserIdentity) GoString() string {
	return s.String()
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *UserIdentity) SetPrincipalId(v string) *UserIdentity {
	s.PrincipalId = &v
	return s
}

// SetType sets the Type field's value.
func (s *UserIdentity) SetType(v string) *UserIdentity {
	s.Type = &v
	return s
}

// The configuration of the Amazon VPCs for the cluster.
type VpcConfig struct {
	_ struct{} `type:"structure"`

	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfig"}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfig) SetSecurityGroupIds(v []*string) *VpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfig) SetSubnetIds(v []*string) *VpcConfig {
	s.SubnetIds = v
	return s
}

// The VPC connection object.
type VpcConnection struct {
	_ struct{} `type:"structure"`

	// The authentication type for the VPC connection.
	Authentication *string `locationName:"authentication" type:"string"`

	// The creation time of the VPC connection.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The state of a configuration.
	State *string `locationName:"state" type:"string" enum:"VpcConnectionState"`

	// The Amazon Resource Name (ARN) of the cluster.
	//
	// TargetClusterArn is a required field
	TargetClusterArn *string `locationName:"targetClusterArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the VPC connection.
	//
	// VpcConnectionArn is a required field
	VpcConnectionArn *string `locationName:"vpcConnectionArn" type:"string" required:"true"`

	// The VPC ID of the VPC connection.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnection) GoString() string {
	return s.String()
}

// SetAuthentication sets the Authentication field's value.
func (s *VpcConnection) SetAuthentication(v string) *VpcConnection {
	s.Authentication = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *VpcConnection) SetCreationTime(v time.Time) *VpcConnection {
	s.CreationTime = &v
	return s
}

// SetState sets the State field's value.
func (s *VpcConnection) SetState(v string) *VpcConnection {
	s.State = &v
	return s
}

// SetTargetClusterArn sets the TargetClusterArn field's value.
func (s *VpcConnection) SetTargetClusterArn(v string) *VpcConnection {
	s.TargetClusterArn = &v
	return s
}

// SetVpcConnectionArn sets the VpcConnectionArn field's value.
func (s *VpcConnection) SetVpcConnectionArn(v string) *VpcConnection {
	s.VpcConnectionArn = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConnection) SetVpcId(v string) *VpcConnection {
	s.VpcId = &v
	return s
}

// Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection
// operations.
type VpcConnectionInfo struct {
	_ struct{} `type:"structure"`

	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	Owner *string `locationName:"owner" type:"string"`

	// Description of the requester that calls the API operation.
	UserIdentity *UserIdentity `locationName:"userIdentity" type:"structure"`

	VpcConnectionArn *string `locationName:"vpcConnectionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectionInfo) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *VpcConnectionInfo) SetCreationTime(v time.Time) *VpcConnectionInfo {
	s.CreationTime = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *VpcConnectionInfo) SetOwner(v string) *VpcConnectionInfo {
	s.Owner = &v
	return s
}

// SetUserIdentity sets the UserIdentity field's value.
func (s *VpcConnectionInfo) SetUserIdentity(v *UserIdentity) *VpcConnectionInfo {
	s.UserIdentity = v
	return s
}

// SetVpcConnectionArn sets the VpcConnectionArn field's value.
func (s *VpcConnectionInfo) SetVpcConnectionArn(v string) *VpcConnectionInfo {
	s.VpcConnectionArn = &v
	return s
}

// Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection
// operations.
type VpcConnectionInfoServerless struct {
	_ struct{} `type:"structure"`

	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	Owner *string `locationName:"owner" type:"string"`

	// Description of the requester that calls the API operation.
	UserIdentity *UserIdentity `locationName:"userIdentity" type:"structure"`

	VpcConnectionArn *string `locationName:"vpcConnectionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectionInfoServerless) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectionInfoServerless) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *VpcConnectionInfoServerless) SetCreationTime(v time.Time) *VpcConnectionInfoServerless {
	s.CreationTime = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *VpcConnectionInfoServerless) SetOwner(v string) *VpcConnectionInfoServerless {
	s.Owner = &v
	return s
}

// SetUserIdentity sets the UserIdentity field's value.
func (s *VpcConnectionInfoServerless) SetUserIdentity(v *UserIdentity) *VpcConnectionInfoServerless {
	s.UserIdentity = v
	return s
}

// SetVpcConnectionArn sets the VpcConnectionArn field's value.
func (s *VpcConnectionInfoServerless) SetVpcConnectionArn(v string) *VpcConnectionInfoServerless {
	s.VpcConnectionArn = &v
	return s
}

// Broker VPC connectivity access control.
type VpcConnectivity struct {
	_ struct{} `type:"structure"`

	ClientAuthentication *VpcConnectivityClientAuthentication `locationName:"clientAuthentication" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivity) GoString() string {
	return s.String()
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *VpcConnectivity) SetClientAuthentication(v *VpcConnectivityClientAuthentication) *VpcConnectivity {
	s.ClientAuthentication = v
	return s
}

type VpcConnectivityClientAuthentication struct {
	_ struct{} `type:"structure"`

	Sasl *VpcConnectivitySasl `locationName:"sasl" type:"structure"`

	Tls *VpcConnectivityTls `locationName:"tls" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivityClientAuthentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivityClientAuthentication) GoString() string {
	return s.String()
}

// SetSasl sets the Sasl field's value.
func (s *VpcConnectivityClientAuthentication) SetSasl(v *VpcConnectivitySasl) *VpcConnectivityClientAuthentication {
	s.Sasl = v
	return s
}

// SetTls sets the Tls field's value.
func (s *VpcConnectivityClientAuthentication) SetTls(v *VpcConnectivityTls) *VpcConnectivityClientAuthentication {
	s.Tls = v
	return s
}

type VpcConnectivityIam struct {
	_ struct{} `type:"structure"`

	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivityIam) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivityIam) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *VpcConnectivityIam) SetEnabled(v bool) *VpcConnectivityIam {
	s.Enabled = &v
	return s
}

type VpcConnectivitySasl struct {
	_ struct{} `type:"structure"`

	Iam *VpcConnectivityIam `locationName:"iam" type:"structure"`

	Scram *VpcConnectivityScram `locationName:"scram" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivitySasl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivitySasl) GoString() string {
	return s.String()
}

// SetIam sets the Iam field's value.
func (s *VpcConnectivitySasl) SetIam(v *VpcConnectivityIam) *VpcConnectivitySasl {
	s.Iam = v
	return s
}

// SetScram sets the Scram field's value.
func (s *VpcConnectivitySasl) SetScram(v *VpcConnectivityScram) *VpcConnectivitySasl {
	s.Scram = v
	return s
}

type VpcConnectivityScram struct {
	_ struct{} `type:"structure"`

	// SASL/SCRAM authentication for VPC connectivity is on or off.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivityScram) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivityScram) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *VpcConnectivityScram) SetEnabled(v bool) *VpcConnectivityScram {
	s.Enabled = &v
	return s
}

type VpcConnectivityTls struct {
	_ struct{} `type:"structure"`

	// TLS authentication for VPC connectivity is on or off.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivityTls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConnectivityTls) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *VpcConnectivityTls) SetEnabled(v bool) *VpcConnectivityTls {
	s.Enabled = &v
	return s
}

// Zookeeper node information.
type ZookeeperNodeInfo struct {
	_ struct{} `type:"structure"`

	// The attached elastic network interface of the broker.
	AttachedENIId *string `locationName:"attachedENIId" type:"string"`

	// The virtual private cloud (VPC) IP address of the client.
	ClientVpcIpAddress *string `locationName:"clientVpcIpAddress" type:"string"`

	// Endpoints for accessing the ZooKeeper.
	Endpoints []*string `locationName:"endpoints" type:"list"`

	// The role-specific ID for Zookeeper.
	ZookeeperId *float64 `locationName:"zookeeperId" type:"double"`

	// The version of Zookeeper.
	ZookeeperVersion *string `locationName:"zookeeperVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZookeeperNodeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZookeeperNodeInfo) GoString() string {
	return s.String()
}

// SetAttachedENIId sets the AttachedENIId field's value.
func (s *ZookeeperNodeInfo) SetAttachedENIId(v string) *ZookeeperNodeInfo {
	s.AttachedENIId = &v
	return s
}

// SetClientVpcIpAddress sets the ClientVpcIpAddress field's value.
func (s *ZookeeperNodeInfo) SetClientVpcIpAddress(v string) *ZookeeperNodeInfo {
	s.ClientVpcIpAddress = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *ZookeeperNodeInfo) SetEndpoints(v []*string) *ZookeeperNodeInfo {
	s.Endpoints = v
	return s
}

// SetZookeeperId sets the ZookeeperId field's value.
func (s *ZookeeperNodeInfo) SetZookeeperId(v float64) *ZookeeperNodeInfo {
	s.ZookeeperId = &v
	return s
}

// SetZookeeperVersion sets the ZookeeperVersion field's value.
func (s *ZookeeperNodeInfo) SetZookeeperVersion(v string) *ZookeeperNodeInfo {
	s.ZookeeperVersion = &v
	return s
}

// The distribution of broker nodes across Availability Zones. By default, broker
// nodes are distributed among the Availability Zones of your Region. Currently,
// the only supported value is DEFAULT. You can either specify this value explicitly
// or leave it out.
const (
	// BrokerAZDistributionDefault is a BrokerAZDistribution enum value
	BrokerAZDistributionDefault = "DEFAULT"
)

// BrokerAZDistribution_Values returns all elements of the BrokerAZDistribution enum
func BrokerAZDistribution_Values() []string {
	return []string{
		BrokerAZDistributionDefault,
	}
}

// Client-broker encryption in transit setting.
const (
	// ClientBrokerTls is a ClientBroker enum value
	ClientBrokerTls = "TLS"

	// ClientBrokerTlsPlaintext is a ClientBroker enum value
	ClientBrokerTlsPlaintext = "TLS_PLAINTEXT"

	// ClientBrokerPlaintext is a ClientBroker enum value
	ClientBrokerPlaintext = "PLAINTEXT"
)

// ClientBroker_Values returns all elements of the ClientBroker enum
func ClientBroker_Values() []string {
	return []string{
		ClientBrokerTls,
		ClientBrokerTlsPlaintext,
		ClientBrokerPlaintext,
	}
}

// The state of an Apache Kafka cluster.
const (
	// ClusterStateActive is a ClusterState enum value
	ClusterStateActive = "ACTIVE"

	// ClusterStateCreating is a ClusterState enum value
	ClusterStateCreating = "CREATING"

	// ClusterStateDeleting is a ClusterState enum value
	ClusterStateDeleting = "DELETING"

	// ClusterStateFailed is a ClusterState enum value
	ClusterStateFailed = "FAILED"

	// ClusterStateHealing is a ClusterState enum value
	ClusterStateHealing = "HEALING"

	// ClusterStateMaintenance is a ClusterState enum value
	ClusterStateMaintenance = "MAINTENANCE"

	// ClusterStateRebootingBroker is a ClusterState enum value
	ClusterStateRebootingBroker = "REBOOTING_BROKER"

	// ClusterStateUpdating is a ClusterState enum value
	ClusterStateUpdating = "UPDATING"
)

// ClusterState_Values returns all elements of the ClusterState enum
func ClusterState_Values() []string {
	return []string{
		ClusterStateActive,
		ClusterStateCreating,
		ClusterStateDeleting,
		ClusterStateFailed,
		ClusterStateHealing,
		ClusterStateMaintenance,
		ClusterStateRebootingBroker,
		ClusterStateUpdating,
	}
}

const (
	// ClusterTypeProvisioned is a ClusterType enum value
	ClusterTypeProvisioned = "PROVISIONED"

	// ClusterTypeServerless is a ClusterType enum value
	ClusterTypeServerless = "SERVERLESS"
)

// ClusterType_Values returns all elements of the ClusterType enum
func ClusterType_Values() []string {
	return []string{
		ClusterTypeProvisioned,
		ClusterTypeServerless,
	}
}

// The state of a configuration.
const (
	// ConfigurationStateActive is a ConfigurationState enum value
	ConfigurationStateActive = "ACTIVE"

	// ConfigurationStateDeleting is a ConfigurationState enum value
	ConfigurationStateDeleting = "DELETING"

	// ConfigurationStateDeleteFailed is a ConfigurationState enum value
	ConfigurationStateDeleteFailed = "DELETE_FAILED"
)

// ConfigurationState_Values returns all elements of the ConfigurationState enum
func ConfigurationState_Values() []string {
	return []string{
		ConfigurationStateActive,
		ConfigurationStateDeleting,
		ConfigurationStateDeleteFailed,
	}
}

// Specifies which metrics are gathered for the MSK cluster. This property has
// the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER,
// and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each
// of these levels of monitoring, see Monitoring (https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html).
const (
	// EnhancedMonitoringDefault is a EnhancedMonitoring enum value
	EnhancedMonitoringDefault = "DEFAULT"

	// EnhancedMonitoringPerBroker is a EnhancedMonitoring enum value
	EnhancedMonitoringPerBroker = "PER_BROKER"

	// EnhancedMonitoringPerTopicPerBroker is a EnhancedMonitoring enum value
	EnhancedMonitoringPerTopicPerBroker = "PER_TOPIC_PER_BROKER"

	// EnhancedMonitoringPerTopicPerPartition is a EnhancedMonitoring enum value
	EnhancedMonitoringPerTopicPerPartition = "PER_TOPIC_PER_PARTITION"
)

// EnhancedMonitoring_Values returns all elements of the EnhancedMonitoring enum
func EnhancedMonitoring_Values() []string {
	return []string{
		EnhancedMonitoringDefault,
		EnhancedMonitoringPerBroker,
		EnhancedMonitoringPerTopicPerBroker,
		EnhancedMonitoringPerTopicPerPartition,
	}
}

// The status of a Apache Kafka version.
const (
	// KafkaVersionStatusActive is a KafkaVersionStatus enum value
	KafkaVersionStatusActive = "ACTIVE"

	// KafkaVersionStatusDeprecated is a KafkaVersionStatus enum value
	KafkaVersionStatusDeprecated = "DEPRECATED"
)

// KafkaVersionStatus_Values returns all elements of the KafkaVersionStatus enum
func KafkaVersionStatus_Values() []string {
	return []string{
		KafkaVersionStatusActive,
		KafkaVersionStatusDeprecated,
	}
}

// The broker or Zookeeper node.
const (
	// NodeTypeBroker is a NodeType enum value
	NodeTypeBroker = "BROKER"
)

// NodeType_Values returns all elements of the NodeType enum
func NodeType_Values() []string {
	return []string{
		NodeTypeBroker,
	}
}

// Controls storage mode for various supported storage tiers.
const (
	// StorageModeLocal is a StorageMode enum value
	StorageModeLocal = "LOCAL"

	// StorageModeTiered is a StorageMode enum value
	StorageModeTiered = "TIERED"
)

// StorageMode_Values returns all elements of the StorageMode enum
func StorageMode_Values() []string {
	return []string{
		StorageModeLocal,
		StorageModeTiered,
	}
}

// The identity type of the requester that calls the API operation.
const (
	// UserIdentityTypeAwsaccount is a UserIdentityType enum value
	UserIdentityTypeAwsaccount = "AWSACCOUNT"

	// UserIdentityTypeAwsservice is a UserIdentityType enum value
	UserIdentityTypeAwsservice = "AWSSERVICE"
)

// UserIdentityType_Values returns all elements of the UserIdentityType enum
func UserIdentityType_Values() []string {
	return []string{
		UserIdentityTypeAwsaccount,
		UserIdentityTypeAwsservice,
	}
}

// The state of a configuration.
const (
	// VpcConnectionStateCreating is a VpcConnectionState enum value
	VpcConnectionStateCreating = "CREATING"

	// VpcConnectionStateAvailable is a VpcConnectionState enum value
	VpcConnectionStateAvailable = "AVAILABLE"

	// VpcConnectionStateInactive is a VpcConnectionState enum value
	VpcConnectionStateInactive = "INACTIVE"

	// VpcConnectionStateDeactivating is a VpcConnectionState enum value
	VpcConnectionStateDeactivating = "DEACTIVATING"

	// VpcConnectionStateDeleting is a VpcConnectionState enum value
	VpcConnectionStateDeleting = "DELETING"

	// VpcConnectionStateFailed is a VpcConnectionState enum value
	VpcConnectionStateFailed = "FAILED"

	// VpcConnectionStateRejected is a VpcConnectionState enum value
	VpcConnectionStateRejected = "REJECTED"

	// VpcConnectionStateRejecting is a VpcConnectionState enum value
	VpcConnectionStateRejecting = "REJECTING"
)

// VpcConnectionState_Values returns all elements of the VpcConnectionState enum
func VpcConnectionState_Values() []string {
	return []string{
		VpcConnectionStateCreating,
		VpcConnectionStateAvailable,
		VpcConnectionStateInactive,
		VpcConnectionStateDeactivating,
		VpcConnectionStateDeleting,
		VpcConnectionStateFailed,
		VpcConnectionStateRejected,
		VpcConnectionStateRejecting,
	}
}
