// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptAdministratorInvitation = "AcceptAdministratorInvitation"

// AcceptAdministratorInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptAdministratorInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptAdministratorInvitation for more information on using the AcceptAdministratorInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptAdministratorInvitationRequest method.
//	req, resp := client.AcceptAdministratorInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptAdministratorInvitation
func (c *SecurityHub) AcceptAdministratorInvitationRequest(input *AcceptAdministratorInvitationInput) (req *request.Request, output *AcceptAdministratorInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptAdministratorInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/administrator",
	}

	if input == nil {
		input = &AcceptAdministratorInvitationInput{}
	}

	output = &AcceptAdministratorInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptAdministratorInvitation API operation for AWS SecurityHub.
//
// Accepts the invitation to be a member account and be monitored by the Security
// Hub administrator account that the invitation was sent from.
//
// This operation is only used by member accounts that are not added through
// Organizations.
//
// When the member account accepts the invitation, permission is granted to
// the administrator account to view findings generated in the member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation AcceptAdministratorInvitation for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptAdministratorInvitation
func (c *SecurityHub) AcceptAdministratorInvitation(input *AcceptAdministratorInvitationInput) (*AcceptAdministratorInvitationOutput, error) {
	req, out := c.AcceptAdministratorInvitationRequest(input)
	return out, req.Send()
}

// AcceptAdministratorInvitationWithContext is the same as AcceptAdministratorInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptAdministratorInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) AcceptAdministratorInvitationWithContext(ctx aws.Context, input *AcceptAdministratorInvitationInput, opts ...request.Option) (*AcceptAdministratorInvitationOutput, error) {
	req, out := c.AcceptAdministratorInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptInvitation = "AcceptInvitation"

// AcceptInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInvitation for more information on using the AcceptInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptInvitationRequest method.
//	req, resp := client.AcceptInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation
//
// Deprecated: This API has been deprecated, use AcceptAdministratorInvitation API instead.
func (c *SecurityHub) AcceptInvitationRequest(input *AcceptInvitationInput) (req *request.Request, output *AcceptInvitationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, AcceptInvitation, has been deprecated")
	}
	op := &request.Operation{
		Name:       opAcceptInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &AcceptInvitationInput{}
	}

	output = &AcceptInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptInvitation API operation for AWS SecurityHub.
//
// This method is deprecated. Instead, use AcceptAdministratorInvitation.
//
// The Security Hub console continues to use AcceptInvitation. It will eventually
// change to use AcceptAdministratorInvitation. Any IAM policies that specifically
// control access to this function must continue to use AcceptInvitation. You
// should also add AcceptAdministratorInvitation to your policies to ensure
// that the correct permissions are in place after the console begins to use
// AcceptAdministratorInvitation.
//
// Accepts the invitation to be a member account and be monitored by the Security
// Hub administrator account that the invitation was sent from.
//
// This operation is only used by member accounts that are not added through
// Organizations.
//
// When the member account accepts the invitation, permission is granted to
// the administrator account to view findings generated in the member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation AcceptInvitation for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation
//
// Deprecated: This API has been deprecated, use AcceptAdministratorInvitation API instead.
func (c *SecurityHub) AcceptInvitation(input *AcceptInvitationInput) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	return out, req.Send()
}

// AcceptInvitationWithContext is the same as AcceptInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This API has been deprecated, use AcceptAdministratorInvitation API instead.
func (c *SecurityHub) AcceptInvitationWithContext(ctx aws.Context, input *AcceptInvitationInput, opts ...request.Option) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteAutomationRules = "BatchDeleteAutomationRules"

// BatchDeleteAutomationRulesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteAutomationRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteAutomationRules for more information on using the BatchDeleteAutomationRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteAutomationRulesRequest method.
//	req, resp := client.BatchDeleteAutomationRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDeleteAutomationRules
func (c *SecurityHub) BatchDeleteAutomationRulesRequest(input *BatchDeleteAutomationRulesInput) (req *request.Request, output *BatchDeleteAutomationRulesOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteAutomationRules,
		HTTPMethod: "POST",
		HTTPPath:   "/automationrules/delete",
	}

	if input == nil {
		input = &BatchDeleteAutomationRulesInput{}
	}

	output = &BatchDeleteAutomationRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteAutomationRules API operation for AWS SecurityHub.
//
// Deletes one or more automation rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchDeleteAutomationRules for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDeleteAutomationRules
func (c *SecurityHub) BatchDeleteAutomationRules(input *BatchDeleteAutomationRulesInput) (*BatchDeleteAutomationRulesOutput, error) {
	req, out := c.BatchDeleteAutomationRulesRequest(input)
	return out, req.Send()
}

// BatchDeleteAutomationRulesWithContext is the same as BatchDeleteAutomationRules with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteAutomationRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchDeleteAutomationRulesWithContext(ctx aws.Context, input *BatchDeleteAutomationRulesInput, opts ...request.Option) (*BatchDeleteAutomationRulesOutput, error) {
	req, out := c.BatchDeleteAutomationRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisableStandards = "BatchDisableStandards"

// BatchDisableStandardsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisableStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisableStandards for more information on using the BatchDisableStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDisableStandardsRequest method.
//	req, resp := client.BatchDisableStandardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards
func (c *SecurityHub) BatchDisableStandardsRequest(input *BatchDisableStandardsInput) (req *request.Request, output *BatchDisableStandardsOutput) {
	op := &request.Operation{
		Name:       opBatchDisableStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/deregister",
	}

	if input == nil {
		input = &BatchDisableStandardsInput{}
	}

	output = &BatchDisableStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisableStandards API operation for AWS SecurityHub.
//
// Disables the standards specified by the provided StandardsSubscriptionArns.
//
// For more information, see Security Standards (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html)
// section of the Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchDisableStandards for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards
func (c *SecurityHub) BatchDisableStandards(input *BatchDisableStandardsInput) (*BatchDisableStandardsOutput, error) {
	req, out := c.BatchDisableStandardsRequest(input)
	return out, req.Send()
}

// BatchDisableStandardsWithContext is the same as BatchDisableStandards with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisableStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchDisableStandardsWithContext(ctx aws.Context, input *BatchDisableStandardsInput, opts ...request.Option) (*BatchDisableStandardsOutput, error) {
	req, out := c.BatchDisableStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchEnableStandards = "BatchEnableStandards"

// BatchEnableStandardsRequest generates a "aws/request.Request" representing the
// client's request for the BatchEnableStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchEnableStandards for more information on using the BatchEnableStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchEnableStandardsRequest method.
//	req, resp := client.BatchEnableStandardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards
func (c *SecurityHub) BatchEnableStandardsRequest(input *BatchEnableStandardsInput) (req *request.Request, output *BatchEnableStandardsOutput) {
	op := &request.Operation{
		Name:       opBatchEnableStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/register",
	}

	if input == nil {
		input = &BatchEnableStandardsInput{}
	}

	output = &BatchEnableStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchEnableStandards API operation for AWS SecurityHub.
//
// Enables the standards specified by the provided StandardsArn. To obtain the
// ARN for a standard, use the DescribeStandards operation.
//
// For more information, see the Security Standards (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html)
// section of the Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchEnableStandards for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards
func (c *SecurityHub) BatchEnableStandards(input *BatchEnableStandardsInput) (*BatchEnableStandardsOutput, error) {
	req, out := c.BatchEnableStandardsRequest(input)
	return out, req.Send()
}

// BatchEnableStandardsWithContext is the same as BatchEnableStandards with the addition of
// the ability to pass a context and additional request options.
//
// See BatchEnableStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchEnableStandardsWithContext(ctx aws.Context, input *BatchEnableStandardsInput, opts ...request.Option) (*BatchEnableStandardsOutput, error) {
	req, out := c.BatchEnableStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetAutomationRules = "BatchGetAutomationRules"

// BatchGetAutomationRulesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetAutomationRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetAutomationRules for more information on using the BatchGetAutomationRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetAutomationRulesRequest method.
//	req, resp := client.BatchGetAutomationRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetAutomationRules
func (c *SecurityHub) BatchGetAutomationRulesRequest(input *BatchGetAutomationRulesInput) (req *request.Request, output *BatchGetAutomationRulesOutput) {
	op := &request.Operation{
		Name:       opBatchGetAutomationRules,
		HTTPMethod: "POST",
		HTTPPath:   "/automationrules/get",
	}

	if input == nil {
		input = &BatchGetAutomationRulesInput{}
	}

	output = &BatchGetAutomationRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetAutomationRules API operation for AWS SecurityHub.
//
// Retrieves a list of details for automation rules based on rule Amazon Resource
// Names (ARNs).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchGetAutomationRules for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action specified in the request.
//
//   - InternalException
//     Internal server error.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetAutomationRules
func (c *SecurityHub) BatchGetAutomationRules(input *BatchGetAutomationRulesInput) (*BatchGetAutomationRulesOutput, error) {
	req, out := c.BatchGetAutomationRulesRequest(input)
	return out, req.Send()
}

// BatchGetAutomationRulesWithContext is the same as BatchGetAutomationRules with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetAutomationRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchGetAutomationRulesWithContext(ctx aws.Context, input *BatchGetAutomationRulesInput, opts ...request.Option) (*BatchGetAutomationRulesOutput, error) {
	req, out := c.BatchGetAutomationRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetSecurityControls = "BatchGetSecurityControls"

// BatchGetSecurityControlsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetSecurityControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetSecurityControls for more information on using the BatchGetSecurityControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetSecurityControlsRequest method.
//	req, resp := client.BatchGetSecurityControlsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetSecurityControls
func (c *SecurityHub) BatchGetSecurityControlsRequest(input *BatchGetSecurityControlsInput) (req *request.Request, output *BatchGetSecurityControlsOutput) {
	op := &request.Operation{
		Name:       opBatchGetSecurityControls,
		HTTPMethod: "POST",
		HTTPPath:   "/securityControls/batchGet",
	}

	if input == nil {
		input = &BatchGetSecurityControlsInput{}
	}

	output = &BatchGetSecurityControlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetSecurityControls API operation for AWS SecurityHub.
//
// Provides details about a batch of security controls for the current Amazon
// Web Services account and Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchGetSecurityControls for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetSecurityControls
func (c *SecurityHub) BatchGetSecurityControls(input *BatchGetSecurityControlsInput) (*BatchGetSecurityControlsOutput, error) {
	req, out := c.BatchGetSecurityControlsRequest(input)
	return out, req.Send()
}

// BatchGetSecurityControlsWithContext is the same as BatchGetSecurityControls with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetSecurityControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchGetSecurityControlsWithContext(ctx aws.Context, input *BatchGetSecurityControlsInput, opts ...request.Option) (*BatchGetSecurityControlsOutput, error) {
	req, out := c.BatchGetSecurityControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetStandardsControlAssociations = "BatchGetStandardsControlAssociations"

// BatchGetStandardsControlAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetStandardsControlAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetStandardsControlAssociations for more information on using the BatchGetStandardsControlAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetStandardsControlAssociationsRequest method.
//	req, resp := client.BatchGetStandardsControlAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetStandardsControlAssociations
func (c *SecurityHub) BatchGetStandardsControlAssociationsRequest(input *BatchGetStandardsControlAssociationsInput) (req *request.Request, output *BatchGetStandardsControlAssociationsOutput) {
	op := &request.Operation{
		Name:       opBatchGetStandardsControlAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/associations/batchGet",
	}

	if input == nil {
		input = &BatchGetStandardsControlAssociationsInput{}
	}

	output = &BatchGetStandardsControlAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetStandardsControlAssociations API operation for AWS SecurityHub.
//
// For a batch of security controls and standards, identifies whether each control
// is currently enabled or disabled in a standard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchGetStandardsControlAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetStandardsControlAssociations
func (c *SecurityHub) BatchGetStandardsControlAssociations(input *BatchGetStandardsControlAssociationsInput) (*BatchGetStandardsControlAssociationsOutput, error) {
	req, out := c.BatchGetStandardsControlAssociationsRequest(input)
	return out, req.Send()
}

// BatchGetStandardsControlAssociationsWithContext is the same as BatchGetStandardsControlAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetStandardsControlAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchGetStandardsControlAssociationsWithContext(ctx aws.Context, input *BatchGetStandardsControlAssociationsInput, opts ...request.Option) (*BatchGetStandardsControlAssociationsOutput, error) {
	req, out := c.BatchGetStandardsControlAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchImportFindings = "BatchImportFindings"

// BatchImportFindingsRequest generates a "aws/request.Request" representing the
// client's request for the BatchImportFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchImportFindings for more information on using the BatchImportFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchImportFindingsRequest method.
//	req, resp := client.BatchImportFindingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings
func (c *SecurityHub) BatchImportFindingsRequest(input *BatchImportFindingsInput) (req *request.Request, output *BatchImportFindingsOutput) {
	op := &request.Operation{
		Name:       opBatchImportFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/import",
	}

	if input == nil {
		input = &BatchImportFindingsInput{}
	}

	output = &BatchImportFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchImportFindings API operation for AWS SecurityHub.
//
// Imports security findings generated by a finding provider into Security Hub.
// This action is requested by the finding provider to import its findings into
// Security Hub.
//
// BatchImportFindings must be called by one of the following:
//
//   - The Amazon Web Services account that is associated with a finding if
//     you are using the default product ARN (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-providers.html#securityhub-custom-providers-bfi-reqs)
//     or are a partner sending findings from within a customer's Amazon Web
//     Services account. In these cases, the identifier of the account that you
//     are calling BatchImportFindings from needs to be the same as the AwsAccountId
//     attribute for the finding.
//
//   - An Amazon Web Services account that Security Hub has allow-listed for
//     an official partner integration. In this case, you can call BatchImportFindings
//     from the allow-listed account and send findings from different customer
//     accounts in the same batch.
//
// The maximum allowed size for a finding is 240 Kb. An error is returned for
// any finding larger than 240 Kb.
//
// After a finding is created, BatchImportFindings cannot be used to update
// the following finding fields and objects, which Security Hub customers use
// to manage their investigation workflow.
//
//   - Note
//
//   - UserDefinedFields
//
//   - VerificationState
//
//   - Workflow
//
// Finding providers also should not use BatchImportFindings to update the following
// attributes.
//
//   - Confidence
//
//   - Criticality
//
//   - RelatedFindings
//
//   - Severity
//
//   - Types
//
// Instead, finding providers use FindingProviderFields to provide values for
// these attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchImportFindings for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings
func (c *SecurityHub) BatchImportFindings(input *BatchImportFindingsInput) (*BatchImportFindingsOutput, error) {
	req, out := c.BatchImportFindingsRequest(input)
	return out, req.Send()
}

// BatchImportFindingsWithContext is the same as BatchImportFindings with the addition of
// the ability to pass a context and additional request options.
//
// See BatchImportFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchImportFindingsWithContext(ctx aws.Context, input *BatchImportFindingsInput, opts ...request.Option) (*BatchImportFindingsOutput, error) {
	req, out := c.BatchImportFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateAutomationRules = "BatchUpdateAutomationRules"

// BatchUpdateAutomationRulesRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateAutomationRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateAutomationRules for more information on using the BatchUpdateAutomationRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateAutomationRulesRequest method.
//	req, resp := client.BatchUpdateAutomationRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateAutomationRules
func (c *SecurityHub) BatchUpdateAutomationRulesRequest(input *BatchUpdateAutomationRulesInput) (req *request.Request, output *BatchUpdateAutomationRulesOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateAutomationRules,
		HTTPMethod: "PATCH",
		HTTPPath:   "/automationrules/update",
	}

	if input == nil {
		input = &BatchUpdateAutomationRulesInput{}
	}

	output = &BatchUpdateAutomationRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateAutomationRules API operation for AWS SecurityHub.
//
// Updates one or more automation rules based on rule Amazon Resource Names
// (ARNs) and input parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchUpdateAutomationRules for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateAutomationRules
func (c *SecurityHub) BatchUpdateAutomationRules(input *BatchUpdateAutomationRulesInput) (*BatchUpdateAutomationRulesOutput, error) {
	req, out := c.BatchUpdateAutomationRulesRequest(input)
	return out, req.Send()
}

// BatchUpdateAutomationRulesWithContext is the same as BatchUpdateAutomationRules with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateAutomationRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchUpdateAutomationRulesWithContext(ctx aws.Context, input *BatchUpdateAutomationRulesInput, opts ...request.Option) (*BatchUpdateAutomationRulesOutput, error) {
	req, out := c.BatchUpdateAutomationRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateFindings = "BatchUpdateFindings"

// BatchUpdateFindingsRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateFindings for more information on using the BatchUpdateFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateFindingsRequest method.
//	req, resp := client.BatchUpdateFindingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings
func (c *SecurityHub) BatchUpdateFindingsRequest(input *BatchUpdateFindingsInput) (req *request.Request, output *BatchUpdateFindingsOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateFindings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findings/batchupdate",
	}

	if input == nil {
		input = &BatchUpdateFindingsInput{}
	}

	output = &BatchUpdateFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateFindings API operation for AWS SecurityHub.
//
// Used by Security Hub customers to update information about their investigation
// into a finding. Requested by administrator accounts or member accounts. Administrator
// accounts can update findings for their account and their member accounts.
// Member accounts can update findings for their account.
//
// Updates from BatchUpdateFindings do not affect the value of UpdatedAt for
// a finding.
//
// Administrator and member accounts can use BatchUpdateFindings to update the
// following finding fields and objects.
//
//   - Confidence
//
//   - Criticality
//
//   - Note
//
//   - RelatedFindings
//
//   - Severity
//
//   - Types
//
//   - UserDefinedFields
//
//   - VerificationState
//
//   - Workflow
//
// You can configure IAM policies to restrict access to fields and field values.
// For example, you might not want member accounts to be able to suppress findings
// or change the finding severity. See Configuring access to BatchUpdateFindings
// (https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access)
// in the Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchUpdateFindings for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings
func (c *SecurityHub) BatchUpdateFindings(input *BatchUpdateFindingsInput) (*BatchUpdateFindingsOutput, error) {
	req, out := c.BatchUpdateFindingsRequest(input)
	return out, req.Send()
}

// BatchUpdateFindingsWithContext is the same as BatchUpdateFindings with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchUpdateFindingsWithContext(ctx aws.Context, input *BatchUpdateFindingsInput, opts ...request.Option) (*BatchUpdateFindingsOutput, error) {
	req, out := c.BatchUpdateFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateStandardsControlAssociations = "BatchUpdateStandardsControlAssociations"

// BatchUpdateStandardsControlAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateStandardsControlAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateStandardsControlAssociations for more information on using the BatchUpdateStandardsControlAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateStandardsControlAssociationsRequest method.
//	req, resp := client.BatchUpdateStandardsControlAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateStandardsControlAssociations
func (c *SecurityHub) BatchUpdateStandardsControlAssociationsRequest(input *BatchUpdateStandardsControlAssociationsInput) (req *request.Request, output *BatchUpdateStandardsControlAssociationsOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateStandardsControlAssociations,
		HTTPMethod: "PATCH",
		HTTPPath:   "/associations",
	}

	if input == nil {
		input = &BatchUpdateStandardsControlAssociationsInput{}
	}

	output = &BatchUpdateStandardsControlAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateStandardsControlAssociations API operation for AWS SecurityHub.
//
// For a batch of security controls and standards, this operation updates the
// enablement status of a control in a standard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchUpdateStandardsControlAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateStandardsControlAssociations
func (c *SecurityHub) BatchUpdateStandardsControlAssociations(input *BatchUpdateStandardsControlAssociationsInput) (*BatchUpdateStandardsControlAssociationsOutput, error) {
	req, out := c.BatchUpdateStandardsControlAssociationsRequest(input)
	return out, req.Send()
}

// BatchUpdateStandardsControlAssociationsWithContext is the same as BatchUpdateStandardsControlAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateStandardsControlAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchUpdateStandardsControlAssociationsWithContext(ctx aws.Context, input *BatchUpdateStandardsControlAssociationsInput, opts ...request.Option) (*BatchUpdateStandardsControlAssociationsOutput, error) {
	req, out := c.BatchUpdateStandardsControlAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateActionTarget = "CreateActionTarget"

// CreateActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the CreateActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateActionTarget for more information on using the CreateActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateActionTargetRequest method.
//	req, resp := client.CreateActionTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget
func (c *SecurityHub) CreateActionTargetRequest(input *CreateActionTargetInput) (req *request.Request, output *CreateActionTargetOutput) {
	op := &request.Operation{
		Name:       opCreateActionTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/actionTargets",
	}

	if input == nil {
		input = &CreateActionTargetInput{}
	}

	output = &CreateActionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateActionTarget API operation for AWS SecurityHub.
//
// Creates a custom action target in Security Hub.
//
// You can use custom actions on findings and insights in Security Hub to trigger
// target actions in Amazon CloudWatch Events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateActionTarget for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceConflictException
//     The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget
func (c *SecurityHub) CreateActionTarget(input *CreateActionTargetInput) (*CreateActionTargetOutput, error) {
	req, out := c.CreateActionTargetRequest(input)
	return out, req.Send()
}

// CreateActionTargetWithContext is the same as CreateActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateActionTargetWithContext(ctx aws.Context, input *CreateActionTargetInput, opts ...request.Option) (*CreateActionTargetOutput, error) {
	req, out := c.CreateActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAutomationRule = "CreateAutomationRule"

// CreateAutomationRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateAutomationRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAutomationRule for more information on using the CreateAutomationRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAutomationRuleRequest method.
//	req, resp := client.CreateAutomationRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateAutomationRule
func (c *SecurityHub) CreateAutomationRuleRequest(input *CreateAutomationRuleInput) (req *request.Request, output *CreateAutomationRuleOutput) {
	op := &request.Operation{
		Name:       opCreateAutomationRule,
		HTTPMethod: "POST",
		HTTPPath:   "/automationrules/create",
	}

	if input == nil {
		input = &CreateAutomationRuleInput{}
	}

	output = &CreateAutomationRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAutomationRule API operation for AWS SecurityHub.
//
// Creates an automation rule based on input parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateAutomationRule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action specified in the request.
//
//   - InternalException
//     Internal server error.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateAutomationRule
func (c *SecurityHub) CreateAutomationRule(input *CreateAutomationRuleInput) (*CreateAutomationRuleOutput, error) {
	req, out := c.CreateAutomationRuleRequest(input)
	return out, req.Send()
}

// CreateAutomationRuleWithContext is the same as CreateAutomationRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAutomationRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateAutomationRuleWithContext(ctx aws.Context, input *CreateAutomationRuleInput, opts ...request.Option) (*CreateAutomationRuleOutput, error) {
	req, out := c.CreateAutomationRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFindingAggregator = "CreateFindingAggregator"

// CreateFindingAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the CreateFindingAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFindingAggregator for more information on using the CreateFindingAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFindingAggregatorRequest method.
//	req, resp := client.CreateFindingAggregatorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateFindingAggregator
func (c *SecurityHub) CreateFindingAggregatorRequest(input *CreateFindingAggregatorInput) (req *request.Request, output *CreateFindingAggregatorOutput) {
	op := &request.Operation{
		Name:       opCreateFindingAggregator,
		HTTPMethod: "POST",
		HTTPPath:   "/findingAggregator/create",
	}

	if input == nil {
		input = &CreateFindingAggregatorInput{}
	}

	output = &CreateFindingAggregatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFindingAggregator API operation for AWS SecurityHub.
//
// Used to enable finding aggregation. Must be called from the aggregation Region.
//
// For more details about cross-Region replication, see Configuring finding
// aggregation (https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html)
// in the Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateFindingAggregator for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - AccessDeniedException
//     You don't have permission to perform the action specified in the request.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateFindingAggregator
func (c *SecurityHub) CreateFindingAggregator(input *CreateFindingAggregatorInput) (*CreateFindingAggregatorOutput, error) {
	req, out := c.CreateFindingAggregatorRequest(input)
	return out, req.Send()
}

// CreateFindingAggregatorWithContext is the same as CreateFindingAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFindingAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateFindingAggregatorWithContext(ctx aws.Context, input *CreateFindingAggregatorInput, opts ...request.Option) (*CreateFindingAggregatorOutput, error) {
	req, out := c.CreateFindingAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInsight = "CreateInsight"

// CreateInsightRequest generates a "aws/request.Request" representing the
// client's request for the CreateInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInsight for more information on using the CreateInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInsightRequest method.
//	req, resp := client.CreateInsightRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *SecurityHub) CreateInsightRequest(input *CreateInsightInput) (req *request.Request, output *CreateInsightOutput) {
	op := &request.Operation{
		Name:       opCreateInsight,
		HTTPMethod: "POST",
		HTTPPath:   "/insights",
	}

	if input == nil {
		input = &CreateInsightInput{}
	}

	output = &CreateInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInsight API operation for AWS SecurityHub.
//
// Creates a custom insight in Security Hub. An insight is a consolidation of
// findings that relate to a security issue that requires attention or remediation.
//
// To group the related findings in the insight, use the GroupByAttribute.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateInsight for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceConflictException
//     The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *SecurityHub) CreateInsight(input *CreateInsightInput) (*CreateInsightOutput, error) {
	req, out := c.CreateInsightRequest(input)
	return out, req.Send()
}

// CreateInsightWithContext is the same as CreateInsight with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateInsightWithContext(ctx aws.Context, input *CreateInsightInput, opts ...request.Option) (*CreateInsightOutput, error) {
	req, out := c.CreateInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMembers = "CreateMembers"

// CreateMembersRequest generates a "aws/request.Request" representing the
// client's request for the CreateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMembers for more information on using the CreateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMembersRequest method.
//	req, resp := client.CreateMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers
func (c *SecurityHub) CreateMembersRequest(input *CreateMembersInput) (req *request.Request, output *CreateMembersOutput) {
	op := &request.Operation{
		Name:       opCreateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members",
	}

	if input == nil {
		input = &CreateMembersInput{}
	}

	output = &CreateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMembers API operation for AWS SecurityHub.
//
// Creates a member association in Security Hub between the specified accounts
// and the account used to make the request, which is the administrator account.
// If you are integrated with Organizations, then the administrator account
// is designated by the organization management account.
//
// CreateMembers is always used to add accounts that are not organization members.
//
// For accounts that are managed using Organizations, CreateMembers is only
// used in the following cases:
//
//   - Security Hub is not configured to automatically add new organization
//     accounts.
//
//   - The account was disassociated or deleted in Security Hub.
//
// This action can only be used by an account that has Security Hub enabled.
// To enable Security Hub, you can use the EnableSecurityHub operation.
//
// For accounts that are not organization members, you create the account association
// and then send an invitation to the member account. To send the invitation,
// you use the InviteMembers operation. If the account owner accepts the invitation,
// the account becomes a member account in Security Hub.
//
// Accounts that are managed using Organizations do not receive an invitation.
// They automatically become a member account in Security Hub.
//
//   - If the organization account does not have Security Hub enabled, then
//     Security Hub and the default standards are automatically enabled. Note
//     that Security Hub cannot be enabled automatically for the organization
//     management account. The organization management account must enable Security
//     Hub before the administrator account enables it as a member account.
//
//   - For organization accounts that already have Security Hub enabled, Security
//     Hub does not make any other changes to those accounts. It does not change
//     their enabled standards or controls.
//
// A permissions policy is added that permits the administrator account to view
// the findings generated in the member account.
//
// To remove the association between the administrator and member accounts,
// use the DisassociateFromMasterAccount or DisassociateMembers operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateMembers for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceConflictException
//     The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers
func (c *SecurityHub) CreateMembers(input *CreateMembersInput) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	return out, req.Send()
}

// CreateMembersWithContext is the same as CreateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateMembersWithContext(ctx aws.Context, input *CreateMembersInput, opts ...request.Option) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeclineInvitations = "DeclineInvitations"

// DeclineInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeclineInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeclineInvitations for more information on using the DeclineInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeclineInvitationsRequest method.
//	req, resp := client.DeclineInvitationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations
func (c *SecurityHub) DeclineInvitationsRequest(input *DeclineInvitationsInput) (req *request.Request, output *DeclineInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeclineInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/decline",
	}

	if input == nil {
		input = &DeclineInvitationsInput{}
	}

	output = &DeclineInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeclineInvitations API operation for AWS SecurityHub.
//
// Declines invitations to become a member account.
//
// A prospective member account uses this operation to decline an invitation
// to become a member.
//
// This operation is only called by member accounts that aren't part of an organization.
// Organization accounts don't receive invitations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeclineInvitations for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations
func (c *SecurityHub) DeclineInvitations(input *DeclineInvitationsInput) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	return out, req.Send()
}

// DeclineInvitationsWithContext is the same as DeclineInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeclineInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeclineInvitationsWithContext(ctx aws.Context, input *DeclineInvitationsInput, opts ...request.Option) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteActionTarget = "DeleteActionTarget"

// DeleteActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteActionTarget for more information on using the DeleteActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteActionTargetRequest method.
//	req, resp := client.DeleteActionTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget
func (c *SecurityHub) DeleteActionTargetRequest(input *DeleteActionTargetInput) (req *request.Request, output *DeleteActionTargetOutput) {
	op := &request.Operation{
		Name:       opDeleteActionTarget,
		HTTPMethod: "DELETE",
		HTTPPath:   "/actionTargets/{ActionTargetArn+}",
	}

	if input == nil {
		input = &DeleteActionTargetInput{}
	}

	output = &DeleteActionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteActionTarget API operation for AWS SecurityHub.
//
// Deletes a custom action target from Security Hub.
//
// Deleting a custom action target does not affect any findings or insights
// that were already sent to Amazon CloudWatch Events using the custom action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteActionTarget for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget
func (c *SecurityHub) DeleteActionTarget(input *DeleteActionTargetInput) (*DeleteActionTargetOutput, error) {
	req, out := c.DeleteActionTargetRequest(input)
	return out, req.Send()
}

// DeleteActionTargetWithContext is the same as DeleteActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteActionTargetWithContext(ctx aws.Context, input *DeleteActionTargetInput, opts ...request.Option) (*DeleteActionTargetOutput, error) {
	req, out := c.DeleteActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFindingAggregator = "DeleteFindingAggregator"

// DeleteFindingAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFindingAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFindingAggregator for more information on using the DeleteFindingAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFindingAggregatorRequest method.
//	req, resp := client.DeleteFindingAggregatorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteFindingAggregator
func (c *SecurityHub) DeleteFindingAggregatorRequest(input *DeleteFindingAggregatorInput) (req *request.Request, output *DeleteFindingAggregatorOutput) {
	op := &request.Operation{
		Name:       opDeleteFindingAggregator,
		HTTPMethod: "DELETE",
		HTTPPath:   "/findingAggregator/delete/{FindingAggregatorArn+}",
	}

	if input == nil {
		input = &DeleteFindingAggregatorInput{}
	}

	output = &DeleteFindingAggregatorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFindingAggregator API operation for AWS SecurityHub.
//
// Deletes a finding aggregator. When you delete the finding aggregator, you
// stop finding aggregation.
//
// When you stop finding aggregation, findings that were already aggregated
// to the aggregation Region are still visible from the aggregation Region.
// New findings and finding updates are not aggregated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteFindingAggregator for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - AccessDeniedException
//     You don't have permission to perform the action specified in the request.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteFindingAggregator
func (c *SecurityHub) DeleteFindingAggregator(input *DeleteFindingAggregatorInput) (*DeleteFindingAggregatorOutput, error) {
	req, out := c.DeleteFindingAggregatorRequest(input)
	return out, req.Send()
}

// DeleteFindingAggregatorWithContext is the same as DeleteFindingAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFindingAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteFindingAggregatorWithContext(ctx aws.Context, input *DeleteFindingAggregatorInput, opts ...request.Option) (*DeleteFindingAggregatorOutput, error) {
	req, out := c.DeleteFindingAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInsight = "DeleteInsight"

// DeleteInsightRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInsight for more information on using the DeleteInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInsightRequest method.
//	req, resp := client.DeleteInsightRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *SecurityHub) DeleteInsightRequest(input *DeleteInsightInput) (req *request.Request, output *DeleteInsightOutput) {
	op := &request.Operation{
		Name:       opDeleteInsight,
		HTTPMethod: "DELETE",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &DeleteInsightInput{}
	}

	output = &DeleteInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInsight API operation for AWS SecurityHub.
//
// Deletes the insight specified by the InsightArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteInsight for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *SecurityHub) DeleteInsight(input *DeleteInsightInput) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	return out, req.Send()
}

// DeleteInsightWithContext is the same as DeleteInsight with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteInsightWithContext(ctx aws.Context, input *DeleteInsightInput, opts ...request.Option) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInvitations = "DeleteInvitations"

// DeleteInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInvitations for more information on using the DeleteInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInvitationsRequest method.
//	req, resp := client.DeleteInvitationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations
func (c *SecurityHub) DeleteInvitationsRequest(input *DeleteInvitationsInput) (req *request.Request, output *DeleteInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeleteInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/delete",
	}

	if input == nil {
		input = &DeleteInvitationsInput{}
	}

	output = &DeleteInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInvitations API operation for AWS SecurityHub.
//
// Deletes invitations received by the Amazon Web Services account to become
// a member account.
//
// A Security Hub administrator account can use this operation to delete invitations
// sent to one or more member accounts.
//
// This operation is only used to delete invitations that are sent to member
// accounts that aren't part of an organization. Organization accounts don't
// receive invitations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteInvitations for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations
func (c *SecurityHub) DeleteInvitations(input *DeleteInvitationsInput) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	return out, req.Send()
}

// DeleteInvitationsWithContext is the same as DeleteInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteInvitationsWithContext(ctx aws.Context, input *DeleteInvitationsInput, opts ...request.Option) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMembers = "DeleteMembers"

// DeleteMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMembers for more information on using the DeleteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMembersRequest method.
//	req, resp := client.DeleteMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers
func (c *SecurityHub) DeleteMembersRequest(input *DeleteMembersInput) (req *request.Request, output *DeleteMembersOutput) {
	op := &request.Operation{
		Name:       opDeleteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/delete",
	}

	if input == nil {
		input = &DeleteMembersInput{}
	}

	output = &DeleteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMembers API operation for AWS SecurityHub.
//
// Deletes the specified member accounts from Security Hub.
//
// Can be used to delete member accounts that belong to an organization as well
// as member accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteMembers for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers
func (c *SecurityHub) DeleteMembers(input *DeleteMembersInput) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	return out, req.Send()
}

// DeleteMembersWithContext is the same as DeleteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteMembersWithContext(ctx aws.Context, input *DeleteMembersInput, opts ...request.Option) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActionTargets = "DescribeActionTargets"

// DescribeActionTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActionTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActionTargets for more information on using the DescribeActionTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeActionTargetsRequest method.
//	req, resp := client.DescribeActionTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets
func (c *SecurityHub) DescribeActionTargetsRequest(input *DescribeActionTargetsInput) (req *request.Request, output *DescribeActionTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeActionTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/actionTargets/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeActionTargetsInput{}
	}

	output = &DescribeActionTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActionTargets API operation for AWS SecurityHub.
//
// Returns a list of the custom action targets in Security Hub in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeActionTargets for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets
func (c *SecurityHub) DescribeActionTargets(input *DescribeActionTargetsInput) (*DescribeActionTargetsOutput, error) {
	req, out := c.DescribeActionTargetsRequest(input)
	return out, req.Send()
}

// DescribeActionTargetsWithContext is the same as DescribeActionTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActionTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeActionTargetsWithContext(ctx aws.Context, input *DescribeActionTargetsInput, opts ...request.Option) (*DescribeActionTargetsOutput, error) {
	req, out := c.DescribeActionTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeActionTargetsPages iterates over the pages of a DescribeActionTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeActionTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeActionTargets operation.
//	pageNum := 0
//	err := client.DescribeActionTargetsPages(params,
//	    func(page *securityhub.DescribeActionTargetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) DescribeActionTargetsPages(input *DescribeActionTargetsInput, fn func(*DescribeActionTargetsOutput, bool) bool) error {
	return c.DescribeActionTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeActionTargetsPagesWithContext same as DescribeActionTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeActionTargetsPagesWithContext(ctx aws.Context, input *DescribeActionTargetsInput, fn func(*DescribeActionTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeActionTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeActionTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeActionTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHub = "DescribeHub"

// DescribeHubRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHub for more information on using the DescribeHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeHubRequest method.
//	req, resp := client.DescribeHubRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub
func (c *SecurityHub) DescribeHubRequest(input *DescribeHubInput) (req *request.Request, output *DescribeHubOutput) {
	op := &request.Operation{
		Name:       opDescribeHub,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &DescribeHubInput{}
	}

	output = &DescribeHubOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHub API operation for AWS SecurityHub.
//
// Returns details about the Hub resource in your account, including the HubArn
// and the time when you enabled Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeHub for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub
func (c *SecurityHub) DescribeHub(input *DescribeHubInput) (*DescribeHubOutput, error) {
	req, out := c.DescribeHubRequest(input)
	return out, req.Send()
}

// DescribeHubWithContext is the same as DescribeHub with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeHubWithContext(ctx aws.Context, input *DescribeHubInput, opts ...request.Option) (*DescribeHubOutput, error) {
	req, out := c.DescribeHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConfiguration = "DescribeOrganizationConfiguration"

// DescribeOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfiguration for more information on using the DescribeOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOrganizationConfigurationRequest method.
//	req, resp := client.DescribeOrganizationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration
func (c *SecurityHub) DescribeOrganizationConfigurationRequest(input *DescribeOrganizationConfigurationInput) (req *request.Request, output *DescribeOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/organization/configuration",
	}

	if input == nil {
		input = &DescribeOrganizationConfigurationInput{}
	}

	output = &DescribeOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfiguration API operation for AWS SecurityHub.
//
// Returns information about the Organizations configuration for Security Hub.
// Can only be called from a Security Hub administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration
func (c *SecurityHub) DescribeOrganizationConfiguration(input *DescribeOrganizationConfigurationInput) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigurationWithContext is the same as DescribeOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeOrganizationConfigurationWithContext(ctx aws.Context, input *DescribeOrganizationConfigurationInput, opts ...request.Option) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProducts = "DescribeProducts"

// DescribeProductsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProducts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProducts for more information on using the DescribeProducts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeProductsRequest method.
//	req, resp := client.DescribeProductsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts
func (c *SecurityHub) DescribeProductsRequest(input *DescribeProductsInput) (req *request.Request, output *DescribeProductsOutput) {
	op := &request.Operation{
		Name:       opDescribeProducts,
		HTTPMethod: "GET",
		HTTPPath:   "/products",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeProductsInput{}
	}

	output = &DescribeProductsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProducts API operation for AWS SecurityHub.
//
// Returns information about product integrations in Security Hub.
//
// You can optionally provide an integration ARN. If you provide an integration
// ARN, then the results only include that integration.
//
// If you do not provide an integration ARN, then the results include all of
// the available product integrations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeProducts for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts
func (c *SecurityHub) DescribeProducts(input *DescribeProductsInput) (*DescribeProductsOutput, error) {
	req, out := c.DescribeProductsRequest(input)
	return out, req.Send()
}

// DescribeProductsWithContext is the same as DescribeProducts with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProducts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeProductsWithContext(ctx aws.Context, input *DescribeProductsInput, opts ...request.Option) (*DescribeProductsOutput, error) {
	req, out := c.DescribeProductsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeProductsPages iterates over the pages of a DescribeProducts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeProducts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeProducts operation.
//	pageNum := 0
//	err := client.DescribeProductsPages(params,
//	    func(page *securityhub.DescribeProductsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) DescribeProductsPages(input *DescribeProductsInput, fn func(*DescribeProductsOutput, bool) bool) error {
	return c.DescribeProductsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeProductsPagesWithContext same as DescribeProductsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeProductsPagesWithContext(ctx aws.Context, input *DescribeProductsInput, fn func(*DescribeProductsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeProductsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeProductsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeProductsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStandards = "DescribeStandards"

// DescribeStandardsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStandards for more information on using the DescribeStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStandardsRequest method.
//	req, resp := client.DescribeStandardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards
func (c *SecurityHub) DescribeStandardsRequest(input *DescribeStandardsInput) (req *request.Request, output *DescribeStandardsOutput) {
	op := &request.Operation{
		Name:       opDescribeStandards,
		HTTPMethod: "GET",
		HTTPPath:   "/standards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStandardsInput{}
	}

	output = &DescribeStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStandards API operation for AWS SecurityHub.
//
// Returns a list of the available standards in Security Hub.
//
// For each standard, the results include the standard ARN, the name, and a
// description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeStandards for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards
func (c *SecurityHub) DescribeStandards(input *DescribeStandardsInput) (*DescribeStandardsOutput, error) {
	req, out := c.DescribeStandardsRequest(input)
	return out, req.Send()
}

// DescribeStandardsWithContext is the same as DescribeStandards with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsWithContext(ctx aws.Context, input *DescribeStandardsInput, opts ...request.Option) (*DescribeStandardsOutput, error) {
	req, out := c.DescribeStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStandardsPages iterates over the pages of a DescribeStandards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStandards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeStandards operation.
//	pageNum := 0
//	err := client.DescribeStandardsPages(params,
//	    func(page *securityhub.DescribeStandardsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) DescribeStandardsPages(input *DescribeStandardsInput, fn func(*DescribeStandardsOutput, bool) bool) error {
	return c.DescribeStandardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStandardsPagesWithContext same as DescribeStandardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsPagesWithContext(ctx aws.Context, input *DescribeStandardsInput, fn func(*DescribeStandardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStandardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStandardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStandardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStandardsControls = "DescribeStandardsControls"

// DescribeStandardsControlsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStandardsControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStandardsControls for more information on using the DescribeStandardsControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStandardsControlsRequest method.
//	req, resp := client.DescribeStandardsControlsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls
func (c *SecurityHub) DescribeStandardsControlsRequest(input *DescribeStandardsControlsInput) (req *request.Request, output *DescribeStandardsControlsOutput) {
	op := &request.Operation{
		Name:       opDescribeStandardsControls,
		HTTPMethod: "GET",
		HTTPPath:   "/standards/controls/{StandardsSubscriptionArn+}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStandardsControlsInput{}
	}

	output = &DescribeStandardsControlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStandardsControls API operation for AWS SecurityHub.
//
// Returns a list of security standards controls.
//
// For each control, the results include information about whether it is currently
// enabled, the severity, and a link to remediation information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeStandardsControls for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls
func (c *SecurityHub) DescribeStandardsControls(input *DescribeStandardsControlsInput) (*DescribeStandardsControlsOutput, error) {
	req, out := c.DescribeStandardsControlsRequest(input)
	return out, req.Send()
}

// DescribeStandardsControlsWithContext is the same as DescribeStandardsControls with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStandardsControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsControlsWithContext(ctx aws.Context, input *DescribeStandardsControlsInput, opts ...request.Option) (*DescribeStandardsControlsOutput, error) {
	req, out := c.DescribeStandardsControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStandardsControlsPages iterates over the pages of a DescribeStandardsControls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStandardsControls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeStandardsControls operation.
//	pageNum := 0
//	err := client.DescribeStandardsControlsPages(params,
//	    func(page *securityhub.DescribeStandardsControlsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) DescribeStandardsControlsPages(input *DescribeStandardsControlsInput, fn func(*DescribeStandardsControlsOutput, bool) bool) error {
	return c.DescribeStandardsControlsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStandardsControlsPagesWithContext same as DescribeStandardsControlsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsControlsPagesWithContext(ctx aws.Context, input *DescribeStandardsControlsInput, fn func(*DescribeStandardsControlsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStandardsControlsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStandardsControlsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStandardsControlsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDisableImportFindingsForProduct = "DisableImportFindingsForProduct"

// DisableImportFindingsForProductRequest generates a "aws/request.Request" representing the
// client's request for the DisableImportFindingsForProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableImportFindingsForProduct for more information on using the DisableImportFindingsForProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableImportFindingsForProductRequest method.
//	req, resp := client.DisableImportFindingsForProductRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *SecurityHub) DisableImportFindingsForProductRequest(input *DisableImportFindingsForProductInput) (req *request.Request, output *DisableImportFindingsForProductOutput) {
	op := &request.Operation{
		Name:       opDisableImportFindingsForProduct,
		HTTPMethod: "DELETE",
		HTTPPath:   "/productSubscriptions/{ProductSubscriptionArn+}",
	}

	if input == nil {
		input = &DisableImportFindingsForProductInput{}
	}

	output = &DisableImportFindingsForProductOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableImportFindingsForProduct API operation for AWS SecurityHub.
//
// Disables the integration of the specified product with Security Hub. After
// the integration is disabled, findings from that product are no longer sent
// to Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableImportFindingsForProduct for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *SecurityHub) DisableImportFindingsForProduct(input *DisableImportFindingsForProductInput) (*DisableImportFindingsForProductOutput, error) {
	req, out := c.DisableImportFindingsForProductRequest(input)
	return out, req.Send()
}

// DisableImportFindingsForProductWithContext is the same as DisableImportFindingsForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See DisableImportFindingsForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableImportFindingsForProductWithContext(ctx aws.Context, input *DisableImportFindingsForProductInput, opts ...request.Option) (*DisableImportFindingsForProductOutput, error) {
	req, out := c.DisableImportFindingsForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableOrganizationAdminAccount = "DisableOrganizationAdminAccount"

// DisableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableOrganizationAdminAccount for more information on using the DisableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableOrganizationAdminAccountRequest method.
//	req, resp := client.DisableOrganizationAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount
func (c *SecurityHub) DisableOrganizationAdminAccountRequest(input *DisableOrganizationAdminAccountInput) (req *request.Request, output *DisableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opDisableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/admin/disable",
	}

	if input == nil {
		input = &DisableOrganizationAdminAccountInput{}
	}

	output = &DisableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableOrganizationAdminAccount API operation for AWS SecurityHub.
//
// Disables a Security Hub administrator account. Can only be called by the
// organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount
func (c *SecurityHub) DisableOrganizationAdminAccount(input *DisableOrganizationAdminAccountInput) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// DisableOrganizationAdminAccountWithContext is the same as DisableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableOrganizationAdminAccountWithContext(ctx aws.Context, input *DisableOrganizationAdminAccountInput, opts ...request.Option) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableSecurityHub = "DisableSecurityHub"

// DisableSecurityHubRequest generates a "aws/request.Request" representing the
// client's request for the DisableSecurityHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableSecurityHub for more information on using the DisableSecurityHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableSecurityHubRequest method.
//	req, resp := client.DisableSecurityHubRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub
func (c *SecurityHub) DisableSecurityHubRequest(input *DisableSecurityHubInput) (req *request.Request, output *DisableSecurityHubOutput) {
	op := &request.Operation{
		Name:       opDisableSecurityHub,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &DisableSecurityHubInput{}
	}

	output = &DisableSecurityHubOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableSecurityHub API operation for AWS SecurityHub.
//
// Disables Security Hub in your account only in the current Region. To disable
// Security Hub in all Regions, you must submit one request per Region where
// you have enabled Security Hub.
//
// When you disable Security Hub for an administrator account, it doesn't disable
// Security Hub for any associated member accounts.
//
// When you disable Security Hub, your existing findings and insights and any
// Security Hub configuration settings are deleted after 90 days and cannot
// be recovered. Any standards that were enabled are disabled, and your administrator
// and member account associations are removed.
//
// If you want to save your existing findings, you must export them before you
// disable Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableSecurityHub for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub
func (c *SecurityHub) DisableSecurityHub(input *DisableSecurityHubInput) (*DisableSecurityHubOutput, error) {
	req, out := c.DisableSecurityHubRequest(input)
	return out, req.Send()
}

// DisableSecurityHubWithContext is the same as DisableSecurityHub with the addition of
// the ability to pass a context and additional request options.
//
// See DisableSecurityHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableSecurityHubWithContext(ctx aws.Context, input *DisableSecurityHubInput, opts ...request.Option) (*DisableSecurityHubOutput, error) {
	req, out := c.DisableSecurityHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFromAdministratorAccount = "DisassociateFromAdministratorAccount"

// DisassociateFromAdministratorAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFromAdministratorAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFromAdministratorAccount for more information on using the DisassociateFromAdministratorAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateFromAdministratorAccountRequest method.
//	req, resp := client.DisassociateFromAdministratorAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromAdministratorAccount
func (c *SecurityHub) DisassociateFromAdministratorAccountRequest(input *DisassociateFromAdministratorAccountInput) (req *request.Request, output *DisassociateFromAdministratorAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateFromAdministratorAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/administrator/disassociate",
	}

	if input == nil {
		input = &DisassociateFromAdministratorAccountInput{}
	}

	output = &DisassociateFromAdministratorAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateFromAdministratorAccount API operation for AWS SecurityHub.
//
// Disassociates the current Security Hub member account from the associated
// administrator account.
//
// This operation is only used by accounts that are not part of an organization.
// For organization accounts, only the administrator account can disassociate
// a member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateFromAdministratorAccount for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromAdministratorAccount
func (c *SecurityHub) DisassociateFromAdministratorAccount(input *DisassociateFromAdministratorAccountInput) (*DisassociateFromAdministratorAccountOutput, error) {
	req, out := c.DisassociateFromAdministratorAccountRequest(input)
	return out, req.Send()
}

// DisassociateFromAdministratorAccountWithContext is the same as DisassociateFromAdministratorAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFromAdministratorAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisassociateFromAdministratorAccountWithContext(ctx aws.Context, input *DisassociateFromAdministratorAccountInput, opts ...request.Option) (*DisassociateFromAdministratorAccountOutput, error) {
	req, out := c.DisassociateFromAdministratorAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFromMasterAccount = "DisassociateFromMasterAccount"

// DisassociateFromMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFromMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFromMasterAccount for more information on using the DisassociateFromMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateFromMasterAccountRequest method.
//	req, resp := client.DisassociateFromMasterAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount
//
// Deprecated: This API has been deprecated, use DisassociateFromAdministratorAccount API instead.
func (c *SecurityHub) DisassociateFromMasterAccountRequest(input *DisassociateFromMasterAccountInput) (req *request.Request, output *DisassociateFromMasterAccountOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DisassociateFromMasterAccount, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDisassociateFromMasterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/master/disassociate",
	}

	if input == nil {
		input = &DisassociateFromMasterAccountInput{}
	}

	output = &DisassociateFromMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateFromMasterAccount API operation for AWS SecurityHub.
//
// This method is deprecated. Instead, use DisassociateFromAdministratorAccount.
//
// The Security Hub console continues to use DisassociateFromMasterAccount.
// It will eventually change to use DisassociateFromAdministratorAccount. Any
// IAM policies that specifically control access to this function must continue
// to use DisassociateFromMasterAccount. You should also add DisassociateFromAdministratorAccount
// to your policies to ensure that the correct permissions are in place after
// the console begins to use DisassociateFromAdministratorAccount.
//
// Disassociates the current Security Hub member account from the associated
// administrator account.
//
// This operation is only used by accounts that are not part of an organization.
// For organization accounts, only the administrator account can disassociate
// a member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateFromMasterAccount for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount
//
// Deprecated: This API has been deprecated, use DisassociateFromAdministratorAccount API instead.
func (c *SecurityHub) DisassociateFromMasterAccount(input *DisassociateFromMasterAccountInput) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	return out, req.Send()
}

// DisassociateFromMasterAccountWithContext is the same as DisassociateFromMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFromMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This API has been deprecated, use DisassociateFromAdministratorAccount API instead.
func (c *SecurityHub) DisassociateFromMasterAccountWithContext(ctx aws.Context, input *DisassociateFromMasterAccountInput, opts ...request.Option) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMembers = "DisassociateMembers"

// DisassociateMembersRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMembers for more information on using the DisassociateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateMembersRequest method.
//	req, resp := client.DisassociateMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers
func (c *SecurityHub) DisassociateMembersRequest(input *DisassociateMembersInput) (req *request.Request, output *DisassociateMembersOutput) {
	op := &request.Operation{
		Name:       opDisassociateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/disassociate",
	}

	if input == nil {
		input = &DisassociateMembersInput{}
	}

	output = &DisassociateMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateMembers API operation for AWS SecurityHub.
//
// Disassociates the specified member accounts from the associated administrator
// account.
//
// Can be used to disassociate both accounts that are managed using Organizations
// and accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateMembers for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers
func (c *SecurityHub) DisassociateMembers(input *DisassociateMembersInput) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	return out, req.Send()
}

// DisassociateMembersWithContext is the same as DisassociateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisassociateMembersWithContext(ctx aws.Context, input *DisassociateMembersInput, opts ...request.Option) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableImportFindingsForProduct = "EnableImportFindingsForProduct"

// EnableImportFindingsForProductRequest generates a "aws/request.Request" representing the
// client's request for the EnableImportFindingsForProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableImportFindingsForProduct for more information on using the EnableImportFindingsForProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableImportFindingsForProductRequest method.
//	req, resp := client.EnableImportFindingsForProductRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct
func (c *SecurityHub) EnableImportFindingsForProductRequest(input *EnableImportFindingsForProductInput) (req *request.Request, output *EnableImportFindingsForProductOutput) {
	op := &request.Operation{
		Name:       opEnableImportFindingsForProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/productSubscriptions",
	}

	if input == nil {
		input = &EnableImportFindingsForProductInput{}
	}

	output = &EnableImportFindingsForProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableImportFindingsForProduct API operation for AWS SecurityHub.
//
// Enables the integration of a partner product with Security Hub. Integrated
// products send findings to Security Hub.
//
// When you enable a product integration, a permissions policy that grants permission
// for the product to send findings to Security Hub is applied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableImportFindingsForProduct for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceConflictException
//     The resource specified in the request conflicts with an existing resource.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct
func (c *SecurityHub) EnableImportFindingsForProduct(input *EnableImportFindingsForProductInput) (*EnableImportFindingsForProductOutput, error) {
	req, out := c.EnableImportFindingsForProductRequest(input)
	return out, req.Send()
}

// EnableImportFindingsForProductWithContext is the same as EnableImportFindingsForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See EnableImportFindingsForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableImportFindingsForProductWithContext(ctx aws.Context, input *EnableImportFindingsForProductInput, opts ...request.Option) (*EnableImportFindingsForProductOutput, error) {
	req, out := c.EnableImportFindingsForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableOrganizationAdminAccount = "EnableOrganizationAdminAccount"

// EnableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the EnableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableOrganizationAdminAccount for more information on using the EnableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableOrganizationAdminAccountRequest method.
//	req, resp := client.EnableOrganizationAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount
func (c *SecurityHub) EnableOrganizationAdminAccountRequest(input *EnableOrganizationAdminAccountInput) (req *request.Request, output *EnableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opEnableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/admin/enable",
	}

	if input == nil {
		input = &EnableOrganizationAdminAccountInput{}
	}

	output = &EnableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableOrganizationAdminAccount API operation for AWS SecurityHub.
//
// Designates the Security Hub administrator account for an organization. Can
// only be called by the organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount
func (c *SecurityHub) EnableOrganizationAdminAccount(input *EnableOrganizationAdminAccountInput) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// EnableOrganizationAdminAccountWithContext is the same as EnableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See EnableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableOrganizationAdminAccountWithContext(ctx aws.Context, input *EnableOrganizationAdminAccountInput, opts ...request.Option) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableSecurityHub = "EnableSecurityHub"

// EnableSecurityHubRequest generates a "aws/request.Request" representing the
// client's request for the EnableSecurityHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableSecurityHub for more information on using the EnableSecurityHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableSecurityHubRequest method.
//	req, resp := client.EnableSecurityHubRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub
func (c *SecurityHub) EnableSecurityHubRequest(input *EnableSecurityHubInput) (req *request.Request, output *EnableSecurityHubOutput) {
	op := &request.Operation{
		Name:       opEnableSecurityHub,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &EnableSecurityHubInput{}
	}

	output = &EnableSecurityHubOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableSecurityHub API operation for AWS SecurityHub.
//
// Enables Security Hub for your account in the current Region or the Region
// you specify in the request.
//
// When you enable Security Hub, you grant to Security Hub the permissions necessary
// to gather findings from other services that are integrated with Security
// Hub.
//
// When you use the EnableSecurityHub operation to enable Security Hub, you
// also automatically enable the following standards:
//
//   - Center for Internet Security (CIS) Amazon Web Services Foundations Benchmark
//     v1.2.0
//
//   - Amazon Web Services Foundational Security Best Practices
//
// Other standards are not automatically enabled.
//
// To opt out of automatically enabled standards, set EnableDefaultStandards
// to false.
//
// After you enable Security Hub, to enable a standard, use the BatchEnableStandards
// operation. To disable a standard, use the BatchDisableStandards operation.
//
// To learn more, see the setup information (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html)
// in the Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableSecurityHub for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceConflictException
//     The resource specified in the request conflicts with an existing resource.
//
//   - AccessDeniedException
//     You don't have permission to perform the action specified in the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub
func (c *SecurityHub) EnableSecurityHub(input *EnableSecurityHubInput) (*EnableSecurityHubOutput, error) {
	req, out := c.EnableSecurityHubRequest(input)
	return out, req.Send()
}

// EnableSecurityHubWithContext is the same as EnableSecurityHub with the addition of
// the ability to pass a context and additional request options.
//
// See EnableSecurityHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableSecurityHubWithContext(ctx aws.Context, input *EnableSecurityHubInput, opts ...request.Option) (*EnableSecurityHubOutput, error) {
	req, out := c.EnableSecurityHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAdministratorAccount = "GetAdministratorAccount"

// GetAdministratorAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetAdministratorAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAdministratorAccount for more information on using the GetAdministratorAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAdministratorAccountRequest method.
//	req, resp := client.GetAdministratorAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAdministratorAccount
func (c *SecurityHub) GetAdministratorAccountRequest(input *GetAdministratorAccountInput) (req *request.Request, output *GetAdministratorAccountOutput) {
	op := &request.Operation{
		Name:       opGetAdministratorAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/administrator",
	}

	if input == nil {
		input = &GetAdministratorAccountInput{}
	}

	output = &GetAdministratorAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAdministratorAccount API operation for AWS SecurityHub.
//
// Provides the details for the Security Hub administrator account for the current
// member account.
//
// Can be used by both member accounts that are managed using Organizations
// and accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetAdministratorAccount for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAdministratorAccount
func (c *SecurityHub) GetAdministratorAccount(input *GetAdministratorAccountInput) (*GetAdministratorAccountOutput, error) {
	req, out := c.GetAdministratorAccountRequest(input)
	return out, req.Send()
}

// GetAdministratorAccountWithContext is the same as GetAdministratorAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetAdministratorAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetAdministratorAccountWithContext(ctx aws.Context, input *GetAdministratorAccountInput, opts ...request.Option) (*GetAdministratorAccountOutput, error) {
	req, out := c.GetAdministratorAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnabledStandards = "GetEnabledStandards"

// GetEnabledStandardsRequest generates a "aws/request.Request" representing the
// client's request for the GetEnabledStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnabledStandards for more information on using the GetEnabledStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnabledStandardsRequest method.
//	req, resp := client.GetEnabledStandardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards
func (c *SecurityHub) GetEnabledStandardsRequest(input *GetEnabledStandardsInput) (req *request.Request, output *GetEnabledStandardsOutput) {
	op := &request.Operation{
		Name:       opGetEnabledStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEnabledStandardsInput{}
	}

	output = &GetEnabledStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnabledStandards API operation for AWS SecurityHub.
//
// Returns a list of the standards that are currently enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetEnabledStandards for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards
func (c *SecurityHub) GetEnabledStandards(input *GetEnabledStandardsInput) (*GetEnabledStandardsOutput, error) {
	req, out := c.GetEnabledStandardsRequest(input)
	return out, req.Send()
}

// GetEnabledStandardsWithContext is the same as GetEnabledStandards with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnabledStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetEnabledStandardsWithContext(ctx aws.Context, input *GetEnabledStandardsInput, opts ...request.Option) (*GetEnabledStandardsOutput, error) {
	req, out := c.GetEnabledStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEnabledStandardsPages iterates over the pages of a GetEnabledStandards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEnabledStandards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetEnabledStandards operation.
//	pageNum := 0
//	err := client.GetEnabledStandardsPages(params,
//	    func(page *securityhub.GetEnabledStandardsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) GetEnabledStandardsPages(input *GetEnabledStandardsInput, fn func(*GetEnabledStandardsOutput, bool) bool) error {
	return c.GetEnabledStandardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEnabledStandardsPagesWithContext same as GetEnabledStandardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetEnabledStandardsPagesWithContext(ctx aws.Context, input *GetEnabledStandardsInput, fn func(*GetEnabledStandardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEnabledStandardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEnabledStandardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEnabledStandardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetFindingAggregator = "GetFindingAggregator"

// GetFindingAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the GetFindingAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindingAggregator for more information on using the GetFindingAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFindingAggregatorRequest method.
//	req, resp := client.GetFindingAggregatorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingAggregator
func (c *SecurityHub) GetFindingAggregatorRequest(input *GetFindingAggregatorInput) (req *request.Request, output *GetFindingAggregatorOutput) {
	op := &request.Operation{
		Name:       opGetFindingAggregator,
		HTTPMethod: "GET",
		HTTPPath:   "/findingAggregator/get/{FindingAggregatorArn+}",
	}

	if input == nil {
		input = &GetFindingAggregatorInput{}
	}

	output = &GetFindingAggregatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindingAggregator API operation for AWS SecurityHub.
//
// Returns the current finding aggregation configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetFindingAggregator for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - AccessDeniedException
//     You don't have permission to perform the action specified in the request.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingAggregator
func (c *SecurityHub) GetFindingAggregator(input *GetFindingAggregatorInput) (*GetFindingAggregatorOutput, error) {
	req, out := c.GetFindingAggregatorRequest(input)
	return out, req.Send()
}

// GetFindingAggregatorWithContext is the same as GetFindingAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindingAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingAggregatorWithContext(ctx aws.Context, input *GetFindingAggregatorInput, opts ...request.Option) (*GetFindingAggregatorOutput, error) {
	req, out := c.GetFindingAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindingHistory = "GetFindingHistory"

// GetFindingHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetFindingHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindingHistory for more information on using the GetFindingHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFindingHistoryRequest method.
//	req, resp := client.GetFindingHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingHistory
func (c *SecurityHub) GetFindingHistoryRequest(input *GetFindingHistoryInput) (req *request.Request, output *GetFindingHistoryOutput) {
	op := &request.Operation{
		Name:       opGetFindingHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/findingHistory/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFindingHistoryInput{}
	}

	output = &GetFindingHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindingHistory API operation for AWS SecurityHub.
//
// Returns history for a Security Hub finding in the last 90 days. The history
// includes changes made to any fields in the Amazon Web Services Security Finding
// Format (ASFF).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetFindingHistory for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingHistory
func (c *SecurityHub) GetFindingHistory(input *GetFindingHistoryInput) (*GetFindingHistoryOutput, error) {
	req, out := c.GetFindingHistoryRequest(input)
	return out, req.Send()
}

// GetFindingHistoryWithContext is the same as GetFindingHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindingHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingHistoryWithContext(ctx aws.Context, input *GetFindingHistoryInput, opts ...request.Option) (*GetFindingHistoryOutput, error) {
	req, out := c.GetFindingHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFindingHistoryPages iterates over the pages of a GetFindingHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFindingHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetFindingHistory operation.
//	pageNum := 0
//	err := client.GetFindingHistoryPages(params,
//	    func(page *securityhub.GetFindingHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) GetFindingHistoryPages(input *GetFindingHistoryInput, fn func(*GetFindingHistoryOutput, bool) bool) error {
	return c.GetFindingHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFindingHistoryPagesWithContext same as GetFindingHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingHistoryPagesWithContext(ctx aws.Context, input *GetFindingHistoryInput, fn func(*GetFindingHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFindingHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFindingHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetFindingHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetFindings = "GetFindings"

// GetFindingsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindings for more information on using the GetFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFindingsRequest method.
//	req, resp := client.GetFindingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings
func (c *SecurityHub) GetFindingsRequest(input *GetFindingsInput) (req *request.Request, output *GetFindingsOutput) {
	op := &request.Operation{
		Name:       opGetFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFindingsInput{}
	}

	output = &GetFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindings API operation for AWS SecurityHub.
//
// Returns a list of findings that match the specified criteria.
//
// If finding aggregation is enabled, then when you call GetFindings from the
// aggregation Region, the results include all of the matching findings from
// both the aggregation Region and the linked Regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetFindings for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings
func (c *SecurityHub) GetFindings(input *GetFindingsInput) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	return out, req.Send()
}

// GetFindingsWithContext is the same as GetFindings with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingsWithContext(ctx aws.Context, input *GetFindingsInput, opts ...request.Option) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFindingsPages iterates over the pages of a GetFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetFindings operation.
//	pageNum := 0
//	err := client.GetFindingsPages(params,
//	    func(page *securityhub.GetFindingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) GetFindingsPages(input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool) error {
	return c.GetFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFindingsPagesWithContext same as GetFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingsPagesWithContext(ctx aws.Context, input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetInsightResults = "GetInsightResults"

// GetInsightResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsightResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsightResults for more information on using the GetInsightResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInsightResultsRequest method.
//	req, resp := client.GetInsightResultsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *SecurityHub) GetInsightResultsRequest(input *GetInsightResultsInput) (req *request.Request, output *GetInsightResultsOutput) {
	op := &request.Operation{
		Name:       opGetInsightResults,
		HTTPMethod: "GET",
		HTTPPath:   "/insights/results/{InsightArn+}",
	}

	if input == nil {
		input = &GetInsightResultsInput{}
	}

	output = &GetInsightResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsightResults API operation for AWS SecurityHub.
//
// Lists the results of the Security Hub insight specified by the insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInsightResults for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *SecurityHub) GetInsightResults(input *GetInsightResultsInput) (*GetInsightResultsOutput, error) {
	req, out := c.GetInsightResultsRequest(input)
	return out, req.Send()
}

// GetInsightResultsWithContext is the same as GetInsightResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsightResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightResultsWithContext(ctx aws.Context, input *GetInsightResultsInput, opts ...request.Option) (*GetInsightResultsOutput, error) {
	req, out := c.GetInsightResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInsights = "GetInsights"

// GetInsightsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsights for more information on using the GetInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInsightsRequest method.
//	req, resp := client.GetInsightsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights
func (c *SecurityHub) GetInsightsRequest(input *GetInsightsInput) (req *request.Request, output *GetInsightsOutput) {
	op := &request.Operation{
		Name:       opGetInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetInsightsInput{}
	}

	output = &GetInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsights API operation for AWS SecurityHub.
//
// Lists and describes insights for the specified insight ARNs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInsights for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights
func (c *SecurityHub) GetInsights(input *GetInsightsInput) (*GetInsightsOutput, error) {
	req, out := c.GetInsightsRequest(input)
	return out, req.Send()
}

// GetInsightsWithContext is the same as GetInsights with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightsWithContext(ctx aws.Context, input *GetInsightsInput, opts ...request.Option) (*GetInsightsOutput, error) {
	req, out := c.GetInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetInsightsPages iterates over the pages of a GetInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetInsights operation.
//	pageNum := 0
//	err := client.GetInsightsPages(params,
//	    func(page *securityhub.GetInsightsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) GetInsightsPages(input *GetInsightsInput, fn func(*GetInsightsOutput, bool) bool) error {
	return c.GetInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetInsightsPagesWithContext same as GetInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightsPagesWithContext(ctx aws.Context, input *GetInsightsInput, fn func(*GetInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetInvitationsCount = "GetInvitationsCount"

// GetInvitationsCountRequest generates a "aws/request.Request" representing the
// client's request for the GetInvitationsCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvitationsCount for more information on using the GetInvitationsCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInvitationsCountRequest method.
//	req, resp := client.GetInvitationsCountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount
func (c *SecurityHub) GetInvitationsCountRequest(input *GetInvitationsCountInput) (req *request.Request, output *GetInvitationsCountOutput) {
	op := &request.Operation{
		Name:       opGetInvitationsCount,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations/count",
	}

	if input == nil {
		input = &GetInvitationsCountInput{}
	}

	output = &GetInvitationsCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvitationsCount API operation for AWS SecurityHub.
//
// Returns the count of all Security Hub membership invitations that were sent
// to the current member account, not including the currently accepted invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInvitationsCount for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount
func (c *SecurityHub) GetInvitationsCount(input *GetInvitationsCountInput) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	return out, req.Send()
}

// GetInvitationsCountWithContext is the same as GetInvitationsCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvitationsCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInvitationsCountWithContext(ctx aws.Context, input *GetInvitationsCountInput, opts ...request.Option) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMasterAccount = "GetMasterAccount"

// GetMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMasterAccount for more information on using the GetMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMasterAccountRequest method.
//	req, resp := client.GetMasterAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount
//
// Deprecated: This API has been deprecated, use GetAdministratorAccount API instead.
func (c *SecurityHub) GetMasterAccountRequest(input *GetMasterAccountInput) (req *request.Request, output *GetMasterAccountOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetMasterAccount, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetMasterAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &GetMasterAccountInput{}
	}

	output = &GetMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMasterAccount API operation for AWS SecurityHub.
//
// This method is deprecated. Instead, use GetAdministratorAccount.
//
// The Security Hub console continues to use GetMasterAccount. It will eventually
// change to use GetAdministratorAccount. Any IAM policies that specifically
// control access to this function must continue to use GetMasterAccount. You
// should also add GetAdministratorAccount to your policies to ensure that the
// correct permissions are in place after the console begins to use GetAdministratorAccount.
//
// Provides the details for the Security Hub administrator account for the current
// member account.
//
// Can be used by both member accounts that are managed using Organizations
// and accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetMasterAccount for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount
//
// Deprecated: This API has been deprecated, use GetAdministratorAccount API instead.
func (c *SecurityHub) GetMasterAccount(input *GetMasterAccountInput) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	return out, req.Send()
}

// GetMasterAccountWithContext is the same as GetMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This API has been deprecated, use GetAdministratorAccount API instead.
func (c *SecurityHub) GetMasterAccountWithContext(ctx aws.Context, input *GetMasterAccountInput, opts ...request.Option) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMembers = "GetMembers"

// GetMembersRequest generates a "aws/request.Request" representing the
// client's request for the GetMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMembers for more information on using the GetMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMembersRequest method.
//	req, resp := client.GetMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers
func (c *SecurityHub) GetMembersRequest(input *GetMembersInput) (req *request.Request, output *GetMembersOutput) {
	op := &request.Operation{
		Name:       opGetMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/get",
	}

	if input == nil {
		input = &GetMembersInput{}
	}

	output = &GetMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMembers API operation for AWS SecurityHub.
//
// Returns the details for the Security Hub member accounts for the specified
// account IDs.
//
// An administrator account can be either the delegated Security Hub administrator
// account for an organization or an administrator account that enabled Security
// Hub manually.
//
// The results include both member accounts that are managed using Organizations
// and accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetMembers for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers
func (c *SecurityHub) GetMembers(input *GetMembersInput) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	return out, req.Send()
}

// GetMembersWithContext is the same as GetMembers with the addition of
// the ability to pass a context and additional request options.
//
// See GetMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetMembersWithContext(ctx aws.Context, input *GetMembersInput, opts ...request.Option) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteMembers = "InviteMembers"

// InviteMembersRequest generates a "aws/request.Request" representing the
// client's request for the InviteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteMembers for more information on using the InviteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InviteMembersRequest method.
//	req, resp := client.InviteMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *SecurityHub) InviteMembersRequest(input *InviteMembersInput) (req *request.Request, output *InviteMembersOutput) {
	op := &request.Operation{
		Name:       opInviteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/invite",
	}

	if input == nil {
		input = &InviteMembersInput{}
	}

	output = &InviteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteMembers API operation for AWS SecurityHub.
//
// Invites other Amazon Web Services accounts to become member accounts for
// the Security Hub administrator account that the invitation is sent from.
//
// This operation is only used to invite accounts that do not belong to an organization.
// Organization accounts do not receive invitations.
//
// Before you can use this action to invite a member, you must first use the
// CreateMembers action to create the member account in Security Hub.
//
// When the account owner enables Security Hub and accepts the invitation to
// become a member account, the administrator account can view the findings
// generated from the member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation InviteMembers for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *SecurityHub) InviteMembers(input *InviteMembersInput) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	return out, req.Send()
}

// InviteMembersWithContext is the same as InviteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See InviteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) InviteMembersWithContext(ctx aws.Context, input *InviteMembersInput, opts ...request.Option) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAutomationRules = "ListAutomationRules"

// ListAutomationRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListAutomationRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAutomationRules for more information on using the ListAutomationRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAutomationRulesRequest method.
//	req, resp := client.ListAutomationRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListAutomationRules
func (c *SecurityHub) ListAutomationRulesRequest(input *ListAutomationRulesInput) (req *request.Request, output *ListAutomationRulesOutput) {
	op := &request.Operation{
		Name:       opListAutomationRules,
		HTTPMethod: "GET",
		HTTPPath:   "/automationrules/list",
	}

	if input == nil {
		input = &ListAutomationRulesInput{}
	}

	output = &ListAutomationRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAutomationRules API operation for AWS SecurityHub.
//
// A list of automation rules and their metadata for the calling account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListAutomationRules for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action specified in the request.
//
//   - InternalException
//     Internal server error.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListAutomationRules
func (c *SecurityHub) ListAutomationRules(input *ListAutomationRulesInput) (*ListAutomationRulesOutput, error) {
	req, out := c.ListAutomationRulesRequest(input)
	return out, req.Send()
}

// ListAutomationRulesWithContext is the same as ListAutomationRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListAutomationRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListAutomationRulesWithContext(ctx aws.Context, input *ListAutomationRulesInput, opts ...request.Option) (*ListAutomationRulesOutput, error) {
	req, out := c.ListAutomationRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEnabledProductsForImport = "ListEnabledProductsForImport"

// ListEnabledProductsForImportRequest generates a "aws/request.Request" representing the
// client's request for the ListEnabledProductsForImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnabledProductsForImport for more information on using the ListEnabledProductsForImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnabledProductsForImportRequest method.
//	req, resp := client.ListEnabledProductsForImportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *SecurityHub) ListEnabledProductsForImportRequest(input *ListEnabledProductsForImportInput) (req *request.Request, output *ListEnabledProductsForImportOutput) {
	op := &request.Operation{
		Name:       opListEnabledProductsForImport,
		HTTPMethod: "GET",
		HTTPPath:   "/productSubscriptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnabledProductsForImportInput{}
	}

	output = &ListEnabledProductsForImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnabledProductsForImport API operation for AWS SecurityHub.
//
// Lists all findings-generating solutions (products) that you are subscribed
// to receive findings from in Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListEnabledProductsForImport for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *SecurityHub) ListEnabledProductsForImport(input *ListEnabledProductsForImportInput) (*ListEnabledProductsForImportOutput, error) {
	req, out := c.ListEnabledProductsForImportRequest(input)
	return out, req.Send()
}

// ListEnabledProductsForImportWithContext is the same as ListEnabledProductsForImport with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnabledProductsForImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListEnabledProductsForImportWithContext(ctx aws.Context, input *ListEnabledProductsForImportInput, opts ...request.Option) (*ListEnabledProductsForImportOutput, error) {
	req, out := c.ListEnabledProductsForImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnabledProductsForImportPages iterates over the pages of a ListEnabledProductsForImport operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnabledProductsForImport method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnabledProductsForImport operation.
//	pageNum := 0
//	err := client.ListEnabledProductsForImportPages(params,
//	    func(page *securityhub.ListEnabledProductsForImportOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) ListEnabledProductsForImportPages(input *ListEnabledProductsForImportInput, fn func(*ListEnabledProductsForImportOutput, bool) bool) error {
	return c.ListEnabledProductsForImportPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnabledProductsForImportPagesWithContext same as ListEnabledProductsForImportPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListEnabledProductsForImportPagesWithContext(ctx aws.Context, input *ListEnabledProductsForImportInput, fn func(*ListEnabledProductsForImportOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnabledProductsForImportInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnabledProductsForImportRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnabledProductsForImportOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFindingAggregators = "ListFindingAggregators"

// ListFindingAggregatorsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindingAggregators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindingAggregators for more information on using the ListFindingAggregators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFindingAggregatorsRequest method.
//	req, resp := client.ListFindingAggregatorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators
func (c *SecurityHub) ListFindingAggregatorsRequest(input *ListFindingAggregatorsInput) (req *request.Request, output *ListFindingAggregatorsOutput) {
	op := &request.Operation{
		Name:       opListFindingAggregators,
		HTTPMethod: "GET",
		HTTPPath:   "/findingAggregator/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingAggregatorsInput{}
	}

	output = &ListFindingAggregatorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindingAggregators API operation for AWS SecurityHub.
//
// If finding aggregation is enabled, then ListFindingAggregators returns the
// ARN of the finding aggregator. You can run this operation from any Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListFindingAggregators for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - AccessDeniedException
//     You don't have permission to perform the action specified in the request.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators
func (c *SecurityHub) ListFindingAggregators(input *ListFindingAggregatorsInput) (*ListFindingAggregatorsOutput, error) {
	req, out := c.ListFindingAggregatorsRequest(input)
	return out, req.Send()
}

// ListFindingAggregatorsWithContext is the same as ListFindingAggregators with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindingAggregators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListFindingAggregatorsWithContext(ctx aws.Context, input *ListFindingAggregatorsInput, opts ...request.Option) (*ListFindingAggregatorsOutput, error) {
	req, out := c.ListFindingAggregatorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingAggregatorsPages iterates over the pages of a ListFindingAggregators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindingAggregators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFindingAggregators operation.
//	pageNum := 0
//	err := client.ListFindingAggregatorsPages(params,
//	    func(page *securityhub.ListFindingAggregatorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) ListFindingAggregatorsPages(input *ListFindingAggregatorsInput, fn func(*ListFindingAggregatorsOutput, bool) bool) error {
	return c.ListFindingAggregatorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingAggregatorsPagesWithContext same as ListFindingAggregatorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListFindingAggregatorsPagesWithContext(ctx aws.Context, input *ListFindingAggregatorsInput, fn func(*ListFindingAggregatorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingAggregatorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingAggregatorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFindingAggregatorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInvitationsRequest method.
//	req, resp := client.ListInvitationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *SecurityHub) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for AWS SecurityHub.
//
// Lists all Security Hub membership invitations that were sent to the current
// Amazon Web Services account.
//
// This operation is only used by accounts that are managed by invitation. Accounts
// that are managed using the integration with Organizations do not receive
// invitations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListInvitations for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *SecurityHub) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvitationsPages iterates over the pages of a ListInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInvitations operation.
//	pageNum := 0
//	err := client.ListInvitationsPages(params,
//	    func(page *securityhub.ListInvitationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) ListInvitationsPages(input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool) error {
	return c.ListInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvitationsPagesWithContext same as ListInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListInvitationsPagesWithContext(ctx aws.Context, input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMembersRequest method.
//	req, resp := client.ListMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers
func (c *SecurityHub) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for AWS SecurityHub.
//
// Lists details about all member accounts for the current Security Hub administrator
// account.
//
// The results include both member accounts that belong to an organization and
// member accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers
func (c *SecurityHub) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMembers operation.
//	pageNum := 0
//	err := client.ListMembersPages(params,
//	    func(page *securityhub.ListMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationAdminAccounts = "ListOrganizationAdminAccounts"

// ListOrganizationAdminAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationAdminAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationAdminAccounts for more information on using the ListOrganizationAdminAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOrganizationAdminAccountsRequest method.
//	req, resp := client.ListOrganizationAdminAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts
func (c *SecurityHub) ListOrganizationAdminAccountsRequest(input *ListOrganizationAdminAccountsInput) (req *request.Request, output *ListOrganizationAdminAccountsOutput) {
	op := &request.Operation{
		Name:       opListOrganizationAdminAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/organization/admin",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationAdminAccountsInput{}
	}

	output = &ListOrganizationAdminAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationAdminAccounts API operation for AWS SecurityHub.
//
// Lists the Security Hub administrator accounts. Can only be called by the
// organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListOrganizationAdminAccounts for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts
func (c *SecurityHub) ListOrganizationAdminAccounts(input *ListOrganizationAdminAccountsInput) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	return out, req.Send()
}

// ListOrganizationAdminAccountsWithContext is the same as ListOrganizationAdminAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationAdminAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListOrganizationAdminAccountsWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, opts ...request.Option) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationAdminAccountsPages iterates over the pages of a ListOrganizationAdminAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationAdminAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOrganizationAdminAccounts operation.
//	pageNum := 0
//	err := client.ListOrganizationAdminAccountsPages(params,
//	    func(page *securityhub.ListOrganizationAdminAccountsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) ListOrganizationAdminAccountsPages(input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool) error {
	return c.ListOrganizationAdminAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationAdminAccountsPagesWithContext same as ListOrganizationAdminAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListOrganizationAdminAccountsPagesWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationAdminAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationAdminAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationAdminAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecurityControlDefinitions = "ListSecurityControlDefinitions"

// ListSecurityControlDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityControlDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityControlDefinitions for more information on using the ListSecurityControlDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSecurityControlDefinitionsRequest method.
//	req, resp := client.ListSecurityControlDefinitionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListSecurityControlDefinitions
func (c *SecurityHub) ListSecurityControlDefinitionsRequest(input *ListSecurityControlDefinitionsInput) (req *request.Request, output *ListSecurityControlDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListSecurityControlDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/securityControls/definitions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecurityControlDefinitionsInput{}
	}

	output = &ListSecurityControlDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityControlDefinitions API operation for AWS SecurityHub.
//
// Lists all of the security controls that apply to a specified standard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListSecurityControlDefinitions for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListSecurityControlDefinitions
func (c *SecurityHub) ListSecurityControlDefinitions(input *ListSecurityControlDefinitionsInput) (*ListSecurityControlDefinitionsOutput, error) {
	req, out := c.ListSecurityControlDefinitionsRequest(input)
	return out, req.Send()
}

// ListSecurityControlDefinitionsWithContext is the same as ListSecurityControlDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityControlDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListSecurityControlDefinitionsWithContext(ctx aws.Context, input *ListSecurityControlDefinitionsInput, opts ...request.Option) (*ListSecurityControlDefinitionsOutput, error) {
	req, out := c.ListSecurityControlDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecurityControlDefinitionsPages iterates over the pages of a ListSecurityControlDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecurityControlDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSecurityControlDefinitions operation.
//	pageNum := 0
//	err := client.ListSecurityControlDefinitionsPages(params,
//	    func(page *securityhub.ListSecurityControlDefinitionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) ListSecurityControlDefinitionsPages(input *ListSecurityControlDefinitionsInput, fn func(*ListSecurityControlDefinitionsOutput, bool) bool) error {
	return c.ListSecurityControlDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecurityControlDefinitionsPagesWithContext same as ListSecurityControlDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListSecurityControlDefinitionsPagesWithContext(ctx aws.Context, input *ListSecurityControlDefinitionsInput, fn func(*ListSecurityControlDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecurityControlDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecurityControlDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecurityControlDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStandardsControlAssociations = "ListStandardsControlAssociations"

// ListStandardsControlAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListStandardsControlAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStandardsControlAssociations for more information on using the ListStandardsControlAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStandardsControlAssociationsRequest method.
//	req, resp := client.ListStandardsControlAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListStandardsControlAssociations
func (c *SecurityHub) ListStandardsControlAssociationsRequest(input *ListStandardsControlAssociationsInput) (req *request.Request, output *ListStandardsControlAssociationsOutput) {
	op := &request.Operation{
		Name:       opListStandardsControlAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStandardsControlAssociationsInput{}
	}

	output = &ListStandardsControlAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStandardsControlAssociations API operation for AWS SecurityHub.
//
// Specifies whether a control is currently enabled or disabled in each enabled
// standard in the calling account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListStandardsControlAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListStandardsControlAssociations
func (c *SecurityHub) ListStandardsControlAssociations(input *ListStandardsControlAssociationsInput) (*ListStandardsControlAssociationsOutput, error) {
	req, out := c.ListStandardsControlAssociationsRequest(input)
	return out, req.Send()
}

// ListStandardsControlAssociationsWithContext is the same as ListStandardsControlAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListStandardsControlAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListStandardsControlAssociationsWithContext(ctx aws.Context, input *ListStandardsControlAssociationsInput, opts ...request.Option) (*ListStandardsControlAssociationsOutput, error) {
	req, out := c.ListStandardsControlAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStandardsControlAssociationsPages iterates over the pages of a ListStandardsControlAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStandardsControlAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStandardsControlAssociations operation.
//	pageNum := 0
//	err := client.ListStandardsControlAssociationsPages(params,
//	    func(page *securityhub.ListStandardsControlAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityHub) ListStandardsControlAssociationsPages(input *ListStandardsControlAssociationsInput, fn func(*ListStandardsControlAssociationsOutput, bool) bool) error {
	return c.ListStandardsControlAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStandardsControlAssociationsPagesWithContext same as ListStandardsControlAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListStandardsControlAssociationsPagesWithContext(ctx aws.Context, input *ListStandardsControlAssociationsInput, fn func(*ListStandardsControlAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStandardsControlAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStandardsControlAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStandardsControlAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource
func (c *SecurityHub) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS SecurityHub.
//
// Returns a list of tags associated with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource
func (c *SecurityHub) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource
func (c *SecurityHub) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS SecurityHub.
//
// Adds one or more tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource
func (c *SecurityHub) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource
func (c *SecurityHub) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS SecurityHub.
//
// Removes one or more tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource
func (c *SecurityHub) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateActionTarget = "UpdateActionTarget"

// UpdateActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateActionTarget for more information on using the UpdateActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateActionTargetRequest method.
//	req, resp := client.UpdateActionTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget
func (c *SecurityHub) UpdateActionTargetRequest(input *UpdateActionTargetInput) (req *request.Request, output *UpdateActionTargetOutput) {
	op := &request.Operation{
		Name:       opUpdateActionTarget,
		HTTPMethod: "PATCH",
		HTTPPath:   "/actionTargets/{ActionTargetArn+}",
	}

	if input == nil {
		input = &UpdateActionTargetInput{}
	}

	output = &UpdateActionTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateActionTarget API operation for AWS SecurityHub.
//
// Updates the name and description of a custom action target in Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateActionTarget for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget
func (c *SecurityHub) UpdateActionTarget(input *UpdateActionTargetInput) (*UpdateActionTargetOutput, error) {
	req, out := c.UpdateActionTargetRequest(input)
	return out, req.Send()
}

// UpdateActionTargetWithContext is the same as UpdateActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateActionTargetWithContext(ctx aws.Context, input *UpdateActionTargetInput, opts ...request.Option) (*UpdateActionTargetOutput, error) {
	req, out := c.UpdateActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindingAggregator = "UpdateFindingAggregator"

// UpdateFindingAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindingAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindingAggregator for more information on using the UpdateFindingAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFindingAggregatorRequest method.
//	req, resp := client.UpdateFindingAggregatorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindingAggregator
func (c *SecurityHub) UpdateFindingAggregatorRequest(input *UpdateFindingAggregatorInput) (req *request.Request, output *UpdateFindingAggregatorOutput) {
	op := &request.Operation{
		Name:       opUpdateFindingAggregator,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findingAggregator/update",
	}

	if input == nil {
		input = &UpdateFindingAggregatorInput{}
	}

	output = &UpdateFindingAggregatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFindingAggregator API operation for AWS SecurityHub.
//
// Updates the finding aggregation configuration. Used to update the Region
// linking mode and the list of included or excluded Regions. You cannot use
// UpdateFindingAggregator to change the aggregation Region.
//
// You must run UpdateFindingAggregator from the current aggregation Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateFindingAggregator for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - AccessDeniedException
//     You don't have permission to perform the action specified in the request.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindingAggregator
func (c *SecurityHub) UpdateFindingAggregator(input *UpdateFindingAggregatorInput) (*UpdateFindingAggregatorOutput, error) {
	req, out := c.UpdateFindingAggregatorRequest(input)
	return out, req.Send()
}

// UpdateFindingAggregatorWithContext is the same as UpdateFindingAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindingAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateFindingAggregatorWithContext(ctx aws.Context, input *UpdateFindingAggregatorInput, opts ...request.Option) (*UpdateFindingAggregatorOutput, error) {
	req, out := c.UpdateFindingAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindings = "UpdateFindings"

// UpdateFindingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindings for more information on using the UpdateFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFindingsRequest method.
//	req, resp := client.UpdateFindingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *SecurityHub) UpdateFindingsRequest(input *UpdateFindingsInput) (req *request.Request, output *UpdateFindingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFindings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findings",
	}

	if input == nil {
		input = &UpdateFindingsInput{}
	}

	output = &UpdateFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFindings API operation for AWS SecurityHub.
//
// UpdateFindings is deprecated. Instead of UpdateFindings, use BatchUpdateFindings.
//
// Updates the Note and RecordState of the Security Hub-aggregated findings
// that the filter attributes specify. Any member account that can view the
// finding also sees the update to the finding.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateFindings for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *SecurityHub) UpdateFindings(input *UpdateFindingsInput) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	return out, req.Send()
}

// UpdateFindingsWithContext is the same as UpdateFindings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateFindingsWithContext(ctx aws.Context, input *UpdateFindingsInput, opts ...request.Option) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInsight = "UpdateInsight"

// UpdateInsightRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInsight for more information on using the UpdateInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInsightRequest method.
//	req, resp := client.UpdateInsightRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight
func (c *SecurityHub) UpdateInsightRequest(input *UpdateInsightInput) (req *request.Request, output *UpdateInsightOutput) {
	op := &request.Operation{
		Name:       opUpdateInsight,
		HTTPMethod: "PATCH",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &UpdateInsightInput{}
	}

	output = &UpdateInsightOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInsight API operation for AWS SecurityHub.
//
// Updates the Security Hub insight identified by the specified insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateInsight for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight
func (c *SecurityHub) UpdateInsight(input *UpdateInsightInput) (*UpdateInsightOutput, error) {
	req, out := c.UpdateInsightRequest(input)
	return out, req.Send()
}

// UpdateInsightWithContext is the same as UpdateInsight with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateInsightWithContext(ctx aws.Context, input *UpdateInsightInput, opts ...request.Option) (*UpdateInsightOutput, error) {
	req, out := c.UpdateInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOrganizationConfiguration = "UpdateOrganizationConfiguration"

// UpdateOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOrganizationConfiguration for more information on using the UpdateOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateOrganizationConfigurationRequest method.
//	req, resp := client.UpdateOrganizationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration
func (c *SecurityHub) UpdateOrganizationConfigurationRequest(input *UpdateOrganizationConfigurationInput) (req *request.Request, output *UpdateOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateOrganizationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/configuration",
	}

	if input == nil {
		input = &UpdateOrganizationConfigurationInput{}
	}

	output = &UpdateOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateOrganizationConfiguration API operation for AWS SecurityHub.
//
// Used to update the configuration related to Organizations. Can only be called
// from a Security Hub administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration
func (c *SecurityHub) UpdateOrganizationConfiguration(input *UpdateOrganizationConfigurationInput) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateOrganizationConfigurationWithContext is the same as UpdateOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateOrganizationConfigurationWithContext(ctx aws.Context, input *UpdateOrganizationConfigurationInput, opts ...request.Option) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecurityHubConfiguration = "UpdateSecurityHubConfiguration"

// UpdateSecurityHubConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecurityHubConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecurityHubConfiguration for more information on using the UpdateSecurityHubConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSecurityHubConfigurationRequest method.
//	req, resp := client.UpdateSecurityHubConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration
func (c *SecurityHub) UpdateSecurityHubConfigurationRequest(input *UpdateSecurityHubConfigurationInput) (req *request.Request, output *UpdateSecurityHubConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateSecurityHubConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &UpdateSecurityHubConfigurationInput{}
	}

	output = &UpdateSecurityHubConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSecurityHubConfiguration API operation for AWS SecurityHub.
//
// Updates configuration options for Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateSecurityHubConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - LimitExceededException
//     The request was rejected because it attempted to create resources beyond
//     the current Amazon Web Services account or throttling limits. The error code
//     describes the limit exceeded.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration
func (c *SecurityHub) UpdateSecurityHubConfiguration(input *UpdateSecurityHubConfigurationInput) (*UpdateSecurityHubConfigurationOutput, error) {
	req, out := c.UpdateSecurityHubConfigurationRequest(input)
	return out, req.Send()
}

// UpdateSecurityHubConfigurationWithContext is the same as UpdateSecurityHubConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecurityHubConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateSecurityHubConfigurationWithContext(ctx aws.Context, input *UpdateSecurityHubConfigurationInput, opts ...request.Option) (*UpdateSecurityHubConfigurationOutput, error) {
	req, out := c.UpdateSecurityHubConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStandardsControl = "UpdateStandardsControl"

// UpdateStandardsControlRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStandardsControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStandardsControl for more information on using the UpdateStandardsControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStandardsControlRequest method.
//	req, resp := client.UpdateStandardsControlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl
func (c *SecurityHub) UpdateStandardsControlRequest(input *UpdateStandardsControlInput) (req *request.Request, output *UpdateStandardsControlOutput) {
	op := &request.Operation{
		Name:       opUpdateStandardsControl,
		HTTPMethod: "PATCH",
		HTTPPath:   "/standards/control/{StandardsControlArn+}",
	}

	if input == nil {
		input = &UpdateStandardsControlInput{}
	}

	output = &UpdateStandardsControlOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateStandardsControl API operation for AWS SecurityHub.
//
// Used to control whether an individual security standard control is enabled
// or disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateStandardsControl for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Internal server error.
//
//   - InvalidInputException
//     The request was rejected because you supplied an invalid or out-of-range
//     value for an input parameter.
//
//   - InvalidAccessException
//     The account doesn't have permission to perform this action.
//
//   - ResourceNotFoundException
//     The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl
func (c *SecurityHub) UpdateStandardsControl(input *UpdateStandardsControlInput) (*UpdateStandardsControlOutput, error) {
	req, out := c.UpdateStandardsControlRequest(input)
	return out, req.Send()
}

// UpdateStandardsControlWithContext is the same as UpdateStandardsControl with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStandardsControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateStandardsControlWithContext(ctx aws.Context, input *UpdateStandardsControlInput, opts ...request.Option) (*UpdateStandardsControlOutput, error) {
	req, out := c.UpdateStandardsControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptAdministratorInvitationInput struct {
	_ struct{} `type:"structure"`

	// The account ID of the Security Hub administrator account that sent the invitation.
	//
	// AdministratorId is a required field
	AdministratorId *string `type:"string" required:"true"`

	// The identifier of the invitation sent from the Security Hub administrator
	// account.
	//
	// InvitationId is a required field
	InvitationId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAdministratorInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAdministratorInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptAdministratorInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptAdministratorInvitationInput"}
	if s.AdministratorId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdministratorId"))
	}
	if s.InvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdministratorId sets the AdministratorId field's value.
func (s *AcceptAdministratorInvitationInput) SetAdministratorId(v string) *AcceptAdministratorInvitationInput {
	s.AdministratorId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *AcceptAdministratorInvitationInput) SetInvitationId(v string) *AcceptAdministratorInvitationInput {
	s.InvitationId = &v
	return s
}

type AcceptAdministratorInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAdministratorInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAdministratorInvitationOutput) GoString() string {
	return s.String()
}

type AcceptInvitationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the invitation sent from the Security Hub administrator
	// account.
	//
	// InvitationId is a required field
	InvitationId *string `type:"string" required:"true"`

	// The account ID of the Security Hub administrator account that sent the invitation.
	//
	// MasterId is a required field
	MasterId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInvitationInput"}
	if s.InvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationId"))
	}
	if s.MasterId == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvitationId sets the InvitationId field's value.
func (s *AcceptInvitationInput) SetInvitationId(v string) *AcceptInvitationInput {
	s.InvitationId = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *AcceptInvitationInput) SetMasterId(v string) *AcceptInvitationInput {
	s.MasterId = &v
	return s
}

type AcceptInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationOutput) GoString() string {
	return s.String()
}

// You don't have permission to perform the action specified in the request.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of an Amazon Web Services account.
type AccountDetails struct {
	_ struct{} `type:"structure"`

	// The ID of an Amazon Web Services account.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The email of an Amazon Web Services account.
	Email *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountDetails"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AccountDetails) SetAccountId(v string) *AccountDetails {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *AccountDetails) SetEmail(v string) *AccountDetails {
	s.Email = &v
	return s
}

// Provides details about one of the following actions that affects or that
// was taken on a resource:
//
//   - A remote IP address issued an Amazon Web Services API call
//
//   - A DNS request was received
//
//   - A remote IP address attempted to connect to an EC2 instance
//
//   - A remote IP address attempted a port probe on an EC2 instance
type Action struct {
	_ struct{} `type:"structure"`

	// The type of action that was detected. The possible action types are:
	//
	//    * NETWORK_CONNECTION
	//
	//    * AWS_API_CALL
	//
	//    * DNS_REQUEST
	//
	//    * PORT_PROBE
	ActionType *string `type:"string"`

	// Included if ActionType is AWS_API_CALL. Provides details about the API call
	// that was detected.
	AwsApiCallAction *AwsApiCallAction `type:"structure"`

	// Included if ActionType is DNS_REQUEST. Provides details about the DNS request
	// that was detected.
	DnsRequestAction *DnsRequestAction `type:"structure"`

	// Included if ActionType is NETWORK_CONNECTION. Provides details about the
	// network connection that was detected.
	NetworkConnectionAction *NetworkConnectionAction `type:"structure"`

	// Included if ActionType is PORT_PROBE. Provides details about the port probe
	// that was detected.
	PortProbeAction *PortProbeAction `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *Action) SetActionType(v string) *Action {
	s.ActionType = &v
	return s
}

// SetAwsApiCallAction sets the AwsApiCallAction field's value.
func (s *Action) SetAwsApiCallAction(v *AwsApiCallAction) *Action {
	s.AwsApiCallAction = v
	return s
}

// SetDnsRequestAction sets the DnsRequestAction field's value.
func (s *Action) SetDnsRequestAction(v *DnsRequestAction) *Action {
	s.DnsRequestAction = v
	return s
}

// SetNetworkConnectionAction sets the NetworkConnectionAction field's value.
func (s *Action) SetNetworkConnectionAction(v *NetworkConnectionAction) *Action {
	s.NetworkConnectionAction = v
	return s
}

// SetPortProbeAction sets the PortProbeAction field's value.
func (s *Action) SetPortProbeAction(v *PortProbeAction) *Action {
	s.PortProbeAction = v
	return s
}

// Provides information about the IP address where the scanned port is located.
type ActionLocalIpDetails struct {
	_ struct{} `type:"structure"`

	// The IP address.
	IpAddressV4 *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionLocalIpDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionLocalIpDetails) GoString() string {
	return s.String()
}

// SetIpAddressV4 sets the IpAddressV4 field's value.
func (s *ActionLocalIpDetails) SetIpAddressV4(v string) *ActionLocalIpDetails {
	s.IpAddressV4 = &v
	return s
}

// For NetworkConnectionAction and PortProbeDetails, LocalPortDetails provides
// information about the local port that was involved in the action.
type ActionLocalPortDetails struct {
	_ struct{} `type:"structure"`

	// The number of the port.
	Port *int64 `type:"integer"`

	// The port name of the local connection.
	PortName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionLocalPortDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionLocalPortDetails) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *ActionLocalPortDetails) SetPort(v int64) *ActionLocalPortDetails {
	s.Port = &v
	return s
}

// SetPortName sets the PortName field's value.
func (s *ActionLocalPortDetails) SetPortName(v string) *ActionLocalPortDetails {
	s.PortName = &v
	return s
}

// For AwsApiAction, NetworkConnectionAction, and PortProbeAction, RemoteIpDetails
// provides information about the remote IP address that was involved in the
// action.
type ActionRemoteIpDetails struct {
	_ struct{} `type:"structure"`

	// The city where the remote IP address is located.
	City *City `type:"structure"`

	// The country where the remote IP address is located.
	Country *Country `type:"structure"`

	// The coordinates of the location of the remote IP address.
	GeoLocation *GeoLocation `type:"structure"`

	// The IP address.
	IpAddressV4 *string `type:"string"`

	// The internet service provider (ISP) organization associated with the remote
	// IP address.
	Organization *IpOrganizationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionRemoteIpDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionRemoteIpDetails) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *ActionRemoteIpDetails) SetCity(v *City) *ActionRemoteIpDetails {
	s.City = v
	return s
}

// SetCountry sets the Country field's value.
func (s *ActionRemoteIpDetails) SetCountry(v *Country) *ActionRemoteIpDetails {
	s.Country = v
	return s
}

// SetGeoLocation sets the GeoLocation field's value.
func (s *ActionRemoteIpDetails) SetGeoLocation(v *GeoLocation) *ActionRemoteIpDetails {
	s.GeoLocation = v
	return s
}

// SetIpAddressV4 sets the IpAddressV4 field's value.
func (s *ActionRemoteIpDetails) SetIpAddressV4(v string) *ActionRemoteIpDetails {
	s.IpAddressV4 = &v
	return s
}

// SetOrganization sets the Organization field's value.
func (s *ActionRemoteIpDetails) SetOrganization(v *IpOrganizationDetails) *ActionRemoteIpDetails {
	s.Organization = v
	return s
}

// Provides information about the remote port that was involved in an attempted
// network connection.
type ActionRemotePortDetails struct {
	_ struct{} `type:"structure"`

	// The number of the port.
	Port *int64 `type:"integer"`

	// The port name of the remote connection.
	PortName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionRemotePortDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionRemotePortDetails) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *ActionRemotePortDetails) SetPort(v int64) *ActionRemotePortDetails {
	s.Port = &v
	return s
}

// SetPortName sets the PortName field's value.
func (s *ActionRemotePortDetails) SetPortName(v string) *ActionRemotePortDetails {
	s.PortName = &v
	return s
}

// An ActionTarget object.
type ActionTarget struct {
	_ struct{} `type:"structure"`

	// The ARN for the target action.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `type:"string" required:"true"`

	// The description of the target action.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the action target.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTarget) GoString() string {
	return s.String()
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *ActionTarget) SetActionTargetArn(v string) *ActionTarget {
	s.ActionTargetArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ActionTarget) SetDescription(v string) *ActionTarget {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActionTarget) SetName(v string) *ActionTarget {
	s.Name = &v
	return s
}

// An adjustment to the CVSS metric.
type Adjustment struct {
	_ struct{} `type:"structure"`

	// The metric to adjust.
	Metric *string `type:"string"`

	// The reason for the adjustment.
	Reason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Adjustment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Adjustment) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *Adjustment) SetMetric(v string) *Adjustment {
	s.Metric = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *Adjustment) SetReason(v string) *Adjustment {
	s.Reason = &v
	return s
}

// Represents a Security Hub administrator account designated by an organization
// management account.
type AdminAccount struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account identifier of the Security Hub administrator
	// account.
	AccountId *string `type:"string"`

	// The current status of the Security Hub administrator account. Indicates whether
	// the account is currently enabled as a Security Hub administrator.
	Status *string `type:"string" enum:"AdminStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AdminAccount) SetAccountId(v string) *AdminAccount {
	s.AccountId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdminAccount) SetStatus(v string) *AdminAccount {
	s.Status = &v
	return s
}

// Information about an enabled security standard in which a security control
// is enabled.
type AssociatedStandard struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a standard in which a control is enabled. This field
	// consists of the resource portion of the Amazon Resource Name (ARN) returned
	// for a standard in the DescribeStandards (https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html)
	// API response.
	StandardsId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedStandard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedStandard) GoString() string {
	return s.String()
}

// SetStandardsId sets the StandardsId field's value.
func (s *AssociatedStandard) SetStandardsId(v string) *AssociatedStandard {
	s.StandardsId = &v
	return s
}

// The associations between a route table and one or more subnets or a gateway.
type AssociationSetDetails struct {
	_ struct{} `type:"structure"`

	// The state of the association between a route table and a subnet or gateway.
	AssociationState *AssociationStateDetails `type:"structure"`

	// The ID of the internet gateway or virtual private gateway.
	GatewayId *string `type:"string"`

	// Indicates whether this is the main route table.
	Main *bool `type:"boolean"`

	// The ID of the association.
	RouteTableAssociationId *string `type:"string"`

	// The ID of the route table.
	RouteTableId *string `type:"string"`

	// The ID of the subnet. A subnet ID is not returned for an implicit association.
	SubnetId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationSetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationSetDetails) GoString() string {
	return s.String()
}

// SetAssociationState sets the AssociationState field's value.
func (s *AssociationSetDetails) SetAssociationState(v *AssociationStateDetails) *AssociationSetDetails {
	s.AssociationState = v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *AssociationSetDetails) SetGatewayId(v string) *AssociationSetDetails {
	s.GatewayId = &v
	return s
}

// SetMain sets the Main field's value.
func (s *AssociationSetDetails) SetMain(v bool) *AssociationSetDetails {
	s.Main = &v
	return s
}

// SetRouteTableAssociationId sets the RouteTableAssociationId field's value.
func (s *AssociationSetDetails) SetRouteTableAssociationId(v string) *AssociationSetDetails {
	s.RouteTableAssociationId = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *AssociationSetDetails) SetRouteTableId(v string) *AssociationSetDetails {
	s.RouteTableId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AssociationSetDetails) SetSubnetId(v string) *AssociationSetDetails {
	s.SubnetId = &v
	return s
}

// Describes the state of an association between a route table and a subnet
// or gateway.
type AssociationStateDetails struct {
	_ struct{} `type:"structure"`

	// The state of the association.
	State *string `type:"string"`

	// The status message, if applicable.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationStateDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationStateDetails) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *AssociationStateDetails) SetState(v string) *AssociationStateDetails {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *AssociationStateDetails) SetStatusMessage(v string) *AssociationStateDetails {
	s.StatusMessage = &v
	return s
}

// One or more actions to update finding fields if a finding matches the defined
// criteria of the rule.
type AutomationRulesAction struct {
	_ struct{} `type:"structure"`

	// Specifies that the automation rule action is an update to a finding field.
	FindingFieldsUpdate *AutomationRulesFindingFieldsUpdate `type:"structure"`

	// Specifies that the rule action should update the Types finding field. The
	// Types finding field classifies findings in the format of namespace/category/classifier.
	// For more information, see Types taxonomy for ASFF (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html)
	// in the Security Hub User Guide.
	Type *string `type:"string" enum:"AutomationRulesActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationRulesAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationRulesAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutomationRulesAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutomationRulesAction"}
	if s.FindingFieldsUpdate != nil {
		if err := s.FindingFieldsUpdate.Validate(); err != nil {
			invalidParams.AddNested("FindingFieldsUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingFieldsUpdate sets the FindingFieldsUpdate field's value.
func (s *AutomationRulesAction) SetFindingFieldsUpdate(v *AutomationRulesFindingFieldsUpdate) *AutomationRulesAction {
	s.FindingFieldsUpdate = v
	return s
}

// SetType sets the Type field's value.
func (s *AutomationRulesAction) SetType(v string) *AutomationRulesAction {
	s.Type = &v
	return s
}

// Defines the configuration of an automation rule.
type AutomationRulesConfig struct {
	_ struct{} `type:"structure"`

	// One or more actions to update finding fields if a finding matches the defined
	// criteria of the rule.
	Actions []*AutomationRulesAction `min:"1" type:"list"`

	// A timestamp that indicates when the rule was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The principal that created a rule.
	CreatedBy *string `type:"string"`

	// A set of Amazon Web Services Security Finding Format (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html)
	// finding field attributes and corresponding expected values that Security
	// Hub uses to filter findings. If a rule is enabled and a finding matches the
	// conditions specified in this parameter, Security Hub applies the rule action
	// to the finding.
	Criteria *AutomationRulesFindingFilters `type:"structure"`

	// A description of the rule.
	Description *string `type:"string"`

	// Specifies whether a rule is the last to be applied with respect to a finding
	// that matches the rule criteria. This is useful when a finding matches the
	// criteria for multiple rules, and each rule has different actions. If a rule
	// is terminal, Security Hub applies the rule action to a finding that matches
	// the rule criteria and doesn't evaluate other rules for the finding. By default,
	// a rule isn't terminal.
	IsTerminal *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a rule.
	RuleArn *string `type:"string"`

	// The name of the rule.
	RuleName *string `type:"string"`

	// An integer ranging from 1 to 1000 that represents the order in which the
	// rule action is applied to findings. Security Hub applies rules with lower
	// values for this parameter first.
	RuleOrder *int64 `min:"1" type:"integer"`

	// Whether the rule is active after it is created. If this parameter is equal
	// to ENABLED, Security Hub starts applying the rule to findings and finding
	// updates after the rule is created.
	RuleStatus *string `type:"string" enum:"RuleStatus"`

	// A timestamp that indicates when the rule was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationRulesConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationRulesConfig) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *AutomationRulesConfig) SetActions(v []*AutomationRulesAction) *AutomationRulesConfig {
	s.Actions = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AutomationRulesConfig) SetCreatedAt(v time.Time) *AutomationRulesConfig {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *AutomationRulesConfig) SetCreatedBy(v string) *AutomationRulesConfig {
	s.CreatedBy = &v
	return s
}

// SetCriteria sets the Criteria field's value.
func (s *AutomationRulesConfig) SetCriteria(v *AutomationRulesFindingFilters) *AutomationRulesConfig {
	s.Criteria = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AutomationRulesConfig) SetDescription(v string) *AutomationRulesConfig {
	s.Description = &v
	return s
}

// SetIsTerminal sets the IsTerminal field's value.
func (s *AutomationRulesConfig) SetIsTerminal(v bool) *AutomationRulesConfig {
	s.IsTerminal = &v
	return s
}

// SetRuleArn sets the RuleArn field's value.
func (s *AutomationRulesConfig) SetRuleArn(v string) *AutomationRulesConfig {
	s.RuleArn = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *AutomationRulesConfig) SetRuleName(v string) *AutomationRulesConfig {
	s.RuleName = &v
	return s
}

// SetRuleOrder sets the RuleOrder field's value.
func (s *AutomationRulesConfig) SetRuleOrder(v int64) *AutomationRulesConfig {
	s.RuleOrder = &v
	return s
}

// SetRuleStatus sets the RuleStatus field's value.
func (s *AutomationRulesConfig) SetRuleStatus(v string) *AutomationRulesConfig {
	s.RuleStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AutomationRulesConfig) SetUpdatedAt(v time.Time) *AutomationRulesConfig {
	s.UpdatedAt = &v
	return s
}

// Identifies the finding fields that the automation rule action updates when
// a finding matches the defined criteria.
type AutomationRulesFindingFieldsUpdate struct {
	_ struct{} `type:"structure"`

	// The rule action updates the Confidence field of a finding.
	Confidence *int64 `type:"integer"`

	// The rule action updates the Criticality field of a finding.
	Criticality *int64 `type:"integer"`

	// The updated note.
	Note *NoteUpdate `type:"structure"`

	// The rule action updates the RelatedFindings field of a finding.
	RelatedFindings []*RelatedFinding `type:"list"`

	// Updates to the severity information for a finding.
	Severity *SeverityUpdate `type:"structure"`

	// The rule action updates the Types field of a finding.
	Types []*string `type:"list"`

	// The rule action updates the UserDefinedFields field of a finding.
	UserDefinedFields map[string]*string `type:"map"`

	// The rule action updates the VerificationState field of a finding.
	VerificationState *string `type:"string" enum:"VerificationState"`

	// Used to update information about the investigation into the finding.
	Workflow *WorkflowUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationRulesFindingFieldsUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationRulesFindingFieldsUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutomationRulesFindingFieldsUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutomationRulesFindingFieldsUpdate"}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(request.ErrInvalidParams))
		}
	}
	if s.RelatedFindings != nil {
		for i, v := range s.RelatedFindings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedFindings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfidence sets the Confidence field's value.
func (s *AutomationRulesFindingFieldsUpdate) SetConfidence(v int64) *AutomationRulesFindingFieldsUpdate {
	s.Confidence = &v
	return s
}

// SetCriticality sets the Criticality field's value.
func (s *AutomationRulesFindingFieldsUpdate) SetCriticality(v int64) *AutomationRulesFindingFieldsUpdate {
	s.Criticality = &v
	return s
}

// SetNote sets the Note field's value.
func (s *AutomationRulesFindingFieldsUpdate) SetNote(v *NoteUpdate) *AutomationRulesFindingFieldsUpdate {
	s.Note = v
	return s
}

// SetRelatedFindings sets the RelatedFindings field's value.
func (s *AutomationRulesFindingFieldsUpdate) SetRelatedFindings(v []*RelatedFinding) *AutomationRulesFindingFieldsUpdate {
	s.RelatedFindings = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *AutomationRulesFindingFieldsUpdate) SetSeverity(v *SeverityUpdate) *AutomationRulesFindingFieldsUpdate {
	s.Severity = v
	return s
}

// SetTypes sets the Types field's value.
func (s *AutomationRulesFindingFieldsUpdate) SetTypes(v []*string) *AutomationRulesFindingFieldsUpdate {
	s.Types = v
	return s
}

// SetUserDefinedFields sets the UserDefinedFields field's value.
func (s *AutomationRulesFindingFieldsUpdate) SetUserDefinedFields(v map[string]*string) *AutomationRulesFindingFieldsUpdate {
	s.UserDefinedFields = v
	return s
}

// SetVerificationState sets the VerificationState field's value.
func (s *AutomationRulesFindingFieldsUpdate) SetVerificationState(v string) *AutomationRulesFindingFieldsUpdate {
	s.VerificationState = &v
	return s
}

// SetWorkflow sets the Workflow field's value.
func (s *AutomationRulesFindingFieldsUpdate) SetWorkflow(v *WorkflowUpdate) *AutomationRulesFindingFieldsUpdate {
	s.Workflow = v
	return s
}

// The criteria that determine which findings a rule applies to.
type AutomationRulesFindingFilters struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID in which a finding was generated.
	AwsAccountId []*StringFilter `type:"list"`

	// The name of the company for the product that generated the finding. For control-based
	// findings, the company is Amazon Web Services.
	CompanyName []*StringFilter `type:"list"`

	// The unique identifier of a standard in which a control is enabled. This field
	// consists of the resource portion of the Amazon Resource Name (ARN) returned
	// for a standard in the DescribeStandards (https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html)
	// API response.
	ComplianceAssociatedStandardsId []*StringFilter `type:"list"`

	// The security control ID for which a finding was generated. Security control
	// IDs are the same across standards.
	ComplianceSecurityControlId []*StringFilter `type:"list"`

	// The result of a security check. This field is only used for findings generated
	// from controls.
	ComplianceStatus []*StringFilter `type:"list"`

	// The likelihood that a finding accurately identifies the behavior or issue
	// that it was intended to identify. Confidence is scored on a 0–100 basis
	// using a ratio scale. A value of 0 means 0 percent confidence, and a value
	// of 100 means 100 percent confidence. For example, a data exfiltration detection
	// based on a statistical deviation of network traffic has low confidence because
	// an actual exfiltration hasn't been verified. For more information, see Confidence
	// (https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence)
	// in the Security Hub User Guide.
	Confidence []*NumberFilter `type:"list"`

	// A timestamp that indicates when this finding record was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt []*DateFilter `type:"list"`

	// The level of importance that is assigned to the resources that are associated
	// with a finding. Criticality is scored on a 0–100 basis, using a ratio scale
	// that supports only full integers. A score of 0 means that the underlying
	// resources have no criticality, and a score of 100 is reserved for the most
	// critical resources. For more information, see Criticality (https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality)
	// in the Security Hub User Guide.
	Criticality []*NumberFilter `type:"list"`

	// A finding's description.
	Description []*StringFilter `type:"list"`

	// A timestamp that indicates when the potential security issue captured by
	// a finding was first observed by the security findings product.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	FirstObservedAt []*DateFilter `type:"list"`

	// The identifier for the solution-specific component that generated a finding.
	GeneratorId []*StringFilter `type:"list"`

	// The product-specific identifier for a finding.
	Id []*StringFilter `type:"list"`

	// A timestamp that indicates when the potential security issue captured by
	// a finding was most recently observed by the security findings product.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastObservedAt []*DateFilter `type:"list"`

	// The text of a user-defined note that's added to a finding.
	NoteText []*StringFilter `type:"list"`

	// The timestamp of when the note was updated. Uses the date-time format specified
	// in RFC 3339 section 5.6, Internet Date/Time Format (https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
	// The value cannot contain spaces. For example, 2020-03-22T13:22:13.933Z.
	NoteUpdatedAt []*DateFilter `type:"list"`

	// The principal that created a note.
	NoteUpdatedBy []*StringFilter `type:"list"`

	// The Amazon Resource Name (ARN) for a third-party product that generated a
	// finding in Security Hub.
	ProductArn []*StringFilter `type:"list"`

	// Provides the name of the product that generated the finding. For control-based
	// findings, the product name is Security Hub.
	ProductName []*StringFilter `type:"list"`

	// Provides the current state of a finding.
	RecordState []*StringFilter `type:"list"`

	// The product-generated identifier for a related finding.
	RelatedFindingsId []*StringFilter `type:"list"`

	// The ARN for the product that generated a related finding.
	RelatedFindingsProductArn []*StringFilter `type:"list"`

	// Custom fields and values about the resource that a finding pertains to.
	ResourceDetailsOther []*MapFilter `type:"list"`

	// The identifier for the given resource type. For Amazon Web Services resources
	// that are identified by Amazon Resource Names (ARNs), this is the ARN. For
	// Amazon Web Services resources that lack ARNs, this is the identifier as defined
	// by the Amazon Web Service that created the resource. For non-Amazon Web Services
	// resources, this is a unique identifier that is associated with the resource.
	ResourceId []*StringFilter `type:"list"`

	// The partition in which the resource that the finding pertains to is located.
	// A partition is a group of Amazon Web Services Regions. Each Amazon Web Services
	// account is scoped to one partition.
	ResourcePartition []*StringFilter `type:"list"`

	// The Amazon Web Services Region where the resource that a finding pertains
	// to is located.
	ResourceRegion []*StringFilter `type:"list"`

	// A list of Amazon Web Services tags associated with a resource at the time
	// the finding was processed.
	ResourceTags []*MapFilter `type:"list"`

	// The type of resource that the finding pertains to.
	ResourceType []*StringFilter `type:"list"`

	// The severity value of the finding.
	SeverityLabel []*StringFilter `type:"list"`

	// Provides a URL that links to a page about the current finding in the finding
	// product.
	SourceUrl []*StringFilter `type:"list"`

	// A finding's title.
	Title []*StringFilter `type:"list"`

	// One or more finding types in the format of namespace/category/classifier
	// that classify a finding. For a list of namespaces, classifiers, and categories,
	// see Types taxonomy for ASFF (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html)
	// in the Security Hub User Guide.
	Type []*StringFilter `type:"list"`

	// A timestamp that indicates when the finding record was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	UpdatedAt []*DateFilter `type:"list"`

	// A list of user-defined name and value string pairs added to a finding.
	UserDefinedFields []*MapFilter `type:"list"`

	// Provides the veracity of a finding.
	VerificationState []*StringFilter `type:"list"`

	// Provides information about the status of the investigation into a finding.
	WorkflowStatus []*StringFilter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationRulesFindingFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationRulesFindingFilters) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *AutomationRulesFindingFilters) SetAwsAccountId(v []*StringFilter) *AutomationRulesFindingFilters {
	s.AwsAccountId = v
	return s
}

// SetCompanyName sets the CompanyName field's value.
func (s *AutomationRulesFindingFilters) SetCompanyName(v []*StringFilter) *AutomationRulesFindingFilters {
	s.CompanyName = v
	return s
}

// SetComplianceAssociatedStandardsId sets the ComplianceAssociatedStandardsId field's value.
func (s *AutomationRulesFindingFilters) SetComplianceAssociatedStandardsId(v []*StringFilter) *AutomationRulesFindingFilters {
	s.ComplianceAssociatedStandardsId = v
	return s
}

// SetComplianceSecurityControlId sets the ComplianceSecurityControlId field's value.
func (s *AutomationRulesFindingFilters) SetComplianceSecurityControlId(v []*StringFilter) *AutomationRulesFindingFilters {
	s.ComplianceSecurityControlId = v
	return s
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *AutomationRulesFindingFilters) SetComplianceStatus(v []*StringFilter) *AutomationRulesFindingFilters {
	s.ComplianceStatus = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *AutomationRulesFindingFilters) SetConfidence(v []*NumberFilter) *AutomationRulesFindingFilters {
	s.Confidence = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AutomationRulesFindingFilters) SetCreatedAt(v []*DateFilter) *AutomationRulesFindingFilters {
	s.CreatedAt = v
	return s
}

// SetCriticality sets the Criticality field's value.
func (s *AutomationRulesFindingFilters) SetCriticality(v []*NumberFilter) *AutomationRulesFindingFilters {
	s.Criticality = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AutomationRulesFindingFilters) SetDescription(v []*StringFilter) *AutomationRulesFindingFilters {
	s.Description = v
	return s
}

// SetFirstObservedAt sets the FirstObservedAt field's value.
func (s *AutomationRulesFindingFilters) SetFirstObservedAt(v []*DateFilter) *AutomationRulesFindingFilters {
	s.FirstObservedAt = v
	return s
}

// SetGeneratorId sets the GeneratorId field's value.
func (s *AutomationRulesFindingFilters) SetGeneratorId(v []*StringFilter) *AutomationRulesFindingFilters {
	s.GeneratorId = v
	return s
}

// SetId sets the Id field's value.
func (s *AutomationRulesFindingFilters) SetId(v []*StringFilter) *AutomationRulesFindingFilters {
	s.Id = v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *AutomationRulesFindingFilters) SetLastObservedAt(v []*DateFilter) *AutomationRulesFindingFilters {
	s.LastObservedAt = v
	return s
}

// SetNoteText sets the NoteText field's value.
func (s *AutomationRulesFindingFilters) SetNoteText(v []*StringFilter) *AutomationRulesFindingFilters {
	s.NoteText = v
	return s
}

// SetNoteUpdatedAt sets the NoteUpdatedAt field's value.
func (s *AutomationRulesFindingFilters) SetNoteUpdatedAt(v []*DateFilter) *AutomationRulesFindingFilters {
	s.NoteUpdatedAt = v
	return s
}

// SetNoteUpdatedBy sets the NoteUpdatedBy field's value.
func (s *AutomationRulesFindingFilters) SetNoteUpdatedBy(v []*StringFilter) *AutomationRulesFindingFilters {
	s.NoteUpdatedBy = v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *AutomationRulesFindingFilters) SetProductArn(v []*StringFilter) *AutomationRulesFindingFilters {
	s.ProductArn = v
	return s
}

// SetProductName sets the ProductName field's value.
func (s *AutomationRulesFindingFilters) SetProductName(v []*StringFilter) *AutomationRulesFindingFilters {
	s.ProductName = v
	return s
}

// SetRecordState sets the RecordState field's value.
func (s *AutomationRulesFindingFilters) SetRecordState(v []*StringFilter) *AutomationRulesFindingFilters {
	s.RecordState = v
	return s
}

// SetRelatedFindingsId sets the RelatedFindingsId field's value.
func (s *AutomationRulesFindingFilters) SetRelatedFindingsId(v []*StringFilter) *AutomationRulesFindingFilters {
	s.RelatedFindingsId = v
	return s
}

// SetRelatedFindingsProductArn sets the RelatedFindingsProductArn field's value.
func (s *AutomationRulesFindingFilters) SetRelatedFindingsProductArn(v []*StringFilter) *AutomationRulesFindingFilters {
	s.RelatedFindingsProductArn = v
	return s
}

// SetResourceDetailsOther sets the ResourceDetailsOther field's value.
func (s *AutomationRulesFindingFilters) SetResourceDetailsOther(v []*MapFilter) *AutomationRulesFindingFilters {
	s.ResourceDetailsOther = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AutomationRulesFindingFilters) SetResourceId(v []*StringFilter) *AutomationRulesFindingFilters {
	s.ResourceId = v
	return s
}

// SetResourcePartition sets the ResourcePartition field's value.
func (s *AutomationRulesFindingFilters) SetResourcePartition(v []*StringFilter) *AutomationRulesFindingFilters {
	s.ResourcePartition = v
	return s
}

// SetResourceRegion sets the ResourceRegion field's value.
func (s *AutomationRulesFindingFilters) SetResourceRegion(v []*StringFilter) *AutomationRulesFindingFilters {
	s.ResourceRegion = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *AutomationRulesFindingFilters) SetResourceTags(v []*MapFilter) *AutomationRulesFindingFilters {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AutomationRulesFindingFilters) SetResourceType(v []*StringFilter) *AutomationRulesFindingFilters {
	s.ResourceType = v
	return s
}

// SetSeverityLabel sets the SeverityLabel field's value.
func (s *AutomationRulesFindingFilters) SetSeverityLabel(v []*StringFilter) *AutomationRulesFindingFilters {
	s.SeverityLabel = v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *AutomationRulesFindingFilters) SetSourceUrl(v []*StringFilter) *AutomationRulesFindingFilters {
	s.SourceUrl = v
	return s
}

// SetTitle sets the Title field's value.
func (s *AutomationRulesFindingFilters) SetTitle(v []*StringFilter) *AutomationRulesFindingFilters {
	s.Title = v
	return s
}

// SetType sets the Type field's value.
func (s *AutomationRulesFindingFilters) SetType(v []*StringFilter) *AutomationRulesFindingFilters {
	s.Type = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AutomationRulesFindingFilters) SetUpdatedAt(v []*DateFilter) *AutomationRulesFindingFilters {
	s.UpdatedAt = v
	return s
}

// SetUserDefinedFields sets the UserDefinedFields field's value.
func (s *AutomationRulesFindingFilters) SetUserDefinedFields(v []*MapFilter) *AutomationRulesFindingFilters {
	s.UserDefinedFields = v
	return s
}

// SetVerificationState sets the VerificationState field's value.
func (s *AutomationRulesFindingFilters) SetVerificationState(v []*StringFilter) *AutomationRulesFindingFilters {
	s.VerificationState = v
	return s
}

// SetWorkflowStatus sets the WorkflowStatus field's value.
func (s *AutomationRulesFindingFilters) SetWorkflowStatus(v []*StringFilter) *AutomationRulesFindingFilters {
	s.WorkflowStatus = v
	return s
}

// Metadata for automation rules in the calling account. The response includes
// rules with a RuleStatus of ENABLED and DISABLED.
type AutomationRulesMetadata struct {
	_ struct{} `type:"structure"`

	// A timestamp that indicates when the rule was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The principal that created a rule.
	CreatedBy *string `type:"string"`

	// A description of the rule.
	Description *string `type:"string"`

	// Specifies whether a rule is the last to be applied with respect to a finding
	// that matches the rule criteria. This is useful when a finding matches the
	// criteria for multiple rules, and each rule has different actions. If a rule
	// is terminal, Security Hub applies the rule action to a finding that matches
	// the rule criteria and doesn't evaluate other rules for the finding. By default,
	// a rule isn't terminal.
	IsTerminal *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for the rule.
	RuleArn *string `type:"string"`

	// The name of the rule.
	RuleName *string `type:"string"`

	// An integer ranging from 1 to 1000 that represents the order in which the
	// rule action is applied to findings. Security Hub applies rules with lower
	// values for this parameter first.
	RuleOrder *int64 `min:"1" type:"integer"`

	// Whether the rule is active after it is created. If this parameter is equal
	// to ENABLED, Security Hub starts applying the rule to findings and finding
	// updates after the rule is created. To change the value of this parameter
	// after creating a rule, use BatchUpdateAutomationRules (https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html).
	RuleStatus *string `type:"string" enum:"RuleStatus"`

	// A timestamp that indicates when the rule was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationRulesMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationRulesMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AutomationRulesMetadata) SetCreatedAt(v time.Time) *AutomationRulesMetadata {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *AutomationRulesMetadata) SetCreatedBy(v string) *AutomationRulesMetadata {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AutomationRulesMetadata) SetDescription(v string) *AutomationRulesMetadata {
	s.Description = &v
	return s
}

// SetIsTerminal sets the IsTerminal field's value.
func (s *AutomationRulesMetadata) SetIsTerminal(v bool) *AutomationRulesMetadata {
	s.IsTerminal = &v
	return s
}

// SetRuleArn sets the RuleArn field's value.
func (s *AutomationRulesMetadata) SetRuleArn(v string) *AutomationRulesMetadata {
	s.RuleArn = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *AutomationRulesMetadata) SetRuleName(v string) *AutomationRulesMetadata {
	s.RuleName = &v
	return s
}

// SetRuleOrder sets the RuleOrder field's value.
func (s *AutomationRulesMetadata) SetRuleOrder(v int64) *AutomationRulesMetadata {
	s.RuleOrder = &v
	return s
}

// SetRuleStatus sets the RuleStatus field's value.
func (s *AutomationRulesMetadata) SetRuleStatus(v string) *AutomationRulesMetadata {
	s.RuleStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AutomationRulesMetadata) SetUpdatedAt(v time.Time) *AutomationRulesMetadata {
	s.UpdatedAt = &v
	return s
}

// Information about an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The ID of the subnet. You can specify one subnet per Availability Zone.
	SubnetId *string `type:"string"`

	// The name of the Availability Zone.
	ZoneName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetSubnetId sets the SubnetId field's value.
func (s *AvailabilityZone) SetSubnetId(v string) *AvailabilityZone {
	s.SubnetId = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *AvailabilityZone) SetZoneName(v string) *AvailabilityZone {
	s.ZoneName = &v
	return s
}

// Provides details about an Amazon MQ message broker. A message broker allows
// software applications and components to communicate using various programming
// languages, operating systems, and formal messaging protocols.
type AwsAmazonMqBrokerDetails struct {
	_ struct{} `type:"structure"`

	// The authentication strategy used to secure the broker. The default is SIMPLE.
	AuthenticationStrategy *string `type:"string"`

	// Whether automatically upgrade new minor versions for brokers, as new versions
	// are released and supported by Amazon MQ. Automatic upgrades occur during
	// the scheduled maintenance window of the broker or after a manual broker reboot.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the broker.
	BrokerArn *string `type:"string"`

	// The unique ID that Amazon MQ generates for the broker.
	BrokerId *string `type:"string"`

	// The broker's name.
	BrokerName *string `type:"string"`

	// The broker's deployment mode.
	DeploymentMode *string `type:"string"`

	// Encryption options for the broker. Doesn’t apply to RabbitMQ brokers.
	EncryptionOptions *AwsAmazonMqBrokerEncryptionOptionsDetails `type:"structure"`

	// The type of broker engine.
	EngineType *string `type:"string"`

	// The version of the broker engine.
	EngineVersion *string `type:"string"`

	// The broker's instance type.
	HostInstanceType *string `type:"string"`

	// The metadata of the Lightweight Directory Access Protocol (LDAP) server used
	// to authenticate and authorize connections to the broker. This is an optional
	// failover server.
	LdapServerMetadata *AwsAmazonMqBrokerLdapServerMetadataDetails `type:"structure"`

	// Turns on Amazon CloudWatch logging for brokers.
	Logs *AwsAmazonMqBrokerLogsDetails `type:"structure"`

	// The scheduled time period (UTC) during which Amazon MQ begins to apply pending
	// updates or patches to the broker.
	MaintenanceWindowStartTime *AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails `type:"structure"`

	// Permits connections from applications outside of the VPC that hosts the broker's
	// subnets.
	PubliclyAccessible *bool `type:"boolean"`

	// The list of rules (one minimum, 125 maximum) that authorize connections to
	// brokers.
	SecurityGroups []*string `type:"list"`

	// The broker's storage type.
	StorageType *string `type:"string"`

	// The list of groups that define which subnets and IP ranges the broker can
	// use from different Availability Zones.
	SubnetIds []*string `type:"list"`

	// The list of all broker usernames for the specified broker. Doesn't apply
	// to RabbitMQ brokers.
	Users []*AwsAmazonMqBrokerUsersDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerDetails) GoString() string {
	return s.String()
}

// SetAuthenticationStrategy sets the AuthenticationStrategy field's value.
func (s *AwsAmazonMqBrokerDetails) SetAuthenticationStrategy(v string) *AwsAmazonMqBrokerDetails {
	s.AuthenticationStrategy = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *AwsAmazonMqBrokerDetails) SetAutoMinorVersionUpgrade(v bool) *AwsAmazonMqBrokerDetails {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetBrokerArn sets the BrokerArn field's value.
func (s *AwsAmazonMqBrokerDetails) SetBrokerArn(v string) *AwsAmazonMqBrokerDetails {
	s.BrokerArn = &v
	return s
}

// SetBrokerId sets the BrokerId field's value.
func (s *AwsAmazonMqBrokerDetails) SetBrokerId(v string) *AwsAmazonMqBrokerDetails {
	s.BrokerId = &v
	return s
}

// SetBrokerName sets the BrokerName field's value.
func (s *AwsAmazonMqBrokerDetails) SetBrokerName(v string) *AwsAmazonMqBrokerDetails {
	s.BrokerName = &v
	return s
}

// SetDeploymentMode sets the DeploymentMode field's value.
func (s *AwsAmazonMqBrokerDetails) SetDeploymentMode(v string) *AwsAmazonMqBrokerDetails {
	s.DeploymentMode = &v
	return s
}

// SetEncryptionOptions sets the EncryptionOptions field's value.
func (s *AwsAmazonMqBrokerDetails) SetEncryptionOptions(v *AwsAmazonMqBrokerEncryptionOptionsDetails) *AwsAmazonMqBrokerDetails {
	s.EncryptionOptions = v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *AwsAmazonMqBrokerDetails) SetEngineType(v string) *AwsAmazonMqBrokerDetails {
	s.EngineType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsAmazonMqBrokerDetails) SetEngineVersion(v string) *AwsAmazonMqBrokerDetails {
	s.EngineVersion = &v
	return s
}

// SetHostInstanceType sets the HostInstanceType field's value.
func (s *AwsAmazonMqBrokerDetails) SetHostInstanceType(v string) *AwsAmazonMqBrokerDetails {
	s.HostInstanceType = &v
	return s
}

// SetLdapServerMetadata sets the LdapServerMetadata field's value.
func (s *AwsAmazonMqBrokerDetails) SetLdapServerMetadata(v *AwsAmazonMqBrokerLdapServerMetadataDetails) *AwsAmazonMqBrokerDetails {
	s.LdapServerMetadata = v
	return s
}

// SetLogs sets the Logs field's value.
func (s *AwsAmazonMqBrokerDetails) SetLogs(v *AwsAmazonMqBrokerLogsDetails) *AwsAmazonMqBrokerDetails {
	s.Logs = v
	return s
}

// SetMaintenanceWindowStartTime sets the MaintenanceWindowStartTime field's value.
func (s *AwsAmazonMqBrokerDetails) SetMaintenanceWindowStartTime(v *AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails) *AwsAmazonMqBrokerDetails {
	s.MaintenanceWindowStartTime = v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *AwsAmazonMqBrokerDetails) SetPubliclyAccessible(v bool) *AwsAmazonMqBrokerDetails {
	s.PubliclyAccessible = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsAmazonMqBrokerDetails) SetSecurityGroups(v []*string) *AwsAmazonMqBrokerDetails {
	s.SecurityGroups = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *AwsAmazonMqBrokerDetails) SetStorageType(v string) *AwsAmazonMqBrokerDetails {
	s.StorageType = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AwsAmazonMqBrokerDetails) SetSubnetIds(v []*string) *AwsAmazonMqBrokerDetails {
	s.SubnetIds = v
	return s
}

// SetUsers sets the Users field's value.
func (s *AwsAmazonMqBrokerDetails) SetUsers(v []*AwsAmazonMqBrokerUsersDetails) *AwsAmazonMqBrokerDetails {
	s.Users = v
	return s
}

// Provides details about broker encryption options.
type AwsAmazonMqBrokerEncryptionOptionsDetails struct {
	_ struct{} `type:"structure"`

	// The KMS key that’s used to encrypt your data at rest. If not provided,
	// Amazon MQ will use a default KMS key to encrypt your data.
	KmsKeyId *string `type:"string"`

	// Specifies that an KMS key should be used for at-rest encryption. Set to true
	// by default if no value is provided (for example, for RabbitMQ brokers).
	UseAwsOwnedKey *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerEncryptionOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerEncryptionOptionsDetails) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsAmazonMqBrokerEncryptionOptionsDetails) SetKmsKeyId(v string) *AwsAmazonMqBrokerEncryptionOptionsDetails {
	s.KmsKeyId = &v
	return s
}

// SetUseAwsOwnedKey sets the UseAwsOwnedKey field's value.
func (s *AwsAmazonMqBrokerEncryptionOptionsDetails) SetUseAwsOwnedKey(v bool) *AwsAmazonMqBrokerEncryptionOptionsDetails {
	s.UseAwsOwnedKey = &v
	return s
}

// The metadata of the Lightweight Directory Access Protocol (LDAP) server used
// to authenticate and authorize connections to the broker. This is an optional
// failover server.
type AwsAmazonMqBrokerLdapServerMetadataDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the location of the LDAP server, such as Amazon Web Services Directory
	// Service for Microsoft Active Directory.
	Hosts []*string `type:"list"`

	// The distinguished name of the node in the directory information tree (DIT)
	// to search for roles or groups.
	RoleBase *string `type:"string"`

	// The group name attribute in a role entry whose value is the name of that
	// role.
	RoleName *string `type:"string"`

	// The LDAP search filter used to find roles within the roleBase.
	RoleSearchMatching *string `type:"string"`

	// The directory search scope for the role. If set to true, the scope is to
	// search the entire subtree.
	RoleSearchSubtree *bool `type:"boolean"`

	// A username for the service account, which is an account in your LDAP server
	// that has access to initiate a connection.
	ServiceAccountUsername *string `type:"string"`

	// Selects a particular subtree of the directory information tree (DIT) to search
	// for user entries.
	UserBase *string `type:"string"`

	// The name of the LDAP attribute in the user's directory entry for the user's
	// group membership.
	UserRoleName *string `type:"string"`

	// The LDAP search filter used to find users within the userBase.
	UserSearchMatching *string `type:"string"`

	// The directory search scope for the user. If set to true, the scope is to
	// search the entire subtree.
	UserSearchSubtree *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerLdapServerMetadataDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerLdapServerMetadataDetails) GoString() string {
	return s.String()
}

// SetHosts sets the Hosts field's value.
func (s *AwsAmazonMqBrokerLdapServerMetadataDetails) SetHosts(v []*string) *AwsAmazonMqBrokerLdapServerMetadataDetails {
	s.Hosts = v
	return s
}

// SetRoleBase sets the RoleBase field's value.
func (s *AwsAmazonMqBrokerLdapServerMetadataDetails) SetRoleBase(v string) *AwsAmazonMqBrokerLdapServerMetadataDetails {
	s.RoleBase = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *AwsAmazonMqBrokerLdapServerMetadataDetails) SetRoleName(v string) *AwsAmazonMqBrokerLdapServerMetadataDetails {
	s.RoleName = &v
	return s
}

// SetRoleSearchMatching sets the RoleSearchMatching field's value.
func (s *AwsAmazonMqBrokerLdapServerMetadataDetails) SetRoleSearchMatching(v string) *AwsAmazonMqBrokerLdapServerMetadataDetails {
	s.RoleSearchMatching = &v
	return s
}

// SetRoleSearchSubtree sets the RoleSearchSubtree field's value.
func (s *AwsAmazonMqBrokerLdapServerMetadataDetails) SetRoleSearchSubtree(v bool) *AwsAmazonMqBrokerLdapServerMetadataDetails {
	s.RoleSearchSubtree = &v
	return s
}

// SetServiceAccountUsername sets the ServiceAccountUsername field's value.
func (s *AwsAmazonMqBrokerLdapServerMetadataDetails) SetServiceAccountUsername(v string) *AwsAmazonMqBrokerLdapServerMetadataDetails {
	s.ServiceAccountUsername = &v
	return s
}

// SetUserBase sets the UserBase field's value.
func (s *AwsAmazonMqBrokerLdapServerMetadataDetails) SetUserBase(v string) *AwsAmazonMqBrokerLdapServerMetadataDetails {
	s.UserBase = &v
	return s
}

// SetUserRoleName sets the UserRoleName field's value.
func (s *AwsAmazonMqBrokerLdapServerMetadataDetails) SetUserRoleName(v string) *AwsAmazonMqBrokerLdapServerMetadataDetails {
	s.UserRoleName = &v
	return s
}

// SetUserSearchMatching sets the UserSearchMatching field's value.
func (s *AwsAmazonMqBrokerLdapServerMetadataDetails) SetUserSearchMatching(v string) *AwsAmazonMqBrokerLdapServerMetadataDetails {
	s.UserSearchMatching = &v
	return s
}

// SetUserSearchSubtree sets the UserSearchSubtree field's value.
func (s *AwsAmazonMqBrokerLdapServerMetadataDetails) SetUserSearchSubtree(v bool) *AwsAmazonMqBrokerLdapServerMetadataDetails {
	s.UserSearchSubtree = &v
	return s
}

// Provides information about logs to be activated for the specified broker.
type AwsAmazonMqBrokerLogsDetails struct {
	_ struct{} `type:"structure"`

	// Activates audit logging. Every user management action made using JMX or the
	// ActiveMQ Web Console is logged. Doesn't apply to RabbitMQ brokers.
	Audit *bool `type:"boolean"`

	// The location of the CloudWatch Logs log group where audit logs are sent.
	AuditLogGroup *string `type:"string"`

	// Activates general logging.
	General *bool `type:"boolean"`

	// The location of the CloudWatch Logs log group where general logs are sent.
	GeneralLogGroup *string `type:"string"`

	// The list of information about logs that are to be turned on for the specified
	// broker.
	Pending *AwsAmazonMqBrokerLogsPendingDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerLogsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerLogsDetails) GoString() string {
	return s.String()
}

// SetAudit sets the Audit field's value.
func (s *AwsAmazonMqBrokerLogsDetails) SetAudit(v bool) *AwsAmazonMqBrokerLogsDetails {
	s.Audit = &v
	return s
}

// SetAuditLogGroup sets the AuditLogGroup field's value.
func (s *AwsAmazonMqBrokerLogsDetails) SetAuditLogGroup(v string) *AwsAmazonMqBrokerLogsDetails {
	s.AuditLogGroup = &v
	return s
}

// SetGeneral sets the General field's value.
func (s *AwsAmazonMqBrokerLogsDetails) SetGeneral(v bool) *AwsAmazonMqBrokerLogsDetails {
	s.General = &v
	return s
}

// SetGeneralLogGroup sets the GeneralLogGroup field's value.
func (s *AwsAmazonMqBrokerLogsDetails) SetGeneralLogGroup(v string) *AwsAmazonMqBrokerLogsDetails {
	s.GeneralLogGroup = &v
	return s
}

// SetPending sets the Pending field's value.
func (s *AwsAmazonMqBrokerLogsDetails) SetPending(v *AwsAmazonMqBrokerLogsPendingDetails) *AwsAmazonMqBrokerLogsDetails {
	s.Pending = v
	return s
}

// Provides information about logs to be activated for the specified broker.
type AwsAmazonMqBrokerLogsPendingDetails struct {
	_ struct{} `type:"structure"`

	// Activates audit logging. Every user management action made using JMX or the
	// ActiveMQ Web Console is logged. Doesn't apply to RabbitMQ brokers.
	Audit *bool `type:"boolean"`

	// Activates general logging.
	General *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerLogsPendingDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerLogsPendingDetails) GoString() string {
	return s.String()
}

// SetAudit sets the Audit field's value.
func (s *AwsAmazonMqBrokerLogsPendingDetails) SetAudit(v bool) *AwsAmazonMqBrokerLogsPendingDetails {
	s.Audit = &v
	return s
}

// SetGeneral sets the General field's value.
func (s *AwsAmazonMqBrokerLogsPendingDetails) SetGeneral(v bool) *AwsAmazonMqBrokerLogsPendingDetails {
	s.General = &v
	return s
}

// The scheduled time period (UTC) during which Amazon MQ begins to apply pending
// updates or patches to the broker.
type AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails struct {
	_ struct{} `type:"structure"`

	// The day of the week on which the maintenance window falls.
	DayOfWeek *string `type:"string"`

	// The time, in 24-hour format, on which the maintenance window falls.
	TimeOfDay *string `type:"string"`

	// The time zone in either the Country/City format or the UTC offset format.
	// UTC is the default format.
	TimeZone *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails) GoString() string {
	return s.String()
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails) SetDayOfWeek(v string) *AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails {
	s.DayOfWeek = &v
	return s
}

// SetTimeOfDay sets the TimeOfDay field's value.
func (s *AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails) SetTimeOfDay(v string) *AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails {
	s.TimeOfDay = &v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails) SetTimeZone(v string) *AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails {
	s.TimeZone = &v
	return s
}

// Provides details about the broker usernames for the specified broker. Doesn't
// apply to RabbitMQ brokers.
type AwsAmazonMqBrokerUsersDetails struct {
	_ struct{} `type:"structure"`

	// The type of change pending for the broker user.
	PendingChange *string `type:"string"`

	// The username of the broker user.
	Username *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerUsersDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAmazonMqBrokerUsersDetails) GoString() string {
	return s.String()
}

// SetPendingChange sets the PendingChange field's value.
func (s *AwsAmazonMqBrokerUsersDetails) SetPendingChange(v string) *AwsAmazonMqBrokerUsersDetails {
	s.PendingChange = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AwsAmazonMqBrokerUsersDetails) SetUsername(v string) *AwsAmazonMqBrokerUsersDetails {
	s.Username = &v
	return s
}

// Provided if ActionType is AWS_API_CALL. It provides details about the API
// call that was detected.
type AwsApiCallAction struct {
	_ struct{} `type:"structure"`

	// Identifies the resources that were affected by the API call.
	AffectedResources map[string]*string `type:"map"`

	// The name of the API method that was issued.
	Api *string `type:"string"`

	// Indicates whether the API call originated from a remote IP address (remoteip)
	// or from a DNS domain (domain).
	CallerType *string `type:"string"`

	// Provided if CallerType is domain. Provides information about the DNS domain
	// that the API call originated from.
	DomainDetails *AwsApiCallActionDomainDetails `type:"structure"`

	// An ISO8601-formatted timestamp that indicates when the API call was first
	// observed.
	//
	// A correctly formatted example is 2020-05-21T20:16:34.724Z. The value cannot
	// contain spaces, and date and time should be separated by T. For more information,
	// see RFC 3339 section 5.6, Internet Date/Time Format (https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
	FirstSeen *string `type:"string"`

	// An ISO8601-formatted timestamp that indicates when the API call was most
	// recently observed.
	//
	// A correctly formatted example is 2020-05-21T20:16:34.724Z. The value cannot
	// contain spaces, and date and time should be separated by T. For more information,
	// see RFC 3339 section 5.6, Internet Date/Time Format (https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
	LastSeen *string `type:"string"`

	// Provided if CallerType is remoteIp. Provides information about the remote
	// IP address that the API call originated from.
	RemoteIpDetails *ActionRemoteIpDetails `type:"structure"`

	// The name of the Amazon Web Services service that the API method belongs to.
	ServiceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiCallAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiCallAction) GoString() string {
	return s.String()
}

// SetAffectedResources sets the AffectedResources field's value.
func (s *AwsApiCallAction) SetAffectedResources(v map[string]*string) *AwsApiCallAction {
	s.AffectedResources = v
	return s
}

// SetApi sets the Api field's value.
func (s *AwsApiCallAction) SetApi(v string) *AwsApiCallAction {
	s.Api = &v
	return s
}

// SetCallerType sets the CallerType field's value.
func (s *AwsApiCallAction) SetCallerType(v string) *AwsApiCallAction {
	s.CallerType = &v
	return s
}

// SetDomainDetails sets the DomainDetails field's value.
func (s *AwsApiCallAction) SetDomainDetails(v *AwsApiCallActionDomainDetails) *AwsApiCallAction {
	s.DomainDetails = v
	return s
}

// SetFirstSeen sets the FirstSeen field's value.
func (s *AwsApiCallAction) SetFirstSeen(v string) *AwsApiCallAction {
	s.FirstSeen = &v
	return s
}

// SetLastSeen sets the LastSeen field's value.
func (s *AwsApiCallAction) SetLastSeen(v string) *AwsApiCallAction {
	s.LastSeen = &v
	return s
}

// SetRemoteIpDetails sets the RemoteIpDetails field's value.
func (s *AwsApiCallAction) SetRemoteIpDetails(v *ActionRemoteIpDetails) *AwsApiCallAction {
	s.RemoteIpDetails = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AwsApiCallAction) SetServiceName(v string) *AwsApiCallAction {
	s.ServiceName = &v
	return s
}

// Provided if CallerType is domain. It provides information about the DNS domain
// that issued the API call.
type AwsApiCallActionDomainDetails struct {
	_ struct{} `type:"structure"`

	// The name of the DNS domain that issued the API call.
	Domain *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiCallActionDomainDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiCallActionDomainDetails) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *AwsApiCallActionDomainDetails) SetDomain(v string) *AwsApiCallActionDomainDetails {
	s.Domain = &v
	return s
}

// Contains information about settings for logging access for the stage.
type AwsApiGatewayAccessLogSettings struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch Logs log group that receives the access logs.
	DestinationArn *string `type:"string"`

	// A single-line format of the access logs of data, as specified by selected
	// $context variables. The format must include at least $context.requestId.
	Format *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayAccessLogSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayAccessLogSettings) GoString() string {
	return s.String()
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *AwsApiGatewayAccessLogSettings) SetDestinationArn(v string) *AwsApiGatewayAccessLogSettings {
	s.DestinationArn = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *AwsApiGatewayAccessLogSettings) SetFormat(v string) *AwsApiGatewayAccessLogSettings {
	s.Format = &v
	return s
}

// Contains information about settings for canary deployment in the stage.
type AwsApiGatewayCanarySettings struct {
	_ struct{} `type:"structure"`

	// The deployment identifier for the canary deployment.
	DeploymentId *string `type:"string"`

	// The percentage of traffic that is diverted to a canary deployment.
	PercentTraffic *float64 `type:"double"`

	// Stage variables that are overridden in the canary release deployment. The
	// variables include new stage variables that are introduced in the canary.
	//
	// Each variable is represented as a string-to-string map between the stage
	// variable name and the variable value.
	StageVariableOverrides map[string]*string `type:"map"`

	// Indicates whether the canary deployment uses the stage cache.
	UseStageCache *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayCanarySettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayCanarySettings) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *AwsApiGatewayCanarySettings) SetDeploymentId(v string) *AwsApiGatewayCanarySettings {
	s.DeploymentId = &v
	return s
}

// SetPercentTraffic sets the PercentTraffic field's value.
func (s *AwsApiGatewayCanarySettings) SetPercentTraffic(v float64) *AwsApiGatewayCanarySettings {
	s.PercentTraffic = &v
	return s
}

// SetStageVariableOverrides sets the StageVariableOverrides field's value.
func (s *AwsApiGatewayCanarySettings) SetStageVariableOverrides(v map[string]*string) *AwsApiGatewayCanarySettings {
	s.StageVariableOverrides = v
	return s
}

// SetUseStageCache sets the UseStageCache field's value.
func (s *AwsApiGatewayCanarySettings) SetUseStageCache(v bool) *AwsApiGatewayCanarySettings {
	s.UseStageCache = &v
	return s
}

// Contains information about the endpoints for the API.
type AwsApiGatewayEndpointConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of endpoint types for the REST API.
	//
	// For an edge-optimized API, the endpoint type is EDGE. For a Regional API,
	// the endpoint type is REGIONAL. For a private API, the endpoint type is PRIVATE.
	Types []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayEndpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayEndpointConfiguration) GoString() string {
	return s.String()
}

// SetTypes sets the Types field's value.
func (s *AwsApiGatewayEndpointConfiguration) SetTypes(v []*string) *AwsApiGatewayEndpointConfiguration {
	s.Types = v
	return s
}

// Defines settings for a method for the stage.
type AwsApiGatewayMethodSettings struct {
	_ struct{} `type:"structure"`

	// Indicates whether the cached responses are encrypted.
	CacheDataEncrypted *bool `type:"boolean"`

	// Specifies the time to live (TTL), in seconds, for cached responses. The higher
	// the TTL, the longer the response is cached.
	CacheTtlInSeconds *int64 `type:"integer"`

	// Indicates whether responses are cached and returned for requests. For responses
	// to be cached, a cache cluster must be enabled on the stage.
	CachingEnabled *bool `type:"boolean"`

	// Indicates whether data trace logging is enabled for the method. Data trace
	// logging affects the log entries that are pushed to CloudWatch Logs.
	DataTraceEnabled *bool `type:"boolean"`

	// The HTTP method. You can use an asterisk (*) as a wildcard to apply method
	// settings to multiple methods.
	HttpMethod *string `type:"string"`

	// The logging level for this method. The logging level affects the log entries
	// that are pushed to CloudWatch Logs.
	//
	// If the logging level is ERROR, then the logs only include error-level entries.
	//
	// If the logging level is INFO, then the logs include both ERROR events and
	// extra informational events.
	//
	// Valid values: OFF | ERROR | INFO
	LoggingLevel *string `type:"string"`

	// Indicates whether CloudWatch metrics are enabled for the method.
	MetricsEnabled *bool `type:"boolean"`

	// Indicates whether authorization is required for a cache invalidation request.
	RequireAuthorizationForCacheControl *bool `type:"boolean"`

	// The resource path for this method. Forward slashes (/) are encoded as ~1
	// . The initial slash must include a forward slash.
	//
	// For example, the path value /resource/subresource must be encoded as /~1resource~1subresource.
	//
	// To specify the root path, use only a slash (/). You can use an asterisk (*)
	// as a wildcard to apply method settings to multiple methods.
	ResourcePath *string `type:"string"`

	// The throttling burst limit for the method.
	ThrottlingBurstLimit *int64 `type:"integer"`

	// The throttling rate limit for the method.
	ThrottlingRateLimit *float64 `type:"double"`

	// Indicates how to handle unauthorized requests for cache invalidation.
	//
	// Valid values: FAIL_WITH_403 | SUCCEED_WITH_RESPONSE_HEADER | SUCCEED_WITHOUT_RESPONSE_HEADER
	UnauthorizedCacheControlHeaderStrategy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayMethodSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayMethodSettings) GoString() string {
	return s.String()
}

// SetCacheDataEncrypted sets the CacheDataEncrypted field's value.
func (s *AwsApiGatewayMethodSettings) SetCacheDataEncrypted(v bool) *AwsApiGatewayMethodSettings {
	s.CacheDataEncrypted = &v
	return s
}

// SetCacheTtlInSeconds sets the CacheTtlInSeconds field's value.
func (s *AwsApiGatewayMethodSettings) SetCacheTtlInSeconds(v int64) *AwsApiGatewayMethodSettings {
	s.CacheTtlInSeconds = &v
	return s
}

// SetCachingEnabled sets the CachingEnabled field's value.
func (s *AwsApiGatewayMethodSettings) SetCachingEnabled(v bool) *AwsApiGatewayMethodSettings {
	s.CachingEnabled = &v
	return s
}

// SetDataTraceEnabled sets the DataTraceEnabled field's value.
func (s *AwsApiGatewayMethodSettings) SetDataTraceEnabled(v bool) *AwsApiGatewayMethodSettings {
	s.DataTraceEnabled = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *AwsApiGatewayMethodSettings) SetHttpMethod(v string) *AwsApiGatewayMethodSettings {
	s.HttpMethod = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *AwsApiGatewayMethodSettings) SetLoggingLevel(v string) *AwsApiGatewayMethodSettings {
	s.LoggingLevel = &v
	return s
}

// SetMetricsEnabled sets the MetricsEnabled field's value.
func (s *AwsApiGatewayMethodSettings) SetMetricsEnabled(v bool) *AwsApiGatewayMethodSettings {
	s.MetricsEnabled = &v
	return s
}

// SetRequireAuthorizationForCacheControl sets the RequireAuthorizationForCacheControl field's value.
func (s *AwsApiGatewayMethodSettings) SetRequireAuthorizationForCacheControl(v bool) *AwsApiGatewayMethodSettings {
	s.RequireAuthorizationForCacheControl = &v
	return s
}

// SetResourcePath sets the ResourcePath field's value.
func (s *AwsApiGatewayMethodSettings) SetResourcePath(v string) *AwsApiGatewayMethodSettings {
	s.ResourcePath = &v
	return s
}

// SetThrottlingBurstLimit sets the ThrottlingBurstLimit field's value.
func (s *AwsApiGatewayMethodSettings) SetThrottlingBurstLimit(v int64) *AwsApiGatewayMethodSettings {
	s.ThrottlingBurstLimit = &v
	return s
}

// SetThrottlingRateLimit sets the ThrottlingRateLimit field's value.
func (s *AwsApiGatewayMethodSettings) SetThrottlingRateLimit(v float64) *AwsApiGatewayMethodSettings {
	s.ThrottlingRateLimit = &v
	return s
}

// SetUnauthorizedCacheControlHeaderStrategy sets the UnauthorizedCacheControlHeaderStrategy field's value.
func (s *AwsApiGatewayMethodSettings) SetUnauthorizedCacheControlHeaderStrategy(v string) *AwsApiGatewayMethodSettings {
	s.UnauthorizedCacheControlHeaderStrategy = &v
	return s
}

// Contains information about a REST API in version 1 of Amazon API Gateway.
type AwsApiGatewayRestApiDetails struct {
	_ struct{} `type:"structure"`

	// The source of the API key for metering requests according to a usage plan.
	//
	// HEADER indicates whether to read the API key from the X-API-Key header of
	// a request.
	//
	// AUTHORIZER indicates whether to read the API key from the UsageIdentifierKey
	// from a custom authorizer.
	ApiKeySource *string `type:"string"`

	// The list of binary media types supported by the REST API.
	BinaryMediaTypes []*string `type:"list"`

	// Indicates when the API was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// A description of the REST API.
	Description *string `type:"string"`

	// The endpoint configuration of the REST API.
	EndpointConfiguration *AwsApiGatewayEndpointConfiguration `type:"structure"`

	// The identifier of the REST API.
	Id *string `type:"string"`

	// The minimum size in bytes of a payload before compression is enabled.
	//
	// If null, then compression is disabled.
	//
	// If 0, then all payloads are compressed.
	MinimumCompressionSize *int64 `type:"integer"`

	// The name of the REST API.
	Name *string `type:"string"`

	// The version identifier for the REST API.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayRestApiDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayRestApiDetails) GoString() string {
	return s.String()
}

// SetApiKeySource sets the ApiKeySource field's value.
func (s *AwsApiGatewayRestApiDetails) SetApiKeySource(v string) *AwsApiGatewayRestApiDetails {
	s.ApiKeySource = &v
	return s
}

// SetBinaryMediaTypes sets the BinaryMediaTypes field's value.
func (s *AwsApiGatewayRestApiDetails) SetBinaryMediaTypes(v []*string) *AwsApiGatewayRestApiDetails {
	s.BinaryMediaTypes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayRestApiDetails) SetCreatedDate(v string) *AwsApiGatewayRestApiDetails {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayRestApiDetails) SetDescription(v string) *AwsApiGatewayRestApiDetails {
	s.Description = &v
	return s
}

// SetEndpointConfiguration sets the EndpointConfiguration field's value.
func (s *AwsApiGatewayRestApiDetails) SetEndpointConfiguration(v *AwsApiGatewayEndpointConfiguration) *AwsApiGatewayRestApiDetails {
	s.EndpointConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *AwsApiGatewayRestApiDetails) SetId(v string) *AwsApiGatewayRestApiDetails {
	s.Id = &v
	return s
}

// SetMinimumCompressionSize sets the MinimumCompressionSize field's value.
func (s *AwsApiGatewayRestApiDetails) SetMinimumCompressionSize(v int64) *AwsApiGatewayRestApiDetails {
	s.MinimumCompressionSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsApiGatewayRestApiDetails) SetName(v string) *AwsApiGatewayRestApiDetails {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsApiGatewayRestApiDetails) SetVersion(v string) *AwsApiGatewayRestApiDetails {
	s.Version = &v
	return s
}

// Provides information about a version 1 Amazon API Gateway stage.
type AwsApiGatewayStageDetails struct {
	_ struct{} `type:"structure"`

	// Settings for logging access for the stage.
	AccessLogSettings *AwsApiGatewayAccessLogSettings `type:"structure"`

	// Indicates whether a cache cluster is enabled for the stage.
	CacheClusterEnabled *bool `type:"boolean"`

	// If a cache cluster is enabled, the size of the cache cluster.
	CacheClusterSize *string `type:"string"`

	// If a cache cluster is enabled, the status of the cache cluster.
	CacheClusterStatus *string `type:"string"`

	// Information about settings for canary deployment in the stage.
	CanarySettings *AwsApiGatewayCanarySettings `type:"structure"`

	// The identifier of the client certificate for the stage.
	ClientCertificateId *string `type:"string"`

	// Indicates when the stage was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// The identifier of the deployment that the stage points to.
	DeploymentId *string `type:"string"`

	// A description of the stage.
	Description *string `type:"string"`

	// The version of the API documentation that is associated with the stage.
	DocumentationVersion *string `type:"string"`

	// Indicates when the stage was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	LastUpdatedDate *string `type:"string"`

	// Defines the method settings for the stage.
	MethodSettings []*AwsApiGatewayMethodSettings `type:"list"`

	// The name of the stage.
	StageName *string `type:"string"`

	// Indicates whether active tracing with X-Ray is enabled for the stage.
	TracingEnabled *bool `type:"boolean"`

	// A map that defines the stage variables for the stage.
	//
	// Variable names can have alphanumeric and underscore characters.
	//
	// Variable values can contain the following characters:
	//
	//    * Uppercase and lowercase letters
	//
	//    * Numbers
	//
	//    * Special characters -._~:/?#&=,
	Variables map[string]*string `type:"map"`

	// The ARN of the web ACL associated with the stage.
	WebAclArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayStageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayStageDetails) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *AwsApiGatewayStageDetails) SetAccessLogSettings(v *AwsApiGatewayAccessLogSettings) *AwsApiGatewayStageDetails {
	s.AccessLogSettings = v
	return s
}

// SetCacheClusterEnabled sets the CacheClusterEnabled field's value.
func (s *AwsApiGatewayStageDetails) SetCacheClusterEnabled(v bool) *AwsApiGatewayStageDetails {
	s.CacheClusterEnabled = &v
	return s
}

// SetCacheClusterSize sets the CacheClusterSize field's value.
func (s *AwsApiGatewayStageDetails) SetCacheClusterSize(v string) *AwsApiGatewayStageDetails {
	s.CacheClusterSize = &v
	return s
}

// SetCacheClusterStatus sets the CacheClusterStatus field's value.
func (s *AwsApiGatewayStageDetails) SetCacheClusterStatus(v string) *AwsApiGatewayStageDetails {
	s.CacheClusterStatus = &v
	return s
}

// SetCanarySettings sets the CanarySettings field's value.
func (s *AwsApiGatewayStageDetails) SetCanarySettings(v *AwsApiGatewayCanarySettings) *AwsApiGatewayStageDetails {
	s.CanarySettings = v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *AwsApiGatewayStageDetails) SetClientCertificateId(v string) *AwsApiGatewayStageDetails {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayStageDetails) SetCreatedDate(v string) *AwsApiGatewayStageDetails {
	s.CreatedDate = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *AwsApiGatewayStageDetails) SetDeploymentId(v string) *AwsApiGatewayStageDetails {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayStageDetails) SetDescription(v string) *AwsApiGatewayStageDetails {
	s.Description = &v
	return s
}

// SetDocumentationVersion sets the DocumentationVersion field's value.
func (s *AwsApiGatewayStageDetails) SetDocumentationVersion(v string) *AwsApiGatewayStageDetails {
	s.DocumentationVersion = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *AwsApiGatewayStageDetails) SetLastUpdatedDate(v string) *AwsApiGatewayStageDetails {
	s.LastUpdatedDate = &v
	return s
}

// SetMethodSettings sets the MethodSettings field's value.
func (s *AwsApiGatewayStageDetails) SetMethodSettings(v []*AwsApiGatewayMethodSettings) *AwsApiGatewayStageDetails {
	s.MethodSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *AwsApiGatewayStageDetails) SetStageName(v string) *AwsApiGatewayStageDetails {
	s.StageName = &v
	return s
}

// SetTracingEnabled sets the TracingEnabled field's value.
func (s *AwsApiGatewayStageDetails) SetTracingEnabled(v bool) *AwsApiGatewayStageDetails {
	s.TracingEnabled = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *AwsApiGatewayStageDetails) SetVariables(v map[string]*string) *AwsApiGatewayStageDetails {
	s.Variables = v
	return s
}

// SetWebAclArn sets the WebAclArn field's value.
func (s *AwsApiGatewayStageDetails) SetWebAclArn(v string) *AwsApiGatewayStageDetails {
	s.WebAclArn = &v
	return s
}

// Contains information about a version 2 API in Amazon API Gateway.
type AwsApiGatewayV2ApiDetails struct {
	_ struct{} `type:"structure"`

	// The URI of the API.
	//
	// Uses the format <api-id>.execute-api.<region>.amazonaws.com
	//
	// The stage name is typically appended to the URI to form a complete path to
	// a deployed API stage.
	ApiEndpoint *string `type:"string"`

	// The identifier of the API.
	ApiId *string `type:"string"`

	// An API key selection expression. Supported only for WebSocket APIs.
	ApiKeySelectionExpression *string `type:"string"`

	// A cross-origin resource sharing (CORS) configuration. Supported only for
	// HTTP APIs.
	CorsConfiguration *AwsCorsConfiguration `type:"structure"`

	// Indicates when the API was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// A description of the API.
	Description *string `type:"string"`

	// The name of the API.
	Name *string `type:"string"`

	// The API protocol for the API.
	//
	// Valid values: WEBSOCKET | HTTP
	ProtocolType *string `type:"string"`

	// The route selection expression for the API.
	//
	// For HTTP APIs, must be ${request.method} ${request.path}. This is the default
	// value for HTTP APIs.
	//
	// For WebSocket APIs, there is no default value.
	RouteSelectionExpression *string `type:"string"`

	// The version identifier for the API.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2ApiDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2ApiDetails) GoString() string {
	return s.String()
}

// SetApiEndpoint sets the ApiEndpoint field's value.
func (s *AwsApiGatewayV2ApiDetails) SetApiEndpoint(v string) *AwsApiGatewayV2ApiDetails {
	s.ApiEndpoint = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *AwsApiGatewayV2ApiDetails) SetApiId(v string) *AwsApiGatewayV2ApiDetails {
	s.ApiId = &v
	return s
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *AwsApiGatewayV2ApiDetails) SetApiKeySelectionExpression(v string) *AwsApiGatewayV2ApiDetails {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *AwsApiGatewayV2ApiDetails) SetCorsConfiguration(v *AwsCorsConfiguration) *AwsApiGatewayV2ApiDetails {
	s.CorsConfiguration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayV2ApiDetails) SetCreatedDate(v string) *AwsApiGatewayV2ApiDetails {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayV2ApiDetails) SetDescription(v string) *AwsApiGatewayV2ApiDetails {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsApiGatewayV2ApiDetails) SetName(v string) *AwsApiGatewayV2ApiDetails {
	s.Name = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *AwsApiGatewayV2ApiDetails) SetProtocolType(v string) *AwsApiGatewayV2ApiDetails {
	s.ProtocolType = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *AwsApiGatewayV2ApiDetails) SetRouteSelectionExpression(v string) *AwsApiGatewayV2ApiDetails {
	s.RouteSelectionExpression = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsApiGatewayV2ApiDetails) SetVersion(v string) *AwsApiGatewayV2ApiDetails {
	s.Version = &v
	return s
}

// Contains route settings for a stage.
type AwsApiGatewayV2RouteSettings struct {
	_ struct{} `type:"structure"`

	// Indicates whether data trace logging is enabled. Data trace logging affects
	// the log entries that are pushed to CloudWatch Logs. Supported only for WebSocket
	// APIs.
	DataTraceEnabled *bool `type:"boolean"`

	// Indicates whether detailed metrics are enabled.
	DetailedMetricsEnabled *bool `type:"boolean"`

	// The logging level. The logging level affects the log entries that are pushed
	// to CloudWatch Logs. Supported only for WebSocket APIs.
	//
	// If the logging level is ERROR, then the logs only include error-level entries.
	//
	// If the logging level is INFO, then the logs include both ERROR events and
	// extra informational events.
	//
	// Valid values: OFF | ERROR | INFO
	LoggingLevel *string `type:"string"`

	// The throttling burst limit.
	ThrottlingBurstLimit *int64 `type:"integer"`

	// The throttling rate limit.
	ThrottlingRateLimit *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2RouteSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2RouteSettings) GoString() string {
	return s.String()
}

// SetDataTraceEnabled sets the DataTraceEnabled field's value.
func (s *AwsApiGatewayV2RouteSettings) SetDataTraceEnabled(v bool) *AwsApiGatewayV2RouteSettings {
	s.DataTraceEnabled = &v
	return s
}

// SetDetailedMetricsEnabled sets the DetailedMetricsEnabled field's value.
func (s *AwsApiGatewayV2RouteSettings) SetDetailedMetricsEnabled(v bool) *AwsApiGatewayV2RouteSettings {
	s.DetailedMetricsEnabled = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *AwsApiGatewayV2RouteSettings) SetLoggingLevel(v string) *AwsApiGatewayV2RouteSettings {
	s.LoggingLevel = &v
	return s
}

// SetThrottlingBurstLimit sets the ThrottlingBurstLimit field's value.
func (s *AwsApiGatewayV2RouteSettings) SetThrottlingBurstLimit(v int64) *AwsApiGatewayV2RouteSettings {
	s.ThrottlingBurstLimit = &v
	return s
}

// SetThrottlingRateLimit sets the ThrottlingRateLimit field's value.
func (s *AwsApiGatewayV2RouteSettings) SetThrottlingRateLimit(v float64) *AwsApiGatewayV2RouteSettings {
	s.ThrottlingRateLimit = &v
	return s
}

// Contains information about a version 2 stage for Amazon API Gateway.
type AwsApiGatewayV2StageDetails struct {
	_ struct{} `type:"structure"`

	// Information about settings for logging access for the stage.
	AccessLogSettings *AwsApiGatewayAccessLogSettings `type:"structure"`

	// Indicates whether the stage is managed by API Gateway.
	ApiGatewayManaged *bool `type:"boolean"`

	// Indicates whether updates to an API automatically trigger a new deployment.
	AutoDeploy *bool `type:"boolean"`

	// The identifier of a client certificate for a stage. Supported only for WebSocket
	// API calls.
	ClientCertificateId *string `type:"string"`

	// Indicates when the stage was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// Default route settings for the stage.
	DefaultRouteSettings *AwsApiGatewayV2RouteSettings `type:"structure"`

	// The identifier of the deployment that the stage is associated with.
	DeploymentId *string `type:"string"`

	// The description of the stage.
	Description *string `type:"string"`

	// The status of the last deployment of a stage. Supported only if the stage
	// has automatic deployment enabled.
	LastDeploymentStatusMessage *string `type:"string"`

	// Indicates when the stage was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	LastUpdatedDate *string `type:"string"`

	// The route settings for the stage.
	RouteSettings *AwsApiGatewayV2RouteSettings `type:"structure"`

	// The name of the stage.
	StageName *string `type:"string"`

	// A map that defines the stage variables for the stage.
	//
	// Variable names can have alphanumeric and underscore characters.
	//
	// Variable values can contain the following characters:
	//
	//    * Uppercase and lowercase letters
	//
	//    * Numbers
	//
	//    * Special characters -._~:/?#&=,
	StageVariables map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2StageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2StageDetails) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *AwsApiGatewayV2StageDetails) SetAccessLogSettings(v *AwsApiGatewayAccessLogSettings) *AwsApiGatewayV2StageDetails {
	s.AccessLogSettings = v
	return s
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *AwsApiGatewayV2StageDetails) SetApiGatewayManaged(v bool) *AwsApiGatewayV2StageDetails {
	s.ApiGatewayManaged = &v
	return s
}

// SetAutoDeploy sets the AutoDeploy field's value.
func (s *AwsApiGatewayV2StageDetails) SetAutoDeploy(v bool) *AwsApiGatewayV2StageDetails {
	s.AutoDeploy = &v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *AwsApiGatewayV2StageDetails) SetClientCertificateId(v string) *AwsApiGatewayV2StageDetails {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayV2StageDetails) SetCreatedDate(v string) *AwsApiGatewayV2StageDetails {
	s.CreatedDate = &v
	return s
}

// SetDefaultRouteSettings sets the DefaultRouteSettings field's value.
func (s *AwsApiGatewayV2StageDetails) SetDefaultRouteSettings(v *AwsApiGatewayV2RouteSettings) *AwsApiGatewayV2StageDetails {
	s.DefaultRouteSettings = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *AwsApiGatewayV2StageDetails) SetDeploymentId(v string) *AwsApiGatewayV2StageDetails {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayV2StageDetails) SetDescription(v string) *AwsApiGatewayV2StageDetails {
	s.Description = &v
	return s
}

// SetLastDeploymentStatusMessage sets the LastDeploymentStatusMessage field's value.
func (s *AwsApiGatewayV2StageDetails) SetLastDeploymentStatusMessage(v string) *AwsApiGatewayV2StageDetails {
	s.LastDeploymentStatusMessage = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *AwsApiGatewayV2StageDetails) SetLastUpdatedDate(v string) *AwsApiGatewayV2StageDetails {
	s.LastUpdatedDate = &v
	return s
}

// SetRouteSettings sets the RouteSettings field's value.
func (s *AwsApiGatewayV2StageDetails) SetRouteSettings(v *AwsApiGatewayV2RouteSettings) *AwsApiGatewayV2StageDetails {
	s.RouteSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *AwsApiGatewayV2StageDetails) SetStageName(v string) *AwsApiGatewayV2StageDetails {
	s.StageName = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *AwsApiGatewayV2StageDetails) SetStageVariables(v map[string]*string) *AwsApiGatewayV2StageDetails {
	s.StageVariables = v
	return s
}

// A list of additional authentication providers for the GraphqlApi API.
type AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails struct {
	_ struct{} `type:"structure"`

	// The type of security configuration for your GraphQL API: API key, Identity
	// and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools,
	// or Lambda.
	AuthenticationType *string `type:"string"`

	// The configuration for Lambda function authorization.
	LambdaAuthorizerConfig *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails `type:"structure"`

	// The OpenID Connect configuration.
	OpenIdConnectConfig *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails `type:"structure"`

	// The Amazon Cognito user pools configuration.
	UserPoolConfig *AwsAppSyncGraphQlApiUserPoolConfigDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails) GoString() string {
	return s.String()
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails) SetAuthenticationType(v string) *AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails {
	s.AuthenticationType = &v
	return s
}

// SetLambdaAuthorizerConfig sets the LambdaAuthorizerConfig field's value.
func (s *AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails) SetLambdaAuthorizerConfig(v *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails) *AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails {
	s.LambdaAuthorizerConfig = v
	return s
}

// SetOpenIdConnectConfig sets the OpenIdConnectConfig field's value.
func (s *AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails) SetOpenIdConnectConfig(v *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) *AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails {
	s.OpenIdConnectConfig = v
	return s
}

// SetUserPoolConfig sets the UserPoolConfig field's value.
func (s *AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails) SetUserPoolConfig(v *AwsAppSyncGraphQlApiUserPoolConfigDetails) *AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails {
	s.UserPoolConfig = v
	return s
}

// Provides details about an AppSync Graph QL API, which lets you query multiple
// databases, microservices, and APIs from a single GraphQL endpoint.
type AwsAppSyncGraphQlApiDetails struct {
	_ struct{} `type:"structure"`

	// A list of additional authentication providers for the GraphQL API.
	AdditionalAuthenticationProviders []*AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails `type:"list"`

	// The unique identifier for the API.
	ApiId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the API.
	Arn *string `type:"string"`

	// The type of security configuration for your GraphQL API: API key, Identity
	// and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools,
	// or Lambda.
	AuthenticationType *string `type:"string"`

	// The unique identifier for the API.
	Id *string `type:"string"`

	// Specifies the configuration for Lambda function authorization.
	LambdaAuthorizerConfig *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails `type:"structure"`

	// The Amazon CloudWatch Logs configuration.
	LogConfig *AwsAppSyncGraphQlApiLogConfigDetails `type:"structure"`

	// The API name.
	Name *string `type:"string"`

	// Specifies the authorization configuration for using an OpenID Connect compliant
	// service with an AppSync GraphQL API endpoint.
	OpenIdConnectConfig *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails `type:"structure"`

	// The Amazon Cognito user pools configuration.
	UserPoolConfig *AwsAppSyncGraphQlApiUserPoolConfigDetails `type:"structure"`

	// The Amazon Resource Name (ARN) of the WAF web access control list (web ACL)
	// associated with this GraphQL API, if one exists.
	WafWebAclArn *string `type:"string"`

	// Indicates whether to use X-Ray tracing for the GraphQL API.
	XrayEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiDetails) GoString() string {
	return s.String()
}

// SetAdditionalAuthenticationProviders sets the AdditionalAuthenticationProviders field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetAdditionalAuthenticationProviders(v []*AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails) *AwsAppSyncGraphQlApiDetails {
	s.AdditionalAuthenticationProviders = v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetApiId(v string) *AwsAppSyncGraphQlApiDetails {
	s.ApiId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetArn(v string) *AwsAppSyncGraphQlApiDetails {
	s.Arn = &v
	return s
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetAuthenticationType(v string) *AwsAppSyncGraphQlApiDetails {
	s.AuthenticationType = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetId(v string) *AwsAppSyncGraphQlApiDetails {
	s.Id = &v
	return s
}

// SetLambdaAuthorizerConfig sets the LambdaAuthorizerConfig field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetLambdaAuthorizerConfig(v *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails) *AwsAppSyncGraphQlApiDetails {
	s.LambdaAuthorizerConfig = v
	return s
}

// SetLogConfig sets the LogConfig field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetLogConfig(v *AwsAppSyncGraphQlApiLogConfigDetails) *AwsAppSyncGraphQlApiDetails {
	s.LogConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetName(v string) *AwsAppSyncGraphQlApiDetails {
	s.Name = &v
	return s
}

// SetOpenIdConnectConfig sets the OpenIdConnectConfig field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetOpenIdConnectConfig(v *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) *AwsAppSyncGraphQlApiDetails {
	s.OpenIdConnectConfig = v
	return s
}

// SetUserPoolConfig sets the UserPoolConfig field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetUserPoolConfig(v *AwsAppSyncGraphQlApiUserPoolConfigDetails) *AwsAppSyncGraphQlApiDetails {
	s.UserPoolConfig = v
	return s
}

// SetWafWebAclArn sets the WafWebAclArn field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetWafWebAclArn(v string) *AwsAppSyncGraphQlApiDetails {
	s.WafWebAclArn = &v
	return s
}

// SetXrayEnabled sets the XrayEnabled field's value.
func (s *AwsAppSyncGraphQlApiDetails) SetXrayEnabled(v bool) *AwsAppSyncGraphQlApiDetails {
	s.XrayEnabled = &v
	return s
}

// Specifies the authorization configuration for using an Lambda function with
// your AppSync GraphQL API endpoint.
type AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails struct {
	_ struct{} `type:"structure"`

	// The number of seconds a response should be cached for. The default is 5 minutes
	// (300 seconds).
	AuthorizerResultTtlInSeconds *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the Lambda function to be called for authorization.
	// This can be a standard Lambda ARN, a version ARN (.../v3), or an alias ARN.
	AuthorizerUri *string `type:"string"`

	// A regular expression for validation of tokens before the Lambda function
	// is called.
	IdentityValidationExpression *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails) GoString() string {
	return s.String()
}

// SetAuthorizerResultTtlInSeconds sets the AuthorizerResultTtlInSeconds field's value.
func (s *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails) SetAuthorizerResultTtlInSeconds(v int64) *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails {
	s.AuthorizerResultTtlInSeconds = &v
	return s
}

// SetAuthorizerUri sets the AuthorizerUri field's value.
func (s *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails) SetAuthorizerUri(v string) *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails {
	s.AuthorizerUri = &v
	return s
}

// SetIdentityValidationExpression sets the IdentityValidationExpression field's value.
func (s *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails) SetIdentityValidationExpression(v string) *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails {
	s.IdentityValidationExpression = &v
	return s
}

// Specifies the logging configuration when writing GraphQL operations and tracing
// to Amazon CloudWatch for an AppSync GraphQL API.
type AwsAppSyncGraphQlApiLogConfigDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service role that AppSync assumes to
	// publish to CloudWatch Logs in your account.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Set to TRUE to exclude sections that contain information such as headers,
	// context, and evaluated mapping templates, regardless of logging level.
	ExcludeVerboseContent *bool `type:"boolean"`

	// The field logging level.
	FieldLogLevel *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiLogConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiLogConfigDetails) GoString() string {
	return s.String()
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *AwsAppSyncGraphQlApiLogConfigDetails) SetCloudWatchLogsRoleArn(v string) *AwsAppSyncGraphQlApiLogConfigDetails {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetExcludeVerboseContent sets the ExcludeVerboseContent field's value.
func (s *AwsAppSyncGraphQlApiLogConfigDetails) SetExcludeVerboseContent(v bool) *AwsAppSyncGraphQlApiLogConfigDetails {
	s.ExcludeVerboseContent = &v
	return s
}

// SetFieldLogLevel sets the FieldLogLevel field's value.
func (s *AwsAppSyncGraphQlApiLogConfigDetails) SetFieldLogLevel(v string) *AwsAppSyncGraphQlApiLogConfigDetails {
	s.FieldLogLevel = &v
	return s
}

// Specifies the authorization configuration for using an OpenID Connect compliant
// service with your AppSync GraphQL API endpoint.
type AwsAppSyncGraphQlApiOpenIdConnectConfigDetails struct {
	_ struct{} `type:"structure"`

	// The number of milliseconds that a token is valid after being authenticated.
	AuthTtL *int64 `type:"long"`

	// The client identifier of the relying party at the OpenID identity provider.
	// This identifier is typically obtained when the relying party is registered
	// with the OpenID identity provider. You can specify a regular expression so
	// that AppSync can validate against multiple client identifiers at a time.
	ClientId *string `type:"string"`

	// The number of milliseconds that a token is valid after it's issued to a user.
	IatTtL *int64 `type:"long"`

	// The issuer for the OIDC configuration. The issuer returned by discovery must
	// exactly match the value of iss in the ID token.
	Issuer *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) GoString() string {
	return s.String()
}

// SetAuthTtL sets the AuthTtL field's value.
func (s *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) SetAuthTtL(v int64) *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails {
	s.AuthTtL = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) SetClientId(v string) *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails {
	s.ClientId = &v
	return s
}

// SetIatTtL sets the IatTtL field's value.
func (s *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) SetIatTtL(v int64) *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails {
	s.IatTtL = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) SetIssuer(v string) *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails {
	s.Issuer = &v
	return s
}

// Specifies the authorization configuration for using Amazon Cognito user pools
// with your AppSync GraphQL API endpoint.
type AwsAppSyncGraphQlApiUserPoolConfigDetails struct {
	_ struct{} `type:"structure"`

	// A regular expression for validating the incoming Amazon Cognito user pools
	// app client ID. If this value isn't set, no filtering is applied.
	AppIdClientRegex *string `type:"string"`

	// The Amazon Web Services Region in which the user pool was created.
	AwsRegion *string `type:"string"`

	// The action that you want your GraphQL API to take when a request that uses
	// Amazon Cognito user pools authentication doesn't match the Amazon Cognito
	// user pools configuration.
	DefaultAction *string `type:"string"`

	// The user pool ID.
	UserPoolId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiUserPoolConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAppSyncGraphQlApiUserPoolConfigDetails) GoString() string {
	return s.String()
}

// SetAppIdClientRegex sets the AppIdClientRegex field's value.
func (s *AwsAppSyncGraphQlApiUserPoolConfigDetails) SetAppIdClientRegex(v string) *AwsAppSyncGraphQlApiUserPoolConfigDetails {
	s.AppIdClientRegex = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AwsAppSyncGraphQlApiUserPoolConfigDetails) SetAwsRegion(v string) *AwsAppSyncGraphQlApiUserPoolConfigDetails {
	s.AwsRegion = &v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *AwsAppSyncGraphQlApiUserPoolConfigDetails) SetDefaultAction(v string) *AwsAppSyncGraphQlApiUserPoolConfigDetails {
	s.DefaultAction = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AwsAppSyncGraphQlApiUserPoolConfigDetails) SetUserPoolId(v string) *AwsAppSyncGraphQlApiUserPoolConfigDetails {
	s.UserPoolId = &v
	return s
}

// The configuration of the workgroup, which includes the location in Amazon
// Simple Storage Service (Amazon S3) where query results are stored, the encryption
// option, if any, used for query results, whether Amazon CloudWatch metrics
// are enabled for the workgroup, and the limit for the amount of bytes scanned
// (cutoff) per query, if it is specified.
type AwsAthenaWorkGroupConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The location in Amazon S3 where query and calculation results are stored
	// and the encryption option, if any, used for query and calculation results.
	// These are known as client-side settings. If workgroup settings override client-side
	// settings, then the query uses the workgroup settings.
	ResultConfiguration *AwsAthenaWorkGroupConfigurationResultConfigurationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAthenaWorkGroupConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAthenaWorkGroupConfigurationDetails) GoString() string {
	return s.String()
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *AwsAthenaWorkGroupConfigurationDetails) SetResultConfiguration(v *AwsAthenaWorkGroupConfigurationResultConfigurationDetails) *AwsAthenaWorkGroupConfigurationDetails {
	s.ResultConfiguration = v
	return s
}

// The location in Amazon Simple Storage Service (Amazon S3) where query and
// calculation results are stored and the encryption option, if any, used for
// query and calculation results. These are known as client-side settings. If
// workgroup settings override client-side settings, then the query uses the
// workgroup settings.
type AwsAthenaWorkGroupConfigurationResultConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the method used to encrypt the user’s data stores in the Athena
	// workgroup.
	EncryptionConfiguration *AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAthenaWorkGroupConfigurationResultConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAthenaWorkGroupConfigurationResultConfigurationDetails) GoString() string {
	return s.String()
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *AwsAthenaWorkGroupConfigurationResultConfigurationDetails) SetEncryptionConfiguration(v *AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails) *AwsAthenaWorkGroupConfigurationResultConfigurationDetails {
	s.EncryptionConfiguration = v
	return s
}

// Specifies the method used to encrypt the user’s data stores in the Athena
// workgroup.
type AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether Amazon Simple Storage Service (Amazon S3) server-side encryption
	// with Amazon S3 managed keys (SSE_S3), server-side encryption with KMS keys
	// (SSE_KMS), or client-side encryption with KMS customer managed keys (CSE_KMS)
	// is used.
	EncryptionOption *string `type:"string"`

	// For SSE_KMS and CSE_KMS, this is the KMS key Amazon Resource Name (ARN) or
	// ID.
	KmsKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails) GoString() string {
	return s.String()
}

// SetEncryptionOption sets the EncryptionOption field's value.
func (s *AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails) SetEncryptionOption(v string) *AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails {
	s.EncryptionOption = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails) SetKmsKey(v string) *AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails {
	s.KmsKey = &v
	return s
}

// Provides information about an Amazon Athena workgroup.
type AwsAthenaWorkGroupDetails struct {
	_ struct{} `type:"structure"`

	// The configuration of the workgroup, which includes the location in Amazon
	// Simple Storage Service (Amazon S3) where query results are stored, the encryption
	// option, if any, used for query results, whether Amazon CloudWatch metrics
	// are enabled for the workgroup, and the limit for the amount of bytes scanned
	// (cutoff) per query, if it is specified.
	Configuration *AwsAthenaWorkGroupConfigurationDetails `type:"structure"`

	// The workgroup description.
	Description *string `type:"string"`

	// The workgroup name.
	Name *string `type:"string"`

	// Whether the workgroup is enabled or disabled.
	State *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAthenaWorkGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAthenaWorkGroupDetails) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *AwsAthenaWorkGroupDetails) SetConfiguration(v *AwsAthenaWorkGroupConfigurationDetails) *AwsAthenaWorkGroupDetails {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsAthenaWorkGroupDetails) SetDescription(v string) *AwsAthenaWorkGroupDetails {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsAthenaWorkGroupDetails) SetName(v string) *AwsAthenaWorkGroupDetails {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *AwsAthenaWorkGroupDetails) SetState(v string) *AwsAthenaWorkGroupDetails {
	s.State = &v
	return s
}

// An Availability Zone for the automatic scaling group.
type AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails) SetValue(v string) *AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails {
	s.Value = &v
	return s
}

// Provides details about an auto scaling group.
type AwsAutoScalingAutoScalingGroupDetails struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones for the automatic scaling group.
	AvailabilityZones []*AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails `type:"list"`

	// Indicates whether capacity rebalancing is enabled.
	CapacityRebalance *bool `type:"boolean"`

	// Indicates when the auto scaling group was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	CreatedTime *string `type:"string"`

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// it checks the health status of an EC2 instance that has come into service.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. Valid values are EC2 or ELB.
	HealthCheckType *string `type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `type:"string"`

	// The launch template to use.
	LaunchTemplate *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification `type:"structure"`

	// The list of load balancers associated with the group.
	LoadBalancerNames []*string `type:"list"`

	// The mixed instances policy for the automatic scaling group.
	MixedInstancesPolicy *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetAvailabilityZones(v []*AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails) *AwsAutoScalingAutoScalingGroupDetails {
	s.AvailabilityZones = v
	return s
}

// SetCapacityRebalance sets the CapacityRebalance field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetCapacityRebalance(v bool) *AwsAutoScalingAutoScalingGroupDetails {
	s.CapacityRebalance = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetCreatedTime(v string) *AwsAutoScalingAutoScalingGroupDetails {
	s.CreatedTime = &v
	return s
}

// SetHealthCheckGracePeriod sets the HealthCheckGracePeriod field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetHealthCheckGracePeriod(v int64) *AwsAutoScalingAutoScalingGroupDetails {
	s.HealthCheckGracePeriod = &v
	return s
}

// SetHealthCheckType sets the HealthCheckType field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetHealthCheckType(v string) *AwsAutoScalingAutoScalingGroupDetails {
	s.HealthCheckType = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetLaunchConfigurationName(v string) *AwsAutoScalingAutoScalingGroupDetails {
	s.LaunchConfigurationName = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetLaunchTemplate(v *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) *AwsAutoScalingAutoScalingGroupDetails {
	s.LaunchTemplate = v
	return s
}

// SetLoadBalancerNames sets the LoadBalancerNames field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetLoadBalancerNames(v []*string) *AwsAutoScalingAutoScalingGroupDetails {
	s.LoadBalancerNames = v
	return s
}

// SetMixedInstancesPolicy sets the MixedInstancesPolicy field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetMixedInstancesPolicy(v *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) *AwsAutoScalingAutoScalingGroupDetails {
	s.MixedInstancesPolicy = v
	return s
}

// Details about the launch template to use.
type AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName.
	LaunchTemplateId *string `type:"string"`

	// The name of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName.
	LaunchTemplateName *string `type:"string"`

	// Identifies the version of the launch template. You can specify a version
	// identifier, or use the values $Latest or $Default.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) GoString() string {
	return s.String()
}

// SetLaunchTemplateId sets the LaunchTemplateId field's value.
func (s *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) SetLaunchTemplateId(v string) *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification {
	s.LaunchTemplateId = &v
	return s
}

// SetLaunchTemplateName sets the LaunchTemplateName field's value.
func (s *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) SetLaunchTemplateName(v string) *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification {
	s.LaunchTemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) SetVersion(v string) *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification {
	s.Version = &v
	return s
}

// The mixed instances policy for the automatic scaling group.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails struct {
	_ struct{} `type:"structure"`

	// The instances distribution. The instances distribution specifies the distribution
	// of On-Demand Instances and Spot Instances, the maximum price to pay for Spot
	// Instances, and how the Auto Scaling group allocates instance types to fulfill
	// On-Demand and Spot capacity.
	InstancesDistribution *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails `type:"structure"`

	// The launch template to use and the instance types (overrides) to use to provision
	// EC2 instances to fulfill On-Demand and Spot capacities.
	LaunchTemplate *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) GoString() string {
	return s.String()
}

// SetInstancesDistribution sets the InstancesDistribution field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) SetInstancesDistribution(v *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails {
	s.InstancesDistribution = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) SetLaunchTemplate(v *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails {
	s.LaunchTemplate = v
	return s
}

// Information about the instances distribution.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails struct {
	_ struct{} `type:"structure"`

	// How to allocate instance types to fulfill On-Demand capacity. The valid value
	// is prioritized.
	OnDemandAllocationStrategy *string `type:"string"`

	// The minimum amount of the Auto Scaling group's capacity that must be fulfilled
	// by On-Demand Instances.
	OnDemandBaseCapacity *int64 `type:"integer"`

	// The percentage of On-Demand Instances and Spot Instances for additional capacity
	// beyond OnDemandBaseCapacity.
	OnDemandPercentageAboveBaseCapacity *int64 `type:"integer"`

	// How to allocate instances across Spot Instance pools. Valid values are as
	// follows:
	//
	//    * lowest-price
	//
	//    * capacity-optimized
	//
	//    * capacity-optimized-prioritized
	SpotAllocationStrategy *string `type:"string"`

	// The number of Spot Instance pools across which to allocate your Spot Instances.
	SpotInstancePools *int64 `type:"integer"`

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	SpotMaxPrice *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) GoString() string {
	return s.String()
}

// SetOnDemandAllocationStrategy sets the OnDemandAllocationStrategy field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetOnDemandAllocationStrategy(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.OnDemandAllocationStrategy = &v
	return s
}

// SetOnDemandBaseCapacity sets the OnDemandBaseCapacity field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetOnDemandBaseCapacity(v int64) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.OnDemandBaseCapacity = &v
	return s
}

// SetOnDemandPercentageAboveBaseCapacity sets the OnDemandPercentageAboveBaseCapacity field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetOnDemandPercentageAboveBaseCapacity(v int64) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.OnDemandPercentageAboveBaseCapacity = &v
	return s
}

// SetSpotAllocationStrategy sets the SpotAllocationStrategy field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetSpotAllocationStrategy(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.SpotAllocationStrategy = &v
	return s
}

// SetSpotInstancePools sets the SpotInstancePools field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetSpotInstancePools(v int64) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.SpotInstancePools = &v
	return s
}

// SetSpotMaxPrice sets the SpotMaxPrice field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetSpotMaxPrice(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.SpotMaxPrice = &v
	return s
}

// Describes a launch template and overrides for a mixed instances policy.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails struct {
	_ struct{} `type:"structure"`

	// The launch template to use for a mixed instances policy.
	LaunchTemplateSpecification *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification `type:"structure"`

	// Property values to use to override the values in the launch template.
	Overrides []*AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) GoString() string {
	return s.String()
}

// SetLaunchTemplateSpecification sets the LaunchTemplateSpecification field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) SetLaunchTemplateSpecification(v *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails {
	s.LaunchTemplateSpecification = v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) SetOverrides(v []*AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails {
	s.Overrides = v
	return s
}

// Details about the launch template to use for a mixed instances policy.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName.
	LaunchTemplateId *string `type:"string"`

	// The name of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName.
	LaunchTemplateName *string `type:"string"`

	// Identifies the version of the launch template. You can specify a version
	// identifier, or use the values $Latest or $Default.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) GoString() string {
	return s.String()
}

// SetLaunchTemplateId sets the LaunchTemplateId field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) SetLaunchTemplateId(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification {
	s.LaunchTemplateId = &v
	return s
}

// SetLaunchTemplateName sets the LaunchTemplateName field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) SetLaunchTemplateName(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification {
	s.LaunchTemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) SetVersion(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification {
	s.Version = &v
	return s
}

// Property values to use to override the values in the launch template.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails struct {
	_ struct{} `type:"structure"`

	// The instance type. For example, m3.xlarge.
	InstanceType *string `type:"string"`

	// The number of capacity units provided by the specified instance type in terms
	// of virtual CPUs, memory, storage, throughput, or other relative performance
	// characteristic.
	WeightedCapacity *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails) GoString() string {
	return s.String()
}

// SetInstanceType sets the InstanceType field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails) SetInstanceType(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails {
	s.InstanceType = &v
	return s
}

// SetWeightedCapacity sets the WeightedCapacity field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails) SetWeightedCapacity(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails {
	s.WeightedCapacity = &v
	return s
}

// A block device for the instance.
type AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails struct {
	_ struct{} `type:"structure"`

	// The device name that is exposed to the EC2 instance. For example, /dev/sdh
	// or xvdh.
	DeviceName *string `type:"string"`

	// Parameters that are used to automatically set up Amazon EBS volumes when
	// an instance is launched.
	Ebs *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails `type:"structure"`

	// Whether to suppress the device that is included in the block device mapping
	// of the Amazon Machine Image (AMI).
	//
	// If NoDevice is true, then you cannot specify Ebs.>
	NoDevice *bool `type:"boolean"`

	// The name of the virtual device (for example, ephemeral0).
	//
	// You can provide either VirtualName or Ebs, but not both.
	VirtualName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) SetDeviceName(v string) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
	s.DeviceName = &v
	return s
}

// SetEbs sets the Ebs field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) SetEbs(v *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
	s.Ebs = v
	return s
}

// SetNoDevice sets the NoDevice field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) SetNoDevice(v bool) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
	s.NoDevice = &v
	return s
}

// SetVirtualName sets the VirtualName field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) SetVirtualName(v string) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
	s.VirtualName = &v
	return s
}

// Parameters that are used to automatically set up EBS volumes when an instance
// is launched.
type AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails struct {
	_ struct{} `type:"structure"`

	// Whether to delete the volume when the instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// Whether to encrypt the volume.
	Encrypted *bool `type:"boolean"`

	// The number of input/output (I/O) operations per second (IOPS) to provision
	// for the volume.
	//
	// Only supported for gp3 or io1 volumes. Required for io1 volumes. Not used
	// with standard, gp2, st1, or sc1 volumes.
	Iops *int64 `type:"integer"`

	// The snapshot ID of the volume to use.
	//
	// You must specify either VolumeSize or SnapshotId.
	SnapshotId *string `type:"string"`

	// The volume size, in GiBs. The following are the supported volumes sizes for
	// each volume type:
	//
	//    * gp2 and gp3: 1-16,384
	//
	//    * io1: 4-16,384
	//
	//    * st1 and sc1: 125-16,384
	//
	//    * standard: 1-1,024
	//
	// You must specify either SnapshotId or VolumeSize. If you specify both SnapshotId
	// and VolumeSize, the volume size must be equal or greater than the size of
	// the snapshot.
	VolumeSize *int64 `type:"integer"`

	// The volume type. Valid values are as follows:
	//
	//    * gp2
	//
	//    * gp3
	//
	//    * io1
	//
	//    * sc1
	//
	//    * st1
	//
	//    * standard
	VolumeType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) GoString() string {
	return s.String()
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetDeleteOnTermination(v bool) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.DeleteOnTermination = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetEncrypted(v bool) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.Encrypted = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetIops(v int64) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.Iops = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetSnapshotId(v string) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.SnapshotId = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetVolumeSize(v int64) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetVolumeType(v string) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.VolumeType = &v
	return s
}

// Details about a launch configuration.
type AwsAutoScalingLaunchConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// For Auto Scaling groups that run in a VPC, specifies whether to assign a
	// public IP address to the group's instances.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// Specifies the block devices for the instance.
	BlockDeviceMappings []*AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails `type:"list"`

	// The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are
	// linked to.
	ClassicLinkVpcId *string `type:"string"`

	// The identifiers of one or more security groups for the VPC that is specified
	// in ClassicLinkVPCId.
	ClassicLinkVpcSecurityGroups []*string `type:"list"`

	// The creation date and time for the launch configuration.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	CreatedTime *string `type:"string"`

	// Whether the launch configuration is optimized for Amazon EBS I/O.
	EbsOptimized *bool `type:"boolean"`

	// The name or the ARN of the instance profile associated with the IAM role
	// for the instance. The instance profile contains the IAM role.
	IamInstanceProfile *string `type:"string"`

	// The identifier of the Amazon Machine Image (AMI) that is used to launch EC2
	// instances.
	ImageId *string `type:"string"`

	// Indicates the type of monitoring for instances in the group.
	InstanceMonitoring *AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails `type:"structure"`

	// The instance type for the instances.
	InstanceType *string `type:"string"`

	// The identifier of the kernel associated with the AMI.
	KernelId *string `type:"string"`

	// The name of the key pair.
	KeyName *string `type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `type:"string"`

	// The metadata options for the instances.
	MetadataOptions *AwsAutoScalingLaunchConfigurationMetadataOptions `type:"structure"`

	// The tenancy of the instance. An instance with dedicated tenancy runs on isolated,
	// single-tenant hardware and can only be launched into a VPC.
	PlacementTenancy *string `type:"string"`

	// The identifier of the RAM disk associated with the AMI.
	RamdiskId *string `type:"string"`

	// The security groups to assign to the instances in the Auto Scaling group.
	SecurityGroups []*string `type:"list"`

	// The maximum hourly price to be paid for any Spot Instance that is launched
	// to fulfill the request.
	SpotPrice *string `type:"string"`

	// The user data to make available to the launched EC2 instances. Must be base64-encoded
	// text.
	UserData *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationDetails) GoString() string {
	return s.String()
}

// SetAssociatePublicIpAddress sets the AssociatePublicIpAddress field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetAssociatePublicIpAddress(v bool) *AwsAutoScalingLaunchConfigurationDetails {
	s.AssociatePublicIpAddress = &v
	return s
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetBlockDeviceMappings(v []*AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) *AwsAutoScalingLaunchConfigurationDetails {
	s.BlockDeviceMappings = v
	return s
}

// SetClassicLinkVpcId sets the ClassicLinkVpcId field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetClassicLinkVpcId(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.ClassicLinkVpcId = &v
	return s
}

// SetClassicLinkVpcSecurityGroups sets the ClassicLinkVpcSecurityGroups field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetClassicLinkVpcSecurityGroups(v []*string) *AwsAutoScalingLaunchConfigurationDetails {
	s.ClassicLinkVpcSecurityGroups = v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetCreatedTime(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.CreatedTime = &v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetEbsOptimized(v bool) *AwsAutoScalingLaunchConfigurationDetails {
	s.EbsOptimized = &v
	return s
}

// SetIamInstanceProfile sets the IamInstanceProfile field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetIamInstanceProfile(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.IamInstanceProfile = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetImageId(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.ImageId = &v
	return s
}

// SetInstanceMonitoring sets the InstanceMonitoring field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetInstanceMonitoring(v *AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails) *AwsAutoScalingLaunchConfigurationDetails {
	s.InstanceMonitoring = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetInstanceType(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.InstanceType = &v
	return s
}

// SetKernelId sets the KernelId field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetKernelId(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.KernelId = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetKeyName(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.KeyName = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetLaunchConfigurationName(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.LaunchConfigurationName = &v
	return s
}

// SetMetadataOptions sets the MetadataOptions field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetMetadataOptions(v *AwsAutoScalingLaunchConfigurationMetadataOptions) *AwsAutoScalingLaunchConfigurationDetails {
	s.MetadataOptions = v
	return s
}

// SetPlacementTenancy sets the PlacementTenancy field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetPlacementTenancy(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.PlacementTenancy = &v
	return s
}

// SetRamdiskId sets the RamdiskId field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetRamdiskId(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.RamdiskId = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetSecurityGroups(v []*string) *AwsAutoScalingLaunchConfigurationDetails {
	s.SecurityGroups = v
	return s
}

// SetSpotPrice sets the SpotPrice field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetSpotPrice(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.SpotPrice = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetUserData(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.UserData = &v
	return s
}

// Information about the type of monitoring for instances in the group.
type AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails struct {
	_ struct{} `type:"structure"`

	// If set to true, then instances in the group launch with detailed monitoring.
	//
	// If set to false, then instances in the group launch with basic monitoring.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails) SetEnabled(v bool) *AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails {
	s.Enabled = &v
	return s
}

// The metadata options for the instances.
type AwsAutoScalingLaunchConfigurationMetadataOptions struct {
	_ struct{} `type:"structure"`

	// Enables or disables the HTTP metadata endpoint on your instances. By default,
	// the metadata endpoint is enabled.
	HttpEndpoint *string `type:"string"`

	// The HTTP PUT response hop limit for instance metadata requests. The larger
	// the number, the further instance metadata requests can travel.
	HttpPutResponseHopLimit *int64 `type:"integer"`

	// Indicates whether token usage is required or optional for metadata requests.
	// By default, token usage is optional.
	HttpTokens *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationMetadataOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationMetadataOptions) GoString() string {
	return s.String()
}

// SetHttpEndpoint sets the HttpEndpoint field's value.
func (s *AwsAutoScalingLaunchConfigurationMetadataOptions) SetHttpEndpoint(v string) *AwsAutoScalingLaunchConfigurationMetadataOptions {
	s.HttpEndpoint = &v
	return s
}

// SetHttpPutResponseHopLimit sets the HttpPutResponseHopLimit field's value.
func (s *AwsAutoScalingLaunchConfigurationMetadataOptions) SetHttpPutResponseHopLimit(v int64) *AwsAutoScalingLaunchConfigurationMetadataOptions {
	s.HttpPutResponseHopLimit = &v
	return s
}

// SetHttpTokens sets the HttpTokens field's value.
func (s *AwsAutoScalingLaunchConfigurationMetadataOptions) SetHttpTokens(v string) *AwsAutoScalingLaunchConfigurationMetadataOptions {
	s.HttpTokens = &v
	return s
}

// Provides a list of backup options for each resource type.
type AwsBackupBackupPlanAdvancedBackupSettingsDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the backup option for a selected resource. This option is only
	// available for Windows Volume Shadow Copy Service (VSS) backup jobs. Valid
	// values are as follows:
	//
	//    * Set to WindowsVSS: enabled to enable the WindowsVSS backup option and
	//    create a Windows VSS backup.
	//
	//    * Set to WindowsVSS: disabled to create a regular backup. The WindowsVSS
	//    option is not enabled by default.
	BackupOptions map[string]*string `type:"map"`

	// The name of a resource type. The only supported resource type is Amazon EC2
	// instances with Windows VSS.
	//
	// The only valid value is EC2.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanAdvancedBackupSettingsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanAdvancedBackupSettingsDetails) GoString() string {
	return s.String()
}

// SetBackupOptions sets the BackupOptions field's value.
func (s *AwsBackupBackupPlanAdvancedBackupSettingsDetails) SetBackupOptions(v map[string]*string) *AwsBackupBackupPlanAdvancedBackupSettingsDetails {
	s.BackupOptions = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AwsBackupBackupPlanAdvancedBackupSettingsDetails) SetResourceType(v string) *AwsBackupBackupPlanAdvancedBackupSettingsDetails {
	s.ResourceType = &v
	return s
}

// Provides details about an Backup backup plan and an array of BackupRule objects,
// each of which specifies a backup rule.
type AwsBackupBackupPlanBackupPlanDetails struct {
	_ struct{} `type:"structure"`

	// A list of backup options for each resource type.
	AdvancedBackupSettings []*AwsBackupBackupPlanAdvancedBackupSettingsDetails `type:"list"`

	// The display name of a backup plan.
	BackupPlanName *string `type:"string"`

	// An array of BackupRule objects, each of which specifies a scheduled task
	// that is used to back up a selection of resources.
	BackupPlanRule []*AwsBackupBackupPlanRuleDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanBackupPlanDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanBackupPlanDetails) GoString() string {
	return s.String()
}

// SetAdvancedBackupSettings sets the AdvancedBackupSettings field's value.
func (s *AwsBackupBackupPlanBackupPlanDetails) SetAdvancedBackupSettings(v []*AwsBackupBackupPlanAdvancedBackupSettingsDetails) *AwsBackupBackupPlanBackupPlanDetails {
	s.AdvancedBackupSettings = v
	return s
}

// SetBackupPlanName sets the BackupPlanName field's value.
func (s *AwsBackupBackupPlanBackupPlanDetails) SetBackupPlanName(v string) *AwsBackupBackupPlanBackupPlanDetails {
	s.BackupPlanName = &v
	return s
}

// SetBackupPlanRule sets the BackupPlanRule field's value.
func (s *AwsBackupBackupPlanBackupPlanDetails) SetBackupPlanRule(v []*AwsBackupBackupPlanRuleDetails) *AwsBackupBackupPlanBackupPlanDetails {
	s.BackupPlanRule = v
	return s
}

// Provides details about an Backup backup plan and an array of BackupRule objects,
// each of which specifies a backup rule.
type AwsBackupBackupPlanDetails struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies the backup plan to be associated with the selection of
	// resources.
	BackupPlan *AwsBackupBackupPlanBackupPlanDetails `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies the backup plan.
	BackupPlanArn *string `type:"string"`

	// A unique ID for the backup plan.
	BackupPlanId *string `type:"string"`

	// Unique, randomly generated, Unicode, UTF-8 encoded strings. Version IDs cannot
	// be edited.
	VersionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanDetails) GoString() string {
	return s.String()
}

// SetBackupPlan sets the BackupPlan field's value.
func (s *AwsBackupBackupPlanDetails) SetBackupPlan(v *AwsBackupBackupPlanBackupPlanDetails) *AwsBackupBackupPlanDetails {
	s.BackupPlan = v
	return s
}

// SetBackupPlanArn sets the BackupPlanArn field's value.
func (s *AwsBackupBackupPlanDetails) SetBackupPlanArn(v string) *AwsBackupBackupPlanDetails {
	s.BackupPlanArn = &v
	return s
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *AwsBackupBackupPlanDetails) SetBackupPlanId(v string) *AwsBackupBackupPlanDetails {
	s.BackupPlanId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *AwsBackupBackupPlanDetails) SetVersionId(v string) *AwsBackupBackupPlanDetails {
	s.VersionId = &v
	return s
}

// Provides lifecycle details for the backup plan. A lifecycle defines when
// a backup is transitioned to cold storage and when it expires.
type AwsBackupBackupPlanLifecycleDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days after creation that a recovery point is deleted.
	// Must be greater than 90 days plus MoveToColdStorageAfterDays.
	DeleteAfterDays *int64 `type:"long"`

	// Specifies the number of days after creation that a recovery point is moved
	// to cold storage.
	MoveToColdStorageAfterDays *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanLifecycleDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanLifecycleDetails) GoString() string {
	return s.String()
}

// SetDeleteAfterDays sets the DeleteAfterDays field's value.
func (s *AwsBackupBackupPlanLifecycleDetails) SetDeleteAfterDays(v int64) *AwsBackupBackupPlanLifecycleDetails {
	s.DeleteAfterDays = &v
	return s
}

// SetMoveToColdStorageAfterDays sets the MoveToColdStorageAfterDays field's value.
func (s *AwsBackupBackupPlanLifecycleDetails) SetMoveToColdStorageAfterDays(v int64) *AwsBackupBackupPlanLifecycleDetails {
	s.MoveToColdStorageAfterDays = &v
	return s
}

// An array of CopyAction objects, each of which contains details of the copy
// operation.
type AwsBackupBackupPlanRuleCopyActionsDetails struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies the destination backup
	// vault for the copied backup.
	DestinationBackupVaultArn *string `type:"string"`

	// Defines when a protected resource is transitioned to cold storage and when
	// it expires. Backup transitions and expires backups automatically according
	// to the lifecycle that you define. If you do not specify a lifecycle, Backup
	// applies the lifecycle policy of the source backup to the destination backup.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days.
	Lifecycle *AwsBackupBackupPlanLifecycleDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanRuleCopyActionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanRuleCopyActionsDetails) GoString() string {
	return s.String()
}

// SetDestinationBackupVaultArn sets the DestinationBackupVaultArn field's value.
func (s *AwsBackupBackupPlanRuleCopyActionsDetails) SetDestinationBackupVaultArn(v string) *AwsBackupBackupPlanRuleCopyActionsDetails {
	s.DestinationBackupVaultArn = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *AwsBackupBackupPlanRuleCopyActionsDetails) SetLifecycle(v *AwsBackupBackupPlanLifecycleDetails) *AwsBackupBackupPlanRuleCopyActionsDetails {
	s.Lifecycle = v
	return s
}

// Provides details about an array of BackupRule objects, each of which specifies
// a scheduled task that is used to back up a selection of resources.
type AwsBackupBackupPlanRuleDetails struct {
	_ struct{} `type:"structure"`

	// A value in minutes after a backup job is successfully started before it must
	// be completed, or it is canceled by Backup.
	CompletionWindowMinutes *int64 `type:"long"`

	// An array of CopyAction objects, each of which contains details of the copy
	// operation.
	CopyActions []*AwsBackupBackupPlanRuleCopyActionsDetails `type:"list"`

	// Specifies whether Backup creates continuous backups capable of point-in-time
	// restore (PITR).
	EnableContinuousBackup *bool `type:"boolean"`

	// Defines when a protected resource is transitioned to cold storage and when
	// it expires. Backup transitions and expires backups automatically according
	// to the lifecycle that you define. If you do not specify a lifecycle, Backup
	// applies the lifecycle policy of the source backup to the destination backup.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days.
	Lifecycle *AwsBackupBackupPlanLifecycleDetails `type:"structure"`

	// Uniquely identifies a rule that is used to schedule the backup of a selection
	// of resources.
	RuleId *string `type:"string"`

	// A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.'
	// characters.
	RuleName *string `type:"string"`

	// A cron expression in UTC specifying when Backup initiates a backup job.
	ScheduleExpression *string `type:"string"`

	// A value in minutes after a backup is scheduled before a job will be canceled
	// if it doesn't start successfully.
	StartWindowMinutes *int64 `type:"long"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the Amazon Web Services account used
	// to create them and the Amazon Web Services Region where they are created.
	// They consist of letters, numbers, and hyphens.
	TargetBackupVault *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanRuleDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupPlanRuleDetails) GoString() string {
	return s.String()
}

// SetCompletionWindowMinutes sets the CompletionWindowMinutes field's value.
func (s *AwsBackupBackupPlanRuleDetails) SetCompletionWindowMinutes(v int64) *AwsBackupBackupPlanRuleDetails {
	s.CompletionWindowMinutes = &v
	return s
}

// SetCopyActions sets the CopyActions field's value.
func (s *AwsBackupBackupPlanRuleDetails) SetCopyActions(v []*AwsBackupBackupPlanRuleCopyActionsDetails) *AwsBackupBackupPlanRuleDetails {
	s.CopyActions = v
	return s
}

// SetEnableContinuousBackup sets the EnableContinuousBackup field's value.
func (s *AwsBackupBackupPlanRuleDetails) SetEnableContinuousBackup(v bool) *AwsBackupBackupPlanRuleDetails {
	s.EnableContinuousBackup = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *AwsBackupBackupPlanRuleDetails) SetLifecycle(v *AwsBackupBackupPlanLifecycleDetails) *AwsBackupBackupPlanRuleDetails {
	s.Lifecycle = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *AwsBackupBackupPlanRuleDetails) SetRuleId(v string) *AwsBackupBackupPlanRuleDetails {
	s.RuleId = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *AwsBackupBackupPlanRuleDetails) SetRuleName(v string) *AwsBackupBackupPlanRuleDetails {
	s.RuleName = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *AwsBackupBackupPlanRuleDetails) SetScheduleExpression(v string) *AwsBackupBackupPlanRuleDetails {
	s.ScheduleExpression = &v
	return s
}

// SetStartWindowMinutes sets the StartWindowMinutes field's value.
func (s *AwsBackupBackupPlanRuleDetails) SetStartWindowMinutes(v int64) *AwsBackupBackupPlanRuleDetails {
	s.StartWindowMinutes = &v
	return s
}

// SetTargetBackupVault sets the TargetBackupVault field's value.
func (s *AwsBackupBackupPlanRuleDetails) SetTargetBackupVault(v string) *AwsBackupBackupPlanRuleDetails {
	s.TargetBackupVault = &v
	return s
}

// Provides details about an Backup backup vault. In Backup, a backup vault
// is a container that stores and organizes your backups.
type AwsBackupBackupVaultDetails struct {
	_ struct{} `type:"structure"`

	// A resource-based policy that is used to manage access permissions on the
	// target backup vault.
	AccessPolicy *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the Amazon Web Services account used
	// to create them and the Amazon Web Services Region where they are created.
	// They consist of lowercase letters, numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// The unique ARN associated with the server-side encryption key. You can specify
	// a key to encrypt your backups from services that support full Backup management.
	// If you do not specify a key, Backup creates an KMS key for you by default.
	EncryptionKeyArn *string `type:"string"`

	// The Amazon SNS event notifications for the specified backup vault.
	Notifications *AwsBackupBackupVaultNotificationsDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupVaultDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupVaultDetails) GoString() string {
	return s.String()
}

// SetAccessPolicy sets the AccessPolicy field's value.
func (s *AwsBackupBackupVaultDetails) SetAccessPolicy(v string) *AwsBackupBackupVaultDetails {
	s.AccessPolicy = &v
	return s
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *AwsBackupBackupVaultDetails) SetBackupVaultArn(v string) *AwsBackupBackupVaultDetails {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *AwsBackupBackupVaultDetails) SetBackupVaultName(v string) *AwsBackupBackupVaultDetails {
	s.BackupVaultName = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *AwsBackupBackupVaultDetails) SetEncryptionKeyArn(v string) *AwsBackupBackupVaultDetails {
	s.EncryptionKeyArn = &v
	return s
}

// SetNotifications sets the Notifications field's value.
func (s *AwsBackupBackupVaultDetails) SetNotifications(v *AwsBackupBackupVaultNotificationsDetails) *AwsBackupBackupVaultDetails {
	s.Notifications = v
	return s
}

// Provides details about the Amazon SNS event notifications for the specified
// backup vault.
type AwsBackupBackupVaultNotificationsDetails struct {
	_ struct{} `type:"structure"`

	// An array of events that indicate the status of jobs to back up resources
	// to the backup vault. The following events are supported:
	//
	//    * BACKUP_JOB_STARTED | BACKUP_JOB_COMPLETED
	//
	//    * COPY_JOB_STARTED | COPY_JOB_SUCCESSFUL | COPY_JOB_FAILED
	//
	//    * RESTORE_JOB_STARTED | RESTORE_JOB_COMPLETED | RECOVERY_POINT_MODIFIED
	//
	//    * S3_BACKUP_OBJECT_FAILED | S3_RESTORE_OBJECT_FAILED
	BackupVaultEvents []*string `type:"list"`

	// The Amazon Resource Name (ARN) that uniquely identifies the Amazon SNS topic
	// for a backup vault's events.
	SnsTopicArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupVaultNotificationsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupBackupVaultNotificationsDetails) GoString() string {
	return s.String()
}

// SetBackupVaultEvents sets the BackupVaultEvents field's value.
func (s *AwsBackupBackupVaultNotificationsDetails) SetBackupVaultEvents(v []*string) *AwsBackupBackupVaultNotificationsDetails {
	s.BackupVaultEvents = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *AwsBackupBackupVaultNotificationsDetails) SetSnsTopicArn(v string) *AwsBackupBackupVaultNotificationsDetails {
	s.SnsTopicArn = &v
	return s
}

// Specifies how long in days before a recovery point transitions to cold storage
// or is deleted.
type AwsBackupRecoveryPointCalculatedLifecycleDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days after creation that a recovery point is deleted.
	// Must be greater than 90 days plus MoveToColdStorageAfterDays.
	DeleteAt *string `type:"string"`

	// Specifies the number of days after creation that a recovery point is moved
	// to cold storage.
	MoveToColdStorageAt *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupRecoveryPointCalculatedLifecycleDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupRecoveryPointCalculatedLifecycleDetails) GoString() string {
	return s.String()
}

// SetDeleteAt sets the DeleteAt field's value.
func (s *AwsBackupRecoveryPointCalculatedLifecycleDetails) SetDeleteAt(v string) *AwsBackupRecoveryPointCalculatedLifecycleDetails {
	s.DeleteAt = &v
	return s
}

// SetMoveToColdStorageAt sets the MoveToColdStorageAt field's value.
func (s *AwsBackupRecoveryPointCalculatedLifecycleDetails) SetMoveToColdStorageAt(v string) *AwsBackupRecoveryPointCalculatedLifecycleDetails {
	s.MoveToColdStorageAt = &v
	return s
}

// Contains information about the backup plan and rule that Backup used to initiate
// the recovery point backup.
type AwsBackupRecoveryPointCreatedByDetails struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan.
	BackupPlanArn *string `type:"string"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most
	// 1,024 bytes long. Version IDs cannot be edited.
	BackupPlanVersion *string `type:"string"`

	// Uniquely identifies a rule used to schedule the backup of a selection of
	// resources.
	BackupRuleId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupRecoveryPointCreatedByDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupRecoveryPointCreatedByDetails) GoString() string {
	return s.String()
}

// SetBackupPlanArn sets the BackupPlanArn field's value.
func (s *AwsBackupRecoveryPointCreatedByDetails) SetBackupPlanArn(v string) *AwsBackupRecoveryPointCreatedByDetails {
	s.BackupPlanArn = &v
	return s
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *AwsBackupRecoveryPointCreatedByDetails) SetBackupPlanId(v string) *AwsBackupRecoveryPointCreatedByDetails {
	s.BackupPlanId = &v
	return s
}

// SetBackupPlanVersion sets the BackupPlanVersion field's value.
func (s *AwsBackupRecoveryPointCreatedByDetails) SetBackupPlanVersion(v string) *AwsBackupRecoveryPointCreatedByDetails {
	s.BackupPlanVersion = &v
	return s
}

// SetBackupRuleId sets the BackupRuleId field's value.
func (s *AwsBackupRecoveryPointCreatedByDetails) SetBackupRuleId(v string) *AwsBackupRecoveryPointCreatedByDetails {
	s.BackupRuleId = &v
	return s
}

// Contains detailed information about the recovery points stored in an Backup
// backup vault. A backup, or recovery point, represents the content of a resource
// at a specified time.
type AwsBackupRecoveryPointDetails struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64 `type:"long"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the Amazon Web Services account used
	// to create them and the Amazon Web Services Region where they are created.
	// They consist of lowercase letters, numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// A CalculatedLifecycle object containing DeleteAt and MoveToColdStorageAt
	// timestamps.
	CalculatedLifecycle *AwsBackupRecoveryPointCalculatedLifecycleDetails `type:"structure"`

	// The date and time that a job to create a recovery point is completed, in
	// Unix format and UTC. The value of CompletionDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CompletionDate *string `type:"string"`

	// Contains identifying information about the creation of a recovery point,
	// including the BackupPlanArn, BackupPlanId, BackupPlanVersion, and BackupRuleId
	// of the backup plan that is used to create it.
	CreatedBy *AwsBackupRecoveryPointCreatedByDetails `type:"structure"`

	// The date and time a recovery point is created, in Unix format and UTC. The
	// value of CreationDate is accurate to milliseconds. For example, the value
	// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	CreationDate *string `type:"string"`

	// The ARN for the server-side encryption key that is used to protect your backups.
	EncryptionKeyArn *string `type:"string"`

	// Specifies the IAM role ARN used to create the target recovery point
	IamRoleArn *string `type:"string"`

	// A Boolean value that is returned as TRUE if the specified recovery point
	// is encrypted, or FALSE if the recovery point is not encrypted.
	IsEncrypted *bool `type:"boolean"`

	// The date and time that a recovery point was last restored, in Unix format
	// and UTC. The value of LastRestoreTime is accurate to milliseconds. For example,
	// the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
	// AM.
	LastRestoreTime *string `type:"string"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup transitions and expires backups automatically
	// according to the lifecycle that you define
	Lifecycle *AwsBackupRecoveryPointLifecycleDetails `type:"structure"`

	// An ARN that uniquely identifies a recovery point.
	RecoveryPointArn *string `type:"string"`

	// An ARN that uniquely identifies a resource. The format of the ARN depends
	// on the resource type.
	ResourceArn *string `type:"string"`

	// The type of Amazon Web Services resource saved as a recovery point, such
	// as an Amazon EBS volume or an Amazon RDS database.
	ResourceType *string `type:"string"`

	// The ARN for the backup vault where the recovery point was originally copied
	// from. If the recovery point is restored to the same account, this value will
	// be null.
	SourceBackupVaultArn *string `type:"string"`

	// A status code specifying the state of the recovery point. Valid values are
	// as follows:
	//
	//    * COMPLETED
	//
	//    * DELETING
	//
	//    * EXPIRED
	//
	//    * PARTIAL
	Status *string `type:"string"`

	// A message explaining the reason of the recovery point deletion failure.
	StatusMessage *string `type:"string"`

	// Specifies the storage class of the recovery point. Valid values are as follows:
	//
	//    * COLD
	//
	//    * DELETED
	//
	//    * WARM
	StorageClass *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupRecoveryPointDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupRecoveryPointDetails) GoString() string {
	return s.String()
}

// SetBackupSizeInBytes sets the BackupSizeInBytes field's value.
func (s *AwsBackupRecoveryPointDetails) SetBackupSizeInBytes(v int64) *AwsBackupRecoveryPointDetails {
	s.BackupSizeInBytes = &v
	return s
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *AwsBackupRecoveryPointDetails) SetBackupVaultArn(v string) *AwsBackupRecoveryPointDetails {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *AwsBackupRecoveryPointDetails) SetBackupVaultName(v string) *AwsBackupRecoveryPointDetails {
	s.BackupVaultName = &v
	return s
}

// SetCalculatedLifecycle sets the CalculatedLifecycle field's value.
func (s *AwsBackupRecoveryPointDetails) SetCalculatedLifecycle(v *AwsBackupRecoveryPointCalculatedLifecycleDetails) *AwsBackupRecoveryPointDetails {
	s.CalculatedLifecycle = v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *AwsBackupRecoveryPointDetails) SetCompletionDate(v string) *AwsBackupRecoveryPointDetails {
	s.CompletionDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *AwsBackupRecoveryPointDetails) SetCreatedBy(v *AwsBackupRecoveryPointCreatedByDetails) *AwsBackupRecoveryPointDetails {
	s.CreatedBy = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AwsBackupRecoveryPointDetails) SetCreationDate(v string) *AwsBackupRecoveryPointDetails {
	s.CreationDate = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *AwsBackupRecoveryPointDetails) SetEncryptionKeyArn(v string) *AwsBackupRecoveryPointDetails {
	s.EncryptionKeyArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *AwsBackupRecoveryPointDetails) SetIamRoleArn(v string) *AwsBackupRecoveryPointDetails {
	s.IamRoleArn = &v
	return s
}

// SetIsEncrypted sets the IsEncrypted field's value.
func (s *AwsBackupRecoveryPointDetails) SetIsEncrypted(v bool) *AwsBackupRecoveryPointDetails {
	s.IsEncrypted = &v
	return s
}

// SetLastRestoreTime sets the LastRestoreTime field's value.
func (s *AwsBackupRecoveryPointDetails) SetLastRestoreTime(v string) *AwsBackupRecoveryPointDetails {
	s.LastRestoreTime = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *AwsBackupRecoveryPointDetails) SetLifecycle(v *AwsBackupRecoveryPointLifecycleDetails) *AwsBackupRecoveryPointDetails {
	s.Lifecycle = v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *AwsBackupRecoveryPointDetails) SetRecoveryPointArn(v string) *AwsBackupRecoveryPointDetails {
	s.RecoveryPointArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AwsBackupRecoveryPointDetails) SetResourceArn(v string) *AwsBackupRecoveryPointDetails {
	s.ResourceArn = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AwsBackupRecoveryPointDetails) SetResourceType(v string) *AwsBackupRecoveryPointDetails {
	s.ResourceType = &v
	return s
}

// SetSourceBackupVaultArn sets the SourceBackupVaultArn field's value.
func (s *AwsBackupRecoveryPointDetails) SetSourceBackupVaultArn(v string) *AwsBackupRecoveryPointDetails {
	s.SourceBackupVaultArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsBackupRecoveryPointDetails) SetStatus(v string) *AwsBackupRecoveryPointDetails {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *AwsBackupRecoveryPointDetails) SetStatusMessage(v string) *AwsBackupRecoveryPointDetails {
	s.StatusMessage = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *AwsBackupRecoveryPointDetails) SetStorageClass(v string) *AwsBackupRecoveryPointDetails {
	s.StorageClass = &v
	return s
}

// Contains an array of Transition objects specifying how long in days before
// a recovery point transitions to cold storage or is deleted.
type AwsBackupRecoveryPointLifecycleDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days after creation that a recovery point is deleted.
	// Must be greater than 90 days plus MoveToColdStorageAfterDays.
	DeleteAfterDays *int64 `type:"long"`

	// Specifies the number of days after creation that a recovery point is moved
	// to cold storage.
	MoveToColdStorageAfterDays *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupRecoveryPointLifecycleDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsBackupRecoveryPointLifecycleDetails) GoString() string {
	return s.String()
}

// SetDeleteAfterDays sets the DeleteAfterDays field's value.
func (s *AwsBackupRecoveryPointLifecycleDetails) SetDeleteAfterDays(v int64) *AwsBackupRecoveryPointLifecycleDetails {
	s.DeleteAfterDays = &v
	return s
}

// SetMoveToColdStorageAfterDays sets the MoveToColdStorageAfterDays field's value.
func (s *AwsBackupRecoveryPointLifecycleDetails) SetMoveToColdStorageAfterDays(v int64) *AwsBackupRecoveryPointLifecycleDetails {
	s.MoveToColdStorageAfterDays = &v
	return s
}

// Provides details about an Certificate Manager certificate.
type AwsCertificateManagerCertificateDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the private certificate authority (CA) that will be used to issue
	// the certificate.
	CertificateAuthorityArn *string `type:"string"`

	// Indicates when the certificate was requested.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	CreatedAt *string `type:"string"`

	// The fully qualified domain name (FQDN), such as www.example.com, that is
	// secured by the certificate.
	DomainName *string `type:"string"`

	// Contains information about the initial validation of each domain name that
	// occurs as a result of the RequestCertificate request.
	//
	// Only provided if the certificate type is AMAZON_ISSUED.
	DomainValidationOptions []*AwsCertificateManagerCertificateDomainValidationOption `type:"list"`

	// Contains a list of Extended Key Usage X.509 v3 extension objects. Each object
	// specifies a purpose for which the certificate public key can be used and
	// consists of a name and an object identifier (OID).
	ExtendedKeyUsages []*AwsCertificateManagerCertificateExtendedKeyUsage `type:"list"`

	// For a failed certificate request, the reason for the failure.
	//
	// Valid values: NO_AVAILABLE_CONTACTS | ADDITIONAL_VERIFICATION_REQUIRED |
	// DOMAIN_NOT_ALLOWED | INVALID_PUBLIC_DOMAIN | DOMAIN_VALIDATION_DENIED | CAA_ERROR
	// | PCA_LIMIT_EXCEEDED | PCA_INVALID_ARN | PCA_INVALID_STATE | PCA_REQUEST_FAILED
	// | PCA_NAME_CONSTRAINTS_VALIDATION | PCA_RESOURCE_NOT_FOUND | PCA_INVALID_ARGS
	// | PCA_INVALID_DURATION | PCA_ACCESS_DENIED | SLR_NOT_FOUND | OTHER
	FailureReason *string `type:"string"`

	// Indicates when the certificate was imported. Provided if the certificate
	// type is IMPORTED.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	ImportedAt *string `type:"string"`

	// The list of ARNs for the Amazon Web Services resources that use the certificate.
	InUseBy []*string `type:"list"`

	// Indicates when the certificate was issued. Provided if the certificate type
	// is AMAZON_ISSUED.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	IssuedAt *string `type:"string"`

	// The name of the certificate authority that issued and signed the certificate.
	Issuer *string `type:"string"`

	// The algorithm that was used to generate the public-private key pair.
	//
	// Valid values: RSA_2048 | RSA_1024 |RSA_4096 | EC_prime256v1 | EC_secp384r1
	// | EC_secp521r1
	KeyAlgorithm *string `type:"string"`

	// A list of key usage X.509 v3 extension objects.
	KeyUsages []*AwsCertificateManagerCertificateKeyUsage `type:"list"`

	// The time after which the certificate becomes invalid.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	NotAfter *string `type:"string"`

	// The time before which the certificate is not valid.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	NotBefore *string `type:"string"`

	// Provides a value that specifies whether to add the certificate to a transparency
	// log.
	Options *AwsCertificateManagerCertificateOptions `type:"structure"`

	// Whether the certificate is eligible for renewal.
	//
	// Valid values: ELIGIBLE | INELIGIBLE
	RenewalEligibility *string `type:"string"`

	// Information about the status of the Certificate Manager managed renewal for
	// the certificate. Provided only when the certificate type is AMAZON_ISSUED.
	RenewalSummary *AwsCertificateManagerCertificateRenewalSummary `type:"structure"`

	// The serial number of the certificate.
	Serial *string `type:"string"`

	// The algorithm that was used to sign the certificate.
	SignatureAlgorithm *string `type:"string"`

	// The status of the certificate.
	//
	// Valid values: PENDING_VALIDATION | ISSUED | INACTIVE | EXPIRED | VALIDATION_TIMED_OUT
	// | REVOKED | FAILED
	Status *string `type:"string"`

	// The name of the entity that is associated with the public key contained in
	// the certificate.
	Subject *string `type:"string"`

	// One or more domain names (subject alternative names) included in the certificate.
	// This list contains the domain names that are bound to the public key that
	// is contained in the certificate.
	//
	// The subject alternative names include the canonical domain name (CN) of the
	// certificate and additional domain names that can be used to connect to the
	// website.
	SubjectAlternativeNames []*string `type:"list"`

	// The source of the certificate. For certificates that Certificate Manager
	// provides, Type is AMAZON_ISSUED. For certificates that are imported with
	// ImportCertificate, Type is IMPORTED.
	//
	// Valid values: IMPORTED | AMAZON_ISSUED | PRIVATE
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateDetails) GoString() string {
	return s.String()
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *AwsCertificateManagerCertificateDetails) SetCertificateAuthorityArn(v string) *AwsCertificateManagerCertificateDetails {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsCertificateManagerCertificateDetails) SetCreatedAt(v string) *AwsCertificateManagerCertificateDetails {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCertificateManagerCertificateDetails) SetDomainName(v string) *AwsCertificateManagerCertificateDetails {
	s.DomainName = &v
	return s
}

// SetDomainValidationOptions sets the DomainValidationOptions field's value.
func (s *AwsCertificateManagerCertificateDetails) SetDomainValidationOptions(v []*AwsCertificateManagerCertificateDomainValidationOption) *AwsCertificateManagerCertificateDetails {
	s.DomainValidationOptions = v
	return s
}

// SetExtendedKeyUsages sets the ExtendedKeyUsages field's value.
func (s *AwsCertificateManagerCertificateDetails) SetExtendedKeyUsages(v []*AwsCertificateManagerCertificateExtendedKeyUsage) *AwsCertificateManagerCertificateDetails {
	s.ExtendedKeyUsages = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *AwsCertificateManagerCertificateDetails) SetFailureReason(v string) *AwsCertificateManagerCertificateDetails {
	s.FailureReason = &v
	return s
}

// SetImportedAt sets the ImportedAt field's value.
func (s *AwsCertificateManagerCertificateDetails) SetImportedAt(v string) *AwsCertificateManagerCertificateDetails {
	s.ImportedAt = &v
	return s
}

// SetInUseBy sets the InUseBy field's value.
func (s *AwsCertificateManagerCertificateDetails) SetInUseBy(v []*string) *AwsCertificateManagerCertificateDetails {
	s.InUseBy = v
	return s
}

// SetIssuedAt sets the IssuedAt field's value.
func (s *AwsCertificateManagerCertificateDetails) SetIssuedAt(v string) *AwsCertificateManagerCertificateDetails {
	s.IssuedAt = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *AwsCertificateManagerCertificateDetails) SetIssuer(v string) *AwsCertificateManagerCertificateDetails {
	s.Issuer = &v
	return s
}

// SetKeyAlgorithm sets the KeyAlgorithm field's value.
func (s *AwsCertificateManagerCertificateDetails) SetKeyAlgorithm(v string) *AwsCertificateManagerCertificateDetails {
	s.KeyAlgorithm = &v
	return s
}

// SetKeyUsages sets the KeyUsages field's value.
func (s *AwsCertificateManagerCertificateDetails) SetKeyUsages(v []*AwsCertificateManagerCertificateKeyUsage) *AwsCertificateManagerCertificateDetails {
	s.KeyUsages = v
	return s
}

// SetNotAfter sets the NotAfter field's value.
func (s *AwsCertificateManagerCertificateDetails) SetNotAfter(v string) *AwsCertificateManagerCertificateDetails {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *AwsCertificateManagerCertificateDetails) SetNotBefore(v string) *AwsCertificateManagerCertificateDetails {
	s.NotBefore = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *AwsCertificateManagerCertificateDetails) SetOptions(v *AwsCertificateManagerCertificateOptions) *AwsCertificateManagerCertificateDetails {
	s.Options = v
	return s
}

// SetRenewalEligibility sets the RenewalEligibility field's value.
func (s *AwsCertificateManagerCertificateDetails) SetRenewalEligibility(v string) *AwsCertificateManagerCertificateDetails {
	s.RenewalEligibility = &v
	return s
}

// SetRenewalSummary sets the RenewalSummary field's value.
func (s *AwsCertificateManagerCertificateDetails) SetRenewalSummary(v *AwsCertificateManagerCertificateRenewalSummary) *AwsCertificateManagerCertificateDetails {
	s.RenewalSummary = v
	return s
}

// SetSerial sets the Serial field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSerial(v string) *AwsCertificateManagerCertificateDetails {
	s.Serial = &v
	return s
}

// SetSignatureAlgorithm sets the SignatureAlgorithm field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSignatureAlgorithm(v string) *AwsCertificateManagerCertificateDetails {
	s.SignatureAlgorithm = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCertificateManagerCertificateDetails) SetStatus(v string) *AwsCertificateManagerCertificateDetails {
	s.Status = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSubject(v string) *AwsCertificateManagerCertificateDetails {
	s.Subject = &v
	return s
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSubjectAlternativeNames(v []*string) *AwsCertificateManagerCertificateDetails {
	s.SubjectAlternativeNames = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCertificateManagerCertificateDetails) SetType(v string) *AwsCertificateManagerCertificateDetails {
	s.Type = &v
	return s
}

// Contains information about one of the following:
//
//   - The initial validation of each domain name that occurs as a result of
//     the RequestCertificate request
//
//   - The validation of each domain name in the certificate, as it pertains
//     to Certificate Manager managed renewal
type AwsCertificateManagerCertificateDomainValidationOption struct {
	_ struct{} `type:"structure"`

	// A fully qualified domain name (FQDN) in the certificate.
	DomainName *string `type:"string"`

	// The CNAME record that is added to the DNS database for domain validation.
	ResourceRecord *AwsCertificateManagerCertificateResourceRecord `type:"structure"`

	// The domain name that Certificate Manager uses to send domain validation emails.
	ValidationDomain *string `type:"string"`

	// A list of email addresses that Certificate Manager uses to send domain validation
	// emails.
	ValidationEmails []*string `type:"list"`

	// The method used to validate the domain name.
	ValidationMethod *string `type:"string"`

	// The validation status of the domain name.
	ValidationStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateDomainValidationOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateDomainValidationOption) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetDomainName(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.DomainName = &v
	return s
}

// SetResourceRecord sets the ResourceRecord field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetResourceRecord(v *AwsCertificateManagerCertificateResourceRecord) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ResourceRecord = v
	return s
}

// SetValidationDomain sets the ValidationDomain field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationDomain(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationDomain = &v
	return s
}

// SetValidationEmails sets the ValidationEmails field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationEmails(v []*string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationEmails = v
	return s
}

// SetValidationMethod sets the ValidationMethod field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationMethod(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationMethod = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationStatus(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationStatus = &v
	return s
}

// Contains information about an extended key usage X.509 v3 extension object.
type AwsCertificateManagerCertificateExtendedKeyUsage struct {
	_ struct{} `type:"structure"`

	// The name of an extension value. Indicates the purpose for which the certificate
	// public key can be used.
	Name *string `type:"string"`

	// An object identifier (OID) for the extension value.
	//
	// The format is numbers separated by periods.
	OId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateExtendedKeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateExtendedKeyUsage) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCertificateManagerCertificateExtendedKeyUsage) SetName(v string) *AwsCertificateManagerCertificateExtendedKeyUsage {
	s.Name = &v
	return s
}

// SetOId sets the OId field's value.
func (s *AwsCertificateManagerCertificateExtendedKeyUsage) SetOId(v string) *AwsCertificateManagerCertificateExtendedKeyUsage {
	s.OId = &v
	return s
}

// Contains information about a key usage X.509 v3 extension object.
type AwsCertificateManagerCertificateKeyUsage struct {
	_ struct{} `type:"structure"`

	// The key usage extension name.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateKeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateKeyUsage) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCertificateManagerCertificateKeyUsage) SetName(v string) *AwsCertificateManagerCertificateKeyUsage {
	s.Name = &v
	return s
}

// Contains other options for the certificate.
type AwsCertificateManagerCertificateOptions struct {
	_ struct{} `type:"structure"`

	// Whether to add the certificate to a transparency log.
	//
	// Valid values: DISABLED | ENABLED
	CertificateTransparencyLoggingPreference *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateOptions) GoString() string {
	return s.String()
}

// SetCertificateTransparencyLoggingPreference sets the CertificateTransparencyLoggingPreference field's value.
func (s *AwsCertificateManagerCertificateOptions) SetCertificateTransparencyLoggingPreference(v string) *AwsCertificateManagerCertificateOptions {
	s.CertificateTransparencyLoggingPreference = &v
	return s
}

// Contains information about the Certificate Manager managed renewal for an
// AMAZON_ISSUED certificate.
type AwsCertificateManagerCertificateRenewalSummary struct {
	_ struct{} `type:"structure"`

	// Information about the validation of each domain name in the certificate,
	// as it pertains to Certificate Manager managed renewal. Provided only when
	// the certificate type is AMAZON_ISSUED.
	DomainValidationOptions []*AwsCertificateManagerCertificateDomainValidationOption `type:"list"`

	// The status of the Certificate Manager managed renewal of the certificate.
	//
	// Valid values: PENDING_AUTO_RENEWAL | PENDING_VALIDATION | SUCCESS | FAILED
	RenewalStatus *string `type:"string"`

	// The reason that a renewal request was unsuccessful. This attribute is used
	// only when RenewalStatus is FAILED.
	//
	// Valid values: NO_AVAILABLE_CONTACTS | ADDITIONAL_VERIFICATION_REQUIRED |
	// DOMAIN_NOT_ALLOWED | INVALID_PUBLIC_DOMAIN | DOMAIN_VALIDATION_DENIED | CAA_ERROR
	// | PCA_LIMIT_EXCEEDED | PCA_INVALID_ARN | PCA_INVALID_STATE | PCA_REQUEST_FAILED
	// | PCA_NAME_CONSTRAINTS_VALIDATION | PCA_RESOURCE_NOT_FOUND | PCA_INVALID_ARGS
	// | PCA_INVALID_DURATION | PCA_ACCESS_DENIED | SLR_NOT_FOUND | OTHER
	RenewalStatusReason *string `type:"string"`

	// Indicates when the renewal summary was last updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	UpdatedAt *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateRenewalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateRenewalSummary) GoString() string {
	return s.String()
}

// SetDomainValidationOptions sets the DomainValidationOptions field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetDomainValidationOptions(v []*AwsCertificateManagerCertificateDomainValidationOption) *AwsCertificateManagerCertificateRenewalSummary {
	s.DomainValidationOptions = v
	return s
}

// SetRenewalStatus sets the RenewalStatus field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetRenewalStatus(v string) *AwsCertificateManagerCertificateRenewalSummary {
	s.RenewalStatus = &v
	return s
}

// SetRenewalStatusReason sets the RenewalStatusReason field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetRenewalStatusReason(v string) *AwsCertificateManagerCertificateRenewalSummary {
	s.RenewalStatusReason = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetUpdatedAt(v string) *AwsCertificateManagerCertificateRenewalSummary {
	s.UpdatedAt = &v
	return s
}

// Provides details about the CNAME record that is added to the DNS database
// for domain validation.
type AwsCertificateManagerCertificateResourceRecord struct {
	_ struct{} `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`

	// The type of resource.
	Type *string `type:"string"`

	// The value of the resource.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateResourceRecord) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCertificateManagerCertificateResourceRecord) SetName(v string) *AwsCertificateManagerCertificateResourceRecord {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCertificateManagerCertificateResourceRecord) SetType(v string) *AwsCertificateManagerCertificateResourceRecord {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsCertificateManagerCertificateResourceRecord) SetValue(v string) *AwsCertificateManagerCertificateResourceRecord {
	s.Value = &v
	return s
}

// Nests a stack as a resource in a top-level template. Nested stacks are stacks
// created as resources for another stack.
type AwsCloudFormationStackDetails struct {
	_ struct{} `type:"structure"`

	// The capabilities allowed in the stack.
	Capabilities []*string `type:"list"`

	// The time at which the stack was created.
	CreationTime *string `type:"string"`

	// A user-defined description associated with the stack.
	Description *string `type:"string"`

	// Boolean to enable or disable rollback on stack creation failures.
	DisableRollback *bool `type:"boolean"`

	// Information about whether a stack's actual configuration differs, or has
	// drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters.
	DriftInformation *AwsCloudFormationStackDriftInformationDetails `type:"structure"`

	// Whether termination protection is enabled for the stack.
	EnableTerminationProtection *bool `type:"boolean"`

	// The time the nested stack was last updated. This field will only be returned
	// if the stack has been updated at least once.
	LastUpdatedTime *string `type:"string"`

	// The Amazon Resource Names (ARNs) of the Amazon SNS topic to which stack-related
	// events are published.
	NotificationArns []*string `type:"list"`

	// A list of output structures.
	Outputs []*AwsCloudFormationStackOutputsDetails `type:"list"`

	// The ARN of an IAM role that's associated with the stack.
	RoleArn *string `type:"string"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`

	// Current status of the stack.
	StackStatus *string `type:"string"`

	// Success or failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// The length of time, in minutes, that CloudFormation waits for the nested
	// stack to reach the CREATE_COMPLETE state.
	TimeoutInMinutes *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFormationStackDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFormationStackDetails) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *AwsCloudFormationStackDetails) SetCapabilities(v []*string) *AwsCloudFormationStackDetails {
	s.Capabilities = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AwsCloudFormationStackDetails) SetCreationTime(v string) *AwsCloudFormationStackDetails {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsCloudFormationStackDetails) SetDescription(v string) *AwsCloudFormationStackDetails {
	s.Description = &v
	return s
}

// SetDisableRollback sets the DisableRollback field's value.
func (s *AwsCloudFormationStackDetails) SetDisableRollback(v bool) *AwsCloudFormationStackDetails {
	s.DisableRollback = &v
	return s
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *AwsCloudFormationStackDetails) SetDriftInformation(v *AwsCloudFormationStackDriftInformationDetails) *AwsCloudFormationStackDetails {
	s.DriftInformation = v
	return s
}

// SetEnableTerminationProtection sets the EnableTerminationProtection field's value.
func (s *AwsCloudFormationStackDetails) SetEnableTerminationProtection(v bool) *AwsCloudFormationStackDetails {
	s.EnableTerminationProtection = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *AwsCloudFormationStackDetails) SetLastUpdatedTime(v string) *AwsCloudFormationStackDetails {
	s.LastUpdatedTime = &v
	return s
}

// SetNotificationArns sets the NotificationArns field's value.
func (s *AwsCloudFormationStackDetails) SetNotificationArns(v []*string) *AwsCloudFormationStackDetails {
	s.NotificationArns = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AwsCloudFormationStackDetails) SetOutputs(v []*AwsCloudFormationStackOutputsDetails) *AwsCloudFormationStackDetails {
	s.Outputs = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AwsCloudFormationStackDetails) SetRoleArn(v string) *AwsCloudFormationStackDetails {
	s.RoleArn = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *AwsCloudFormationStackDetails) SetStackId(v string) *AwsCloudFormationStackDetails {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *AwsCloudFormationStackDetails) SetStackName(v string) *AwsCloudFormationStackDetails {
	s.StackName = &v
	return s
}

// SetStackStatus sets the StackStatus field's value.
func (s *AwsCloudFormationStackDetails) SetStackStatus(v string) *AwsCloudFormationStackDetails {
	s.StackStatus = &v
	return s
}

// SetStackStatusReason sets the StackStatusReason field's value.
func (s *AwsCloudFormationStackDetails) SetStackStatusReason(v string) *AwsCloudFormationStackDetails {
	s.StackStatusReason = &v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *AwsCloudFormationStackDetails) SetTimeoutInMinutes(v int64) *AwsCloudFormationStackDetails {
	s.TimeoutInMinutes = &v
	return s
}

// Provides information about the stack's conformity to its expected template
// configuration.
type AwsCloudFormationStackDriftInformationDetails struct {
	_ struct{} `type:"structure"`

	// Status of the stack's actual configuration compared to its expected template
	// configuration.
	StackDriftStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFormationStackDriftInformationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFormationStackDriftInformationDetails) GoString() string {
	return s.String()
}

// SetStackDriftStatus sets the StackDriftStatus field's value.
func (s *AwsCloudFormationStackDriftInformationDetails) SetStackDriftStatus(v string) *AwsCloudFormationStackDriftInformationDetails {
	s.StackDriftStatus = &v
	return s
}

// Provides information about the CloudFormation stack output.
type AwsCloudFormationStackOutputsDetails struct {
	_ struct{} `type:"structure"`

	// A user-defined description associated with the output.
	Description *string `type:"string"`

	// The key associated with the output.
	OutputKey *string `type:"string"`

	// The value associated with the output.
	OutputValue *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFormationStackOutputsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFormationStackOutputsDetails) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *AwsCloudFormationStackOutputsDetails) SetDescription(v string) *AwsCloudFormationStackOutputsDetails {
	s.Description = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *AwsCloudFormationStackOutputsDetails) SetOutputKey(v string) *AwsCloudFormationStackOutputsDetails {
	s.OutputKey = &v
	return s
}

// SetOutputValue sets the OutputValue field's value.
func (s *AwsCloudFormationStackOutputsDetails) SetOutputValue(v string) *AwsCloudFormationStackOutputsDetails {
	s.OutputValue = &v
	return s
}

// Information about a cache behavior for the distribution.
type AwsCloudFrontDistributionCacheBehavior struct {
	_ struct{} `type:"structure"`

	// The protocol that viewers can use to access the files in an origin. You can
	// specify the following options:
	//
	//    * allow-all - Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https - CloudFront responds to HTTP requests with an HTTP
	//    status code of 301 (Moved Permanently) and the HTTPS URL. The viewer then
	//    uses the new URL to resubmit.
	//
	//    * https-only - CloudFront responds to HTTP request with an HTTP status
	//    code of 403 (Forbidden).
	ViewerProtocolPolicy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionCacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionCacheBehavior) GoString() string {
	return s.String()
}

// SetViewerProtocolPolicy sets the ViewerProtocolPolicy field's value.
func (s *AwsCloudFrontDistributionCacheBehavior) SetViewerProtocolPolicy(v string) *AwsCloudFrontDistributionCacheBehavior {
	s.ViewerProtocolPolicy = &v
	return s
}

// Provides information about caching for the CloudFront distribution.
type AwsCloudFrontDistributionCacheBehaviors struct {
	_ struct{} `type:"structure"`

	// The cache behaviors for the distribution.
	Items []*AwsCloudFrontDistributionCacheBehavior `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionCacheBehaviors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionCacheBehaviors) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionCacheBehaviors) SetItems(v []*AwsCloudFrontDistributionCacheBehavior) *AwsCloudFrontDistributionCacheBehaviors {
	s.Items = v
	return s
}

// Contains information about the default cache configuration for the CloudFront
// distribution.
type AwsCloudFrontDistributionDefaultCacheBehavior struct {
	_ struct{} `type:"structure"`

	// The protocol that viewers can use to access the files in an origin. You can
	// specify the following options:
	//
	//    * allow-all - Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https - CloudFront responds to HTTP requests with an HTTP
	//    status code of 301 (Moved Permanently) and the HTTPS URL. The viewer then
	//    uses the new URL to resubmit.
	//
	//    * https-only - CloudFront responds to HTTP request with an HTTP status
	//    code of 403 (Forbidden).
	ViewerProtocolPolicy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionDefaultCacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionDefaultCacheBehavior) GoString() string {
	return s.String()
}

// SetViewerProtocolPolicy sets the ViewerProtocolPolicy field's value.
func (s *AwsCloudFrontDistributionDefaultCacheBehavior) SetViewerProtocolPolicy(v string) *AwsCloudFrontDistributionDefaultCacheBehavior {
	s.ViewerProtocolPolicy = &v
	return s
}

// A CloudFront distribution configuration.
type AwsCloudFrontDistributionDetails struct {
	_ struct{} `type:"structure"`

	// Provides information about the cache configuration for the distribution.
	CacheBehaviors *AwsCloudFrontDistributionCacheBehaviors `type:"structure"`

	// The default cache behavior for the configuration.
	DefaultCacheBehavior *AwsCloudFrontDistributionDefaultCacheBehavior `type:"structure"`

	// The object that CloudFront sends in response to requests from the origin
	// (for example, index.html) when a viewer requests the root URL for the distribution
	// (http://www.example.com) instead of an object in your distribution (http://www.example.com/product-description.html).
	DefaultRootObject *string `type:"string"`

	// The domain name corresponding to the distribution.
	DomainName *string `type:"string"`

	// The entity tag is a hash of the object.
	ETag *string `type:"string"`

	// Indicates when that the distribution was last modified.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	LastModifiedTime *string `type:"string"`

	// A complex type that controls whether access logs are written for the distribution.
	Logging *AwsCloudFrontDistributionLogging `type:"structure"`

	// Provides information about the origin groups in the distribution.
	OriginGroups *AwsCloudFrontDistributionOriginGroups `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	Origins *AwsCloudFrontDistributionOrigins `type:"structure"`

	// Indicates the current status of the distribution.
	Status *string `type:"string"`

	// Provides information about the TLS/SSL configuration that the distribution
	// uses to communicate with viewers.
	ViewerCertificate *AwsCloudFrontDistributionViewerCertificate `type:"structure"`

	// A unique identifier that specifies the WAF web ACL, if any, to associate
	// with this distribution.
	WebAclId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionDetails) GoString() string {
	return s.String()
}

// SetCacheBehaviors sets the CacheBehaviors field's value.
func (s *AwsCloudFrontDistributionDetails) SetCacheBehaviors(v *AwsCloudFrontDistributionCacheBehaviors) *AwsCloudFrontDistributionDetails {
	s.CacheBehaviors = v
	return s
}

// SetDefaultCacheBehavior sets the DefaultCacheBehavior field's value.
func (s *AwsCloudFrontDistributionDetails) SetDefaultCacheBehavior(v *AwsCloudFrontDistributionDefaultCacheBehavior) *AwsCloudFrontDistributionDetails {
	s.DefaultCacheBehavior = v
	return s
}

// SetDefaultRootObject sets the DefaultRootObject field's value.
func (s *AwsCloudFrontDistributionDetails) SetDefaultRootObject(v string) *AwsCloudFrontDistributionDetails {
	s.DefaultRootObject = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCloudFrontDistributionDetails) SetDomainName(v string) *AwsCloudFrontDistributionDetails {
	s.DomainName = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *AwsCloudFrontDistributionDetails) SetETag(v string) *AwsCloudFrontDistributionDetails {
	s.ETag = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *AwsCloudFrontDistributionDetails) SetLastModifiedTime(v string) *AwsCloudFrontDistributionDetails {
	s.LastModifiedTime = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *AwsCloudFrontDistributionDetails) SetLogging(v *AwsCloudFrontDistributionLogging) *AwsCloudFrontDistributionDetails {
	s.Logging = v
	return s
}

// SetOriginGroups sets the OriginGroups field's value.
func (s *AwsCloudFrontDistributionDetails) SetOriginGroups(v *AwsCloudFrontDistributionOriginGroups) *AwsCloudFrontDistributionDetails {
	s.OriginGroups = v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *AwsCloudFrontDistributionDetails) SetOrigins(v *AwsCloudFrontDistributionOrigins) *AwsCloudFrontDistributionDetails {
	s.Origins = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCloudFrontDistributionDetails) SetStatus(v string) *AwsCloudFrontDistributionDetails {
	s.Status = &v
	return s
}

// SetViewerCertificate sets the ViewerCertificate field's value.
func (s *AwsCloudFrontDistributionDetails) SetViewerCertificate(v *AwsCloudFrontDistributionViewerCertificate) *AwsCloudFrontDistributionDetails {
	s.ViewerCertificate = v
	return s
}

// SetWebAclId sets the WebAclId field's value.
func (s *AwsCloudFrontDistributionDetails) SetWebAclId(v string) *AwsCloudFrontDistributionDetails {
	s.WebAclId = &v
	return s
}

// A complex type that controls whether access logs are written for the CloudFront
// distribution.
type AwsCloudFrontDistributionLogging struct {
	_ struct{} `type:"structure"`

	// The S3 bucket to store the access logs in.
	Bucket *string `type:"string"`

	// With this field, you can enable or disable the selected distribution.
	Enabled *bool `type:"boolean"`

	// Specifies whether you want CloudFront to include cookies in access logs.
	IncludeCookies *bool `type:"boolean"`

	// An optional string that you want CloudFront to use as a prefix to the access
	// log filenames for this distribution.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionLogging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionLogging) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *AwsCloudFrontDistributionLogging) SetBucket(v string) *AwsCloudFrontDistributionLogging {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AwsCloudFrontDistributionLogging) SetEnabled(v bool) *AwsCloudFrontDistributionLogging {
	s.Enabled = &v
	return s
}

// SetIncludeCookies sets the IncludeCookies field's value.
func (s *AwsCloudFrontDistributionLogging) SetIncludeCookies(v bool) *AwsCloudFrontDistributionLogging {
	s.IncludeCookies = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *AwsCloudFrontDistributionLogging) SetPrefix(v string) *AwsCloudFrontDistributionLogging {
	s.Prefix = &v
	return s
}

// A custom origin. A custom origin is any origin that is not an Amazon S3 bucket,
// with one exception. An Amazon S3 bucket that is configured with static website
// hosting (https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)
// is a custom origin.
type AwsCloudFrontDistributionOriginCustomOriginConfig struct {
	_ struct{} `type:"structure"`

	// The HTTP port that CloudFront uses to connect to the origin.
	HttpPort *int64 `type:"integer"`

	// The HTTPS port that CloudFront uses to connect to the origin.
	HttpsPort *int64 `type:"integer"`

	// Specifies how long, in seconds, CloudFront persists its connection to the
	// origin.
	OriginKeepaliveTimeout *int64 `type:"integer"`

	// Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to
	// the origin.
	OriginProtocolPolicy *string `type:"string"`

	// Specifies how long, in seconds, CloudFront waits for a response from the
	// origin.
	OriginReadTimeout *int64 `type:"integer"`

	// Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting
	// to your origin over HTTPS.
	OriginSslProtocols *AwsCloudFrontDistributionOriginSslProtocols `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginCustomOriginConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginCustomOriginConfig) GoString() string {
	return s.String()
}

// SetHttpPort sets the HttpPort field's value.
func (s *AwsCloudFrontDistributionOriginCustomOriginConfig) SetHttpPort(v int64) *AwsCloudFrontDistributionOriginCustomOriginConfig {
	s.HttpPort = &v
	return s
}

// SetHttpsPort sets the HttpsPort field's value.
func (s *AwsCloudFrontDistributionOriginCustomOriginConfig) SetHttpsPort(v int64) *AwsCloudFrontDistributionOriginCustomOriginConfig {
	s.HttpsPort = &v
	return s
}

// SetOriginKeepaliveTimeout sets the OriginKeepaliveTimeout field's value.
func (s *AwsCloudFrontDistributionOriginCustomOriginConfig) SetOriginKeepaliveTimeout(v int64) *AwsCloudFrontDistributionOriginCustomOriginConfig {
	s.OriginKeepaliveTimeout = &v
	return s
}

// SetOriginProtocolPolicy sets the OriginProtocolPolicy field's value.
func (s *AwsCloudFrontDistributionOriginCustomOriginConfig) SetOriginProtocolPolicy(v string) *AwsCloudFrontDistributionOriginCustomOriginConfig {
	s.OriginProtocolPolicy = &v
	return s
}

// SetOriginReadTimeout sets the OriginReadTimeout field's value.
func (s *AwsCloudFrontDistributionOriginCustomOriginConfig) SetOriginReadTimeout(v int64) *AwsCloudFrontDistributionOriginCustomOriginConfig {
	s.OriginReadTimeout = &v
	return s
}

// SetOriginSslProtocols sets the OriginSslProtocols field's value.
func (s *AwsCloudFrontDistributionOriginCustomOriginConfig) SetOriginSslProtocols(v *AwsCloudFrontDistributionOriginSslProtocols) *AwsCloudFrontDistributionOriginCustomOriginConfig {
	s.OriginSslProtocols = v
	return s
}

// Information about an origin group for the CloudFront distribution.
type AwsCloudFrontDistributionOriginGroup struct {
	_ struct{} `type:"structure"`

	// Provides the criteria for an origin group to fail over.
	FailoverCriteria *AwsCloudFrontDistributionOriginGroupFailover `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroup) GoString() string {
	return s.String()
}

// SetFailoverCriteria sets the FailoverCriteria field's value.
func (s *AwsCloudFrontDistributionOriginGroup) SetFailoverCriteria(v *AwsCloudFrontDistributionOriginGroupFailover) *AwsCloudFrontDistributionOriginGroup {
	s.FailoverCriteria = v
	return s
}

// Provides information about when an origin group fails over.
type AwsCloudFrontDistributionOriginGroupFailover struct {
	_ struct{} `type:"structure"`

	// Information about the status codes that cause an origin group to fail over.
	StatusCodes *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroupFailover) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroupFailover) GoString() string {
	return s.String()
}

// SetStatusCodes sets the StatusCodes field's value.
func (s *AwsCloudFrontDistributionOriginGroupFailover) SetStatusCodes(v *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) *AwsCloudFrontDistributionOriginGroupFailover {
	s.StatusCodes = v
	return s
}

// The status codes that cause an origin group to fail over.
type AwsCloudFrontDistributionOriginGroupFailoverStatusCodes struct {
	_ struct{} `type:"structure"`

	// The list of status code values that can cause a failover to the next origin.
	Items []*int64 `type:"list"`

	// The number of status codes that can cause a failover.
	Quantity *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) SetItems(v []*int64) *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) SetQuantity(v int64) *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes {
	s.Quantity = &v
	return s
}

// Provides information about origin groups that are associated with the CloudFront
// distribution.
type AwsCloudFrontDistributionOriginGroups struct {
	_ struct{} `type:"structure"`

	// The list of origin groups.
	Items []*AwsCloudFrontDistributionOriginGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroups) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroups) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOriginGroups) SetItems(v []*AwsCloudFrontDistributionOriginGroup) *AwsCloudFrontDistributionOriginGroups {
	s.Items = v
	return s
}

// A complex type that describes the Amazon S3 bucket, HTTP server (for example,
// a web server), AWS Elemental MediaStore, or other server from which CloudFront
// gets your files.
type AwsCloudFrontDistributionOriginItem struct {
	_ struct{} `type:"structure"`

	// An origin that is not an Amazon S3 bucket, with one exception. If the Amazon
	// S3 bucket is configured with static website hosting, use this attribute.
	// If the Amazon S3 bucket is not configured with static website hosting, use
	// the S3OriginConfig type instead.
	CustomOriginConfig *AwsCloudFrontDistributionOriginCustomOriginConfig `type:"structure"`

	// Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront
	// to get objects for this origin.
	DomainName *string `type:"string"`

	// A unique identifier for the origin or origin group.
	Id *string `type:"string"`

	// An optional element that causes CloudFront to request your content from a
	// directory in your Amazon S3 bucket or your custom origin.
	OriginPath *string `type:"string"`

	// An origin that is an S3 bucket that is not configured with static website
	// hosting.
	S3OriginConfig *AwsCloudFrontDistributionOriginS3OriginConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginItem) GoString() string {
	return s.String()
}

// SetCustomOriginConfig sets the CustomOriginConfig field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetCustomOriginConfig(v *AwsCloudFrontDistributionOriginCustomOriginConfig) *AwsCloudFrontDistributionOriginItem {
	s.CustomOriginConfig = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetDomainName(v string) *AwsCloudFrontDistributionOriginItem {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetId(v string) *AwsCloudFrontDistributionOriginItem {
	s.Id = &v
	return s
}

// SetOriginPath sets the OriginPath field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetOriginPath(v string) *AwsCloudFrontDistributionOriginItem {
	s.OriginPath = &v
	return s
}

// SetS3OriginConfig sets the S3OriginConfig field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetS3OriginConfig(v *AwsCloudFrontDistributionOriginS3OriginConfig) *AwsCloudFrontDistributionOriginItem {
	s.S3OriginConfig = v
	return s
}

// Information about an origin that is an Amazon S3 bucket that is not configured
// with static website hosting.
type AwsCloudFrontDistributionOriginS3OriginConfig struct {
	_ struct{} `type:"structure"`

	// The CloudFront origin access identity to associate with the origin.
	OriginAccessIdentity *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginS3OriginConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginS3OriginConfig) GoString() string {
	return s.String()
}

// SetOriginAccessIdentity sets the OriginAccessIdentity field's value.
func (s *AwsCloudFrontDistributionOriginS3OriginConfig) SetOriginAccessIdentity(v string) *AwsCloudFrontDistributionOriginS3OriginConfig {
	s.OriginAccessIdentity = &v
	return s
}

// A complex type that contains information about the SSL/TLS protocols that
// CloudFront can use when establishing an HTTPS connection with your origin.
type AwsCloudFrontDistributionOriginSslProtocols struct {
	_ struct{} `type:"structure"`

	// A list that contains allowed SSL/TLS protocols for this distribution.
	Items []*string `type:"list"`

	// The number of SSL/TLS protocols that you want to allow CloudFront to use
	// when establishing an HTTPS connection with this origin.
	Quantity *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginSslProtocols) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginSslProtocols) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOriginSslProtocols) SetItems(v []*string) *AwsCloudFrontDistributionOriginSslProtocols {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *AwsCloudFrontDistributionOriginSslProtocols) SetQuantity(v int64) *AwsCloudFrontDistributionOriginSslProtocols {
	s.Quantity = &v
	return s
}

// A complex type that contains information about origins and origin groups
// for this CloudFront distribution.
type AwsCloudFrontDistributionOrigins struct {
	_ struct{} `type:"structure"`

	// A complex type that contains origins or origin groups for this distribution.
	Items []*AwsCloudFrontDistributionOriginItem `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOrigins) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOrigins) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOrigins) SetItems(v []*AwsCloudFrontDistributionOriginItem) *AwsCloudFrontDistributionOrigins {
	s.Items = v
	return s
}

// Provides information about the TLS/SSL configuration that the CloudFront
// distribution uses to communicate with viewers.
type AwsCloudFrontDistributionViewerCertificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the ACM certificate. Used if the certificate is stored in ACM.
	// If you provide an ACM certificate ARN, you must also provide MinimumCertificateVersion
	// and SslSupportMethod.
	AcmCertificateArn *string `type:"string"`

	// The identifier of the certificate. Note that in CloudFront, this attribute
	// is deprecated.
	Certificate *string `type:"string"`

	// The source of the certificate identified by Certificate. Note that in CloudFront,
	// this attribute is deprecated.
	CertificateSource *string `type:"string"`

	// Whether the distribution uses the CloudFront domain name. If set to false,
	// then you provide either AcmCertificateArn or IamCertificateId.
	CloudFrontDefaultCertificate *bool `type:"boolean"`

	// The identifier of the IAM certificate. Used if the certificate is stored
	// in IAM. If you provide IamCertificateId, then you also must provide MinimumProtocolVersion
	// and SslSupportMethod.
	IamCertificateId *string `type:"string"`

	// The security policy that CloudFront uses for HTTPS connections with viewers.
	// If SslSupportMethod is sni-only, then MinimumProtocolVersion must be TLSv1
	// or higher.
	MinimumProtocolVersion *string `type:"string"`

	// The viewers that the distribution accepts HTTPS connections from.
	SslSupportMethod *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionViewerCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionViewerCertificate) GoString() string {
	return s.String()
}

// SetAcmCertificateArn sets the AcmCertificateArn field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetAcmCertificateArn(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.AcmCertificateArn = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetCertificate(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.Certificate = &v
	return s
}

// SetCertificateSource sets the CertificateSource field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetCertificateSource(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.CertificateSource = &v
	return s
}

// SetCloudFrontDefaultCertificate sets the CloudFrontDefaultCertificate field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetCloudFrontDefaultCertificate(v bool) *AwsCloudFrontDistributionViewerCertificate {
	s.CloudFrontDefaultCertificate = &v
	return s
}

// SetIamCertificateId sets the IamCertificateId field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetIamCertificateId(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.IamCertificateId = &v
	return s
}

// SetMinimumProtocolVersion sets the MinimumProtocolVersion field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetMinimumProtocolVersion(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.MinimumProtocolVersion = &v
	return s
}

// SetSslSupportMethod sets the SslSupportMethod field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetSslSupportMethod(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.SslSupportMethod = &v
	return s
}

// Provides details about a CloudTrail trail.
type AwsCloudTrailTrailDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the log group that CloudTrail logs are delivered to.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// The ARN of the role that the CloudWatch Events endpoint assumes when it writes
	// to the log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Indicates whether the trail has custom event selectors.
	HasCustomEventSelectors *bool `type:"boolean"`

	// The Region where the trail was created.
	HomeRegion *string `type:"string"`

	// Indicates whether the trail publishes events from global services such as
	// IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Indicates whether the trail applies only to the current Region or to all
	// Regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Whether the trail is created for all accounts in an organization in Organizations,
	// or only for the current Amazon Web Services account.
	IsOrganizationTrail *bool `type:"boolean"`

	// The KMS key ID to use to encrypt the logs.
	KmsKeyId *string `type:"string"`

	// Indicates whether CloudTrail log file validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// The name of the trail.
	Name *string `type:"string"`

	// The name of the S3 bucket where the log files are published.
	S3BucketName *string `type:"string"`

	// The S3 key prefix. The key prefix is added after the name of the S3 bucket
	// where the log files are published.
	S3KeyPrefix *string `type:"string"`

	// The ARN of the SNS topic that is used for notifications of log file delivery.
	SnsTopicArn *string `type:"string"`

	// The name of the SNS topic that is used for notifications of log file delivery.
	SnsTopicName *string `type:"string"`

	// The ARN of the trail.
	TrailArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudTrailTrailDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudTrailTrailDetails) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *AwsCloudTrailTrailDetails) SetCloudWatchLogsLogGroupArn(v string) *AwsCloudTrailTrailDetails {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *AwsCloudTrailTrailDetails) SetCloudWatchLogsRoleArn(v string) *AwsCloudTrailTrailDetails {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetHasCustomEventSelectors sets the HasCustomEventSelectors field's value.
func (s *AwsCloudTrailTrailDetails) SetHasCustomEventSelectors(v bool) *AwsCloudTrailTrailDetails {
	s.HasCustomEventSelectors = &v
	return s
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *AwsCloudTrailTrailDetails) SetHomeRegion(v string) *AwsCloudTrailTrailDetails {
	s.HomeRegion = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *AwsCloudTrailTrailDetails) SetIncludeGlobalServiceEvents(v bool) *AwsCloudTrailTrailDetails {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *AwsCloudTrailTrailDetails) SetIsMultiRegionTrail(v bool) *AwsCloudTrailTrailDetails {
	s.IsMultiRegionTrail = &v
	return s
}

// SetIsOrganizationTrail sets the IsOrganizationTrail field's value.
func (s *AwsCloudTrailTrailDetails) SetIsOrganizationTrail(v bool) *AwsCloudTrailTrailDetails {
	s.IsOrganizationTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsCloudTrailTrailDetails) SetKmsKeyId(v string) *AwsCloudTrailTrailDetails {
	s.KmsKeyId = &v
	return s
}

// SetLogFileValidationEnabled sets the LogFileValidationEnabled field's value.
func (s *AwsCloudTrailTrailDetails) SetLogFileValidationEnabled(v bool) *AwsCloudTrailTrailDetails {
	s.LogFileValidationEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsCloudTrailTrailDetails) SetName(v string) *AwsCloudTrailTrailDetails {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *AwsCloudTrailTrailDetails) SetS3BucketName(v string) *AwsCloudTrailTrailDetails {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *AwsCloudTrailTrailDetails) SetS3KeyPrefix(v string) *AwsCloudTrailTrailDetails {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *AwsCloudTrailTrailDetails) SetSnsTopicArn(v string) *AwsCloudTrailTrailDetails {
	s.SnsTopicArn = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *AwsCloudTrailTrailDetails) SetSnsTopicName(v string) *AwsCloudTrailTrailDetails {
	s.SnsTopicName = &v
	return s
}

// SetTrailArn sets the TrailArn field's value.
func (s *AwsCloudTrailTrailDetails) SetTrailArn(v string) *AwsCloudTrailTrailDetails {
	s.TrailArn = &v
	return s
}

// Specifies an alarm and associates it with the specified metric or metric
// math expression.
type AwsCloudWatchAlarmDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state.
	ActionsEnabled *bool `type:"boolean"`

	// The list of actions, specified as Amazon Resource Names (ARNs) to execute
	// when this alarm transitions into an ALARM state from any other state.
	AlarmActions []*string `type:"list"`

	// The ARN of the alarm.
	AlarmArn *string `type:"string"`

	// The time stamp of the last update to the alarm configuration.
	AlarmConfigurationUpdatedTimestamp *string `type:"string"`

	// The description of the alarm.
	AlarmDescription *string `type:"string"`

	// The name of the alarm. If you don't specify a name, CloudFront generates
	// a unique physical ID and uses that ID for the alarm name.
	AlarmName *string `type:"string"`

	// The arithmetic operation to use when comparing the specified statistic and
	// threshold. The specified statistic value is used as the first operand.
	ComparisonOperator *string `type:"string"`

	// The number of datapoints that must be breaching to trigger the alarm.
	DatapointsToAlarm *int64 `type:"integer"`

	// The dimensions for the metric associated with the alarm.
	Dimensions []*AwsCloudWatchAlarmDimensionsDetails `type:"list"`

	// Used only for alarms based on percentiles. If ignore, the alarm state does
	// not change during periods with too few data points to be statistically significant.
	// If evaluate or this parameter is not used, the alarm is always evaluated
	// and possibly changes state no matter how many data points are available.
	EvaluateLowSampleCountPercentile *string `type:"string"`

	// The number of periods over which data is compared to the specified threshold.
	EvaluationPeriods *int64 `type:"integer"`

	// The percentile statistic for the metric associated with the alarm.
	ExtendedStatistic *string `type:"string"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an ARN.
	InsufficientDataActions []*string `type:"list"`

	// The name of the metric associated with the alarm. This is required for an
	// alarm based on a metric. For an alarm based on a math expression, you use
	// Metrics instead and you can't specify MetricName.
	MetricName *string `type:"string"`

	// The namespace of the metric associated with the alarm. This is required for
	// an alarm based on a metric. For an alarm based on a math expression, you
	// can't specify Namespace and you use Metrics instead.
	Namespace *string `type:"string"`

	// The actions to execute when this alarm transitions to the OK state from any
	// other state. Each action is specified as an ARN.
	OkActions []*string `type:"list"`

	// The period, in seconds, over which the statistic is applied. This is required
	// for an alarm based on a metric.
	Period *int64 `type:"integer"`

	// The statistic for the metric associated with the alarm, other than percentile.
	// For percentile statistics, use ExtendedStatistic.
	//
	// For an alarm based on a metric, you must specify either Statistic or ExtendedStatistic
	// but not both.
	//
	// For an alarm based on a math expression, you can't specify Statistic. Instead,
	// you use Metrics.
	Statistic *string `type:"string"`

	// The value to compare with the specified statistic.
	Threshold *float64 `type:"double"`

	// n an alarm based on an anomaly detection model, this is the ID of the ANOMALY_DETECTION_BAND
	// function used as the threshold for the alarm.
	ThresholdMetricId *string `type:"string"`

	// Sets how this alarm is to handle missing data points.
	TreatMissingData *string `type:"string"`

	// The unit of the metric associated with the alarm.
	Unit *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudWatchAlarmDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudWatchAlarmDetails) GoString() string {
	return s.String()
}

// SetActionsEnabled sets the ActionsEnabled field's value.
func (s *AwsCloudWatchAlarmDetails) SetActionsEnabled(v bool) *AwsCloudWatchAlarmDetails {
	s.ActionsEnabled = &v
	return s
}

// SetAlarmActions sets the AlarmActions field's value.
func (s *AwsCloudWatchAlarmDetails) SetAlarmActions(v []*string) *AwsCloudWatchAlarmDetails {
	s.AlarmActions = v
	return s
}

// SetAlarmArn sets the AlarmArn field's value.
func (s *AwsCloudWatchAlarmDetails) SetAlarmArn(v string) *AwsCloudWatchAlarmDetails {
	s.AlarmArn = &v
	return s
}

// SetAlarmConfigurationUpdatedTimestamp sets the AlarmConfigurationUpdatedTimestamp field's value.
func (s *AwsCloudWatchAlarmDetails) SetAlarmConfigurationUpdatedTimestamp(v string) *AwsCloudWatchAlarmDetails {
	s.AlarmConfigurationUpdatedTimestamp = &v
	return s
}

// SetAlarmDescription sets the AlarmDescription field's value.
func (s *AwsCloudWatchAlarmDetails) SetAlarmDescription(v string) *AwsCloudWatchAlarmDetails {
	s.AlarmDescription = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *AwsCloudWatchAlarmDetails) SetAlarmName(v string) *AwsCloudWatchAlarmDetails {
	s.AlarmName = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *AwsCloudWatchAlarmDetails) SetComparisonOperator(v string) *AwsCloudWatchAlarmDetails {
	s.ComparisonOperator = &v
	return s
}

// SetDatapointsToAlarm sets the DatapointsToAlarm field's value.
func (s *AwsCloudWatchAlarmDetails) SetDatapointsToAlarm(v int64) *AwsCloudWatchAlarmDetails {
	s.DatapointsToAlarm = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *AwsCloudWatchAlarmDetails) SetDimensions(v []*AwsCloudWatchAlarmDimensionsDetails) *AwsCloudWatchAlarmDetails {
	s.Dimensions = v
	return s
}

// SetEvaluateLowSampleCountPercentile sets the EvaluateLowSampleCountPercentile field's value.
func (s *AwsCloudWatchAlarmDetails) SetEvaluateLowSampleCountPercentile(v string) *AwsCloudWatchAlarmDetails {
	s.EvaluateLowSampleCountPercentile = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *AwsCloudWatchAlarmDetails) SetEvaluationPeriods(v int64) *AwsCloudWatchAlarmDetails {
	s.EvaluationPeriods = &v
	return s
}

// SetExtendedStatistic sets the ExtendedStatistic field's value.
func (s *AwsCloudWatchAlarmDetails) SetExtendedStatistic(v string) *AwsCloudWatchAlarmDetails {
	s.ExtendedStatistic = &v
	return s
}

// SetInsufficientDataActions sets the InsufficientDataActions field's value.
func (s *AwsCloudWatchAlarmDetails) SetInsufficientDataActions(v []*string) *AwsCloudWatchAlarmDetails {
	s.InsufficientDataActions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *AwsCloudWatchAlarmDetails) SetMetricName(v string) *AwsCloudWatchAlarmDetails {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *AwsCloudWatchAlarmDetails) SetNamespace(v string) *AwsCloudWatchAlarmDetails {
	s.Namespace = &v
	return s
}

// SetOkActions sets the OkActions field's value.
func (s *AwsCloudWatchAlarmDetails) SetOkActions(v []*string) *AwsCloudWatchAlarmDetails {
	s.OkActions = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *AwsCloudWatchAlarmDetails) SetPeriod(v int64) *AwsCloudWatchAlarmDetails {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *AwsCloudWatchAlarmDetails) SetStatistic(v string) *AwsCloudWatchAlarmDetails {
	s.Statistic = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *AwsCloudWatchAlarmDetails) SetThreshold(v float64) *AwsCloudWatchAlarmDetails {
	s.Threshold = &v
	return s
}

// SetThresholdMetricId sets the ThresholdMetricId field's value.
func (s *AwsCloudWatchAlarmDetails) SetThresholdMetricId(v string) *AwsCloudWatchAlarmDetails {
	s.ThresholdMetricId = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *AwsCloudWatchAlarmDetails) SetTreatMissingData(v string) *AwsCloudWatchAlarmDetails {
	s.TreatMissingData = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *AwsCloudWatchAlarmDetails) SetUnit(v string) *AwsCloudWatchAlarmDetails {
	s.Unit = &v
	return s
}

// Details about the dimensions for the metric associated with the alarm.
type AwsCloudWatchAlarmDimensionsDetails struct {
	_ struct{} `type:"structure"`

	// The name of a dimension.
	Name *string `type:"string"`

	// The value of a dimension.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudWatchAlarmDimensionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudWatchAlarmDimensionsDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCloudWatchAlarmDimensionsDetails) SetName(v string) *AwsCloudWatchAlarmDimensionsDetails {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsCloudWatchAlarmDimensionsDetails) SetValue(v string) *AwsCloudWatchAlarmDimensionsDetails {
	s.Value = &v
	return s
}

// Information about the build artifacts for the CodeBuild project.
type AwsCodeBuildProjectArtifactsDetails struct {
	_ struct{} `type:"structure"`

	// An identifier for the artifact definition.
	ArtifactIdentifier *string `type:"string"`

	// Indicates whether to disable encryption on the artifact. Only valid when
	// Type is S3.
	EncryptionDisabled *bool `type:"boolean"`

	// Only used when Type is S3. The name of the S3 bucket where the artifact is
	// located.
	Location *string `type:"string"`

	// Only used when Type is S3. The name of the artifact. Used with NamepaceType
	// and Path to determine the pattern for storing the artifact.
	Name *string `type:"string"`

	// Only used when Type is S3. The value to use for the namespace. Used with
	// Name and Path to determine the pattern for storing the artifact.
	NamespaceType *string `type:"string"`

	// Whether the name specified in the buildspec file overrides the artifact name.
	OverrideArtifactName *bool `type:"boolean"`

	// Only used when Type is S3. The type of output artifact to create.
	Packaging *string `type:"string"`

	// Only used when Type is S3. The path to the artifact. Used with Name and NamespaceType
	// to determine the pattern for storing the artifact.
	Path *string `type:"string"`

	// The type of build artifact.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectArtifactsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectArtifactsDetails) GoString() string {
	return s.String()
}

// SetArtifactIdentifier sets the ArtifactIdentifier field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetArtifactIdentifier(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.ArtifactIdentifier = &v
	return s
}

// SetEncryptionDisabled sets the EncryptionDisabled field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetEncryptionDisabled(v bool) *AwsCodeBuildProjectArtifactsDetails {
	s.EncryptionDisabled = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetLocation(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetName(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.Name = &v
	return s
}

// SetNamespaceType sets the NamespaceType field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetNamespaceType(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.NamespaceType = &v
	return s
}

// SetOverrideArtifactName sets the OverrideArtifactName field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetOverrideArtifactName(v bool) *AwsCodeBuildProjectArtifactsDetails {
	s.OverrideArtifactName = &v
	return s
}

// SetPackaging sets the Packaging field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetPackaging(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.Packaging = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetPath(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetType(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.Type = &v
	return s
}

// Information about an CodeBuild project.
type AwsCodeBuildProjectDetails struct {
	_ struct{} `type:"structure"`

	// Information about the build artifacts for the CodeBuild project.
	Artifacts []*AwsCodeBuildProjectArtifactsDetails `type:"list"`

	// The KMS key used to encrypt the build output artifacts.
	//
	// You can specify either the ARN of the KMS key or, if available, the KMS key
	// alias (using the format alias/alias-name).
	EncryptionKey *string `type:"string"`

	// Information about the build environment for this build project.
	Environment *AwsCodeBuildProjectEnvironment `type:"structure"`

	// Information about logs for the build project.
	LogsConfig *AwsCodeBuildProjectLogsConfigDetails `type:"structure"`

	// The name of the build project.
	Name *string `type:"string"`

	// Information about the secondary artifacts for the CodeBuild project.
	SecondaryArtifacts []*AwsCodeBuildProjectArtifactsDetails `type:"list"`

	// The ARN of the IAM role that enables CodeBuild to interact with dependent
	// Amazon Web Services services on behalf of the Amazon Web Services account.
	ServiceRole *string `type:"string"`

	// Information about the build input source code for this build project.
	Source *AwsCodeBuildProjectSource `type:"structure"`

	// Information about the VPC configuration that CodeBuild accesses.
	VpcConfig *AwsCodeBuildProjectVpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectDetails) GoString() string {
	return s.String()
}

// SetArtifacts sets the Artifacts field's value.
func (s *AwsCodeBuildProjectDetails) SetArtifacts(v []*AwsCodeBuildProjectArtifactsDetails) *AwsCodeBuildProjectDetails {
	s.Artifacts = v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *AwsCodeBuildProjectDetails) SetEncryptionKey(v string) *AwsCodeBuildProjectDetails {
	s.EncryptionKey = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *AwsCodeBuildProjectDetails) SetEnvironment(v *AwsCodeBuildProjectEnvironment) *AwsCodeBuildProjectDetails {
	s.Environment = v
	return s
}

// SetLogsConfig sets the LogsConfig field's value.
func (s *AwsCodeBuildProjectDetails) SetLogsConfig(v *AwsCodeBuildProjectLogsConfigDetails) *AwsCodeBuildProjectDetails {
	s.LogsConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsCodeBuildProjectDetails) SetName(v string) *AwsCodeBuildProjectDetails {
	s.Name = &v
	return s
}

// SetSecondaryArtifacts sets the SecondaryArtifacts field's value.
func (s *AwsCodeBuildProjectDetails) SetSecondaryArtifacts(v []*AwsCodeBuildProjectArtifactsDetails) *AwsCodeBuildProjectDetails {
	s.SecondaryArtifacts = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *AwsCodeBuildProjectDetails) SetServiceRole(v string) *AwsCodeBuildProjectDetails {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *AwsCodeBuildProjectDetails) SetSource(v *AwsCodeBuildProjectSource) *AwsCodeBuildProjectDetails {
	s.Source = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *AwsCodeBuildProjectDetails) SetVpcConfig(v *AwsCodeBuildProjectVpcConfig) *AwsCodeBuildProjectDetails {
	s.VpcConfig = v
	return s
}

// Information about the build environment for this build project.
type AwsCodeBuildProjectEnvironment struct {
	_ struct{} `type:"structure"`

	// The certificate to use with this build project.
	Certificate *string `type:"string"`

	// A set of environment variables to make available to builds for the build
	// project.
	EnvironmentVariables []*AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails `type:"list"`

	// The type of credentials CodeBuild uses to pull images in your build.
	//
	// Valid values:
	//
	//    * CODEBUILD specifies that CodeBuild uses its own credentials. This requires
	//    that you modify your ECR repository policy to trust the CodeBuild service
	//    principal.
	//
	//    * SERVICE_ROLE specifies that CodeBuild uses your build project's service
	//    role.
	//
	// When you use a cross-account or private registry image, you must use SERVICE_ROLE
	// credentials. When you use an CodeBuild curated image, you must use CODEBUILD
	// credentials.
	ImagePullCredentialsType *string `type:"string"`

	// Whether to allow the Docker daemon to run inside a Docker container. Set
	// to true if the build project is used to build Docker images.
	PrivilegedMode *bool `type:"boolean"`

	// The credentials for access to a private registry.
	RegistryCredential *AwsCodeBuildProjectEnvironmentRegistryCredential `type:"structure"`

	// The type of build environment to use for related builds.
	//
	// The environment type ARM_CONTAINER is available only in Regions US East (N.
	// Virginia), US East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific
	// (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt).
	//
	// The environment type LINUX_CONTAINER with compute type build.general1.2xlarge
	// is available only in Regions US East (N. Virginia), US East (N. Virginia),
	// US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
	// (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore),
	// Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
	//
	// The environment type LINUX_GPU_CONTAINER is available only in Regions US
	// East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central),
	// Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo),
	// Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China
	// (Beijing), and China (Ningxia).
	//
	// Valid values: WINDOWS_CONTAINER | LINUX_CONTAINER | LINUX_GPU_CONTAINER |
	// ARM_CONTAINER
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironment) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *AwsCodeBuildProjectEnvironment) SetCertificate(v string) *AwsCodeBuildProjectEnvironment {
	s.Certificate = &v
	return s
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *AwsCodeBuildProjectEnvironment) SetEnvironmentVariables(v []*AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) *AwsCodeBuildProjectEnvironment {
	s.EnvironmentVariables = v
	return s
}

// SetImagePullCredentialsType sets the ImagePullCredentialsType field's value.
func (s *AwsCodeBuildProjectEnvironment) SetImagePullCredentialsType(v string) *AwsCodeBuildProjectEnvironment {
	s.ImagePullCredentialsType = &v
	return s
}

// SetPrivilegedMode sets the PrivilegedMode field's value.
func (s *AwsCodeBuildProjectEnvironment) SetPrivilegedMode(v bool) *AwsCodeBuildProjectEnvironment {
	s.PrivilegedMode = &v
	return s
}

// SetRegistryCredential sets the RegistryCredential field's value.
func (s *AwsCodeBuildProjectEnvironment) SetRegistryCredential(v *AwsCodeBuildProjectEnvironmentRegistryCredential) *AwsCodeBuildProjectEnvironment {
	s.RegistryCredential = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectEnvironment) SetType(v string) *AwsCodeBuildProjectEnvironment {
	s.Type = &v
	return s
}

// Information about an environment variable that is available to builds for
// the build project.
type AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails struct {
	_ struct{} `type:"structure"`

	// The name of the environment variable.
	Name *string `type:"string"`

	// The type of environment variable.
	Type *string `type:"string"`

	// The value of the environment variable.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) SetName(v string) *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) SetType(v string) *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) SetValue(v string) *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails {
	s.Value = &v
	return s
}

// The credentials for access to a private registry.
type AwsCodeBuildProjectEnvironmentRegistryCredential struct {
	_ struct{} `type:"structure"`

	// The ARN or name of credentials created using Secrets Manager.
	//
	// The credential can use the name of the credentials only if they exist in
	// your current Amazon Web Services Region.
	Credential *string `type:"string"`

	// The service that created the credentials to access a private Docker registry.
	//
	// The valid value,SECRETS_MANAGER, is for Secrets Manager.
	CredentialProvider *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironmentRegistryCredential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironmentRegistryCredential) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *AwsCodeBuildProjectEnvironmentRegistryCredential) SetCredential(v string) *AwsCodeBuildProjectEnvironmentRegistryCredential {
	s.Credential = &v
	return s
}

// SetCredentialProvider sets the CredentialProvider field's value.
func (s *AwsCodeBuildProjectEnvironmentRegistryCredential) SetCredentialProvider(v string) *AwsCodeBuildProjectEnvironmentRegistryCredential {
	s.CredentialProvider = &v
	return s
}

// Information about CloudWatch Logs for the build project.
type AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails struct {
	_ struct{} `type:"structure"`

	// The group name of the logs in CloudWatch Logs.
	GroupName *string `type:"string"`

	// The current status of the logs in CloudWatch Logs for a build project.
	Status *string `type:"string"`

	// The prefix of the stream name of the CloudWatch Logs.
	StreamName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) SetGroupName(v string) *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails {
	s.GroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) SetStatus(v string) *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails {
	s.Status = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) SetStreamName(v string) *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails {
	s.StreamName = &v
	return s
}

// Information about logs for the build project.
type AwsCodeBuildProjectLogsConfigDetails struct {
	_ struct{} `type:"structure"`

	// Information about CloudWatch Logs for the build project.
	CloudWatchLogs *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails `type:"structure"`

	// Information about logs built to an S3 bucket for a build project.
	S3Logs *AwsCodeBuildProjectLogsConfigS3LogsDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigDetails) GoString() string {
	return s.String()
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *AwsCodeBuildProjectLogsConfigDetails) SetCloudWatchLogs(v *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) *AwsCodeBuildProjectLogsConfigDetails {
	s.CloudWatchLogs = v
	return s
}

// SetS3Logs sets the S3Logs field's value.
func (s *AwsCodeBuildProjectLogsConfigDetails) SetS3Logs(v *AwsCodeBuildProjectLogsConfigS3LogsDetails) *AwsCodeBuildProjectLogsConfigDetails {
	s.S3Logs = v
	return s
}

// Information about logs built to an S3 bucket for a build project.
type AwsCodeBuildProjectLogsConfigS3LogsDetails struct {
	_ struct{} `type:"structure"`

	// Whether to disable encryption of the S3 build log output.
	EncryptionDisabled *bool `type:"boolean"`

	// The ARN of the S3 bucket and the path prefix for S3 logs.
	Location *string `type:"string"`

	// The current status of the S3 build logs.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigS3LogsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigS3LogsDetails) GoString() string {
	return s.String()
}

// SetEncryptionDisabled sets the EncryptionDisabled field's value.
func (s *AwsCodeBuildProjectLogsConfigS3LogsDetails) SetEncryptionDisabled(v bool) *AwsCodeBuildProjectLogsConfigS3LogsDetails {
	s.EncryptionDisabled = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *AwsCodeBuildProjectLogsConfigS3LogsDetails) SetLocation(v string) *AwsCodeBuildProjectLogsConfigS3LogsDetails {
	s.Location = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCodeBuildProjectLogsConfigS3LogsDetails) SetStatus(v string) *AwsCodeBuildProjectLogsConfigS3LogsDetails {
	s.Status = &v
	return s
}

// Information about the build input source code for this build project.
type AwsCodeBuildProjectSource struct {
	_ struct{} `type:"structure"`

	// Information about the Git clone depth for the build project.
	GitCloneDepth *int64 `type:"integer"`

	// Whether to ignore SSL warnings while connecting to the project source code.
	InsecureSsl *bool `type:"boolean"`

	// Information about the location of the source code to be built.
	//
	// Valid values include:
	//
	//    * For source code settings that are specified in the source action of
	//    a pipeline in CodePipeline, location should not be specified. If it is
	//    specified, CodePipeline ignores it. This is because CodePipeline uses
	//    the settings in a pipeline's source action instead of this value.
	//
	//    * For source code in an CodeCommit repository, the HTTPS clone URL to
	//    the repository that contains the source code and the build spec file (for
	//    example, https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name
	//    ).
	//
	//    * For source code in an S3 input bucket, one of the following. The path
	//    to the ZIP file that contains the source code (for example, bucket-name/path/to/object-name.zip).
	//    The path to the folder that contains the source code (for example, bucket-name/path/to/source-code/folder/).
	//
	//    * For source code in a GitHub repository, the HTTPS clone URL to the repository
	//    that contains the source and the build spec file.
	//
	//    * For source code in a Bitbucket repository, the HTTPS clone URL to the
	//    repository that contains the source and the build spec file.
	Location *string `type:"string"`

	// The type of repository that contains the source code to be built. Valid values
	// are:
	//
	//    * BITBUCKET - The source code is in a Bitbucket repository.
	//
	//    * CODECOMMIT - The source code is in an CodeCommit repository.
	//
	//    * CODEPIPELINE - The source code settings are specified in the source
	//    action of a pipeline in CodePipeline.
	//
	//    * GITHUB - The source code is in a GitHub repository.
	//
	//    * GITHUB_ENTERPRISE - The source code is in a GitHub Enterprise repository.
	//
	//    * NO_SOURCE - The project does not have input source code.
	//
	//    * S3 - The source code is in an S3 input bucket.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectSource) GoString() string {
	return s.String()
}

// SetGitCloneDepth sets the GitCloneDepth field's value.
func (s *AwsCodeBuildProjectSource) SetGitCloneDepth(v int64) *AwsCodeBuildProjectSource {
	s.GitCloneDepth = &v
	return s
}

// SetInsecureSsl sets the InsecureSsl field's value.
func (s *AwsCodeBuildProjectSource) SetInsecureSsl(v bool) *AwsCodeBuildProjectSource {
	s.InsecureSsl = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *AwsCodeBuildProjectSource) SetLocation(v string) *AwsCodeBuildProjectSource {
	s.Location = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectSource) SetType(v string) *AwsCodeBuildProjectSource {
	s.Type = &v
	return s
}

// Information about the VPC configuration that CodeBuild accesses.
type AwsCodeBuildProjectVpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security group IDs in your VPC.
	SecurityGroupIds []*string `type:"list"`

	// A list of one or more subnet IDs in your VPC.
	Subnets []*string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectVpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetSecurityGroupIds(v []*string) *AwsCodeBuildProjectVpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetSubnets(v []*string) *AwsCodeBuildProjectVpcConfig {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetVpcId(v string) *AwsCodeBuildProjectVpcConfig {
	s.VpcId = &v
	return s
}

// Contains the cross-origin resource sharing (CORS) configuration for the API.
// CORS is only supported for HTTP APIs.
type AwsCorsConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether the CORS request includes credentials.
	AllowCredentials *bool `type:"boolean"`

	// The allowed headers for CORS requests.
	AllowHeaders []*string `type:"list"`

	// The allowed methods for CORS requests.
	AllowMethods []*string `type:"list"`

	// The allowed origins for CORS requests.
	AllowOrigins []*string `type:"list"`

	// The exposed headers for CORS requests.
	ExposeHeaders []*string `type:"list"`

	// The number of seconds for which the browser caches preflight request results.
	MaxAge *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCorsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCorsConfiguration) GoString() string {
	return s.String()
}

// SetAllowCredentials sets the AllowCredentials field's value.
func (s *AwsCorsConfiguration) SetAllowCredentials(v bool) *AwsCorsConfiguration {
	s.AllowCredentials = &v
	return s
}

// SetAllowHeaders sets the AllowHeaders field's value.
func (s *AwsCorsConfiguration) SetAllowHeaders(v []*string) *AwsCorsConfiguration {
	s.AllowHeaders = v
	return s
}

// SetAllowMethods sets the AllowMethods field's value.
func (s *AwsCorsConfiguration) SetAllowMethods(v []*string) *AwsCorsConfiguration {
	s.AllowMethods = v
	return s
}

// SetAllowOrigins sets the AllowOrigins field's value.
func (s *AwsCorsConfiguration) SetAllowOrigins(v []*string) *AwsCorsConfiguration {
	s.AllowOrigins = v
	return s
}

// SetExposeHeaders sets the ExposeHeaders field's value.
func (s *AwsCorsConfiguration) SetExposeHeaders(v []*string) *AwsCorsConfiguration {
	s.ExposeHeaders = v
	return s
}

// SetMaxAge sets the MaxAge field's value.
func (s *AwsCorsConfiguration) SetMaxAge(v int64) *AwsCorsConfiguration {
	s.MaxAge = &v
	return s
}

// Contains a definition of an attribute for the table.
type AwsDynamoDbTableAttributeDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	AttributeName *string `type:"string"`

	// The type of the attribute.
	AttributeType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableAttributeDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableAttributeDefinition) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *AwsDynamoDbTableAttributeDefinition) SetAttributeName(v string) *AwsDynamoDbTableAttributeDefinition {
	s.AttributeName = &v
	return s
}

// SetAttributeType sets the AttributeType field's value.
func (s *AwsDynamoDbTableAttributeDefinition) SetAttributeType(v string) *AwsDynamoDbTableAttributeDefinition {
	s.AttributeType = &v
	return s
}

// Provides information about the billing for read/write capacity on the table.
type AwsDynamoDbTableBillingModeSummary struct {
	_ struct{} `type:"structure"`

	// The method used to charge for read and write throughput and to manage capacity.
	BillingMode *string `type:"string"`

	// If the billing mode is PAY_PER_REQUEST, indicates when the billing mode was
	// set to that value.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	LastUpdateToPayPerRequestDateTime *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableBillingModeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableBillingModeSummary) GoString() string {
	return s.String()
}

// SetBillingMode sets the BillingMode field's value.
func (s *AwsDynamoDbTableBillingModeSummary) SetBillingMode(v string) *AwsDynamoDbTableBillingModeSummary {
	s.BillingMode = &v
	return s
}

// SetLastUpdateToPayPerRequestDateTime sets the LastUpdateToPayPerRequestDateTime field's value.
func (s *AwsDynamoDbTableBillingModeSummary) SetLastUpdateToPayPerRequestDateTime(v string) *AwsDynamoDbTableBillingModeSummary {
	s.LastUpdateToPayPerRequestDateTime = &v
	return s
}

// Provides details about a DynamoDB table.
type AwsDynamoDbTableDetails struct {
	_ struct{} `type:"structure"`

	// A list of attribute definitions for the table.
	AttributeDefinitions []*AwsDynamoDbTableAttributeDefinition `type:"list"`

	// Information about the billing for read/write capacity on the table.
	BillingModeSummary *AwsDynamoDbTableBillingModeSummary `type:"structure"`

	// Indicates when the table was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	CreationDateTime *string `type:"string"`

	// List of global secondary indexes for the table.
	GlobalSecondaryIndexes []*AwsDynamoDbTableGlobalSecondaryIndex `type:"list"`

	// The version of global tables being used.
	GlobalTableVersion *string `type:"string"`

	// The number of items in the table.
	ItemCount *int64 `type:"integer"`

	// The primary key structure for the table.
	KeySchema []*AwsDynamoDbTableKeySchema `type:"list"`

	// The ARN of the latest stream for the table.
	LatestStreamArn *string `type:"string"`

	// The label of the latest stream. The label is not a unique identifier.
	LatestStreamLabel *string `type:"string"`

	// The list of local secondary indexes for the table.
	LocalSecondaryIndexes []*AwsDynamoDbTableLocalSecondaryIndex `type:"list"`

	// Information about the provisioned throughput for the table.
	ProvisionedThroughput *AwsDynamoDbTableProvisionedThroughput `type:"structure"`

	// The list of replicas of this table.
	Replicas []*AwsDynamoDbTableReplica `type:"list"`

	// Information about the restore for the table.
	RestoreSummary *AwsDynamoDbTableRestoreSummary `type:"structure"`

	// Information about the server-side encryption for the table.
	SseDescription *AwsDynamoDbTableSseDescription `type:"structure"`

	// The current DynamoDB Streams configuration for the table.
	StreamSpecification *AwsDynamoDbTableStreamSpecification `type:"structure"`

	// The identifier of the table.
	TableId *string `type:"string"`

	// The name of the table.
	TableName *string `type:"string"`

	// The total size of the table in bytes.
	TableSizeBytes *int64 `type:"long"`

	// The current status of the table. Valid values are as follows:
	//
	//    * ACTIVE
	//
	//    * ARCHIVED
	//
	//    * ARCHIVING
	//
	//    * CREATING
	//
	//    * DELETING
	//
	//    * INACCESSIBLE_ENCRYPTION_CREDENTIALS
	//
	//    * UPDATING
	TableStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableDetails) GoString() string {
	return s.String()
}

// SetAttributeDefinitions sets the AttributeDefinitions field's value.
func (s *AwsDynamoDbTableDetails) SetAttributeDefinitions(v []*AwsDynamoDbTableAttributeDefinition) *AwsDynamoDbTableDetails {
	s.AttributeDefinitions = v
	return s
}

// SetBillingModeSummary sets the BillingModeSummary field's value.
func (s *AwsDynamoDbTableDetails) SetBillingModeSummary(v *AwsDynamoDbTableBillingModeSummary) *AwsDynamoDbTableDetails {
	s.BillingModeSummary = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *AwsDynamoDbTableDetails) SetCreationDateTime(v string) *AwsDynamoDbTableDetails {
	s.CreationDateTime = &v
	return s
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *AwsDynamoDbTableDetails) SetGlobalSecondaryIndexes(v []*AwsDynamoDbTableGlobalSecondaryIndex) *AwsDynamoDbTableDetails {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetGlobalTableVersion sets the GlobalTableVersion field's value.
func (s *AwsDynamoDbTableDetails) SetGlobalTableVersion(v string) *AwsDynamoDbTableDetails {
	s.GlobalTableVersion = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *AwsDynamoDbTableDetails) SetItemCount(v int64) *AwsDynamoDbTableDetails {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *AwsDynamoDbTableDetails) SetKeySchema(v []*AwsDynamoDbTableKeySchema) *AwsDynamoDbTableDetails {
	s.KeySchema = v
	return s
}

// SetLatestStreamArn sets the LatestStreamArn field's value.
func (s *AwsDynamoDbTableDetails) SetLatestStreamArn(v string) *AwsDynamoDbTableDetails {
	s.LatestStreamArn = &v
	return s
}

// SetLatestStreamLabel sets the LatestStreamLabel field's value.
func (s *AwsDynamoDbTableDetails) SetLatestStreamLabel(v string) *AwsDynamoDbTableDetails {
	s.LatestStreamLabel = &v
	return s
}

// SetLocalSecondaryIndexes sets the LocalSecondaryIndexes field's value.
func (s *AwsDynamoDbTableDetails) SetLocalSecondaryIndexes(v []*AwsDynamoDbTableLocalSecondaryIndex) *AwsDynamoDbTableDetails {
	s.LocalSecondaryIndexes = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *AwsDynamoDbTableDetails) SetProvisionedThroughput(v *AwsDynamoDbTableProvisionedThroughput) *AwsDynamoDbTableDetails {
	s.ProvisionedThroughput = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *AwsDynamoDbTableDetails) SetReplicas(v []*AwsDynamoDbTableReplica) *AwsDynamoDbTableDetails {
	s.Replicas = v
	return s
}

// SetRestoreSummary sets the RestoreSummary field's value.
func (s *AwsDynamoDbTableDetails) SetRestoreSummary(v *AwsDynamoDbTableRestoreSummary) *AwsDynamoDbTableDetails {
	s.RestoreSummary = v
	return s
}

// SetSseDescription sets the SseDescription field's value.
func (s *AwsDynamoDbTableDetails) SetSseDescription(v *AwsDynamoDbTableSseDescription) *AwsDynamoDbTableDetails {
	s.SseDescription = v
	return s
}

// SetStreamSpecification sets the StreamSpecification field's value.
func (s *AwsDynamoDbTableDetails) SetStreamSpecification(v *AwsDynamoDbTableStreamSpecification) *AwsDynamoDbTableDetails {
	s.StreamSpecification = v
	return s
}

// SetTableId sets the TableId field's value.
func (s *AwsDynamoDbTableDetails) SetTableId(v string) *AwsDynamoDbTableDetails {
	s.TableId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *AwsDynamoDbTableDetails) SetTableName(v string) *AwsDynamoDbTableDetails {
	s.TableName = &v
	return s
}

// SetTableSizeBytes sets the TableSizeBytes field's value.
func (s *AwsDynamoDbTableDetails) SetTableSizeBytes(v int64) *AwsDynamoDbTableDetails {
	s.TableSizeBytes = &v
	return s
}

// SetTableStatus sets the TableStatus field's value.
func (s *AwsDynamoDbTableDetails) SetTableStatus(v string) *AwsDynamoDbTableDetails {
	s.TableStatus = &v
	return s
}

// Information abut a global secondary index for the table.
type AwsDynamoDbTableGlobalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// Whether the index is currently backfilling.
	Backfilling *bool `type:"boolean"`

	// The ARN of the index.
	IndexArn *string `type:"string"`

	// The name of the index.
	IndexName *string `type:"string"`

	// The total size in bytes of the index.
	IndexSizeBytes *int64 `type:"long"`

	// The current status of the index.
	//
	//    * ACTIVE
	//
	//    * CREATING
	//
	//    * DELETING
	//
	//    * UPDATING
	IndexStatus *string `type:"string"`

	// The number of items in the index.
	ItemCount *int64 `type:"integer"`

	// The key schema for the index.
	KeySchema []*AwsDynamoDbTableKeySchema `type:"list"`

	// Attributes that are copied from the table into an index.
	Projection *AwsDynamoDbTableProjection `type:"structure"`

	// Information about the provisioned throughput settings for the indexes.
	ProvisionedThroughput *AwsDynamoDbTableProvisionedThroughput `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableGlobalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableGlobalSecondaryIndex) GoString() string {
	return s.String()
}

// SetBackfilling sets the Backfilling field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetBackfilling(v bool) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.Backfilling = &v
	return s
}

// SetIndexArn sets the IndexArn field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexArn(v string) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexName(v string) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetIndexSizeBytes sets the IndexSizeBytes field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexSizeBytes(v int64) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexSizeBytes = &v
	return s
}

// SetIndexStatus sets the IndexStatus field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexStatus(v string) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexStatus = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetItemCount(v int64) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetKeySchema(v []*AwsDynamoDbTableKeySchema) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetProjection(v *AwsDynamoDbTableProjection) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.Projection = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetProvisionedThroughput(v *AwsDynamoDbTableProvisionedThroughput) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.ProvisionedThroughput = v
	return s
}

// A component of the key schema for the DynamoDB table, a global secondary
// index, or a local secondary index.
type AwsDynamoDbTableKeySchema struct {
	_ struct{} `type:"structure"`

	// The name of the key schema attribute.
	AttributeName *string `type:"string"`

	// The type of key used for the key schema attribute. Valid values are HASH
	// or RANGE.
	KeyType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableKeySchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableKeySchema) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *AwsDynamoDbTableKeySchema) SetAttributeName(v string) *AwsDynamoDbTableKeySchema {
	s.AttributeName = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *AwsDynamoDbTableKeySchema) SetKeyType(v string) *AwsDynamoDbTableKeySchema {
	s.KeyType = &v
	return s
}

// Information about a local secondary index for a DynamoDB table.
type AwsDynamoDbTableLocalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The ARN of the index.
	IndexArn *string `type:"string"`

	// The name of the index.
	IndexName *string `type:"string"`

	// The complete key schema for the index.
	KeySchema []*AwsDynamoDbTableKeySchema `type:"list"`

	// Attributes that are copied from the table into the index. These are in addition
	// to the primary key attributes and index key attributes, which are automatically
	// projected.
	Projection *AwsDynamoDbTableProjection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableLocalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableLocalSecondaryIndex) GoString() string {
	return s.String()
}

// SetIndexArn sets the IndexArn field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetIndexArn(v string) *AwsDynamoDbTableLocalSecondaryIndex {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetIndexName(v string) *AwsDynamoDbTableLocalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetKeySchema(v []*AwsDynamoDbTableKeySchema) *AwsDynamoDbTableLocalSecondaryIndex {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetProjection(v *AwsDynamoDbTableProjection) *AwsDynamoDbTableLocalSecondaryIndex {
	s.Projection = v
	return s
}

// For global and local secondary indexes, identifies the attributes that are
// copied from the table into the index.
type AwsDynamoDbTableProjection struct {
	_ struct{} `type:"structure"`

	// The nonkey attributes that are projected into the index. For each attribute,
	// provide the attribute name.
	NonKeyAttributes []*string `type:"list"`

	// The types of attributes that are projected into the index. Valid values are
	// as follows:
	//
	//    * ALL
	//
	//    * INCLUDE
	//
	//    * KEYS_ONLY
	ProjectionType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProjection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProjection) GoString() string {
	return s.String()
}

// SetNonKeyAttributes sets the NonKeyAttributes field's value.
func (s *AwsDynamoDbTableProjection) SetNonKeyAttributes(v []*string) *AwsDynamoDbTableProjection {
	s.NonKeyAttributes = v
	return s
}

// SetProjectionType sets the ProjectionType field's value.
func (s *AwsDynamoDbTableProjection) SetProjectionType(v string) *AwsDynamoDbTableProjection {
	s.ProjectionType = &v
	return s
}

// Information about the provisioned throughput for the table or for a global
// secondary index.
type AwsDynamoDbTableProvisionedThroughput struct {
	_ struct{} `type:"structure"`

	// Indicates when the provisioned throughput was last decreased.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	LastDecreaseDateTime *string `type:"string"`

	// Indicates when the provisioned throughput was last increased.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	LastIncreaseDateTime *string `type:"string"`

	// The number of times during the current UTC calendar day that the provisioned
	// throughput was decreased.
	NumberOfDecreasesToday *int64 `type:"integer"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException.
	ReadCapacityUnits *int64 `type:"integer"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	WriteCapacityUnits *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProvisionedThroughput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProvisionedThroughput) GoString() string {
	return s.String()
}

// SetLastDecreaseDateTime sets the LastDecreaseDateTime field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetLastDecreaseDateTime(v string) *AwsDynamoDbTableProvisionedThroughput {
	s.LastDecreaseDateTime = &v
	return s
}

// SetLastIncreaseDateTime sets the LastIncreaseDateTime field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetLastIncreaseDateTime(v string) *AwsDynamoDbTableProvisionedThroughput {
	s.LastIncreaseDateTime = &v
	return s
}

// SetNumberOfDecreasesToday sets the NumberOfDecreasesToday field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetNumberOfDecreasesToday(v int64) *AwsDynamoDbTableProvisionedThroughput {
	s.NumberOfDecreasesToday = &v
	return s
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetReadCapacityUnits(v int64) *AwsDynamoDbTableProvisionedThroughput {
	s.ReadCapacityUnits = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetWriteCapacityUnits(v int64) *AwsDynamoDbTableProvisionedThroughput {
	s.WriteCapacityUnits = &v
	return s
}

// Replica-specific configuration for the provisioned throughput.
type AwsDynamoDbTableProvisionedThroughputOverride struct {
	_ struct{} `type:"structure"`

	// The read capacity units for the replica.
	ReadCapacityUnits *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProvisionedThroughputOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProvisionedThroughputOverride) GoString() string {
	return s.String()
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *AwsDynamoDbTableProvisionedThroughputOverride) SetReadCapacityUnits(v int64) *AwsDynamoDbTableProvisionedThroughputOverride {
	s.ReadCapacityUnits = &v
	return s
}

// Information about a replica of a DynamoDB table.
type AwsDynamoDbTableReplica struct {
	_ struct{} `type:"structure"`

	// List of global secondary indexes for the replica.
	GlobalSecondaryIndexes []*AwsDynamoDbTableReplicaGlobalSecondaryIndex `type:"list"`

	// The identifier of the KMS key that will be used for KMS encryption for the
	// replica.
	KmsMasterKeyId *string `type:"string"`

	// Replica-specific configuration for the provisioned throughput.
	ProvisionedThroughputOverride *AwsDynamoDbTableProvisionedThroughputOverride `type:"structure"`

	// The name of the Region where the replica is located.
	RegionName *string `type:"string"`

	// The current status of the replica. Valid values are as follows:
	//
	//    * ACTIVE
	//
	//    * CREATING
	//
	//    * CREATION_FAILED
	//
	//    * DELETING
	//
	//    * UPDATING
	ReplicaStatus *string `type:"string"`

	// Detailed information about the replica status.
	ReplicaStatusDescription *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableReplica) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableReplica) GoString() string {
	return s.String()
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *AwsDynamoDbTableReplica) SetGlobalSecondaryIndexes(v []*AwsDynamoDbTableReplicaGlobalSecondaryIndex) *AwsDynamoDbTableReplica {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetKmsMasterKeyId sets the KmsMasterKeyId field's value.
func (s *AwsDynamoDbTableReplica) SetKmsMasterKeyId(v string) *AwsDynamoDbTableReplica {
	s.KmsMasterKeyId = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *AwsDynamoDbTableReplica) SetProvisionedThroughputOverride(v *AwsDynamoDbTableProvisionedThroughputOverride) *AwsDynamoDbTableReplica {
	s.ProvisionedThroughputOverride = v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *AwsDynamoDbTableReplica) SetRegionName(v string) *AwsDynamoDbTableReplica {
	s.RegionName = &v
	return s
}

// SetReplicaStatus sets the ReplicaStatus field's value.
func (s *AwsDynamoDbTableReplica) SetReplicaStatus(v string) *AwsDynamoDbTableReplica {
	s.ReplicaStatus = &v
	return s
}

// SetReplicaStatusDescription sets the ReplicaStatusDescription field's value.
func (s *AwsDynamoDbTableReplica) SetReplicaStatusDescription(v string) *AwsDynamoDbTableReplica {
	s.ReplicaStatusDescription = &v
	return s
}

// Information about a global secondary index for a DynamoDB table replica.
type AwsDynamoDbTableReplicaGlobalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The name of the index.
	IndexName *string `type:"string"`

	// Replica-specific configuration for the provisioned throughput for the index.
	ProvisionedThroughputOverride *AwsDynamoDbTableProvisionedThroughputOverride `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableReplicaGlobalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableReplicaGlobalSecondaryIndex) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *AwsDynamoDbTableReplicaGlobalSecondaryIndex) SetIndexName(v string) *AwsDynamoDbTableReplicaGlobalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *AwsDynamoDbTableReplicaGlobalSecondaryIndex) SetProvisionedThroughputOverride(v *AwsDynamoDbTableProvisionedThroughputOverride) *AwsDynamoDbTableReplicaGlobalSecondaryIndex {
	s.ProvisionedThroughputOverride = v
	return s
}

// Information about the restore for the table.
type AwsDynamoDbTableRestoreSummary struct {
	_ struct{} `type:"structure"`

	// Indicates the point in time that the table was restored to.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	RestoreDateTime *string `type:"string"`

	// Whether a restore is currently in progress.
	RestoreInProgress *bool `type:"boolean"`

	// The ARN of the source backup from which the table was restored.
	SourceBackupArn *string `type:"string"`

	// The ARN of the source table for the backup.
	SourceTableArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableRestoreSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableRestoreSummary) GoString() string {
	return s.String()
}

// SetRestoreDateTime sets the RestoreDateTime field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetRestoreDateTime(v string) *AwsDynamoDbTableRestoreSummary {
	s.RestoreDateTime = &v
	return s
}

// SetRestoreInProgress sets the RestoreInProgress field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetRestoreInProgress(v bool) *AwsDynamoDbTableRestoreSummary {
	s.RestoreInProgress = &v
	return s
}

// SetSourceBackupArn sets the SourceBackupArn field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetSourceBackupArn(v string) *AwsDynamoDbTableRestoreSummary {
	s.SourceBackupArn = &v
	return s
}

// SetSourceTableArn sets the SourceTableArn field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetSourceTableArn(v string) *AwsDynamoDbTableRestoreSummary {
	s.SourceTableArn = &v
	return s
}

// Information about the server-side encryption for the table.
type AwsDynamoDbTableSseDescription struct {
	_ struct{} `type:"structure"`

	// If the key is inaccessible, the date and time when DynamoDB detected that
	// the key was inaccessible.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	InaccessibleEncryptionDateTime *string `type:"string"`

	// The ARN of the KMS key that is used for the KMS encryption.
	KmsMasterKeyArn *string `type:"string"`

	// The type of server-side encryption.
	SseType *string `type:"string"`

	// The status of the server-side encryption.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableSseDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableSseDescription) GoString() string {
	return s.String()
}

// SetInaccessibleEncryptionDateTime sets the InaccessibleEncryptionDateTime field's value.
func (s *AwsDynamoDbTableSseDescription) SetInaccessibleEncryptionDateTime(v string) *AwsDynamoDbTableSseDescription {
	s.InaccessibleEncryptionDateTime = &v
	return s
}

// SetKmsMasterKeyArn sets the KmsMasterKeyArn field's value.
func (s *AwsDynamoDbTableSseDescription) SetKmsMasterKeyArn(v string) *AwsDynamoDbTableSseDescription {
	s.KmsMasterKeyArn = &v
	return s
}

// SetSseType sets the SseType field's value.
func (s *AwsDynamoDbTableSseDescription) SetSseType(v string) *AwsDynamoDbTableSseDescription {
	s.SseType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsDynamoDbTableSseDescription) SetStatus(v string) *AwsDynamoDbTableSseDescription {
	s.Status = &v
	return s
}

// The current DynamoDB Streams configuration for the table.
type AwsDynamoDbTableStreamSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether DynamoDB Streams is enabled on the table.
	StreamEnabled *bool `type:"boolean"`

	// Determines the information that is written to the table.
	StreamViewType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableStreamSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableStreamSpecification) GoString() string {
	return s.String()
}

// SetStreamEnabled sets the StreamEnabled field's value.
func (s *AwsDynamoDbTableStreamSpecification) SetStreamEnabled(v bool) *AwsDynamoDbTableStreamSpecification {
	s.StreamEnabled = &v
	return s
}

// SetStreamViewType sets the StreamViewType field's value.
func (s *AwsDynamoDbTableStreamSpecification) SetStreamViewType(v string) *AwsDynamoDbTableStreamSpecification {
	s.StreamViewType = &v
	return s
}

// Information about an Elastic IP address.
type AwsEc2EipDetails struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Web Services assigns to represent the allocation
	// of the Elastic IP address for use with Amazon VPC.
	AllocationId *string `type:"string"`

	// The identifier that represents the association of the Elastic IP address
	// with an EC2 instance.
	AssociationId *string `type:"string"`

	// The domain in which to allocate the address.
	//
	// If the address is for use with EC2 instances in a VPC, then Domain is vpc.
	// Otherwise, Domain is standard.
	Domain *string `type:"string"`

	// The identifier of the EC2 instance.
	InstanceId *string `type:"string"`

	// The name of the location from which the Elastic IP address is advertised.
	NetworkBorderGroup *string `type:"string"`

	// The identifier of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// The Amazon Web Services account ID of the owner of the network interface.
	NetworkInterfaceOwnerId *string `type:"string"`

	// The private IP address that is associated with the Elastic IP address.
	PrivateIpAddress *string `type:"string"`

	// A public IP address that is associated with the EC2 instance.
	PublicIp *string `type:"string"`

	// The identifier of an IP address pool. This parameter allows Amazon EC2 to
	// select an IP address from the address pool.
	PublicIpv4Pool *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2EipDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2EipDetails) GoString() string {
	return s.String()
}

// SetAllocationId sets the AllocationId field's value.
func (s *AwsEc2EipDetails) SetAllocationId(v string) *AwsEc2EipDetails {
	s.AllocationId = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *AwsEc2EipDetails) SetAssociationId(v string) *AwsEc2EipDetails {
	s.AssociationId = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *AwsEc2EipDetails) SetDomain(v string) *AwsEc2EipDetails {
	s.Domain = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsEc2EipDetails) SetInstanceId(v string) *AwsEc2EipDetails {
	s.InstanceId = &v
	return s
}

// SetNetworkBorderGroup sets the NetworkBorderGroup field's value.
func (s *AwsEc2EipDetails) SetNetworkBorderGroup(v string) *AwsEc2EipDetails {
	s.NetworkBorderGroup = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AwsEc2EipDetails) SetNetworkInterfaceId(v string) *AwsEc2EipDetails {
	s.NetworkInterfaceId = &v
	return s
}

// SetNetworkInterfaceOwnerId sets the NetworkInterfaceOwnerId field's value.
func (s *AwsEc2EipDetails) SetNetworkInterfaceOwnerId(v string) *AwsEc2EipDetails {
	s.NetworkInterfaceOwnerId = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *AwsEc2EipDetails) SetPrivateIpAddress(v string) *AwsEc2EipDetails {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *AwsEc2EipDetails) SetPublicIp(v string) *AwsEc2EipDetails {
	s.PublicIp = &v
	return s
}

// SetPublicIpv4Pool sets the PublicIpv4Pool field's value.
func (s *AwsEc2EipDetails) SetPublicIpv4Pool(v string) *AwsEc2EipDetails {
	s.PublicIpv4Pool = &v
	return s
}

// The details of an Amazon EC2 instance.
type AwsEc2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The IAM profile ARN of the instance.
	IamInstanceProfileArn *string `type:"string"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ImageId *string `type:"string"`

	// The IPv4 addresses associated with the instance.
	IpV4Addresses []*string `type:"list"`

	// The IPv6 addresses associated with the instance.
	IpV6Addresses []*string `type:"list"`

	// The key name associated with the instance.
	KeyName *string `type:"string"`

	// Indicates when the instance was launched.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	LaunchedAt *string `type:"string"`

	// Details about the metadata options for the Amazon EC2 instance.
	MetadataOptions *AwsEc2InstanceMetadataOptions `type:"structure"`

	// Describes the type of monitoring that’s turned on for an instance.
	Monitoring *AwsEc2InstanceMonitoringDetails `type:"structure"`

	// The identifiers of the network interfaces for the EC2 instance. The details
	// for each network interface are in a corresponding AwsEc2NetworkInterfacesDetails
	// object.
	NetworkInterfaces []*AwsEc2InstanceNetworkInterfacesDetails `type:"list"`

	// The identifier of the subnet that the instance was launched in.
	SubnetId *string `type:"string"`

	// The instance type of the instance.
	Type *string `type:"string"`

	// The virtualization type of the Amazon Machine Image (AMI) required to launch
	// the instance.
	VirtualizationType *string `type:"string"`

	// The identifier of the VPC that the instance was launched in.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceDetails) GoString() string {
	return s.String()
}

// SetIamInstanceProfileArn sets the IamInstanceProfileArn field's value.
func (s *AwsEc2InstanceDetails) SetIamInstanceProfileArn(v string) *AwsEc2InstanceDetails {
	s.IamInstanceProfileArn = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *AwsEc2InstanceDetails) SetImageId(v string) *AwsEc2InstanceDetails {
	s.ImageId = &v
	return s
}

// SetIpV4Addresses sets the IpV4Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV4Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV4Addresses = v
	return s
}

// SetIpV6Addresses sets the IpV6Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV6Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV6Addresses = v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AwsEc2InstanceDetails) SetKeyName(v string) *AwsEc2InstanceDetails {
	s.KeyName = &v
	return s
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *AwsEc2InstanceDetails) SetLaunchedAt(v string) *AwsEc2InstanceDetails {
	s.LaunchedAt = &v
	return s
}

// SetMetadataOptions sets the MetadataOptions field's value.
func (s *AwsEc2InstanceDetails) SetMetadataOptions(v *AwsEc2InstanceMetadataOptions) *AwsEc2InstanceDetails {
	s.MetadataOptions = v
	return s
}

// SetMonitoring sets the Monitoring field's value.
func (s *AwsEc2InstanceDetails) SetMonitoring(v *AwsEc2InstanceMonitoringDetails) *AwsEc2InstanceDetails {
	s.Monitoring = v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *AwsEc2InstanceDetails) SetNetworkInterfaces(v []*AwsEc2InstanceNetworkInterfacesDetails) *AwsEc2InstanceDetails {
	s.NetworkInterfaces = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2InstanceDetails) SetSubnetId(v string) *AwsEc2InstanceDetails {
	s.SubnetId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEc2InstanceDetails) SetType(v string) *AwsEc2InstanceDetails {
	s.Type = &v
	return s
}

// SetVirtualizationType sets the VirtualizationType field's value.
func (s *AwsEc2InstanceDetails) SetVirtualizationType(v string) *AwsEc2InstanceDetails {
	s.VirtualizationType = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2InstanceDetails) SetVpcId(v string) *AwsEc2InstanceDetails {
	s.VpcId = &v
	return s
}

// Metadata options that allow you to configure and secure the Amazon EC2 instance.
type AwsEc2InstanceMetadataOptions struct {
	_ struct{} `type:"structure"`

	// Enables or disables the HTTP metadata endpoint on the instance.
	HttpEndpoint *string `type:"string"`

	// Enables or disables the IPv6 endpoint for the instance metadata service.
	HttpProtocolIpv6 *string `type:"string"`

	// The desired HTTP PUT response hop limit for instance metadata requests. The
	// larger the number, the further instance metadata requests can travel.
	HttpPutResponseHopLimit *int64 `type:"integer"`

	// The state of token usage for your instance metadata requests.
	HttpTokens *string `type:"string"`

	// Specifies whether to allow access to instance tags from the instance metadata.
	InstanceMetadataTags *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceMetadataOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceMetadataOptions) GoString() string {
	return s.String()
}

// SetHttpEndpoint sets the HttpEndpoint field's value.
func (s *AwsEc2InstanceMetadataOptions) SetHttpEndpoint(v string) *AwsEc2InstanceMetadataOptions {
	s.HttpEndpoint = &v
	return s
}

// SetHttpProtocolIpv6 sets the HttpProtocolIpv6 field's value.
func (s *AwsEc2InstanceMetadataOptions) SetHttpProtocolIpv6(v string) *AwsEc2InstanceMetadataOptions {
	s.HttpProtocolIpv6 = &v
	return s
}

// SetHttpPutResponseHopLimit sets the HttpPutResponseHopLimit field's value.
func (s *AwsEc2InstanceMetadataOptions) SetHttpPutResponseHopLimit(v int64) *AwsEc2InstanceMetadataOptions {
	s.HttpPutResponseHopLimit = &v
	return s
}

// SetHttpTokens sets the HttpTokens field's value.
func (s *AwsEc2InstanceMetadataOptions) SetHttpTokens(v string) *AwsEc2InstanceMetadataOptions {
	s.HttpTokens = &v
	return s
}

// SetInstanceMetadataTags sets the InstanceMetadataTags field's value.
func (s *AwsEc2InstanceMetadataOptions) SetInstanceMetadataTags(v string) *AwsEc2InstanceMetadataOptions {
	s.InstanceMetadataTags = &v
	return s
}

// The type of monitoring that’s turned on for an Amazon EC2 instance.
type AwsEc2InstanceMonitoringDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether detailed monitoring is turned on. Otherwise, basic monitoring
	// is turned on.
	State *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceMonitoringDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceMonitoringDetails) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *AwsEc2InstanceMonitoringDetails) SetState(v string) *AwsEc2InstanceMonitoringDetails {
	s.State = &v
	return s
}

// Identifies a network interface for the Amazon EC2 instance.
type AwsEc2InstanceNetworkInterfacesDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the network interface. The details are in a corresponding
	// AwsEc2NetworkInterfacesDetails object.
	NetworkInterfaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceNetworkInterfacesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceNetworkInterfacesDetails) GoString() string {
	return s.String()
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AwsEc2InstanceNetworkInterfacesDetails) SetNetworkInterfaceId(v string) *AwsEc2InstanceNetworkInterfacesDetails {
	s.NetworkInterfaceId = &v
	return s
}

// Information about a block device mapping for an Amazon Elastic Compute Cloud
// (Amazon EC2) launch template.
type AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails struct {
	_ struct{} `type:"structure"`

	// The device name.
	DeviceName *string `type:"string"`

	// Parameters used to automatically set up Amazon EBS volumes when the instance
	// is launched.
	Ebs *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails `type:"structure"`

	// Omits the device from the block device mapping when an empty string is specified.
	NoDevice *string `type:"string"`

	// The virtual device name (ephemeralN). Instance store volumes are numbered
	// starting from 0. An instance type with 2 available instance store volumes
	// can specify mappings for ephemeral0 and ephemeral1. The number of available
	// instance store volumes depends on the instance type.
	VirtualName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails) SetDeviceName(v string) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails {
	s.DeviceName = &v
	return s
}

// SetEbs sets the Ebs field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails) SetEbs(v *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails {
	s.Ebs = v
	return s
}

// SetNoDevice sets the NoDevice field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails) SetNoDevice(v string) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails {
	s.NoDevice = &v
	return s
}

// SetVirtualName sets the VirtualName field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails) SetVirtualName(v string) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails {
	s.VirtualName = &v
	return s
}

// Parameters for a block device for an Amazon Elastic Block Store (Amazon EBS)
// volume in an Amazon EC2 launch template.
type AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether the EBS volume is deleted on instance termination.
	DeleteOnTermination *bool `type:"boolean"`

	// Indicates whether the EBS volume is encrypted. Encrypted volumes can only
	// be attached to instances that support Amazon EBS encryption. If you're creating
	// a volume from a snapshot, you can't specify an encryption value.
	Encrypted *bool `type:"boolean"`

	// The number of I/O operations per second (IOPS).
	Iops *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the symmetric Key Management Service (KMS)
	// customer managed key used for encryption.
	KmsKeyId *string `type:"string"`

	// The ID of the EBS snapshot.
	SnapshotId *string `type:"string"`

	// The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
	Throughput *int64 `type:"integer"`

	// The size of the volume, in GiBs. You must specify either a snapshot ID or
	// a volume size.
	VolumeSize *int64 `type:"integer"`

	// The volume type.
	VolumeType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) GoString() string {
	return s.String()
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) SetDeleteOnTermination(v bool) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails {
	s.DeleteOnTermination = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) SetEncrypted(v bool) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails {
	s.Encrypted = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) SetIops(v int64) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) SetKmsKeyId(v string) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails {
	s.KmsKeyId = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) SetSnapshotId(v string) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails {
	s.SnapshotId = &v
	return s
}

// SetThroughput sets the Throughput field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) SetThroughput(v int64) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails {
	s.Throughput = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) SetVolumeSize(v int64) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) SetVolumeType(v string) *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails {
	s.VolumeType = &v
	return s
}

// Information about the target Capacity Reservation or Capacity Reservation
// group in which to run an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the Capacity Reservation in which to run the instance.
	CapacityReservationId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Capacity Reservation resource group
	// in which to run the instance.
	CapacityReservationResourceGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails) GoString() string {
	return s.String()
}

// SetCapacityReservationId sets the CapacityReservationId field's value.
func (s *AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails) SetCapacityReservationId(v string) *AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails {
	s.CapacityReservationId = &v
	return s
}

// SetCapacityReservationResourceGroupArn sets the CapacityReservationResourceGroupArn field's value.
func (s *AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails) SetCapacityReservationResourceGroupArn(v string) *AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails {
	s.CapacityReservationResourceGroupArn = &v
	return s
}

// Specifies the Capacity Reservation targeting option of an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails struct {
	_ struct{} `type:"structure"`

	// Indicates the instance's Capacity Reservation preferences. If equal to open,
	// the instance can run in any open Capacity Reservation that has matching attributes
	// (instance type, platform, Availability Zone). If equal to none, the instance
	// avoids running in a Capacity Reservation even if one is available. The instance
	// runs in On-Demand capacity.
	CapacityReservationPreference *string `type:"string"`

	// Specifies a target Capacity Reservation.
	CapacityReservationTarget *AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails) GoString() string {
	return s.String()
}

// SetCapacityReservationPreference sets the CapacityReservationPreference field's value.
func (s *AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails) SetCapacityReservationPreference(v string) *AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails {
	s.CapacityReservationPreference = &v
	return s
}

// SetCapacityReservationTarget sets the CapacityReservationTarget field's value.
func (s *AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails) SetCapacityReservationTarget(v *AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails) *AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails {
	s.CapacityReservationTarget = v
	return s
}

// Specifies the CPU options for an Amazon EC2 instance. For more information,
// see Optimize CPU options (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html)
// in the Amazon Elastic Compute Cloud User Guide.
type AwsEc2LaunchTemplateDataCpuOptionsDetails struct {
	_ struct{} `type:"structure"`

	// The number of CPU cores for the instance.
	CoreCount *int64 `type:"integer"`

	// The number of threads per CPU core. A value of 1 disables multithreading
	// for the instance, The default value is 2.
	ThreadsPerCore *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataCpuOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataCpuOptionsDetails) GoString() string {
	return s.String()
}

// SetCoreCount sets the CoreCount field's value.
func (s *AwsEc2LaunchTemplateDataCpuOptionsDetails) SetCoreCount(v int64) *AwsEc2LaunchTemplateDataCpuOptionsDetails {
	s.CoreCount = &v
	return s
}

// SetThreadsPerCore sets the ThreadsPerCore field's value.
func (s *AwsEc2LaunchTemplateDataCpuOptionsDetails) SetThreadsPerCore(v int64) *AwsEc2LaunchTemplateDataCpuOptionsDetails {
	s.ThreadsPerCore = &v
	return s
}

// Specifies the credit option for CPU usage of a T2, T3, or T3a Amazon EC2
// instance.
type AwsEc2LaunchTemplateDataCreditSpecificationDetails struct {
	_ struct{} `type:"structure"`

	// The credit option for CPU usage of a T instance.
	CpuCredits *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataCreditSpecificationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataCreditSpecificationDetails) GoString() string {
	return s.String()
}

// SetCpuCredits sets the CpuCredits field's value.
func (s *AwsEc2LaunchTemplateDataCreditSpecificationDetails) SetCpuCredits(v string) *AwsEc2LaunchTemplateDataCreditSpecificationDetails {
	s.CpuCredits = &v
	return s
}

// The information to include in an Amazon Elastic Compute Cloud (Amazon EC2)
// launch template.
type AwsEc2LaunchTemplateDataDetails struct {
	_ struct{} `type:"structure"`

	// Information about a block device mapping for an Amazon EC2 launch template.
	BlockDeviceMappingSet []*AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails `type:"list"`

	// Specifies an instance's Capacity Reservation targeting option. You can specify
	// only one option at a time.
	CapacityReservationSpecification *AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails `type:"structure"`

	// Specifies the CPU options for an instance. For more information, see Optimize
	// CPU options (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	CpuOptions *AwsEc2LaunchTemplateDataCpuOptionsDetails `type:"structure"`

	// Specifies the credit option for CPU usage of a T2, T3, or T3a instance.
	CreditSpecification *AwsEc2LaunchTemplateDataCreditSpecificationDetails `type:"structure"`

	// Indicates whether to enable the instance for stop protection. For more information,
	// see Enable stop protection (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection)
	// in the Amazon EC2 User Guide.
	DisableApiStop *bool `type:"boolean"`

	// If you set this parameter to true, you can't terminate the instance using
	// the Amazon EC2 console, CLI, or API. If set to true, you can.
	DisableApiTermination *bool `type:"boolean"`

	// Indicates whether the instance is optimized for Amazon EBS I/O.
	EbsOptimized *bool `type:"boolean"`

	// Provides details about Elastic Graphics accelerators to associate with the
	// instance.
	ElasticGpuSpecificationSet []*AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails `type:"list"`

	// The Amazon Elastic Inference accelerator for the instance.
	ElasticInferenceAcceleratorSet []*AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails `type:"list"`

	// Indicates whether the Amazon EC2 instance is enabled for Amazon Web Services
	// Nitro Enclaves.
	EnclaveOptions *AwsEc2LaunchTemplateDataEnclaveOptionsDetails `type:"structure"`

	// Specifies whether your Amazon EC2 instance is configured for hibernation.
	HibernationOptions *AwsEc2LaunchTemplateDataHibernationOptionsDetails `type:"structure"`

	// The name or Amazon Resource Name (ARN) of an IAM instance profile.
	IamInstanceProfile *AwsEc2LaunchTemplateDataIamInstanceProfileDetails `type:"structure"`

	// The ID of the Amazon Machine Image (AMI).
	ImageId *string `type:"string"`

	// Provides the options for specifying the instance initiated shutdown behavior.
	InstanceInitiatedShutdownBehavior *string `type:"string"`

	// Specifies the market (purchasing) option for an instance.
	InstanceMarketOptions *AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails `type:"structure"`

	// The attributes for the instance types. When you specify instance attributes,
	// Amazon EC2 will identify instance types with these attributes. If you specify
	// InstanceRequirements, you can't specify InstanceType.
	InstanceRequirements *AwsEc2LaunchTemplateDataInstanceRequirementsDetails `type:"structure"`

	// The instance type. For more information, see Instance types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
	// in the Amazon EC2 User Guide. If you specify InstanceType, you can't specify
	// InstanceRequirements.
	InstanceType *string `type:"string"`

	// The ID of the kernel.
	KernelId *string `type:"string"`

	// The name of the key pair that allows users to connect to the instance.
	KeyName *string `type:"string"`

	// Specifies a license configuration for an instance.
	LicenseSet []*AwsEc2LaunchTemplateDataLicenseSetDetails `type:"list"`

	// The maintenance options of your instance.
	MaintenanceOptions *AwsEc2LaunchTemplateDataMaintenanceOptionsDetails `type:"structure"`

	// The metadata options for the instance. For more information, see Instance
	// metadata and user data (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
	// in the Amazon EC2 User Guide.
	MetadataOptions *AwsEc2LaunchTemplateDataMetadataOptionsDetails `type:"structure"`

	// The monitoring for the instance.
	Monitoring *AwsEc2LaunchTemplateDataMonitoringDetails `type:"structure"`

	// Specifies the parameters for a network interface that is attached to the
	// instance.
	NetworkInterfaceSet []*AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails `type:"list"`

	// Specifies the placement of an instance.
	Placement *AwsEc2LaunchTemplateDataPlacementDetails `type:"structure"`

	// The options for the instance hostname.
	PrivateDnsNameOptions *AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails `type:"structure"`

	// The ID of the RAM disk.
	RamDiskId *string `type:"string"`

	// One or more security group IDs.
	SecurityGroupIdSet []*string `type:"list"`

	// One or more security group names. For a nondefault VPC, you must use security
	// group IDs instead. You cannot specify both a security group ID and security
	// name in the same request.
	SecurityGroupSet []*string `type:"list"`

	// The user data to make available to the instance.
	UserData *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataDetails) GoString() string {
	return s.String()
}

// SetBlockDeviceMappingSet sets the BlockDeviceMappingSet field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetBlockDeviceMappingSet(v []*AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails) *AwsEc2LaunchTemplateDataDetails {
	s.BlockDeviceMappingSet = v
	return s
}

// SetCapacityReservationSpecification sets the CapacityReservationSpecification field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetCapacityReservationSpecification(v *AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails) *AwsEc2LaunchTemplateDataDetails {
	s.CapacityReservationSpecification = v
	return s
}

// SetCpuOptions sets the CpuOptions field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetCpuOptions(v *AwsEc2LaunchTemplateDataCpuOptionsDetails) *AwsEc2LaunchTemplateDataDetails {
	s.CpuOptions = v
	return s
}

// SetCreditSpecification sets the CreditSpecification field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetCreditSpecification(v *AwsEc2LaunchTemplateDataCreditSpecificationDetails) *AwsEc2LaunchTemplateDataDetails {
	s.CreditSpecification = v
	return s
}

// SetDisableApiStop sets the DisableApiStop field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetDisableApiStop(v bool) *AwsEc2LaunchTemplateDataDetails {
	s.DisableApiStop = &v
	return s
}

// SetDisableApiTermination sets the DisableApiTermination field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetDisableApiTermination(v bool) *AwsEc2LaunchTemplateDataDetails {
	s.DisableApiTermination = &v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetEbsOptimized(v bool) *AwsEc2LaunchTemplateDataDetails {
	s.EbsOptimized = &v
	return s
}

// SetElasticGpuSpecificationSet sets the ElasticGpuSpecificationSet field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetElasticGpuSpecificationSet(v []*AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails) *AwsEc2LaunchTemplateDataDetails {
	s.ElasticGpuSpecificationSet = v
	return s
}

// SetElasticInferenceAcceleratorSet sets the ElasticInferenceAcceleratorSet field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetElasticInferenceAcceleratorSet(v []*AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails) *AwsEc2LaunchTemplateDataDetails {
	s.ElasticInferenceAcceleratorSet = v
	return s
}

// SetEnclaveOptions sets the EnclaveOptions field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetEnclaveOptions(v *AwsEc2LaunchTemplateDataEnclaveOptionsDetails) *AwsEc2LaunchTemplateDataDetails {
	s.EnclaveOptions = v
	return s
}

// SetHibernationOptions sets the HibernationOptions field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetHibernationOptions(v *AwsEc2LaunchTemplateDataHibernationOptionsDetails) *AwsEc2LaunchTemplateDataDetails {
	s.HibernationOptions = v
	return s
}

// SetIamInstanceProfile sets the IamInstanceProfile field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetIamInstanceProfile(v *AwsEc2LaunchTemplateDataIamInstanceProfileDetails) *AwsEc2LaunchTemplateDataDetails {
	s.IamInstanceProfile = v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetImageId(v string) *AwsEc2LaunchTemplateDataDetails {
	s.ImageId = &v
	return s
}

// SetInstanceInitiatedShutdownBehavior sets the InstanceInitiatedShutdownBehavior field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetInstanceInitiatedShutdownBehavior(v string) *AwsEc2LaunchTemplateDataDetails {
	s.InstanceInitiatedShutdownBehavior = &v
	return s
}

// SetInstanceMarketOptions sets the InstanceMarketOptions field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetInstanceMarketOptions(v *AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails) *AwsEc2LaunchTemplateDataDetails {
	s.InstanceMarketOptions = v
	return s
}

// SetInstanceRequirements sets the InstanceRequirements field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetInstanceRequirements(v *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) *AwsEc2LaunchTemplateDataDetails {
	s.InstanceRequirements = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetInstanceType(v string) *AwsEc2LaunchTemplateDataDetails {
	s.InstanceType = &v
	return s
}

// SetKernelId sets the KernelId field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetKernelId(v string) *AwsEc2LaunchTemplateDataDetails {
	s.KernelId = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetKeyName(v string) *AwsEc2LaunchTemplateDataDetails {
	s.KeyName = &v
	return s
}

// SetLicenseSet sets the LicenseSet field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetLicenseSet(v []*AwsEc2LaunchTemplateDataLicenseSetDetails) *AwsEc2LaunchTemplateDataDetails {
	s.LicenseSet = v
	return s
}

// SetMaintenanceOptions sets the MaintenanceOptions field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetMaintenanceOptions(v *AwsEc2LaunchTemplateDataMaintenanceOptionsDetails) *AwsEc2LaunchTemplateDataDetails {
	s.MaintenanceOptions = v
	return s
}

// SetMetadataOptions sets the MetadataOptions field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetMetadataOptions(v *AwsEc2LaunchTemplateDataMetadataOptionsDetails) *AwsEc2LaunchTemplateDataDetails {
	s.MetadataOptions = v
	return s
}

// SetMonitoring sets the Monitoring field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetMonitoring(v *AwsEc2LaunchTemplateDataMonitoringDetails) *AwsEc2LaunchTemplateDataDetails {
	s.Monitoring = v
	return s
}

// SetNetworkInterfaceSet sets the NetworkInterfaceSet field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetNetworkInterfaceSet(v []*AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) *AwsEc2LaunchTemplateDataDetails {
	s.NetworkInterfaceSet = v
	return s
}

// SetPlacement sets the Placement field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetPlacement(v *AwsEc2LaunchTemplateDataPlacementDetails) *AwsEc2LaunchTemplateDataDetails {
	s.Placement = v
	return s
}

// SetPrivateDnsNameOptions sets the PrivateDnsNameOptions field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetPrivateDnsNameOptions(v *AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails) *AwsEc2LaunchTemplateDataDetails {
	s.PrivateDnsNameOptions = v
	return s
}

// SetRamDiskId sets the RamDiskId field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetRamDiskId(v string) *AwsEc2LaunchTemplateDataDetails {
	s.RamDiskId = &v
	return s
}

// SetSecurityGroupIdSet sets the SecurityGroupIdSet field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetSecurityGroupIdSet(v []*string) *AwsEc2LaunchTemplateDataDetails {
	s.SecurityGroupIdSet = v
	return s
}

// SetSecurityGroupSet sets the SecurityGroupSet field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetSecurityGroupSet(v []*string) *AwsEc2LaunchTemplateDataDetails {
	s.SecurityGroupSet = v
	return s
}

// SetUserData sets the UserData field's value.
func (s *AwsEc2LaunchTemplateDataDetails) SetUserData(v string) *AwsEc2LaunchTemplateDataDetails {
	s.UserData = &v
	return s
}

// Provides details about an Elastic Graphics specification for an Amazon EC2
// launch template.
type AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails struct {
	_ struct{} `type:"structure"`

	// The type of Elastic Graphics accelerator.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails) SetType(v string) *AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails {
	s.Type = &v
	return s
}

// Provides details for an Amazon Elastic Inference accelerator.
type AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails struct {
	_ struct{} `type:"structure"`

	// The number of Elastic Inference accelerators to attach to the instance.
	Count *int64 `type:"integer"`

	// The type of Elastic Inference accelerator.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails) SetCount(v int64) *AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails {
	s.Count = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails) SetType(v string) *AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails {
	s.Type = &v
	return s
}

// Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
type AwsEc2LaunchTemplateDataEnclaveOptionsDetails struct {
	_ struct{} `type:"structure"`

	// If this parameter is set to true, the instance is enabled for Amazon Web
	// Services Nitro Enclaves.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataEnclaveOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataEnclaveOptionsDetails) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsEc2LaunchTemplateDataEnclaveOptionsDetails) SetEnabled(v bool) *AwsEc2LaunchTemplateDataEnclaveOptionsDetails {
	s.Enabled = &v
	return s
}

// Specifies whether your Amazon EC2 instance is configured for hibernation.
type AwsEc2LaunchTemplateDataHibernationOptionsDetails struct {
	_ struct{} `type:"structure"`

	// If you set this parameter to true, the instance is enabled for hibernation.
	Configured *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataHibernationOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataHibernationOptionsDetails) GoString() string {
	return s.String()
}

// SetConfigured sets the Configured field's value.
func (s *AwsEc2LaunchTemplateDataHibernationOptionsDetails) SetConfigured(v bool) *AwsEc2LaunchTemplateDataHibernationOptionsDetails {
	s.Configured = &v
	return s
}

// Provides details for an Identity and Access Management (IAM) instance profile,
// which is a container for an IAM role for your instance.
type AwsEc2LaunchTemplateDataIamInstanceProfileDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	Arn *string `type:"string"`

	// The name of the instance profile.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataIamInstanceProfileDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataIamInstanceProfileDetails) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AwsEc2LaunchTemplateDataIamInstanceProfileDetails) SetArn(v string) *AwsEc2LaunchTemplateDataIamInstanceProfileDetails {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEc2LaunchTemplateDataIamInstanceProfileDetails) SetName(v string) *AwsEc2LaunchTemplateDataIamInstanceProfileDetails {
	s.Name = &v
	return s
}

// Provides details about the market (purchasing) option for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails struct {
	_ struct{} `type:"structure"`

	// The market type.
	MarketType *string `type:"string"`

	// The options for Spot Instances.
	SpotOptions *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails) GoString() string {
	return s.String()
}

// SetMarketType sets the MarketType field's value.
func (s *AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails) SetMarketType(v string) *AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails {
	s.MarketType = &v
	return s
}

// SetSpotOptions sets the SpotOptions field's value.
func (s *AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails) SetSpotOptions(v *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails) *AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails {
	s.SpotOptions = v
	return s
}

// Provides details about the market (purchasing) options for Spot Instances.
type AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails struct {
	_ struct{} `type:"structure"`

	// Deprecated.
	BlockDurationMinutes *int64 `type:"integer"`

	// The behavior when a Spot Instance is interrupted.
	InstanceInterruptionBehavior *string `type:"string"`

	// The maximum hourly price you're willing to pay for the Spot Instances.
	MaxPrice *string `type:"string"`

	// The Spot Instance request type.
	SpotInstanceType *string `type:"string"`

	// The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ), for persistent
	// requests.
	ValidUntil *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails) GoString() string {
	return s.String()
}

// SetBlockDurationMinutes sets the BlockDurationMinutes field's value.
func (s *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails) SetBlockDurationMinutes(v int64) *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails {
	s.BlockDurationMinutes = &v
	return s
}

// SetInstanceInterruptionBehavior sets the InstanceInterruptionBehavior field's value.
func (s *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails) SetInstanceInterruptionBehavior(v string) *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails {
	s.InstanceInterruptionBehavior = &v
	return s
}

// SetMaxPrice sets the MaxPrice field's value.
func (s *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails) SetMaxPrice(v string) *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails {
	s.MaxPrice = &v
	return s
}

// SetSpotInstanceType sets the SpotInstanceType field's value.
func (s *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails) SetSpotInstanceType(v string) *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails {
	s.SpotInstanceType = &v
	return s
}

// SetValidUntil sets the ValidUntil field's value.
func (s *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails) SetValidUntil(v string) *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails {
	s.ValidUntil = &v
	return s
}

// The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web
// Services Inferentia chips) on an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails struct {
	_ struct{} `type:"structure"`

	// The maximum number of accelerators. If this parameter isn't specified, there's
	// no maximum limit. To exclude accelerator-enabled instance types, set Max
	// to 0.
	Max *int64 `type:"integer"`

	// The minimum number of accelerators. If this parameter isn't specified, there's
	// no minimum limit.
	Min *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails) SetMax(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails) SetMin(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails {
	s.Min = &v
	return s
}

// The minimum and maximum amount of memory, in MiB, for the accelerators on
// an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails struct {
	_ struct{} `type:"structure"`

	// The maximum amount of memory, in MiB. If this parameter isn't specified,
	// there's no maximum limit.
	Max *int64 `type:"integer"`

	// The minimum amount of memory, in MiB. If 0 is specified, there's no maximum
	// limit.
	Min *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails) SetMax(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails) SetMin(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails {
	s.Min = &v
	return s
}

// The minimum and maximum baseline bandwidth to Amazon Elastic Block Store
// (Amazon EBS), in Mbps. For more information, see Amazon EBS–optimized instances
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html)
// in the Amazon EC2 User Guide.
type AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails struct {
	_ struct{} `type:"structure"`

	// The maximum baseline bandwidth, in Mbps. If this parameter is omitted, there's
	// no maximum limit.
	Max *int64 `type:"integer"`

	// The minimum baseline bandwidth, in Mbps. If this parameter is omitted, there's
	// no minimum limit.
	Min *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails) SetMax(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails) SetMin(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails {
	s.Min = &v
	return s
}

// The attributes for the Amazon EC2 instance types.
type AwsEc2LaunchTemplateDataInstanceRequirementsDetails struct {
	_ struct{} `type:"structure"`

	// The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web
	// Services Inferentia chips) on an instance.
	AcceleratorCount *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails `type:"structure"`

	// Indicates whether instance types must have accelerators by specific manufacturers.
	AcceleratorManufacturers []*string `type:"list"`

	// The accelerators that must be on the instance type.
	AcceleratorNames []*string `type:"list"`

	// The minimum and maximum amount of total accelerator memory, in MiB.
	AcceleratorTotalMemoryMiB *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails `type:"structure"`

	// The accelerator types that must be on the instance type.
	AcceleratorTypes []*string `type:"list"`

	// Indicates whether bare metal instance types must be included, excluded, or
	// required.
	BareMetal *string `type:"string"`

	// The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more
	// information, see Amazon EBS optimized instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html)
	// in the Amazon EC2 User Guide.
	BaselineEbsBandwidthMbps *AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails `type:"structure"`

	// Indicates whether burstable performance T instance types are included, excluded,
	// or required. For more information, Burstable performance instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
	// in the Amazon EC2 User Guide.
	BurstablePerformance *string `type:"string"`

	// The CPU manufacturers to include.
	CpuManufacturers []*string `type:"list"`

	// The instance types to exclude.
	ExcludedInstanceTypes []*string `type:"list"`

	// Indicates whether current or previous generation instance types are included.
	InstanceGenerations []*string `type:"list"`

	// Indicates whether instance types with instance store volumes are included,
	// excluded, or required. For more information, see Amazon EC2 instance store
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html)
	// in the Amazon EC2 User Guide.
	LocalStorage *string `type:"string"`

	// The type of local storage that is required.
	LocalStorageTypes []*string `type:"list"`

	// The minimum and maximum amount of memory per vCPU, in GiB.
	MemoryGiBPerVCpu *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails `type:"structure"`

	// The minimum and maximum amount of memory, in MiB.
	MemoryMiB *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails `type:"structure"`

	// The minimum and maximum number of network interfaces.
	NetworkInterfaceCount *AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails `type:"structure"`

	// The price protection threshold for On-Demand Instances. This is the maximum
	// you'll pay for an On-Demand Instance, expressed as a percentage above the
	// least expensive current generation M, C, or R instance type with your specified
	// attributes. When Amazon EC2 selects instance types with your attributes,
	// it excludes instance types priced above your threshold.
	//
	// The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
	//
	// A high value, such as 999999, turns off price protection.
	OnDemandMaxPricePercentageOverLowestPrice *int64 `type:"integer"`

	// Indicates whether instance types must support hibernation for On-Demand Instances.
	RequireHibernateSupport *bool `type:"boolean"`

	// The price protection threshold for Spot Instances. This is the maximum you'll
	// pay for a Spot Instance, expressed as a percentage above the least expensive
	// current generation M, C, or R instance type with your specified attributes.
	// When Amazon EC2 selects instance types with your attributes, it excludes
	// instance types priced above your threshold.
	//
	// The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
	//
	// A high value, such as 999999, turns off price protection.
	SpotMaxPricePercentageOverLowestPrice *int64 `type:"integer"`

	// The minimum and maximum amount of total local storage, in GB.
	TotalLocalStorageGB *AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails `type:"structure"`

	// The minimum and maximum number of vCPUs.
	VCpuCount *AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsDetails) GoString() string {
	return s.String()
}

// SetAcceleratorCount sets the AcceleratorCount field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetAcceleratorCount(v *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.AcceleratorCount = v
	return s
}

// SetAcceleratorManufacturers sets the AcceleratorManufacturers field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetAcceleratorManufacturers(v []*string) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.AcceleratorManufacturers = v
	return s
}

// SetAcceleratorNames sets the AcceleratorNames field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetAcceleratorNames(v []*string) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.AcceleratorNames = v
	return s
}

// SetAcceleratorTotalMemoryMiB sets the AcceleratorTotalMemoryMiB field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetAcceleratorTotalMemoryMiB(v *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.AcceleratorTotalMemoryMiB = v
	return s
}

// SetAcceleratorTypes sets the AcceleratorTypes field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetAcceleratorTypes(v []*string) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.AcceleratorTypes = v
	return s
}

// SetBareMetal sets the BareMetal field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetBareMetal(v string) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.BareMetal = &v
	return s
}

// SetBaselineEbsBandwidthMbps sets the BaselineEbsBandwidthMbps field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetBaselineEbsBandwidthMbps(v *AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.BaselineEbsBandwidthMbps = v
	return s
}

// SetBurstablePerformance sets the BurstablePerformance field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetBurstablePerformance(v string) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.BurstablePerformance = &v
	return s
}

// SetCpuManufacturers sets the CpuManufacturers field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetCpuManufacturers(v []*string) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.CpuManufacturers = v
	return s
}

// SetExcludedInstanceTypes sets the ExcludedInstanceTypes field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetExcludedInstanceTypes(v []*string) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.ExcludedInstanceTypes = v
	return s
}

// SetInstanceGenerations sets the InstanceGenerations field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetInstanceGenerations(v []*string) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.InstanceGenerations = v
	return s
}

// SetLocalStorage sets the LocalStorage field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetLocalStorage(v string) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.LocalStorage = &v
	return s
}

// SetLocalStorageTypes sets the LocalStorageTypes field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetLocalStorageTypes(v []*string) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.LocalStorageTypes = v
	return s
}

// SetMemoryGiBPerVCpu sets the MemoryGiBPerVCpu field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetMemoryGiBPerVCpu(v *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.MemoryGiBPerVCpu = v
	return s
}

// SetMemoryMiB sets the MemoryMiB field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetMemoryMiB(v *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.MemoryMiB = v
	return s
}

// SetNetworkInterfaceCount sets the NetworkInterfaceCount field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetNetworkInterfaceCount(v *AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.NetworkInterfaceCount = v
	return s
}

// SetOnDemandMaxPricePercentageOverLowestPrice sets the OnDemandMaxPricePercentageOverLowestPrice field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetOnDemandMaxPricePercentageOverLowestPrice(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.OnDemandMaxPricePercentageOverLowestPrice = &v
	return s
}

// SetRequireHibernateSupport sets the RequireHibernateSupport field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetRequireHibernateSupport(v bool) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.RequireHibernateSupport = &v
	return s
}

// SetSpotMaxPricePercentageOverLowestPrice sets the SpotMaxPricePercentageOverLowestPrice field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetSpotMaxPricePercentageOverLowestPrice(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.SpotMaxPricePercentageOverLowestPrice = &v
	return s
}

// SetTotalLocalStorageGB sets the TotalLocalStorageGB field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetTotalLocalStorageGB(v *AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.TotalLocalStorageGB = v
	return s
}

// SetVCpuCount sets the VCpuCount field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsDetails) SetVCpuCount(v *AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails) *AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
	s.VCpuCount = v
	return s
}

// The minimum and maximum amount of memory per vCPU, in GiB.
type AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails struct {
	_ struct{} `type:"structure"`

	// The maximum amount of memory per vCPU, in GiB. If this parameter is omitted,
	// there's no maximum limit.
	Max *float64 `type:"double"`

	// The minimum amount of memory per vCPU, in GiB. If this parameter is omitted,
	// there's no maximum limit.
	Min *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails) SetMax(v float64) *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails) SetMin(v float64) *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails {
	s.Min = &v
	return s
}

// The minimum and maximum amount of memory, in MiB, for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails struct {
	_ struct{} `type:"structure"`

	// The maximum amount of memory, in MiB.
	Max *int64 `type:"integer"`

	// The minimum amount of memory, in MiB.
	Min *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails) SetMax(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails) SetMin(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails {
	s.Min = &v
	return s
}

// The minimum and maximum number of network interfaces to be attached to an
// Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails struct {
	_ struct{} `type:"structure"`

	// The maximum number of network interfaces.
	Max *int64 `type:"integer"`

	// The minimum number of network interfaces.
	Min *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails) SetMax(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails) SetMin(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails {
	s.Min = &v
	return s
}

// The minimum and maximum amount of total local storage, in GB, that an Amazon
// EC2 instance uses.
type AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails struct {
	_ struct{} `type:"structure"`

	// The maximum amount of total local storage, in GB.
	Max *float64 `type:"double"`

	// The minimum amount of total local storage, in GB.
	Min *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails) SetMax(v float64) *AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails) SetMin(v float64) *AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails {
	s.Min = &v
	return s
}

// The minimum and maximum number of vCPUs for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails struct {
	_ struct{} `type:"structure"`

	// The maximum number of vCPUs.
	Max *int64 `type:"integer"`

	// The minimum number of vCPUs.
	Min *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails) SetMax(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails) SetMin(v int64) *AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails {
	s.Min = &v
	return s
}

// Provides details about the license configuration for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataLicenseSetDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the license configuration.
	LicenseConfigurationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataLicenseSetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataLicenseSetDetails) GoString() string {
	return s.String()
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *AwsEc2LaunchTemplateDataLicenseSetDetails) SetLicenseConfigurationArn(v string) *AwsEc2LaunchTemplateDataLicenseSetDetails {
	s.LicenseConfigurationArn = &v
	return s
}

// The maintenance options of an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataMaintenanceOptionsDetails struct {
	_ struct{} `type:"structure"`

	// Disables the automatic recovery behavior of your instance or sets it to default.
	AutoRecovery *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataMaintenanceOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataMaintenanceOptionsDetails) GoString() string {
	return s.String()
}

// SetAutoRecovery sets the AutoRecovery field's value.
func (s *AwsEc2LaunchTemplateDataMaintenanceOptionsDetails) SetAutoRecovery(v string) *AwsEc2LaunchTemplateDataMaintenanceOptionsDetails {
	s.AutoRecovery = &v
	return s
}

// Specifies the metadata options for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataMetadataOptionsDetails struct {
	_ struct{} `type:"structure"`

	// Enables or disables the HTTP metadata endpoint on your instances. If the
	// parameter is not specified, the default state is enabled, and you won't be
	// able to access your instance metadata.
	HttpEndpoint *string `type:"string"`

	// Enables or disables the IPv6 endpoint for the instance metadata service.
	HttpProtocolIpv6 *string `type:"string"`

	// The desired HTTP PUT response hop limit for instance metadata requests. The
	// larger the number, the further instance metadata requests can travel.
	HttpPutResponseHopLimit *int64 `type:"integer"`

	// The state of token usage for your instance metadata requests.
	HttpTokens *string `type:"string"`

	// When set to enabled, this parameter allows access to instance tags from the
	// instance metadata. When set to disabled, it turns off access to instance
	// tags from the instance metadata. For more information, see Work with instance
	// tags in instance metadata (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS)
	// in the Amazon EC2 User Guide.
	InstanceMetadataTags *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataMetadataOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataMetadataOptionsDetails) GoString() string {
	return s.String()
}

// SetHttpEndpoint sets the HttpEndpoint field's value.
func (s *AwsEc2LaunchTemplateDataMetadataOptionsDetails) SetHttpEndpoint(v string) *AwsEc2LaunchTemplateDataMetadataOptionsDetails {
	s.HttpEndpoint = &v
	return s
}

// SetHttpProtocolIpv6 sets the HttpProtocolIpv6 field's value.
func (s *AwsEc2LaunchTemplateDataMetadataOptionsDetails) SetHttpProtocolIpv6(v string) *AwsEc2LaunchTemplateDataMetadataOptionsDetails {
	s.HttpProtocolIpv6 = &v
	return s
}

// SetHttpPutResponseHopLimit sets the HttpPutResponseHopLimit field's value.
func (s *AwsEc2LaunchTemplateDataMetadataOptionsDetails) SetHttpPutResponseHopLimit(v int64) *AwsEc2LaunchTemplateDataMetadataOptionsDetails {
	s.HttpPutResponseHopLimit = &v
	return s
}

// SetHttpTokens sets the HttpTokens field's value.
func (s *AwsEc2LaunchTemplateDataMetadataOptionsDetails) SetHttpTokens(v string) *AwsEc2LaunchTemplateDataMetadataOptionsDetails {
	s.HttpTokens = &v
	return s
}

// SetInstanceMetadataTags sets the InstanceMetadataTags field's value.
func (s *AwsEc2LaunchTemplateDataMetadataOptionsDetails) SetInstanceMetadataTags(v string) *AwsEc2LaunchTemplateDataMetadataOptionsDetails {
	s.InstanceMetadataTags = &v
	return s
}

// The monitoring for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataMonitoringDetails struct {
	_ struct{} `type:"structure"`

	// Enables detailed monitoring when true is specified. Otherwise, basic monitoring
	// is enabled. For more information about detailed monitoring, see Enable or
	// turn off detailed monitoring for your instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html)
	// in the Amazon EC2 User Guide.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataMonitoringDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataMonitoringDetails) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsEc2LaunchTemplateDataMonitoringDetails) SetEnabled(v bool) *AwsEc2LaunchTemplateDataMonitoringDetails {
	s.Enabled = &v
	return s
}

// One or more network interfaces to attach to an Amazon EC2 instance. If you
// specify a network interface, you must specify security groups and subnets
// as part of the network interface.
type AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether to associate a Carrier IP address with eth0 for a new network
	// interface. You use this option when you launch an instance in a Wavelength
	// Zone and want to associate a Carrier IP address with the network interface.
	// For more information, see Carrier IP address (https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip)
	// in the Wavelength Developer Guide.
	AssociateCarrierIpAddress *bool `type:"boolean"`

	// Associates a public IPv4 address with eth0 for a new network interface.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// A description for the network interface.
	Description *string `type:"string"`

	// The device index for the network interface attachment.
	DeviceIndex *int64 `type:"integer"`

	// The IDs of one or more security groups.
	Groups []*string `type:"list"`

	// The type of network interface.
	InterfaceType *string `type:"string"`

	// The number of IPv4 prefixes to be automatically assigned to the network interface.
	// You cannot use this option if you use the Ipv4Prefixes option.
	Ipv4PrefixCount *int64 `type:"integer"`

	// One or more IPv4 prefixes to be assigned to the network interface. You cannot
	// use this option if you use the Ipv4PrefixCount option.
	Ipv4Prefixes []*AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails `type:"list"`

	// The number of IPv6 addresses to assign to a network interface. Amazon EC2
	// automatically selects the IPv6 addresses from the subnet range. You can't
	// use this option if you use Ipv6Addresses.
	Ipv6AddressCount *int64 `type:"integer"`

	// One or more specific IPv6 addresses from the IPv6 CIDR block range of your
	// subnet. You can't use this option if you use Ipv6AddressCount.
	Ipv6Addresses []*AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails `type:"list"`

	// The number of IPv6 prefixes to be automatically assigned to the network interface.
	// You cannot use this option if you use the Ipv6Prefix option.
	Ipv6PrefixCount *int64 `type:"integer"`

	// One or more IPv6 prefixes to be assigned to the network interface. You cannot
	// use this option if you use the Ipv6PrefixCount option.
	Ipv6Prefixes []*AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails `type:"list"`

	// The index of the network card. Some instance types support multiple network
	// cards. The primary network interface must be assigned to network card index
	// 0. The default is network card index 0.
	NetworkCardIndex *int64 `type:"integer"`

	// The ID of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// The primary private IPv4 address of the network interface.
	PrivateIpAddress *string `type:"string"`

	// One or more private IPv4 addresses.
	PrivateIpAddresses []*AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails `type:"list"`

	// The number of secondary private IPv4 addresses to assign to a network interface.
	SecondaryPrivateIpAddressCount *int64 `type:"integer"`

	// The ID of the subnet for the network interface.
	SubnetId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) GoString() string {
	return s.String()
}

// SetAssociateCarrierIpAddress sets the AssociateCarrierIpAddress field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetAssociateCarrierIpAddress(v bool) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.AssociateCarrierIpAddress = &v
	return s
}

// SetAssociatePublicIpAddress sets the AssociatePublicIpAddress field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetAssociatePublicIpAddress(v bool) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.AssociatePublicIpAddress = &v
	return s
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetDeleteOnTermination(v bool) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.DeleteOnTermination = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetDescription(v string) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.Description = &v
	return s
}

// SetDeviceIndex sets the DeviceIndex field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetDeviceIndex(v int64) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.DeviceIndex = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetGroups(v []*string) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.Groups = v
	return s
}

// SetInterfaceType sets the InterfaceType field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetInterfaceType(v string) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.InterfaceType = &v
	return s
}

// SetIpv4PrefixCount sets the Ipv4PrefixCount field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetIpv4PrefixCount(v int64) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.Ipv4PrefixCount = &v
	return s
}

// SetIpv4Prefixes sets the Ipv4Prefixes field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetIpv4Prefixes(v []*AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.Ipv4Prefixes = v
	return s
}

// SetIpv6AddressCount sets the Ipv6AddressCount field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetIpv6AddressCount(v int64) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.Ipv6AddressCount = &v
	return s
}

// SetIpv6Addresses sets the Ipv6Addresses field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetIpv6Addresses(v []*AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.Ipv6Addresses = v
	return s
}

// SetIpv6PrefixCount sets the Ipv6PrefixCount field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetIpv6PrefixCount(v int64) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.Ipv6PrefixCount = &v
	return s
}

// SetIpv6Prefixes sets the Ipv6Prefixes field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetIpv6Prefixes(v []*AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.Ipv6Prefixes = v
	return s
}

// SetNetworkCardIndex sets the NetworkCardIndex field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetNetworkCardIndex(v int64) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.NetworkCardIndex = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetNetworkInterfaceId(v string) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.NetworkInterfaceId = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetPrivateIpAddress(v string) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.PrivateIpAddress = &v
	return s
}

// SetPrivateIpAddresses sets the PrivateIpAddresses field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetPrivateIpAddresses(v []*AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.PrivateIpAddresses = v
	return s
}

// SetSecondaryPrivateIpAddressCount sets the SecondaryPrivateIpAddressCount field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetSecondaryPrivateIpAddressCount(v int64) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.SecondaryPrivateIpAddressCount = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) SetSubnetId(v string) *AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
	s.SubnetId = &v
	return s
}

// Provides details on one or more IPv4 prefixes for a network interface.
type AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails struct {
	_ struct{} `type:"structure"`

	// The IPv4 prefix. For more information, see Assigning prefixes to Amazon EC2
	// network interfaces (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	Ipv4Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails) GoString() string {
	return s.String()
}

// SetIpv4Prefix sets the Ipv4Prefix field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails) SetIpv4Prefix(v string) *AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails {
	s.Ipv4Prefix = &v
	return s
}

// Specifies an IPv6 address in an Amazon EC2 launch template.
type AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails struct {
	_ struct{} `type:"structure"`

	// One or more specific IPv6 addresses from the IPv6 CIDR block range of your
	// subnet.
	Ipv6Address *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails) GoString() string {
	return s.String()
}

// SetIpv6Address sets the Ipv6Address field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails) SetIpv6Address(v string) *AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails {
	s.Ipv6Address = &v
	return s
}

// Provides details on one or more IPv6 prefixes to be assigned to the network
// interface.
type AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails struct {
	_ struct{} `type:"structure"`

	// The IPv6 prefix.
	Ipv6Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails) GoString() string {
	return s.String()
}

// SetIpv6Prefix sets the Ipv6Prefix field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails) SetIpv6Prefix(v string) *AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails {
	s.Ipv6Prefix = &v
	return s
}

// One or more private IPv4 addresses.
type AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether the private IPv4 address is the primary private IPv4 address.
	// Only one IPv4 address can be designated as primary.
	Primary *bool `type:"boolean"`

	// The private IPv4 address.
	PrivateIpAddress *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails) GoString() string {
	return s.String()
}

// SetPrimary sets the Primary field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails) SetPrimary(v bool) *AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails {
	s.Primary = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails) SetPrivateIpAddress(v string) *AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails {
	s.PrivateIpAddress = &v
	return s
}

// Provides details about the placement of an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataPlacementDetails struct {
	_ struct{} `type:"structure"`

	// The affinity setting for an instance on an EC2 Dedicated Host.
	Affinity *string `type:"string"`

	// The Availability Zone for the instance.
	AvailabilityZone *string `type:"string"`

	// The name of the placement group for the instance.
	GroupName *string `type:"string"`

	// The ID of the Dedicated Host for the instance.
	HostId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the host resource group in which to launch
	// the instances.
	HostResourceGroupArn *string `type:"string"`

	// The number of the partition the instance should launch in.
	PartitionNumber *int64 `type:"integer"`

	// Reserved for future use.
	SpreadDomain *string `type:"string"`

	// The tenancy of the instance (if the instance is running in a VPC). An instance
	// with a tenancy of dedicated runs on single-tenant hardware.
	Tenancy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataPlacementDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataPlacementDetails) GoString() string {
	return s.String()
}

// SetAffinity sets the Affinity field's value.
func (s *AwsEc2LaunchTemplateDataPlacementDetails) SetAffinity(v string) *AwsEc2LaunchTemplateDataPlacementDetails {
	s.Affinity = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *AwsEc2LaunchTemplateDataPlacementDetails) SetAvailabilityZone(v string) *AwsEc2LaunchTemplateDataPlacementDetails {
	s.AvailabilityZone = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2LaunchTemplateDataPlacementDetails) SetGroupName(v string) *AwsEc2LaunchTemplateDataPlacementDetails {
	s.GroupName = &v
	return s
}

// SetHostId sets the HostId field's value.
func (s *AwsEc2LaunchTemplateDataPlacementDetails) SetHostId(v string) *AwsEc2LaunchTemplateDataPlacementDetails {
	s.HostId = &v
	return s
}

// SetHostResourceGroupArn sets the HostResourceGroupArn field's value.
func (s *AwsEc2LaunchTemplateDataPlacementDetails) SetHostResourceGroupArn(v string) *AwsEc2LaunchTemplateDataPlacementDetails {
	s.HostResourceGroupArn = &v
	return s
}

// SetPartitionNumber sets the PartitionNumber field's value.
func (s *AwsEc2LaunchTemplateDataPlacementDetails) SetPartitionNumber(v int64) *AwsEc2LaunchTemplateDataPlacementDetails {
	s.PartitionNumber = &v
	return s
}

// SetSpreadDomain sets the SpreadDomain field's value.
func (s *AwsEc2LaunchTemplateDataPlacementDetails) SetSpreadDomain(v string) *AwsEc2LaunchTemplateDataPlacementDetails {
	s.SpreadDomain = &v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *AwsEc2LaunchTemplateDataPlacementDetails) SetTenancy(v string) *AwsEc2LaunchTemplateDataPlacementDetails {
	s.Tenancy = &v
	return s
}

// Describes the options for Amazon EC2 instance hostnames.
type AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether to respond to DNS queries for instance hostnames with DNS
	// AAAA records.
	EnableResourceNameDnsAAAARecord *bool `type:"boolean"`

	// Indicates whether to respond to DNS queries for instance hostnames with DNS
	// A records.
	EnableResourceNameDnsARecord *bool `type:"boolean"`

	// The type of hostname for EC2 instances.
	HostnameType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails) GoString() string {
	return s.String()
}

// SetEnableResourceNameDnsAAAARecord sets the EnableResourceNameDnsAAAARecord field's value.
func (s *AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails) SetEnableResourceNameDnsAAAARecord(v bool) *AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails {
	s.EnableResourceNameDnsAAAARecord = &v
	return s
}

// SetEnableResourceNameDnsARecord sets the EnableResourceNameDnsARecord field's value.
func (s *AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails) SetEnableResourceNameDnsARecord(v bool) *AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails {
	s.EnableResourceNameDnsARecord = &v
	return s
}

// SetHostnameType sets the HostnameType field's value.
func (s *AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails) SetHostnameType(v string) *AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails {
	s.HostnameType = &v
	return s
}

// Specifies the properties for creating an Amazon Elastic Compute Cloud (Amazon
// EC2) launch template.
type AwsEc2LaunchTemplateDetails struct {
	_ struct{} `type:"structure"`

	// The default version of the launch template.
	DefaultVersionNumber *int64 `type:"long"`

	// An ID for the launch template.
	Id *string `type:"string"`

	// The latest version of the launch template.
	LatestVersionNumber *int64 `type:"long"`

	// The information to include in the launch template.
	LaunchTemplateData *AwsEc2LaunchTemplateDataDetails `type:"structure"`

	// A name for the launch template.
	LaunchTemplateName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2LaunchTemplateDetails) GoString() string {
	return s.String()
}

// SetDefaultVersionNumber sets the DefaultVersionNumber field's value.
func (s *AwsEc2LaunchTemplateDetails) SetDefaultVersionNumber(v int64) *AwsEc2LaunchTemplateDetails {
	s.DefaultVersionNumber = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsEc2LaunchTemplateDetails) SetId(v string) *AwsEc2LaunchTemplateDetails {
	s.Id = &v
	return s
}

// SetLatestVersionNumber sets the LatestVersionNumber field's value.
func (s *AwsEc2LaunchTemplateDetails) SetLatestVersionNumber(v int64) *AwsEc2LaunchTemplateDetails {
	s.LatestVersionNumber = &v
	return s
}

// SetLaunchTemplateData sets the LaunchTemplateData field's value.
func (s *AwsEc2LaunchTemplateDetails) SetLaunchTemplateData(v *AwsEc2LaunchTemplateDataDetails) *AwsEc2LaunchTemplateDetails {
	s.LaunchTemplateData = v
	return s
}

// SetLaunchTemplateName sets the LaunchTemplateName field's value.
func (s *AwsEc2LaunchTemplateDetails) SetLaunchTemplateName(v string) *AwsEc2LaunchTemplateDetails {
	s.LaunchTemplateName = &v
	return s
}

// An association between the network ACL and a subnet.
type AwsEc2NetworkAclAssociation struct {
	_ struct{} `type:"structure"`

	// The identifier of the association between the network ACL and the subnet.
	NetworkAclAssociationId *string `type:"string"`

	// The identifier of the network ACL.
	NetworkAclId *string `type:"string"`

	// The identifier of the subnet that is associated with the network ACL.
	SubnetId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclAssociation) GoString() string {
	return s.String()
}

// SetNetworkAclAssociationId sets the NetworkAclAssociationId field's value.
func (s *AwsEc2NetworkAclAssociation) SetNetworkAclAssociationId(v string) *AwsEc2NetworkAclAssociation {
	s.NetworkAclAssociationId = &v
	return s
}

// SetNetworkAclId sets the NetworkAclId field's value.
func (s *AwsEc2NetworkAclAssociation) SetNetworkAclId(v string) *AwsEc2NetworkAclAssociation {
	s.NetworkAclId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2NetworkAclAssociation) SetSubnetId(v string) *AwsEc2NetworkAclAssociation {
	s.SubnetId = &v
	return s
}

// Contains details about an Amazon EC2 network access control list (ACL).
type AwsEc2NetworkAclDetails struct {
	_ struct{} `type:"structure"`

	// Associations between the network ACL and subnets.
	Associations []*AwsEc2NetworkAclAssociation `type:"list"`

	// The set of rules in the network ACL.
	Entries []*AwsEc2NetworkAclEntry `type:"list"`

	// Whether this is the default network ACL for the VPC.
	IsDefault *bool `type:"boolean"`

	// The identifier of the network ACL.
	NetworkAclId *string `type:"string"`

	// The identifier of the Amazon Web Services account that owns the network ACL.
	OwnerId *string `type:"string"`

	// The identifier of the VPC for the network ACL.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclDetails) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *AwsEc2NetworkAclDetails) SetAssociations(v []*AwsEc2NetworkAclAssociation) *AwsEc2NetworkAclDetails {
	s.Associations = v
	return s
}

// SetEntries sets the Entries field's value.
func (s *AwsEc2NetworkAclDetails) SetEntries(v []*AwsEc2NetworkAclEntry) *AwsEc2NetworkAclDetails {
	s.Entries = v
	return s
}

// SetIsDefault sets the IsDefault field's value.
func (s *AwsEc2NetworkAclDetails) SetIsDefault(v bool) *AwsEc2NetworkAclDetails {
	s.IsDefault = &v
	return s
}

// SetNetworkAclId sets the NetworkAclId field's value.
func (s *AwsEc2NetworkAclDetails) SetNetworkAclId(v string) *AwsEc2NetworkAclDetails {
	s.NetworkAclId = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsEc2NetworkAclDetails) SetOwnerId(v string) *AwsEc2NetworkAclDetails {
	s.OwnerId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2NetworkAclDetails) SetVpcId(v string) *AwsEc2NetworkAclDetails {
	s.VpcId = &v
	return s
}

// A rule for the network ACL. Each rule allows or denies access based on the
// IP address, traffic direction, port, and protocol.
type AwsEc2NetworkAclEntry struct {
	_ struct{} `type:"structure"`

	// The IPV4 network range for which to deny or allow access.
	CidrBlock *string `type:"string"`

	// Whether the rule is an egress rule. An egress rule is a rule that applies
	// to traffic that leaves the subnet.
	Egress *bool `type:"boolean"`

	// The Internet Control Message Protocol (ICMP) type and code for which to deny
	// or allow access.
	IcmpTypeCode *IcmpTypeCode `type:"structure"`

	// The IPV6 network range for which to deny or allow access.
	Ipv6CidrBlock *string `type:"string"`

	// For TCP or UDP protocols, the range of ports that the rule applies to.
	PortRange *PortRangeFromTo `type:"structure"`

	// The protocol that the rule applies to. To deny or allow access to all protocols,
	// use the value -1.
	Protocol *string `type:"string"`

	// Whether the rule is used to allow access or deny access.
	RuleAction *string `type:"string"`

	// The rule number. The rules are processed in order by their number.
	RuleNumber *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclEntry) GoString() string {
	return s.String()
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *AwsEc2NetworkAclEntry) SetCidrBlock(v string) *AwsEc2NetworkAclEntry {
	s.CidrBlock = &v
	return s
}

// SetEgress sets the Egress field's value.
func (s *AwsEc2NetworkAclEntry) SetEgress(v bool) *AwsEc2NetworkAclEntry {
	s.Egress = &v
	return s
}

// SetIcmpTypeCode sets the IcmpTypeCode field's value.
func (s *AwsEc2NetworkAclEntry) SetIcmpTypeCode(v *IcmpTypeCode) *AwsEc2NetworkAclEntry {
	s.IcmpTypeCode = v
	return s
}

// SetIpv6CidrBlock sets the Ipv6CidrBlock field's value.
func (s *AwsEc2NetworkAclEntry) SetIpv6CidrBlock(v string) *AwsEc2NetworkAclEntry {
	s.Ipv6CidrBlock = &v
	return s
}

// SetPortRange sets the PortRange field's value.
func (s *AwsEc2NetworkAclEntry) SetPortRange(v *PortRangeFromTo) *AwsEc2NetworkAclEntry {
	s.PortRange = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AwsEc2NetworkAclEntry) SetProtocol(v string) *AwsEc2NetworkAclEntry {
	s.Protocol = &v
	return s
}

// SetRuleAction sets the RuleAction field's value.
func (s *AwsEc2NetworkAclEntry) SetRuleAction(v string) *AwsEc2NetworkAclEntry {
	s.RuleAction = &v
	return s
}

// SetRuleNumber sets the RuleNumber field's value.
func (s *AwsEc2NetworkAclEntry) SetRuleNumber(v int64) *AwsEc2NetworkAclEntry {
	s.RuleNumber = &v
	return s
}

// Information about the network interface attachment.
type AwsEc2NetworkInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// Indicates when the attachment initiated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	AttachTime *string `type:"string"`

	// The identifier of the network interface attachment
	AttachmentId *string `type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// The device index of the network interface attachment on the instance.
	DeviceIndex *int64 `type:"integer"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The Amazon Web Services account ID of the owner of the instance.
	InstanceOwnerId *string `type:"string"`

	// The attachment state.
	//
	// Valid values: attaching | attached | detaching | detached
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceAttachment) GoString() string {
	return s.String()
}

// SetAttachTime sets the AttachTime field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetAttachTime(v string) *AwsEc2NetworkInterfaceAttachment {
	s.AttachTime = &v
	return s
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetAttachmentId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.AttachmentId = &v
	return s
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetDeleteOnTermination(v bool) *AwsEc2NetworkInterfaceAttachment {
	s.DeleteOnTermination = &v
	return s
}

// SetDeviceIndex sets the DeviceIndex field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetDeviceIndex(v int64) *AwsEc2NetworkInterfaceAttachment {
	s.DeviceIndex = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetInstanceId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.InstanceId = &v
	return s
}

// SetInstanceOwnerId sets the InstanceOwnerId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetInstanceOwnerId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.InstanceOwnerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetStatus(v string) *AwsEc2NetworkInterfaceAttachment {
	s.Status = &v
	return s
}

// Details about the network interface
type AwsEc2NetworkInterfaceDetails struct {
	_ struct{} `type:"structure"`

	// The network interface attachment.
	Attachment *AwsEc2NetworkInterfaceAttachment `type:"structure"`

	// The IPv6 addresses associated with the network interface.
	IpV6Addresses []*AwsEc2NetworkInterfaceIpV6AddressDetail `type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// The private IPv4 addresses associated with the network interface.
	PrivateIpAddresses []*AwsEc2NetworkInterfacePrivateIpAddressDetail `type:"list"`

	// The public DNS name of the network interface.
	PublicDnsName *string `type:"string"`

	// The address of the Elastic IP address bound to the network interface.
	PublicIp *string `type:"string"`

	// Security groups for the network interface.
	SecurityGroups []*AwsEc2NetworkInterfaceSecurityGroup `type:"list"`

	// Indicates whether traffic to or from the instance is validated.
	SourceDestCheck *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceDetails) GoString() string {
	return s.String()
}

// SetAttachment sets the Attachment field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetAttachment(v *AwsEc2NetworkInterfaceAttachment) *AwsEc2NetworkInterfaceDetails {
	s.Attachment = v
	return s
}

// SetIpV6Addresses sets the IpV6Addresses field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetIpV6Addresses(v []*AwsEc2NetworkInterfaceIpV6AddressDetail) *AwsEc2NetworkInterfaceDetails {
	s.IpV6Addresses = v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetNetworkInterfaceId(v string) *AwsEc2NetworkInterfaceDetails {
	s.NetworkInterfaceId = &v
	return s
}

// SetPrivateIpAddresses sets the PrivateIpAddresses field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetPrivateIpAddresses(v []*AwsEc2NetworkInterfacePrivateIpAddressDetail) *AwsEc2NetworkInterfaceDetails {
	s.PrivateIpAddresses = v
	return s
}

// SetPublicDnsName sets the PublicDnsName field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetPublicDnsName(v string) *AwsEc2NetworkInterfaceDetails {
	s.PublicDnsName = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetPublicIp(v string) *AwsEc2NetworkInterfaceDetails {
	s.PublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetSecurityGroups(v []*AwsEc2NetworkInterfaceSecurityGroup) *AwsEc2NetworkInterfaceDetails {
	s.SecurityGroups = v
	return s
}

// SetSourceDestCheck sets the SourceDestCheck field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetSourceDestCheck(v bool) *AwsEc2NetworkInterfaceDetails {
	s.SourceDestCheck = &v
	return s
}

// Provides information about an IPV6 address that is associated with the network
// interface.
type AwsEc2NetworkInterfaceIpV6AddressDetail struct {
	_ struct{} `type:"structure"`

	// The IPV6 address.
	IpV6Address *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceIpV6AddressDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceIpV6AddressDetail) GoString() string {
	return s.String()
}

// SetIpV6Address sets the IpV6Address field's value.
func (s *AwsEc2NetworkInterfaceIpV6AddressDetail) SetIpV6Address(v string) *AwsEc2NetworkInterfaceIpV6AddressDetail {
	s.IpV6Address = &v
	return s
}

// Provides information about a private IPv4 address that is with the network
// interface.
type AwsEc2NetworkInterfacePrivateIpAddressDetail struct {
	_ struct{} `type:"structure"`

	// The private DNS name for the IP address.
	PrivateDnsName *string `type:"string"`

	// The IP address.
	PrivateIpAddress *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfacePrivateIpAddressDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfacePrivateIpAddressDetail) GoString() string {
	return s.String()
}

// SetPrivateDnsName sets the PrivateDnsName field's value.
func (s *AwsEc2NetworkInterfacePrivateIpAddressDetail) SetPrivateDnsName(v string) *AwsEc2NetworkInterfacePrivateIpAddressDetail {
	s.PrivateDnsName = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *AwsEc2NetworkInterfacePrivateIpAddressDetail) SetPrivateIpAddress(v string) *AwsEc2NetworkInterfacePrivateIpAddressDetail {
	s.PrivateIpAddress = &v
	return s
}

// A security group associated with the network interface.
type AwsEc2NetworkInterfaceSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceSecurityGroup) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2NetworkInterfaceSecurityGroup) SetGroupId(v string) *AwsEc2NetworkInterfaceSecurityGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2NetworkInterfaceSecurityGroup) SetGroupName(v string) *AwsEc2NetworkInterfaceSecurityGroup {
	s.GroupName = &v
	return s
}

// Provides details about a route table for the specified VPC.
type AwsEc2RouteTableDetails struct {
	_ struct{} `type:"structure"`

	// The associations between a route table and one or more subnets or a gateway.
	AssociationSet []*AssociationSetDetails `type:"list"`

	// The ID of the Amazon Web Services account that owns the route table.
	OwnerId *string `type:"string"`

	// Describes a virtual private gateway propagating route.
	PropagatingVgwSet []*PropagatingVgwSetDetails `type:"list"`

	// The routes in the route table.
	RouteSet []*RouteSetDetails `type:"list"`

	// The ID of the route table.
	RouteTableId *string `type:"string"`

	// The ID of the virtual private cloud (VPC).
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2RouteTableDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2RouteTableDetails) GoString() string {
	return s.String()
}

// SetAssociationSet sets the AssociationSet field's value.
func (s *AwsEc2RouteTableDetails) SetAssociationSet(v []*AssociationSetDetails) *AwsEc2RouteTableDetails {
	s.AssociationSet = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsEc2RouteTableDetails) SetOwnerId(v string) *AwsEc2RouteTableDetails {
	s.OwnerId = &v
	return s
}

// SetPropagatingVgwSet sets the PropagatingVgwSet field's value.
func (s *AwsEc2RouteTableDetails) SetPropagatingVgwSet(v []*PropagatingVgwSetDetails) *AwsEc2RouteTableDetails {
	s.PropagatingVgwSet = v
	return s
}

// SetRouteSet sets the RouteSet field's value.
func (s *AwsEc2RouteTableDetails) SetRouteSet(v []*RouteSetDetails) *AwsEc2RouteTableDetails {
	s.RouteSet = v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *AwsEc2RouteTableDetails) SetRouteTableId(v string) *AwsEc2RouteTableDetails {
	s.RouteTableId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2RouteTableDetails) SetVpcId(v string) *AwsEc2RouteTableDetails {
	s.VpcId = &v
	return s
}

// Details about an Amazon EC2 security group.
type AwsEc2SecurityGroupDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The inbound rules associated with the security group.
	IpPermissions []*AwsEc2SecurityGroupIpPermission `type:"list"`

	// [VPC only] The outbound rules associated with the security group.
	IpPermissionsEgress []*AwsEc2SecurityGroupIpPermission `type:"list"`

	// The Amazon Web Services account ID of the owner of the security group.
	OwnerId *string `type:"string"`

	// [VPC only] The ID of the VPC for the security group.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupDetails) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2SecurityGroupDetails) SetGroupId(v string) *AwsEc2SecurityGroupDetails {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2SecurityGroupDetails) SetGroupName(v string) *AwsEc2SecurityGroupDetails {
	s.GroupName = &v
	return s
}

// SetIpPermissions sets the IpPermissions field's value.
func (s *AwsEc2SecurityGroupDetails) SetIpPermissions(v []*AwsEc2SecurityGroupIpPermission) *AwsEc2SecurityGroupDetails {
	s.IpPermissions = v
	return s
}

// SetIpPermissionsEgress sets the IpPermissionsEgress field's value.
func (s *AwsEc2SecurityGroupDetails) SetIpPermissionsEgress(v []*AwsEc2SecurityGroupIpPermission) *AwsEc2SecurityGroupDetails {
	s.IpPermissionsEgress = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsEc2SecurityGroupDetails) SetOwnerId(v string) *AwsEc2SecurityGroupDetails {
	s.OwnerId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2SecurityGroupDetails) SetVpcId(v string) *AwsEc2SecurityGroupDetails {
	s.VpcId = &v
	return s
}

// An IP permission for an EC2 security group.
type AwsEc2SecurityGroupIpPermission struct {
	_ struct{} `type:"structure"`

	// The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number.
	//
	// A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	FromPort *int64 `type:"integer"`

	// The IP protocol name (tcp, udp, icmp, icmpv6) or number.
	//
	// [VPC only] Use -1 to specify all protocols.
	//
	// When authorizing security group rules, specifying -1 or a protocol number
	// other than tcp, udp, icmp, or icmpv6 allows traffic on all ports, regardless
	// of any port range you specify.
	//
	// For tcp, udp, and icmp, you must specify a port range.
	//
	// For icmpv6, the port range is optional. If you omit the port range, traffic
	// for all types and codes is allowed.
	IpProtocol *string `type:"string"`

	// The IPv4 ranges.
	IpRanges []*AwsEc2SecurityGroupIpRange `type:"list"`

	// The IPv6 ranges.
	Ipv6Ranges []*AwsEc2SecurityGroupIpv6Range `type:"list"`

	// [VPC only] The prefix list IDs for an Amazon Web Services service. With outbound
	// rules, this is the Amazon Web Services service to access through a VPC endpoint
	// from instances associated with the security group.
	PrefixListIds []*AwsEc2SecurityGroupPrefixListId `type:"list"`

	// The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// code.
	//
	// A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	ToPort *int64 `type:"integer"`

	// The security group and Amazon Web Services account ID pairs.
	UserIdGroupPairs []*AwsEc2SecurityGroupUserIdGroupPair `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpPermission) GoString() string {
	return s.String()
}

// SetFromPort sets the FromPort field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetFromPort(v int64) *AwsEc2SecurityGroupIpPermission {
	s.FromPort = &v
	return s
}

// SetIpProtocol sets the IpProtocol field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpProtocol(v string) *AwsEc2SecurityGroupIpPermission {
	s.IpProtocol = &v
	return s
}

// SetIpRanges sets the IpRanges field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpRanges(v []*AwsEc2SecurityGroupIpRange) *AwsEc2SecurityGroupIpPermission {
	s.IpRanges = v
	return s
}

// SetIpv6Ranges sets the Ipv6Ranges field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpv6Ranges(v []*AwsEc2SecurityGroupIpv6Range) *AwsEc2SecurityGroupIpPermission {
	s.Ipv6Ranges = v
	return s
}

// SetPrefixListIds sets the PrefixListIds field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetPrefixListIds(v []*AwsEc2SecurityGroupPrefixListId) *AwsEc2SecurityGroupIpPermission {
	s.PrefixListIds = v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetToPort(v int64) *AwsEc2SecurityGroupIpPermission {
	s.ToPort = &v
	return s
}

// SetUserIdGroupPairs sets the UserIdGroupPairs field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetUserIdGroupPairs(v []*AwsEc2SecurityGroupUserIdGroupPair) *AwsEc2SecurityGroupIpPermission {
	s.UserIdGroupPairs = v
	return s
}

// A range of IPv4 addresses.
type AwsEc2SecurityGroupIpRange struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv4 address, use the /32 prefix
	// length.
	CidrIp *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpRange) GoString() string {
	return s.String()
}

// SetCidrIp sets the CidrIp field's value.
func (s *AwsEc2SecurityGroupIpRange) SetCidrIp(v string) *AwsEc2SecurityGroupIpRange {
	s.CidrIp = &v
	return s
}

// A range of IPv6 addresses.
type AwsEc2SecurityGroupIpv6Range struct {
	_ struct{} `type:"structure"`

	// The IPv6 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv6 address, use the /128 prefix
	// length.
	CidrIpv6 *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpv6Range) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpv6Range) GoString() string {
	return s.String()
}

// SetCidrIpv6 sets the CidrIpv6 field's value.
func (s *AwsEc2SecurityGroupIpv6Range) SetCidrIpv6(v string) *AwsEc2SecurityGroupIpv6Range {
	s.CidrIpv6 = &v
	return s
}

// A prefix list ID.
type AwsEc2SecurityGroupPrefixListId struct {
	_ struct{} `type:"structure"`

	// The ID of the prefix.
	PrefixListId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupPrefixListId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupPrefixListId) GoString() string {
	return s.String()
}

// SetPrefixListId sets the PrefixListId field's value.
func (s *AwsEc2SecurityGroupPrefixListId) SetPrefixListId(v string) *AwsEc2SecurityGroupPrefixListId {
	s.PrefixListId = &v
	return s
}

// A relationship between a security group and a user.
type AwsEc2SecurityGroupUserIdGroupPair struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The status of a VPC peering connection, if applicable.
	PeeringStatus *string `type:"string"`

	// The ID of an Amazon Web Services account.
	//
	// For a referenced security group in another VPC, the account ID of the referenced
	// security group is returned in the response. If the referenced security group
	// is deleted, this value is not returned.
	//
	// [EC2-Classic] Required when adding or removing rules that reference a security
	// group in another VPC.
	UserId *string `type:"string"`

	// The ID of the VPC for the referenced security group, if applicable.
	VpcId *string `type:"string"`

	// The ID of the VPC peering connection, if applicable.
	VpcPeeringConnectionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupUserIdGroupPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupUserIdGroupPair) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetGroupId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetGroupName(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.GroupName = &v
	return s
}

// SetPeeringStatus sets the PeeringStatus field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetPeeringStatus(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.PeeringStatus = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetUserId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.UserId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetVpcId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.VpcId = &v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetVpcPeeringConnectionId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.VpcPeeringConnectionId = &v
	return s
}

// Contains information about a subnet in Amazon EC2.
type AwsEc2SubnetDetails struct {
	_ struct{} `type:"structure"`

	// Whether to assign an IPV6 address to a network interface that is created
	// in this subnet.
	AssignIpv6AddressOnCreation *bool `type:"boolean"`

	// The Availability Zone for the subnet.
	AvailabilityZone *string `type:"string"`

	// The identifier of the Availability Zone for the subnet.
	AvailabilityZoneId *string `type:"string"`

	// The number of available IPV4 addresses in the subnet. Does not include addresses
	// for stopped instances.
	AvailableIpAddressCount *int64 `type:"integer"`

	// The IPV4 CIDR block that is assigned to the subnet.
	CidrBlock *string `type:"string"`

	// Whether this subnet is the default subnet for the Availability Zone.
	DefaultForAz *bool `type:"boolean"`

	// The IPV6 CIDR blocks that are associated with the subnet.
	Ipv6CidrBlockAssociationSet []*Ipv6CidrBlockAssociation `type:"list"`

	// Whether instances in this subnet receive a public IP address.
	MapPublicIpOnLaunch *bool `type:"boolean"`

	// The identifier of the Amazon Web Services account that owns the subnet.
	OwnerId *string `type:"string"`

	// The current state of the subnet. Valid values are available or pending.
	State *string `type:"string"`

	// The ARN of the subnet.
	SubnetArn *string `type:"string"`

	// The identifier of the subnet.
	SubnetId *string `type:"string"`

	// The identifier of the VPC that contains the subnet.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SubnetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SubnetDetails) GoString() string {
	return s.String()
}

// SetAssignIpv6AddressOnCreation sets the AssignIpv6AddressOnCreation field's value.
func (s *AwsEc2SubnetDetails) SetAssignIpv6AddressOnCreation(v bool) *AwsEc2SubnetDetails {
	s.AssignIpv6AddressOnCreation = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *AwsEc2SubnetDetails) SetAvailabilityZone(v string) *AwsEc2SubnetDetails {
	s.AvailabilityZone = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *AwsEc2SubnetDetails) SetAvailabilityZoneId(v string) *AwsEc2SubnetDetails {
	s.AvailabilityZoneId = &v
	return s
}

// SetAvailableIpAddressCount sets the AvailableIpAddressCount field's value.
func (s *AwsEc2SubnetDetails) SetAvailableIpAddressCount(v int64) *AwsEc2SubnetDetails {
	s.AvailableIpAddressCount = &v
	return s
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *AwsEc2SubnetDetails) SetCidrBlock(v string) *AwsEc2SubnetDetails {
	s.CidrBlock = &v
	return s
}

// SetDefaultForAz sets the DefaultForAz field's value.
func (s *AwsEc2SubnetDetails) SetDefaultForAz(v bool) *AwsEc2SubnetDetails {
	s.DefaultForAz = &v
	return s
}

// SetIpv6CidrBlockAssociationSet sets the Ipv6CidrBlockAssociationSet field's value.
func (s *AwsEc2SubnetDetails) SetIpv6CidrBlockAssociationSet(v []*Ipv6CidrBlockAssociation) *AwsEc2SubnetDetails {
	s.Ipv6CidrBlockAssociationSet = v
	return s
}

// SetMapPublicIpOnLaunch sets the MapPublicIpOnLaunch field's value.
func (s *AwsEc2SubnetDetails) SetMapPublicIpOnLaunch(v bool) *AwsEc2SubnetDetails {
	s.MapPublicIpOnLaunch = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsEc2SubnetDetails) SetOwnerId(v string) *AwsEc2SubnetDetails {
	s.OwnerId = &v
	return s
}

// SetState sets the State field's value.
func (s *AwsEc2SubnetDetails) SetState(v string) *AwsEc2SubnetDetails {
	s.State = &v
	return s
}

// SetSubnetArn sets the SubnetArn field's value.
func (s *AwsEc2SubnetDetails) SetSubnetArn(v string) *AwsEc2SubnetDetails {
	s.SubnetArn = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2SubnetDetails) SetSubnetId(v string) *AwsEc2SubnetDetails {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2SubnetDetails) SetVpcId(v string) *AwsEc2SubnetDetails {
	s.VpcId = &v
	return s
}

// Information about an Amazon Web Services Amazon EC2 Transit Gateway that
// interconnects virtual private clouds (VPCs) and on-premises networks.
type AwsEc2TransitGatewayDetails struct {
	_ struct{} `type:"structure"`

	// A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
	AmazonSideAsn *int64 `type:"integer"`

	// The ID of the default association route table.
	AssociationDefaultRouteTableId *string `type:"string"`

	// Turn on or turn off automatic acceptance of attachment requests.
	AutoAcceptSharedAttachments *string `type:"string"`

	// Turn on or turn off automatic association with the default association route
	// table.
	DefaultRouteTableAssociation *string `type:"string"`

	// Turn on or turn off automatic propagation of routes to the default propagation
	// route table.
	DefaultRouteTablePropagation *string `type:"string"`

	// The description of the transit gateway.
	Description *string `type:"string"`

	// Turn on or turn off DNS support.
	DnsSupport *string `type:"string"`

	// The ID of the transit gateway.
	Id *string `type:"string"`

	// Indicates whether multicast is supported on the transit gateway.
	MulticastSupport *string `type:"string"`

	// The ID of the default propagation route table.
	PropagationDefaultRouteTableId *string `type:"string"`

	// The transit gateway Classless Inter-Domain Routing (CIDR) blocks.
	TransitGatewayCidrBlocks []*string `type:"list"`

	// Turn on or turn off Equal Cost Multipath Protocol (ECMP) support.
	VpnEcmpSupport *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2TransitGatewayDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2TransitGatewayDetails) GoString() string {
	return s.String()
}

// SetAmazonSideAsn sets the AmazonSideAsn field's value.
func (s *AwsEc2TransitGatewayDetails) SetAmazonSideAsn(v int64) *AwsEc2TransitGatewayDetails {
	s.AmazonSideAsn = &v
	return s
}

// SetAssociationDefaultRouteTableId sets the AssociationDefaultRouteTableId field's value.
func (s *AwsEc2TransitGatewayDetails) SetAssociationDefaultRouteTableId(v string) *AwsEc2TransitGatewayDetails {
	s.AssociationDefaultRouteTableId = &v
	return s
}

// SetAutoAcceptSharedAttachments sets the AutoAcceptSharedAttachments field's value.
func (s *AwsEc2TransitGatewayDetails) SetAutoAcceptSharedAttachments(v string) *AwsEc2TransitGatewayDetails {
	s.AutoAcceptSharedAttachments = &v
	return s
}

// SetDefaultRouteTableAssociation sets the DefaultRouteTableAssociation field's value.
func (s *AwsEc2TransitGatewayDetails) SetDefaultRouteTableAssociation(v string) *AwsEc2TransitGatewayDetails {
	s.DefaultRouteTableAssociation = &v
	return s
}

// SetDefaultRouteTablePropagation sets the DefaultRouteTablePropagation field's value.
func (s *AwsEc2TransitGatewayDetails) SetDefaultRouteTablePropagation(v string) *AwsEc2TransitGatewayDetails {
	s.DefaultRouteTablePropagation = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsEc2TransitGatewayDetails) SetDescription(v string) *AwsEc2TransitGatewayDetails {
	s.Description = &v
	return s
}

// SetDnsSupport sets the DnsSupport field's value.
func (s *AwsEc2TransitGatewayDetails) SetDnsSupport(v string) *AwsEc2TransitGatewayDetails {
	s.DnsSupport = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsEc2TransitGatewayDetails) SetId(v string) *AwsEc2TransitGatewayDetails {
	s.Id = &v
	return s
}

// SetMulticastSupport sets the MulticastSupport field's value.
func (s *AwsEc2TransitGatewayDetails) SetMulticastSupport(v string) *AwsEc2TransitGatewayDetails {
	s.MulticastSupport = &v
	return s
}

// SetPropagationDefaultRouteTableId sets the PropagationDefaultRouteTableId field's value.
func (s *AwsEc2TransitGatewayDetails) SetPropagationDefaultRouteTableId(v string) *AwsEc2TransitGatewayDetails {
	s.PropagationDefaultRouteTableId = &v
	return s
}

// SetTransitGatewayCidrBlocks sets the TransitGatewayCidrBlocks field's value.
func (s *AwsEc2TransitGatewayDetails) SetTransitGatewayCidrBlocks(v []*string) *AwsEc2TransitGatewayDetails {
	s.TransitGatewayCidrBlocks = v
	return s
}

// SetVpnEcmpSupport sets the VpnEcmpSupport field's value.
func (s *AwsEc2TransitGatewayDetails) SetVpnEcmpSupport(v string) *AwsEc2TransitGatewayDetails {
	s.VpnEcmpSupport = &v
	return s
}

// An attachment to an Amazon EC2 volume.
type AwsEc2VolumeAttachment struct {
	_ struct{} `type:"structure"`

	// The datetime when the attachment initiated.
	AttachTime *string `type:"string"`

	// Whether the EBS volume is deleted when the EC2 instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// The identifier of the EC2 instance.
	InstanceId *string `type:"string"`

	// The attachment state of the volume. Valid values are as follows:
	//
	//    * attaching
	//
	//    * attached
	//
	//    * busy
	//
	//    * detaching
	//
	//    * detached
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VolumeAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VolumeAttachment) GoString() string {
	return s.String()
}

// SetAttachTime sets the AttachTime field's value.
func (s *AwsEc2VolumeAttachment) SetAttachTime(v string) *AwsEc2VolumeAttachment {
	s.AttachTime = &v
	return s
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsEc2VolumeAttachment) SetDeleteOnTermination(v bool) *AwsEc2VolumeAttachment {
	s.DeleteOnTermination = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsEc2VolumeAttachment) SetInstanceId(v string) *AwsEc2VolumeAttachment {
	s.InstanceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2VolumeAttachment) SetStatus(v string) *AwsEc2VolumeAttachment {
	s.Status = &v
	return s
}

// Details about an EC2 volume.
type AwsEc2VolumeDetails struct {
	_ struct{} `type:"structure"`

	// The volume attachments.
	Attachments []*AwsEc2VolumeAttachment `type:"list"`

	// Indicates when the volume was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	CreateTime *string `type:"string"`

	// The device name for the volume that is attached to the instance.
	DeviceName *string `type:"string"`

	// Specifies whether the volume is encrypted.
	Encrypted *bool `type:"boolean"`

	// The ARN of the KMS key that was used to protect the volume encryption key
	// for the volume.
	KmsKeyId *string `type:"string"`

	// The size of the volume, in GiBs.
	Size *int64 `type:"integer"`

	// The snapshot from which the volume was created.
	SnapshotId *string `type:"string"`

	// The volume state. Valid values are as follows:
	//
	//    * available
	//
	//    * creating
	//
	//    * deleted
	//
	//    * deleting
	//
	//    * error
	//
	//    * in-use
	Status *string `type:"string"`

	// The ID of the volume.
	VolumeId *string `type:"string"`

	// Indicates whether the volume was scanned or skipped.
	VolumeScanStatus *string `type:"string"`

	// The volume type.
	VolumeType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VolumeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VolumeDetails) GoString() string {
	return s.String()
}

// SetAttachments sets the Attachments field's value.
func (s *AwsEc2VolumeDetails) SetAttachments(v []*AwsEc2VolumeAttachment) *AwsEc2VolumeDetails {
	s.Attachments = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AwsEc2VolumeDetails) SetCreateTime(v string) *AwsEc2VolumeDetails {
	s.CreateTime = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *AwsEc2VolumeDetails) SetDeviceName(v string) *AwsEc2VolumeDetails {
	s.DeviceName = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *AwsEc2VolumeDetails) SetEncrypted(v bool) *AwsEc2VolumeDetails {
	s.Encrypted = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsEc2VolumeDetails) SetKmsKeyId(v string) *AwsEc2VolumeDetails {
	s.KmsKeyId = &v
	return s
}

// SetSize sets the Size field's value.
func (s *AwsEc2VolumeDetails) SetSize(v int64) *AwsEc2VolumeDetails {
	s.Size = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *AwsEc2VolumeDetails) SetSnapshotId(v string) *AwsEc2VolumeDetails {
	s.SnapshotId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2VolumeDetails) SetStatus(v string) *AwsEc2VolumeDetails {
	s.Status = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *AwsEc2VolumeDetails) SetVolumeId(v string) *AwsEc2VolumeDetails {
	s.VolumeId = &v
	return s
}

// SetVolumeScanStatus sets the VolumeScanStatus field's value.
func (s *AwsEc2VolumeDetails) SetVolumeScanStatus(v string) *AwsEc2VolumeDetails {
	s.VolumeScanStatus = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *AwsEc2VolumeDetails) SetVolumeType(v string) *AwsEc2VolumeDetails {
	s.VolumeType = &v
	return s
}

// Details about an EC2 VPC.
type AwsEc2VpcDetails struct {
	_ struct{} `type:"structure"`

	// Information about the IPv4 CIDR blocks associated with the VPC.
	CidrBlockAssociationSet []*CidrBlockAssociation `type:"list"`

	// The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options
	// that are associated with the VPC. If the default options are associated with
	// the VPC, then this is default.
	DhcpOptionsId *string `type:"string"`

	// Information about the IPv6 CIDR blocks associated with the VPC.
	Ipv6CidrBlockAssociationSet []*Ipv6CidrBlockAssociation `type:"list"`

	// The current state of the VPC. Valid values are available or pending.
	State *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcDetails) GoString() string {
	return s.String()
}

// SetCidrBlockAssociationSet sets the CidrBlockAssociationSet field's value.
func (s *AwsEc2VpcDetails) SetCidrBlockAssociationSet(v []*CidrBlockAssociation) *AwsEc2VpcDetails {
	s.CidrBlockAssociationSet = v
	return s
}

// SetDhcpOptionsId sets the DhcpOptionsId field's value.
func (s *AwsEc2VpcDetails) SetDhcpOptionsId(v string) *AwsEc2VpcDetails {
	s.DhcpOptionsId = &v
	return s
}

// SetIpv6CidrBlockAssociationSet sets the Ipv6CidrBlockAssociationSet field's value.
func (s *AwsEc2VpcDetails) SetIpv6CidrBlockAssociationSet(v []*Ipv6CidrBlockAssociation) *AwsEc2VpcDetails {
	s.Ipv6CidrBlockAssociationSet = v
	return s
}

// SetState sets the State field's value.
func (s *AwsEc2VpcDetails) SetState(v string) *AwsEc2VpcDetails {
	s.State = &v
	return s
}

// Contains details about the service configuration for a VPC endpoint service.
type AwsEc2VpcEndpointServiceDetails struct {
	_ struct{} `type:"structure"`

	// Whether requests from other Amazon Web Services accounts to create an endpoint
	// to the service must first be accepted.
	AcceptanceRequired *bool `type:"boolean"`

	// The Availability Zones where the service is available.
	AvailabilityZones []*string `type:"list"`

	// The DNS names for the service.
	BaseEndpointDnsNames []*string `type:"list"`

	// The ARNs of the Gateway Load Balancers for the service.
	GatewayLoadBalancerArns []*string `type:"list"`

	// Whether the service manages its VPC endpoints.
	ManagesVpcEndpoints *bool `type:"boolean"`

	// The ARNs of the Network Load Balancers for the service.
	NetworkLoadBalancerArns []*string `type:"list"`

	// The private DNS name for the service.
	PrivateDnsName *string `type:"string"`

	// The identifier of the service.
	ServiceId *string `type:"string"`

	// The name of the service.
	ServiceName *string `type:"string"`

	// The current state of the service. Valid values are as follows:
	//
	//    * Available
	//
	//    * Deleted
	//
	//    * Deleting
	//
	//    * Failed
	//
	//    * Pending
	ServiceState *string `type:"string"`

	// The types for the service.
	ServiceType []*AwsEc2VpcEndpointServiceServiceTypeDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcEndpointServiceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcEndpointServiceDetails) GoString() string {
	return s.String()
}

// SetAcceptanceRequired sets the AcceptanceRequired field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetAcceptanceRequired(v bool) *AwsEc2VpcEndpointServiceDetails {
	s.AcceptanceRequired = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetAvailabilityZones(v []*string) *AwsEc2VpcEndpointServiceDetails {
	s.AvailabilityZones = v
	return s
}

// SetBaseEndpointDnsNames sets the BaseEndpointDnsNames field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetBaseEndpointDnsNames(v []*string) *AwsEc2VpcEndpointServiceDetails {
	s.BaseEndpointDnsNames = v
	return s
}

// SetGatewayLoadBalancerArns sets the GatewayLoadBalancerArns field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetGatewayLoadBalancerArns(v []*string) *AwsEc2VpcEndpointServiceDetails {
	s.GatewayLoadBalancerArns = v
	return s
}

// SetManagesVpcEndpoints sets the ManagesVpcEndpoints field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetManagesVpcEndpoints(v bool) *AwsEc2VpcEndpointServiceDetails {
	s.ManagesVpcEndpoints = &v
	return s
}

// SetNetworkLoadBalancerArns sets the NetworkLoadBalancerArns field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetNetworkLoadBalancerArns(v []*string) *AwsEc2VpcEndpointServiceDetails {
	s.NetworkLoadBalancerArns = v
	return s
}

// SetPrivateDnsName sets the PrivateDnsName field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetPrivateDnsName(v string) *AwsEc2VpcEndpointServiceDetails {
	s.PrivateDnsName = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetServiceId(v string) *AwsEc2VpcEndpointServiceDetails {
	s.ServiceId = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetServiceName(v string) *AwsEc2VpcEndpointServiceDetails {
	s.ServiceName = &v
	return s
}

// SetServiceState sets the ServiceState field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetServiceState(v string) *AwsEc2VpcEndpointServiceDetails {
	s.ServiceState = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetServiceType(v []*AwsEc2VpcEndpointServiceServiceTypeDetails) *AwsEc2VpcEndpointServiceDetails {
	s.ServiceType = v
	return s
}

// The service type information for a VPC endpoint service.
type AwsEc2VpcEndpointServiceServiceTypeDetails struct {
	_ struct{} `type:"structure"`

	// The type of service.
	ServiceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcEndpointServiceServiceTypeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcEndpointServiceServiceTypeDetails) GoString() string {
	return s.String()
}

// SetServiceType sets the ServiceType field's value.
func (s *AwsEc2VpcEndpointServiceServiceTypeDetails) SetServiceType(v string) *AwsEc2VpcEndpointServiceServiceTypeDetails {
	s.ServiceType = &v
	return s
}

// Provides information about a VPC peering connection between two VPCs: a requester
// VPC that you own and an accepter VPC with which to create the connection.
type AwsEc2VpcPeeringConnectionDetails struct {
	_ struct{} `type:"structure"`

	// Information about the accepter VPC.
	AccepterVpcInfo *AwsEc2VpcPeeringConnectionVpcInfoDetails `type:"structure"`

	// The time at which an unaccepted VPC peering connection will expire.
	ExpirationTime *string `type:"string"`

	// Information about the requester VPC.
	RequesterVpcInfo *AwsEc2VpcPeeringConnectionVpcInfoDetails `type:"structure"`

	// The status of the VPC peering connection.
	Status *AwsEc2VpcPeeringConnectionStatusDetails `type:"structure"`

	// The ID of the VPC peering connection.
	VpcPeeringConnectionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcPeeringConnectionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcPeeringConnectionDetails) GoString() string {
	return s.String()
}

// SetAccepterVpcInfo sets the AccepterVpcInfo field's value.
func (s *AwsEc2VpcPeeringConnectionDetails) SetAccepterVpcInfo(v *AwsEc2VpcPeeringConnectionVpcInfoDetails) *AwsEc2VpcPeeringConnectionDetails {
	s.AccepterVpcInfo = v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *AwsEc2VpcPeeringConnectionDetails) SetExpirationTime(v string) *AwsEc2VpcPeeringConnectionDetails {
	s.ExpirationTime = &v
	return s
}

// SetRequesterVpcInfo sets the RequesterVpcInfo field's value.
func (s *AwsEc2VpcPeeringConnectionDetails) SetRequesterVpcInfo(v *AwsEc2VpcPeeringConnectionVpcInfoDetails) *AwsEc2VpcPeeringConnectionDetails {
	s.RequesterVpcInfo = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2VpcPeeringConnectionDetails) SetStatus(v *AwsEc2VpcPeeringConnectionStatusDetails) *AwsEc2VpcPeeringConnectionDetails {
	s.Status = v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *AwsEc2VpcPeeringConnectionDetails) SetVpcPeeringConnectionId(v string) *AwsEc2VpcPeeringConnectionDetails {
	s.VpcPeeringConnectionId = &v
	return s
}

// Details about the status of the VPC peering connection.
type AwsEc2VpcPeeringConnectionStatusDetails struct {
	_ struct{} `type:"structure"`

	// The status of the VPC peering connection.
	Code *string `type:"string"`

	// A message that provides more information about the status, if applicable.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcPeeringConnectionStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcPeeringConnectionStatusDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *AwsEc2VpcPeeringConnectionStatusDetails) SetCode(v string) *AwsEc2VpcPeeringConnectionStatusDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AwsEc2VpcPeeringConnectionStatusDetails) SetMessage(v string) *AwsEc2VpcPeeringConnectionStatusDetails {
	s.Message = &v
	return s
}

// Describes a VPC in a VPC peering connection.
type AwsEc2VpcPeeringConnectionVpcInfoDetails struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR block for the VPC.
	CidrBlock *string `type:"string"`

	// Information about the IPv4 CIDR blocks for the VPC.
	CidrBlockSet []*VpcInfoCidrBlockSetDetails `type:"list"`

	// The IPv6 CIDR block for the VPC.
	Ipv6CidrBlockSet []*VpcInfoIpv6CidrBlockSetDetails `type:"list"`

	// The ID of the Amazon Web Services account that owns the VPC.
	OwnerId *string `type:"string"`

	// Information about the VPC peering connection options for the accepter or
	// requester VPC.
	PeeringOptions *VpcInfoPeeringOptionsDetails `type:"structure"`

	// The Amazon Web Services Region in which the VPC is located.
	Region *string `type:"string"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcPeeringConnectionVpcInfoDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcPeeringConnectionVpcInfoDetails) GoString() string {
	return s.String()
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *AwsEc2VpcPeeringConnectionVpcInfoDetails) SetCidrBlock(v string) *AwsEc2VpcPeeringConnectionVpcInfoDetails {
	s.CidrBlock = &v
	return s
}

// SetCidrBlockSet sets the CidrBlockSet field's value.
func (s *AwsEc2VpcPeeringConnectionVpcInfoDetails) SetCidrBlockSet(v []*VpcInfoCidrBlockSetDetails) *AwsEc2VpcPeeringConnectionVpcInfoDetails {
	s.CidrBlockSet = v
	return s
}

// SetIpv6CidrBlockSet sets the Ipv6CidrBlockSet field's value.
func (s *AwsEc2VpcPeeringConnectionVpcInfoDetails) SetIpv6CidrBlockSet(v []*VpcInfoIpv6CidrBlockSetDetails) *AwsEc2VpcPeeringConnectionVpcInfoDetails {
	s.Ipv6CidrBlockSet = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsEc2VpcPeeringConnectionVpcInfoDetails) SetOwnerId(v string) *AwsEc2VpcPeeringConnectionVpcInfoDetails {
	s.OwnerId = &v
	return s
}

// SetPeeringOptions sets the PeeringOptions field's value.
func (s *AwsEc2VpcPeeringConnectionVpcInfoDetails) SetPeeringOptions(v *VpcInfoPeeringOptionsDetails) *AwsEc2VpcPeeringConnectionVpcInfoDetails {
	s.PeeringOptions = v
	return s
}

// SetRegion sets the Region field's value.
func (s *AwsEc2VpcPeeringConnectionVpcInfoDetails) SetRegion(v string) *AwsEc2VpcPeeringConnectionVpcInfoDetails {
	s.Region = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2VpcPeeringConnectionVpcInfoDetails) SetVpcId(v string) *AwsEc2VpcPeeringConnectionVpcInfoDetails {
	s.VpcId = &v
	return s
}

// Details about an Amazon EC2 VPN connection.
type AwsEc2VpnConnectionDetails struct {
	_ struct{} `type:"structure"`

	// The category of the VPN connection. VPN indicates an Amazon Web Services
	// VPN connection. VPN-Classic indicates an Amazon Web Services Classic VPN
	// connection.
	Category *string `type:"string"`

	// The configuration information for the VPN connection's customer gateway,
	// in the native XML format.
	CustomerGatewayConfiguration *string `type:"string"`

	// The identifier of the customer gateway that is at your end of the VPN connection.
	CustomerGatewayId *string `type:"string"`

	// The VPN connection options.
	Options *AwsEc2VpnConnectionOptionsDetails `type:"structure"`

	// The static routes that are associated with the VPN connection.
	Routes []*AwsEc2VpnConnectionRoutesDetails `type:"list"`

	// The current state of the VPN connection. Valid values are as follows:
	//
	//    * available
	//
	//    * deleted
	//
	//    * deleting
	//
	//    * pending
	State *string `type:"string"`

	// The identifier of the transit gateway that is associated with the VPN connection.
	TransitGatewayId *string `type:"string"`

	// The type of VPN connection.
	Type *string `type:"string"`

	// Information about the VPN tunnel.
	VgwTelemetry []*AwsEc2VpnConnectionVgwTelemetryDetails `type:"list"`

	// The identifier of the VPN connection.
	VpnConnectionId *string `type:"string"`

	// The identifier of the virtual private gateway that is at the Amazon Web Services
	// side of the VPN connection.
	VpnGatewayId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionDetails) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *AwsEc2VpnConnectionDetails) SetCategory(v string) *AwsEc2VpnConnectionDetails {
	s.Category = &v
	return s
}

// SetCustomerGatewayConfiguration sets the CustomerGatewayConfiguration field's value.
func (s *AwsEc2VpnConnectionDetails) SetCustomerGatewayConfiguration(v string) *AwsEc2VpnConnectionDetails {
	s.CustomerGatewayConfiguration = &v
	return s
}

// SetCustomerGatewayId sets the CustomerGatewayId field's value.
func (s *AwsEc2VpnConnectionDetails) SetCustomerGatewayId(v string) *AwsEc2VpnConnectionDetails {
	s.CustomerGatewayId = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *AwsEc2VpnConnectionDetails) SetOptions(v *AwsEc2VpnConnectionOptionsDetails) *AwsEc2VpnConnectionDetails {
	s.Options = v
	return s
}

// SetRoutes sets the Routes field's value.
func (s *AwsEc2VpnConnectionDetails) SetRoutes(v []*AwsEc2VpnConnectionRoutesDetails) *AwsEc2VpnConnectionDetails {
	s.Routes = v
	return s
}

// SetState sets the State field's value.
func (s *AwsEc2VpnConnectionDetails) SetState(v string) *AwsEc2VpnConnectionDetails {
	s.State = &v
	return s
}

// SetTransitGatewayId sets the TransitGatewayId field's value.
func (s *AwsEc2VpnConnectionDetails) SetTransitGatewayId(v string) *AwsEc2VpnConnectionDetails {
	s.TransitGatewayId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEc2VpnConnectionDetails) SetType(v string) *AwsEc2VpnConnectionDetails {
	s.Type = &v
	return s
}

// SetVgwTelemetry sets the VgwTelemetry field's value.
func (s *AwsEc2VpnConnectionDetails) SetVgwTelemetry(v []*AwsEc2VpnConnectionVgwTelemetryDetails) *AwsEc2VpnConnectionDetails {
	s.VgwTelemetry = v
	return s
}

// SetVpnConnectionId sets the VpnConnectionId field's value.
func (s *AwsEc2VpnConnectionDetails) SetVpnConnectionId(v string) *AwsEc2VpnConnectionDetails {
	s.VpnConnectionId = &v
	return s
}

// SetVpnGatewayId sets the VpnGatewayId field's value.
func (s *AwsEc2VpnConnectionDetails) SetVpnGatewayId(v string) *AwsEc2VpnConnectionDetails {
	s.VpnGatewayId = &v
	return s
}

// VPN connection options.
type AwsEc2VpnConnectionOptionsDetails struct {
	_ struct{} `type:"structure"`

	// Whether the VPN connection uses static routes only.
	StaticRoutesOnly *bool `type:"boolean"`

	// The VPN tunnel options.
	TunnelOptions []*AwsEc2VpnConnectionOptionsTunnelOptionsDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionOptionsDetails) GoString() string {
	return s.String()
}

// SetStaticRoutesOnly sets the StaticRoutesOnly field's value.
func (s *AwsEc2VpnConnectionOptionsDetails) SetStaticRoutesOnly(v bool) *AwsEc2VpnConnectionOptionsDetails {
	s.StaticRoutesOnly = &v
	return s
}

// SetTunnelOptions sets the TunnelOptions field's value.
func (s *AwsEc2VpnConnectionOptionsDetails) SetTunnelOptions(v []*AwsEc2VpnConnectionOptionsTunnelOptionsDetails) *AwsEc2VpnConnectionOptionsDetails {
	s.TunnelOptions = v
	return s
}

// The VPN tunnel options.
type AwsEc2VpnConnectionOptionsTunnelOptionsDetails struct {
	_ struct{} `type:"structure"`

	// The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.
	DpdTimeoutSeconds *int64 `type:"integer"`

	// The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
	IkeVersions []*string `type:"list"`

	// The external IP address of the VPN tunnel.
	OutsideIpAddress *string `type:"string"`

	// The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1
	// IKE negotiations.
	Phase1DhGroupNumbers []*int64 `type:"list"`

	// The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
	Phase1EncryptionAlgorithms []*string `type:"list"`

	// The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
	Phase1IntegrityAlgorithms []*string `type:"list"`

	// The lifetime for phase 1 of the IKE negotiation, in seconds.
	Phase1LifetimeSeconds *int64 `type:"integer"`

	// The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2
	// IKE negotiations.
	Phase2DhGroupNumbers []*int64 `type:"list"`

	// The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
	Phase2EncryptionAlgorithms []*string `type:"list"`

	// The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
	Phase2IntegrityAlgorithms []*string `type:"list"`

	// The lifetime for phase 2 of the IKE negotiation, in seconds.
	Phase2LifetimeSeconds *int64 `type:"integer"`

	// The preshared key to establish initial authentication between the virtual
	// private gateway and the customer gateway.
	PreSharedKey *string `type:"string"`

	// The percentage of the rekey window, which is determined by RekeyMarginTimeSeconds
	// during which the rekey time is randomly selected.
	RekeyFuzzPercentage *int64 `type:"integer"`

	// The margin time, in seconds, before the phase 2 lifetime expires, during
	// which the Amazon Web Services side of the VPN connection performs an IKE
	// rekey.
	RekeyMarginTimeSeconds *int64 `type:"integer"`

	// The number of packets in an IKE replay window.
	ReplayWindowSize *int64 `type:"integer"`

	// The range of inside IPv4 addresses for the tunnel.
	TunnelInsideCidr *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionOptionsTunnelOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionOptionsTunnelOptionsDetails) GoString() string {
	return s.String()
}

// SetDpdTimeoutSeconds sets the DpdTimeoutSeconds field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetDpdTimeoutSeconds(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.DpdTimeoutSeconds = &v
	return s
}

// SetIkeVersions sets the IkeVersions field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetIkeVersions(v []*string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.IkeVersions = v
	return s
}

// SetOutsideIpAddress sets the OutsideIpAddress field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetOutsideIpAddress(v string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.OutsideIpAddress = &v
	return s
}

// SetPhase1DhGroupNumbers sets the Phase1DhGroupNumbers field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase1DhGroupNumbers(v []*int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase1DhGroupNumbers = v
	return s
}

// SetPhase1EncryptionAlgorithms sets the Phase1EncryptionAlgorithms field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase1EncryptionAlgorithms(v []*string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase1EncryptionAlgorithms = v
	return s
}

// SetPhase1IntegrityAlgorithms sets the Phase1IntegrityAlgorithms field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase1IntegrityAlgorithms(v []*string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase1IntegrityAlgorithms = v
	return s
}

// SetPhase1LifetimeSeconds sets the Phase1LifetimeSeconds field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase1LifetimeSeconds(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase1LifetimeSeconds = &v
	return s
}

// SetPhase2DhGroupNumbers sets the Phase2DhGroupNumbers field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase2DhGroupNumbers(v []*int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase2DhGroupNumbers = v
	return s
}

// SetPhase2EncryptionAlgorithms sets the Phase2EncryptionAlgorithms field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase2EncryptionAlgorithms(v []*string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase2EncryptionAlgorithms = v
	return s
}

// SetPhase2IntegrityAlgorithms sets the Phase2IntegrityAlgorithms field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase2IntegrityAlgorithms(v []*string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase2IntegrityAlgorithms = v
	return s
}

// SetPhase2LifetimeSeconds sets the Phase2LifetimeSeconds field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase2LifetimeSeconds(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase2LifetimeSeconds = &v
	return s
}

// SetPreSharedKey sets the PreSharedKey field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPreSharedKey(v string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.PreSharedKey = &v
	return s
}

// SetRekeyFuzzPercentage sets the RekeyFuzzPercentage field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetRekeyFuzzPercentage(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.RekeyFuzzPercentage = &v
	return s
}

// SetRekeyMarginTimeSeconds sets the RekeyMarginTimeSeconds field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetRekeyMarginTimeSeconds(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.RekeyMarginTimeSeconds = &v
	return s
}

// SetReplayWindowSize sets the ReplayWindowSize field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetReplayWindowSize(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.ReplayWindowSize = &v
	return s
}

// SetTunnelInsideCidr sets the TunnelInsideCidr field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetTunnelInsideCidr(v string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.TunnelInsideCidr = &v
	return s
}

// A static routes associated with the VPN connection.
type AwsEc2VpnConnectionRoutesDetails struct {
	_ struct{} `type:"structure"`

	// The CIDR block associated with the local subnet of the customer data center.
	DestinationCidrBlock *string `type:"string"`

	// The current state of the static route.
	State *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionRoutesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionRoutesDetails) GoString() string {
	return s.String()
}

// SetDestinationCidrBlock sets the DestinationCidrBlock field's value.
func (s *AwsEc2VpnConnectionRoutesDetails) SetDestinationCidrBlock(v string) *AwsEc2VpnConnectionRoutesDetails {
	s.DestinationCidrBlock = &v
	return s
}

// SetState sets the State field's value.
func (s *AwsEc2VpnConnectionRoutesDetails) SetState(v string) *AwsEc2VpnConnectionRoutesDetails {
	s.State = &v
	return s
}

// Information about the VPN tunnel.
type AwsEc2VpnConnectionVgwTelemetryDetails struct {
	_ struct{} `type:"structure"`

	// The number of accepted routes.
	AcceptedRouteCount *int64 `type:"integer"`

	// The ARN of the VPN tunnel endpoint certificate.
	CertificateArn *string `type:"string"`

	// The date and time of the last change in status.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	LastStatusChange *string `type:"string"`

	// The Internet-routable IP address of the virtual private gateway's outside
	// interface.
	OutsideIpAddress *string `type:"string"`

	// The status of the VPN tunnel. Valid values are DOWN or UP.
	Status *string `type:"string"`

	// If an error occurs, a description of the error.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionVgwTelemetryDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionVgwTelemetryDetails) GoString() string {
	return s.String()
}

// SetAcceptedRouteCount sets the AcceptedRouteCount field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetAcceptedRouteCount(v int64) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.AcceptedRouteCount = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetCertificateArn(v string) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.CertificateArn = &v
	return s
}

// SetLastStatusChange sets the LastStatusChange field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetLastStatusChange(v string) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.LastStatusChange = &v
	return s
}

// SetOutsideIpAddress sets the OutsideIpAddress field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetOutsideIpAddress(v string) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.OutsideIpAddress = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetStatus(v string) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetStatusMessage(v string) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.StatusMessage = &v
	return s
}

// Information about an Amazon ECR image.
type AwsEcrContainerImageDetails struct {
	_ struct{} `type:"structure"`

	// The architecture of the image. Valid values are as follows:
	//
	//    * arm64
	//
	//    * i386
	//
	//    * x86_64
	Architecture *string `type:"string"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `type:"string"`

	// The date and time when the image was pushed to the repository.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces, and date and time should be separated by T. For example,
	// 2020-03-22T13:22:13.933Z.
	ImagePublishedAt *string `type:"string"`

	// The list of tags that are associated with the image.
	ImageTags []*string `type:"list"`

	// The Amazon Web Services account identifier that is associated with the registry
	// that the image belongs to.
	RegistryId *string `type:"string"`

	// The name of the repository that the image belongs to.
	RepositoryName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrContainerImageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrContainerImageDetails) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *AwsEcrContainerImageDetails) SetArchitecture(v string) *AwsEcrContainerImageDetails {
	s.Architecture = &v
	return s
}

// SetImageDigest sets the ImageDigest field's value.
func (s *AwsEcrContainerImageDetails) SetImageDigest(v string) *AwsEcrContainerImageDetails {
	s.ImageDigest = &v
	return s
}

// SetImagePublishedAt sets the ImagePublishedAt field's value.
func (s *AwsEcrContainerImageDetails) SetImagePublishedAt(v string) *AwsEcrContainerImageDetails {
	s.ImagePublishedAt = &v
	return s
}

// SetImageTags sets the ImageTags field's value.
func (s *AwsEcrContainerImageDetails) SetImageTags(v []*string) *AwsEcrContainerImageDetails {
	s.ImageTags = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *AwsEcrContainerImageDetails) SetRegistryId(v string) *AwsEcrContainerImageDetails {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *AwsEcrContainerImageDetails) SetRepositoryName(v string) *AwsEcrContainerImageDetails {
	s.RepositoryName = &v
	return s
}

// Provides information about an Amazon Elastic Container Registry repository.
type AwsEcrRepositoryDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the repository.
	Arn *string `type:"string"`

	// The image scanning configuration for a repository.
	ImageScanningConfiguration *AwsEcrRepositoryImageScanningConfigurationDetails `type:"structure"`

	// The tag mutability setting for the repository. Valid values are IMMUTABLE
	// or MUTABLE.
	ImageTagMutability *string `type:"string"`

	// Information about the lifecycle policy for the repository.
	LifecyclePolicy *AwsEcrRepositoryLifecyclePolicyDetails `type:"structure"`

	// The name of the repository.
	RepositoryName *string `type:"string"`

	// The text of the repository policy.
	RepositoryPolicyText *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryDetails) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AwsEcrRepositoryDetails) SetArn(v string) *AwsEcrRepositoryDetails {
	s.Arn = &v
	return s
}

// SetImageScanningConfiguration sets the ImageScanningConfiguration field's value.
func (s *AwsEcrRepositoryDetails) SetImageScanningConfiguration(v *AwsEcrRepositoryImageScanningConfigurationDetails) *AwsEcrRepositoryDetails {
	s.ImageScanningConfiguration = v
	return s
}

// SetImageTagMutability sets the ImageTagMutability field's value.
func (s *AwsEcrRepositoryDetails) SetImageTagMutability(v string) *AwsEcrRepositoryDetails {
	s.ImageTagMutability = &v
	return s
}

// SetLifecyclePolicy sets the LifecyclePolicy field's value.
func (s *AwsEcrRepositoryDetails) SetLifecyclePolicy(v *AwsEcrRepositoryLifecyclePolicyDetails) *AwsEcrRepositoryDetails {
	s.LifecyclePolicy = v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *AwsEcrRepositoryDetails) SetRepositoryName(v string) *AwsEcrRepositoryDetails {
	s.RepositoryName = &v
	return s
}

// SetRepositoryPolicyText sets the RepositoryPolicyText field's value.
func (s *AwsEcrRepositoryDetails) SetRepositoryPolicyText(v string) *AwsEcrRepositoryDetails {
	s.RepositoryPolicyText = &v
	return s
}

// The image scanning configuration for a repository.
type AwsEcrRepositoryImageScanningConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Whether to scan images after they are pushed to a repository.
	ScanOnPush *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryImageScanningConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryImageScanningConfigurationDetails) GoString() string {
	return s.String()
}

// SetScanOnPush sets the ScanOnPush field's value.
func (s *AwsEcrRepositoryImageScanningConfigurationDetails) SetScanOnPush(v bool) *AwsEcrRepositoryImageScanningConfigurationDetails {
	s.ScanOnPush = &v
	return s
}

// Information about the lifecycle policy for the repository.
type AwsEcrRepositoryLifecyclePolicyDetails struct {
	_ struct{} `type:"structure"`

	// The text of the lifecycle policy.
	LifecyclePolicyText *string `type:"string"`

	// The Amazon Web Services account identifier that is associated with the registry
	// that contains the repository.
	RegistryId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryLifecyclePolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryLifecyclePolicyDetails) GoString() string {
	return s.String()
}

// SetLifecyclePolicyText sets the LifecyclePolicyText field's value.
func (s *AwsEcrRepositoryLifecyclePolicyDetails) SetLifecyclePolicyText(v string) *AwsEcrRepositoryLifecyclePolicyDetails {
	s.LifecyclePolicyText = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *AwsEcrRepositoryLifecyclePolicyDetails) SetRegistryId(v string) *AwsEcrRepositoryLifecyclePolicyDetails {
	s.RegistryId = &v
	return s
}

// Indicates whether to enable CloudWatch Container Insights for the ECS cluster.
type AwsEcsClusterClusterSettingsDetails struct {
	_ struct{} `type:"structure"`

	// The name of the setting. The valid value is containerInsights.
	Name *string `type:"string"`

	// The value of the setting. Valid values are disabled or enabled.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterClusterSettingsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterClusterSettingsDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsEcsClusterClusterSettingsDetails) SetName(v string) *AwsEcsClusterClusterSettingsDetails {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsClusterClusterSettingsDetails) SetValue(v string) *AwsEcsClusterClusterSettingsDetails {
	s.Value = &v
	return s
}

// The run command configuration for the cluster.
type AwsEcsClusterConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Contains the run command configuration for the cluster.
	ExecuteCommandConfiguration *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationDetails) GoString() string {
	return s.String()
}

// SetExecuteCommandConfiguration sets the ExecuteCommandConfiguration field's value.
func (s *AwsEcsClusterConfigurationDetails) SetExecuteCommandConfiguration(v *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) *AwsEcsClusterConfigurationDetails {
	s.ExecuteCommandConfiguration = v
	return s
}

// Contains the run command configuration for the cluster.
type AwsEcsClusterConfigurationExecuteCommandConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the KMS key that is used to encrypt the data between the
	// local client and the container.
	KmsKeyId *string `type:"string"`

	// The log configuration for the results of the run command actions. Required
	// if Logging is NONE.
	LogConfiguration *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails `type:"structure"`

	// The log setting to use for redirecting logs for run command results.
	Logging *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) SetKmsKeyId(v string) *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails {
	s.KmsKeyId = &v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) SetLogConfiguration(v *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails {
	s.LogConfiguration = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) SetLogging(v string) *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails {
	s.Logging = &v
	return s
}

// The log configuration for the results of the run command actions.
type AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Whether to enable encryption on the CloudWatch logs.
	CloudWatchEncryptionEnabled *bool `type:"boolean"`

	// The name of the CloudWatch log group to send the logs to.
	CloudWatchLogGroupName *string `type:"string"`

	// The name of the S3 bucket to send logs to.
	S3BucketName *string `type:"string"`

	// Whether to encrypt the logs that are sent to the S3 bucket.
	S3EncryptionEnabled *bool `type:"boolean"`

	// Identifies the folder in the S3 bucket to send the logs to.
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) GoString() string {
	return s.String()
}

// SetCloudWatchEncryptionEnabled sets the CloudWatchEncryptionEnabled field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) SetCloudWatchEncryptionEnabled(v bool) *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
	s.CloudWatchEncryptionEnabled = &v
	return s
}

// SetCloudWatchLogGroupName sets the CloudWatchLogGroupName field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) SetCloudWatchLogGroupName(v string) *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
	s.CloudWatchLogGroupName = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) SetS3BucketName(v string) *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
	s.S3BucketName = &v
	return s
}

// SetS3EncryptionEnabled sets the S3EncryptionEnabled field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) SetS3EncryptionEnabled(v bool) *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
	s.S3EncryptionEnabled = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) SetS3KeyPrefix(v string) *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
	s.S3KeyPrefix = &v
	return s
}

// The default capacity provider strategy for the cluster. The default capacity
// provider strategy is used when services or tasks are run without a specified
// launch type or capacity provider strategy.
type AwsEcsClusterDefaultCapacityProviderStrategyDetails struct {
	_ struct{} `type:"structure"`

	// The minimum number of tasks to run on the specified capacity provider.
	Base *int64 `type:"integer"`

	// The name of the capacity provider.
	CapacityProvider *string `type:"string"`

	// The relative percentage of the total number of tasks launched that should
	// use the capacity provider.
	Weight *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterDefaultCapacityProviderStrategyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterDefaultCapacityProviderStrategyDetails) GoString() string {
	return s.String()
}

// SetBase sets the Base field's value.
func (s *AwsEcsClusterDefaultCapacityProviderStrategyDetails) SetBase(v int64) *AwsEcsClusterDefaultCapacityProviderStrategyDetails {
	s.Base = &v
	return s
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *AwsEcsClusterDefaultCapacityProviderStrategyDetails) SetCapacityProvider(v string) *AwsEcsClusterDefaultCapacityProviderStrategyDetails {
	s.CapacityProvider = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *AwsEcsClusterDefaultCapacityProviderStrategyDetails) SetWeight(v int64) *AwsEcsClusterDefaultCapacityProviderStrategyDetails {
	s.Weight = &v
	return s
}

// Provides details about an Amazon ECS cluster.
type AwsEcsClusterDetails struct {
	_ struct{} `type:"structure"`

	// The number of services that are running on the cluster in an ACTIVE state.
	// You can view these services with the Amazon ECS ListServices (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html)
	// API operation.
	ActiveServicesCount *int64 `type:"integer"`

	// The short name of one or more capacity providers to associate with the cluster.
	CapacityProviders []*string `type:"list"`

	// The Amazon Resource Name (ARN) that identifies the cluster.
	ClusterArn *string `type:"string"`

	// A name that you use to identify your cluster.
	ClusterName *string `type:"string"`

	// The setting to use to create the cluster. Specifically used to configure
	// whether to enable CloudWatch Container Insights for the cluster.
	ClusterSettings []*AwsEcsClusterClusterSettingsDetails `type:"list"`

	// The run command configuration for the cluster.
	Configuration *AwsEcsClusterConfigurationDetails `type:"structure"`

	// The default capacity provider strategy for the cluster. The default capacity
	// provider strategy is used when services or tasks are run without a specified
	// launch type or capacity provider strategy.
	DefaultCapacityProviderStrategy []*AwsEcsClusterDefaultCapacityProviderStrategyDetails `type:"list"`

	// The number of container instances registered into the cluster. This includes
	// container instances in both ACTIVE and DRAINING status.
	RegisteredContainerInstancesCount *int64 `type:"integer"`

	// The number of tasks in the cluster that are in the RUNNING state.
	RunningTasksCount *int64 `type:"integer"`

	// The status of the cluster.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterDetails) GoString() string {
	return s.String()
}

// SetActiveServicesCount sets the ActiveServicesCount field's value.
func (s *AwsEcsClusterDetails) SetActiveServicesCount(v int64) *AwsEcsClusterDetails {
	s.ActiveServicesCount = &v
	return s
}

// SetCapacityProviders sets the CapacityProviders field's value.
func (s *AwsEcsClusterDetails) SetCapacityProviders(v []*string) *AwsEcsClusterDetails {
	s.CapacityProviders = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *AwsEcsClusterDetails) SetClusterArn(v string) *AwsEcsClusterDetails {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *AwsEcsClusterDetails) SetClusterName(v string) *AwsEcsClusterDetails {
	s.ClusterName = &v
	return s
}

// SetClusterSettings sets the ClusterSettings field's value.
func (s *AwsEcsClusterDetails) SetClusterSettings(v []*AwsEcsClusterClusterSettingsDetails) *AwsEcsClusterDetails {
	s.ClusterSettings = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *AwsEcsClusterDetails) SetConfiguration(v *AwsEcsClusterConfigurationDetails) *AwsEcsClusterDetails {
	s.Configuration = v
	return s
}

// SetDefaultCapacityProviderStrategy sets the DefaultCapacityProviderStrategy field's value.
func (s *AwsEcsClusterDetails) SetDefaultCapacityProviderStrategy(v []*AwsEcsClusterDefaultCapacityProviderStrategyDetails) *AwsEcsClusterDetails {
	s.DefaultCapacityProviderStrategy = v
	return s
}

// SetRegisteredContainerInstancesCount sets the RegisteredContainerInstancesCount field's value.
func (s *AwsEcsClusterDetails) SetRegisteredContainerInstancesCount(v int64) *AwsEcsClusterDetails {
	s.RegisteredContainerInstancesCount = &v
	return s
}

// SetRunningTasksCount sets the RunningTasksCount field's value.
func (s *AwsEcsClusterDetails) SetRunningTasksCount(v int64) *AwsEcsClusterDetails {
	s.RunningTasksCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEcsClusterDetails) SetStatus(v string) *AwsEcsClusterDetails {
	s.Status = &v
	return s
}

// Provides information about an Amazon ECS container.
type AwsEcsContainerDetails struct {
	_ struct{} `type:"structure"`

	// The image used for the container.
	Image *string `type:"string"`

	// The mount points for data volumes in your container.
	MountPoints []*AwsMountPoint `type:"list"`

	// The name of the container.
	Name *string `type:"string"`

	// When this parameter is true, the container is given elevated privileges on
	// the host container instance (similar to the root user).
	Privileged *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsContainerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsContainerDetails) GoString() string {
	return s.String()
}

// SetImage sets the Image field's value.
func (s *AwsEcsContainerDetails) SetImage(v string) *AwsEcsContainerDetails {
	s.Image = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *AwsEcsContainerDetails) SetMountPoints(v []*AwsMountPoint) *AwsEcsContainerDetails {
	s.MountPoints = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEcsContainerDetails) SetName(v string) *AwsEcsContainerDetails {
	s.Name = &v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *AwsEcsContainerDetails) SetPrivileged(v bool) *AwsEcsContainerDetails {
	s.Privileged = &v
	return s
}

// Strategy item for the capacity provider strategy that the service uses.
type AwsEcsServiceCapacityProviderStrategyDetails struct {
	_ struct{} `type:"structure"`

	// The minimum number of tasks to run on the capacity provider. Only one strategy
	// item can specify a value for Base.
	//
	// The value must be between 0 and 100000.
	Base *int64 `type:"integer"`

	// The short name of the capacity provider.
	CapacityProvider *string `type:"string"`

	// The relative percentage of the total number of tasks that should use the
	// capacity provider.
	//
	// If no weight is specified, the default value is 0. At least one capacity
	// provider must have a weight greater than 0.
	//
	// The value can be between 0 and 1000.
	Weight *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceCapacityProviderStrategyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceCapacityProviderStrategyDetails) GoString() string {
	return s.String()
}

// SetBase sets the Base field's value.
func (s *AwsEcsServiceCapacityProviderStrategyDetails) SetBase(v int64) *AwsEcsServiceCapacityProviderStrategyDetails {
	s.Base = &v
	return s
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *AwsEcsServiceCapacityProviderStrategyDetails) SetCapacityProvider(v string) *AwsEcsServiceCapacityProviderStrategyDetails {
	s.CapacityProvider = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *AwsEcsServiceCapacityProviderStrategyDetails) SetWeight(v int64) *AwsEcsServiceCapacityProviderStrategyDetails {
	s.Weight = &v
	return s
}

// Determines whether a service deployment fails if a service cannot reach a
// steady state.
type AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails struct {
	_ struct{} `type:"structure"`

	// Whether to enable the deployment circuit breaker logic for the service.
	Enable *bool `type:"boolean"`

	// Whether to roll back the service if a service deployment fails. If rollback
	// is enabled, when a service deployment fails, the service is rolled back to
	// the last deployment that completed successfully.
	Rollback *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) SetEnable(v bool) *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails {
	s.Enable = &v
	return s
}

// SetRollback sets the Rollback field's value.
func (s *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) SetRollback(v bool) *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails {
	s.Rollback = &v
	return s
}

// Optional deployment parameters for the service.
type AwsEcsServiceDeploymentConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Determines whether a service deployment fails if a service cannot reach a
	// steady state.
	DeploymentCircuitBreaker *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails `type:"structure"`

	// For a service that uses the rolling update (ECS) deployment type, the maximum
	// number of tasks in a service that are allowed in the RUNNING or PENDING state
	// during a deployment, and for tasks that use the EC2 launch type, when any
	// container instances are in the DRAINING state. Provided as a percentage of
	// the desired number of tasks. The default value is 200%.
	//
	// For a service that uses the blue/green (CODE_DEPLOY) or EXTERNAL deployment
	// types, and tasks that use the EC2 launch type, the maximum number of tasks
	// in the service that remain in the RUNNING state while the container instances
	// are in the DRAINING state.
	//
	// For the Fargate launch type, the maximum percent value is not used.
	MaximumPercent *int64 `type:"integer"`

	// For a service that uses the rolling update (ECS) deployment type, the minimum
	// number of tasks in a service that must remain in the RUNNING state during
	// a deployment, and while any container instances are in the DRAINING state
	// if the service contains tasks using the EC2 launch type. Expressed as a percentage
	// of the desired number of tasks. The default value is 100%.
	//
	// For a service that uses the blue/green (CODE_DEPLOY) or EXTERNAL deployment
	// types and tasks that use the EC2 launch type, the minimum number of the tasks
	// in the service that remain in the RUNNING state while the container instances
	// are in the DRAINING state.
	//
	// For the Fargate launch type, the minimum healthy percent value is not used.
	MinimumHealthyPercent *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentConfigurationDetails) GoString() string {
	return s.String()
}

// SetDeploymentCircuitBreaker sets the DeploymentCircuitBreaker field's value.
func (s *AwsEcsServiceDeploymentConfigurationDetails) SetDeploymentCircuitBreaker(v *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) *AwsEcsServiceDeploymentConfigurationDetails {
	s.DeploymentCircuitBreaker = v
	return s
}

// SetMaximumPercent sets the MaximumPercent field's value.
func (s *AwsEcsServiceDeploymentConfigurationDetails) SetMaximumPercent(v int64) *AwsEcsServiceDeploymentConfigurationDetails {
	s.MaximumPercent = &v
	return s
}

// SetMinimumHealthyPercent sets the MinimumHealthyPercent field's value.
func (s *AwsEcsServiceDeploymentConfigurationDetails) SetMinimumHealthyPercent(v int64) *AwsEcsServiceDeploymentConfigurationDetails {
	s.MinimumHealthyPercent = &v
	return s
}

// Information about the deployment controller type that the service uses.
type AwsEcsServiceDeploymentControllerDetails struct {
	_ struct{} `type:"structure"`

	// The rolling update (ECS) deployment type replaces the current running version
	// of the container with the latest version.
	//
	// The blue/green (CODE_DEPLOY) deployment type uses the blue/green deployment
	// model that is powered by CodeDeploy. This deployment model a new deployment
	// of a service can be verified before production traffic is sent to it.
	//
	// The external (EXTERNAL) deployment type allows the use of any third-party
	// deployment controller for full control over the deployment process for an
	// Amazon ECS service.
	//
	// Valid values: ECS | CODE_DEPLOY | EXTERNAL
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentControllerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentControllerDetails) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *AwsEcsServiceDeploymentControllerDetails) SetType(v string) *AwsEcsServiceDeploymentControllerDetails {
	s.Type = &v
	return s
}

// Provides details about a service within an ECS cluster.
type AwsEcsServiceDetails struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy that the service uses.
	CapacityProviderStrategy []*AwsEcsServiceCapacityProviderStrategyDetails `type:"list"`

	// The ARN of the cluster that hosts the service.
	Cluster *string `type:"string"`

	// Deployment parameters for the service. Includes the number of tasks that
	// run and the order in which to start and stop tasks.
	DeploymentConfiguration *AwsEcsServiceDeploymentConfigurationDetails `type:"structure"`

	// Contains the deployment controller type that the service uses.
	DeploymentController *AwsEcsServiceDeploymentControllerDetails `type:"structure"`

	// The number of instantiations of the task definition to run on the service.
	DesiredCount *int64 `type:"integer"`

	// Whether to enable Amazon ECS managed tags for the tasks in the service.
	EnableEcsManagedTags *bool `type:"boolean"`

	// Whether the execute command functionality is enabled for the service.
	EnableExecuteCommand *bool `type:"boolean"`

	// After a task starts, the amount of time in seconds that the Amazon ECS service
	// scheduler ignores unhealthy Elastic Load Balancing target health checks.
	HealthCheckGracePeriodSeconds *int64 `type:"integer"`

	// The launch type that the service uses.
	//
	// Valid values: EC2 | FARGATE | EXTERNAL
	LaunchType *string `type:"string"`

	// Information about the load balancers that the service uses.
	LoadBalancers []*AwsEcsServiceLoadBalancersDetails `type:"list"`

	// The name of the service.
	Name *string `type:"string"`

	// For tasks that use the awsvpc networking mode, the VPC subnet and security
	// group configuration.
	NetworkConfiguration *AwsEcsServiceNetworkConfigurationDetails `type:"structure"`

	// The placement constraints for the tasks in the service.
	PlacementConstraints []*AwsEcsServicePlacementConstraintsDetails `type:"list"`

	// Information about how tasks for the service are placed.
	PlacementStrategies []*AwsEcsServicePlacementStrategiesDetails `type:"list"`

	// The platform version on which to run the service. Only specified for tasks
	// that are hosted on Fargate. If a platform version is not specified, the LATEST
	// platform version is used by default.
	PlatformVersion *string `type:"string"`

	// Indicates whether to propagate the tags from the task definition to the task
	// or from the service to the task. If no value is provided, then tags are not
	// propagated.
	//
	// Valid values: TASK_DEFINITION | SERVICE
	PropagateTags *string `type:"string"`

	// The ARN of the IAM role that is associated with the service. The role allows
	// the Amazon ECS container agent to register container instances with an Elastic
	// Load Balancing load balancer.
	Role *string `type:"string"`

	// The scheduling strategy to use for the service.
	//
	// The REPLICA scheduling strategy places and maintains the desired number of
	// tasks across the cluster. By default, the service scheduler spreads tasks
	// across Availability Zones. Task placement strategies and constraints are
	// used to customize task placement decisions.
	//
	// The DAEMON scheduling strategy deploys exactly one task on each active container
	// instance that meets all of the task placement constraints that are specified
	// in the cluster. The service scheduler also evaluates the task placement constraints
	// for running tasks and stops tasks that do not meet the placement constraints.
	//
	// Valid values: REPLICA | DAEMON
	SchedulingStrategy *string `type:"string"`

	// The ARN of the service.
	ServiceArn *string `type:"string"`

	// The name of the service.
	//
	// The name can contain up to 255 characters. It can use letters, numbers, underscores,
	// and hyphens.
	ServiceName *string `type:"string"`

	// Information about the service discovery registries to assign to the service.
	ServiceRegistries []*AwsEcsServiceServiceRegistriesDetails `type:"list"`

	// The task definition to use for tasks in the service.
	TaskDefinition *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDetails) GoString() string {
	return s.String()
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *AwsEcsServiceDetails) SetCapacityProviderStrategy(v []*AwsEcsServiceCapacityProviderStrategyDetails) *AwsEcsServiceDetails {
	s.CapacityProviderStrategy = v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *AwsEcsServiceDetails) SetCluster(v string) *AwsEcsServiceDetails {
	s.Cluster = &v
	return s
}

// SetDeploymentConfiguration sets the DeploymentConfiguration field's value.
func (s *AwsEcsServiceDetails) SetDeploymentConfiguration(v *AwsEcsServiceDeploymentConfigurationDetails) *AwsEcsServiceDetails {
	s.DeploymentConfiguration = v
	return s
}

// SetDeploymentController sets the DeploymentController field's value.
func (s *AwsEcsServiceDetails) SetDeploymentController(v *AwsEcsServiceDeploymentControllerDetails) *AwsEcsServiceDetails {
	s.DeploymentController = v
	return s
}

// SetDesiredCount sets the DesiredCount field's value.
func (s *AwsEcsServiceDetails) SetDesiredCount(v int64) *AwsEcsServiceDetails {
	s.DesiredCount = &v
	return s
}

// SetEnableEcsManagedTags sets the EnableEcsManagedTags field's value.
func (s *AwsEcsServiceDetails) SetEnableEcsManagedTags(v bool) *AwsEcsServiceDetails {
	s.EnableEcsManagedTags = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *AwsEcsServiceDetails) SetEnableExecuteCommand(v bool) *AwsEcsServiceDetails {
	s.EnableExecuteCommand = &v
	return s
}

// SetHealthCheckGracePeriodSeconds sets the HealthCheckGracePeriodSeconds field's value.
func (s *AwsEcsServiceDetails) SetHealthCheckGracePeriodSeconds(v int64) *AwsEcsServiceDetails {
	s.HealthCheckGracePeriodSeconds = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *AwsEcsServiceDetails) SetLaunchType(v string) *AwsEcsServiceDetails {
	s.LaunchType = &v
	return s
}

// SetLoadBalancers sets the LoadBalancers field's value.
func (s *AwsEcsServiceDetails) SetLoadBalancers(v []*AwsEcsServiceLoadBalancersDetails) *AwsEcsServiceDetails {
	s.LoadBalancers = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEcsServiceDetails) SetName(v string) *AwsEcsServiceDetails {
	s.Name = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *AwsEcsServiceDetails) SetNetworkConfiguration(v *AwsEcsServiceNetworkConfigurationDetails) *AwsEcsServiceDetails {
	s.NetworkConfiguration = v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *AwsEcsServiceDetails) SetPlacementConstraints(v []*AwsEcsServicePlacementConstraintsDetails) *AwsEcsServiceDetails {
	s.PlacementConstraints = v
	return s
}

// SetPlacementStrategies sets the PlacementStrategies field's value.
func (s *AwsEcsServiceDetails) SetPlacementStrategies(v []*AwsEcsServicePlacementStrategiesDetails) *AwsEcsServiceDetails {
	s.PlacementStrategies = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *AwsEcsServiceDetails) SetPlatformVersion(v string) *AwsEcsServiceDetails {
	s.PlatformVersion = &v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *AwsEcsServiceDetails) SetPropagateTags(v string) *AwsEcsServiceDetails {
	s.PropagateTags = &v
	return s
}

// SetRole sets the Role field's value.
func (s *AwsEcsServiceDetails) SetRole(v string) *AwsEcsServiceDetails {
	s.Role = &v
	return s
}

// SetSchedulingStrategy sets the SchedulingStrategy field's value.
func (s *AwsEcsServiceDetails) SetSchedulingStrategy(v string) *AwsEcsServiceDetails {
	s.SchedulingStrategy = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *AwsEcsServiceDetails) SetServiceArn(v string) *AwsEcsServiceDetails {
	s.ServiceArn = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AwsEcsServiceDetails) SetServiceName(v string) *AwsEcsServiceDetails {
	s.ServiceName = &v
	return s
}

// SetServiceRegistries sets the ServiceRegistries field's value.
func (s *AwsEcsServiceDetails) SetServiceRegistries(v []*AwsEcsServiceServiceRegistriesDetails) *AwsEcsServiceDetails {
	s.ServiceRegistries = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *AwsEcsServiceDetails) SetTaskDefinition(v string) *AwsEcsServiceDetails {
	s.TaskDefinition = &v
	return s
}

// Information about a load balancer that the service uses.
type AwsEcsServiceLoadBalancersDetails struct {
	_ struct{} `type:"structure"`

	// The name of the container to associate with the load balancer.
	ContainerName *string `type:"string"`

	// The port on the container to associate with the load balancer. This port
	// must correspond to a containerPort in the task definition the tasks in the
	// service are using. For tasks that use the EC2 launch type, the container
	// instance they are launched on must allow ingress traffic on the hostPort
	// of the port mapping.
	ContainerPort *int64 `type:"integer"`

	// The name of the load balancer to associate with the Amazon ECS service or
	// task set.
	//
	// Only specified when using a Classic Load Balancer. For an Application Load
	// Balancer or a Network Load Balancer, the load balancer name is omitted.
	LoadBalancerName *string `type:"string"`

	// The ARN of the Elastic Load Balancing target group or groups associated with
	// a service or task set.
	//
	// Only specified when using an Application Load Balancer or a Network Load
	// Balancer. For a Classic Load Balancer, the target group ARN is omitted.
	TargetGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceLoadBalancersDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceLoadBalancersDetails) GoString() string {
	return s.String()
}

// SetContainerName sets the ContainerName field's value.
func (s *AwsEcsServiceLoadBalancersDetails) SetContainerName(v string) *AwsEcsServiceLoadBalancersDetails {
	s.ContainerName = &v
	return s
}

// SetContainerPort sets the ContainerPort field's value.
func (s *AwsEcsServiceLoadBalancersDetails) SetContainerPort(v int64) *AwsEcsServiceLoadBalancersDetails {
	s.ContainerPort = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *AwsEcsServiceLoadBalancersDetails) SetLoadBalancerName(v string) *AwsEcsServiceLoadBalancersDetails {
	s.LoadBalancerName = &v
	return s
}

// SetTargetGroupArn sets the TargetGroupArn field's value.
func (s *AwsEcsServiceLoadBalancersDetails) SetTargetGroupArn(v string) *AwsEcsServiceLoadBalancersDetails {
	s.TargetGroupArn = &v
	return s
}

// For tasks that use the awsvpc networking mode, the VPC subnet and security
// group configuration.
type AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Whether the task's elastic network interface receives a public IP address.
	// The default value is DISABLED.
	//
	// Valid values: ENABLED | DISABLED
	AssignPublicIp *string `type:"string"`

	// The IDs of the security groups associated with the task or service.
	//
	// You can provide up to five security groups.
	SecurityGroups []*string `type:"list"`

	// The IDs of the subnets associated with the task or service.
	//
	// You can provide up to 16 subnets.
	Subnets []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) GoString() string {
	return s.String()
}

// SetAssignPublicIp sets the AssignPublicIp field's value.
func (s *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) SetAssignPublicIp(v string) *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
	s.AssignPublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) SetSecurityGroups(v []*string) *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) SetSubnets(v []*string) *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
	s.Subnets = v
	return s
}

// For tasks that use the awsvpc networking mode, the VPC subnet and security
// group configuration.
type AwsEcsServiceNetworkConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The VPC subnet and security group configuration.
	AwsVpcConfiguration *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceNetworkConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceNetworkConfigurationDetails) GoString() string {
	return s.String()
}

// SetAwsVpcConfiguration sets the AwsVpcConfiguration field's value.
func (s *AwsEcsServiceNetworkConfigurationDetails) SetAwsVpcConfiguration(v *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) *AwsEcsServiceNetworkConfigurationDetails {
	s.AwsVpcConfiguration = v
	return s
}

// A placement constraint for the tasks in the service.
type AwsEcsServicePlacementConstraintsDetails struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint. You cannot
	// specify an expression if the constraint type is distinctInstance.
	Expression *string `type:"string"`

	// The type of constraint. Use distinctInstance to run each task in a particular
	// group on a different container instance. Use memberOf to restrict the selection
	// to a group of valid candidates.
	//
	// Valid values: distinctInstance | memberOf
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServicePlacementConstraintsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServicePlacementConstraintsDetails) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *AwsEcsServicePlacementConstraintsDetails) SetExpression(v string) *AwsEcsServicePlacementConstraintsDetails {
	s.Expression = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEcsServicePlacementConstraintsDetails) SetType(v string) *AwsEcsServicePlacementConstraintsDetails {
	s.Type = &v
	return s
}

// A placement strategy that determines how to place the tasks for the service.
type AwsEcsServicePlacementStrategiesDetails struct {
	_ struct{} `type:"structure"`

	// The field to apply the placement strategy against.
	//
	// For the spread placement strategy, valid values are instanceId (or host,
	// which has the same effect), or any platform or custom attribute that is applied
	// to a container instance, such as attribute:ecs.availability-zone.
	//
	// For the binpack placement strategy, valid values are cpu and memory.
	//
	// For the random placement strategy, this attribute is not used.
	Field *string `type:"string"`

	// The type of placement strategy.
	//
	// The random placement strategy randomly places tasks on available candidates.
	//
	// The spread placement strategy spreads placement across available candidates
	// evenly based on the value of Field.
	//
	// The binpack strategy places tasks on available candidates that have the least
	// available amount of the resource that is specified in Field.
	//
	// Valid values: random | spread | binpack
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServicePlacementStrategiesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServicePlacementStrategiesDetails) GoString() string {
	return s.String()
}

// SetField sets the Field field's value.
func (s *AwsEcsServicePlacementStrategiesDetails) SetField(v string) *AwsEcsServicePlacementStrategiesDetails {
	s.Field = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEcsServicePlacementStrategiesDetails) SetType(v string) *AwsEcsServicePlacementStrategiesDetails {
	s.Type = &v
	return s
}

// Information about a service discovery registry to assign to the service.
type AwsEcsServiceServiceRegistriesDetails struct {
	_ struct{} `type:"structure"`

	// The container name value to use for the service discovery service.
	//
	// If the task definition uses the bridge or host network mode, you must specify
	// ContainerName and ContainerPort.
	//
	// If the task definition uses the awsvpc network mode and a type SRV DNS record,
	// you must specify either ContainerName and ContainerPort, or Port , but not
	// both.
	ContainerName *string `type:"string"`

	// The port value to use for the service discovery service.
	//
	// If the task definition uses the bridge or host network mode, you must specify
	// ContainerName and ContainerPort.
	//
	// If the task definition uses the awsvpc network mode and a type SRV DNS record,
	// you must specify either ContainerName and ContainerPort, or Port , but not
	// both.
	ContainerPort *int64 `type:"integer"`

	// The port value to use for a service discovery service that specifies an SRV
	// record. This field can be used if both the awsvpcawsvpc network mode and
	// SRV records are used.
	Port *int64 `type:"integer"`

	// The ARN of the service registry.
	RegistryArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceServiceRegistriesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceServiceRegistriesDetails) GoString() string {
	return s.String()
}

// SetContainerName sets the ContainerName field's value.
func (s *AwsEcsServiceServiceRegistriesDetails) SetContainerName(v string) *AwsEcsServiceServiceRegistriesDetails {
	s.ContainerName = &v
	return s
}

// SetContainerPort sets the ContainerPort field's value.
func (s *AwsEcsServiceServiceRegistriesDetails) SetContainerPort(v int64) *AwsEcsServiceServiceRegistriesDetails {
	s.ContainerPort = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsEcsServiceServiceRegistriesDetails) SetPort(v int64) *AwsEcsServiceServiceRegistriesDetails {
	s.Port = &v
	return s
}

// SetRegistryArn sets the RegistryArn field's value.
func (s *AwsEcsServiceServiceRegistriesDetails) SetRegistryArn(v string) *AwsEcsServiceServiceRegistriesDetails {
	s.RegistryArn = &v
	return s
}

// A dependency that is defined for container startup and shutdown.
type AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails struct {
	_ struct{} `type:"structure"`

	// The dependency condition of the dependent container. Indicates the required
	// status of the dependent container before the current container can start.
	// Valid values are as follows:
	//
	//    * COMPLETE
	//
	//    * HEALTHY
	//
	//    * SUCCESS
	//
	//    * START
	Condition *string `type:"string"`

	// The name of the dependent container.
	ContainerName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) SetCondition(v string) *AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails {
	s.Condition = &v
	return s
}

// SetContainerName sets the ContainerName field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) SetContainerName(v string) *AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails {
	s.ContainerName = &v
	return s
}

// A container definition that describes a container in the task.
type AwsEcsTaskDefinitionContainerDefinitionsDetails struct {
	_ struct{} `type:"structure"`

	// The command that is passed to the container.
	Command []*string `type:"list"`

	// The number of CPU units reserved for the container.
	Cpu *int64 `type:"integer"`

	// The dependencies that are defined for container startup and shutdown.
	DependsOn []*AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails `type:"list"`

	// Whether to disable networking within the container.
	DisableNetworking *bool `type:"boolean"`

	// A list of DNS search domains that are presented to the container.
	DnsSearchDomains []*string `type:"list"`

	// A list of DNS servers that are presented to the container.
	DnsServers []*string `type:"list"`

	// A key-value map of labels to add to the container.
	DockerLabels map[string]*string `type:"map"`

	// A list of strings to provide custom labels for SELinux and AppArmor multi-level
	// security systems.
	DockerSecurityOptions []*string `type:"list"`

	// The entry point that is passed to the container.
	EntryPoint []*string `type:"list"`

	// The environment variables to pass to a container.
	Environment []*AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails `type:"list"`

	// A list of files containing the environment variables to pass to a container.
	EnvironmentFiles []*AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails `type:"list"`

	// Whether the container is essential. All tasks must have at least one essential
	// container.
	Essential *bool `type:"boolean"`

	// A list of hostnames and IP address mappings to append to the /etc/hosts file
	// on the container.
	ExtraHosts []*AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails `type:"list"`

	// The FireLens configuration for the container. Specifies and configures a
	// log router for container logs.
	FirelensConfiguration *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails `type:"structure"`

	// The container health check command and associated configuration parameters
	// for the container.
	HealthCheck *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails `type:"structure"`

	// The hostname to use for the container.
	Hostname *string `type:"string"`

	// The image used to start the container.
	Image *string `type:"string"`

	// If set to true, then containerized applications can be deployed that require
	// stdin or a tty to be allocated.
	Interactive *bool `type:"boolean"`

	// A list of links for the container in the form container_name:alias . Allows
	// containers to communicate with each other without the need for port mappings.
	Links []*string `type:"list"`

	// Linux-specific modifications that are applied to the container, such as Linux
	// kernel capabilities.
	LinuxParameters *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails `type:"structure"`

	// The log configuration specification for the container.
	LogConfiguration *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails `type:"structure"`

	// The amount (in MiB) of memory to present to the container. If the container
	// attempts to exceed the memory specified here, the container is shut down.
	// The total amount of memory reserved for all containers within a task must
	// be lower than the task memory value, if one is specified.
	Memory *int64 `type:"integer"`

	// The soft limit (in MiB) of memory to reserve for the container.
	MemoryReservation *int64 `type:"integer"`

	// The mount points for the data volumes in the container.
	MountPoints []*AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails `type:"list"`

	// The name of the container.
	Name *string `type:"string"`

	// The list of port mappings for the container.
	PortMappings []*AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails `type:"list"`

	// Whether the container is given elevated privileges on the host container
	// instance. The elevated privileges are similar to the root user.
	Privileged *bool `type:"boolean"`

	// Whether to allocate a TTY to the container.
	PseudoTerminal *bool `type:"boolean"`

	// Whether the container is given read-only access to its root file system.
	ReadonlyRootFilesystem *bool `type:"boolean"`

	// The private repository authentication credentials to use.
	RepositoryCredentials *AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails `type:"structure"`

	// The type and amount of a resource to assign to a container. The only supported
	// resource is a GPU.
	ResourceRequirements []*AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails `type:"list"`

	// The secrets to pass to the container.
	Secrets []*AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails `type:"list"`

	// The number of seconds to wait before giving up on resolving dependencies
	// for a container.
	StartTimeout *int64 `type:"integer"`

	// The number of seconds to wait before the container is stopped if it doesn't
	// shut down normally on its own.
	StopTimeout *int64 `type:"integer"`

	// A list of namespaced kernel parameters to set in the container.
	SystemControls []*AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails `type:"list"`

	// A list of ulimits to set in the container.
	Ulimits []*AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails `type:"list"`

	// The user to use inside the container.
	//
	// The value can use one of the following formats.
	//
	//    * user
	//
	//    * user :group
	//
	//    * uid
	//
	//    * uid :gid
	//
	//    * user :gid
	//
	//    * uid :group
	User *string `type:"string"`

	// Data volumes to mount from another container.
	VolumesFrom []*AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails `type:"list"`

	// The working directory in which to run commands inside the container.
	WorkingDirectory *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsDetails) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetCommand(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Command = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetCpu(v int64) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Cpu = &v
	return s
}

// SetDependsOn sets the DependsOn field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDependsOn(v []*AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DependsOn = v
	return s
}

// SetDisableNetworking sets the DisableNetworking field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDisableNetworking(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DisableNetworking = &v
	return s
}

// SetDnsSearchDomains sets the DnsSearchDomains field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDnsSearchDomains(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DnsSearchDomains = v
	return s
}

// SetDnsServers sets the DnsServers field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDnsServers(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DnsServers = v
	return s
}

// SetDockerLabels sets the DockerLabels field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDockerLabels(v map[string]*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DockerLabels = v
	return s
}

// SetDockerSecurityOptions sets the DockerSecurityOptions field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDockerSecurityOptions(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DockerSecurityOptions = v
	return s
}

// SetEntryPoint sets the EntryPoint field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetEntryPoint(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.EntryPoint = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetEnvironment(v []*AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Environment = v
	return s
}

// SetEnvironmentFiles sets the EnvironmentFiles field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetEnvironmentFiles(v []*AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.EnvironmentFiles = v
	return s
}

// SetEssential sets the Essential field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetEssential(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Essential = &v
	return s
}

// SetExtraHosts sets the ExtraHosts field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetExtraHosts(v []*AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.ExtraHosts = v
	return s
}

// SetFirelensConfiguration sets the FirelensConfiguration field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetFirelensConfiguration(v *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.FirelensConfiguration = v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetHealthCheck(v *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.HealthCheck = v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetHostname(v string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Hostname = &v
	return s
}

// SetImage sets the Image field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetImage(v string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Image = &v
	return s
}

// SetInteractive sets the Interactive field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetInteractive(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Interactive = &v
	return s
}

// SetLinks sets the Links field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetLinks(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Links = v
	return s
}

// SetLinuxParameters sets the LinuxParameters field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetLinuxParameters(v *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.LinuxParameters = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetLogConfiguration(v *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.LogConfiguration = v
	return s
}

// SetMemory sets the Memory field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetMemory(v int64) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Memory = &v
	return s
}

// SetMemoryReservation sets the MemoryReservation field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetMemoryReservation(v int64) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.MemoryReservation = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetMountPoints(v []*AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.MountPoints = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetName(v string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Name = &v
	return s
}

// SetPortMappings sets the PortMappings field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetPortMappings(v []*AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.PortMappings = v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetPrivileged(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Privileged = &v
	return s
}

// SetPseudoTerminal sets the PseudoTerminal field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetPseudoTerminal(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.PseudoTerminal = &v
	return s
}

// SetReadonlyRootFilesystem sets the ReadonlyRootFilesystem field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetReadonlyRootFilesystem(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.ReadonlyRootFilesystem = &v
	return s
}

// SetRepositoryCredentials sets the RepositoryCredentials field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetRepositoryCredentials(v *AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.RepositoryCredentials = v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetResourceRequirements(v []*AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.ResourceRequirements = v
	return s
}

// SetSecrets sets the Secrets field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetSecrets(v []*AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Secrets = v
	return s
}

// SetStartTimeout sets the StartTimeout field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetStartTimeout(v int64) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.StartTimeout = &v
	return s
}

// SetStopTimeout sets the StopTimeout field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetStopTimeout(v int64) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.StopTimeout = &v
	return s
}

// SetSystemControls sets the SystemControls field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetSystemControls(v []*AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.SystemControls = v
	return s
}

// SetUlimits sets the Ulimits field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetUlimits(v []*AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Ulimits = v
	return s
}

// SetUser sets the User field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetUser(v string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.User = &v
	return s
}

// SetVolumesFrom sets the VolumesFrom field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetVolumesFrom(v []*AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.VolumesFrom = v
	return s
}

// SetWorkingDirectory sets the WorkingDirectory field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetWorkingDirectory(v string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.WorkingDirectory = &v
	return s
}

// An environment variable to pass to the container.
type AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails struct {
	_ struct{} `type:"structure"`

	// The name of the environment variable.
	Name *string `type:"string"`

	// The value of the environment variable.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails) SetName(v string) *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails) SetValue(v string) *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails {
	s.Value = &v
	return s
}

// A file that contain environment variables to pass to a container.
type AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails struct {
	_ struct{} `type:"structure"`

	// The type of environment file. The valid value is s3.
	Type *string `type:"string"`

	// The ARN of the S3 object that contains the environment variable file.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails) SetType(v string) *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails) SetValue(v string) *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails {
	s.Value = &v
	return s
}

// A hostname and IP address mapping to append to the /etc/hosts file on the
// container.
type AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails struct {
	_ struct{} `type:"structure"`

	// The hostname to use in the /etc/hosts entry.
	Hostname *string `type:"string"`

	// The IP address to use in the /etc/hosts entry.
	IpAddress *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails) GoString() string {
	return s.String()
}

// SetHostname sets the Hostname field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails) SetHostname(v string) *AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails {
	s.Hostname = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails) SetIpAddress(v string) *AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails {
	s.IpAddress = &v
	return s
}

// The FireLens configuration for the container. The configuration specifies
// and configures a log router for container logs.
type AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The options to use to configure the log router.
	//
	// The valid option keys are as follows:
	//
	//    * enable-ecs-log-metadata. The value can be true or false.
	//
	//    * config-file-type. The value can be s3 or file.
	//
	//    * config-file-value. The value is either an S3 ARN or a file path.
	Options map[string]*string `type:"map"`

	// The log router to use. Valid values are fluentbit or fluentd.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) SetOptions(v map[string]*string) *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails {
	s.Options = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) SetType(v string) *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails {
	s.Type = &v
	return s
}

// The container health check command and associated configuration parameters
// for the container.
type AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails struct {
	_ struct{} `type:"structure"`

	// The command that the container runs to determine whether it is healthy.
	Command []*string `type:"list"`

	// The time period in seconds between each health check execution. The default
	// value is 30 seconds.
	Interval *int64 `type:"integer"`

	// The number of times to retry a failed health check before the container is
	// considered unhealthy. The default value is 3.
	Retries *int64 `type:"integer"`

	// The optional grace period in seconds that allows containers time to bootstrap
	// before failed health checks count towards the maximum number of retries.
	StartPeriod *int64 `type:"integer"`

	// The time period in seconds to wait for a health check to succeed before it
	// is considered a failure. The default value is 5.
	Timeout *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) SetCommand(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
	s.Command = v
	return s
}

// SetInterval sets the Interval field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) SetInterval(v int64) *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
	s.Interval = &v
	return s
}

// SetRetries sets the Retries field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) SetRetries(v int64) *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
	s.Retries = &v
	return s
}

// SetStartPeriod sets the StartPeriod field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) SetStartPeriod(v int64) *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
	s.StartPeriod = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) SetTimeout(v int64) *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
	s.Timeout = &v
	return s
}

// The Linux capabilities for the container that are added to or dropped from
// the default configuration provided by Docker.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails struct {
	_ struct{} `type:"structure"`

	// The Linux capabilities for the container that are added to the default configuration
	// provided by Docker. Valid values are as follows:
	//
	// Valid values: "ALL" | "AUDIT_CONTROL" |"AUDIT_WRITE" | "BLOCK_SUSPEND" |
	// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK"
	// | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" |"MAC_OVERRIDE"
	// | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW"
	// | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT"
	// | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" |
	// "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
	// "WAKE_ALARM"
	Add []*string `type:"list"`

	// The Linux capabilities for the container that are dropped from the default
	// configuration provided by Docker.
	//
	// Valid values: "ALL" | "AUDIT_CONTROL" |"AUDIT_WRITE" | "BLOCK_SUSPEND" |
	// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK"
	// | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" |"MAC_OVERRIDE"
	// | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW"
	// | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT"
	// | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" |
	// "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
	// "WAKE_ALARM"
	Drop []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails) GoString() string {
	return s.String()
}

// SetAdd sets the Add field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails) SetAdd(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails {
	s.Add = v
	return s
}

// SetDrop sets the Drop field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails) SetDrop(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails {
	s.Drop = v
	return s
}

// >Linux-specific modifications that are applied to the container, such as
// Linux kernel capabilities.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails struct {
	_ struct{} `type:"structure"`

	// The Linux capabilities for the container that are added to or dropped from
	// the default configuration provided by Docker.
	Capabilities *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails `type:"structure"`

	// The host devices to expose to the container.
	Devices []*AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails `type:"list"`

	// Whether to run an init process inside the container that forwards signals
	// and reaps processes.
	InitProcessEnabled *bool `type:"boolean"`

	// The total amount of swap memory (in MiB) that a container can use.
	MaxSwap *int64 `type:"integer"`

	// The value for the size (in MiB) of the /dev/shm volume.
	SharedMemorySize *int64 `type:"integer"`

	// Configures the container's memory swappiness behavior. Determines how aggressively
	// pages are swapped. The higher the value, the more aggressive the swappiness.
	// The default is 60.
	Swappiness *int64 `type:"integer"`

	// The container path, mount options, and size (in MiB) of the tmpfs mount.
	Tmpfs []*AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetCapabilities(v *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.Capabilities = v
	return s
}

// SetDevices sets the Devices field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetDevices(v []*AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.Devices = v
	return s
}

// SetInitProcessEnabled sets the InitProcessEnabled field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetInitProcessEnabled(v bool) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.InitProcessEnabled = &v
	return s
}

// SetMaxSwap sets the MaxSwap field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetMaxSwap(v int64) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.MaxSwap = &v
	return s
}

// SetSharedMemorySize sets the SharedMemorySize field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetSharedMemorySize(v int64) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.SharedMemorySize = &v
	return s
}

// SetSwappiness sets the Swappiness field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetSwappiness(v int64) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.Swappiness = &v
	return s
}

// SetTmpfs sets the Tmpfs field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetTmpfs(v []*AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.Tmpfs = v
	return s
}

// A host device to expose to the container.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails struct {
	_ struct{} `type:"structure"`

	// The path inside the container at which to expose the host device.
	ContainerPath *string `type:"string"`

	// The path for the device on the host container instance.
	HostPath *string `type:"string"`

	// The explicit permissions to provide to the container for the device. By default,
	// the container has permissions for read, write, and mknod for the device.
	Permissions []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) GoString() string {
	return s.String()
}

// SetContainerPath sets the ContainerPath field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) SetContainerPath(v string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails {
	s.ContainerPath = &v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) SetHostPath(v string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails {
	s.HostPath = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) SetPermissions(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails {
	s.Permissions = v
	return s
}

// The container path, mount options, and size (in MiB) of a tmpfs mount.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails struct {
	_ struct{} `type:"structure"`

	// The absolute file path where the tmpfs volume is to be mounted.
	ContainerPath *string `type:"string"`

	// The list of tmpfs volume mount options.
	//
	// Valid values: "defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev"
	// |"exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" |
	// "nomand" | "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind"
	// | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared"
	// | "slave" | "rslave" | "relatime" | "norelatime" | "strictatime" | "nostrictatime"
	// |"mode" | "uid" | "gid" | "nr_inodes" |"nr_blocks" | "mpol"
	MountOptions []*string `type:"list"`

	// The maximum size (in MiB) of the tmpfs volume.
	Size *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) GoString() string {
	return s.String()
}

// SetContainerPath sets the ContainerPath field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) SetContainerPath(v string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails {
	s.ContainerPath = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) SetMountOptions(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails {
	s.MountOptions = v
	return s
}

// SetSize sets the Size field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) SetSize(v int64) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails {
	s.Size = &v
	return s
}

// The log configuration specification for the container.
type AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The log driver to use for the container.
	//
	// Valid values on Fargate are as follows:
	//
	//    * awsfirelens
	//
	//    * awslogs
	//
	//    * splunk
	//
	// Valid values on Amazon EC2 are as follows:
	//
	//    * awsfirelens
	//
	//    * awslogs
	//
	//    * fluentd
	//
	//    * gelf
	//
	//    * journald
	//
	//    * json-file
	//
	//    * logentries
	//
	//    * splunk
	//
	//    * syslog
	LogDriver *string `type:"string"`

	// The configuration options to send to the log driver. Requires version 1.19
	// of the Docker Remote API or greater on your container instance.
	Options map[string]*string `type:"map"`

	// The secrets to pass to the log configuration.
	SecretOptions []*AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) GoString() string {
	return s.String()
}

// SetLogDriver sets the LogDriver field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) SetLogDriver(v string) *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
	s.LogDriver = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) SetOptions(v map[string]*string) *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
	s.Options = v
	return s
}

// SetSecretOptions sets the SecretOptions field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) SetSecretOptions(v []*AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
	s.SecretOptions = v
	return s
}

// A secret to pass to the log configuration.
type AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails struct {
	_ struct{} `type:"structure"`

	// The name of the secret.
	Name *string `type:"string"`

	// The secret to expose to the container.
	//
	// The value is either the full ARN of the Secrets Manager secret or the full
	// ARN of the parameter in the Systems Manager Parameter Store.
	ValueFrom *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) SetName(v string) *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails {
	s.Name = &v
	return s
}

// SetValueFrom sets the ValueFrom field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) SetValueFrom(v string) *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails {
	s.ValueFrom = &v
	return s
}

// A mount point for the data volumes in the container.
type AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails struct {
	_ struct{} `type:"structure"`

	// The path on the container to mount the host volume at.
	ContainerPath *string `type:"string"`

	// Whether the container has read-only access to the volume.
	ReadOnly *bool `type:"boolean"`

	// The name of the volume to mount. Must match the name of a volume listed in
	// VolumeDetails for the task definition.
	SourceVolume *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) GoString() string {
	return s.String()
}

// SetContainerPath sets the ContainerPath field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) SetContainerPath(v string) *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
	s.ContainerPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) SetReadOnly(v bool) *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
	s.ReadOnly = &v
	return s
}

// SetSourceVolume sets the SourceVolume field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) SetSourceVolume(v string) *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
	s.SourceVolume = &v
	return s
}

// A port mapping for the container.
type AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails struct {
	_ struct{} `type:"structure"`

	// The port number on the container that is bound to the user-specified or automatically
	// assigned host port.
	ContainerPort *int64 `type:"integer"`

	// The port number on the container instance to reserve for the container.
	HostPort *int64 `type:"integer"`

	// The protocol used for the port mapping. The default is tcp.
	Protocol *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) GoString() string {
	return s.String()
}

// SetContainerPort sets the ContainerPort field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) SetContainerPort(v int64) *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
	s.ContainerPort = &v
	return s
}

// SetHostPort sets the HostPort field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) SetHostPort(v int64) *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
	s.HostPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) SetProtocol(v string) *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
	s.Protocol = &v
	return s
}

// The private repository authentication credentials to use.
type AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that contains the private repository credentials.
	CredentialsParameter *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails) GoString() string {
	return s.String()
}

// SetCredentialsParameter sets the CredentialsParameter field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails) SetCredentialsParameter(v string) *AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails {
	s.CredentialsParameter = &v
	return s
}

// A resource to assign to a container.
type AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails struct {
	_ struct{} `type:"structure"`

	// The type of resource to assign to a container. Valid values are GPU or InferenceAccelerator.
	Type *string `type:"string"`

	// The value for the specified resource type.
	//
	// For GPU, the value is the number of physical GPUs the Amazon ECS container
	// agent reserves for the container.
	//
	// For InferenceAccelerator, the value should match the DeviceName attribute
	// of an entry in InferenceAccelerators.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) SetType(v string) *AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) SetValue(v string) *AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails {
	s.Value = &v
	return s
}

// A secret to pass to the container.
type AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails struct {
	_ struct{} `type:"structure"`

	// The name of the secret.
	Name *string `type:"string"`

	// The secret to expose to the container. The value is either the full ARN of
	// the Secrets Manager secret or the full ARN of the parameter in the Systems
	// Manager Parameter Store.
	ValueFrom *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails) SetName(v string) *AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails {
	s.Name = &v
	return s
}

// SetValueFrom sets the ValueFrom field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails) SetValueFrom(v string) *AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails {
	s.ValueFrom = &v
	return s
}

// A namespaced kernel parameter to set in the container.
type AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails struct {
	_ struct{} `type:"structure"`

	// The namespaced kernel parameter for which to set a value.
	Namespace *string `type:"string"`

	// The value of the parameter.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails) SetNamespace(v string) *AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails {
	s.Namespace = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails) SetValue(v string) *AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails {
	s.Value = &v
	return s
}

// A ulimit to set in the container.
type AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails struct {
	_ struct{} `type:"structure"`

	// The hard limit for the ulimit type.
	HardLimit *int64 `type:"integer"`

	// The type of the ulimit. Valid values are as follows:
	//
	//    * core
	//
	//    * cpu
	//
	//    * data
	//
	//    * fsize
	//
	//    * locks
	//
	//    * memlock
	//
	//    * msgqueue
	//
	//    * nice
	//
	//    * nofile
	//
	//    * nproc
	//
	//    * rss
	//
	//    * rtprio
	//
	//    * rttime
	//
	//    * sigpending
	//
	//    * stack
	Name *string `type:"string"`

	// The soft limit for the ulimit type.
	SoftLimit *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) GoString() string {
	return s.String()
}

// SetHardLimit sets the HardLimit field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) SetHardLimit(v int64) *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
	s.HardLimit = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) SetName(v string) *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
	s.Name = &v
	return s
}

// SetSoftLimit sets the SoftLimit field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) SetSoftLimit(v int64) *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
	s.SoftLimit = &v
	return s
}

// A data volume to mount from another container.
type AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails struct {
	_ struct{} `type:"structure"`

	// Whether the container has read-only access to the volume.
	ReadOnly *bool `type:"boolean"`

	// The name of another container within the same task definition from which
	// to mount volumes.
	SourceContainer *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) GoString() string {
	return s.String()
}

// SetReadOnly sets the ReadOnly field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) SetReadOnly(v bool) *AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails {
	s.ReadOnly = &v
	return s
}

// SetSourceContainer sets the SourceContainer field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) SetSourceContainer(v string) *AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails {
	s.SourceContainer = &v
	return s
}

// Details about a task definition. A task definition describes the container
// and volume definitions of an Amazon Elastic Container Service task.
type AwsEcsTaskDefinitionDetails struct {
	_ struct{} `type:"structure"`

	// The container definitions that describe the containers that make up the task.
	ContainerDefinitions []*AwsEcsTaskDefinitionContainerDefinitionsDetails `type:"list"`

	// The number of CPU units used by the task.Valid values are as follows:
	//
	//    * 256 (.25 vCPU)
	//
	//    * 512 (.5 vCPU)
	//
	//    * 1024 (1 vCPU)
	//
	//    * 2048 (2 vCPU)
	//
	//    * 4096 (4 vCPU)
	Cpu *string `type:"string"`

	// The ARN of the task execution role that grants the container agent permission
	// to make API calls on behalf of the container user.
	ExecutionRoleArn *string `type:"string"`

	// The name of a family that this task definition is registered to.
	Family *string `type:"string"`

	// The Elastic Inference accelerators to use for the containers in the task.
	InferenceAccelerators []*AwsEcsTaskDefinitionInferenceAcceleratorsDetails `type:"list"`

	// The inter-process communication (IPC) resource namespace to use for the containers
	// in the task. Valid values are as follows:
	//
	//    * host
	//
	//    * none
	//
	//    * task
	IpcMode *string `type:"string"`

	// The amount (in MiB) of memory used by the task.
	//
	// For tasks that are hosted on Amazon EC2, you can provide a task-level memory
	// value or a container-level memory value. For tasks that are hosted on Fargate,
	// you must use one of the specified values (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size)
	// in the Amazon Elastic Container Service Developer Guide , which determines
	// your range of supported values for the Cpu and Memory parameters.
	Memory *string `type:"string"`

	// The Docker networking mode to use for the containers in the task. Valid values
	// are as follows:
	//
	//    * awsvpc
	//
	//    * bridge
	//
	//    * host
	//
	//    * none
	NetworkMode *string `type:"string"`

	// The process namespace to use for the containers in the task. Valid values
	// are host or task.
	PidMode *string `type:"string"`

	// The placement constraint objects to use for tasks.
	PlacementConstraints []*AwsEcsTaskDefinitionPlacementConstraintsDetails `type:"list"`

	// The configuration details for the App Mesh proxy.
	ProxyConfiguration *AwsEcsTaskDefinitionProxyConfigurationDetails `type:"structure"`

	// The task launch types that the task definition was validated against.
	RequiresCompatibilities []*string `type:"list"`

	// The short name or ARN of the IAM role that grants containers in the task
	// permission to call Amazon Web Services API operations on your behalf.
	TaskRoleArn *string `type:"string"`

	// The data volume definitions for the task.
	Volumes []*AwsEcsTaskDefinitionVolumesDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionDetails) GoString() string {
	return s.String()
}

// SetContainerDefinitions sets the ContainerDefinitions field's value.
func (s *AwsEcsTaskDefinitionDetails) SetContainerDefinitions(v []*AwsEcsTaskDefinitionContainerDefinitionsDetails) *AwsEcsTaskDefinitionDetails {
	s.ContainerDefinitions = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *AwsEcsTaskDefinitionDetails) SetCpu(v string) *AwsEcsTaskDefinitionDetails {
	s.Cpu = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *AwsEcsTaskDefinitionDetails) SetExecutionRoleArn(v string) *AwsEcsTaskDefinitionDetails {
	s.ExecutionRoleArn = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *AwsEcsTaskDefinitionDetails) SetFamily(v string) *AwsEcsTaskDefinitionDetails {
	s.Family = &v
	return s
}

// SetInferenceAccelerators sets the InferenceAccelerators field's value.
func (s *AwsEcsTaskDefinitionDetails) SetInferenceAccelerators(v []*AwsEcsTaskDefinitionInferenceAcceleratorsDetails) *AwsEcsTaskDefinitionDetails {
	s.InferenceAccelerators = v
	return s
}

// SetIpcMode sets the IpcMode field's value.
func (s *AwsEcsTaskDefinitionDetails) SetIpcMode(v string) *AwsEcsTaskDefinitionDetails {
	s.IpcMode = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *AwsEcsTaskDefinitionDetails) SetMemory(v string) *AwsEcsTaskDefinitionDetails {
	s.Memory = &v
	return s
}

// SetNetworkMode sets the NetworkMode field's value.
func (s *AwsEcsTaskDefinitionDetails) SetNetworkMode(v string) *AwsEcsTaskDefinitionDetails {
	s.NetworkMode = &v
	return s
}

// SetPidMode sets the PidMode field's value.
func (s *AwsEcsTaskDefinitionDetails) SetPidMode(v string) *AwsEcsTaskDefinitionDetails {
	s.PidMode = &v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *AwsEcsTaskDefinitionDetails) SetPlacementConstraints(v []*AwsEcsTaskDefinitionPlacementConstraintsDetails) *AwsEcsTaskDefinitionDetails {
	s.PlacementConstraints = v
	return s
}

// SetProxyConfiguration sets the ProxyConfiguration field's value.
func (s *AwsEcsTaskDefinitionDetails) SetProxyConfiguration(v *AwsEcsTaskDefinitionProxyConfigurationDetails) *AwsEcsTaskDefinitionDetails {
	s.ProxyConfiguration = v
	return s
}

// SetRequiresCompatibilities sets the RequiresCompatibilities field's value.
func (s *AwsEcsTaskDefinitionDetails) SetRequiresCompatibilities(v []*string) *AwsEcsTaskDefinitionDetails {
	s.RequiresCompatibilities = v
	return s
}

// SetTaskRoleArn sets the TaskRoleArn field's value.
func (s *AwsEcsTaskDefinitionDetails) SetTaskRoleArn(v string) *AwsEcsTaskDefinitionDetails {
	s.TaskRoleArn = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *AwsEcsTaskDefinitionDetails) SetVolumes(v []*AwsEcsTaskDefinitionVolumesDetails) *AwsEcsTaskDefinitionDetails {
	s.Volumes = v
	return s
}

// An Elastic Inference accelerator to use for the containers in the task.
type AwsEcsTaskDefinitionInferenceAcceleratorsDetails struct {
	_ struct{} `type:"structure"`

	// The Elastic Inference accelerator device name.
	DeviceName *string `type:"string"`

	// The Elastic Inference accelerator type to use.
	DeviceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionInferenceAcceleratorsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionInferenceAcceleratorsDetails) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *AwsEcsTaskDefinitionInferenceAcceleratorsDetails) SetDeviceName(v string) *AwsEcsTaskDefinitionInferenceAcceleratorsDetails {
	s.DeviceName = &v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *AwsEcsTaskDefinitionInferenceAcceleratorsDetails) SetDeviceType(v string) *AwsEcsTaskDefinitionInferenceAcceleratorsDetails {
	s.DeviceType = &v
	return s
}

// A placement constraint object to use for tasks.
type AwsEcsTaskDefinitionPlacementConstraintsDetails struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint.
	Expression *string `type:"string"`

	// The type of constraint.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionPlacementConstraintsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionPlacementConstraintsDetails) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *AwsEcsTaskDefinitionPlacementConstraintsDetails) SetExpression(v string) *AwsEcsTaskDefinitionPlacementConstraintsDetails {
	s.Expression = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEcsTaskDefinitionPlacementConstraintsDetails) SetType(v string) *AwsEcsTaskDefinitionPlacementConstraintsDetails {
	s.Type = &v
	return s
}

// The configuration details for the App Mesh proxy.
type AwsEcsTaskDefinitionProxyConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The name of the container that will serve as the App Mesh proxy.
	ContainerName *string `type:"string"`

	// The set of network configuration parameters to provide to the Container Network
	// Interface (CNI) plugin, specified as key-value pairs.
	ProxyConfigurationProperties []*AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails `type:"list"`

	// The proxy type.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionProxyConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionProxyConfigurationDetails) GoString() string {
	return s.String()
}

// SetContainerName sets the ContainerName field's value.
func (s *AwsEcsTaskDefinitionProxyConfigurationDetails) SetContainerName(v string) *AwsEcsTaskDefinitionProxyConfigurationDetails {
	s.ContainerName = &v
	return s
}

// SetProxyConfigurationProperties sets the ProxyConfigurationProperties field's value.
func (s *AwsEcsTaskDefinitionProxyConfigurationDetails) SetProxyConfigurationProperties(v []*AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails) *AwsEcsTaskDefinitionProxyConfigurationDetails {
	s.ProxyConfigurationProperties = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEcsTaskDefinitionProxyConfigurationDetails) SetType(v string) *AwsEcsTaskDefinitionProxyConfigurationDetails {
	s.Type = &v
	return s
}

// A network configuration parameter to provide to the Container Network Interface
// (CNI) plugin.
type AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails struct {
	_ struct{} `type:"structure"`

	// The name of the property.
	Name *string `type:"string"`

	// The value of the property.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails) SetName(v string) *AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails) SetValue(v string) *AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails {
	s.Value = &v
	return s
}

// A data volume to mount from another container.
type AwsEcsTaskDefinitionVolumesDetails struct {
	_ struct{} `type:"structure"`

	// Information about a Docker volume.
	DockerVolumeConfiguration *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails `type:"structure"`

	// Information about the Amazon Elastic File System file system that is used
	// for task storage.
	EfsVolumeConfiguration *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails `type:"structure"`

	// Information about a bind mount host volume.
	Host *AwsEcsTaskDefinitionVolumesHostDetails `type:"structure"`

	// The name of the data volume.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesDetails) GoString() string {
	return s.String()
}

// SetDockerVolumeConfiguration sets the DockerVolumeConfiguration field's value.
func (s *AwsEcsTaskDefinitionVolumesDetails) SetDockerVolumeConfiguration(v *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) *AwsEcsTaskDefinitionVolumesDetails {
	s.DockerVolumeConfiguration = v
	return s
}

// SetEfsVolumeConfiguration sets the EfsVolumeConfiguration field's value.
func (s *AwsEcsTaskDefinitionVolumesDetails) SetEfsVolumeConfiguration(v *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) *AwsEcsTaskDefinitionVolumesDetails {
	s.EfsVolumeConfiguration = v
	return s
}

// SetHost sets the Host field's value.
func (s *AwsEcsTaskDefinitionVolumesDetails) SetHost(v *AwsEcsTaskDefinitionVolumesHostDetails) *AwsEcsTaskDefinitionVolumesDetails {
	s.Host = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionVolumesDetails) SetName(v string) *AwsEcsTaskDefinitionVolumesDetails {
	s.Name = &v
	return s
}

// Information about a Docker volume.
type AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Whether to create the Docker volume automatically if it does not already
	// exist.
	Autoprovision *bool `type:"boolean"`

	// The Docker volume driver to use.
	Driver *string `type:"string"`

	// A map of Docker driver-specific options that are passed through.
	DriverOpts map[string]*string `type:"map"`

	// Custom metadata to add to the Docker volume.
	Labels map[string]*string `type:"map"`

	// The scope for the Docker volume that determines its lifecycle. Docker volumes
	// that are scoped to a task are provisioned automatically when the task starts
	// and destroyed when the task stops. Docker volumes that are shared persist
	// after the task stops. Valid values are shared or task.
	Scope *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) GoString() string {
	return s.String()
}

// SetAutoprovision sets the Autoprovision field's value.
func (s *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) SetAutoprovision(v bool) *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
	s.Autoprovision = &v
	return s
}

// SetDriver sets the Driver field's value.
func (s *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) SetDriver(v string) *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
	s.Driver = &v
	return s
}

// SetDriverOpts sets the DriverOpts field's value.
func (s *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) SetDriverOpts(v map[string]*string) *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
	s.DriverOpts = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) SetLabels(v map[string]*string) *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
	s.Labels = v
	return s
}

// SetScope sets the Scope field's value.
func (s *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) SetScope(v string) *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
	s.Scope = &v
	return s
}

type AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon EFS access point identifier to use.
	AccessPointId *string `type:"string"`

	// Whether to use the Amazon ECS task IAM role defined in a task definition
	// when mounting the Amazon EFS file system.
	Iam *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) GoString() string {
	return s.String()
}

// SetAccessPointId sets the AccessPointId field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) SetAccessPointId(v string) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails {
	s.AccessPointId = &v
	return s
}

// SetIam sets the Iam field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) SetIam(v string) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails {
	s.Iam = &v
	return s
}

// Information about the Amazon Elastic File System file system that is used
// for task storage.
type AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The authorization configuration details for the Amazon EFS file system.
	AuthorizationConfig *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails `type:"structure"`

	// The Amazon EFS file system identifier to use.
	FilesystemId *string `type:"string"`

	// The directory within the Amazon EFS file system to mount as the root directory
	// inside the host.
	RootDirectory *string `type:"string"`

	// Whether to enable encryption for Amazon EFS data in transit between the Amazon
	// ECS host and the Amazon EFS server.
	TransitEncryption *string `type:"string"`

	// The port to use when sending encrypted data between the Amazon ECS host and
	// the Amazon EFS server.
	TransitEncryptionPort *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) GoString() string {
	return s.String()
}

// SetAuthorizationConfig sets the AuthorizationConfig field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) SetAuthorizationConfig(v *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
	s.AuthorizationConfig = v
	return s
}

// SetFilesystemId sets the FilesystemId field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) SetFilesystemId(v string) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
	s.FilesystemId = &v
	return s
}

// SetRootDirectory sets the RootDirectory field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) SetRootDirectory(v string) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
	s.RootDirectory = &v
	return s
}

// SetTransitEncryption sets the TransitEncryption field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) SetTransitEncryption(v string) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
	s.TransitEncryption = &v
	return s
}

// SetTransitEncryptionPort sets the TransitEncryptionPort field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) SetTransitEncryptionPort(v int64) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
	s.TransitEncryptionPort = &v
	return s
}

// Information about a bind mount host volume.
type AwsEcsTaskDefinitionVolumesHostDetails struct {
	_ struct{} `type:"structure"`

	// The path on the host container instance that is presented to the container.
	SourcePath *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesHostDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesHostDetails) GoString() string {
	return s.String()
}

// SetSourcePath sets the SourcePath field's value.
func (s *AwsEcsTaskDefinitionVolumesHostDetails) SetSourcePath(v string) *AwsEcsTaskDefinitionVolumesHostDetails {
	s.SourcePath = &v
	return s
}

// Provides details about a task in a cluster.
type AwsEcsTaskDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster that hosts the task.
	ClusterArn *string `type:"string"`

	// The containers that are associated with the task.
	Containers []*AwsEcsContainerDetails `type:"list"`

	// The Unix timestamp for the time when the task was created. More specifically,
	// it's for the time when the task entered the PENDING state.
	CreatedAt *string `type:"string"`

	// The name of the task group that's associated with the task.
	Group *string `type:"string"`

	// The Unix timestamp for the time when the task started. More specifically,
	// it's for the time when the task transitioned from the PENDING state to the
	// RUNNING state.
	StartedAt *string `type:"string"`

	// The tag specified when a task is started. If an Amazon ECS service started
	// the task, the startedBy parameter contains the deployment ID of that service.
	StartedBy *string `type:"string"`

	// The ARN of the task definition that creates the task.
	TaskDefinitionArn *string `type:"string"`

	// The version counter for the task.
	Version *string `type:"string"`

	// Details about the data volume that is used in a task definition.
	Volumes []*AwsEcsTaskVolumeDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDetails) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *AwsEcsTaskDetails) SetClusterArn(v string) *AwsEcsTaskDetails {
	s.ClusterArn = &v
	return s
}

// SetContainers sets the Containers field's value.
func (s *AwsEcsTaskDetails) SetContainers(v []*AwsEcsContainerDetails) *AwsEcsTaskDetails {
	s.Containers = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsEcsTaskDetails) SetCreatedAt(v string) *AwsEcsTaskDetails {
	s.CreatedAt = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *AwsEcsTaskDetails) SetGroup(v string) *AwsEcsTaskDetails {
	s.Group = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *AwsEcsTaskDetails) SetStartedAt(v string) *AwsEcsTaskDetails {
	s.StartedAt = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *AwsEcsTaskDetails) SetStartedBy(v string) *AwsEcsTaskDetails {
	s.StartedBy = &v
	return s
}

// SetTaskDefinitionArn sets the TaskDefinitionArn field's value.
func (s *AwsEcsTaskDetails) SetTaskDefinitionArn(v string) *AwsEcsTaskDetails {
	s.TaskDefinitionArn = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsEcsTaskDetails) SetVersion(v string) *AwsEcsTaskDetails {
	s.Version = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *AwsEcsTaskDetails) SetVolumes(v []*AwsEcsTaskVolumeDetails) *AwsEcsTaskDetails {
	s.Volumes = v
	return s
}

// Provides information about a data volume that's used in a task definition.
type AwsEcsTaskVolumeDetails struct {
	_ struct{} `type:"structure"`

	// This parameter is specified when you use bind mount host volumes. The contents
	// of the host parameter determine whether your bind mount host volume persists
	// on the host container instance and where it's stored.
	Host *AwsEcsTaskVolumeHostDetails `type:"structure"`

	// The name of the volume. Up to 255 letters (uppercase and lowercase), numbers,
	// underscores, and hyphens are allowed. This name is referenced in the sourceVolume
	// parameter of container definition mountPoints.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskVolumeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskVolumeDetails) GoString() string {
	return s.String()
}

// SetHost sets the Host field's value.
func (s *AwsEcsTaskVolumeDetails) SetHost(v *AwsEcsTaskVolumeHostDetails) *AwsEcsTaskVolumeDetails {
	s.Host = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskVolumeDetails) SetName(v string) *AwsEcsTaskVolumeDetails {
	s.Name = &v
	return s
}

// Provides details on a container instance bind mount host volume.
type AwsEcsTaskVolumeHostDetails struct {
	_ struct{} `type:"structure"`

	// When the host parameter is used, specify a sourcePath to declare the path
	// on the host container instance that's presented to the container.
	SourcePath *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskVolumeHostDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskVolumeHostDetails) GoString() string {
	return s.String()
}

// SetSourcePath sets the SourcePath field's value.
func (s *AwsEcsTaskVolumeHostDetails) SetSourcePath(v string) *AwsEcsTaskVolumeHostDetails {
	s.SourcePath = &v
	return s
}

// Provides information about an Amazon EFS access point.
type AwsEfsAccessPointDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon EFS access point.
	AccessPointId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon EFS access point.
	Arn *string `type:"string"`

	// The opaque string specified in the request to ensure idempotent creation.
	ClientToken *string `type:"string"`

	// The ID of the Amazon EFS file system that the access point applies to.
	FileSystemId *string `type:"string"`

	// The full POSIX identity, including the user ID, group ID, and secondary group
	// IDs on the access point, that is used for all file operations by NFS clients
	// using the access point.
	PosixUser *AwsEfsAccessPointPosixUserDetails `type:"structure"`

	// The directory on the Amazon EFS file system that the access point exposes
	// as the root directory to NFS clients using the access point.
	RootDirectory *AwsEfsAccessPointRootDirectoryDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEfsAccessPointDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEfsAccessPointDetails) GoString() string {
	return s.String()
}

// SetAccessPointId sets the AccessPointId field's value.
func (s *AwsEfsAccessPointDetails) SetAccessPointId(v string) *AwsEfsAccessPointDetails {
	s.AccessPointId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *AwsEfsAccessPointDetails) SetArn(v string) *AwsEfsAccessPointDetails {
	s.Arn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AwsEfsAccessPointDetails) SetClientToken(v string) *AwsEfsAccessPointDetails {
	s.ClientToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *AwsEfsAccessPointDetails) SetFileSystemId(v string) *AwsEfsAccessPointDetails {
	s.FileSystemId = &v
	return s
}

// SetPosixUser sets the PosixUser field's value.
func (s *AwsEfsAccessPointDetails) SetPosixUser(v *AwsEfsAccessPointPosixUserDetails) *AwsEfsAccessPointDetails {
	s.PosixUser = v
	return s
}

// SetRootDirectory sets the RootDirectory field's value.
func (s *AwsEfsAccessPointDetails) SetRootDirectory(v *AwsEfsAccessPointRootDirectoryDetails) *AwsEfsAccessPointDetails {
	s.RootDirectory = v
	return s
}

// Provides details for all file system operations using this Amazon EFS access
// point.
type AwsEfsAccessPointPosixUserDetails struct {
	_ struct{} `type:"structure"`

	// The POSIX group ID used for all file system operations using this access
	// point.
	Gid *string `type:"string"`

	// Secondary POSIX group IDs used for all file system operations using this
	// access point.
	SecondaryGids []*string `type:"list"`

	// The POSIX user ID used for all file system operations using this access point.
	Uid *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEfsAccessPointPosixUserDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEfsAccessPointPosixUserDetails) GoString() string {
	return s.String()
}

// SetGid sets the Gid field's value.
func (s *AwsEfsAccessPointPosixUserDetails) SetGid(v string) *AwsEfsAccessPointPosixUserDetails {
	s.Gid = &v
	return s
}

// SetSecondaryGids sets the SecondaryGids field's value.
func (s *AwsEfsAccessPointPosixUserDetails) SetSecondaryGids(v []*string) *AwsEfsAccessPointPosixUserDetails {
	s.SecondaryGids = v
	return s
}

// SetUid sets the Uid field's value.
func (s *AwsEfsAccessPointPosixUserDetails) SetUid(v string) *AwsEfsAccessPointPosixUserDetails {
	s.Uid = &v
	return s
}

// Provides information about the settings that Amazon EFS uses to create the
// root directory when a client connects to an access point.
type AwsEfsAccessPointRootDirectoryCreationInfoDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the POSIX group ID to apply to the root directory.
	OwnerGid *string `type:"string"`

	// Specifies the POSIX user ID to apply to the root directory.
	OwnerUid *string `type:"string"`

	// Specifies the POSIX permissions to apply to the root directory, in the format
	// of an octal number representing the file's mode bits.
	Permissions *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEfsAccessPointRootDirectoryCreationInfoDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEfsAccessPointRootDirectoryCreationInfoDetails) GoString() string {
	return s.String()
}

// SetOwnerGid sets the OwnerGid field's value.
func (s *AwsEfsAccessPointRootDirectoryCreationInfoDetails) SetOwnerGid(v string) *AwsEfsAccessPointRootDirectoryCreationInfoDetails {
	s.OwnerGid = &v
	return s
}

// SetOwnerUid sets the OwnerUid field's value.
func (s *AwsEfsAccessPointRootDirectoryCreationInfoDetails) SetOwnerUid(v string) *AwsEfsAccessPointRootDirectoryCreationInfoDetails {
	s.OwnerUid = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *AwsEfsAccessPointRootDirectoryCreationInfoDetails) SetPermissions(v string) *AwsEfsAccessPointRootDirectoryCreationInfoDetails {
	s.Permissions = &v
	return s
}

// Provides information about the directory on the Amazon EFS file system that
// the access point exposes as the root directory to NFS clients using the access
// point.
type AwsEfsAccessPointRootDirectoryDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the POSIX IDs and permissions to apply to the access point's root
	// directory.
	CreationInfo *AwsEfsAccessPointRootDirectoryCreationInfoDetails `type:"structure"`

	// Specifies the path on the Amazon EFS file system to expose as the root directory
	// to NFS clients using the access point to access the EFS file system. A path
	// can have up to four subdirectories. If the specified path does not exist,
	// you are required to provide CreationInfo.
	Path *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEfsAccessPointRootDirectoryDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEfsAccessPointRootDirectoryDetails) GoString() string {
	return s.String()
}

// SetCreationInfo sets the CreationInfo field's value.
func (s *AwsEfsAccessPointRootDirectoryDetails) SetCreationInfo(v *AwsEfsAccessPointRootDirectoryCreationInfoDetails) *AwsEfsAccessPointRootDirectoryDetails {
	s.CreationInfo = v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsEfsAccessPointRootDirectoryDetails) SetPath(v string) *AwsEfsAccessPointRootDirectoryDetails {
	s.Path = &v
	return s
}

// Provides details about an Amazon EKS cluster.
type AwsEksClusterDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the cluster.
	Arn *string `type:"string"`

	// The certificate authority data for the cluster.
	CertificateAuthorityData *string `type:"string"`

	// The status of the cluster. Valid values are as follows:
	//
	//    * ACTIVE
	//
	//    * CREATING
	//
	//    * DELETING
	//
	//    * FAILED
	//
	//    * PENDING
	//
	//    * UPDATING
	ClusterStatus *string `type:"string"`

	// The endpoint for the Amazon EKS API server.
	Endpoint *string `type:"string"`

	// The logging configuration for the cluster.
	Logging *AwsEksClusterLoggingDetails `type:"structure"`

	// The name of the cluster.
	Name *string `type:"string"`

	// The VPC configuration used by the cluster control plane.
	ResourcesVpcConfig *AwsEksClusterResourcesVpcConfigDetails `type:"structure"`

	// The ARN of the IAM role that provides permissions for the Amazon EKS control
	// plane to make calls to Amazon Web Services API operations on your behalf.
	RoleArn *string `type:"string"`

	// The Amazon EKS server version for the cluster.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterDetails) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AwsEksClusterDetails) SetArn(v string) *AwsEksClusterDetails {
	s.Arn = &v
	return s
}

// SetCertificateAuthorityData sets the CertificateAuthorityData field's value.
func (s *AwsEksClusterDetails) SetCertificateAuthorityData(v string) *AwsEksClusterDetails {
	s.CertificateAuthorityData = &v
	return s
}

// SetClusterStatus sets the ClusterStatus field's value.
func (s *AwsEksClusterDetails) SetClusterStatus(v string) *AwsEksClusterDetails {
	s.ClusterStatus = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsEksClusterDetails) SetEndpoint(v string) *AwsEksClusterDetails {
	s.Endpoint = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *AwsEksClusterDetails) SetLogging(v *AwsEksClusterLoggingDetails) *AwsEksClusterDetails {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEksClusterDetails) SetName(v string) *AwsEksClusterDetails {
	s.Name = &v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *AwsEksClusterDetails) SetResourcesVpcConfig(v *AwsEksClusterResourcesVpcConfigDetails) *AwsEksClusterDetails {
	s.ResourcesVpcConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AwsEksClusterDetails) SetRoleArn(v string) *AwsEksClusterDetails {
	s.RoleArn = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsEksClusterDetails) SetVersion(v string) *AwsEksClusterDetails {
	s.Version = &v
	return s
}

// Details for a cluster logging configuration.
type AwsEksClusterLoggingClusterLoggingDetails struct {
	_ struct{} `type:"structure"`

	// Whether the logging types that are listed in Types are enabled.
	Enabled *bool `type:"boolean"`

	// A list of logging types. Valid values are as follows:
	//
	//    * api
	//
	//    * audit
	//
	//    * authenticator
	//
	//    * controllerManager
	//
	//    * scheduler
	Types []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterLoggingClusterLoggingDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterLoggingClusterLoggingDetails) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsEksClusterLoggingClusterLoggingDetails) SetEnabled(v bool) *AwsEksClusterLoggingClusterLoggingDetails {
	s.Enabled = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *AwsEksClusterLoggingClusterLoggingDetails) SetTypes(v []*string) *AwsEksClusterLoggingClusterLoggingDetails {
	s.Types = v
	return s
}

// The logging configuration for an Amazon EKS cluster.
type AwsEksClusterLoggingDetails struct {
	_ struct{} `type:"structure"`

	// Cluster logging configurations.
	ClusterLogging []*AwsEksClusterLoggingClusterLoggingDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterLoggingDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterLoggingDetails) GoString() string {
	return s.String()
}

// SetClusterLogging sets the ClusterLogging field's value.
func (s *AwsEksClusterLoggingDetails) SetClusterLogging(v []*AwsEksClusterLoggingClusterLoggingDetails) *AwsEksClusterLoggingDetails {
	s.ClusterLogging = v
	return s
}

// Information about the VPC configuration used by the cluster control plane.
type AwsEksClusterResourcesVpcConfigDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether the Amazon EKS public API server endpoint is turned on.
	// If the Amazon EKS public API server endpoint is turned off, your cluster's
	// Kubernetes API server can only receive requests that originate from within
	// the cluster VPC.
	EndpointPublicAccess *bool `type:"boolean"`

	// The security groups that are associated with the cross-account elastic network
	// interfaces that are used to allow communication between your nodes and the
	// Amazon EKS control plane.
	SecurityGroupIds []*string `type:"list"`

	// The subnets that are associated with the cluster.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterResourcesVpcConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterResourcesVpcConfigDetails) GoString() string {
	return s.String()
}

// SetEndpointPublicAccess sets the EndpointPublicAccess field's value.
func (s *AwsEksClusterResourcesVpcConfigDetails) SetEndpointPublicAccess(v bool) *AwsEksClusterResourcesVpcConfigDetails {
	s.EndpointPublicAccess = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsEksClusterResourcesVpcConfigDetails) SetSecurityGroupIds(v []*string) *AwsEksClusterResourcesVpcConfigDetails {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AwsEksClusterResourcesVpcConfigDetails) SetSubnetIds(v []*string) *AwsEksClusterResourcesVpcConfigDetails {
	s.SubnetIds = v
	return s
}

// Contains details about an Elastic Beanstalk environment.
type AwsElasticBeanstalkEnvironmentDetails struct {
	_ struct{} `type:"structure"`

	// The name of the application that is associated with the environment.
	ApplicationName *string `type:"string"`

	// The URL to the CNAME for this environment.
	Cname *string `type:"string"`

	// The creation date for this environment.
	DateCreated *string `type:"string"`

	// The date when this environment was last modified.
	DateUpdated *string `type:"string"`

	// A description of the environment.
	Description *string `type:"string"`

	// For load-balanced, autoscaling environments, the URL to the load balancer.
	// For single-instance environments, the IP address of the instance.
	EndpointUrl *string `type:"string"`

	// The ARN of the environment.
	EnvironmentArn *string `type:"string"`

	// The identifier of the environment.
	EnvironmentId *string `type:"string"`

	// Links to other environments in the same group.
	EnvironmentLinks []*AwsElasticBeanstalkEnvironmentEnvironmentLink `type:"list"`

	// The name of the environment.
	EnvironmentName *string `type:"string"`

	// The configuration setting for the environment.
	OptionSettings []*AwsElasticBeanstalkEnvironmentOptionSetting `type:"list"`

	// The ARN of the platform version for the environment.
	PlatformArn *string `type:"string"`

	// The name of the solution stack that is deployed with the environment.
	SolutionStackName *string `type:"string"`

	// The current operational status of the environment. Valid values are as follows:
	//
	//    * Aborting
	//
	//    * Launching
	//
	//    * LinkingFrom
	//
	//    * LinkingTo
	//
	//    * Ready
	//
	//    * Terminated
	//
	//    * Terminating
	//
	//    * Updating
	Status *string `type:"string"`

	// The tier of the environment.
	Tier *AwsElasticBeanstalkEnvironmentTier `type:"structure"`

	// The application version of the environment.
	VersionLabel *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticBeanstalkEnvironmentDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API param