// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/cloud/visionai/v1alpha1/platform.proto

package visionai

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// All the supported model types in Vision AI App Platform.
type ModelType int32

const (
	// Processor Type UNSPECIFIED.
	ModelType_MODEL_TYPE_UNSPECIFIED ModelType = 0
	// Model Type Image Classification.
	ModelType_IMAGE_CLASSIFICATION ModelType = 1
	// Model Type Object Detection.
	ModelType_OBJECT_DETECTION ModelType = 2
	// Model Type Video Classification.
	ModelType_VIDEO_CLASSIFICATION ModelType = 3
	// Model Type Object Tracking.
	ModelType_VIDEO_OBJECT_TRACKING ModelType = 4
	// Model Type Action Recognition.
	ModelType_VIDEO_ACTION_RECOGNITION ModelType = 5
	// Model Type Occupancy Counting.
	ModelType_OCCUPANCY_COUNTING ModelType = 6
	// Model Type Person Blur.
	ModelType_PERSON_BLUR ModelType = 7
	// Model Type Vertex Custom.
	ModelType_VERTEX_CUSTOM ModelType = 8
)

// Enum value maps for ModelType.
var (
	ModelType_name = map[int32]string{
		0: "MODEL_TYPE_UNSPECIFIED",
		1: "IMAGE_CLASSIFICATION",
		2: "OBJECT_DETECTION",
		3: "VIDEO_CLASSIFICATION",
		4: "VIDEO_OBJECT_TRACKING",
		5: "VIDEO_ACTION_RECOGNITION",
		6: "OCCUPANCY_COUNTING",
		7: "PERSON_BLUR",
		8: "VERTEX_CUSTOM",
	}
	ModelType_value = map[string]int32{
		"MODEL_TYPE_UNSPECIFIED":   0,
		"IMAGE_CLASSIFICATION":     1,
		"OBJECT_DETECTION":         2,
		"VIDEO_CLASSIFICATION":     3,
		"VIDEO_OBJECT_TRACKING":    4,
		"VIDEO_ACTION_RECOGNITION": 5,
		"OCCUPANCY_COUNTING":       6,
		"PERSON_BLUR":              7,
		"VERTEX_CUSTOM":            8,
	}
)

func (x ModelType) Enum() *ModelType {
	p := new(ModelType)
	*p = x
	return p
}

func (x ModelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[0].Descriptor()
}

func (ModelType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[0]
}

func (x ModelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ModelType.Descriptor instead.
func (ModelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{0}
}

// Represents a hardware accelerator type.
type AcceleratorType int32

const (
	// Unspecified accelerator type, which means no accelerator.
	AcceleratorType_ACCELERATOR_TYPE_UNSPECIFIED AcceleratorType = 0
	// Nvidia Tesla K80 GPU.
	AcceleratorType_NVIDIA_TESLA_K80 AcceleratorType = 1
	// Nvidia Tesla P100 GPU.
	AcceleratorType_NVIDIA_TESLA_P100 AcceleratorType = 2
	// Nvidia Tesla V100 GPU.
	AcceleratorType_NVIDIA_TESLA_V100 AcceleratorType = 3
	// Nvidia Tesla P4 GPU.
	AcceleratorType_NVIDIA_TESLA_P4 AcceleratorType = 4
	// Nvidia Tesla T4 GPU.
	AcceleratorType_NVIDIA_TESLA_T4 AcceleratorType = 5
	// Nvidia Tesla A100 GPU.
	AcceleratorType_NVIDIA_TESLA_A100 AcceleratorType = 8
	// TPU v2.
	AcceleratorType_TPU_V2 AcceleratorType = 6
	// TPU v3.
	AcceleratorType_TPU_V3 AcceleratorType = 7
)

// Enum value maps for AcceleratorType.
var (
	AcceleratorType_name = map[int32]string{
		0: "ACCELERATOR_TYPE_UNSPECIFIED",
		1: "NVIDIA_TESLA_K80",
		2: "NVIDIA_TESLA_P100",
		3: "NVIDIA_TESLA_V100",
		4: "NVIDIA_TESLA_P4",
		5: "NVIDIA_TESLA_T4",
		8: "NVIDIA_TESLA_A100",
		6: "TPU_V2",
		7: "TPU_V3",
	}
	AcceleratorType_value = map[string]int32{
		"ACCELERATOR_TYPE_UNSPECIFIED": 0,
		"NVIDIA_TESLA_K80":             1,
		"NVIDIA_TESLA_P100":            2,
		"NVIDIA_TESLA_V100":            3,
		"NVIDIA_TESLA_P4":              4,
		"NVIDIA_TESLA_T4":              5,
		"NVIDIA_TESLA_A100":            8,
		"TPU_V2":                       6,
		"TPU_V3":                       7,
	}
)

func (x AcceleratorType) Enum() *AcceleratorType {
	p := new(AcceleratorType)
	*p = x
	return p
}

func (x AcceleratorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AcceleratorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[1].Descriptor()
}

func (AcceleratorType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[1]
}

func (x AcceleratorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AcceleratorType.Descriptor instead.
func (AcceleratorType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{1}
}

// State of the Application
type Application_State int32

const (
	// The default value. This value is used if the state is omitted.
	Application_STATE_UNSPECIFIED Application_State = 0
	// State CREATED.
	Application_CREATED Application_State = 1
	// State DEPLOYING.
	Application_DEPLOYING Application_State = 2
	// State DEPLOYED.
	Application_DEPLOYED Application_State = 3
	// State UNDEPLOYING.
	Application_UNDEPLOYING Application_State = 4
	// State DELETED.
	Application_DELETED Application_State = 5
	// State ERROR.
	Application_ERROR Application_State = 6
	// State CREATING.
	Application_CREATING Application_State = 7
	// State Updating.
	Application_UPDATING Application_State = 8
	// State Deleting.
	Application_DELETING Application_State = 9
	// State Fixing.
	Application_FIXING Application_State = 10
)

// Enum value maps for Application_State.
var (
	Application_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "CREATED",
		2:  "DEPLOYING",
		3:  "DEPLOYED",
		4:  "UNDEPLOYING",
		5:  "DELETED",
		6:  "ERROR",
		7:  "CREATING",
		8:  "UPDATING",
		9:  "DELETING",
		10: "FIXING",
	}
	Application_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATED":           1,
		"DEPLOYING":         2,
		"DEPLOYED":          3,
		"UNDEPLOYING":       4,
		"DELETED":           5,
		"ERROR":             6,
		"CREATING":          7,
		"UPDATING":          8,
		"DELETING":          9,
		"FIXING":            10,
	}
)

func (x Application_State) Enum() *Application_State {
	p := new(Application_State)
	*p = x
	return p
}

func (x Application_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Application_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[2].Descriptor()
}

func (Application_State) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[2]
}

func (x Application_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Application_State.Descriptor instead.
func (Application_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{40, 0}
}

// State of the Instance
type Instance_State int32

const (
	// The default value. This value is used if the state is omitted.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// State CREATING.
	Instance_CREATING Instance_State = 1
	// State CREATED.
	Instance_CREATED Instance_State = 2
	// State DEPLOYING.
	Instance_DEPLOYING Instance_State = 3
	// State DEPLOYED.
	Instance_DEPLOYED Instance_State = 4
	// State UNDEPLOYING.
	Instance_UNDEPLOYING Instance_State = 5
	// State DELETED.
	Instance_DELETED Instance_State = 6
	// State ERROR.
	Instance_ERROR Instance_State = 7
	// State Updating
	Instance_UPDATING Instance_State = 8
	// State Deleting.
	Instance_DELETING Instance_State = 9
	// State Fixing.
	Instance_FIXING Instance_State = 10
)

// Enum value maps for Instance_State.
var (
	Instance_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "CREATING",
		2:  "CREATED",
		3:  "DEPLOYING",
		4:  "DEPLOYED",
		5:  "UNDEPLOYING",
		6:  "DELETED",
		7:  "ERROR",
		8:  "UPDATING",
		9:  "DELETING",
		10: "FIXING",
	}
	Instance_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"CREATED":           2,
		"DEPLOYING":         3,
		"DEPLOYED":          4,
		"UNDEPLOYING":       5,
		"DELETED":           6,
		"ERROR":             7,
		"UPDATING":          8,
		"DELETING":          9,
		"FIXING":            10,
	}
)

func (x Instance_State) Enum() *Instance_State {
	p := new(Instance_State)
	*p = x
	return p
}

func (x Instance_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[3].Descriptor()
}

func (Instance_State) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[3]
}

func (x Instance_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_State.Descriptor instead.
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{44, 0}
}

// Type
type Processor_ProcessorType int32

const (
	// Processor Type UNSPECIFIED.
	Processor_PROCESSOR_TYPE_UNSPECIFIED Processor_ProcessorType = 0
	// Processor Type PRETRAINED.
	// Pretrained processor is developed by Vision AI App Platform with
	// state-of-the-art vision data processing functionality, like occupancy
	// counting or person blur. Pretrained processor is usually publicly
	// available.
	Processor_PRETRAINED Processor_ProcessorType = 1
	// Processor Type CUSTOM.
	// Custom processors are specialized processors which are either uploaded by
	// customers or imported from other GCP platform (for example Vertex AI).
	// Custom processor is only visible to the creator.
	Processor_CUSTOM Processor_ProcessorType = 2
	// Processor Type CONNECTOR.
	// Connector processors are special processors which perform I/O for the
	// application, they do not processing the data but either deliver the data
	// to other processors or receive data from other processors.
	Processor_CONNECTOR Processor_ProcessorType = 3
)

// Enum value maps for Processor_ProcessorType.
var (
	Processor_ProcessorType_name = map[int32]string{
		0: "PROCESSOR_TYPE_UNSPECIFIED",
		1: "PRETRAINED",
		2: "CUSTOM",
		3: "CONNECTOR",
	}
	Processor_ProcessorType_value = map[string]int32{
		"PROCESSOR_TYPE_UNSPECIFIED": 0,
		"PRETRAINED":                 1,
		"CUSTOM":                     2,
		"CONNECTOR":                  3,
	}
)

func (x Processor_ProcessorType) Enum() *Processor_ProcessorType {
	p := new(Processor_ProcessorType)
	*p = x
	return p
}

func (x Processor_ProcessorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Processor_ProcessorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[4].Descriptor()
}

func (Processor_ProcessorType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[4]
}

func (x Processor_ProcessorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Processor_ProcessorType.Descriptor instead.
func (Processor_ProcessorType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{46, 0}
}

type Processor_ProcessorState int32

const (
	// Unspecified Processor state.
	Processor_PROCESSOR_STATE_UNSPECIFIED Processor_ProcessorState = 0
	// Processor is being created (not ready for use).
	Processor_CREATING Processor_ProcessorState = 1
	// Processor is and ready for use.
	Processor_ACTIVE Processor_ProcessorState = 2
	// Processor is being deleted (not ready for use).
	Processor_DELETING Processor_ProcessorState = 3
	// Processor deleted or creation failed .
	Processor_FAILED Processor_ProcessorState = 4
)

// Enum value maps for Processor_ProcessorState.
var (
	Processor_ProcessorState_name = map[int32]string{
		0: "PROCESSOR_STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "FAILED",
	}
	Processor_ProcessorState_value = map[string]int32{
		"PROCESSOR_STATE_UNSPECIFIED": 0,
		"CREATING":                    1,
		"ACTIVE":                      2,
		"DELETING":                    3,
		"FAILED":                      4,
	}
)

func (x Processor_ProcessorState) Enum() *Processor_ProcessorState {
	p := new(Processor_ProcessorState)
	*p = x
	return p
}

func (x Processor_ProcessorState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Processor_ProcessorState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[5].Descriptor()
}

func (Processor_ProcessorState) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[5]
}

func (x Processor_ProcessorState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Processor_ProcessorState.Descriptor instead.
func (Processor_ProcessorState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{46, 1}
}

// High level data types supported by the processor.
type ProcessorIOSpec_DataType int32

const (
	// The default value of DataType.
	ProcessorIOSpec_DATA_TYPE_UNSPECIFIED ProcessorIOSpec_DataType = 0
	// Video data type like H264.
	ProcessorIOSpec_VIDEO ProcessorIOSpec_DataType = 1
	// Protobuf data type, usually used for general data blob.
	ProcessorIOSpec_PROTO ProcessorIOSpec_DataType = 2
)

// Enum value maps for ProcessorIOSpec_DataType.
var (
	ProcessorIOSpec_DataType_name = map[int32]string{
		0: "DATA_TYPE_UNSPECIFIED",
		1: "VIDEO",
		2: "PROTO",
	}
	ProcessorIOSpec_DataType_value = map[string]int32{
		"DATA_TYPE_UNSPECIFIED": 0,
		"VIDEO":                 1,
		"PROTO":                 2,
	}
)

func (x ProcessorIOSpec_DataType) Enum() *ProcessorIOSpec_DataType {
	p := new(ProcessorIOSpec_DataType)
	*p = x
	return p
}

func (x ProcessorIOSpec_DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProcessorIOSpec_DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[6].Descriptor()
}

func (ProcessorIOSpec_DataType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[6]
}

func (x ProcessorIOSpec_DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProcessorIOSpec_DataType.Descriptor instead.
func (ProcessorIOSpec_DataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{47, 0}
}

// Source type of the imported custom processor.
type CustomProcessorSourceInfo_SourceType int32

const (
	// Source type unspecified.
	CustomProcessorSourceInfo_SOURCE_TYPE_UNSPECIFIED CustomProcessorSourceInfo_SourceType = 0
	// Custom processors coming from Vertex AutoML product.
	CustomProcessorSourceInfo_VERTEX_AUTOML CustomProcessorSourceInfo_SourceType = 1
	// Custom processors coming from general custom models from Vertex.
	CustomProcessorSourceInfo_VERTEX_CUSTOM CustomProcessorSourceInfo_SourceType = 2
)

// Enum value maps for CustomProcessorSourceInfo_SourceType.
var (
	CustomProcessorSourceInfo_SourceType_name = map[int32]string{
		0: "SOURCE_TYPE_UNSPECIFIED",
		1: "VERTEX_AUTOML",
		2: "VERTEX_CUSTOM",
	}
	CustomProcessorSourceInfo_SourceType_value = map[string]int32{
		"SOURCE_TYPE_UNSPECIFIED": 0,
		"VERTEX_AUTOML":           1,
		"VERTEX_CUSTOM":           2,
	}
)

func (x CustomProcessorSourceInfo_SourceType) Enum() *CustomProcessorSourceInfo_SourceType {
	p := new(CustomProcessorSourceInfo_SourceType)
	*p = x
	return p
}

func (x CustomProcessorSourceInfo_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomProcessorSourceInfo_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[7].Descriptor()
}

func (CustomProcessorSourceInfo_SourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[7]
}

func (x CustomProcessorSourceInfo_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomProcessorSourceInfo_SourceType.Descriptor instead.
func (CustomProcessorSourceInfo_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{48, 0}
}

// Type of Person Blur
type PersonBlurConfig_PersonBlurType int32

const (
	// PersonBlur Type UNSPECIFIED.
	PersonBlurConfig_PERSON_BLUR_TYPE_UNSPECIFIED PersonBlurConfig_PersonBlurType = 0
	// FaceBlur Type full occlusion.
	PersonBlurConfig_FULL_OCCULUSION PersonBlurConfig_PersonBlurType = 1
	// FaceBlur Type blur filter.
	PersonBlurConfig_BLUR_FILTER PersonBlurConfig_PersonBlurType = 2
)

// Enum value maps for PersonBlurConfig_PersonBlurType.
var (
	PersonBlurConfig_PersonBlurType_name = map[int32]string{
		0: "PERSON_BLUR_TYPE_UNSPECIFIED",
		1: "FULL_OCCULUSION",
		2: "BLUR_FILTER",
	}
	PersonBlurConfig_PersonBlurType_value = map[string]int32{
		"PERSON_BLUR_TYPE_UNSPECIFIED": 0,
		"FULL_OCCULUSION":              1,
		"BLUR_FILTER":                  2,
	}
)

func (x PersonBlurConfig_PersonBlurType) Enum() *PersonBlurConfig_PersonBlurType {
	p := new(PersonBlurConfig_PersonBlurType)
	*p = x
	return p
}

func (x PersonBlurConfig_PersonBlurType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PersonBlurConfig_PersonBlurType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[8].Descriptor()
}

func (PersonBlurConfig_PersonBlurType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes[8]
}

func (x PersonBlurConfig_PersonBlurType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PersonBlurConfig_PersonBlurType.Descriptor instead.
func (PersonBlurConfig_PersonBlurType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{56, 0}
}

// Message for DeleteApplicationInstance Response.
type DeleteApplicationInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteApplicationInstancesResponse) Reset() {
	*x = DeleteApplicationInstancesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteApplicationInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteApplicationInstancesResponse) ProtoMessage() {}

func (x *DeleteApplicationInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteApplicationInstancesResponse.ProtoReflect.Descriptor instead.
func (*DeleteApplicationInstancesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{0}
}

// Message for CreateApplicationInstance Response.
type CreateApplicationInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateApplicationInstancesResponse) Reset() {
	*x = CreateApplicationInstancesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateApplicationInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateApplicationInstancesResponse) ProtoMessage() {}

func (x *CreateApplicationInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateApplicationInstancesResponse.ProtoReflect.Descriptor instead.
func (*CreateApplicationInstancesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{1}
}

// Message for UpdateApplicationInstances Response.
type UpdateApplicationInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateApplicationInstancesResponse) Reset() {
	*x = UpdateApplicationInstancesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateApplicationInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateApplicationInstancesResponse) ProtoMessage() {}

func (x *UpdateApplicationInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateApplicationInstancesResponse.ProtoReflect.Descriptor instead.
func (*UpdateApplicationInstancesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{2}
}

// Message for adding stream input to an Application.
type CreateApplicationInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. the name of the application to retrieve.
	// Format:
	// "projects/{project}/locations/{location}/applications/{application}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The resources being created.
	ApplicationInstances []*ApplicationInstance `protobuf:"bytes,2,rep,name=application_instances,json=applicationInstances,proto3" json:"application_instances,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateApplicationInstancesRequest) Reset() {
	*x = CreateApplicationInstancesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateApplicationInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateApplicationInstancesRequest) ProtoMessage() {}

func (x *CreateApplicationInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateApplicationInstancesRequest.ProtoReflect.Descriptor instead.
func (*CreateApplicationInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{3}
}

func (x *CreateApplicationInstancesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateApplicationInstancesRequest) GetApplicationInstances() []*ApplicationInstance {
	if x != nil {
		return x.ApplicationInstances
	}
	return nil
}

func (x *CreateApplicationInstancesRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for removing stream input from an Application.
type DeleteApplicationInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. the name of the application to retrieve.
	// Format:
	// "projects/{project}/locations/{location}/applications/{application}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Id of the requesting object.
	InstanceIds []string `protobuf:"bytes,2,rep,name=instance_ids,json=instanceIds,proto3" json:"instance_ids,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteApplicationInstancesRequest) Reset() {
	*x = DeleteApplicationInstancesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteApplicationInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteApplicationInstancesRequest) ProtoMessage() {}

func (x *DeleteApplicationInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteApplicationInstancesRequest.ProtoReflect.Descriptor instead.
func (*DeleteApplicationInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteApplicationInstancesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteApplicationInstancesRequest) GetInstanceIds() []string {
	if x != nil {
		return x.InstanceIds
	}
	return nil
}

func (x *DeleteApplicationInstancesRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// RPC Request Messages.
// Message for DeployApplication Response.
type DeployApplicationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeployApplicationResponse) Reset() {
	*x = DeployApplicationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployApplicationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployApplicationResponse) ProtoMessage() {}

func (x *DeployApplicationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployApplicationResponse.ProtoReflect.Descriptor instead.
func (*DeployApplicationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{5}
}

// Message for UndeployApplication Response.
type UndeployApplicationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UndeployApplicationResponse) Reset() {
	*x = UndeployApplicationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployApplicationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployApplicationResponse) ProtoMessage() {}

func (x *UndeployApplicationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployApplicationResponse.ProtoReflect.Descriptor instead.
func (*UndeployApplicationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{6}
}

// Message for RemoveApplicationStreamInput Response.
type RemoveApplicationStreamInputResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveApplicationStreamInputResponse) Reset() {
	*x = RemoveApplicationStreamInputResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveApplicationStreamInputResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveApplicationStreamInputResponse) ProtoMessage() {}

func (x *RemoveApplicationStreamInputResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveApplicationStreamInputResponse.ProtoReflect.Descriptor instead.
func (*RemoveApplicationStreamInputResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{7}
}

// Message for AddApplicationStreamInput Response.
type AddApplicationStreamInputResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddApplicationStreamInputResponse) Reset() {
	*x = AddApplicationStreamInputResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddApplicationStreamInputResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddApplicationStreamInputResponse) ProtoMessage() {}

func (x *AddApplicationStreamInputResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddApplicationStreamInputResponse.ProtoReflect.Descriptor instead.
func (*AddApplicationStreamInputResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{8}
}

// Message for AddApplicationStreamInput Response.
type UpdateApplicationStreamInputResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateApplicationStreamInputResponse) Reset() {
	*x = UpdateApplicationStreamInputResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateApplicationStreamInputResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateApplicationStreamInputResponse) ProtoMessage() {}

func (x *UpdateApplicationStreamInputResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateApplicationStreamInputResponse.ProtoReflect.Descriptor instead.
func (*UpdateApplicationStreamInputResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{9}
}

// Message for requesting list of Applications.
type ListApplicationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListApplicationsRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListApplicationsRequest) Reset() {
	*x = ListApplicationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListApplicationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApplicationsRequest) ProtoMessage() {}

func (x *ListApplicationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApplicationsRequest.ProtoReflect.Descriptor instead.
func (*ListApplicationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{10}
}

func (x *ListApplicationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListApplicationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListApplicationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListApplicationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListApplicationsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing Applications.
type ListApplicationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Application.
	Applications []*Application `protobuf:"bytes,1,rep,name=applications,proto3" json:"applications,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListApplicationsResponse) Reset() {
	*x = ListApplicationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListApplicationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApplicationsResponse) ProtoMessage() {}

func (x *ListApplicationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApplicationsResponse.ProtoReflect.Descriptor instead.
func (*ListApplicationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{11}
}

func (x *ListApplicationsResponse) GetApplications() []*Application {
	if x != nil {
		return x.Applications
	}
	return nil
}

func (x *ListApplicationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListApplicationsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a Application.
type GetApplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetApplicationRequest) Reset() {
	*x = GetApplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetApplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetApplicationRequest) ProtoMessage() {}

func (x *GetApplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetApplicationRequest.ProtoReflect.Descriptor instead.
func (*GetApplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{12}
}

func (x *GetApplicationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a Application.
type CreateApplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting object.
	ApplicationId string `protobuf:"bytes,2,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// Required. The resource being created.
	Application *Application `protobuf:"bytes,3,opt,name=application,proto3" json:"application,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateApplicationRequest) Reset() {
	*x = CreateApplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateApplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateApplicationRequest) ProtoMessage() {}

func (x *CreateApplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateApplicationRequest.ProtoReflect.Descriptor instead.
func (*CreateApplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{13}
}

func (x *CreateApplicationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateApplicationRequest) GetApplicationId() string {
	if x != nil {
		return x.ApplicationId
	}
	return ""
}

func (x *CreateApplicationRequest) GetApplication() *Application {
	if x != nil {
		return x.Application
	}
	return nil
}

func (x *CreateApplicationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating an Application.
type UpdateApplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// Application resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated.
	Application *Application `protobuf:"bytes,2,opt,name=application,proto3" json:"application,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateApplicationRequest) Reset() {
	*x = UpdateApplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateApplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateApplicationRequest) ProtoMessage() {}

func (x *UpdateApplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateApplicationRequest.ProtoReflect.Descriptor instead.
func (*UpdateApplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateApplicationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateApplicationRequest) GetApplication() *Application {
	if x != nil {
		return x.Application
	}
	return nil
}

func (x *UpdateApplicationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting an Application.
type DeleteApplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, any instances and drafts from this application will also be
	// deleted. (Otherwise, the request will only work if the application has no
	// instances and drafts.)
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteApplicationRequest) Reset() {
	*x = DeleteApplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteApplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteApplicationRequest) ProtoMessage() {}

func (x *DeleteApplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteApplicationRequest.ProtoReflect.Descriptor instead.
func (*DeleteApplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteApplicationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteApplicationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteApplicationRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Message for deploying an Application.
type DeployApplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. the name of the application to retrieve.
	// Format:
	// "projects/{project}/locations/{location}/applications/{application}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the application graph, but do not
	// actually deploy it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Whether or not to enable monitoring for the application on deployment.
	EnableMonitoring bool `protobuf:"varint,4,opt,name=enable_monitoring,json=enableMonitoring,proto3" json:"enable_monitoring,omitempty"`
}

func (x *DeployApplicationRequest) Reset() {
	*x = DeployApplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployApplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployApplicationRequest) ProtoMessage() {}

func (x *DeployApplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployApplicationRequest.ProtoReflect.Descriptor instead.
func (*DeployApplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{16}
}

func (x *DeployApplicationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeployApplicationRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeployApplicationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeployApplicationRequest) GetEnableMonitoring() bool {
	if x != nil {
		return x.EnableMonitoring
	}
	return false
}

// Message for undeploying an Application.
type UndeployApplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. the name of the application to retrieve.
	// Format:
	// "projects/{project}/locations/{location}/applications/{application}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UndeployApplicationRequest) Reset() {
	*x = UndeployApplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployApplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployApplicationRequest) ProtoMessage() {}

func (x *UndeployApplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployApplicationRequest.ProtoReflect.Descriptor instead.
func (*UndeployApplicationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{17}
}

func (x *UndeployApplicationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UndeployApplicationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message about a single stream input config.
type ApplicationStreamInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StreamWithAnnotation *StreamWithAnnotation `protobuf:"bytes,1,opt,name=stream_with_annotation,json=streamWithAnnotation,proto3" json:"stream_with_annotation,omitempty"`
}

func (x *ApplicationStreamInput) Reset() {
	*x = ApplicationStreamInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationStreamInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationStreamInput) ProtoMessage() {}

func (x *ApplicationStreamInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationStreamInput.ProtoReflect.Descriptor instead.
func (*ApplicationStreamInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{18}
}

func (x *ApplicationStreamInput) GetStreamWithAnnotation() *StreamWithAnnotation {
	if x != nil {
		return x.StreamWithAnnotation
	}
	return nil
}

// Message for adding stream input to an Application.
type AddApplicationStreamInputRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. the name of the application to retrieve.
	// Format:
	// "projects/{project}/locations/{location}/applications/{application}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The stream inputs to add, the stream resource name is the key of each
	// StreamInput, and it must be unique within each application.
	ApplicationStreamInputs []*ApplicationStreamInput `protobuf:"bytes,2,rep,name=application_stream_inputs,json=applicationStreamInputs,proto3" json:"application_stream_inputs,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *AddApplicationStreamInputRequest) Reset() {
	*x = AddApplicationStreamInputRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddApplicationStreamInputRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddApplicationStreamInputRequest) ProtoMessage() {}

func (x *AddApplicationStreamInputRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddApplicationStreamInputRequest.ProtoReflect.Descriptor instead.
func (*AddApplicationStreamInputRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{19}
}

func (x *AddApplicationStreamInputRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AddApplicationStreamInputRequest) GetApplicationStreamInputs() []*ApplicationStreamInput {
	if x != nil {
		return x.ApplicationStreamInputs
	}
	return nil
}

func (x *AddApplicationStreamInputRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating stream input to an Application.
type UpdateApplicationStreamInputRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. the name of the application to retrieve.
	// Format:
	// "projects/{project}/locations/{location}/applications/{application}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The stream inputs to update, the stream resource name is the key of each
	// StreamInput, and it must be unique within each application.
	ApplicationStreamInputs []*ApplicationStreamInput `protobuf:"bytes,2,rep,name=application_stream_inputs,json=applicationStreamInputs,proto3" json:"application_stream_inputs,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// If true, UpdateApplicationStreamInput will insert stream input to
	// application even if the target stream is not included in the application.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateApplicationStreamInputRequest) Reset() {
	*x = UpdateApplicationStreamInputRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateApplicationStreamInputRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateApplicationStreamInputRequest) ProtoMessage() {}

func (x *UpdateApplicationStreamInputRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateApplicationStreamInputRequest.ProtoReflect.Descriptor instead.
func (*UpdateApplicationStreamInputRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateApplicationStreamInputRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateApplicationStreamInputRequest) GetApplicationStreamInputs() []*ApplicationStreamInput {
	if x != nil {
		return x.ApplicationStreamInputs
	}
	return nil
}

func (x *UpdateApplicationStreamInputRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateApplicationStreamInputRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Message for removing stream input from an Application.
type RemoveApplicationStreamInputRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. the name of the application to retrieve.
	// Format:
	// "projects/{project}/locations/{location}/applications/{application}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The target stream to remove.
	TargetStreamInputs []*RemoveApplicationStreamInputRequest_TargetStreamInput `protobuf:"bytes,2,rep,name=target_stream_inputs,json=targetStreamInputs,proto3" json:"target_stream_inputs,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *RemoveApplicationStreamInputRequest) Reset() {
	*x = RemoveApplicationStreamInputRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveApplicationStreamInputRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveApplicationStreamInputRequest) ProtoMessage() {}

func (x *RemoveApplicationStreamInputRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveApplicationStreamInputRequest.ProtoReflect.Descriptor instead.
func (*RemoveApplicationStreamInputRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{21}
}

func (x *RemoveApplicationStreamInputRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RemoveApplicationStreamInputRequest) GetTargetStreamInputs() []*RemoveApplicationStreamInputRequest_TargetStreamInput {
	if x != nil {
		return x.TargetStreamInputs
	}
	return nil
}

func (x *RemoveApplicationStreamInputRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for requesting list of Instances.
type ListInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListInstancesRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListInstancesRequest) Reset() {
	*x = ListInstancesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesRequest) ProtoMessage() {}

func (x *ListInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesRequest.ProtoReflect.Descriptor instead.
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{22}
}

func (x *ListInstancesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstancesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstancesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInstancesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInstancesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing Instances.
type ListInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Instance.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListInstancesResponse) Reset() {
	*x = ListInstancesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesResponse) ProtoMessage() {}

func (x *ListInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesResponse.ProtoReflect.Descriptor instead.
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{23}
}

func (x *ListInstancesResponse) GetInstances() []*Instance {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *ListInstancesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListInstancesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a Instance.
type GetInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInstanceRequest) Reset() {
	*x = GetInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInstanceRequest) ProtoMessage() {}

func (x *GetInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInstanceRequest.ProtoReflect.Descriptor instead.
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{24}
}

func (x *GetInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for requesting list of Drafts.
type ListDraftsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListDraftsRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDraftsRequest) Reset() {
	*x = ListDraftsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDraftsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDraftsRequest) ProtoMessage() {}

func (x *ListDraftsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDraftsRequest.ProtoReflect.Descriptor instead.
func (*ListDraftsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{25}
}

func (x *ListDraftsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDraftsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDraftsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDraftsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDraftsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing Drafts.
type ListDraftsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Draft.
	Drafts []*Draft `protobuf:"bytes,1,rep,name=drafts,proto3" json:"drafts,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDraftsResponse) Reset() {
	*x = ListDraftsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDraftsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDraftsResponse) ProtoMessage() {}

func (x *ListDraftsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDraftsResponse.ProtoReflect.Descriptor instead.
func (*ListDraftsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{26}
}

func (x *ListDraftsResponse) GetDrafts() []*Draft {
	if x != nil {
		return x.Drafts
	}
	return nil
}

func (x *ListDraftsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDraftsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a Draft.
type GetDraftRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDraftRequest) Reset() {
	*x = GetDraftRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDraftRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDraftRequest) ProtoMessage() {}

func (x *GetDraftRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDraftRequest.ProtoReflect.Descriptor instead.
func (*GetDraftRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{27}
}

func (x *GetDraftRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a Draft.
type CreateDraftRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting object.
	DraftId string `protobuf:"bytes,2,opt,name=draft_id,json=draftId,proto3" json:"draft_id,omitempty"`
	// Required. The resource being created.
	Draft *Draft `protobuf:"bytes,3,opt,name=draft,proto3" json:"draft,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateDraftRequest) Reset() {
	*x = CreateDraftRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDraftRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDraftRequest) ProtoMessage() {}

func (x *CreateDraftRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDraftRequest.ProtoReflect.Descriptor instead.
func (*CreateDraftRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{28}
}

func (x *CreateDraftRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDraftRequest) GetDraftId() string {
	if x != nil {
		return x.DraftId
	}
	return ""
}

func (x *CreateDraftRequest) GetDraft() *Draft {
	if x != nil {
		return x.Draft
	}
	return nil
}

func (x *CreateDraftRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating an Draft.
type UpdateDraftRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// Draft resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated.
	Draft *Draft `protobuf:"bytes,2,opt,name=draft,proto3" json:"draft,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// If true, UpdateDraftRequest will create one resource if the target resource
	// doesn't exist, this time, the field_mask will be ignored.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateDraftRequest) Reset() {
	*x = UpdateDraftRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDraftRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDraftRequest) ProtoMessage() {}

func (x *UpdateDraftRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDraftRequest.ProtoReflect.Descriptor instead.
func (*UpdateDraftRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{29}
}

func (x *UpdateDraftRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDraftRequest) GetDraft() *Draft {
	if x != nil {
		return x.Draft
	}
	return nil
}

func (x *UpdateDraftRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateDraftRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Message for updating an ApplicationInstance.
type UpdateApplicationInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. the name of the application to retrieve.
	// Format:
	// "projects/{project}/locations/{location}/applications/{application}"
	Name                 string                                                         `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	ApplicationInstances []*UpdateApplicationInstancesRequest_UpdateApplicationInstance `protobuf:"bytes,2,rep,name=application_instances,json=applicationInstances,proto3" json:"application_instances,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// If true, Update Request will create one resource if the target resource
	// doesn't exist, this time, the field_mask will be ignored.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateApplicationInstancesRequest) Reset() {
	*x = UpdateApplicationInstancesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateApplicationInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateApplicationInstancesRequest) ProtoMessage() {}

func (x *UpdateApplicationInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateApplicationInstancesRequest.ProtoReflect.Descriptor instead.
func (*UpdateApplicationInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateApplicationInstancesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateApplicationInstancesRequest) GetApplicationInstances() []*UpdateApplicationInstancesRequest_UpdateApplicationInstance {
	if x != nil {
		return x.ApplicationInstances
	}
	return nil
}

func (x *UpdateApplicationInstancesRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateApplicationInstancesRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Message for deleting an Draft.
type DeleteDraftRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteDraftRequest) Reset() {
	*x = DeleteDraftRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDraftRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDraftRequest) ProtoMessage() {}

func (x *DeleteDraftRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDraftRequest.ProtoReflect.Descriptor instead.
func (*DeleteDraftRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{31}
}

func (x *DeleteDraftRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDraftRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for requesting list of Processors.
type ListProcessorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListProcessorsRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListProcessorsRequest) Reset() {
	*x = ListProcessorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorsRequest) ProtoMessage() {}

func (x *ListProcessorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorsRequest.ProtoReflect.Descriptor instead.
func (*ListProcessorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{32}
}

func (x *ListProcessorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProcessorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProcessorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListProcessorsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListProcessorsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing Processors.
type ListProcessorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Processor.
	Processors []*Processor `protobuf:"bytes,1,rep,name=processors,proto3" json:"processors,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListProcessorsResponse) Reset() {
	*x = ListProcessorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorsResponse) ProtoMessage() {}

func (x *ListProcessorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorsResponse.ProtoReflect.Descriptor instead.
func (*ListProcessorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{33}
}

func (x *ListProcessorsResponse) GetProcessors() []*Processor {
	if x != nil {
		return x.Processors
	}
	return nil
}

func (x *ListProcessorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListProcessorsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request Message for listing Prebuilt Processors.
type ListPrebuiltProcessorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent path.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListPrebuiltProcessorsRequest) Reset() {
	*x = ListPrebuiltProcessorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrebuiltProcessorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrebuiltProcessorsRequest) ProtoMessage() {}

func (x *ListPrebuiltProcessorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrebuiltProcessorsRequest.ProtoReflect.Descriptor instead.
func (*ListPrebuiltProcessorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{34}
}

func (x *ListPrebuiltProcessorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response Message for listing Prebuilt Processors.
type ListPrebuiltProcessorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Processor.
	Processors []*Processor `protobuf:"bytes,1,rep,name=processors,proto3" json:"processors,omitempty"`
}

func (x *ListPrebuiltProcessorsResponse) Reset() {
	*x = ListPrebuiltProcessorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrebuiltProcessorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrebuiltProcessorsResponse) ProtoMessage() {}

func (x *ListPrebuiltProcessorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrebuiltProcessorsResponse.ProtoReflect.Descriptor instead.
func (*ListPrebuiltProcessorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{35}
}

func (x *ListPrebuiltProcessorsResponse) GetProcessors() []*Processor {
	if x != nil {
		return x.Processors
	}
	return nil
}

// Message for getting a Processor.
type GetProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProcessorRequest) Reset() {
	*x = GetProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProcessorRequest) ProtoMessage() {}

func (x *GetProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProcessorRequest.ProtoReflect.Descriptor instead.
func (*GetProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{36}
}

func (x *GetProcessorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a Processor.
type CreateProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting object.
	ProcessorId string `protobuf:"bytes,2,opt,name=processor_id,json=processorId,proto3" json:"processor_id,omitempty"`
	// Required. The resource being created.
	Processor *Processor `protobuf:"bytes,3,opt,name=processor,proto3" json:"processor,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateProcessorRequest) Reset() {
	*x = CreateProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateProcessorRequest) ProtoMessage() {}

func (x *CreateProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateProcessorRequest.ProtoReflect.Descriptor instead.
func (*CreateProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{37}
}

func (x *CreateProcessorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateProcessorRequest) GetProcessorId() string {
	if x != nil {
		return x.ProcessorId
	}
	return ""
}

func (x *CreateProcessorRequest) GetProcessor() *Processor {
	if x != nil {
		return x.Processor
	}
	return nil
}

func (x *CreateProcessorRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating a Processor.
type UpdateProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// Processor resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated.
	Processor *Processor `protobuf:"bytes,2,opt,name=processor,proto3" json:"processor,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateProcessorRequest) Reset() {
	*x = UpdateProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateProcessorRequest) ProtoMessage() {}

func (x *UpdateProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateProcessorRequest.ProtoReflect.Descriptor instead.
func (*UpdateProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{38}
}

func (x *UpdateProcessorRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateProcessorRequest) GetProcessor() *Processor {
	if x != nil {
		return x.Processor
	}
	return nil
}

func (x *UpdateProcessorRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting a Processor.
type DeleteProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteProcessorRequest) Reset() {
	*x = DeleteProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessorRequest) ProtoMessage() {}

func (x *DeleteProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessorRequest.ProtoReflect.Descriptor instead.
func (*DeleteProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{39}
}

func (x *DeleteProcessorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteProcessorRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message describing Application object
type Application struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. [Output only] Create timestamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update timestamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. A user friendly display name for the solution.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A description for this application.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Application graph configuration.
	ApplicationConfigs *ApplicationConfigs `protobuf:"bytes,7,opt,name=application_configs,json=applicationConfigs,proto3" json:"application_configs,omitempty"`
	// Output only. Application graph runtime info. Only exists when application state equals
	// to DEPLOYED.
	RuntimeInfo *Application_ApplicationRuntimeInfo `protobuf:"bytes,8,opt,name=runtime_info,json=runtimeInfo,proto3" json:"runtime_info,omitempty"`
	// Output only. State of the application.
	State Application_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.visionai.v1alpha1.Application_State" json:"state,omitempty"`
}

func (x *Application) Reset() {
	*x = Application{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Application) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Application) ProtoMessage() {}

func (x *Application) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Application.ProtoReflect.Descriptor instead.
func (*Application) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{40}
}

func (x *Application) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Application) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Application) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Application) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Application) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Application) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Application) GetApplicationConfigs() *ApplicationConfigs {
	if x != nil {
		return x.ApplicationConfigs
	}
	return nil
}

func (x *Application) GetRuntimeInfo() *Application_ApplicationRuntimeInfo {
	if x != nil {
		return x.RuntimeInfo
	}
	return nil
}

func (x *Application) GetState() Application_State {
	if x != nil {
		return x.State
	}
	return Application_STATE_UNSPECIFIED
}

// Message storing the graph of the application.
type ApplicationConfigs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of nodes  in the application graph.
	Nodes []*Node `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	// Event-related configuration for this application.
	EventDeliveryConfig *ApplicationConfigs_EventDeliveryConfig `protobuf:"bytes,3,opt,name=event_delivery_config,json=eventDeliveryConfig,proto3" json:"event_delivery_config,omitempty"`
}

func (x *ApplicationConfigs) Reset() {
	*x = ApplicationConfigs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigs) ProtoMessage() {}

func (x *ApplicationConfigs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigs.ProtoReflect.Descriptor instead.
func (*ApplicationConfigs) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{41}
}

func (x *ApplicationConfigs) GetNodes() []*Node {
	if x != nil {
		return x.Nodes
	}
	return nil
}

func (x *ApplicationConfigs) GetEventDeliveryConfig() *ApplicationConfigs_EventDeliveryConfig {
	if x != nil {
		return x.EventDeliveryConfig
	}
	return nil
}

// Message describing node object.
type Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to StreamOutputConfig:
	//
	//	*Node_OutputAllOutputChannelsToStream
	StreamOutputConfig isNode_StreamOutputConfig `protobuf_oneof:"stream_output_config"`
	// Required. A unique name for the node.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A user friendly display name for the node.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Node config.
	NodeConfig *ProcessorConfig `protobuf:"bytes,3,opt,name=node_config,json=nodeConfig,proto3" json:"node_config,omitempty"`
	// Processor name refer to the chosen processor resource.
	Processor string `protobuf:"bytes,4,opt,name=processor,proto3" json:"processor,omitempty"`
	// Parent node. Input node should not have parent node. For V1 Alpha1/Beta
	// only media warehouse node can have multiple parents, other types of nodes
	// will only have one parent.
	Parents []*Node_InputEdge `protobuf:"bytes,5,rep,name=parents,proto3" json:"parents,omitempty"`
}

func (x *Node) Reset() {
	*x = Node{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Node) ProtoMessage() {}

func (x *Node) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Node.ProtoReflect.Descriptor instead.
func (*Node) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{42}
}

func (m *Node) GetStreamOutputConfig() isNode_StreamOutputConfig {
	if m != nil {
		return m.StreamOutputConfig
	}
	return nil
}

func (x *Node) GetOutputAllOutputChannelsToStream() bool {
	if x, ok := x.GetStreamOutputConfig().(*Node_OutputAllOutputChannelsToStream); ok {
		return x.OutputAllOutputChannelsToStream
	}
	return false
}

func (x *Node) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Node) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Node) GetNodeConfig() *ProcessorConfig {
	if x != nil {
		return x.NodeConfig
	}
	return nil
}

func (x *Node) GetProcessor() string {
	if x != nil {
		return x.Processor
	}
	return ""
}

func (x *Node) GetParents() []*Node_InputEdge {
	if x != nil {
		return x.Parents
	}
	return nil
}

type isNode_StreamOutputConfig interface {
	isNode_StreamOutputConfig()
}

type Node_OutputAllOutputChannelsToStream struct {
	// By default, the output of the node will only be available to downstream
	// nodes. To consume the direct output from the application node, the output
	// must be sent to Vision AI Streams at first.
	//
	// By setting output_all_output_channels_to_stream to true, App Platform
	// will automatically send all the outputs of the current node to Vision AI
	// Stream resources (one stream per output channel). The output stream
	// resource will be created by App Platform automatically during deployment
	// and deleted after application un-deployment.
	// Note that this config applies to all the Application Instances.
	//
	// The output stream can be override at instance level by
	// configuring the `output_resources` section of Instance resource.
	// `producer_node` should be current node, `output_resource_binding` should
	// be the output channel name (or leave it blank if there is only 1 output
	// channel of the processor) and `output_resource` should be the target
	// output stream.
	OutputAllOutputChannelsToStream bool `protobuf:"varint,6,opt,name=output_all_output_channels_to_stream,json=outputAllOutputChannelsToStream,proto3,oneof"`
}

func (*Node_OutputAllOutputChannelsToStream) isNode_StreamOutputConfig() {}

// Message describing Draft object
type Draft struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. [Output only] Create timestamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Create timestamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. A user friendly display name for the solution.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A description for this application.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// The draft application configs which haven't been updated to an application.
	DraftApplicationConfigs *ApplicationConfigs `protobuf:"bytes,6,opt,name=draft_application_configs,json=draftApplicationConfigs,proto3" json:"draft_application_configs,omitempty"`
}

func (x *Draft) Reset() {
	*x = Draft{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Draft) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Draft) ProtoMessage() {}

func (x *Draft) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Draft.ProtoReflect.Descriptor instead.
func (*Draft) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{43}
}

func (x *Draft) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Draft) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Draft) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Draft) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Draft) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Draft) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Draft) GetDraftApplicationConfigs() *ApplicationConfigs {
	if x != nil {
		return x.DraftApplicationConfigs
	}
	return nil
}

// Message describing Instance object
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. name of resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. [Output only] Create timestamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update timestamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. A user friendly display name for the solution.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A description for this application.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// The input resources for the current application instance.
	// For example:
	// input_resources:
	// visionai.googleapis.com/v1/projects/123/locations/us-central1/clusters/456/streams/stream-a
	InputResources []*Instance_InputResource `protobuf:"bytes,6,rep,name=input_resources,json=inputResources,proto3" json:"input_resources,omitempty"`
	// All the output resources associated to one application instance.
	OutputResources []*Instance_OutputResource `protobuf:"bytes,7,rep,name=output_resources,json=outputResources,proto3" json:"output_resources,omitempty"`
	// State of the instance.
	State Instance_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.visionai.v1alpha1.Instance_State" json:"state,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{44}
}

func (x *Instance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Instance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Instance) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Instance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Instance) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Instance) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Instance) GetInputResources() []*Instance_InputResource {
	if x != nil {
		return x.InputResources
	}
	return nil
}

func (x *Instance) GetOutputResources() []*Instance_OutputResource {
	if x != nil {
		return x.OutputResources
	}
	return nil
}

func (x *Instance) GetState() Instance_State {
	if x != nil {
		return x.State
	}
	return Instance_STATE_UNSPECIFIED
}

// Message for creating a Instance.
type ApplicationInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Id of the requesting object.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. The resource being created.
	Instance *Instance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *ApplicationInstance) Reset() {
	*x = ApplicationInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationInstance) ProtoMessage() {}

func (x *ApplicationInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationInstance.ProtoReflect.Descriptor instead.
func (*ApplicationInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{45}
}

func (x *ApplicationInstance) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *ApplicationInstance) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Message describing Processor object.
// Next ID: 18
type Processor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. [Output only] Create timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels as key value pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. A user friendly display name for the processor.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Illustrative sentences for describing the functionality of the processor.
	Description string `protobuf:"bytes,10,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Processor Type.
	ProcessorType Processor_ProcessorType `protobuf:"varint,6,opt,name=processor_type,json=processorType,proto3,enum=google.cloud.visionai.v1alpha1.Processor_ProcessorType" json:"processor_type,omitempty"`
	// Model Type.
	ModelType ModelType `protobuf:"varint,13,opt,name=model_type,json=modelType,proto3,enum=google.cloud.visionai.v1alpha1.ModelType" json:"model_type,omitempty"`
	// Source info for customer created processor.
	CustomProcessorSourceInfo *CustomProcessorSourceInfo `protobuf:"bytes,7,opt,name=custom_processor_source_info,json=customProcessorSourceInfo,proto3" json:"custom_processor_source_info,omitempty"`
	// Output only. State of the Processor.
	State Processor_ProcessorState `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.visionai.v1alpha1.Processor_ProcessorState" json:"state,omitempty"`
	// Output only. [Output only] The input / output specifications of a processor, each type
	// of processor has fixed input / output specs which cannot be altered by
	// customer.
	ProcessorIoSpec *ProcessorIOSpec `protobuf:"bytes,11,opt,name=processor_io_spec,json=processorIoSpec,proto3" json:"processor_io_spec,omitempty"`
	// Output only. The corresponding configuration can be used in the Application to customize
	// the behavior of the processor.
	ConfigurationTypeurl     string                 `protobuf:"bytes,14,opt,name=configuration_typeurl,json=configurationTypeurl,proto3" json:"configuration_typeurl,omitempty"`
	SupportedAnnotationTypes []StreamAnnotationType `protobuf:"varint,15,rep,packed,name=supported_annotation_types,json=supportedAnnotationTypes,proto3,enum=google.cloud.visionai.v1alpha1.StreamAnnotationType" json:"supported_annotation_types,omitempty"`
	// Indicates if the processor supports post processing.
	SupportsPostProcessing bool `protobuf:"varint,17,opt,name=supports_post_processing,json=supportsPostProcessing,proto3" json:"supports_post_processing,omitempty"`
}

func (x *Processor) Reset() {
	*x = Processor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Processor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Processor) ProtoMessage() {}

func (x *Processor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Processor.ProtoReflect.Descriptor instead.
func (*Processor) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{46}
}

func (x *Processor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Processor) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Processor) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Processor) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Processor) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Processor) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Processor) GetProcessorType() Processor_ProcessorType {
	if x != nil {
		return x.ProcessorType
	}
	return Processor_PROCESSOR_TYPE_UNSPECIFIED
}

func (x *Processor) GetModelType() ModelType {
	if x != nil {
		return x.ModelType
	}
	return ModelType_MODEL_TYPE_UNSPECIFIED
}

func (x *Processor) GetCustomProcessorSourceInfo() *CustomProcessorSourceInfo {
	if x != nil {
		return x.CustomProcessorSourceInfo
	}
	return nil
}

func (x *Processor) GetState() Processor_ProcessorState {
	if x != nil {
		return x.State
	}
	return Processor_PROCESSOR_STATE_UNSPECIFIED
}

func (x *Processor) GetProcessorIoSpec() *ProcessorIOSpec {
	if x != nil {
		return x.ProcessorIoSpec
	}
	return nil
}

func (x *Processor) GetConfigurationTypeurl() string {
	if x != nil {
		return x.ConfigurationTypeurl
	}
	return ""
}

func (x *Processor) GetSupportedAnnotationTypes() []StreamAnnotationType {
	if x != nil {
		return x.SupportedAnnotationTypes
	}
	return nil
}

func (x *Processor) GetSupportsPostProcessing() bool {
	if x != nil {
		return x.SupportsPostProcessing
	}
	return false
}

// Message describing the input / output specifications of a processor.
type ProcessorIOSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For processors with input_channel_specs, the processor must be explicitly
	// connected to another processor.
	GraphInputChannelSpecs []*ProcessorIOSpec_GraphInputChannelSpec `protobuf:"bytes,3,rep,name=graph_input_channel_specs,json=graphInputChannelSpecs,proto3" json:"graph_input_channel_specs,omitempty"`
	// The output artifact specifications for the current processor.
	GraphOutputChannelSpecs []*ProcessorIOSpec_GraphOutputChannelSpec `protobuf:"bytes,4,rep,name=graph_output_channel_specs,json=graphOutputChannelSpecs,proto3" json:"graph_output_channel_specs,omitempty"`
	// The input resource that needs to be fed from the application instance.
	InstanceResourceInputBindingSpecs []*ProcessorIOSpec_InstanceResourceInputBindingSpec `protobuf:"bytes,5,rep,name=instance_resource_input_binding_specs,json=instanceResourceInputBindingSpecs,proto3" json:"instance_resource_input_binding_specs,omitempty"`
	// The output resource that the processor will generate per instance.
	// Other than the explicitly listed output bindings here, all the processors'
	// GraphOutputChannels can be binded to stream resource. The bind name then is
	// the same as the GraphOutputChannel's name.
	InstanceResourceOutputBindingSpecs []*ProcessorIOSpec_InstanceResourceOutputBindingSpec `protobuf:"bytes,6,rep,name=instance_resource_output_binding_specs,json=instanceResourceOutputBindingSpecs,proto3" json:"instance_resource_output_binding_specs,omitempty"`
}

func (x *ProcessorIOSpec) Reset() {
	*x = ProcessorIOSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessorIOSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorIOSpec) ProtoMessage() {}

func (x *ProcessorIOSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorIOSpec.ProtoReflect.Descriptor instead.
func (*ProcessorIOSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{47}
}

func (x *ProcessorIOSpec) GetGraphInputChannelSpecs() []*ProcessorIOSpec_GraphInputChannelSpec {
	if x != nil {
		return x.GraphInputChannelSpecs
	}
	return nil
}

func (x *ProcessorIOSpec) GetGraphOutputChannelSpecs() []*ProcessorIOSpec_GraphOutputChannelSpec {
	if x != nil {
		return x.GraphOutputChannelSpecs
	}
	return nil
}

func (x *ProcessorIOSpec) GetInstanceResourceInputBindingSpecs() []*ProcessorIOSpec_InstanceResourceInputBindingSpec {
	if x != nil {
		return x.InstanceResourceInputBindingSpecs
	}
	return nil
}

func (x *ProcessorIOSpec) GetInstanceResourceOutputBindingSpecs() []*ProcessorIOSpec_InstanceResourceOutputBindingSpec {
	if x != nil {
		return x.InstanceResourceOutputBindingSpecs
	}
	return nil
}

// Describes the source info for a custom processor.
type CustomProcessorSourceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path where App Platform loads the artifacts for the custom processor.
	//
	// Types that are assignable to ArtifactPath:
	//
	//	*CustomProcessorSourceInfo_VertexModel
	ArtifactPath isCustomProcessorSourceInfo_ArtifactPath `protobuf_oneof:"artifact_path"`
	// The original product which holds the custom processor's functionality.
	SourceType CustomProcessorSourceInfo_SourceType `protobuf:"varint,1,opt,name=source_type,json=sourceType,proto3,enum=google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo_SourceType" json:"source_type,omitempty"`
	// Output only. Additional info related to the imported custom processor.
	// Data is filled in by app platform during the processor creation.
	AdditionalInfo map[string]string `protobuf:"bytes,4,rep,name=additional_info,json=additionalInfo,proto3" json:"additional_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Model schema files which specifies the signature of the model.
	// For VERTEX_CUSTOM models, instances schema is required.
	// If instances schema is not specified during the processor creation,
	// VisionAI Platform will try to get it from Vertex, if it doesn't exist, the
	// creation will fail.
	ModelSchema *CustomProcessorSourceInfo_ModelSchema `protobuf:"bytes,5,opt,name=model_schema,json=modelSchema,proto3" json:"model_schema,omitempty"`
}

func (x *CustomProcessorSourceInfo) Reset() {
	*x = CustomProcessorSourceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomProcessorSourceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomProcessorSourceInfo) ProtoMessage() {}

func (x *CustomProcessorSourceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomProcessorSourceInfo.ProtoReflect.Descriptor instead.
func (*CustomProcessorSourceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{48}
}

func (m *CustomProcessorSourceInfo) GetArtifactPath() isCustomProcessorSourceInfo_ArtifactPath {
	if m != nil {
		return m.ArtifactPath
	}
	return nil
}

func (x *CustomProcessorSourceInfo) GetVertexModel() string {
	if x, ok := x.GetArtifactPath().(*CustomProcessorSourceInfo_VertexModel); ok {
		return x.VertexModel
	}
	return ""
}

func (x *CustomProcessorSourceInfo) GetSourceType() CustomProcessorSourceInfo_SourceType {
	if x != nil {
		return x.SourceType
	}
	return CustomProcessorSourceInfo_SOURCE_TYPE_UNSPECIFIED
}

func (x *CustomProcessorSourceInfo) GetAdditionalInfo() map[string]string {
	if x != nil {
		return x.AdditionalInfo
	}
	return nil
}

func (x *CustomProcessorSourceInfo) GetModelSchema() *CustomProcessorSourceInfo_ModelSchema {
	if x != nil {
		return x.ModelSchema
	}
	return nil
}

type isCustomProcessorSourceInfo_ArtifactPath interface {
	isCustomProcessorSourceInfo_ArtifactPath()
}

type CustomProcessorSourceInfo_VertexModel struct {
	// The resource name original model hosted in the vertex AI platform.
	VertexModel string `protobuf:"bytes,2,opt,name=vertex_model,json=vertexModel,proto3,oneof"`
}

func (*CustomProcessorSourceInfo_VertexModel) isCustomProcessorSourceInfo_ArtifactPath() {}

// Next ID: 24
type ProcessorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ProcessorConfig:
	//
	//	*ProcessorConfig_VideoStreamInputConfig
	//	*ProcessorConfig_AiEnabledDevicesInputConfig
	//	*ProcessorConfig_MediaWarehouseConfig
	//	*ProcessorConfig_PersonBlurConfig
	//	*ProcessorConfig_OccupancyCountConfig
	//	*ProcessorConfig_PersonVehicleDetectionConfig
	//	*ProcessorConfig_VertexAutomlVisionConfig
	//	*ProcessorConfig_VertexAutomlVideoConfig
	//	*ProcessorConfig_VertexCustomConfig
	//	*ProcessorConfig_GeneralObjectDetectionConfig
	//	*ProcessorConfig_BigQueryConfig
	//	*ProcessorConfig_PersonalProtectiveEquipmentDetectionConfig
	ProcessorConfig isProcessorConfig_ProcessorConfig `protobuf_oneof:"processor_config"`
}

func (x *ProcessorConfig) Reset() {
	*x = ProcessorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorConfig) ProtoMessage() {}

func (x *ProcessorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorConfig.ProtoReflect.Descriptor instead.
func (*ProcessorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{49}
}

func (m *ProcessorConfig) GetProcessorConfig() isProcessorConfig_ProcessorConfig {
	if m != nil {
		return m.ProcessorConfig
	}
	return nil
}

func (x *ProcessorConfig) GetVideoStreamInputConfig() *VideoStreamInputConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_VideoStreamInputConfig); ok {
		return x.VideoStreamInputConfig
	}
	return nil
}

func (x *ProcessorConfig) GetAiEnabledDevicesInputConfig() *AIEnabledDevicesInputConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_AiEnabledDevicesInputConfig); ok {
		return x.AiEnabledDevicesInputConfig
	}
	return nil
}

func (x *ProcessorConfig) GetMediaWarehouseConfig() *MediaWarehouseConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_MediaWarehouseConfig); ok {
		return x.MediaWarehouseConfig
	}
	return nil
}

func (x *ProcessorConfig) GetPersonBlurConfig() *PersonBlurConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_PersonBlurConfig); ok {
		return x.PersonBlurConfig
	}
	return nil
}

func (x *ProcessorConfig) GetOccupancyCountConfig() *OccupancyCountConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_OccupancyCountConfig); ok {
		return x.OccupancyCountConfig
	}
	return nil
}

func (x *ProcessorConfig) GetPersonVehicleDetectionConfig() *PersonVehicleDetectionConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_PersonVehicleDetectionConfig); ok {
		return x.PersonVehicleDetectionConfig
	}
	return nil
}

func (x *ProcessorConfig) GetVertexAutomlVisionConfig() *VertexAutoMLVisionConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_VertexAutomlVisionConfig); ok {
		return x.VertexAutomlVisionConfig
	}
	return nil
}

func (x *ProcessorConfig) GetVertexAutomlVideoConfig() *VertexAutoMLVideoConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_VertexAutomlVideoConfig); ok {
		return x.VertexAutomlVideoConfig
	}
	return nil
}

func (x *ProcessorConfig) GetVertexCustomConfig() *VertexCustomConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_VertexCustomConfig); ok {
		return x.VertexCustomConfig
	}
	return nil
}

func (x *ProcessorConfig) GetGeneralObjectDetectionConfig() *GeneralObjectDetectionConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_GeneralObjectDetectionConfig); ok {
		return x.GeneralObjectDetectionConfig
	}
	return nil
}

func (x *ProcessorConfig) GetBigQueryConfig() *BigQueryConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_BigQueryConfig); ok {
		return x.BigQueryConfig
	}
	return nil
}

func (x *ProcessorConfig) GetPersonalProtectiveEquipmentDetectionConfig() *PersonalProtectiveEquipmentDetectionConfig {
	if x, ok := x.GetProcessorConfig().(*ProcessorConfig_PersonalProtectiveEquipmentDetectionConfig); ok {
		return x.PersonalProtectiveEquipmentDetectionConfig
	}
	return nil
}

type isProcessorConfig_ProcessorConfig interface {
	isProcessorConfig_ProcessorConfig()
}

type ProcessorConfig_VideoStreamInputConfig struct {
	// Configs of stream input processor.
	VideoStreamInputConfig *VideoStreamInputConfig `protobuf:"bytes,9,opt,name=video_stream_input_config,json=videoStreamInputConfig,proto3,oneof"`
}

type ProcessorConfig_AiEnabledDevicesInputConfig struct {
	// Config of AI-enabled input devices.
	AiEnabledDevicesInputConfig *AIEnabledDevicesInputConfig `protobuf:"bytes,20,opt,name=ai_enabled_devices_input_config,json=aiEnabledDevicesInputConfig,proto3,oneof"`
}

type ProcessorConfig_MediaWarehouseConfig struct {
	// Configs of media warehouse processor.
	MediaWarehouseConfig *MediaWarehouseConfig `protobuf:"bytes,10,opt,name=media_warehouse_config,json=mediaWarehouseConfig,proto3,oneof"`
}

type ProcessorConfig_PersonBlurConfig struct {
	// Configs of person blur processor.
	PersonBlurConfig *PersonBlurConfig `protobuf:"bytes,11,opt,name=person_blur_config,json=personBlurConfig,proto3,oneof"`
}

type ProcessorConfig_OccupancyCountConfig struct {
	// Configs of occupancy count processor.
	OccupancyCountConfig *OccupancyCountConfig `protobuf:"bytes,12,opt,name=occupancy_count_config,json=occupancyCountConfig,proto3,oneof"`
}

type ProcessorConfig_PersonVehicleDetectionConfig struct {
	// Configs of Person Vehicle Detection processor.
	PersonVehicleDetectionConfig *PersonVehicleDetectionConfig `protobuf:"bytes,15,opt,name=person_vehicle_detection_config,json=personVehicleDetectionConfig,proto3,oneof"`
}

type ProcessorConfig_VertexAutomlVisionConfig struct {
	// Configs of Vertex AutoML vision processor.
	VertexAutomlVisionConfig *VertexAutoMLVisionConfig `protobuf:"bytes,13,opt,name=vertex_automl_vision_config,json=vertexAutomlVisionConfig,proto3,oneof"`
}

type ProcessorConfig_VertexAutomlVideoConfig struct {
	// Configs of Vertex AutoML video processor.
	VertexAutomlVideoConfig *VertexAutoMLVideoConfig `protobuf:"bytes,14,opt,name=vertex_automl_video_config,json=vertexAutomlVideoConfig,proto3,oneof"`
}

type ProcessorConfig_VertexCustomConfig struct {
	// Configs of Vertex Custom processor.
	VertexCustomConfig *VertexCustomConfig `protobuf:"bytes,17,opt,name=vertex_custom_config,json=vertexCustomConfig,proto3,oneof"`
}

type ProcessorConfig_GeneralObjectDetectionConfig struct {
	// Configs of General Object Detection processor.
	GeneralObjectDetectionConfig *GeneralObjectDetectionConfig `protobuf:"bytes,18,opt,name=general_object_detection_config,json=generalObjectDetectionConfig,proto3,oneof"`
}

type ProcessorConfig_BigQueryConfig struct {
	// Configs of BigQuery processor.
	BigQueryConfig *BigQueryConfig `protobuf:"bytes,19,opt,name=big_query_config,json=bigQueryConfig,proto3,oneof"`
}

type ProcessorConfig_PersonalProtectiveEquipmentDetectionConfig struct {
	// Configs of personal_protective_equipment_detection_config
	PersonalProtectiveEquipmentDetectionConfig *PersonalProtectiveEquipmentDetectionConfig `protobuf:"bytes,22,opt,name=personal_protective_equipment_detection_config,json=personalProtectiveEquipmentDetectionConfig,proto3,oneof"`
}

func (*ProcessorConfig_VideoStreamInputConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_AiEnabledDevicesInputConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_MediaWarehouseConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_PersonBlurConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_OccupancyCountConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_PersonVehicleDetectionConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_VertexAutomlVisionConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_VertexAutomlVideoConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_VertexCustomConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_GeneralObjectDetectionConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_BigQueryConfig) isProcessorConfig_ProcessorConfig() {}

func (*ProcessorConfig_PersonalProtectiveEquipmentDetectionConfig) isProcessorConfig_ProcessorConfig() {
}

// Message describing Vision AI stream with application specific annotations.
// All the StreamAnnotation object inside this message MUST have unique id.
type StreamWithAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Vision AI Stream resource name.
	Stream string `protobuf:"bytes,1,opt,name=stream,proto3" json:"stream,omitempty"`
	// Annotations that will be applied to the whole application.
	ApplicationAnnotations []*StreamAnnotation `protobuf:"bytes,2,rep,name=application_annotations,json=applicationAnnotations,proto3" json:"application_annotations,omitempty"`
	// Annotations that will be applied to the specific node of the application.
	// If the same type of the annotations is applied to both application and
	// node, the node annotation will be added in addition to the global
	// application one.
	// For example, if there is one active zone annotation for the whole
	// application and one active zone annotation for the Occupancy Analytic
	// processor, then the Occupancy Analytic processor will have two active zones
	// defined.
	NodeAnnotations []*StreamWithAnnotation_NodeAnnotation `protobuf:"bytes,3,rep,name=node_annotations,json=nodeAnnotations,proto3" json:"node_annotations,omitempty"`
}

func (x *StreamWithAnnotation) Reset() {
	*x = StreamWithAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamWithAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamWithAnnotation) ProtoMessage() {}

func (x *StreamWithAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamWithAnnotation.ProtoReflect.Descriptor instead.
func (*StreamWithAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{50}
}

func (x *StreamWithAnnotation) GetStream() string {
	if x != nil {
		return x.Stream
	}
	return ""
}

func (x *StreamWithAnnotation) GetApplicationAnnotations() []*StreamAnnotation {
	if x != nil {
		return x.ApplicationAnnotations
	}
	return nil
}

func (x *StreamWithAnnotation) GetNodeAnnotations() []*StreamWithAnnotation_NodeAnnotation {
	if x != nil {
		return x.NodeAnnotations
	}
	return nil
}

// Message describing annotations specific to application node.
// This message is a duplication of StreamWithAnnotation.NodeAnnotation.
type ApplicationNodeAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The node name of the application graph.
	Node string `protobuf:"bytes,1,opt,name=node,proto3" json:"node,omitempty"`
	// The node specific stream annotations.
	Annotations []*StreamAnnotation `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *ApplicationNodeAnnotation) Reset() {
	*x = ApplicationNodeAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationNodeAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationNodeAnnotation) ProtoMessage() {}

func (x *ApplicationNodeAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationNodeAnnotation.ProtoReflect.Descriptor instead.
func (*ApplicationNodeAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{51}
}

func (x *ApplicationNodeAnnotation) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *ApplicationNodeAnnotation) GetAnnotations() []*StreamAnnotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// Message describing general annotation for resources.
type ResourceAnnotations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Annotations that will be applied to the whole application.
	ApplicationAnnotations []*StreamAnnotation `protobuf:"bytes,1,rep,name=application_annotations,json=applicationAnnotations,proto3" json:"application_annotations,omitempty"`
	// Annotations that will be applied to the specific node of the application.
	// If the same type of the annotations is applied to both application and
	// node, the node annotation will be added in addition to the global
	// application one.
	// For example, if there is one active zone annotation for the whole
	// application and one active zone annotation for the Occupancy Analytic
	// processor, then the Occupancy Analytic processor will have two active zones
	// defined.
	NodeAnnotations []*ApplicationNodeAnnotation `protobuf:"bytes,2,rep,name=node_annotations,json=nodeAnnotations,proto3" json:"node_annotations,omitempty"`
}

func (x *ResourceAnnotations) Reset() {
	*x = ResourceAnnotations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceAnnotations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceAnnotations) ProtoMessage() {}

func (x *ResourceAnnotations) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceAnnotations.ProtoReflect.Descriptor instead.
func (*ResourceAnnotations) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{52}
}

func (x *ResourceAnnotations) GetApplicationAnnotations() []*StreamAnnotation {
	if x != nil {
		return x.ApplicationAnnotations
	}
	return nil
}

func (x *ResourceAnnotations) GetNodeAnnotations() []*ApplicationNodeAnnotation {
	if x != nil {
		return x.NodeAnnotations
	}
	return nil
}

// Message describing Video Stream Input Config.
// This message should only be used as a placeholder for builtin:stream-input
// processor, actual stream binding should be specified using corresponding
// API.
type VideoStreamInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated: Do not use.
	Streams []string `protobuf:"bytes,1,rep,name=streams,proto3" json:"streams,omitempty"`
	// Deprecated: Do not use.
	StreamsWithAnnotation []*StreamWithAnnotation `protobuf:"bytes,2,rep,name=streams_with_annotation,json=streamsWithAnnotation,proto3" json:"streams_with_annotation,omitempty"`
}

func (x *VideoStreamInputConfig) Reset() {
	*x = VideoStreamInputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoStreamInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStreamInputConfig) ProtoMessage() {}

func (x *VideoStreamInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStreamInputConfig.ProtoReflect.Descriptor instead.
func (*VideoStreamInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{53}
}

// Deprecated: Do not use.
func (x *VideoStreamInputConfig) GetStreams() []string {
	if x != nil {
		return x.Streams
	}
	return nil
}

// Deprecated: Do not use.
func (x *VideoStreamInputConfig) GetStreamsWithAnnotation() []*StreamWithAnnotation {
	if x != nil {
		return x.StreamsWithAnnotation
	}
	return nil
}

// Message describing AI-enabled Devices Input Config.
type AIEnabledDevicesInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AIEnabledDevicesInputConfig) Reset() {
	*x = AIEnabledDevicesInputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AIEnabledDevicesInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AIEnabledDevicesInputConfig) ProtoMessage() {}

func (x *AIEnabledDevicesInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AIEnabledDevicesInputConfig.ProtoReflect.Descriptor instead.
func (*AIEnabledDevicesInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{54}
}

// Message describing MediaWarehouseConfig.
type MediaWarehouseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the Media Warehouse corpus.
	// Format:
	// projects/${project_id}/locations/${location_id}/corpora/${corpus_id}
	Corpus string `protobuf:"bytes,1,opt,name=corpus,proto3" json:"corpus,omitempty"`
	// Deprecated.
	//
	// Deprecated: Do not use.
	Region string `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	// The duration for which all media assets, associated metadata, and search
	// documents can exist.
	Ttl *durationpb.Duration `protobuf:"bytes,3,opt,name=ttl,proto3" json:"ttl,omitempty"`
}

func (x *MediaWarehouseConfig) Reset() {
	*x = MediaWarehouseConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MediaWarehouseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MediaWarehouseConfig) ProtoMessage() {}

func (x *MediaWarehouseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MediaWarehouseConfig.ProtoReflect.Descriptor instead.
func (*MediaWarehouseConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{55}
}

func (x *MediaWarehouseConfig) GetCorpus() string {
	if x != nil {
		return x.Corpus
	}
	return ""
}

// Deprecated: Do not use.
func (x *MediaWarehouseConfig) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *MediaWarehouseConfig) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

// Message describing FaceBlurConfig.
type PersonBlurConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Person blur type.
	PersonBlurType PersonBlurConfig_PersonBlurType `protobuf:"varint,1,opt,name=person_blur_type,json=personBlurType,proto3,enum=google.cloud.visionai.v1alpha1.PersonBlurConfig_PersonBlurType" json:"person_blur_type,omitempty"`
	// Whether only blur faces other than the whole object in the processor.
	FacesOnly bool `protobuf:"varint,2,opt,name=faces_only,json=facesOnly,proto3" json:"faces_only,omitempty"`
}

func (x *PersonBlurConfig) Reset() {
	*x = PersonBlurConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonBlurConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonBlurConfig) ProtoMessage() {}

func (x *PersonBlurConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonBlurConfig.ProtoReflect.Descriptor instead.
func (*PersonBlurConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{56}
}

func (x *PersonBlurConfig) GetPersonBlurType() PersonBlurConfig_PersonBlurType {
	if x != nil {
		return x.PersonBlurType
	}
	return PersonBlurConfig_PERSON_BLUR_TYPE_UNSPECIFIED
}

func (x *PersonBlurConfig) GetFacesOnly() bool {
	if x != nil {
		return x.FacesOnly
	}
	return false
}

// Message describing OccupancyCountConfig.
type OccupancyCountConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to count the appearances of people, output counts have 'people' as
	// the key.
	EnablePeopleCounting bool `protobuf:"varint,1,opt,name=enable_people_counting,json=enablePeopleCounting,proto3" json:"enable_people_counting,omitempty"`
	// Whether to count the appearances of vehicles, output counts will have
	// 'vehicle' as the key.
	EnableVehicleCounting bool `protobuf:"varint,2,opt,name=enable_vehicle_counting,json=enableVehicleCounting,proto3" json:"enable_vehicle_counting,omitempty"`
	// Whether to track each invidual object's loitering time inside the scene or
	// specific zone.
	EnableDwellingTimeTracking bool `protobuf:"varint,3,opt,name=enable_dwelling_time_tracking,json=enableDwellingTimeTracking,proto3" json:"enable_dwelling_time_tracking,omitempty"`
}

func (x *OccupancyCountConfig) Reset() {
	*x = OccupancyCountConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountConfig) ProtoMessage() {}

func (x *OccupancyCountConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountConfig.ProtoReflect.Descriptor instead.
func (*OccupancyCountConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{57}
}

func (x *OccupancyCountConfig) GetEnablePeopleCounting() bool {
	if x != nil {
		return x.EnablePeopleCounting
	}
	return false
}

func (x *OccupancyCountConfig) GetEnableVehicleCounting() bool {
	if x != nil {
		return x.EnableVehicleCounting
	}
	return false
}

func (x *OccupancyCountConfig) GetEnableDwellingTimeTracking() bool {
	if x != nil {
		return x.EnableDwellingTimeTracking
	}
	return false
}

// Message describing PersonVehicleDetectionConfig.
type PersonVehicleDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// At least one of enable_people_counting and enable_vehicle_counting fields
	// must be set to true.
	// Whether to count the appearances of people, output counts have 'people' as
	// the key.
	EnablePeopleCounting bool `protobuf:"varint,1,opt,name=enable_people_counting,json=enablePeopleCounting,proto3" json:"enable_people_counting,omitempty"`
	// Whether to count the appearances of vehicles, output counts will have
	// 'vehicle' as the key.
	EnableVehicleCounting bool `protobuf:"varint,2,opt,name=enable_vehicle_counting,json=enableVehicleCounting,proto3" json:"enable_vehicle_counting,omitempty"`
}

func (x *PersonVehicleDetectionConfig) Reset() {
	*x = PersonVehicleDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonVehicleDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonVehicleDetectionConfig) ProtoMessage() {}

func (x *PersonVehicleDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonVehicleDetectionConfig.ProtoReflect.Descriptor instead.
func (*PersonVehicleDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{58}
}

func (x *PersonVehicleDetectionConfig) GetEnablePeopleCounting() bool {
	if x != nil {
		return x.EnablePeopleCounting
	}
	return false
}

func (x *PersonVehicleDetectionConfig) GetEnableVehicleCounting() bool {
	if x != nil {
		return x.EnableVehicleCounting
	}
	return false
}

// Message describing PersonalProtectiveEquipmentDetectionConfig.
type PersonalProtectiveEquipmentDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to enable face coverage detection.
	EnableFaceCoverageDetection bool `protobuf:"varint,1,opt,name=enable_face_coverage_detection,json=enableFaceCoverageDetection,proto3" json:"enable_face_coverage_detection,omitempty"`
	// Whether to enable head coverage detection.
	EnableHeadCoverageDetection bool `protobuf:"varint,2,opt,name=enable_head_coverage_detection,json=enableHeadCoverageDetection,proto3" json:"enable_head_coverage_detection,omitempty"`
	// Whether to enable hands coverage detection.
	EnableHandsCoverageDetection bool `protobuf:"varint,3,opt,name=enable_hands_coverage_detection,json=enableHandsCoverageDetection,proto3" json:"enable_hands_coverage_detection,omitempty"`
}

func (x *PersonalProtectiveEquipmentDetectionConfig) Reset() {
	*x = PersonalProtectiveEquipmentDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonalProtectiveEquipmentDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonalProtectiveEquipmentDetectionConfig) ProtoMessage() {}

func (x *PersonalProtectiveEquipmentDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonalProtectiveEquipmentDetectionConfig.ProtoReflect.Descriptor instead.
func (*PersonalProtectiveEquipmentDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{59}
}

func (x *PersonalProtectiveEquipmentDetectionConfig) GetEnableFaceCoverageDetection() bool {
	if x != nil {
		return x.EnableFaceCoverageDetection
	}
	return false
}

func (x *PersonalProtectiveEquipmentDetectionConfig) GetEnableHeadCoverageDetection() bool {
	if x != nil {
		return x.EnableHeadCoverageDetection
	}
	return false
}

func (x *PersonalProtectiveEquipmentDetectionConfig) GetEnableHandsCoverageDetection() bool {
	if x != nil {
		return x.EnableHandsCoverageDetection
	}
	return false
}

// Message of configurations for General Object Detection processor.
type GeneralObjectDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GeneralObjectDetectionConfig) Reset() {
	*x = GeneralObjectDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GeneralObjectDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneralObjectDetectionConfig) ProtoMessage() {}

func (x *GeneralObjectDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneralObjectDetectionConfig.ProtoReflect.Descriptor instead.
func (*GeneralObjectDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{60}
}

// Message of configurations for BigQuery processor.
type BigQueryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BigQuery table resource for Vision AI Platform to ingest annotations to.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Data Schema
	// By default, Vision AI Application will try to write annotations to the
	// target BigQuery table using the following schema:
	//
	// ingestion_time: TIMESTAMP, the ingestion time of the original data.
	//
	// application: STRING, name of the application which produces the annotation.
	//
	// instance: STRING, Id of the instance which produces the annotation.
	//
	// node: STRING, name of the application graph node which produces the
	// annotation.
	//
	// annotation: STRING or JSON, the actual annotation protobuf will be
	// converted to json string with bytes field as 64 encoded string. It can be
	// written to both String or Json type column.
	//
	// To forward annotation data to an existing BigQuery table, customer needs to
	// make sure the compatibility of the schema.
	// The map maps application node name to its corresponding cloud function
	// endpoint to transform the annotations directly to the
	// google.cloud.bigquery.storage.v1.AppendRowsRequest (only avro_rows or
	// proto_rows should be set). If configured, annotations produced by
	// corresponding application node will sent to the Cloud Function at first
	// before be forwarded to BigQuery.
	//
	// If the default table schema doesn't fit, customer is able to transform the
	// annotation output from Vision AI Application to arbitrary BigQuery table
	// schema with CloudFunction.
	// * The cloud function will receive AppPlatformCloudFunctionRequest where
	// the annotations field will be the json format of Vision AI annotation.
	// * The cloud function should return AppPlatformCloudFunctionResponse with
	// AppendRowsRequest stored in the annotations field.
	// * To drop the annotation, simply clear the annotations field in the
	// returned AppPlatformCloudFunctionResponse.
	CloudFunctionMapping map[string]string `protobuf:"bytes,2,rep,name=cloud_function_mapping,json=cloudFunctionMapping,proto3" json:"cloud_function_mapping,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If true, App Platform will create the BigQuery DataSet and the
	// BigQuery Table with default schema if the specified table doesn't exist.
	// This doesn't work if any cloud function customized schema is specified
	// since the system doesn't know your desired schema.
	// JSON column will be used in the default table created by App Platform.
	CreateDefaultTableIfNotExists bool `protobuf:"varint,3,opt,name=create_default_table_if_not_exists,json=createDefaultTableIfNotExists,proto3" json:"create_default_table_if_not_exists,omitempty"`
}

func (x *BigQueryConfig) Reset() {
	*x = BigQueryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryConfig) ProtoMessage() {}

func (x *BigQueryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryConfig.ProtoReflect.Descriptor instead.
func (*BigQueryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{61}
}

func (x *BigQueryConfig) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *BigQueryConfig) GetCloudFunctionMapping() map[string]string {
	if x != nil {
		return x.CloudFunctionMapping
	}
	return nil
}

func (x *BigQueryConfig) GetCreateDefaultTableIfNotExists() bool {
	if x != nil {
		return x.CreateDefaultTableIfNotExists
	}
	return false
}

// Message of configurations of Vertex AutoML Vision Processors.
type VertexAutoMLVisionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only entities with higher score than the threshold will be returned.
	// Value 0.0 means to return all the detected entities.
	ConfidenceThreshold float32 `protobuf:"fixed32,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// At most this many predictions will be returned per output frame.
	// Value 0 means to return all the detected entities.
	MaxPredictions int32 `protobuf:"varint,2,opt,name=max_predictions,json=maxPredictions,proto3" json:"max_predictions,omitempty"`
}

func (x *VertexAutoMLVisionConfig) Reset() {
	*x = VertexAutoMLVisionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VertexAutoMLVisionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexAutoMLVisionConfig) ProtoMessage() {}

func (x *VertexAutoMLVisionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexAutoMLVisionConfig.ProtoReflect.Descriptor instead.
func (*VertexAutoMLVisionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{62}
}

func (x *VertexAutoMLVisionConfig) GetConfidenceThreshold() float32 {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return 0
}

func (x *VertexAutoMLVisionConfig) GetMaxPredictions() int32 {
	if x != nil {
		return x.MaxPredictions
	}
	return 0
}

// Message describing VertexAutoMLVideoConfig.
type VertexAutoMLVideoConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only entities with higher score than the threshold will be returned.
	// Value 0.0 means returns all the detected entities.
	ConfidenceThreshold float32 `protobuf:"fixed32,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// Labels specified in this field won't be returned.
	BlockedLabels []string `protobuf:"bytes,2,rep,name=blocked_labels,json=blockedLabels,proto3" json:"blocked_labels,omitempty"`
	// At most this many predictions will be returned per output frame.
	// Value 0 means to return all the detected entities.
	MaxPredictions int32 `protobuf:"varint,3,opt,name=max_predictions,json=maxPredictions,proto3" json:"max_predictions,omitempty"`
	// Only Bounding Box whose size is larger than this limit will be returned.
	// Object Tracking only.
	// Value 0.0 means to return all the detected entities.
	BoundingBoxSizeLimit float32 `protobuf:"fixed32,4,opt,name=bounding_box_size_limit,json=boundingBoxSizeLimit,proto3" json:"bounding_box_size_limit,omitempty"`
}

func (x *VertexAutoMLVideoConfig) Reset() {
	*x = VertexAutoMLVideoConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VertexAutoMLVideoConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexAutoMLVideoConfig) ProtoMessage() {}

func (x *VertexAutoMLVideoConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexAutoMLVideoConfig.ProtoReflect.Descriptor instead.
func (*VertexAutoMLVideoConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{63}
}

func (x *VertexAutoMLVideoConfig) GetConfidenceThreshold() float32 {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return 0
}

func (x *VertexAutoMLVideoConfig) GetBlockedLabels() []string {
	if x != nil {
		return x.BlockedLabels
	}
	return nil
}

func (x *VertexAutoMLVideoConfig) GetMaxPredictions() int32 {
	if x != nil {
		return x.MaxPredictions
	}
	return 0
}

func (x *VertexAutoMLVideoConfig) GetBoundingBoxSizeLimit() float32 {
	if x != nil {
		return x.BoundingBoxSizeLimit
	}
	return 0
}

// Message describing VertexCustomConfig.
type VertexCustomConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The max prediction frame per second. This attribute sets how fast the
	// operator sends prediction requests to Vertex AI endpoint. Default value is
	// 0, which means there is no max prediction fps limit. The operator sends
	// prediction requests at input fps.
	MaxPredictionFps int32 `protobuf:"varint,1,opt,name=max_prediction_fps,json=maxPredictionFps,proto3" json:"max_prediction_fps,omitempty"`
	// A description of resources that are dedicated to the DeployedModel, and
	// that need a higher degree of manual configuration.
	DedicatedResources *DedicatedResources `protobuf:"bytes,2,opt,name=dedicated_resources,json=dedicatedResources,proto3" json:"dedicated_resources,omitempty"`
	// If not empty, the prediction result will be sent to the specified cloud
	// function for post processing.
	// * The cloud function will receive AppPlatformCloudFunctionRequest where
	// the annotations field will be the json format of proto PredictResponse.
	// * The cloud function should return AppPlatformCloudFunctionResponse with
	// PredictResponse stored in the annotations field.
	// * To drop the prediction output, simply clear the payload field in the
	// returned AppPlatformCloudFunctionResponse.
	PostProcessingCloudFunction string `protobuf:"bytes,3,opt,name=post_processing_cloud_function,json=postProcessingCloudFunction,proto3" json:"post_processing_cloud_function,omitempty"`
	// If true, the prediction request received by custom model will also contain
	// metadata with the following schema:
	//
	//	'appPlatformMetadata': {
	//	      'ingestionTime': DOUBLE; (UNIX timestamp)
	//	      'application': STRING;
	//	      'instanceId': STRING;
	//	      'node': STRING;
	//	      'processor': STRING;
	//	 }
	AttachApplicationMetadata bool `protobuf:"varint,4,opt,name=attach_application_metadata,json=attachApplicationMetadata,proto3" json:"attach_application_metadata,omitempty"`
}

func (x *VertexCustomConfig) Reset() {
	*x = VertexCustomConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VertexCustomConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexCustomConfig) ProtoMessage() {}

func (x *VertexCustomConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexCustomConfig.ProtoReflect.Descriptor instead.
func (*VertexCustomConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{64}
}

func (x *VertexCustomConfig) GetMaxPredictionFps() int32 {
	if x != nil {
		return x.MaxPredictionFps
	}
	return 0
}

func (x *VertexCustomConfig) GetDedicatedResources() *DedicatedResources {
	if x != nil {
		return x.DedicatedResources
	}
	return nil
}

func (x *VertexCustomConfig) GetPostProcessingCloudFunction() string {
	if x != nil {
		return x.PostProcessingCloudFunction
	}
	return ""
}

func (x *VertexCustomConfig) GetAttachApplicationMetadata() bool {
	if x != nil {
		return x.AttachApplicationMetadata
	}
	return false
}

// Specification of a single machine.
type MachineSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The type of the machine.
	//
	// See the [list of machine types supported for
	// prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types)
	//
	// See the [list of machine types supported for custom
	// training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types).
	//
	// For [DeployedModel][] this field is optional, and the default
	// value is `n1-standard-2`. For [BatchPredictionJob][] or as part of
	// [WorkerPoolSpec][] this field is required.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Immutable. The type of accelerator(s) that may be attached to the machine as per
	// [accelerator_count][google.cloud.visionai.v1alpha1.MachineSpec.accelerator_count].
	AcceleratorType AcceleratorType `protobuf:"varint,2,opt,name=accelerator_type,json=acceleratorType,proto3,enum=google.cloud.visionai.v1alpha1.AcceleratorType" json:"accelerator_type,omitempty"`
	// The number of accelerators to attach to the machine.
	AcceleratorCount int32 `protobuf:"varint,3,opt,name=accelerator_count,json=acceleratorCount,proto3" json:"accelerator_count,omitempty"`
}

func (x *MachineSpec) Reset() {
	*x = MachineSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MachineSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachineSpec) ProtoMessage() {}

func (x *MachineSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachineSpec.ProtoReflect.Descriptor instead.
func (*MachineSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{65}
}

func (x *MachineSpec) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *MachineSpec) GetAcceleratorType() AcceleratorType {
	if x != nil {
		return x.AcceleratorType
	}
	return AcceleratorType_ACCELERATOR_TYPE_UNSPECIFIED
}

func (x *MachineSpec) GetAcceleratorCount() int32 {
	if x != nil {
		return x.AcceleratorCount
	}
	return 0
}

// The metric specification that defines the target resource utilization
// (CPU utilization, accelerator's duty cycle, and so on) for calculating the
// desired replica count.
type AutoscalingMetricSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource metric name.
	// Supported metrics:
	//
	// * For Online Prediction:
	// * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle`
	// * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// The target resource utilization in percentage (1% - 100%) for the given
	// metric; once the real usage deviates from the target by a certain
	// percentage, the machine replicas change. The default value is 60
	// (representing 60%) if not provided.
	Target int32 `protobuf:"varint,2,opt,name=target,proto3" json:"target,omitempty"`
}

func (x *AutoscalingMetricSpec) Reset() {
	*x = AutoscalingMetricSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingMetricSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingMetricSpec) ProtoMessage() {}

func (x *AutoscalingMetricSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingMetricSpec.ProtoReflect.Descriptor instead.
func (*AutoscalingMetricSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{66}
}

func (x *AutoscalingMetricSpec) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

func (x *AutoscalingMetricSpec) GetTarget() int32 {
	if x != nil {
		return x.Target
	}
	return 0
}

// A description of resources that are dedicated to a DeployedModel, and
// that need a higher degree of manual configuration.
type DedicatedResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The specification of a single machine used by the prediction.
	MachineSpec *MachineSpec `protobuf:"bytes,1,opt,name=machine_spec,json=machineSpec,proto3" json:"machine_spec,omitempty"`
	// Required. Immutable. The minimum number of machine replicas this DeployedModel will be always
	// deployed on. This value must be greater than or equal to 1.
	//
	// If traffic against the DeployedModel increases, it may dynamically be
	// deployed onto more replicas, and as traffic decreases, some of these extra
	// replicas may be freed.
	MinReplicaCount int32 `protobuf:"varint,2,opt,name=min_replica_count,json=minReplicaCount,proto3" json:"min_replica_count,omitempty"`
	// Immutable. The maximum number of replicas this DeployedModel may be deployed on when
	// the traffic against it increases. If the requested value is too large,
	// the deployment will error, but if deployment succeeds then the ability
	// to scale the model to that many replicas is guaranteed (barring service
	// outages). If traffic against the DeployedModel increases beyond what its
	// replicas at maximum may handle, a portion of the traffic will be dropped.
	// If this value is not provided, will use [min_replica_count][google.cloud.visionai.v1alpha1.DedicatedResources.min_replica_count] as the
	// default value.
	//
	// The value of this field impacts the charge against Vertex CPU and GPU
	// quotas. Specifically, you will be charged for max_replica_count *
	// number of cores in the selected machine type) and (max_replica_count *
	// number of GPUs per replica in the selected machine type).
	MaxReplicaCount int32 `protobuf:"varint,3,opt,name=max_replica_count,json=maxReplicaCount,proto3" json:"max_replica_count,omitempty"`
	// Immutable. The metric specifications that overrides a resource
	// utilization metric (CPU utilization, accelerator's duty cycle, and so on)
	// target value (default to 60 if not set). At most one entry is allowed per
	// metric.
	//
	// If [machine_spec.accelerator_count][google.cloud.visionai.v1alpha1.MachineSpec.accelerator_count] is
	// above 0, the autoscaling will be based on both CPU utilization and
	// accelerator's duty cycle metrics and scale up when either metrics exceeds
	// its target value while scale down if both metrics are under their target
	// value. The default target value is 60 for both metrics.
	//
	// If [machine_spec.accelerator_count][google.cloud.visionai.v1alpha1.MachineSpec.accelerator_count] is
	// 0, the autoscaling will be based on CPU utilization metric only with
	// default target value 60 if not explicitly set.
	//
	// For example, in the case of Online Prediction, if you want to override
	// target CPU utilization to 80, you should set
	// [autoscaling_metric_specs.metric_name][google.cloud.visionai.v1alpha1.AutoscalingMetricSpec.metric_name]
	// to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
	// [autoscaling_metric_specs.target][google.cloud.visionai.v1alpha1.AutoscalingMetricSpec.target] to `80`.
	AutoscalingMetricSpecs []*AutoscalingMetricSpec `protobuf:"bytes,4,rep,name=autoscaling_metric_specs,json=autoscalingMetricSpecs,proto3" json:"autoscaling_metric_specs,omitempty"`
}

func (x *DedicatedResources) Reset() {
	*x = DedicatedResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DedicatedResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DedicatedResources) ProtoMessage() {}

func (x *DedicatedResources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DedicatedResources.ProtoReflect.Descriptor instead.
func (*DedicatedResources) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{67}
}

func (x *DedicatedResources) GetMachineSpec() *MachineSpec {
	if x != nil {
		return x.MachineSpec
	}
	return nil
}

func (x *DedicatedResources) GetMinReplicaCount() int32 {
	if x != nil {
		return x.MinReplicaCount
	}
	return 0
}

func (x *DedicatedResources) GetMaxReplicaCount() int32 {
	if x != nil {
		return x.MaxReplicaCount
	}
	return 0
}

func (x *DedicatedResources) GetAutoscalingMetricSpecs() []*AutoscalingMetricSpec {
	if x != nil {
		return x.AutoscalingMetricSpecs
	}
	return nil
}

// Message about target streamInput to remove.
type RemoveApplicationStreamInputRequest_TargetStreamInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Stream string `protobuf:"bytes,1,opt,name=stream,proto3" json:"stream,omitempty"`
}

func (x *RemoveApplicationStreamInputRequest_TargetStreamInput) Reset() {
	*x = RemoveApplicationStreamInputRequest_TargetStreamInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveApplicationStreamInputRequest_TargetStreamInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveApplicationStreamInputRequest_TargetStreamInput) ProtoMessage() {}

func (x *RemoveApplicationStreamInputRequest_TargetStreamInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveApplicationStreamInputRequest_TargetStreamInput.ProtoReflect.Descriptor instead.
func (*RemoveApplicationStreamInputRequest_TargetStreamInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{21, 0}
}

func (x *RemoveApplicationStreamInputRequest_TargetStreamInput) GetStream() string {
	if x != nil {
		return x.Stream
	}
	return ""
}

type UpdateApplicationInstancesRequest_UpdateApplicationInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// Draft resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If
	// the user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated.
	Instance *Instance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Required. The id of the instance.
	InstanceId string `protobuf:"bytes,3,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
}

func (x *UpdateApplicationInstancesRequest_UpdateApplicationInstance) Reset() {
	*x = UpdateApplicationInstancesRequest_UpdateApplicationInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateApplicationInstancesRequest_UpdateApplicationInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateApplicationInstancesRequest_UpdateApplicationInstance) ProtoMessage() {}

func (x *UpdateApplicationInstancesRequest_UpdateApplicationInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateApplicationInstancesRequest_UpdateApplicationInstance.ProtoReflect.Descriptor instead.
func (*UpdateApplicationInstancesRequest_UpdateApplicationInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{30, 0}
}

func (x *UpdateApplicationInstancesRequest_UpdateApplicationInstance) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateApplicationInstancesRequest_UpdateApplicationInstance) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *UpdateApplicationInstancesRequest_UpdateApplicationInstance) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

// Message storing the runtime information of the application.
type Application_ApplicationRuntimeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp when the engine be deployed
	DeployTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=deploy_time,json=deployTime,proto3" json:"deploy_time,omitempty"`
	// Globally created resources like warehouse dataschemas.
	GlobalOutputResources []*Application_ApplicationRuntimeInfo_GlobalOutputResource `protobuf:"bytes,3,rep,name=global_output_resources,json=globalOutputResources,proto3" json:"global_output_resources,omitempty"`
	// Monitoring-related configuration for this application.
	MonitoringConfig *Application_ApplicationRuntimeInfo_MonitoringConfig `protobuf:"bytes,4,opt,name=monitoring_config,json=monitoringConfig,proto3" json:"monitoring_config,omitempty"`
}

func (x *Application_ApplicationRuntimeInfo) Reset() {
	*x = Application_ApplicationRuntimeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Application_ApplicationRuntimeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Application_ApplicationRuntimeInfo) ProtoMessage() {}

func (x *Application_ApplicationRuntimeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Application_ApplicationRuntimeInfo.ProtoReflect.Descriptor instead.
func (*Application_ApplicationRuntimeInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{40, 0}
}

func (x *Application_ApplicationRuntimeInfo) GetDeployTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeployTime
	}
	return nil
}

func (x *Application_ApplicationRuntimeInfo) GetGlobalOutputResources() []*Application_ApplicationRuntimeInfo_GlobalOutputResource {
	if x != nil {
		return x.GlobalOutputResources
	}
	return nil
}

func (x *Application_ApplicationRuntimeInfo) GetMonitoringConfig() *Application_ApplicationRuntimeInfo_MonitoringConfig {
	if x != nil {
		return x.MonitoringConfig
	}
	return nil
}

// Message about output resources from application.
type Application_ApplicationRuntimeInfo_GlobalOutputResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of the outputted resources.
	OutputResource string `protobuf:"bytes,1,opt,name=output_resource,json=outputResource,proto3" json:"output_resource,omitempty"`
	// The name of graph node who produces the output resource name.
	// For example:
	// output_resource:
	// /projects/123/locations/us-central1/corpora/my-corpus/dataSchemas/my-schema
	// producer_node: occupancy-count
	ProducerNode string `protobuf:"bytes,2,opt,name=producer_node,json=producerNode,proto3" json:"producer_node,omitempty"`
	// The key of the output resource, it has to be unique within the same
	// producer node. One producer node can output several output resources,
	// the key can be used to match corresponding output resources.
	Key string `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *Application_ApplicationRuntimeInfo_GlobalOutputResource) Reset() {
	*x = Application_ApplicationRuntimeInfo_GlobalOutputResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Application_ApplicationRuntimeInfo_GlobalOutputResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Application_ApplicationRuntimeInfo_GlobalOutputResource) ProtoMessage() {}

func (x *Application_ApplicationRuntimeInfo_GlobalOutputResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Application_ApplicationRuntimeInfo_GlobalOutputResource.ProtoReflect.Descriptor instead.
func (*Application_ApplicationRuntimeInfo_GlobalOutputResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{40, 0, 0}
}

func (x *Application_ApplicationRuntimeInfo_GlobalOutputResource) GetOutputResource() string {
	if x != nil {
		return x.OutputResource
	}
	return ""
}

func (x *Application_ApplicationRuntimeInfo_GlobalOutputResource) GetProducerNode() string {
	if x != nil {
		return x.ProducerNode
	}
	return ""
}

func (x *Application_ApplicationRuntimeInfo_GlobalOutputResource) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Monitoring-related configuration for an application.
type Application_ApplicationRuntimeInfo_MonitoringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether this application has monitoring enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *Application_ApplicationRuntimeInfo_MonitoringConfig) Reset() {
	*x = Application_ApplicationRuntimeInfo_MonitoringConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Application_ApplicationRuntimeInfo_MonitoringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Application_ApplicationRuntimeInfo_MonitoringConfig) ProtoMessage() {}

func (x *Application_ApplicationRuntimeInfo_MonitoringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Application_ApplicationRuntimeInfo_MonitoringConfig.ProtoReflect.Descriptor instead.
func (*Application_ApplicationRuntimeInfo_MonitoringConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{40, 0, 1}
}

func (x *Application_ApplicationRuntimeInfo_MonitoringConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// message storing the config for event delivery
type ApplicationConfigs_EventDeliveryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The delivery channel for the event notification, only pub/sub topic is
	// supported now.
	// Example channel:
	// [//pubsub.googleapis.com/projects/visionai-testing-stable/topics/test-topic]
	Channel string `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel,omitempty"`
	// The expected delivery interval for the same event. The same event won't
	// be notified multiple times during this internal event that it is
	// happening multiple times during the period of time.The same event is
	// identified by <event_id, app_platform_metadata>.
	MinimalDeliveryInterval *durationpb.Duration `protobuf:"bytes,2,opt,name=minimal_delivery_interval,json=minimalDeliveryInterval,proto3" json:"minimal_delivery_interval,omitempty"`
}

func (x *ApplicationConfigs_EventDeliveryConfig) Reset() {
	*x = ApplicationConfigs_EventDeliveryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationConfigs_EventDeliveryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationConfigs_EventDeliveryConfig) ProtoMessage() {}

func (x *ApplicationConfigs_EventDeliveryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationConfigs_EventDeliveryConfig.ProtoReflect.Descriptor instead.
func (*ApplicationConfigs_EventDeliveryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{41, 0}
}

func (x *ApplicationConfigs_EventDeliveryConfig) GetChannel() string {
	if x != nil {
		return x.Channel
	}
	return ""
}

func (x *ApplicationConfigs_EventDeliveryConfig) GetMinimalDeliveryInterval() *durationpb.Duration {
	if x != nil {
		return x.MinimalDeliveryInterval
	}
	return nil
}

// Message describing one edge pointing into a node.
type Node_InputEdge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the parent node.
	ParentNode string `protobuf:"bytes,1,opt,name=parent_node,json=parentNode,proto3" json:"parent_node,omitempty"`
	// The connected output artifact of the parent node.
	// It can be omitted if target processor only has 1 output artifact.
	ParentOutputChannel string `protobuf:"bytes,2,opt,name=parent_output_channel,json=parentOutputChannel,proto3" json:"parent_output_channel,omitempty"`
	// The connected input channel of the current node's processor.
	// It can be omitted if target processor only has 1 input channel.
	ConnectedInputChannel string `protobuf:"bytes,3,opt,name=connected_input_channel,json=connectedInputChannel,proto3" json:"connected_input_channel,omitempty"`
}

func (x *Node_InputEdge) Reset() {
	*x = Node_InputEdge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Node_InputEdge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Node_InputEdge) ProtoMessage() {}

func (x *Node_InputEdge) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Node_InputEdge.ProtoReflect.Descriptor instead.
func (*Node_InputEdge) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{42, 0}
}

func (x *Node_InputEdge) GetParentNode() string {
	if x != nil {
		return x.ParentNode
	}
	return ""
}

func (x *Node_InputEdge) GetParentOutputChannel() string {
	if x != nil {
		return x.ParentOutputChannel
	}
	return ""
}

func (x *Node_InputEdge) GetConnectedInputChannel() string {
	if x != nil {
		return x.ConnectedInputChannel
	}
	return ""
}

// Message of input resource used in one application instance.
type Instance_InputResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specify the input to the application instance.
	//
	// Types that are assignable to InputResourceInformation:
	//
	//	*Instance_InputResource_InputResource
	//	*Instance_InputResource_AnnotatedStream
	InputResourceInformation isInstance_InputResource_InputResourceInformation `protobuf_oneof:"input_resource_information"`
	// The name of graph node who receives the input resource.
	// For example:
	// input_resource:
	// visionai.googleapis.com/v1/projects/123/locations/us-central1/clusters/456/streams/input-stream-a
	// consumer_node: stream-input
	ConsumerNode string `protobuf:"bytes,2,opt,name=consumer_node,json=consumerNode,proto3" json:"consumer_node,omitempty"`
	// The specific input resource binding which will consume the current Input
	// Resource, can be ignored is there is only 1 input binding.
	InputResourceBinding string `protobuf:"bytes,3,opt,name=input_resource_binding,json=inputResourceBinding,proto3" json:"input_resource_binding,omitempty"`
	// Contains resource annotations.
	Annotations *ResourceAnnotations `protobuf:"bytes,5,opt,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *Instance_InputResource) Reset() {
	*x = Instance_InputResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance_InputResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_InputResource) ProtoMessage() {}

func (x *Instance_InputResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_InputResource.ProtoReflect.Descriptor instead.
func (*Instance_InputResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{44, 0}
}

func (m *Instance_InputResource) GetInputResourceInformation() isInstance_InputResource_InputResourceInformation {
	if m != nil {
		return m.InputResourceInformation
	}
	return nil
}

func (x *Instance_InputResource) GetInputResource() string {
	if x, ok := x.GetInputResourceInformation().(*Instance_InputResource_InputResource); ok {
		return x.InputResource
	}
	return ""
}

// Deprecated: Do not use.
func (x *Instance_InputResource) GetAnnotatedStream() *StreamWithAnnotation {
	if x, ok := x.GetInputResourceInformation().(*Instance_InputResource_AnnotatedStream); ok {
		return x.AnnotatedStream
	}
	return nil
}

func (x *Instance_InputResource) GetConsumerNode() string {
	if x != nil {
		return x.ConsumerNode
	}
	return ""
}

func (x *Instance_InputResource) GetInputResourceBinding() string {
	if x != nil {
		return x.InputResourceBinding
	}
	return ""
}

func (x *Instance_InputResource) GetAnnotations() *ResourceAnnotations {
	if x != nil {
		return x.Annotations
	}
	return nil
}

type isInstance_InputResource_InputResourceInformation interface {
	isInstance_InputResource_InputResourceInformation()
}

type Instance_InputResource_InputResource struct {
	// The direct input resource name.
	InputResource string `protobuf:"bytes,1,opt,name=input_resource,json=inputResource,proto3,oneof"`
}

type Instance_InputResource_AnnotatedStream struct {
	// If the input resource is VisionAI Stream, the associated annotations
	// can be specified using annotated_stream instead.
	//
	// Deprecated: Do not use.
	AnnotatedStream *StreamWithAnnotation `protobuf:"bytes,4,opt,name=annotated_stream,json=annotatedStream,proto3,oneof"`
}

func (*Instance_InputResource_InputResource) isInstance_InputResource_InputResourceInformation() {}

func (*Instance_InputResource_AnnotatedStream) isInstance_InputResource_InputResourceInformation() {}

// Message of output resource used in one application instance.
type Instance_OutputResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output resource name for the current application instance.
	OutputResource string `protobuf:"bytes,1,opt,name=output_resource,json=outputResource,proto3" json:"output_resource,omitempty"`
	// The name of graph node who produces the output resource name.
	// For example:
	// output_resource:
	// /projects/123/locations/us-central1/clusters/456/streams/output-application-789-stream-a-occupancy-counting
	// producer_node: occupancy-counting
	ProducerNode string `protobuf:"bytes,2,opt,name=producer_node,json=producerNode,proto3" json:"producer_node,omitempty"`
	// The specific output resource binding which produces the current
	// OutputResource.
	OutputResourceBinding string `protobuf:"bytes,4,opt,name=output_resource_binding,json=outputResourceBinding,proto3" json:"output_resource_binding,omitempty"`
	// Output only. Whether the output resource is temporary which means the resource is
	// generated during the deployment of the application.
	// Temporary resource will be deleted during the undeployment of the
	// application.
	IsTemporary bool `protobuf:"varint,3,opt,name=is_temporary,json=isTemporary,proto3" json:"is_temporary,omitempty"`
	// Output only. Whether the output resource is created automatically by the Vision AI App
	// Platform.
	Autogen bool `protobuf:"varint,5,opt,name=autogen,proto3" json:"autogen,omitempty"`
}

func (x *Instance_OutputResource) Reset() {
	*x = Instance_OutputResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance_OutputResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_OutputResource) ProtoMessage() {}

func (x *Instance_OutputResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_OutputResource.ProtoReflect.Descriptor instead.
func (*Instance_OutputResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{44, 1}
}

func (x *Instance_OutputResource) GetOutputResource() string {
	if x != nil {
		return x.OutputResource
	}
	return ""
}

func (x *Instance_OutputResource) GetProducerNode() string {
	if x != nil {
		return x.ProducerNode
	}
	return ""
}

func (x *Instance_OutputResource) GetOutputResourceBinding() string {
	if x != nil {
		return x.OutputResourceBinding
	}
	return ""
}

func (x *Instance_OutputResource) GetIsTemporary() bool {
	if x != nil {
		return x.IsTemporary
	}
	return false
}

func (x *Instance_OutputResource) GetAutogen() bool {
	if x != nil {
		return x.Autogen
	}
	return false
}

// Message for input channel specification.
type ProcessorIOSpec_GraphInputChannelSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the current input channel.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The data types of the current input channel.
	// When this field has more than 1 value, it means this input channel can be
	// connected to either of these different data types.
	DataType ProcessorIOSpec_DataType `protobuf:"varint,2,opt,name=data_type,json=dataType,proto3,enum=google.cloud.visionai.v1alpha1.ProcessorIOSpec_DataType" json:"data_type,omitempty"`
	// If specified, only those detailed data types can be connected to the
	// processor. For example, jpeg stream for MEDIA, or PredictionResult proto
	// for PROTO type. If unspecified, then any proto is accepted.
	AcceptedDataTypeUris []string `protobuf:"bytes,5,rep,name=accepted_data_type_uris,json=acceptedDataTypeUris,proto3" json:"accepted_data_type_uris,omitempty"`
	// Whether the current input channel is required by the processor.
	// For example, for a processor with required video input and optional audio
	// input, if video input is missing, the application will be rejected while
	// the audio input can be missing as long as the video input exists.
	Required bool `protobuf:"varint,3,opt,name=required,proto3" json:"required,omitempty"`
	// How many input edges can be connected to this input channel. 0 means
	// unlimited.
	MaxConnectionAllowed int64 `protobuf:"varint,4,opt,name=max_connection_allowed,json=maxConnectionAllowed,proto3" json:"max_connection_allowed,omitempty"`
}

func (x *ProcessorIOSpec_GraphInputChannelSpec) Reset() {
	*x = ProcessorIOSpec_GraphInputChannelSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessorIOSpec_GraphInputChannelSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorIOSpec_GraphInputChannelSpec) ProtoMessage() {}

func (x *ProcessorIOSpec_GraphInputChannelSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorIOSpec_GraphInputChannelSpec.ProtoReflect.Descriptor instead.
func (*ProcessorIOSpec_GraphInputChannelSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{47, 0}
}

func (x *ProcessorIOSpec_GraphInputChannelSpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProcessorIOSpec_GraphInputChannelSpec) GetDataType() ProcessorIOSpec_DataType {
	if x != nil {
		return x.DataType
	}
	return ProcessorIOSpec_DATA_TYPE_UNSPECIFIED
}

func (x *ProcessorIOSpec_GraphInputChannelSpec) GetAcceptedDataTypeUris() []string {
	if x != nil {
		return x.AcceptedDataTypeUris
	}
	return nil
}

func (x *ProcessorIOSpec_GraphInputChannelSpec) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *ProcessorIOSpec_GraphInputChannelSpec) GetMaxConnectionAllowed() int64 {
	if x != nil {
		return x.MaxConnectionAllowed
	}
	return 0
}

// Message for output channel specification.
type ProcessorIOSpec_GraphOutputChannelSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the current output channel.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The data type of the current output channel.
	DataType    ProcessorIOSpec_DataType `protobuf:"varint,2,opt,name=data_type,json=dataType,proto3,enum=google.cloud.visionai.v1alpha1.ProcessorIOSpec_DataType" json:"data_type,omitempty"`
	DataTypeUri string                   `protobuf:"bytes,3,opt,name=data_type_uri,json=dataTypeUri,proto3" json:"data_type_uri,omitempty"`
}

func (x *ProcessorIOSpec_GraphOutputChannelSpec) Reset() {
	*x = ProcessorIOSpec_GraphOutputChannelSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessorIOSpec_GraphOutputChannelSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorIOSpec_GraphOutputChannelSpec) ProtoMessage() {}

func (x *ProcessorIOSpec_GraphOutputChannelSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorIOSpec_GraphOutputChannelSpec.ProtoReflect.Descriptor instead.
func (*ProcessorIOSpec_GraphOutputChannelSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{47, 1}
}

func (x *ProcessorIOSpec_GraphOutputChannelSpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProcessorIOSpec_GraphOutputChannelSpec) GetDataType() ProcessorIOSpec_DataType {
	if x != nil {
		return x.DataType
	}
	return ProcessorIOSpec_DATA_TYPE_UNSPECIFIED
}

func (x *ProcessorIOSpec_GraphOutputChannelSpec) GetDataTypeUri() string {
	if x != nil {
		return x.DataTypeUri
	}
	return ""
}

// Message for instance resource channel specification.
// External resources are virtual nodes which are not expressed in the
// application graph. Each processor expresses its out-graph spec, so customer
// is able to override the external source or destinations to the
type ProcessorIOSpec_InstanceResourceInputBindingSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ResourceType:
	//
	//	*ProcessorIOSpec_InstanceResourceInputBindingSpec_ConfigTypeUri
	//	*ProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceTypeUri
	ResourceType isProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceType `protobuf_oneof:"resource_type"`
	// Name of the input binding, unique within the processor.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ProcessorIOSpec_InstanceResourceInputBindingSpec) Reset() {
	*x = ProcessorIOSpec_InstanceResourceInputBindingSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessorIOSpec_InstanceResourceInputBindingSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorIOSpec_InstanceResourceInputBindingSpec) ProtoMessage() {}

func (x *ProcessorIOSpec_InstanceResourceInputBindingSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorIOSpec_InstanceResourceInputBindingSpec.ProtoReflect.Descriptor instead.
func (*ProcessorIOSpec_InstanceResourceInputBindingSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{47, 2}
}

func (m *ProcessorIOSpec_InstanceResourceInputBindingSpec) GetResourceType() isProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceType {
	if m != nil {
		return m.ResourceType
	}
	return nil
}

func (x *ProcessorIOSpec_InstanceResourceInputBindingSpec) GetConfigTypeUri() string {
	if x, ok := x.GetResourceType().(*ProcessorIOSpec_InstanceResourceInputBindingSpec_ConfigTypeUri); ok {
		return x.ConfigTypeUri
	}
	return ""
}

func (x *ProcessorIOSpec_InstanceResourceInputBindingSpec) GetResourceTypeUri() string {
	if x, ok := x.GetResourceType().(*ProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceTypeUri); ok {
		return x.ResourceTypeUri
	}
	return ""
}

func (x *ProcessorIOSpec_InstanceResourceInputBindingSpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceType interface {
	isProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceType()
}

type ProcessorIOSpec_InstanceResourceInputBindingSpec_ConfigTypeUri struct {
	// The configuration proto that includes the Googleapis resources. I.e.
	// type.googleapis.com/google.cloud.vision.v1.StreamWithAnnotation
	ConfigTypeUri string `protobuf:"bytes,2,opt,name=config_type_uri,json=configTypeUri,proto3,oneof"`
}

type ProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceTypeUri struct {
	// The direct type url of Googleapis resource. i.e.
	// type.googleapis.com/google.cloud.vision.v1.Asset
	ResourceTypeUri string `protobuf:"bytes,3,opt,name=resource_type_uri,json=resourceTypeUri,proto3,oneof"`
}

func (*ProcessorIOSpec_InstanceResourceInputBindingSpec_ConfigTypeUri) isProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceType() {
}

func (*ProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceTypeUri) isProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceType() {
}

type ProcessorIOSpec_InstanceResourceOutputBindingSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the output binding, unique within the processor.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource type uri of the acceptable output resource.
	ResourceTypeUri string `protobuf:"bytes,2,opt,name=resource_type_uri,json=resourceTypeUri,proto3" json:"resource_type_uri,omitempty"`
	// Whether the output resource needs to be explicitly set in the instance.
	// If it is false, the processor will automatically generate it if required.
	Explicit bool `protobuf:"varint,3,opt,name=explicit,proto3" json:"explicit,omitempty"`
}

func (x *ProcessorIOSpec_InstanceResourceOutputBindingSpec) Reset() {
	*x = ProcessorIOSpec_InstanceResourceOutputBindingSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessorIOSpec_InstanceResourceOutputBindingSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorIOSpec_InstanceResourceOutputBindingSpec) ProtoMessage() {}

func (x *ProcessorIOSpec_InstanceResourceOutputBindingSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorIOSpec_InstanceResourceOutputBindingSpec.ProtoReflect.Descriptor instead.
func (*ProcessorIOSpec_InstanceResourceOutputBindingSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{47, 3}
}

func (x *ProcessorIOSpec_InstanceResourceOutputBindingSpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProcessorIOSpec_InstanceResourceOutputBindingSpec) GetResourceTypeUri() string {
	if x != nil {
		return x.ResourceTypeUri
	}
	return ""
}

func (x *ProcessorIOSpec_InstanceResourceOutputBindingSpec) GetExplicit() bool {
	if x != nil {
		return x.Explicit
	}
	return false
}

// The schema is defined as an OpenAPI 3.0.2 [Schema
// Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
type CustomProcessorSourceInfo_ModelSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Storage location to a YAML file that defines the format of a single
	// instance used in prediction and explanation requests.
	InstancesSchema *GcsSource `protobuf:"bytes,1,opt,name=instances_schema,json=instancesSchema,proto3" json:"instances_schema,omitempty"`
	// Cloud Storage location to a YAML file that defines the prediction and
	// explanation parameters.
	ParametersSchema *GcsSource `protobuf:"bytes,2,opt,name=parameters_schema,json=parametersSchema,proto3" json:"parameters_schema,omitempty"`
	// Cloud Storage location to a YAML file that defines the format of a single
	// prediction or explanation.
	PredictionsSchema *GcsSource `protobuf:"bytes,3,opt,name=predictions_schema,json=predictionsSchema,proto3" json:"predictions_schema,omitempty"`
}

func (x *CustomProcessorSourceInfo_ModelSchema) Reset() {
	*x = CustomProcessorSourceInfo_ModelSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomProcessorSourceInfo_ModelSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomProcessorSourceInfo_ModelSchema) ProtoMessage() {}

func (x *CustomProcessorSourceInfo_ModelSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomProcessorSourceInfo_ModelSchema.ProtoReflect.Descriptor instead.
func (*CustomProcessorSourceInfo_ModelSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{48, 0}
}

func (x *CustomProcessorSourceInfo_ModelSchema) GetInstancesSchema() *GcsSource {
	if x != nil {
		return x.InstancesSchema
	}
	return nil
}

func (x *CustomProcessorSourceInfo_ModelSchema) GetParametersSchema() *GcsSource {
	if x != nil {
		return x.ParametersSchema
	}
	return nil
}

func (x *CustomProcessorSourceInfo_ModelSchema) GetPredictionsSchema() *GcsSource {
	if x != nil {
		return x.PredictionsSchema
	}
	return nil
}

// Message describing annotations specific to application node.
type StreamWithAnnotation_NodeAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The node name of the application graph.
	Node string `protobuf:"bytes,1,opt,name=node,proto3" json:"node,omitempty"`
	// The node specific stream annotations.
	Annotations []*StreamAnnotation `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *StreamWithAnnotation_NodeAnnotation) Reset() {
	*x = StreamWithAnnotation_NodeAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamWithAnnotation_NodeAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamWithAnnotation_NodeAnnotation) ProtoMessage() {}

func (x *StreamWithAnnotation_NodeAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamWithAnnotation_NodeAnnotation.ProtoReflect.Descriptor instead.
func (*StreamWithAnnotation_NodeAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP(), []int{50, 0}
}

func (x *StreamWithAnnotation_NodeAnnotation) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *StreamWithAnnotation_NodeAnnotation) GetAnnotations() []*StreamAnnotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

var File_google_cloud_visionai_v1alpha1_platform_proto protoreflect.FileDescriptor

var file_google_cloud_visionai_v1alpha1_platform_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x24, 0x0a, 0x22, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x24, 0x0a, 0x22, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x24, 0x0a, 0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf7, 0x01, 0x0a, 0x21,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x6d, 0x0a, 0x15, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xd5, 0x01, 0x0a, 0x21, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x25, 0x0a, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0c,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x1b, 0x0a,
	0x19, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1d, 0x0a, 0x1b, 0x55, 0x6e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0x0a, 0x24, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x23, 0x0a, 0x21, 0x41, 0x64, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0x0a, 0x24, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xcd,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x25, 0x12, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xb5,
	0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x58, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x83, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x52,
	0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xd4, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x9a, 0x01,
	0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xd6, 0x01, 0x0a, 0x18, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x30, 0x0a, 0x11, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x22, 0x81, 0x01, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x84, 0x01, 0x0a, 0x16, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x12, 0x6a, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x77, 0x69, 0x74,
	0x68, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x57, 0x69, 0x74, 0x68, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x57, 0x69, 0x74, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xfb,
	0x01, 0x0a, 0x20, 0x41, 0x64, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x72, 0x0a, 0x19, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52,
	0x17, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xa3, 0x02, 0x0a,
	0x23, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x72, 0x0a, 0x19, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x52, 0x17, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a,
	0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x22, 0xe6, 0x02, 0x0a, 0x23, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x14,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x1a, 0x50, 0x0a, 0x11, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x3b,
	0x0a, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23,
	0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0xc7, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa9, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x46, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x52, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x72,
	0x61, 0x66, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x72, 0x61,
	0x66, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x9d, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x72, 0x61, 0x66, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3d, 0x0a, 0x06, 0x64, 0x72, 0x61, 0x66, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x06, 0x64, 0x72, 0x61, 0x66, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x4c, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x72, 0x61, 0x66,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a,
	0x08, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x72, 0x61, 0x66, 0x74, 0x49, 0x64, 0x12, 0x40, 0x0a,
	0x05, 0x64, 0x72, 0x61, 0x66, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x72,
	0x61, 0x66, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x64, 0x72, 0x61, 0x66, 0x74, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xe1, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x72,
	0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x40, 0x0a, 0x05,
	0x64, 0x72, 0x61, 0x66, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x72, 0x61,
	0x66, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x64, 0x72, 0x61, 0x66, 0x74, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0x91, 0x04, 0x0a, 0x21, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x90,
	0x01, 0x0a, 0x15, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x14, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x1a, 0xce, 0x01, 0x0a, 0x19, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x49, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x22, 0x73, 0x0a, 0x12, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xc9, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x12, 0x21, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xad, 0x01, 0x0a,
	0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x62, 0x0a, 0x1d,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x22, 0x6b, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x22, 0x54, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xf5, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x4c, 0x0a, 0x09, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xcc, 0x01, 0x0a, 0x16,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4c, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x7b, 0x0a, 0x16, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc8, 0x0b, 0x0a, 0x0b, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x13, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x12, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12,
	0x6a, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4c, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x90, 0x04, 0x0a, 0x16, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3b, 0x0a, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x8f, 0x01, 0x0a, 0x17, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x15, 0x67, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x11, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x76, 0x0a, 0x14, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x27,
	0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x1a, 0x2c,
	0x0a, 0x10, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa7, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x05,
	0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x49, 0x58, 0x49, 0x4e, 0x47, 0x10,
	0x0a, 0x3a, 0x6f, 0xea, 0x41, 0x6c, 0x0a, 0x23, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x52,
	0x01, 0x01, 0x22, 0xd5, 0x02, 0x0a, 0x12, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3a, 0x0a, 0x05, 0x6e, 0x6f, 0x64,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05,
	0x6e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x7a, 0x0a, 0x15, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x1a, 0x86, 0x01, 0x0a, 0x13, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x12, 0x55, 0x0a, 0x19, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x5f, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x17, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x22, 0x80, 0x04, 0x0a, 0x04, 0x4e,
	0x6f, 0x64, 0x65, 0x12, 0x4f, 0x0a, 0x24, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x6c,
	0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x00, 0x52, 0x1f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x6c, 0x6c, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x54, 0x6f, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x50, 0x0a, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x12, 0x48, 0x0a, 0x07, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x45, 0x64, 0x67,
	0x65, 0x52, 0x07, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x98, 0x01, 0x0a, 0x09, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x45, 0x64, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x36, 0x0a,
	0x17, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x16, 0x0a, 0x14, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd9, 0x04,
	0x0a, 0x05, 0x44, 0x72, 0x61, 0x66, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x49, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x44, 0x72, 0x61, 0x66, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6e, 0x0a, 0x19, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x17, 0x64, 0x72, 0x61,
	0x66, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x78, 0xea, 0x41, 0x75, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x72,
	0x61, 0x66, 0x74, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x73, 0x2f, 0x7b,
	0x64, 0x72, 0x61, 0x66, 0x74, 0x7d, 0x52, 0x01, 0x01, 0x22, 0x85, 0x0c, 0x0a, 0x08, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x0f, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0e, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x62, 0x0a, 0x10,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0xef, 0x02, 0x0a, 0x0d, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0e, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0d, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x65, 0x0a, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x57, 0x69, 0x74, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x65, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x34, 0x0a,
	0x16, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x55, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1c, 0x0a, 0x1a, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xdd, 0x01, 0x0a, 0x0e, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x72, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x62, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x26, 0x0a, 0x0c, 0x69, 0x73, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x69, 0x73,
	0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x75, 0x74,
	0x6f, 0x67, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x61, 0x75, 0x74, 0x6f, 0x67, 0x65, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xa7, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b,
	0x55, 0x4e, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0b, 0x0a,
	0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x08, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x09, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x49, 0x58, 0x49, 0x4e, 0x47, 0x10, 0x0a, 0x3a, 0x81, 0x01,
	0xea, 0x41, 0x7e, 0x0a, 0x20, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x57, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x52, 0x01,
	0x01, 0x22, 0x86, 0x01, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x49, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xf4, 0x0a, 0x0a, 0x09, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x0e, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x48,
	0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x7a, 0x0a, 0x1c, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x53, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x60, 0x0a, 0x11, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x69, 0x6f, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x49,
	0x4f, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x49, 0x6f, 0x53, 0x70, 0x65, 0x63, 0x12, 0x38, 0x0a, 0x15, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x75, 0x72, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x14, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x75, 0x72, 0x6c, 0x12, 0x77, 0x0a, 0x1a, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x38,
	0x0a, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x5f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x16, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x50, 0x6f, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x5a, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x4f,
	0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x45, 0x54, 0x52, 0x41, 0x49, 0x4e,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x02,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x10, 0x03, 0x22,
	0x65, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x4f, 0x52, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x69, 0xea, 0x41, 0x66, 0x0a, 0x21, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x3e,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x7d, 0x52, 0x01,
	0x01, 0x22, 0xff, 0x0a, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x49,
	0x4f, 0x53, 0x70, 0x65, 0x63, 0x12, 0x80, 0x01, 0x0a, 0x19, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x49, 0x4f, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x47, 0x72, 0x61, 0x70, 0x68,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x16, 0x67, 0x72, 0x61, 0x70, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x1a, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x49, 0x4f, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x47,
	0x72, 0x61, 0x70, 0x68, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x53, 0x70, 0x65, 0x63, 0x52, 0x17, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0xa2,
	0x01, 0x0a, 0x25, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x49, 0x4f, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x21, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70,
	0x65, 0x63, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x26, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x49,
	0x4f, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x52, 0x22, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x73, 0x1a, 0x8b, 0x02, 0x0a, 0x15,
	0x47, 0x72, 0x61, 0x70, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x09, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x49, 0x4f, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x35, 0x0a, 0x17, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x14, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x54,
	0x79, 0x70, 0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x12, 0x34, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x14, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x1a, 0xa7, 0x01, 0x0a, 0x16, 0x47, 0x72,
	0x61, 0x70, 0x68, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x49, 0x4f, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x22, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65,
	0x55, 0x72, 0x69, 0x1a, 0x9f, 0x01, 0x0a, 0x20, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x28, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x79, 0x70, 0x65, 0x55,
	0x72, 0x69, 0x12, 0x2c, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x55, 0x72, 0x69,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x7f, 0x0a, 0x21, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a,
	0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x55, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78,
	0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x65, 0x78,
	0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x22, 0x3b, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x52, 0x4f, 0x54,
	0x4f, 0x10, 0x02, 0x22, 0xcb, 0x06, 0x0a, 0x19, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x23, 0x0a, 0x0c, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x76, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x65, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x7b, 0x0a,
	0x0f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x61, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x68, 0x0a, 0x0c, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x1a, 0x95, 0x02, 0x0a, 0x0b, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x12, 0x54, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x56, 0x0a, 0x11, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x10, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x12, 0x58, 0x0a, 0x12, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x11, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0x41, 0x0a, 0x13,
	0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x4f, 0x0a, 0x0a, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a,
	0x17, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x56, 0x45,
	0x52, 0x54, 0x45, 0x58, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x4c, 0x10, 0x01, 0x12, 0x11, 0x0a,
	0x0d, 0x56, 0x45, 0x52, 0x54, 0x45, 0x58, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x02,
	0x42, 0x0f, 0x0a, 0x0d, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x22, 0xd8, 0x0b, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x19, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x16, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x83, 0x01, 0x0a, 0x1f, 0x61,
	0x69, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x49, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x1b, 0x61, 0x69, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x6c, 0x0a, 0x16, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f,
	0x75, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x57, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x14, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x57,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60,
	0x0a, 0x12, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x5f, 0x62, 0x6c, 0x75, 0x72, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73,
	0x6f, 0x6e, 0x42, 0x6c, 0x75, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10,
	0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x42, 0x6c, 0x75, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x6c, 0x0a, 0x16, 0x6f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x14, 0x6f, 0x63, 0x63, 0x75, 0x70, 0x61,
	0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x85,
	0x01, 0x0a, 0x1f, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e,
	0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x1c, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e,
	0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x0a, 0x1b, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x4c, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x18, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x76, 0x0a, 0x1a, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x6c, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x75, 0x74,
	0x6f, 0x4d, 0x4c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00,
	0x52, 0x17, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x66, 0x0a, 0x14, 0x76, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x12, 0x76,
	0x65, 0x72, 0x74, 0x65, 0x78, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x85, 0x01, 0x0a, 0x1f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x1c, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x10, 0x62, 0x69, 0x67,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xb0, 0x01, 0x0a, 0x2e, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e,
	0x61, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x65, 0x71,
	0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x45, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x2a, 0x70, 0x65,
	0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x45, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x12, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa8, 0x03, 0x0a,
	0x14, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x57, 0x69, 0x74, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x69, 0x0a, 0x17, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6e, 0x0a,
	0x10, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x57,
	0x69, 0x74, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x6f,
	0x64, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x6e, 0x6f,
	0x64, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x78, 0x0a,
	0x0e, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x6f, 0x64, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x83, 0x01, 0x0a, 0x19, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe6, 0x01,
	0x0a, 0x13, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x69, 0x0a, 0x17, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x64, 0x0a, 0x10, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa8, 0x01, 0x0a, 0x16, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1c, 0x0a, 0x07, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12,
	0x70, 0x0a, 0x17, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x57, 0x69, 0x74, 0x68, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x15, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x57, 0x69, 0x74, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x1d, 0x0a, 0x1b, 0x41, 0x49, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x77, 0x0a, 0x14, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x57, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x12, 0x1a, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x03,
	0x74, 0x74, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x22, 0xf6, 0x01, 0x0a, 0x10, 0x50, 0x65,
	0x72, 0x73, 0x6f, 0x6e, 0x42, 0x6c, 0x75, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x69,
	0x0a, 0x10, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x5f, 0x62, 0x6c, 0x75, 0x72, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e,
	0x42, 0x6c, 0x75, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f,
	0x6e, 0x42, 0x6c, 0x75, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x70, 0x65, 0x72, 0x73, 0x6f,
	0x6e, 0x42, 0x6c, 0x75, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x61, 0x63,
	0x65, 0x73, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x66,
	0x61, 0x63, 0x65, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x58, 0x0a, 0x0e, 0x50, 0x65, 0x72, 0x73,
	0x6f, 0x6e, 0x42, 0x6c, 0x75, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x45,
	0x52, 0x53, 0x4f, 0x4e, 0x5f, 0x42, 0x4c, 0x55, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f,
	0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x4f, 0x43, 0x43, 0x55, 0x4c, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x10,
	0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x4c, 0x55, 0x52, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52,
	0x10, 0x02, 0x22, 0xc7, 0x01, 0x0a, 0x14, 0x4f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x16, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x50, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e,
	0x67, 0x12, 0x36, 0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x65, 0x68, 0x69,
	0x63, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x41, 0x0a, 0x1d, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x64, 0x77, 0x65, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x77, 0x65, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x54, 0x69, 0x6d, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x22, 0x8c, 0x01, 0x0a,
	0x1c, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a,
	0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x69, 0x6e, 0x67, 0x12, 0x36, 0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x65,
	0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x65, 0x68, 0x69,
	0x63, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x22, 0xfd, 0x01, 0x0a, 0x2a,
	0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x45, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x0a, 0x1e, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x61, 0x63, 0x65, 0x43, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x43, 0x0a, 0x1e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x5f, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48,
	0x65, 0x61, 0x64, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x1f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68,
	0x61, 0x6e, 0x64, 0x73, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1c, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x1e, 0x0a, 0x1c, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xba, 0x02, 0x0a, 0x0e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x7e, 0x0a, 0x16, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x12, 0x49, 0x0a, 0x22, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x66, 0x5f,
	0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x1d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x49, 0x66, 0x4e, 0x6f, 0x74, 0x45, 0x78, 0x69, 0x73, 0x74, 0x73, 0x1a,
	0x47, 0x0a, 0x19, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x76, 0x0a, 0x18, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x4c, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0e, 0x6d, 0x61, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xd3, 0x01, 0x0a, 0x17, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x75, 0x74, 0x6f, 0x4d,
	0x4c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x14,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12,
	0x25, 0x0a, 0x0e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0e, 0x6d, 0x61, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x35, 0x0a, 0x17, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x14, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x53, 0x69, 0x7a,
	0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x22, 0xac, 0x02, 0x0a, 0x12, 0x56, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a,
	0x12, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x66, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x70, 0x73, 0x12, 0x63, 0x0a, 0x13, 0x64,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x64, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x12, 0x64, 0x65,
	0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x43, 0x0a, 0x1e, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1b, 0x70, 0x6f, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x1b, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x5f,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xc3, 0x01, 0x0a, 0x0b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5f, 0x0a,
	0x10, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0f, 0x61,
	0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2b,
	0x0a, 0x11, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x61, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x55, 0x0a, 0x15, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x24, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x22, 0xc7, 0x02, 0x0a, 0x12, 0x44, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x0c, 0x6d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x32, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x74, 0x0a, 0x18, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x16, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x73, 0x2a, 0xe6, 0x01, 0x0a,
	0x09, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x4f,
	0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f,
	0x43, 0x4c, 0x41, 0x53, 0x53, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x14, 0x0a, 0x10, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f,
	0x43, 0x4c, 0x41, 0x53, 0x53, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03,
	0x12, 0x19, 0x0a, 0x15, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54,
	0x5f, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x1c, 0x0a, 0x18, 0x56,
	0x49, 0x44, 0x45, 0x4f, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x43, 0x4f,
	0x47, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x4f, 0x43, 0x43,
	0x55, 0x50, 0x41, 0x4e, 0x43, 0x59, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x5f, 0x42, 0x4c, 0x55, 0x52,
	0x10, 0x07, 0x12, 0x11, 0x0a, 0x0d, 0x56, 0x45, 0x52, 0x54, 0x45, 0x58, 0x5f, 0x43, 0x55, 0x53,
	0x54, 0x4f, 0x4d, 0x10, 0x08, 0x2a, 0xd0, 0x01, 0x0a, 0x0f, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x43, 0x43,
	0x45, 0x4c, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x4e,
	0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x4b, 0x38, 0x30, 0x10,
	0x01, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c,
	0x41, 0x5f, 0x50, 0x31, 0x30, 0x30, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49, 0x44,
	0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x56, 0x31, 0x30, 0x30, 0x10, 0x03, 0x12,
	0x13, 0x0a, 0x0f, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f,
	0x50, 0x34, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54,
	0x45, 0x53, 0x4c, 0x41, 0x5f, 0x54, 0x34, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49,
	0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x41, 0x31, 0x30, 0x30, 0x10, 0x08,
	0x12, 0x0a, 0x0a, 0x06, 0x54, 0x50, 0x55, 0x5f, 0x56, 0x32, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06,
	0x54, 0x50, 0x55, 0x5f, 0x56, 0x33, 0x10, 0x07, 0x32, 0xde, 0x30, 0x0a, 0x0b, 0x41, 0x70, 0x70,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0xce, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xbb, 0x01, 0x0a, 0x0e, 0x47, 0x65,
	0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf2, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22,
	0x36, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x83, 0x02, 0x0a,
	0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x51, 0x32, 0x42, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f,
	0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x17, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca,
	0x41, 0x20, 0x0a, 0x0b, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xe0, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a, 0x36, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xef, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x3d, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2e, 0x0a, 0x19, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xf7, 0x01, 0x0a, 0x13, 0x55, 0x6e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x84, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x44, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41,
	0x30, 0x0a, 0x1b, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x8f, 0x02, 0x0a, 0x19, 0x41, 0x64, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x41, 0x64, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x90, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x61, 0x64, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x36, 0x0a, 0x21, 0x41,
	0x64, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x9b, 0x02, 0x0a, 0x1c, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x96, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4d, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x39, 0x0a, 0x24, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x9b, 0x02, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x96, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x22,
	0x48, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0xca, 0x41, 0x39, 0x0a, 0x24, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xd1, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0xbe, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x9e, 0x02, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9d, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x22, 0x51,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x37, 0x0a, 0x22,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x84, 0x02, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x22,
	0x51, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x1d, 0x0a,
	0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb5, 0x02, 0x0a,
	0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb4, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x22, 0x51, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1b, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x20, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0xca, 0x41, 0x37, 0x0a, 0x22, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0xc5, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x72, 0x61,
	0x66, 0x74, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x72, 0x61, 0x66, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x72, 0x61, 0x66,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x72, 0x61,
	0x66, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb2, 0x01, 0x0a,
	0x08, 0x47, 0x65, 0x74, 0x44, 0x72, 0x61, 0x66, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x72,
	0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x72, 0x61, 0x66,
	0x74, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xe6, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x72, 0x61, 0x66,
	0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x22, 0x3f, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x73, 0x3a, 0x05,
	0x64, 0x72, 0x61, 0x66, 0x74, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64,
	0x72, 0x61, 0x66, 0x74, 0x2c, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x1a,
	0x0a, 0x05, 0x44, 0x72, 0x61, 0x66, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe8, 0x01, 0x0a, 0x0b, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x72, 0x61, 0x66, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x32, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2f, 0x7b, 0x64, 0x72, 0x61, 0x66, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x05, 0x64,
	0x72, 0x61, 0x66, 0x74, 0xda, 0x41, 0x11, 0x64, 0x72, 0x61, 0x66, 0x74, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x1a, 0x0a, 0x05, 0x44, 0x72, 0x61,
	0x66, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xdd, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x72, 0x61, 0x66, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x72, 0x61,
	0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41,
	0x2a, 0x3f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc6, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12,
	0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xea,
	0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42,
	0x22, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x3a, 0x70, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb3, 0x01, 0x0a, 0x0c,
	0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x22, 0x43, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xf3, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x41, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x3a, 0x09, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0xda, 0x41, 0x1d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xf5, 0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x8a, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x32, 0x3e, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x09, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0xda, 0x41, 0x15, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41,
	0x1e, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xda, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x36, 0x2a, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca,
	0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x4b, 0xca, 0x41,
	0x17, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe3, 0x01, 0x0a, 0x22, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x42, 0x0d, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x3b, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41,
	0x49, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x41, 0x49, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_visionai_v1alpha1_platform_proto_rawDescOnce sync.Once
	file_google_cloud_visionai_v1alpha1_platform_proto_rawDescData = file_google_cloud_visionai_v1alpha1_platform_proto_rawDesc
)

func file_google_cloud_visionai_v1alpha1_platform_proto_rawDescGZIP() []byte {
	file_google_cloud_visionai_v1alpha1_platform_proto_rawDescOnce.Do(func() {
		file_google_cloud_visionai_v1alpha1_platform_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_visionai_v1alpha1_platform_proto_rawDescData)
	})
	return file_google_cloud_visionai_v1alpha1_platform_proto_rawDescData
}

var file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes = make([]protoimpl.MessageInfo, 89)
var file_google_cloud_visionai_v1alpha1_platform_proto_goTypes = []interface{}{
	(ModelType)(0),                                                      // 0: google.cloud.visionai.v1alpha1.ModelType
	(AcceleratorType)(0),                                                // 1: google.cloud.visionai.v1alpha1.AcceleratorType
	(Application_State)(0),                                              // 2: google.cloud.visionai.v1alpha1.Application.State
	(Instance_State)(0),                                                 // 3: google.cloud.visionai.v1alpha1.Instance.State
	(Processor_ProcessorType)(0),                                        // 4: google.cloud.visionai.v1alpha1.Processor.ProcessorType
	(Processor_ProcessorState)(0),                                       // 5: google.cloud.visionai.v1alpha1.Processor.ProcessorState
	(ProcessorIOSpec_DataType)(0),                                       // 6: google.cloud.visionai.v1alpha1.ProcessorIOSpec.DataType
	(CustomProcessorSourceInfo_SourceType)(0),                           // 7: google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.SourceType
	(PersonBlurConfig_PersonBlurType)(0),                                // 8: google.cloud.visionai.v1alpha1.PersonBlurConfig.PersonBlurType
	(*DeleteApplicationInstancesResponse)(nil),                          // 9: google.cloud.visionai.v1alpha1.DeleteApplicationInstancesResponse
	(*CreateApplicationInstancesResponse)(nil),                          // 10: google.cloud.visionai.v1alpha1.CreateApplicationInstancesResponse
	(*UpdateApplicationInstancesResponse)(nil),                          // 11: google.cloud.visionai.v1alpha1.UpdateApplicationInstancesResponse
	(*CreateApplicationInstancesRequest)(nil),                           // 12: google.cloud.visionai.v1alpha1.CreateApplicationInstancesRequest
	(*DeleteApplicationInstancesRequest)(nil),                           // 13: google.cloud.visionai.v1alpha1.DeleteApplicationInstancesRequest
	(*DeployApplicationResponse)(nil),                                   // 14: google.cloud.visionai.v1alpha1.DeployApplicationResponse
	(*UndeployApplicationResponse)(nil),                                 // 15: google.cloud.visionai.v1alpha1.UndeployApplicationResponse
	(*RemoveApplicationStreamInputResponse)(nil),                        // 16: google.cloud.visionai.v1alpha1.RemoveApplicationStreamInputResponse
	(*AddApplicationStreamInputResponse)(nil),                           // 17: google.cloud.visionai.v1alpha1.AddApplicationStreamInputResponse
	(*UpdateApplicationStreamInputResponse)(nil),                        // 18: google.cloud.visionai.v1alpha1.UpdateApplicationStreamInputResponse
	(*ListApplicationsRequest)(nil),                                     // 19: google.cloud.visionai.v1alpha1.ListApplicationsRequest
	(*ListApplicationsResponse)(nil),                                    // 20: google.cloud.visionai.v1alpha1.ListApplicationsResponse
	(*GetApplicationRequest)(nil),                                       // 21: google.cloud.visionai.v1alpha1.GetApplicationRequest
	(*CreateApplicationRequest)(nil),                                    // 22: google.cloud.visionai.v1alpha1.CreateApplicationRequest
	(*UpdateApplicationRequest)(nil),                                    // 23: google.cloud.visionai.v1alpha1.UpdateApplicationRequest
	(*DeleteApplicationRequest)(nil),                                    // 24: google.cloud.visionai.v1alpha1.DeleteApplicationRequest
	(*DeployApplicationRequest)(nil),                                    // 25: google.cloud.visionai.v1alpha1.DeployApplicationRequest
	(*UndeployApplicationRequest)(nil),                                  // 26: google.cloud.visionai.v1alpha1.UndeployApplicationRequest
	(*ApplicationStreamInput)(nil),                                      // 27: google.cloud.visionai.v1alpha1.ApplicationStreamInput
	(*AddApplicationStreamInputRequest)(nil),                            // 28: google.cloud.visionai.v1alpha1.AddApplicationStreamInputRequest
	(*UpdateApplicationStreamInputRequest)(nil),                         // 29: google.cloud.visionai.v1alpha1.UpdateApplicationStreamInputRequest
	(*RemoveApplicationStreamInputRequest)(nil),                         // 30: google.cloud.visionai.v1alpha1.RemoveApplicationStreamInputRequest
	(*ListInstancesRequest)(nil),                                        // 31: google.cloud.visionai.v1alpha1.ListInstancesRequest
	(*ListInstancesResponse)(nil),                                       // 32: google.cloud.visionai.v1alpha1.ListInstancesResponse
	(*GetInstanceRequest)(nil),                                          // 33: google.cloud.visionai.v1alpha1.GetInstanceRequest
	(*ListDraftsRequest)(nil),                                           // 34: google.cloud.visionai.v1alpha1.ListDraftsRequest
	(*ListDraftsResponse)(nil),                                          // 35: google.cloud.visionai.v1alpha1.ListDraftsResponse
	(*GetDraftRequest)(nil),                                             // 36: google.cloud.visionai.v1alpha1.GetDraftRequest
	(*CreateDraftRequest)(nil),                                          // 37: google.cloud.visionai.v1alpha1.CreateDraftRequest
	(*UpdateDraftRequest)(nil),                                          // 38: google.cloud.visionai.v1alpha1.UpdateDraftRequest
	(*UpdateApplicationInstancesRequest)(nil),                           // 39: google.cloud.visionai.v1alpha1.UpdateApplicationInstancesRequest
	(*DeleteDraftRequest)(nil),                                          // 40: google.cloud.visionai.v1alpha1.DeleteDraftRequest
	(*ListProcessorsRequest)(nil),                                       // 41: google.cloud.visionai.v1alpha1.ListProcessorsRequest
	(*ListProcessorsResponse)(nil),                                      // 42: google.cloud.visionai.v1alpha1.ListProcessorsResponse
	(*ListPrebuiltProcessorsRequest)(nil),                               // 43: google.cloud.visionai.v1alpha1.ListPrebuiltProcessorsRequest
	(*ListPrebuiltProcessorsResponse)(nil),                              // 44: google.cloud.visionai.v1alpha1.ListPrebuiltProcessorsResponse
	(*GetProcessorRequest)(nil),                                         // 45: google.cloud.visionai.v1alpha1.GetProcessorRequest
	(*CreateProcessorRequest)(nil),                                      // 46: google.cloud.visionai.v1alpha1.CreateProcessorRequest
	(*UpdateProcessorRequest)(nil),                                      // 47: google.cloud.visionai.v1alpha1.UpdateProcessorRequest
	(*DeleteProcessorRequest)(nil),                                      // 48: google.cloud.visionai.v1alpha1.DeleteProcessorRequest
	(*Application)(nil),                                                 // 49: google.cloud.visionai.v1alpha1.Application
	(*ApplicationConfigs)(nil),                                          // 50: google.cloud.visionai.v1alpha1.ApplicationConfigs
	(*Node)(nil),                                                        // 51: google.cloud.visionai.v1alpha1.Node
	(*Draft)(nil),                                                       // 52: google.cloud.visionai.v1alpha1.Draft
	(*Instance)(nil),                                                    // 53: google.cloud.visionai.v1alpha1.Instance
	(*ApplicationInstance)(nil),                                         // 54: google.cloud.visionai.v1alpha1.ApplicationInstance
	(*Processor)(nil),                                                   // 55: google.cloud.visionai.v1alpha1.Processor
	(*ProcessorIOSpec)(nil),                                             // 56: google.cloud.visionai.v1alpha1.ProcessorIOSpec
	(*CustomProcessorSourceInfo)(nil),                                   // 57: google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo
	(*ProcessorConfig)(nil),                                             // 58: google.cloud.visionai.v1alpha1.ProcessorConfig
	(*StreamWithAnnotation)(nil),                                        // 59: google.cloud.visionai.v1alpha1.StreamWithAnnotation
	(*ApplicationNodeAnnotation)(nil),                                   // 60: google.cloud.visionai.v1alpha1.ApplicationNodeAnnotation
	(*ResourceAnnotations)(nil),                                         // 61: google.cloud.visionai.v1alpha1.ResourceAnnotations
	(*VideoStreamInputConfig)(nil),                                      // 62: google.cloud.visionai.v1alpha1.VideoStreamInputConfig
	(*AIEnabledDevicesInputConfig)(nil),                                 // 63: google.cloud.visionai.v1alpha1.AIEnabledDevicesInputConfig
	(*MediaWarehouseConfig)(nil),                                        // 64: google.cloud.visionai.v1alpha1.MediaWarehouseConfig
	(*PersonBlurConfig)(nil),                                            // 65: google.cloud.visionai.v1alpha1.PersonBlurConfig
	(*OccupancyCountConfig)(nil),                                        // 66: google.cloud.visionai.v1alpha1.OccupancyCountConfig
	(*PersonVehicleDetectionConfig)(nil),                                // 67: google.cloud.visionai.v1alpha1.PersonVehicleDetectionConfig
	(*PersonalProtectiveEquipmentDetectionConfig)(nil),                  // 68: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionConfig
	(*GeneralObjectDetectionConfig)(nil),                                // 69: google.cloud.visionai.v1alpha1.GeneralObjectDetectionConfig
	(*BigQueryConfig)(nil),                                              // 70: google.cloud.visionai.v1alpha1.BigQueryConfig
	(*VertexAutoMLVisionConfig)(nil),                                    // 71: google.cloud.visionai.v1alpha1.VertexAutoMLVisionConfig
	(*VertexAutoMLVideoConfig)(nil),                                     // 72: google.cloud.visionai.v1alpha1.VertexAutoMLVideoConfig
	(*VertexCustomConfig)(nil),                                          // 73: google.cloud.visionai.v1alpha1.VertexCustomConfig
	(*MachineSpec)(nil),                                                 // 74: google.cloud.visionai.v1alpha1.MachineSpec
	(*AutoscalingMetricSpec)(nil),                                       // 75: google.cloud.visionai.v1alpha1.AutoscalingMetricSpec
	(*DedicatedResources)(nil),                                          // 76: google.cloud.visionai.v1alpha1.DedicatedResources
	(*RemoveApplicationStreamInputRequest_TargetStreamInput)(nil),       // 77: google.cloud.visionai.v1alpha1.RemoveApplicationStreamInputRequest.TargetStreamInput
	(*UpdateApplicationInstancesRequest_UpdateApplicationInstance)(nil), // 78: google.cloud.visionai.v1alpha1.UpdateApplicationInstancesRequest.UpdateApplicationInstance
	(*Application_ApplicationRuntimeInfo)(nil),                          // 79: google.cloud.visionai.v1alpha1.Application.ApplicationRuntimeInfo
	nil, // 80: google.cloud.visionai.v1alpha1.Application.LabelsEntry
	(*Application_ApplicationRuntimeInfo_GlobalOutputResource)(nil), // 81: google.cloud.visionai.v1alpha1.Application.ApplicationRuntimeInfo.GlobalOutputResource
	(*Application_ApplicationRuntimeInfo_MonitoringConfig)(nil),     // 82: google.cloud.visionai.v1alpha1.Application.ApplicationRuntimeInfo.MonitoringConfig
	(*ApplicationConfigs_EventDeliveryConfig)(nil),                  // 83: google.cloud.visionai.v1alpha1.ApplicationConfigs.EventDeliveryConfig
	(*Node_InputEdge)(nil),          // 84: google.cloud.visionai.v1alpha1.Node.InputEdge
	nil,                             // 85: google.cloud.visionai.v1alpha1.Draft.LabelsEntry
	(*Instance_InputResource)(nil),  // 86: google.cloud.visionai.v1alpha1.Instance.InputResource
	(*Instance_OutputResource)(nil), // 87: google.cloud.visionai.v1alpha1.Instance.OutputResource
	nil,                             // 88: google.cloud.visionai.v1alpha1.Instance.LabelsEntry
	nil,                             // 89: google.cloud.visionai.v1alpha1.Processor.LabelsEntry
	(*ProcessorIOSpec_GraphInputChannelSpec)(nil),             // 90: google.cloud.visionai.v1alpha1.ProcessorIOSpec.GraphInputChannelSpec
	(*ProcessorIOSpec_GraphOutputChannelSpec)(nil),            // 91: google.cloud.visionai.v1alpha1.ProcessorIOSpec.GraphOutputChannelSpec
	(*ProcessorIOSpec_InstanceResourceInputBindingSpec)(nil),  // 92: google.cloud.visionai.v1alpha1.ProcessorIOSpec.InstanceResourceInputBindingSpec
	(*ProcessorIOSpec_InstanceResourceOutputBindingSpec)(nil), // 93: google.cloud.visionai.v1alpha1.ProcessorIOSpec.InstanceResourceOutputBindingSpec
	(*CustomProcessorSourceInfo_ModelSchema)(nil),             // 94: google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.ModelSchema
	nil, // 95: google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.AdditionalInfoEntry
	(*StreamWithAnnotation_NodeAnnotation)(nil), // 96: google.cloud.visionai.v1alpha1.StreamWithAnnotation.NodeAnnotation
	nil,                           // 97: google.cloud.visionai.v1alpha1.BigQueryConfig.CloudFunctionMappingEntry
	(*fieldmaskpb.FieldMask)(nil), // 98: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil), // 99: google.protobuf.Timestamp
	(StreamAnnotationType)(0),     // 100: google.cloud.visionai.v1alpha1.StreamAnnotationType
	(*StreamAnnotation)(nil),      // 101: google.cloud.visionai.v1alpha1.StreamAnnotation
	(*durationpb.Duration)(nil),   // 102: google.protobuf.Duration
	(*GcsSource)(nil),             // 103: google.cloud.visionai.v1alpha1.GcsSource
	(*longrunning.Operation)(nil), // 104: google.longrunning.Operation
}
var file_google_cloud_visionai_v1alpha1_platform_proto_depIdxs = []int32{
	54,  // 0: google.cloud.visionai.v1alpha1.CreateApplicationInstancesRequest.application_instances:type_name -> google.cloud.visionai.v1alpha1.ApplicationInstance
	49,  // 1: google.cloud.visionai.v1alpha1.ListApplicationsResponse.applications:type_name -> google.cloud.visionai.v1alpha1.Application
	49,  // 2: google.cloud.visionai.v1alpha1.CreateApplicationRequest.application:type_name -> google.cloud.visionai.v1alpha1.Application
	98,  // 3: google.cloud.visionai.v1alpha1.UpdateApplicationRequest.update_mask:type_name -> google.protobuf.FieldMask
	49,  // 4: google.cloud.visionai.v1alpha1.UpdateApplicationRequest.application:type_name -> google.cloud.visionai.v1alpha1.Application
	59,  // 5: google.cloud.visionai.v1alpha1.ApplicationStreamInput.stream_with_annotation:type_name -> google.cloud.visionai.v1alpha1.StreamWithAnnotation
	27,  // 6: google.cloud.visionai.v1alpha1.AddApplicationStreamInputRequest.application_stream_inputs:type_name -> google.cloud.visionai.v1alpha1.ApplicationStreamInput
	27,  // 7: google.cloud.visionai.v1alpha1.UpdateApplicationStreamInputRequest.application_stream_inputs:type_name -> google.cloud.visionai.v1alpha1.ApplicationStreamInput
	77,  // 8: google.cloud.visionai.v1alpha1.RemoveApplicationStreamInputRequest.target_stream_inputs:type_name -> google.cloud.visionai.v1alpha1.RemoveApplicationStreamInputRequest.TargetStreamInput
	53,  // 9: google.cloud.visionai.v1alpha1.ListInstancesResponse.instances:type_name -> google.cloud.visionai.v1alpha1.Instance
	52,  // 10: google.cloud.visionai.v1alpha1.ListDraftsResponse.drafts:type_name -> google.cloud.visionai.v1alpha1.Draft
	52,  // 11: google.cloud.visionai.v1alpha1.CreateDraftRequest.draft:type_name -> google.cloud.visionai.v1alpha1.Draft
	98,  // 12: google.cloud.visionai.v1alpha1.UpdateDraftRequest.update_mask:type_name -> google.protobuf.FieldMask
	52,  // 13: google.cloud.visionai.v1alpha1.UpdateDraftRequest.draft:type_name -> google.cloud.visionai.v1alpha1.Draft
	78,  // 14: google.cloud.visionai.v1alpha1.UpdateApplicationInstancesRequest.application_instances:type_name -> google.cloud.visionai.v1alpha1.UpdateApplicationInstancesRequest.UpdateApplicationInstance
	55,  // 15: google.cloud.visionai.v1alpha1.ListProcessorsResponse.processors:type_name -> google.cloud.visionai.v1alpha1.Processor
	55,  // 16: google.cloud.visionai.v1alpha1.ListPrebuiltProcessorsResponse.processors:type_name -> google.cloud.visionai.v1alpha1.Processor
	55,  // 17: google.cloud.visionai.v1alpha1.CreateProcessorRequest.processor:type_name -> google.cloud.visionai.v1alpha1.Processor
	98,  // 18: google.cloud.visionai.v1alpha1.UpdateProcessorRequest.update_mask:type_name -> google.protobuf.FieldMask
	55,  // 19: google.cloud.visionai.v1alpha1.UpdateProcessorRequest.processor:type_name -> google.cloud.visionai.v1alpha1.Processor
	99,  // 20: google.cloud.visionai.v1alpha1.Application.create_time:type_name -> google.protobuf.Timestamp
	99,  // 21: google.cloud.visionai.v1alpha1.Application.update_time:type_name -> google.protobuf.Timestamp
	80,  // 22: google.cloud.visionai.v1alpha1.Application.labels:type_name -> google.cloud.visionai.v1alpha1.Application.LabelsEntry
	50,  // 23: google.cloud.visionai.v1alpha1.Application.application_configs:type_name -> google.cloud.visionai.v1alpha1.ApplicationConfigs
	79,  // 24: google.cloud.visionai.v1alpha1.Application.runtime_info:type_name -> google.cloud.visionai.v1alpha1.Application.ApplicationRuntimeInfo
	2,   // 25: google.cloud.visionai.v1alpha1.Application.state:type_name -> google.cloud.visionai.v1alpha1.Application.State
	51,  // 26: google.cloud.visionai.v1alpha1.ApplicationConfigs.nodes:type_name -> google.cloud.visionai.v1alpha1.Node
	83,  // 27: google.cloud.visionai.v1alpha1.ApplicationConfigs.event_delivery_config:type_name -> google.cloud.visionai.v1alpha1.ApplicationConfigs.EventDeliveryConfig
	58,  // 28: google.cloud.visionai.v1alpha1.Node.node_config:type_name -> google.cloud.visionai.v1alpha1.ProcessorConfig
	84,  // 29: google.cloud.visionai.v1alpha1.Node.parents:type_name -> google.cloud.visionai.v1alpha1.Node.InputEdge
	99,  // 30: google.cloud.visionai.v1alpha1.Draft.create_time:type_name -> google.protobuf.Timestamp
	99,  // 31: google.cloud.visionai.v1alpha1.Draft.update_time:type_name -> google.protobuf.Timestamp
	85,  // 32: google.cloud.visionai.v1alpha1.Draft.labels:type_name -> google.cloud.visionai.v1alpha1.Draft.LabelsEntry
	50,  // 33: google.cloud.visionai.v1alpha1.Draft.draft_application_configs:type_name -> google.cloud.visionai.v1alpha1.ApplicationConfigs
	99,  // 34: google.cloud.visionai.v1alpha1.Instance.create_time:type_name -> google.protobuf.Timestamp
	99,  // 35: google.cloud.visionai.v1alpha1.Instance.update_time:type_name -> google.protobuf.Timestamp
	88,  // 36: google.cloud.visionai.v1alpha1.Instance.labels:type_name -> google.cloud.visionai.v1alpha1.Instance.LabelsEntry
	86,  // 37: google.cloud.visionai.v1alpha1.Instance.input_resources:type_name -> google.cloud.visionai.v1alpha1.Instance.InputResource
	87,  // 38: google.cloud.visionai.v1alpha1.Instance.output_resources:type_name -> google.cloud.visionai.v1alpha1.Instance.OutputResource
	3,   // 39: google.cloud.visionai.v1alpha1.Instance.state:type_name -> google.cloud.visionai.v1alpha1.Instance.State
	53,  // 40: google.cloud.visionai.v1alpha1.ApplicationInstance.instance:type_name -> google.cloud.visionai.v1alpha1.Instance
	99,  // 41: google.cloud.visionai.v1alpha1.Processor.create_time:type_name -> google.protobuf.Timestamp
	99,  // 42: google.cloud.visionai.v1alpha1.Processor.update_time:type_name -> google.protobuf.Timestamp
	89,  // 43: google.cloud.visionai.v1alpha1.Processor.labels:type_name -> google.cloud.visionai.v1alpha1.Processor.LabelsEntry
	4,   // 44: google.cloud.visionai.v1alpha1.Processor.processor_type:type_name -> google.cloud.visionai.v1alpha1.Processor.ProcessorType
	0,   // 45: google.cloud.visionai.v1alpha1.Processor.model_type:type_name -> google.cloud.visionai.v1alpha1.ModelType
	57,  // 46: google.cloud.visionai.v1alpha1.Processor.custom_processor_source_info:type_name -> google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo
	5,   // 47: google.cloud.visionai.v1alpha1.Processor.state:type_name -> google.cloud.visionai.v1alpha1.Processor.ProcessorState
	56,  // 48: google.cloud.visionai.v1alpha1.Processor.processor_io_spec:type_name -> google.cloud.visionai.v1alpha1.ProcessorIOSpec
	100, // 49: google.cloud.visionai.v1alpha1.Processor.supported_annotation_types:type_name -> google.cloud.visionai.v1alpha1.StreamAnnotationType
	90,  // 50: google.cloud.visionai.v1alpha1.ProcessorIOSpec.graph_input_channel_specs:type_name -> google.cloud.visionai.v1alpha1.ProcessorIOSpec.GraphInputChannelSpec
	91,  // 51: google.cloud.visionai.v1alpha1.ProcessorIOSpec.graph_output_channel_specs:type_name -> google.cloud.visionai.v1alpha1.ProcessorIOSpec.GraphOutputChannelSpec
	92,  // 52: google.cloud.visionai.v1alpha1.ProcessorIOSpec.instance_resource_input_binding_specs:type_name -> google.cloud.visionai.v1alpha1.ProcessorIOSpec.InstanceResourceInputBindingSpec
	93,  // 53: google.cloud.visionai.v1alpha1.ProcessorIOSpec.instance_resource_output_binding_specs:type_name -> google.cloud.visionai.v1alpha1.ProcessorIOSpec.InstanceResourceOutputBindingSpec
	7,   // 54: google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.source_type:type_name -> google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.SourceType
	95,  // 55: google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.additional_info:type_name -> google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.AdditionalInfoEntry
	94,  // 56: google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.model_schema:type_name -> google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.ModelSchema
	62,  // 57: google.cloud.visionai.v1alpha1.ProcessorConfig.video_stream_input_config:type_name -> google.cloud.visionai.v1alpha1.VideoStreamInputConfig
	63,  // 58: google.cloud.visionai.v1alpha1.ProcessorConfig.ai_enabled_devices_input_config:type_name -> google.cloud.visionai.v1alpha1.AIEnabledDevicesInputConfig
	64,  // 59: google.cloud.visionai.v1alpha1.ProcessorConfig.media_warehouse_config:type_name -> google.cloud.visionai.v1alpha1.MediaWarehouseConfig
	65,  // 60: google.cloud.visionai.v1alpha1.ProcessorConfig.person_blur_config:type_name -> google.cloud.visionai.v1alpha1.PersonBlurConfig
	66,  // 61: google.cloud.visionai.v1alpha1.ProcessorConfig.occupancy_count_config:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountConfig
	67,  // 62: google.cloud.visionai.v1alpha1.ProcessorConfig.person_vehicle_detection_config:type_name -> google.cloud.visionai.v1alpha1.PersonVehicleDetectionConfig
	71,  // 63: google.cloud.visionai.v1alpha1.ProcessorConfig.vertex_automl_vision_config:type_name -> google.cloud.visionai.v1alpha1.VertexAutoMLVisionConfig
	72,  // 64: google.cloud.visionai.v1alpha1.ProcessorConfig.vertex_automl_video_config:type_name -> google.cloud.visionai.v1alpha1.VertexAutoMLVideoConfig
	73,  // 65: google.cloud.visionai.v1alpha1.ProcessorConfig.vertex_custom_config:type_name -> google.cloud.visionai.v1alpha1.VertexCustomConfig
	69,  // 66: google.cloud.visionai.v1alpha1.ProcessorConfig.general_object_detection_config:type_name -> google.cloud.visionai.v1alpha1.GeneralObjectDetectionConfig
	70,  // 67: google.cloud.visionai.v1alpha1.ProcessorConfig.big_query_config:type_name -> google.cloud.visionai.v1alpha1.BigQueryConfig
	68,  // 68: google.cloud.visionai.v1alpha1.ProcessorConfig.personal_protective_equipment_detection_config:type_name -> google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionConfig
	101, // 69: google.cloud.visionai.v1alpha1.StreamWithAnnotation.application_annotations:type_name -> google.cloud.visionai.v1alpha1.StreamAnnotation
	96,  // 70: google.cloud.visionai.v1alpha1.StreamWithAnnotation.node_annotations:type_name -> google.cloud.visionai.v1alpha1.StreamWithAnnotation.NodeAnnotation
	101, // 71: google.cloud.visionai.v1alpha1.ApplicationNodeAnnotation.annotations:type_name -> google.cloud.visionai.v1alpha1.StreamAnnotation
	101, // 72: google.cloud.visionai.v1alpha1.ResourceAnnotations.application_annotations:type_name -> google.cloud.visionai.v1alpha1.StreamAnnotation
	60,  // 73: google.cloud.visionai.v1alpha1.ResourceAnnotations.node_annotations:type_name -> google.cloud.visionai.v1alpha1.ApplicationNodeAnnotation
	59,  // 74: google.cloud.visionai.v1alpha1.VideoStreamInputConfig.streams_with_annotation:type_name -> google.cloud.visionai.v1alpha1.StreamWithAnnotation
	102, // 75: google.cloud.visionai.v1alpha1.MediaWarehouseConfig.ttl:type_name -> google.protobuf.Duration
	8,   // 76: google.cloud.visionai.v1alpha1.PersonBlurConfig.person_blur_type:type_name -> google.cloud.visionai.v1alpha1.PersonBlurConfig.PersonBlurType
	97,  // 77: google.cloud.visionai.v1alpha1.BigQueryConfig.cloud_function_mapping:type_name -> google.cloud.visionai.v1alpha1.BigQueryConfig.CloudFunctionMappingEntry
	76,  // 78: google.cloud.visionai.v1alpha1.VertexCustomConfig.dedicated_resources:type_name -> google.cloud.visionai.v1alpha1.DedicatedResources
	1,   // 79: google.cloud.visionai.v1alpha1.MachineSpec.accelerator_type:type_name -> google.cloud.visionai.v1alpha1.AcceleratorType
	74,  // 80: google.cloud.visionai.v1alpha1.DedicatedResources.machine_spec:type_name -> google.cloud.visionai.v1alpha1.MachineSpec
	75,  // 81: google.cloud.visionai.v1alpha1.DedicatedResources.autoscaling_metric_specs:type_name -> google.cloud.visionai.v1alpha1.AutoscalingMetricSpec
	98,  // 82: google.cloud.visionai.v1alpha1.UpdateApplicationInstancesRequest.UpdateApplicationInstance.update_mask:type_name -> google.protobuf.FieldMask
	53,  // 83: google.cloud.visionai.v1alpha1.UpdateApplicationInstancesRequest.UpdateApplicationInstance.instance:type_name -> google.cloud.visionai.v1alpha1.Instance
	99,  // 84: google.cloud.visionai.v1alpha1.Application.ApplicationRuntimeInfo.deploy_time:type_name -> google.protobuf.Timestamp
	81,  // 85: google.cloud.visionai.v1alpha1.Application.ApplicationRuntimeInfo.global_output_resources:type_name -> google.cloud.visionai.v1alpha1.Application.ApplicationRuntimeInfo.GlobalOutputResource
	82,  // 86: google.cloud.visionai.v1alpha1.Application.ApplicationRuntimeInfo.monitoring_config:type_name -> google.cloud.visionai.v1alpha1.Application.ApplicationRuntimeInfo.MonitoringConfig
	102, // 87: google.cloud.visionai.v1alpha1.ApplicationConfigs.EventDeliveryConfig.minimal_delivery_interval:type_name -> google.protobuf.Duration
	59,  // 88: google.cloud.visionai.v1alpha1.Instance.InputResource.annotated_stream:type_name -> google.cloud.visionai.v1alpha1.StreamWithAnnotation
	61,  // 89: google.cloud.visionai.v1alpha1.Instance.InputResource.annotations:type_name -> google.cloud.visionai.v1alpha1.ResourceAnnotations
	6,   // 90: google.cloud.visionai.v1alpha1.ProcessorIOSpec.GraphInputChannelSpec.data_type:type_name -> google.cloud.visionai.v1alpha1.ProcessorIOSpec.DataType
	6,   // 91: google.cloud.visionai.v1alpha1.ProcessorIOSpec.GraphOutputChannelSpec.data_type:type_name -> google.cloud.visionai.v1alpha1.ProcessorIOSpec.DataType
	103, // 92: google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.ModelSchema.instances_schema:type_name -> google.cloud.visionai.v1alpha1.GcsSource
	103, // 93: google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.ModelSchema.parameters_schema:type_name -> google.cloud.visionai.v1alpha1.GcsSource
	103, // 94: google.cloud.visionai.v1alpha1.CustomProcessorSourceInfo.ModelSchema.predictions_schema:type_name -> google.cloud.visionai.v1alpha1.GcsSource
	101, // 95: google.cloud.visionai.v1alpha1.StreamWithAnnotation.NodeAnnotation.annotations:type_name -> google.cloud.visionai.v1alpha1.StreamAnnotation
	19,  // 96: google.cloud.visionai.v1alpha1.AppPlatform.ListApplications:input_type -> google.cloud.visionai.v1alpha1.ListApplicationsRequest
	21,  // 97: google.cloud.visionai.v1alpha1.AppPlatform.GetApplication:input_type -> google.cloud.visionai.v1alpha1.GetApplicationRequest
	22,  // 98: google.cloud.visionai.v1alpha1.AppPlatform.CreateApplication:input_type -> google.cloud.visionai.v1alpha1.CreateApplicationRequest
	23,  // 99: google.cloud.visionai.v1alpha1.AppPlatform.UpdateApplication:input_type -> google.cloud.visionai.v1alpha1.UpdateApplicationRequest
	24,  // 100: google.cloud.visionai.v1alpha1.AppPlatform.DeleteApplication:input_type -> google.cloud.visionai.v1alpha1.DeleteApplicationRequest
	25,  // 101: google.cloud.visionai.v1alpha1.AppPlatform.DeployApplication:input_type -> google.cloud.visionai.v1alpha1.DeployApplicationRequest
	26,  // 102: google.cloud.visionai.v1alpha1.AppPlatform.UndeployApplication:input_type -> google.cloud.visionai.v1alpha1.UndeployApplicationRequest
	28,  // 103: google.cloud.visionai.v1alpha1.AppPlatform.AddApplicationStreamInput:input_type -> google.cloud.visionai.v1alpha1.AddApplicationStreamInputRequest
	30,  // 104: google.cloud.visionai.v1alpha1.AppPlatform.RemoveApplicationStreamInput:input_type -> google.cloud.visionai.v1alpha1.RemoveApplicationStreamInputRequest
	29,  // 105: google.cloud.visionai.v1alpha1.AppPlatform.UpdateApplicationStreamInput:input_type -> google.cloud.visionai.v1alpha1.UpdateApplicationStreamInputRequest
	31,  // 106: google.cloud.visionai.v1alpha1.AppPlatform.ListInstances:input_type -> google.cloud.visionai.v1alpha1.ListInstancesRequest
	33,  // 107: google.cloud.visionai.v1alpha1.AppPlatform.GetInstance:input_type -> google.cloud.visionai.v1alpha1.GetInstanceRequest
	12,  // 108: google.cloud.visionai.v1alpha1.AppPlatform.CreateApplicationInstances:input_type -> google.cloud.visionai.v1alpha1.CreateApplicationInstancesRequest
	13,  // 109: google.cloud.visionai.v1alpha1.AppPlatform.DeleteApplicationInstances:input_type -> google.cloud.visionai.v1alpha1.DeleteApplicationInstancesRequest
	39,  // 110: google.cloud.visionai.v1alpha1.AppPlatform.UpdateApplicationInstances:input_type -> google.cloud.visionai.v1alpha1.UpdateApplicationInstancesRequest
	34,  // 111: google.cloud.visionai.v1alpha1.AppPlatform.ListDrafts:input_type -> google.cloud.visionai.v1alpha1.ListDraftsRequest
	36,  // 112: google.cloud.visionai.v1alpha1.AppPlatform.GetDraft:input_type -> google.cloud.visionai.v1alpha1.GetDraftRequest
	37,  // 113: google.cloud.visionai.v1alpha1.AppPlatform.CreateDraft:input_type -> google.cloud.visionai.v1alpha1.CreateDraftRequest
	38,  // 114: google.cloud.visionai.v1alpha1.AppPlatform.UpdateDraft:input_type -> google.cloud.visionai.v1alpha1.UpdateDraftRequest
	40,  // 115: google.cloud.visionai.v1alpha1.AppPlatform.DeleteDraft:input_type -> google.cloud.visionai.v1alpha1.DeleteDraftRequest
	41,  // 116: google.cloud.visionai.v1alpha1.AppPlatform.ListProcessors:input_type -> google.cloud.visionai.v1alpha1.ListProcessorsRequest
	43,  // 117: google.cloud.visionai.v1alpha1.AppPlatform.ListPrebuiltProcessors:input_type -> google.cloud.visionai.v1alpha1.ListPrebuiltProcessorsRequest
	45,  // 118: google.cloud.visionai.v1alpha1.AppPlatform.GetProcessor:input_type -> google.cloud.visionai.v1alpha1.GetProcessorRequest
	46,  // 119: google.cloud.visionai.v1alpha1.AppPlatform.CreateProcessor:input_type -> google.cloud.visionai.v1alpha1.CreateProcessorRequest
	47,  // 120: google.cloud.visionai.v1alpha1.AppPlatform.UpdateProcessor:input_type -> google.cloud.visionai.v1alpha1.UpdateProcessorRequest
	48,  // 121: google.cloud.visionai.v1alpha1.AppPlatform.DeleteProcessor:input_type -> google.cloud.visionai.v1alpha1.DeleteProcessorRequest
	20,  // 122: google.cloud.visionai.v1alpha1.AppPlatform.ListApplications:output_type -> google.cloud.visionai.v1alpha1.ListApplicationsResponse
	49,  // 123: google.cloud.visionai.v1alpha1.AppPlatform.GetApplication:output_type -> google.cloud.visionai.v1alpha1.Application
	104, // 124: google.cloud.visionai.v1alpha1.AppPlatform.CreateApplication:output_type -> google.longrunning.Operation
	104, // 125: google.cloud.visionai.v1alpha1.AppPlatform.UpdateApplication:output_type -> google.longrunning.Operation
	104, // 126: google.cloud.visionai.v1alpha1.AppPlatform.DeleteApplication:output_type -> google.longrunning.Operation
	104, // 127: google.cloud.visionai.v1alpha1.AppPlatform.DeployApplication:output_type -> google.longrunning.Operation
	104, // 128: google.cloud.visionai.v1alpha1.AppPlatform.UndeployApplication:output_type -> google.longrunning.Operation
	104, // 129: google.cloud.visionai.v1alpha1.AppPlatform.AddApplicationStreamInput:output_type -> google.longrunning.Operation
	104, // 130: google.cloud.visionai.v1alpha1.AppPlatform.RemoveApplicationStreamInput:output_type -> google.longrunning.Operation
	104, // 131: google.cloud.visionai.v1alpha1.AppPlatform.UpdateApplicationStreamInput:output_type -> google.longrunning.Operation
	32,  // 132: google.cloud.visionai.v1alpha1.AppPlatform.ListInstances:output_type -> google.cloud.visionai.v1alpha1.ListInstancesResponse
	53,  // 133: google.cloud.visionai.v1alpha1.AppPlatform.GetInstance:output_type -> google.cloud.visionai.v1alpha1.Instance
	104, // 134: google.cloud.visionai.v1alpha1.AppPlatform.CreateApplicationInstances:output_type -> google.longrunning.Operation
	104, // 135: google.cloud.visionai.v1alpha1.AppPlatform.DeleteApplicationInstances:output_type -> google.longrunning.Operation
	104, // 136: google.cloud.visionai.v1alpha1.AppPlatform.UpdateApplicationInstances:output_type -> google.longrunning.Operation
	35,  // 137: google.cloud.visionai.v1alpha1.AppPlatform.ListDrafts:output_type -> google.cloud.visionai.v1alpha1.ListDraftsResponse
	52,  // 138: google.cloud.visionai.v1alpha1.AppPlatform.GetDraft:output_type -> google.cloud.visionai.v1alpha1.Draft
	104, // 139: google.cloud.visionai.v1alpha1.AppPlatform.CreateDraft:output_type -> google.longrunning.Operation
	104, // 140: google.cloud.visionai.v1alpha1.AppPlatform.UpdateDraft:output_type -> google.longrunning.Operation
	104, // 141: google.cloud.visionai.v1alpha1.AppPlatform.DeleteDraft:output_type -> google.longrunning.Operation
	42,  // 142: google.cloud.visionai.v1alpha1.AppPlatform.ListProcessors:output_type -> google.cloud.visionai.v1alpha1.ListProcessorsResponse
	44,  // 143: google.cloud.visionai.v1alpha1.AppPlatform.ListPrebuiltProcessors:output_type -> google.cloud.visionai.v1alpha1.ListPrebuiltProcessorsResponse
	55,  // 144: google.cloud.visionai.v1alpha1.AppPlatform.GetProcessor:output_type -> google.cloud.visionai.v1alpha1.Processor
	104, // 145: google.cloud.visionai.v1alpha1.AppPlatform.CreateProcessor:output_type -> google.longrunning.Operation
	104, // 146: google.cloud.visionai.v1alpha1.AppPlatform.UpdateProcessor:output_type -> google.longrunning.Operation
	104, // 147: google.cloud.visionai.v1alpha1.AppPlatform.DeleteProcessor:output_type -> google.longrunning.Operation
	122, // [122:148] is the sub-list for method output_type
	96,  // [96:122] is the sub-list for method input_type
	96,  // [96:96] is the sub-list for extension type_name
	96,  // [96:96] is the sub-list for extension extendee
	0,   // [0:96] is the sub-list for field type_name
}

func init() { file_google_cloud_visionai_v1alpha1_platform_proto_init() }
func file_google_cloud_visionai_v1alpha1_platform_proto_init() {
	if File_google_cloud_visionai_v1alpha1_platform_proto != nil {
		return
	}
	file_google_cloud_visionai_v1alpha1_annotations_proto_init()
	file_google_cloud_visionai_v1alpha1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteApplicationInstancesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateApplicationInstancesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateApplicationInstancesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateApplicationInstancesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteApplicationInstancesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployApplicationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployApplicationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveApplicationStreamInputResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddApplicationStreamInputResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateApplicationStreamInputResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListApplicationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListApplicationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetApplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateApplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateApplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteApplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployApplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployApplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationStreamInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddApplicationStreamInputRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateApplicationStreamInputRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveApplicationStreamInputRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListInstancesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListInstancesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDraftsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDraftsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDraftRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDraftRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDraftRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateApplicationInstancesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDraftRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrebuiltProcessorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrebuiltProcessorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Application); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Node); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Draft); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Processor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessorIOSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomProcessorSourceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamWithAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationNodeAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceAnnotations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoStreamInputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AIEnabledDevicesInputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MediaWarehouseConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonBlurConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonVehicleDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonalProtectiveEquipmentDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GeneralObjectDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VertexAutoMLVisionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VertexAutoMLVideoConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VertexCustomConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MachineSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoscalingMetricSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DedicatedResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveApplicationStreamInputRequest_TargetStreamInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateApplicationInstancesRequest_UpdateApplicationInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Application_ApplicationRuntimeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Application_ApplicationRuntimeInfo_GlobalOutputResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Application_ApplicationRuntimeInfo_MonitoringConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationConfigs_EventDeliveryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Node_InputEdge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance_InputResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance_OutputResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessorIOSpec_GraphInputChannelSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessorIOSpec_GraphOutputChannelSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessorIOSpec_InstanceResourceInputBindingSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessorIOSpec_InstanceResourceOutputBindingSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomProcessorSourceInfo_ModelSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamWithAnnotation_NodeAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[42].OneofWrappers = []interface{}{
		(*Node_OutputAllOutputChannelsToStream)(nil),
	}
	file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[48].OneofWrappers = []interface{}{
		(*CustomProcessorSourceInfo_VertexModel)(nil),
	}
	file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[49].OneofWrappers = []interface{}{
		(*ProcessorConfig_VideoStreamInputConfig)(nil),
		(*ProcessorConfig_AiEnabledDevicesInputConfig)(nil),
		(*ProcessorConfig_MediaWarehouseConfig)(nil),
		(*ProcessorConfig_PersonBlurConfig)(nil),
		(*ProcessorConfig_OccupancyCountConfig)(nil),
		(*ProcessorConfig_PersonVehicleDetectionConfig)(nil),
		(*ProcessorConfig_VertexAutomlVisionConfig)(nil),
		(*ProcessorConfig_VertexAutomlVideoConfig)(nil),
		(*ProcessorConfig_VertexCustomConfig)(nil),
		(*ProcessorConfig_GeneralObjectDetectionConfig)(nil),
		(*ProcessorConfig_BigQueryConfig)(nil),
		(*ProcessorConfig_PersonalProtectiveEquipmentDetectionConfig)(nil),
	}
	file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[77].OneofWrappers = []interface{}{
		(*Instance_InputResource_InputResource)(nil),
		(*Instance_InputResource_AnnotatedStream)(nil),
	}
	file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes[83].OneofWrappers = []interface{}{
		(*ProcessorIOSpec_InstanceResourceInputBindingSpec_ConfigTypeUri)(nil),
		(*ProcessorIOSpec_InstanceResourceInputBindingSpec_ResourceTypeUri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_visionai_v1alpha1_platform_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   89,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_visionai_v1alpha1_platform_proto_goTypes,
		DependencyIndexes: file_google_cloud_visionai_v1alpha1_platform_proto_depIdxs,
		EnumInfos:         file_google_cloud_visionai_v1alpha1_platform_proto_enumTypes,
		MessageInfos:      file_google_cloud_visionai_v1alpha1_platform_proto_msgTypes,
	}.Build()
	File_google_cloud_visionai_v1alpha1_platform_proto = out.File
	file_google_cloud_visionai_v1alpha1_platform_proto_rawDesc = nil
	file_google_cloud_visionai_v1alpha1_platform_proto_goTypes = nil
	file_google_cloud_visionai_v1alpha1_platform_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AppPlatformClient is the client API for AppPlatform service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AppPlatformClient interface {
	// Lists Applications in a given project and location.
	ListApplications(ctx context.Context, in *ListApplicationsRequest, opts ...grpc.CallOption) (*ListApplicationsResponse, error)
	// Gets details of a single Application.
	GetApplication(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*Application, error)
	// Creates a new Application in a given project and location.
	CreateApplication(ctx context.Context, in *CreateApplicationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the parameters of a single Application.
	UpdateApplication(ctx context.Context, in *UpdateApplicationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single Application.
	DeleteApplication(ctx context.Context, in *DeleteApplicationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deploys a single Application.
	DeployApplication(ctx context.Context, in *DeployApplicationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Undeploys a single Application.
	UndeployApplication(ctx context.Context, in *UndeployApplicationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Adds target stream input to the Application.
	// If the Application is deployed, the corresponding new Application instance
	// will be created. If the stream has already been in the Application, the RPC
	// will fail.
	AddApplicationStreamInput(ctx context.Context, in *AddApplicationStreamInputRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Remove target stream input to the Application, if the Application is
	// deployed, the corresponding instance based will be deleted. If the stream
	// is not in the Application, the RPC will fail.
	RemoveApplicationStreamInput(ctx context.Context, in *RemoveApplicationStreamInputRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Update target stream input to the Application, if the Application is
	// deployed, the corresponding instance based will be deployed. For
	// CreateOrUpdate behavior, set allow_missing to true.
	UpdateApplicationStreamInput(ctx context.Context, in *UpdateApplicationStreamInputRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists Instances in a given project and location.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets details of a single Instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Adds target stream input to the Application.
	// If the Application is deployed, the corresponding new Application instance
	// will be created. If the stream has already been in the Application, the RPC
	// will fail.
	CreateApplicationInstances(ctx context.Context, in *CreateApplicationInstancesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Remove target stream input to the Application, if the Application is
	// deployed, the corresponding instance based will be deleted. If the stream
	// is not in the Application, the RPC will fail.
	DeleteApplicationInstances(ctx context.Context, in *DeleteApplicationInstancesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Adds target stream input to the Application.
	// If the Application is deployed, the corresponding new Application instance
	// will be created. If the stream has already been in the Application, the RPC
	// will fail.
	UpdateApplicationInstances(ctx context.Context, in *UpdateApplicationInstancesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists Drafts in a given project and location.
	ListDrafts(ctx context.Context, in *ListDraftsRequest, opts ...grpc.CallOption) (*ListDraftsResponse, error)
	// Gets details of a single Draft.
	GetDraft(ctx context.Context, in *GetDraftRequest, opts ...grpc.CallOption) (*Draft, error)
	// Creates a new Draft in a given project and location.
	CreateDraft(ctx context.Context, in *CreateDraftRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the parameters of a single Draft.
	UpdateDraft(ctx context.Context, in *UpdateDraftRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single Draft.
	DeleteDraft(ctx context.Context, in *DeleteDraftRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists Processors in a given project and location.
	ListProcessors(ctx context.Context, in *ListProcessorsRequest, opts ...grpc.CallOption) (*ListProcessorsResponse, error)
	// ListPrebuiltProcessors is a custom pass-through verb that Lists Prebuilt
	// Processors.
	ListPrebuiltProcessors(ctx context.Context, in *ListPrebuiltProcessorsRequest, opts ...grpc.CallOption) (*ListPrebuiltProcessorsResponse, error)
	// Gets details of a single Processor.
	GetProcessor(ctx context.Context, in *GetProcessorRequest, opts ...grpc.CallOption) (*Processor, error)
	// Creates a new Processor in a given project and location.
	CreateProcessor(ctx context.Context, in *CreateProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the parameters of a single Processor.
	UpdateProcessor(ctx context.Context, in *UpdateProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single Processor.
	DeleteProcessor(ctx context.Context, in *DeleteProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type appPlatformClient struct {
	cc grpc.ClientConnInterface
}

func NewAppPlatformClient(cc grpc.ClientConnInterface) AppPlatformClient {
	return &appPlatformClient{cc}
}

func (c *appPlatformClient) ListApplications(ctx context.Context, in *ListApplicationsRequest, opts ...grpc.CallOption) (*ListApplicationsResponse, error) {
	out := new(ListApplicationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/ListApplications", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) GetApplication(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*Application, error) {
	out := new(Application)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/GetApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) CreateApplication(ctx context.Context, in *CreateApplicationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/CreateApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) UpdateApplication(ctx context.Context, in *UpdateApplicationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/UpdateApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) DeleteApplication(ctx context.Context, in *DeleteApplicationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/DeleteApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) DeployApplication(ctx context.Context, in *DeployApplicationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/DeployApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) UndeployApplication(ctx context.Context, in *UndeployApplicationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/UndeployApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) AddApplicationStreamInput(ctx context.Context, in *AddApplicationStreamInputRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/AddApplicationStreamInput", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) RemoveApplicationStreamInput(ctx context.Context, in *RemoveApplicationStreamInputRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/RemoveApplicationStreamInput", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) UpdateApplicationStreamInput(ctx context.Context, in *UpdateApplicationStreamInputRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/UpdateApplicationStreamInput", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) CreateApplicationInstances(ctx context.Context, in *CreateApplicationInstancesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/CreateApplicationInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) DeleteApplicationInstances(ctx context.Context, in *DeleteApplicationInstancesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/DeleteApplicationInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) UpdateApplicationInstances(ctx context.Context, in *UpdateApplicationInstancesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/UpdateApplicationInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) ListDrafts(ctx context.Context, in *ListDraftsRequest, opts ...grpc.CallOption) (*ListDraftsResponse, error) {
	out := new(ListDraftsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/ListDrafts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) GetDraft(ctx context.Context, in *GetDraftRequest, opts ...grpc.CallOption) (*Draft, error) {
	out := new(Draft)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/GetDraft", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) CreateDraft(ctx context.Context, in *CreateDraftRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/CreateDraft", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) UpdateDraft(ctx context.Context, in *UpdateDraftRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/UpdateDraft", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) DeleteDraft(ctx context.Context, in *DeleteDraftRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/DeleteDraft", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) ListProcessors(ctx context.Context, in *ListProcessorsRequest, opts ...grpc.CallOption) (*ListProcessorsResponse, error) {
	out := new(ListProcessorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/ListProcessors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) ListPrebuiltProcessors(ctx context.Context, in *ListPrebuiltProcessorsRequest, opts ...grpc.CallOption) (*ListPrebuiltProcessorsResponse, error) {
	out := new(ListPrebuiltProcessorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/ListPrebuiltProcessors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) GetProcessor(ctx context.Context, in *GetProcessorRequest, opts ...grpc.CallOption) (*Processor, error) {
	out := new(Processor)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/GetProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) CreateProcessor(ctx context.Context, in *CreateProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/CreateProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) UpdateProcessor(ctx context.Context, in *UpdateProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/UpdateProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appPlatformClient) DeleteProcessor(ctx context.Context, in *DeleteProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.AppPlatform/DeleteProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AppPlatformServer is the server API for AppPlatform service.
type AppPlatformServer interface {
	// Lists Applications in a given project and location.
	ListApplications(context.Context, *ListApplicationsRequest) (*ListApplicationsResponse, error)
	// Gets details of a single Application.
	GetApplication(context.Context, *GetApplicationRequest) (*Application, error)
	// Creates a new Application in a given project and location.
	CreateApplication(context.Context, *CreateApplicationRequest) (*longrunning.Operation, error)
	// Updates the parameters of a single Application.
	UpdateApplication(context.Context, *UpdateApplicationRequest) (*longrunning.Operation, error)
	// Deletes a single Application.
	DeleteApplication(context.Context, *DeleteApplicationRequest) (*longrunning.Operation, error)
	// Deploys a single Application.
	DeployApplication(context.Context, *DeployApplicationRequest) (*longrunning.Operation, error)
	// Undeploys a single Application.
	UndeployApplication(context.Context, *UndeployApplicationRequest) (*longrunning.Operation, error)
	// Adds target stream input to the Application.
	// If the Application is deployed, the corresponding new Application instance
	// will be created. If the stream has already been in the Application, the RPC
	// will fail.
	AddApplicationStreamInput(context.Context, *AddApplicationStreamInputRequest) (*longrunning.Operation, error)
	// Remove target stream input to the Application, if the Application is
	// deployed, the corresponding instance based will be deleted. If the stream
	// is not in the Application, the RPC will fail.
	RemoveApplicationStreamInput(context.Context, *RemoveApplicationStreamInputRequest) (*longrunning.Operation, error)
	// Update target stream input to the Application, if the Application is
	// deployed, the corresponding instance based will be deployed. For
	// CreateOrUpdate behavior, set allow_missing to true.
	UpdateApplicationStreamInput(context.Context, *UpdateApplicationStreamInputRequest) (*longrunning.Operation, error)
	// Lists Instances in a given project and location.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets details of a single Instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Adds target stream input to the Application.
	// If the Application is deployed, the corresponding new Application instance
	// will be created. If the stream has already been in the Application, the RPC
	// will fail.
	CreateApplicationInstances(context.Context, *CreateApplicationInstancesRequest) (*longrunning.Operation, error)
	// Remove target stream input to the Application, if the Application is
	// deployed, the corresponding instance based will be deleted. If the stream
	// is not in the Application, the RPC will fail.
	DeleteApplicationInstances(context.Context, *DeleteApplicationInstancesRequest) (*longrunning.Operation, error)
	// Adds target stream input to the Application.
	// If the Application is deployed, the corresponding new Application instance
	// will be created. If the stream has already been in the Application, the RPC
	// will fail.
	UpdateApplicationInstances(context.Context, *UpdateApplicationInstancesRequest) (*longrunning.Operation, error)
	// Lists Drafts in a given project and location.
	ListDrafts(context.Context, *ListDraftsRequest) (*ListDraftsResponse, error)
	// Gets details of a single Draft.
	GetDraft(context.Context, *GetDraftRequest) (*Draft, error)
	// Creates a new Draft in a given project and location.
	CreateDraft(context.Context, *CreateDraftRequest) (*longrunning.Operation, error)
	// Updates the parameters of a single Draft.
	UpdateDraft(context.Context, *UpdateDraftRequest) (*longrunning.Operation, error)
	// Deletes a single Draft.
	DeleteDraft(context.Context, *DeleteDraftRequest) (*longrunning.Operation, error)
	// Lists Processors in a given project and location.
	ListProcessors(context.Context, *ListProcessorsRequest) (*ListProcessorsResponse, error)
	// ListPrebuiltProcessors is a custom pass-through verb that Lists Prebuilt
	// Processors.
	ListPrebuiltProcessors(context.Context, *ListPrebuiltProcessorsRequest) (*ListPrebuiltProcessorsResponse, error)
	// Gets details of a single Processor.
	GetProcessor(context.Context, *GetProcessorRequest) (*Processor, error)
	// Creates a new Processor in a given project and location.
	CreateProcessor(context.Context, *CreateProcessorRequest) (*longrunning.Operation, error)
	// Updates the parameters of a single Processor.
	UpdateProcessor(context.Context, *UpdateProcessorRequest) (*longrunning.Operation, error)
	// Deletes a single Processor.
	DeleteProcessor(context.Context, *DeleteProcessorRequest) (*longrunning.Operation, error)
}

// UnimplementedAppPlatformServer can be embedded to have forward compatible implementations.
type UnimplementedAppPlatformServer struct {
}

func (*UnimplementedAppPlatformServer) ListApplications(context.Context, *ListApplicationsRequest) (*ListApplicationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApplications not implemented")
}
func (*UnimplementedAppPlatformServer) GetApplication(context.Context, *GetApplicationRequest) (*Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApplication not implemented")
}
func (*UnimplementedAppPlatformServer) CreateApplication(context.Context, *CreateApplicationRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateApplication not implemented")
}
func (*UnimplementedAppPlatformServer) UpdateApplication(context.Context, *UpdateApplicationRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateApplication not implemented")
}
func (*UnimplementedAppPlatformServer) DeleteApplication(context.Context, *DeleteApplicationRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteApplication not implemented")
}
func (*UnimplementedAppPlatformServer) DeployApplication(context.Context, *DeployApplicationRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployApplication not implemented")
}
func (*UnimplementedAppPlatformServer) UndeployApplication(context.Context, *UndeployApplicationRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployApplication not implemented")
}
func (*UnimplementedAppPlatformServer) AddApplicationStreamInput(context.Context, *AddApplicationStreamInputRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddApplicationStreamInput not implemented")
}
func (*UnimplementedAppPlatformServer) RemoveApplicationStreamInput(context.Context, *RemoveApplicationStreamInputRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveApplicationStreamInput not implemented")
}
func (*UnimplementedAppPlatformServer) UpdateApplicationStreamInput(context.Context, *UpdateApplicationStreamInputRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateApplicationStreamInput not implemented")
}
func (*UnimplementedAppPlatformServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedAppPlatformServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (*UnimplementedAppPlatformServer) CreateApplicationInstances(context.Context, *CreateApplicationInstancesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateApplicationInstances not implemented")
}
func (*UnimplementedAppPlatformServer) DeleteApplicationInstances(context.Context, *DeleteApplicationInstancesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteApplicationInstances not implemented")
}
func (*UnimplementedAppPlatformServer) UpdateApplicationInstances(context.Context, *UpdateApplicationInstancesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateApplicationInstances not implemented")
}
func (*UnimplementedAppPlatformServer) ListDrafts(context.Context, *ListDraftsRequest) (*ListDraftsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDrafts not implemented")
}
func (*UnimplementedAppPlatformServer) GetDraft(context.Context, *GetDraftRequest) (*Draft, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDraft not implemented")
}
func (*UnimplementedAppPlatformServer) CreateDraft(context.Context, *CreateDraftRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDraft not implemented")
}
func (*UnimplementedAppPlatformServer) UpdateDraft(context.Context, *UpdateDraftRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDraft not implemented")
}
func (*UnimplementedAppPlatformServer) DeleteDraft(context.Context, *DeleteDraftRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDraft not implemented")
}
func (*UnimplementedAppPlatformServer) ListProcessors(context.Context, *ListProcessorsRequest) (*ListProcessorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProcessors not implemented")
}
func (*UnimplementedAppPlatformServer) ListPrebuiltProcessors(context.Context, *ListPrebuiltProcessorsRequest) (*ListPrebuiltProcessorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrebuiltProcessors not implemented")
}
func (*UnimplementedAppPlatformServer) GetProcessor(context.Context, *GetProcessorRequest) (*Processor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcessor not implemented")
}
func (*UnimplementedAppPlatformServer) CreateProcessor(context.Context, *CreateProcessorRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProcessor not implemented")
}
func (*UnimplementedAppPlatformServer) UpdateProcessor(context.Context, *UpdateProcessorRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProcessor not implemented")
}
func (*UnimplementedAppPlatformServer) DeleteProcessor(context.Context, *DeleteProcessorRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProcessor not implemented")
}

func RegisterAppPlatformServer(s *grpc.Server, srv AppPlatformServer) {
	s.RegisterService(&_AppPlatform_serviceDesc, srv)
}

func _AppPlatform_ListApplications_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).ListApplications(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/ListApplications",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).ListApplications(ctx, req.(*ListApplicationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_GetApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).GetApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/GetApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).GetApplication(ctx, req.(*GetApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_CreateApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).CreateApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/CreateApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).CreateApplication(ctx, req.(*CreateApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_UpdateApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).UpdateApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/UpdateApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).UpdateApplication(ctx, req.(*UpdateApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_DeleteApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).DeleteApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/DeleteApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).DeleteApplication(ctx, req.(*DeleteApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_DeployApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).DeployApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/DeployApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).DeployApplication(ctx, req.(*DeployApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_UndeployApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).UndeployApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/UndeployApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).UndeployApplication(ctx, req.(*UndeployApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_AddApplicationStreamInput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddApplicationStreamInputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).AddApplicationStreamInput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/AddApplicationStreamInput",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).AddApplicationStreamInput(ctx, req.(*AddApplicationStreamInputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_RemoveApplicationStreamInput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveApplicationStreamInputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).RemoveApplicationStreamInput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/RemoveApplicationStreamInput",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).RemoveApplicationStreamInput(ctx, req.(*RemoveApplicationStreamInputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_UpdateApplicationStreamInput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApplicationStreamInputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).UpdateApplicationStreamInput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/UpdateApplicationStreamInput",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).UpdateApplicationStreamInput(ctx, req.(*UpdateApplicationStreamInputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_CreateApplicationInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApplicationInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).CreateApplicationInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/CreateApplicationInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).CreateApplicationInstances(ctx, req.(*CreateApplicationInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_DeleteApplicationInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApplicationInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).DeleteApplicationInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/DeleteApplicationInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).DeleteApplicationInstances(ctx, req.(*DeleteApplicationInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_UpdateApplicationInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApplicationInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).UpdateApplicationInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/UpdateApplicationInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).UpdateApplicationInstances(ctx, req.(*UpdateApplicationInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_ListDrafts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDraftsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).ListDrafts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/ListDrafts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).ListDrafts(ctx, req.(*ListDraftsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_GetDraft_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDraftRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).GetDraft(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/GetDraft",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).GetDraft(ctx, req.(*GetDraftRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_CreateDraft_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDraftRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).CreateDraft(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/CreateDraft",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).CreateDraft(ctx, req.(*CreateDraftRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_UpdateDraft_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDraftRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).UpdateDraft(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/UpdateDraft",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).UpdateDraft(ctx, req.(*UpdateDraftRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_DeleteDraft_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDraftRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).DeleteDraft(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/DeleteDraft",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).DeleteDraft(ctx, req.(*DeleteDraftRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_ListProcessors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).ListProcessors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/ListProcessors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).ListProcessors(ctx, req.(*ListProcessorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_ListPrebuiltProcessors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrebuiltProcessorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).ListPrebuiltProcessors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/ListPrebuiltProcessors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).ListPrebuiltProcessors(ctx, req.(*ListPrebuiltProcessorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_GetProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).GetProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/GetProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).GetProcessor(ctx, req.(*GetProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_CreateProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).CreateProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/CreateProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).CreateProcessor(ctx, req.(*CreateProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_UpdateProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).UpdateProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/UpdateProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).UpdateProcessor(ctx, req.(*UpdateProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppPlatform_DeleteProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppPlatformServer).DeleteProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.AppPlatform/DeleteProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppPlatformServer).DeleteProcessor(ctx, req.(*DeleteProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AppPlatform_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.visionai.v1alpha1.AppPlatform",
	HandlerType: (*AppPlatformServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListApplications",
			Handler:    _AppPlatform_ListApplications_Handler,
		},
		{
			MethodName: "GetApplication",
			Handler:    _AppPlatform_GetApplication_Handler,
		},
		{
			MethodName: "CreateApplication",
			Handler:    _AppPlatform_CreateApplication_Handler,
		},
		{
			MethodName: "UpdateApplication",
			Handler:    _AppPlatform_UpdateApplication_Handler,
		},
		{
			MethodName: "DeleteApplication",
			Handler:    _AppPlatform_DeleteApplication_Handler,
		},
		{
			MethodName: "DeployApplication",
			Handler:    _AppPlatform_DeployApplication_Handler,
		},
		{
			MethodName: "UndeployApplication",
			Handler:    _AppPlatform_UndeployApplication_Handler,
		},
		{
			MethodName: "AddApplicationStreamInput",
			Handler:    _AppPlatform_AddApplicationStreamInput_Handler,
		},
		{
			MethodName: "RemoveApplicationStreamInput",
			Handler:    _AppPlatform_RemoveApplicationStreamInput_Handler,
		},
		{
			MethodName: "UpdateApplicationStreamInput",
			Handler:    _AppPlatform_UpdateApplicationStreamInput_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _AppPlatform_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _AppPlatform_GetInstance_Handler,
		},
		{
			MethodName: "CreateApplicationInstances",
			Handler:    _AppPlatform_CreateApplicationInstances_Handler,
		},
		{
			MethodName: "DeleteApplicationInstances",
			Handler:    _AppPlatform_DeleteApplicationInstances_Handler,
		},
		{
			MethodName: "UpdateApplicationInstances",
			Handler:    _AppPlatform_UpdateApplicationInstances_Handler,
		},
		{
			MethodName: "ListDrafts",
			Handler:    _AppPlatform_ListDrafts_Handler,
		},
		{
			MethodName: "GetDraft",
			Handler:    _AppPlatform_GetDraft_Handler,
		},
		{
			MethodName: "CreateDraft",
			Handler:    _AppPlatform_CreateDraft_Handler,
		},
		{
			MethodName: "UpdateDraft",
			Handler:    _AppPlatform_UpdateDraft_Handler,
		},
		{
			MethodName: "DeleteDraft",
			Handler:    _AppPlatform_DeleteDraft_Handler,
		},
		{
			MethodName: "ListProcessors",
			Handler:    _AppPlatform_ListProcessors_Handler,
		},
		{
			MethodName: "ListPrebuiltProcessors",
			Handler:    _AppPlatform_ListPrebuiltProcessors_Handler,
		},
		{
			MethodName: "GetProcessor",
			Handler:    _AppPlatform_GetProcessor_Handler,
		},
		{
			MethodName: "CreateProcessor",
			Handler:    _AppPlatform_CreateProcessor_Handler,
		},
		{
			MethodName: "UpdateProcessor",
			Handler:    _AppPlatform_UpdateProcessor_Handler,
		},
		{
			MethodName: "DeleteProcessor",
			Handler:    _AppPlatform_DeleteProcessor_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/visionai/v1alpha1/platform.proto",
}
