---
layout: post
title: "Cap'n Proto 0.5: Generics, Visual C++, Java, C#, Sandstorm.io"
author: kentonv
---

Today we're releasing Cap'n Proto 0.5. We've added lots of goodies!

### Finally: Visual Studio

Microsoft Visual Studio 2015 (currently in "preview") finally supports enough C++11 to get Cap'n
Proto working, and we've duly added official support for it!

Not all features are supported yet. The core serialization functionality sufficient for 90% of users
is available, but reflection and RPC APIs are not. We will turn on these APIs as soon as Visual C++
is ready (the main blocker is incomplete `constexpr` support).

As part of this, we now support CMake as a build system, and it can be used on Unix as well.

In related news, for Windows users not interested in C++ but who need the Cap'n Proto tools for
other languages, we now provide precompiled Windows binaries. See
[the installation page]({{site.baseurl}}install.html).

I'd like to thank [Bryan Boreham](https://github.com/bboreham),
[Joshua Warner](https://github.com/joshuawarner32), and [Phillip Quinn](https://github.com/pqu) for
their help in getting this working.

### C#, Java

While not strictly part of this release, our two biggest missing languages recently gained support
for Cap'n Proto:

* [Marc Gravell](https://github.com/mgravell) -- the man responsible for the most popular C#
  implementation of Protobufs -- has now implemented
  [Cap'n Proto in C#](https://github.com/mgravell/capnproto-net).
* [David Renshaw](https://github.com/dwrensha), author of our existing Rust implementation and
  [Sandstorm.io](https://sandstorm.io) core developer, has implemented
  [Cap'n Proto in Java](https://github.com/dwrensha/capnproto-java).

### Generics

Cap'n Proto now supports [generics]({{site.baseurl}}language.html#generic-types),
in the sense of Java generics or C++ templates. While working on
[Sandstorm.io](https://sandstorm.io) we frequently found that we wanted this, and it turned out
to be easy to support.

This is a feature which Protocol Buffers does not support and likely never will. Cap'n Proto has a
much easier time supporting exotic language features because the generated code is so simple. In
C++, nearly all Cap'n Proto generated code is inline accessor methods, which can easily become
templates. Protocol Buffers, in contrast, has generated parse and serialize functions and a host
of other auxiliary stuff, which is too complex to inline and thus would need to be adapted to
generics without using C++ templates. This would get ugly fast.

Generics are not yet supported by all Cap'n Proto language implementations, but where they are not
supported, things degrade gracefully: all type parameters simply become `AnyPointer`. You can still
use generics in your schemas as documentation. Meanwhile, at least our C++, Java, and Python
implementations have already been updated to support generics, and other implementations that
wrap the C++ reflection API are likely to work too.

### Canonicalization

0.5 introduces a (backwards-compatible) change in
[the way struct lists should be encoded]({{site.baseurl}}encoding.html#lists), in
order to support [canonicalization]({{site.baseurl}}encoding.html#canonicalization).
We believe this will make Cap'n Proto more appropriate for use in cryptographic protocols. If
you've implemented Cap'n Proto in another language, please update your code!

### Sandstorm and Capability Systems

[Sandstorm.io](https://sandstorm.io) is Cap'n Proto's parent project: a platform for personal
servers that is radically easier and more secure.

Cap'n Proto RPC is the underlying communications layer powering Sandstorm. Sandstorm is a
[capability system](http://www.erights.org/elib/capability/overview.html): applications can send
each other object references and address messages to those objects. Messages can themselves contain
new object references, and the recipient implicitly gains permission to use any object reference
they receive. Essentially, Sandstorm allows the interfaces between two apps, or between and app
and the platform, to be designed using the same vocabulary as interfaces between objects or
libraries in an object-oriented programming language (but
[without the mistakes of CORBA or DCOM]({{site.baseurl}}rpc.html#distributed-objects)).
Cap'n Proto RPC is at the core of this.

This has powerful implications: Consider the case of service discovery. On Sandstorm, all
applications start out isolated from each other in secure containers. However, applications can
(or, will be able to) publish Cap'n Proto object references to the system representing APIs they
support. Then, another app can make a request to the system, saying "I need an object that
implements interface Foo". At this point, the system can display a picker UI to the user,
presenting all objects the user owns that satisfy the requirement. However, the requesting app only
ever receives a reference to the object the user chooses; all others remain hidden. Thus, security
becomes "automatic". The user does not have to edit an ACL on the providing app, nor copy around
credentials, nor even answer any security question at all; it all derives automatically and
naturally from the user's choices. We call this interface "The Powerbox".

Moreover, because Sandstorm is fully aware of the object references held by every app, it will
be able to display a visualization of these connections, allowing a user to quickly see which of
their apps have access to each other and even revoke connections that are no longer desired with
a mouse click.

Cap'n Proto 0.5 introduces primitives to support "persistent" capabilities -- that is, the ability
to "save" an object reference to disk and then restore it later, on a different connection.
Obviously, the features described above totally depend on this feature.

The next release of Cap'n Proto is likely to include another feature essential for Sandstorm: the
ability to pass capabilities from machine to machine and have Cap'n Proto automatically form direct
connections when you do. This allows servers running on different machines to interact with each
other in a completely object-oriented way. Instead of passing around URLs (which necessitate a
global namespace, lifetime management, firewall traversal, and all sorts of other obstacles), you
can pass around capabilities and not worry about it. This will be central to Sandstorm's strategies
for federation and cluster management.

### Other notes

* The C++ RPC code now uses `epoll` on Linux.
* We now test Cap'n Proto on Android and MinGW, in addition to Linux, Mac OSX, Cygwin, and Visual
  Studio. (iOS and FreeBSD are also reported to work, though are not yet part of our testing
  process.)
