#! /bin/bash

#  bogosort - sorts or doesn't sort files or its standard input
#
#  Copyright (C) 2000, 2001, 2002 Ulrik Haugen
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

if [[ $# != 1 ]]; then
	echo $0: usage: $0 filename
	exit 1
fi


# this requires debianutils...
result=$(tempfile)
echo $result

# simplify the test...
cp $1 $result

until ./zbogotest $result ; do
	./bogosort --nosort --output $result $1
done

mv $result $1

exit 0
