/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.CleanupActionFactory;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.VersionStrategy;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.caching.local.internal.DirectoryBuildCacheFileStoreFactory;
import org.gradle.caching.local.internal.DirectoryBuildCacheService;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.resource.local.FileAccessTimeJournal;
import org.gradle.internal.resource.local.FileAccessTracker;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.resource.local.SingleDepthFileAccessTracker;

public class DirectoryBuildCacheServiceFactory
implements BuildCacheServiceFactory<DirectoryBuildCache> {
    public static final String FAILED_READ_SUFFIX = ".failed";
    private static final String BUILD_CACHE_VERSION = "1";
    private static final String BUILD_CACHE_KEY = "build-cache-1";
    private static final String DIRECTORY_BUILD_CACHE_TYPE = "directory";
    private static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final CacheRepository cacheRepository;
    private final CacheScopeMapping cacheScopeMapping;
    private final PathToFileResolver resolver;
    private final DirectoryBuildCacheFileStoreFactory fileStoreFactory;
    private final CleanupActionFactory cleanupActionFactory;
    private final FileAccessTimeJournal fileAccessTimeJournal;

    @Inject
    public DirectoryBuildCacheServiceFactory(CacheRepository cacheRepository, CacheScopeMapping cacheScopeMapping, PathToFileResolver resolver, DirectoryBuildCacheFileStoreFactory fileStoreFactory, CleanupActionFactory cleanupActionFactory, FileAccessTimeJournal fileAccessTimeJournal) {
        this.cacheRepository = cacheRepository;
        this.cacheScopeMapping = cacheScopeMapping;
        this.resolver = resolver;
        this.fileStoreFactory = fileStoreFactory;
        this.cleanupActionFactory = cleanupActionFactory;
        this.fileAccessTimeJournal = fileAccessTimeJournal;
    }

    @Override
    public BuildCacheService createBuildCacheService(DirectoryBuildCache configuration, BuildCacheServiceFactory.Describer describer) {
        Object cacheDirectory = configuration.getDirectory();
        File target = cacheDirectory != null ? this.resolver.resolve(cacheDirectory) : this.cacheScopeMapping.getBaseDirectory(null, BUILD_CACHE_KEY, VersionStrategy.SharedCache);
        DirectoryBuildCacheServiceFactory.checkDirectory(target);
        int removeUnusedEntriesAfterDays = configuration.getRemoveUnusedEntriesAfterDays();
        describer.type(DIRECTORY_BUILD_CACHE_TYPE).config("location", target.getAbsolutePath()).config("removeUnusedEntriesAfter", String.valueOf(removeUnusedEntriesAfterDays) + " days");
        PathKeyFileStore fileStore = this.fileStoreFactory.createFileStore(target);
        PersistentCache persistentCache = this.cacheRepository.cache(target).withCleanup(this.cleanupActionFactory.create((CleanupAction)new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(1), this.fileAccessTimeJournal, (long)removeUnusedEntriesAfterDays))).withDisplayName("Build cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).open();
        DefaultBuildCacheTempFileStore tempFileStore = new DefaultBuildCacheTempFileStore(target);
        SingleDepthFileAccessTracker fileAccessTracker = new SingleDepthFileAccessTracker(this.fileAccessTimeJournal, target, 1);
        return new DirectoryBuildCacheService(fileStore, persistentCache, tempFileStore, (FileAccessTracker)fileAccessTracker, FAILED_READ_SUFFIX);
    }

    private static void checkDirectory(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be a directory", directory));
            }
            if (!directory.canRead()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be readable", directory));
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be writable", directory));
            }
        } else if (!directory.mkdirs()) {
            throw new UncheckedIOException(String.format("Could not create cache directory: %s", directory));
        }
    }
}

