/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class LightPackageReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    private final String myPackageName;
    private final PsiPackage myRefPackage;

    public LightPackageReference(PsiManager manager, PsiPackage refPackage) {
        super(manager, JavaLanguage.INSTANCE);
        this.myPackageName = null;
        this.myRefPackage = refPackage;
    }

    public LightPackageReference(PsiManager manager, String packageName) {
        super(manager, JavaLanguage.INSTANCE);
        this.myPackageName = packageName;
        this.myRefPackage = null;
    }

    @Override
    public PsiElement resolve() {
        if (this.myPackageName != null) {
            return JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.myPackageName);
        }
        return this.myRefPackage;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolve2 = this.resolve();
        JavaResolveResult javaResolveResult = resolve2 == null ? JavaResolveResult.EMPTY : new CandidateInfo(resolve2, PsiSubstitutor.EMPTY);
        if (javaResolveResult == null) {
            LightPackageReference.$$$reportNull$$$0(0);
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult result2 = this.advancedResolve(incompleteCode);
        if (result2 != JavaResolveResult.EMPTY) {
            JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{result2};
            if (javaResolveResultArray == null) {
                LightPackageReference.$$$reportNull$$$0(1);
            }
            return javaResolveResultArray;
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            LightPackageReference.$$$reportNull$$$0(2);
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @Override
    public String getText() {
        if (this.myPackageName != null) {
            return this.myPackageName;
        }
        return this.myRefPackage.getQualifiedName();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            LightPackageReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public PsiElement copy() {
        if (this.myPackageName != null) {
            return new LightPackageReference(this.myManager, this.myPackageName);
        }
        return new LightPackageReference(this.myManager, this.myRefPackage);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            LightPackageReference.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            LightPackageReference.$$$reportNull$$$0(5);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiPackage)) {
            return false;
        }
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        if (processor2 == null) {
            LightPackageReference.$$$reportNull$$$0(6);
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getText();
    }

    @Override
    public String getReferenceName() {
        if (this.myPackageName != null) {
            return PsiNameHelper.getShortClassName(this.myPackageName);
        }
        return this.myRefPackage.getName();
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public boolean isValid() {
        return this.myRefPackage == null || this.myRefPackage.isValid();
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            LightPackageReference.$$$reportNull$$$0(7);
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPackageReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightPackageReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

