# Completions for nvr in fish shell
# To install, save file to completions directory of fish config (e.g. ~/.config/fish/completions/nvr.fish)

complete --command=nvr --long-option=remote --description='Use :edit to open files. If no process is found, throw an error and start a new one'
complete --command=nvr --long-option=remote-wait --description='Like --remote, but block until all buffers opened by this option get deleted or the process exits'
complete --command=nvr --long-option=remote-silent --description='Like --remote, but throw no error if no process is found'
complete --command=nvr --long-option=remote-wait-silent --description='Combines --remote-wait and --remote-silent'
complete --command=nvr --long-option=remote-tab --description='Like --remote, but use :tabedit'
complete --command=nvr --long-option=remote-tab-wait --description='Like --remote-wait, but use :tabedit'
complete --command=nvr --long-option=remote-tab-silent --description='Like --remote-silent, but use :tabedit'
complete --command=nvr --long-option=remote-tab-wait-silent --description='Like --remote-wait-silent, but use :tabedit'
complete --command=nvr --long-option=remote-send --no-files --description='Send key presses'
complete --command=nvr --long-option=remote-expr --no-files --description='Evaluate expression and print result in shell'
complete --command=nvr --long-option=servername --no-files --arguments='(nvr --serverlist)' --description='Set the address to be used. This overrides the default "/tmp/nvimsocket" and $NVIM_LISTEN_ADDRESS'
complete --command=nvr --long-option=serverlist --description='Print the TCPv4 and Unix domain socket addresses of all nvim processes'
complete --command=nvr --short-option=h --long-option=help --description='show help message and exit'
complete --command=nvr --short-option=c --no-files --description='Execute a command after every other option'
complete --command=nvr --short-option=d --description='Diff mode. Use :diffthis on all to be opened buffers'
complete --command=nvr --short-option=l --description='Change to previous window via ":wincmd p"'
complete --command=nvr --short-option=o --description='Open files via ":split"'
complete --command=nvr --short-option=O --description='Open files via ":vsplit"'
complete --command=nvr --short-option=p --description='Open files via ":tabedit"'
complete --command=nvr --short-option=q --description='Read errorfile into quickfix list and display first error'
complete --command=nvr --short-option=s --description='Silence "no server found" message'
complete --command=nvr --short-option=t --no-files --description='Jump to file and position of given tag'
complete --command=nvr --long-option=nostart --description='If no process is found, do not start a new one'
complete --command=nvr --long-option=version --description='Show the nvr version'
complete --command=nvr --old-option=cc --description='Execute a command before every other option'
