// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Orchestration and serialization glue logic for `ListObjectVersions`.
#[derive(::std::clone::Clone, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ListObjectVersions;
impl ListObjectVersions {
    /// Creates a new `ListObjectVersions`
    pub fn new() -> Self {
        Self
    }
    pub(crate) async fn orchestrate(
        runtime_plugins: &::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        input: crate::operation::list_object_versions::ListObjectVersionsInput,
    ) -> ::std::result::Result<
        crate::operation::list_object_versions::ListObjectVersionsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_object_versions::ListObjectVersionsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let map_err = |err: ::aws_smithy_runtime_api::client::result::SdkError<
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >| {
            err.map_service_error(|err| {
                err.downcast::<crate::operation::list_object_versions::ListObjectVersionsError>()
                    .expect("correct error type")
            })
        };
        let context = Self::orchestrate_with_stop_point(runtime_plugins, input, ::aws_smithy_runtime::client::orchestrator::StopPoint::None)
            .await
            .map_err(map_err)?;
        let output = context.finalize().map_err(map_err)?;
        ::std::result::Result::Ok(
            output
                .downcast::<crate::operation::list_object_versions::ListObjectVersionsOutput>()
                .expect("correct output type"),
        )
    }

    pub(crate) async fn orchestrate_with_stop_point(
        runtime_plugins: &::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        input: crate::operation::list_object_versions::ListObjectVersionsInput,
        stop_point: ::aws_smithy_runtime::client::orchestrator::StopPoint,
    ) -> ::std::result::Result<
        ::aws_smithy_runtime_api::client::interceptors::context::InterceptorContext,
        ::aws_smithy_runtime_api::client::result::SdkError<
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = ::aws_smithy_runtime_api::client::interceptors::context::Input::erase(input);
        use ::tracing::Instrument;
        ::aws_smithy_runtime::client::orchestrator::invoke_with_stop_point("S3", "ListObjectVersions", input, runtime_plugins, stop_point)
            // Create a parent span for the entire operation. Includes a random, internal-only,
            // seven-digit ID for the operation orchestration so that it can be correlated in the logs.
            .instrument(::tracing::debug_span!(
                "S3.ListObjectVersions",
                "rpc.service" = "S3",
                "rpc.method" = "ListObjectVersions",
                "sdk_invocation_id" = ::fastrand::u32(1_000_000..10_000_000),
                "rpc.system" = "aws-api",
            ))
            .await
    }

    pub(crate) fn operation_runtime_plugins(
        client_runtime_plugins: ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        client_config: &crate::config::Config,
        config_override: ::std::option::Option<crate::config::Builder>,
    ) -> ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins {
        let mut runtime_plugins = client_runtime_plugins.with_operation_plugin(Self::new());

        if let ::std::option::Option::Some(config_override) = config_override {
            for plugin in config_override.runtime_plugins.iter().cloned() {
                runtime_plugins = runtime_plugins.with_operation_plugin(plugin);
            }
            runtime_plugins = runtime_plugins.with_operation_plugin(crate::config::ConfigOverrideRuntimePlugin::new(
                config_override,
                client_config.config.clone(),
                &client_config.runtime_components,
            ));
        }
        runtime_plugins
    }
}
impl ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugin for ListObjectVersions {
    fn config(&self) -> ::std::option::Option<::aws_smithy_types::config_bag::FrozenLayer> {
        let mut cfg = ::aws_smithy_types::config_bag::Layer::new("ListObjectVersions");

        cfg.store_put(::aws_smithy_runtime_api::client::ser_de::SharedRequestSerializer::new(
            ListObjectVersionsRequestSerializer,
        ));
        cfg.store_put(::aws_smithy_runtime_api::client::ser_de::SharedResponseDeserializer::new(
            ListObjectVersionsResponseDeserializer,
        ));

        cfg.store_put(::aws_smithy_runtime_api::client::auth::AuthSchemeOptionResolverParams::new(
            crate::config::auth::Params::builder()
                .operation_name("ListObjectVersions")
                .build()
                .expect("required fields set"),
        ));

        cfg.store_put(::aws_smithy_runtime_api::client::orchestrator::Metadata::new("ListObjectVersions", "S3"));
        let mut signing_options = ::aws_runtime::auth::SigningOptions::default();
        signing_options.double_uri_encode = false;
        signing_options.content_sha256_header = true;
        signing_options.normalize_uri_path = false;
        signing_options.payload_override = None;

        cfg.store_put(::aws_runtime::auth::SigV4OperationSigningConfig {
            signing_options,
            ..::std::default::Default::default()
        });

        ::std::option::Option::Some(cfg.freeze())
    }

    fn runtime_components(
        &self,
        _: &::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder,
    ) -> ::std::borrow::Cow<'_, ::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder> {
        #[allow(unused_mut)]
                    let mut rcb = ::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder::new("ListObjectVersions")
                            .with_interceptor(::aws_smithy_runtime::client::stalled_stream_protection::StalledStreamProtectionInterceptor::default())
.with_interceptor(ListObjectVersionsEndpointParamsInterceptor)
                            .with_retry_classifier(::aws_smithy_runtime::client::retries::classifiers::TransientErrorClassifier::<crate::operation::list_object_versions::ListObjectVersionsError>::new())
.with_retry_classifier(::aws_smithy_runtime::client::retries::classifiers::ModeledAsRetryableClassifier::<crate::operation::list_object_versions::ListObjectVersionsError>::new())
.with_retry_classifier(::aws_runtime::retries::classifiers::AwsErrorCodeClassifier::<crate::operation::list_object_versions::ListObjectVersionsError>::builder().transient_errors({
                                            let mut transient_errors: Vec<&'static str> = ::aws_runtime::retries::classifiers::TRANSIENT_ERRORS.into();
                                            transient_errors.push("InternalError");
                                            ::std::borrow::Cow::Owned(transient_errors)
                                            }).build());

        ::std::borrow::Cow::Owned(rcb)
    }
}

#[derive(Debug)]
struct ListObjectVersionsResponseDeserializer;
impl ::aws_smithy_runtime_api::client::ser_de::DeserializeResponse for ListObjectVersionsResponseDeserializer {
    fn deserialize_nonstreaming(
        &self,
        response: &::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
    ) -> ::aws_smithy_runtime_api::client::interceptors::context::OutputOrError {
        let (success, status) = (response.status().is_success(), response.status().as_u16());
        let headers = response.headers();
        let body = response.body().bytes().expect("body loaded");
        #[allow(unused_mut)]
        let mut force_error = false;
        ::tracing::debug!(extended_request_id = ?crate::s3_request_id::RequestIdExt::extended_request_id(response));
        if matches!(crate::rest_xml_unwrapped_errors::body_is_error(body), Ok(true)) {
            force_error = true;
        }
        ::tracing::debug!(request_id = ?::aws_types::request_id::RequestId::request_id(response));
        let parse_result = if !success && status != 200 || force_error {
            crate::protocol_serde::shape_list_object_versions::de_list_object_versions_http_error(status, headers, body)
        } else {
            crate::protocol_serde::shape_list_object_versions::de_list_object_versions_http_response(status, headers, body)
        };
        crate::protocol_serde::type_erase_result(parse_result)
    }
}
#[derive(Debug)]
struct ListObjectVersionsRequestSerializer;
impl ::aws_smithy_runtime_api::client::ser_de::SerializeRequest for ListObjectVersionsRequestSerializer {
    #[allow(unused_mut, clippy::let_and_return, clippy::needless_borrow, clippy::useless_conversion)]
    fn serialize_input(
        &self,
        input: ::aws_smithy_runtime_api::client::interceptors::context::Input,
        _cfg: &mut ::aws_smithy_types::config_bag::ConfigBag,
    ) -> ::std::result::Result<::aws_smithy_runtime_api::client::orchestrator::HttpRequest, ::aws_smithy_runtime_api::box_error::BoxError> {
        let input = input
            .downcast::<crate::operation::list_object_versions::ListObjectVersionsInput>()
            .expect("correct type");
        let _header_serialization_settings = _cfg
            .load::<crate::serialization_settings::HeaderSerializationSettings>()
            .cloned()
            .unwrap_or_default();
        let mut request_builder = {
            fn uri_base(
                _input: &crate::operation::list_object_versions::ListObjectVersionsInput,
                output: &mut ::std::string::String,
            ) -> ::std::result::Result<(), ::aws_smithy_types::error::operation::BuildError> {
                use ::std::fmt::Write as _;
                ::std::write!(output, "/").expect("formatting should succeed");
                ::std::result::Result::Ok(())
            }
            fn uri_query(
                _input: &crate::operation::list_object_versions::ListObjectVersionsInput,
                mut output: &mut ::std::string::String,
            ) -> ::std::result::Result<(), ::aws_smithy_types::error::operation::BuildError> {
                let mut query = ::aws_smithy_http::query::Writer::new(output);
                query.push_v("versions");
                if let ::std::option::Option::Some(inner_1) = &_input.delimiter {
                    {
                        query.push_kv("delimiter", &::aws_smithy_http::query::fmt_string(inner_1));
                    }
                }
                if let ::std::option::Option::Some(inner_2) = &_input.encoding_type {
                    {
                        query.push_kv("encoding-type", &::aws_smithy_http::query::fmt_string(inner_2));
                    }
                }
                if let ::std::option::Option::Some(inner_3) = &_input.key_marker {
                    {
                        query.push_kv("key-marker", &::aws_smithy_http::query::fmt_string(inner_3));
                    }
                }
                if let ::std::option::Option::Some(inner_4) = &_input.max_keys {
                    {
                        query.push_kv("max-keys", ::aws_smithy_types::primitive::Encoder::from(*inner_4).encode());
                    }
                }
                if let ::std::option::Option::Some(inner_5) = &_input.prefix {
                    {
                        query.push_kv("prefix", &::aws_smithy_http::query::fmt_string(inner_5));
                    }
                }
                if let ::std::option::Option::Some(inner_6) = &_input.version_id_marker {
                    {
                        query.push_kv("version-id-marker", &::aws_smithy_http::query::fmt_string(inner_6));
                    }
                }
                ::std::result::Result::Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::operation::list_object_versions::ListObjectVersionsInput,
                builder: ::http::request::Builder,
            ) -> ::std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
                let mut uri = ::std::string::String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::protocol_serde::shape_list_object_versions::ser_list_object_versions_headers(input, builder)?;
                ::std::result::Result::Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&input, ::http::request::Builder::new())?;
            builder
        };
        let body = ::aws_smithy_types::body::SdkBody::from("");

        ::std::result::Result::Ok(request_builder.body(body).expect("valid request").try_into().unwrap())
    }
}
#[derive(Debug)]
struct ListObjectVersionsEndpointParamsInterceptor;

impl ::aws_smithy_runtime_api::client::interceptors::Intercept for ListObjectVersionsEndpointParamsInterceptor {
    fn name(&self) -> &'static str {
        "ListObjectVersionsEndpointParamsInterceptor"
    }

    fn read_before_execution(
        &self,
        context: &::aws_smithy_runtime_api::client::interceptors::context::BeforeSerializationInterceptorContextRef<
            '_,
            ::aws_smithy_runtime_api::client::interceptors::context::Input,
            ::aws_smithy_runtime_api::client::interceptors::context::Output,
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
        >,
        cfg: &mut ::aws_smithy_types::config_bag::ConfigBag,
    ) -> ::std::result::Result<(), ::aws_smithy_runtime_api::box_error::BoxError> {
        let _input = context
            .input()
            .downcast_ref::<ListObjectVersionsInput>()
            .ok_or("failed to downcast to ListObjectVersionsInput")?;

        let params = crate::config::endpoint::Params::builder()
            .set_region(cfg.load::<::aws_types::region::Region>().map(|r| r.as_ref().to_owned()))
            .set_use_fips(cfg.load::<::aws_types::endpoint_config::UseFips>().map(|ty| ty.0))
            .set_use_dual_stack(cfg.load::<::aws_types::endpoint_config::UseDualStack>().map(|ty| ty.0))
            .set_endpoint(cfg.load::<::aws_types::endpoint_config::EndpointUrl>().map(|ty| ty.0.clone()))
            .set_force_path_style(cfg.load::<crate::config::ForcePathStyle>().map(|ty| ty.0))
            .set_use_arn_region(cfg.load::<crate::config::UseArnRegion>().map(|ty| ty.0))
            .set_disable_multi_region_access_points(cfg.load::<crate::config::DisableMultiRegionAccessPoints>().map(|ty| ty.0))
            .set_accelerate(cfg.load::<crate::config::Accelerate>().map(|ty| ty.0))
            .set_disable_s3_express_session_auth(cfg.load::<crate::config::DisableS3ExpressSessionAuth>().map(|ty| ty.0))
            .set_bucket(Some(
                _input
                    .bucket
                    .clone()
                    .filter(|f| !AsRef::<str>::as_ref(f).trim().is_empty())
                    .ok_or_else(|| ::aws_smithy_types::error::operation::BuildError::missing_field("bucket", "A required field was not set"))?,
            ))
            .set_prefix(_input.prefix.clone())
            .build()
            .map_err(|err| {
                ::aws_smithy_runtime_api::client::interceptors::error::ContextAttachedError::new("endpoint params could not be built", err)
            })?;
        cfg.interceptor_state()
            .store_put(::aws_smithy_runtime_api::client::endpoint::EndpointResolverParams::new(params));
        ::std::result::Result::Ok(())
    }
}

// The get_* functions below are generated from JMESPath expressions in the
// operationContextParams trait. They target the operation's input shape.

#[allow(unreachable_code, unused_variables)]
#[cfg(test)]
mod list_object_versions_test {

    /// Verify that interleaving list elements (DeleteMarker and Version) from different lists works
    /// Test ID: OutOfOrderVersions
    #[::tokio::test]
    #[::tracing_test::traced_test]
    async fn out_of_order_versions_response() {
        let expected_output = crate::operation::list_object_versions::ListObjectVersionsOutput::builder()
            .set_name(::std::option::Option::Some("sdk-obj-versions-test".to_owned()))
            .set_prefix(::std::option::Option::Some("".to_owned()))
            .set_key_marker(::std::option::Option::Some("".to_owned()))
            .set_version_id_marker(::std::option::Option::Some("".to_owned()))
            .set_max_keys(::std::option::Option::Some(1000))
            .set_is_truncated(::std::option::Option::Some(false))
            .set_delete_markers(::std::option::Option::Some(vec![
                crate::types::DeleteMarkerEntry::builder()
                    .set_key(::std::option::Option::Some("build.gradle.kts".to_owned()))
                    .set_version_id(::std::option::Option::Some("null".to_owned()))
                    .set_is_latest(::std::option::Option::Some(true))
                    .set_last_modified(::std::option::Option::Some(::aws_smithy_types::DateTime::from_fractional_secs(
                        1234567890, 0_f64,
                    )))
                    .set_owner(::std::option::Option::Some(
                        crate::types::Owner::builder()
                            .set_id(::std::option::Option::Some(
                                "c1665459250c459f1849ddce9b291fc3a72bcf5220dc8f6391a0a1045c683b34".to_owned(),
                            ))
                            .set_display_name(::std::option::Option::Some("test-name".to_owned()))
                            .build(),
                    ))
                    .build(),
                crate::types::DeleteMarkerEntry::builder()
                    .set_key(::std::option::Option::Some("file-2".to_owned()))
                    .set_version_id(::std::option::Option::Some("o98RL6vmlOYiymftbX7wgy_4XWQG4AmY".to_owned()))
                    .set_is_latest(::std::option::Option::Some(true))
                    .set_last_modified(::std::option::Option::Some(::aws_smithy_types::DateTime::from_fractional_secs(
                        1234567890, 0_f64,
                    )))
                    .set_owner(::std::option::Option::Some(
                        crate::types::Owner::builder()
                            .set_id(::std::option::Option::Some(
                                "c1665459250c459f1849ddce9b291fc3a72bcf5220dc8f6391a0a1045c683b34".to_owned(),
                            ))
                            .set_display_name(::std::option::Option::Some("test-name".to_owned()))
                            .build(),
                    ))
                    .build(),
            ]))
            .set_versions(::std::option::Option::Some(vec![
                crate::types::ObjectVersion::builder()
                    .set_key(::std::option::Option::Some("build.gradle.kts".to_owned()))
                    .set_version_id(::std::option::Option::Some("IfK9Z4.H5TLAtMxFrxN_C7rFEZbufF3V".to_owned()))
                    .set_is_latest(::std::option::Option::Some(false))
                    .set_last_modified(::std::option::Option::Some(::aws_smithy_types::DateTime::from_fractional_secs(
                        1234567890, 0_f64,
                    )))
                    .set_e_tag(::std::option::Option::Some("\"99613b85e3f38b222c4ee548cde1e59d\"".to_owned()))
                    .set_size(::std::option::Option::Some(6903))
                    .set_owner(::std::option::Option::Some(
                        crate::types::Owner::builder()
                            .set_id(::std::option::Option::Some(
                                "c1665459250c459f1849ddce9b291fc3a72bcf5220dc8f6391a0a1045c683b34".to_owned(),
                            ))
                            .set_display_name(::std::option::Option::Some("test-name".to_owned()))
                            .build(),
                    ))
                    .set_storage_class(::std::option::Option::Some(
                        "STANDARD"
                            .parse::<crate::types::ObjectVersionStorageClass>()
                            .expect("static value validated to member"),
                    ))
                    .build(),
                crate::types::ObjectVersion::builder()
                    .set_key(::std::option::Option::Some("file-2".to_owned()))
                    .set_version_id(::std::option::Option::Some("PSVAbvQihRdsNiktGothjGng7q.5ou9Q".to_owned()))
                    .set_is_latest(::std::option::Option::Some(false))
                    .set_last_modified(::std::option::Option::Some(::aws_smithy_types::DateTime::from_fractional_secs(
                        1234567890, 0_f64,
                    )))
                    .set_e_tag(::std::option::Option::Some("\"1727d9cb38dd325d9c12c973ef3675fc\"".to_owned()))
                    .set_size(::std::option::Option::Some(14))
                    .set_owner(::std::option::Option::Some(
                        crate::types::Owner::builder()
                            .set_id(::std::option::Option::Some(
                                "c1665459250c459f1849ddce9b291fc3a72bcf5220dc8f6391a0a1045c683b34".to_owned(),
                            ))
                            .set_display_name(::std::option::Option::Some("test-name".to_owned()))
                            .build(),
                    ))
                    .set_storage_class(::std::option::Option::Some(
                        "STANDARD"
                            .parse::<crate::types::ObjectVersionStorageClass>()
                            .expect("static value validated to member"),
                    ))
                    .build(),
            ]))
            .build();
        let mut http_response = ::aws_smithy_runtime_api::http::Response::try_from(::http::response::Builder::new()
        .status(200)
                    .body(::aws_smithy_types::body::SdkBody::from("<?xml version=\"1.0\"?>\n<ListVersionsResult xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">\n  <Name>sdk-obj-versions-test</Name>\n  <Prefix/>\n  <KeyMarker/>\n  <VersionIdMarker/>\n  <MaxKeys>1000</MaxKeys>\n  <IsTruncated>false</IsTruncated>\n  <DeleteMarker>\n    <Key>build.gradle.kts</Key>\n    <VersionId>null</VersionId>\n    <IsLatest>true</IsLatest>\n    <LastModified>2009-02-13T23:31:30Z</LastModified>\n    <Owner>\n      <ID>c1665459250c459f1849ddce9b291fc3a72bcf5220dc8f6391a0a1045c683b34</ID>\n      <DisplayName>test-name</DisplayName>\n    </Owner>\n  </DeleteMarker>\n  <Version>\n    <Key>build.gradle.kts</Key>\n    <VersionId>IfK9Z4.H5TLAtMxFrxN_C7rFEZbufF3V</VersionId>\n    <IsLatest>false</IsLatest>\n    <LastModified>2009-02-13T23:31:30Z</LastModified>\n    <ETag>\"99613b85e3f38b222c4ee548cde1e59d\"</ETag>\n    <Size>6903</Size>\n    <Owner>\n      <ID>c1665459250c459f1849ddce9b291fc3a72bcf5220dc8f6391a0a1045c683b34</ID>\n      <DisplayName>test-name</DisplayName>\n    </Owner>\n    <StorageClass>STANDARD</StorageClass>\n  </Version>\n  <DeleteMarker>\n    <Key>file-2</Key>\n    <VersionId>o98RL6vmlOYiymftbX7wgy_4XWQG4AmY</VersionId>\n    <IsLatest>true</IsLatest>\n    <LastModified>2009-02-13T23:31:30Z</LastModified>\n    <Owner>\n      <ID>c1665459250c459f1849ddce9b291fc3a72bcf5220dc8f6391a0a1045c683b34</ID>\n      <DisplayName>test-name</DisplayName>\n    </Owner>\n  </DeleteMarker>\n  <Version>\n    <Key>file-2</Key>\n    <VersionId>PSVAbvQihRdsNiktGothjGng7q.5ou9Q</VersionId>\n    <IsLatest>false</IsLatest>\n    <LastModified>2009-02-13T23:31:30Z</LastModified>\n    <ETag>\"1727d9cb38dd325d9c12c973ef3675fc\"</ETag>\n    <Size>14</Size>\n    <Owner>\n      <ID>c1665459250c459f1849ddce9b291fc3a72bcf5220dc8f6391a0a1045c683b34</ID>\n      <DisplayName>test-name</DisplayName>\n    </Owner>\n    <StorageClass>STANDARD</StorageClass>\n  </Version>\n</ListVersionsResult>\n"))
                    .unwrap()
                    ).unwrap();
        use ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugin;
        use ::aws_smithy_runtime_api::client::ser_de::DeserializeResponse;

        let op = crate::operation::list_object_versions::ListObjectVersions::new();
        let config = op.config().expect("the operation has config");
        let de = config
            .load::<::aws_smithy_runtime_api::client::ser_de::SharedResponseDeserializer>()
            .expect("the config must have a deserializer");

        let parsed = de.deserialize_streaming(&mut http_response);
        let parsed = parsed.unwrap_or_else(|| {
            let http_response = http_response.map(|body| {
                ::aws_smithy_types::body::SdkBody::from(::bytes::Bytes::copy_from_slice(&::aws_smithy_protocol_test::decode_body_data(
                    body.bytes().unwrap(),
                    ::aws_smithy_protocol_test::MediaType::from("application/xml"),
                )))
            });
            de.deserialize_nonstreaming(&http_response)
        });
        let parsed = parsed
            .expect("should be successful response")
            .downcast::<crate::operation::list_object_versions::ListObjectVersionsOutput>()
            .unwrap();
        ::pretty_assertions::assert_eq!(parsed.is_truncated, expected_output.is_truncated, "Unexpected value for `is_truncated`");
        ::pretty_assertions::assert_eq!(parsed.key_marker, expected_output.key_marker, "Unexpected value for `key_marker`");
        ::pretty_assertions::assert_eq!(
            parsed.version_id_marker,
            expected_output.version_id_marker,
            "Unexpected value for `version_id_marker`"
        );
        ::pretty_assertions::assert_eq!(
            parsed.next_key_marker,
            expected_output.next_key_marker,
            "Unexpected value for `next_key_marker`"
        );
        ::pretty_assertions::assert_eq!(
            parsed.next_version_id_marker,
            expected_output.next_version_id_marker,
            "Unexpected value for `next_version_id_marker`"
        );
        ::pretty_assertions::assert_eq!(parsed.versions, expected_output.versions, "Unexpected value for `versions`");
        ::pretty_assertions::assert_eq!(
            parsed.delete_markers,
            expected_output.delete_markers,
            "Unexpected value for `delete_markers`"
        );
        ::pretty_assertions::assert_eq!(parsed.name, expected_output.name, "Unexpected value for `name`");
        ::pretty_assertions::assert_eq!(parsed.prefix, expected_output.prefix, "Unexpected value for `prefix`");
        ::pretty_assertions::assert_eq!(parsed.delimiter, expected_output.delimiter, "Unexpected value for `delimiter`");
        ::pretty_assertions::assert_eq!(parsed.max_keys, expected_output.max_keys, "Unexpected value for `max_keys`");
        ::pretty_assertions::assert_eq!(
            parsed.common_prefixes,
            expected_output.common_prefixes,
            "Unexpected value for `common_prefixes`"
        );
        ::pretty_assertions::assert_eq!(
            parsed.encoding_type,
            expected_output.encoding_type,
            "Unexpected value for `encoding_type`"
        );
        ::pretty_assertions::assert_eq!(
            parsed.request_charged,
            expected_output.request_charged,
            "Unexpected value for `request_charged`"
        );
    }
}

/// Error type for the `ListObjectVersionsError` operation.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum ListObjectVersionsError {
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-ListObjectVersionsError) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ListObjectVersionsError {
    /// Creates the `ListObjectVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(
        err: impl ::std::convert::Into<::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.into(),
            meta: ::std::default::Default::default(),
        })
    }

    /// Creates the `ListObjectVersionsError::Unhandled` variant from an [`ErrorMetadata`](::aws_smithy_types::error::ErrorMetadata).
    pub fn generic(err: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.clone().into(),
            meta: err,
        })
    }
    ///
    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    ///
    pub fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::Unhandled(e) => &e.meta,
        }
    }
}
impl ::std::error::Error for ListObjectVersionsError {
    fn source(&self) -> ::std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Self::Unhandled(_inner) => ::std::option::Option::Some(&*_inner.source),
        }
    }
}
impl ::std::fmt::Display for ListObjectVersionsError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            Self::Unhandled(_inner) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl ::aws_smithy_types::retry::ProvideErrorKind for ListObjectVersionsError {
    fn code(&self) -> ::std::option::Option<&str> {
        ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self)
    }
    fn retryable_error_kind(&self) -> ::std::option::Option<::aws_smithy_types::retry::ErrorKind> {
        ::std::option::Option::None
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for ListObjectVersionsError {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::Unhandled(_inner) => &_inner.meta,
        }
    }
}
impl ::aws_smithy_runtime_api::client::result::CreateUnhandledError for ListObjectVersionsError {
    fn create_unhandled_error(
        source: ::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>,
        meta: ::std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source,
            meta: meta.unwrap_or_default(),
        })
    }
}
impl crate::s3_request_id::RequestIdExt for crate::operation::list_object_versions::ListObjectVersionsError {
    fn extended_request_id(&self) -> Option<&str> {
        self.meta().extended_request_id()
    }
}
impl ::aws_types::request_id::RequestId for crate::operation::list_object_versions::ListObjectVersionsError {
    fn request_id(&self) -> Option<&str> {
        self.meta().request_id()
    }
}

pub use crate::operation::list_object_versions::_list_object_versions_output::ListObjectVersionsOutput;

pub use crate::operation::list_object_versions::_list_object_versions_input::ListObjectVersionsInput;

mod _list_object_versions_input;

mod _list_object_versions_output;

/// Builders
pub mod builders;
