/*
  Copyright (C) 2015 Chris Vine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include <string>
#include <vector>
#include <fstream>
#include <utility>  // for std::move
#include <string.h> // for strdup

#include "fstab_parser.h"

#include <c++-gtk-utils/callback.h>

static std::vector<std::string> fstab_line_split(const std::string& in) {
  std::vector<std::string> ret;
  std::size_t begin = 0, end;
  const std::size_t len = in.size();
  while (begin < len) {
    end = in.find_first_of(" \t", begin);
    if (end != std::string::npos) {
      if (end - begin > 0)
	ret.push_back(in.substr(begin, end - begin));
      begin = end + 1;
    }
    else {
      std::string tmp = in.substr(begin);
      if (tmp.size())
	ret.push_back(std::move(tmp));
      break;
    }
  }
  return ret;
}


char* get_fstab_mount_point_for_device(const char* device) {

  std::ifstream fstab{"/etc/fstab", std::ios::in};
  if (!fstab) {
    Callback::post(Callback::make(write_error,
    				  "Cannot open /etc/fstab\n",
    				  true));
    return 0;
  }
  std::string line;
  while (std::getline(fstab, line)) {
    std::vector<std::string> parsed{fstab_line_split(line)};
    if (parsed.size() > 1 && parsed[0] == std::string{device})
      return strdup(parsed[1].c_str());
  }
  std::string err{"Cannot find device "};
  err += device;
  err += '\n';
  Callback::post(Callback::make(write_error_del,
				const_cast<const char*>(strdup(err.c_str())),
				true));
  return 0;
}
