
/*

    confparse.h - Header file with definitions
    Copyright (C) 2002-2004 Mario Pascucci <ilpettegolo (a) yahoo it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    or
    visit the URL http://www.fsf.org/


*/

/* prevent multiple inclusion */
#ifndef _MP_CONFPARSE


#ifdef __cplusplus
extern "C" {
#endif


/* define header ID */
#define _MP_CONFPARSE

/* header definitions starts here */

/* var type list */
#define VAR_INT	      1   /* an integer (like 32, 0x3f, 0277) */
#define VAR_STR	      2   /* a double quote delimited string (like "string") */
#define VAR_IP	      3   /* an IP address (like 192.168.1.2) */
#define VAR_DEC	      4   /* a float (double) */
#define CALLBK_INT    5	  /* a callback with single int parameter */
#define CALLBK_STR    6	  /* a callback with string parameter */

/* single var definition struct. The parser requires an array of these structs
 * filled with required values and callbacks
 */
struct confvars {
  char *  name;	      // var name, used in the .conf file
  int	  type;	      // var type
  int	  size;	      // maximum size accepted for string vars
  void *  varp;	      // pointer to real var or callback function
};


/* 
 * Parser main function. Requires two parameter:
 * cv: array of confvars structs, terminated by a 0-filled struct.
 * fp: FILE * to the configuration file, ready for parsing.
 */

int confparse(struct confvars *cv, FILE* fp);


#ifdef __cplusplus
}
#endif

#endif /* _MP_CONFPARSE */


