// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/cloud/support/v1alpha1/cloud_support.proto

package support

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	common "google.golang.org/genproto/googleapis/cloud/support/common"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The request message for `GetSupportAccount`.
type GetSupportAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the support accounts. For example:
	// `supportAccounts/accountA`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSupportAccountRequest) Reset() {
	*x = GetSupportAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSupportAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSupportAccountRequest) ProtoMessage() {}

func (x *GetSupportAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSupportAccountRequest.ProtoReflect.Descriptor instead.
func (*GetSupportAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{0}
}

func (x *GetSupportAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for `ListSupportAccount`.
type ListSupportAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The filter applied to search results. It only supports filtering a support
	// account list by a cloud_resource. For example, to filter results by support
	// accounts associated with an Organization, its value should be:
	// "cloud_resource:organizations/<organization_id>"
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// Maximum number of accounts fetched with each request.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return. If unspecified, the
	// first page is retrieved.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSupportAccountsRequest) Reset() {
	*x = ListSupportAccountsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSupportAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSupportAccountsRequest) ProtoMessage() {}

func (x *ListSupportAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSupportAccountsRequest.ProtoReflect.Descriptor instead.
func (*ListSupportAccountsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{1}
}

func (x *ListSupportAccountsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSupportAccountsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSupportAccountsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for `ListSupportAccount`.
type ListSupportAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of support accounts.
	Accounts []*common.SupportAccount `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
	// A token to retrieve the next page of results. This should be passed on in
	// `page_token` field of `ListSupportAccountRequest` for next request. If
	// unspecified, there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSupportAccountsResponse) Reset() {
	*x = ListSupportAccountsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSupportAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSupportAccountsResponse) ProtoMessage() {}

func (x *ListSupportAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSupportAccountsResponse.ProtoReflect.Descriptor instead.
func (*ListSupportAccountsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{2}
}

func (x *ListSupportAccountsResponse) GetAccounts() []*common.SupportAccount {
	if x != nil {
		return x.Accounts
	}
	return nil
}

func (x *ListSupportAccountsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for `GetCase` method.
type GetCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of case resource requested.
	// For example: "supportAccounts/accountA/cases/123"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCaseRequest) Reset() {
	*x = GetCaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCaseRequest) ProtoMessage() {}

func (x *GetCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCaseRequest.ProtoReflect.Descriptor instead.
func (*GetCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{3}
}

func (x *GetCaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for `ListCase` method.
type ListCasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the account resource for which cases are requested. For example:
	// "supportAccounts/accountA"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The filter applied to the search results. Currently it only accepts "OPEN"
	// or "CLOSED" strings, filtering out cases that are open or resolved.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Maximum number of cases fetched with each request.
	PageSize int64 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return. If unspecified, the
	// first page is retrieved.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCasesRequest) Reset() {
	*x = ListCasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCasesRequest) ProtoMessage() {}

func (x *ListCasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCasesRequest.ProtoReflect.Descriptor instead.
func (*ListCasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{4}
}

func (x *ListCasesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListCasesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCasesRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCasesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for `ListCase` method.
type ListCasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of cases.
	Cases []*common.Case `protobuf:"bytes,1,rep,name=cases,proto3" json:"cases,omitempty"`
	// A token to retrieve the next page of results. This should be passed on in
	// `page_token` field of `ListCaseRequest` for next request. If unspecified,
	// there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCasesResponse) Reset() {
	*x = ListCasesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCasesResponse) ProtoMessage() {}

func (x *ListCasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCasesResponse.ProtoReflect.Descriptor instead.
func (*ListCasesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{5}
}

func (x *ListCasesResponse) GetCases() []*common.Case {
	if x != nil {
		return x.Cases
	}
	return nil
}

func (x *ListCasesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for `ListComments` method.
type ListCommentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of case for which comments should be listed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ListCommentsRequest) Reset() {
	*x = ListCommentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCommentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCommentsRequest) ProtoMessage() {}

func (x *ListCommentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCommentsRequest.ProtoReflect.Descriptor instead.
func (*ListCommentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{6}
}

func (x *ListCommentsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response message for `ListComments` method.
type ListCommentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of comments.
	Comments []*common.Comment `protobuf:"bytes,1,rep,name=comments,proto3" json:"comments,omitempty"`
}

func (x *ListCommentsResponse) Reset() {
	*x = ListCommentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCommentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCommentsResponse) ProtoMessage() {}

func (x *ListCommentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCommentsResponse.ProtoReflect.Descriptor instead.
func (*ListCommentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{7}
}

func (x *ListCommentsResponse) GetComments() []*common.Comment {
	if x != nil {
		return x.Comments
	}
	return nil
}

// The request message for `CreateCase` method.
type CreateCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for `SupportAccount` under which this case is created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The case resource to create.
	Case *common.Case `protobuf:"bytes,2,opt,name=case,proto3" json:"case,omitempty"`
}

func (x *CreateCaseRequest) Reset() {
	*x = CreateCaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCaseRequest) ProtoMessage() {}

func (x *CreateCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCaseRequest.ProtoReflect.Descriptor instead.
func (*CreateCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{8}
}

func (x *CreateCaseRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCaseRequest) GetCase() *common.Case {
	if x != nil {
		return x.Case
	}
	return nil
}

// The request message for `UpdateCase` method.
type UpdateCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The case resource to update.
	Case *common.Case `protobuf:"bytes,1,opt,name=case,proto3" json:"case,omitempty"`
	// A field that represents attributes of a Case object that should be updated
	// as part of this request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCaseRequest) Reset() {
	*x = UpdateCaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCaseRequest) ProtoMessage() {}

func (x *UpdateCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCaseRequest.ProtoReflect.Descriptor instead.
func (*UpdateCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateCaseRequest) GetCase() *common.Case {
	if x != nil {
		return x.Case
	}
	return nil
}

func (x *UpdateCaseRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for `CreateComment` method.
type CreateCommentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of case to which this comment should be added.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The `Comment` to be added to this case.
	Comment *common.Comment `protobuf:"bytes,2,opt,name=comment,proto3" json:"comment,omitempty"`
}

func (x *CreateCommentRequest) Reset() {
	*x = CreateCommentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCommentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCommentRequest) ProtoMessage() {}

func (x *CreateCommentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCommentRequest.ProtoReflect.Descriptor instead.
func (*CreateCommentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{10}
}

func (x *CreateCommentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateCommentRequest) GetComment() *common.Comment {
	if x != nil {
		return x.Comment
	}
	return nil
}

// The request message for `GetIssueTaxonomy` method.
type GetIssueTaxonomyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetIssueTaxonomyRequest) Reset() {
	*x = GetIssueTaxonomyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIssueTaxonomyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIssueTaxonomyRequest) ProtoMessage() {}

func (x *GetIssueTaxonomyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIssueTaxonomyRequest.ProtoReflect.Descriptor instead.
func (*GetIssueTaxonomyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP(), []int{11}
}

var File_google_cloud_support_v1alpha1_cloud_support_proto protoreflect.FileDescriptor

var file_google_cloud_support_v1alpha1_cloud_support_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x2e, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x70, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8e, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x52, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x24, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x43, 0x61, 0x73, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x74, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x05,
	0x63, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x52, 0x05,
	0x63, 0x61, 0x73, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x29, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x58, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x40, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x22, 0x62, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x35, 0x0a, 0x04, 0x63, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x73, 0x65,
	0x52, 0x04, 0x63, 0x61, 0x73, 0x65, 0x22, 0x87, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04,
	0x63, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x52, 0x04, 0x63,
	0x61, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0x6a, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x07,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x19, 0x0a, 0x17,
	0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x32, 0xe5, 0x0b, 0x0a, 0x0c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xa5, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74,
	0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xaf, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x12, 0x19, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x12, 0x8f, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x43, 0x61, 0x73, 0x65, 0x12, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x73, 0x65,
	0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x73, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa0, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x73,
	0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x73,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x9b,
	0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x65, 0x12, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61,
	0x73, 0x65, 0x22, 0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x3a, 0x04, 0x63, 0x61, 0x73, 0x65, 0x12, 0xa0, 0x01, 0x0a,
	0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x73, 0x65,
	0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x32, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x7b, 0x63, 0x61, 0x73, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x04, 0x63, 0x61, 0x73, 0x65, 0x12,
	0xb0, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x44, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3e, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x9a, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x54,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x22, 0x22, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1c, 0x12, 0x1a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3a, 0x67,
	0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x42,
	0x7c, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x42, 0x11, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescOnce sync.Once
	file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescData = file_google_cloud_support_v1alpha1_cloud_support_proto_rawDesc
)

func file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescGZIP() []byte {
	file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescOnce.Do(func() {
		file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescData)
	})
	return file_google_cloud_support_v1alpha1_cloud_support_proto_rawDescData
}

var file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_support_v1alpha1_cloud_support_proto_goTypes = []interface{}{
	(*GetSupportAccountRequest)(nil),    // 0: google.cloud.support.v1alpha1.GetSupportAccountRequest
	(*ListSupportAccountsRequest)(nil),  // 1: google.cloud.support.v1alpha1.ListSupportAccountsRequest
	(*ListSupportAccountsResponse)(nil), // 2: google.cloud.support.v1alpha1.ListSupportAccountsResponse
	(*GetCaseRequest)(nil),              // 3: google.cloud.support.v1alpha1.GetCaseRequest
	(*ListCasesRequest)(nil),            // 4: google.cloud.support.v1alpha1.ListCasesRequest
	(*ListCasesResponse)(nil),           // 5: google.cloud.support.v1alpha1.ListCasesResponse
	(*ListCommentsRequest)(nil),         // 6: google.cloud.support.v1alpha1.ListCommentsRequest
	(*ListCommentsResponse)(nil),        // 7: google.cloud.support.v1alpha1.ListCommentsResponse
	(*CreateCaseRequest)(nil),           // 8: google.cloud.support.v1alpha1.CreateCaseRequest
	(*UpdateCaseRequest)(nil),           // 9: google.cloud.support.v1alpha1.UpdateCaseRequest
	(*CreateCommentRequest)(nil),        // 10: google.cloud.support.v1alpha1.CreateCommentRequest
	(*GetIssueTaxonomyRequest)(nil),     // 11: google.cloud.support.v1alpha1.GetIssueTaxonomyRequest
	(*common.SupportAccount)(nil),       // 12: google.cloud.support.common.SupportAccount
	(*common.Case)(nil),                 // 13: google.cloud.support.common.Case
	(*common.Comment)(nil),              // 14: google.cloud.support.common.Comment
	(*fieldmaskpb.FieldMask)(nil),       // 15: google.protobuf.FieldMask
	(*common.IssueTaxonomy)(nil),        // 16: google.cloud.support.common.IssueTaxonomy
}
var file_google_cloud_support_v1alpha1_cloud_support_proto_depIdxs = []int32{
	12, // 0: google.cloud.support.v1alpha1.ListSupportAccountsResponse.accounts:type_name -> google.cloud.support.common.SupportAccount
	13, // 1: google.cloud.support.v1alpha1.ListCasesResponse.cases:type_name -> google.cloud.support.common.Case
	14, // 2: google.cloud.support.v1alpha1.ListCommentsResponse.comments:type_name -> google.cloud.support.common.Comment
	13, // 3: google.cloud.support.v1alpha1.CreateCaseRequest.case:type_name -> google.cloud.support.common.Case
	13, // 4: google.cloud.support.v1alpha1.UpdateCaseRequest.case:type_name -> google.cloud.support.common.Case
	15, // 5: google.cloud.support.v1alpha1.UpdateCaseRequest.update_mask:type_name -> google.protobuf.FieldMask
	14, // 6: google.cloud.support.v1alpha1.CreateCommentRequest.comment:type_name -> google.cloud.support.common.Comment
	0,  // 7: google.cloud.support.v1alpha1.CloudSupport.GetSupportAccount:input_type -> google.cloud.support.v1alpha1.GetSupportAccountRequest
	1,  // 8: google.cloud.support.v1alpha1.CloudSupport.ListSupportAccounts:input_type -> google.cloud.support.v1alpha1.ListSupportAccountsRequest
	3,  // 9: google.cloud.support.v1alpha1.CloudSupport.GetCase:input_type -> google.cloud.support.v1alpha1.GetCaseRequest
	4,  // 10: google.cloud.support.v1alpha1.CloudSupport.ListCases:input_type -> google.cloud.support.v1alpha1.ListCasesRequest
	6,  // 11: google.cloud.support.v1alpha1.CloudSupport.ListComments:input_type -> google.cloud.support.v1alpha1.ListCommentsRequest
	8,  // 12: google.cloud.support.v1alpha1.CloudSupport.CreateCase:input_type -> google.cloud.support.v1alpha1.CreateCaseRequest
	9,  // 13: google.cloud.support.v1alpha1.CloudSupport.UpdateCase:input_type -> google.cloud.support.v1alpha1.UpdateCaseRequest
	10, // 14: google.cloud.support.v1alpha1.CloudSupport.CreateComment:input_type -> google.cloud.support.v1alpha1.CreateCommentRequest
	11, // 15: google.cloud.support.v1alpha1.CloudSupport.GetIssueTaxonomy:input_type -> google.cloud.support.v1alpha1.GetIssueTaxonomyRequest
	12, // 16: google.cloud.support.v1alpha1.CloudSupport.GetSupportAccount:output_type -> google.cloud.support.common.SupportAccount
	2,  // 17: google.cloud.support.v1alpha1.CloudSupport.ListSupportAccounts:output_type -> google.cloud.support.v1alpha1.ListSupportAccountsResponse
	13, // 18: google.cloud.support.v1alpha1.CloudSupport.GetCase:output_type -> google.cloud.support.common.Case
	5,  // 19: google.cloud.support.v1alpha1.CloudSupport.ListCases:output_type -> google.cloud.support.v1alpha1.ListCasesResponse
	7,  // 20: google.cloud.support.v1alpha1.CloudSupport.ListComments:output_type -> google.cloud.support.v1alpha1.ListCommentsResponse
	13, // 21: google.cloud.support.v1alpha1.CloudSupport.CreateCase:output_type -> google.cloud.support.common.Case
	13, // 22: google.cloud.support.v1alpha1.CloudSupport.UpdateCase:output_type -> google.cloud.support.common.Case
	14, // 23: google.cloud.support.v1alpha1.CloudSupport.CreateComment:output_type -> google.cloud.support.common.Comment
	16, // 24: google.cloud.support.v1alpha1.CloudSupport.GetIssueTaxonomy:output_type -> google.cloud.support.common.IssueTaxonomy
	16, // [16:25] is the sub-list for method output_type
	7,  // [7:16] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_support_v1alpha1_cloud_support_proto_init() }
func file_google_cloud_support_v1alpha1_cloud_support_proto_init() {
	if File_google_cloud_support_v1alpha1_cloud_support_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSupportAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSupportAccountsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSupportAccountsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCasesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCommentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCommentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCommentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIssueTaxonomyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_support_v1alpha1_cloud_support_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_support_v1alpha1_cloud_support_proto_goTypes,
		DependencyIndexes: file_google_cloud_support_v1alpha1_cloud_support_proto_depIdxs,
		MessageInfos:      file_google_cloud_support_v1alpha1_cloud_support_proto_msgTypes,
	}.Build()
	File_google_cloud_support_v1alpha1_cloud_support_proto = out.File
	file_google_cloud_support_v1alpha1_cloud_support_proto_rawDesc = nil
	file_google_cloud_support_v1alpha1_cloud_support_proto_goTypes = nil
	file_google_cloud_support_v1alpha1_cloud_support_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudSupportClient is the client API for CloudSupport service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudSupportClient interface {
	// Retrieves the support account details given an account identifier.
	// The authenticated user calling this method must be the account owner.
	GetSupportAccount(ctx context.Context, in *GetSupportAccountRequest, opts ...grpc.CallOption) (*common.SupportAccount, error)
	// Retrieves the list of accounts the current authenticated user has access
	// to.
	ListSupportAccounts(ctx context.Context, in *ListSupportAccountsRequest, opts ...grpc.CallOption) (*ListSupportAccountsResponse, error)
	// Retrieves the details for a support case. The current authenticated user
	// calling this method must have permissions to view this case.
	GetCase(ctx context.Context, in *GetCaseRequest, opts ...grpc.CallOption) (*common.Case, error)
	// Retrieves the list of support cases associated with an account. The current
	// authenticated user must have the permission to list and view these cases.
	ListCases(ctx context.Context, in *ListCasesRequest, opts ...grpc.CallOption) (*ListCasesResponse, error)
	// Lists all comments from a case.
	ListComments(ctx context.Context, in *ListCommentsRequest, opts ...grpc.CallOption) (*ListCommentsResponse, error)
	// Creates a case and associates it with a
	// [SupportAccount][google.cloud.support.v1alpha2.SupportAcccount]. The
	// authenticated user attempting this action must have permissions to create a
	// `Case` under that [SupportAccount].
	CreateCase(ctx context.Context, in *CreateCaseRequest, opts ...grpc.CallOption) (*common.Case, error)
	// Updates a support case. Only a small set of details (priority, subject and
	// cc_address) can be update after a case is created.
	UpdateCase(ctx context.Context, in *UpdateCaseRequest, opts ...grpc.CallOption) (*common.Case, error)
	// Adds a new comment to a case.
	CreateComment(ctx context.Context, in *CreateCommentRequest, opts ...grpc.CallOption) (*common.Comment, error)
	// Retrieves the taxonomy of product categories and components to be used
	// while creating a support case.
	GetIssueTaxonomy(ctx context.Context, in *GetIssueTaxonomyRequest, opts ...grpc.CallOption) (*common.IssueTaxonomy, error)
}

type cloudSupportClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudSupportClient(cc grpc.ClientConnInterface) CloudSupportClient {
	return &cloudSupportClient{cc}
}

func (c *cloudSupportClient) GetSupportAccount(ctx context.Context, in *GetSupportAccountRequest, opts ...grpc.CallOption) (*common.SupportAccount, error) {
	out := new(common.SupportAccount)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v1alpha1.CloudSupport/GetSupportAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSupportClient) ListSupportAccounts(ctx context.Context, in *ListSupportAccountsRequest, opts ...grpc.CallOption) (*ListSupportAccountsResponse, error) {
	out := new(ListSupportAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v1alpha1.CloudSupport/ListSupportAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSupportClient) GetCase(ctx context.Context, in *GetCaseRequest, opts ...grpc.CallOption) (*common.Case, error) {
	out := new(common.Case)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v1alpha1.CloudSupport/GetCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSupportClient) ListCases(ctx context.Context, in *ListCasesRequest, opts ...grpc.CallOption) (*ListCasesResponse, error) {
	out := new(ListCasesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v1alpha1.CloudSupport/ListCases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSupportClient) ListComments(ctx context.Context, in *ListCommentsRequest, opts ...grpc.CallOption) (*ListCommentsResponse, error) {
	out := new(ListCommentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v1alpha1.CloudSupport/ListComments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSupportClient) CreateCase(ctx context.Context, in *CreateCaseRequest, opts ...grpc.CallOption) (*common.Case, error) {
	out := new(common.Case)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v1alpha1.CloudSupport/CreateCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSupportClient) UpdateCase(ctx context.Context, in *UpdateCaseRequest, opts ...grpc.CallOption) (*common.Case, error) {
	out := new(common.Case)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v1alpha1.CloudSupport/UpdateCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSupportClient) CreateComment(ctx context.Context, in *CreateCommentRequest, opts ...grpc.CallOption) (*common.Comment, error) {
	out := new(common.Comment)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v1alpha1.CloudSupport/CreateComment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSupportClient) GetIssueTaxonomy(ctx context.Context, in *GetIssueTaxonomyRequest, opts ...grpc.CallOption) (*common.IssueTaxonomy, error) {
	out := new(common.IssueTaxonomy)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v1alpha1.CloudSupport/GetIssueTaxonomy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudSupportServer is the server API for CloudSupport service.
type CloudSupportServer interface {
	// Retrieves the support account details given an account identifier.
	// The authenticated user calling this method must be the account owner.
	GetSupportAccount(context.Context, *GetSupportAccountRequest) (*common.SupportAccount, error)
	// Retrieves the list of accounts the current authenticated user has access
	// to.
	ListSupportAccounts(context.Context, *ListSupportAccountsRequest) (*ListSupportAccountsResponse, error)
	// Retrieves the details for a support case. The current authenticated user
	// calling this method must have permissions to view this case.
	GetCase(context.Context, *GetCaseRequest) (*common.Case, error)
	// Retrieves the list of support cases associated with an account. The current
	// authenticated user must have the permission to list and view these cases.
	ListCases(context.Context, *ListCasesRequest) (*ListCasesResponse, error)
	// Lists all comments from a case.
	ListComments(context.Context, *ListCommentsRequest) (*ListCommentsResponse, error)
	// Creates a case and associates it with a
	// [SupportAccount][google.cloud.support.v1alpha2.SupportAcccount]. The
	// authenticated user attempting this action must have permissions to create a
	// `Case` under that [SupportAccount].
	CreateCase(context.Context, *CreateCaseRequest) (*common.Case, error)
	// Updates a support case. Only a small set of details (priority, subject and
	// cc_address) can be update after a case is created.
	UpdateCase(context.Context, *UpdateCaseRequest) (*common.Case, error)
	// Adds a new comment to a case.
	CreateComment(context.Context, *CreateCommentRequest) (*common.Comment, error)
	// Retrieves the taxonomy of product categories and components to be used
	// while creating a support case.
	GetIssueTaxonomy(context.Context, *GetIssueTaxonomyRequest) (*common.IssueTaxonomy, error)
}

// UnimplementedCloudSupportServer can be embedded to have forward compatible implementations.
type UnimplementedCloudSupportServer struct {
}

func (*UnimplementedCloudSupportServer) GetSupportAccount(context.Context, *GetSupportAccountRequest) (*common.SupportAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSupportAccount not implemented")
}
func (*UnimplementedCloudSupportServer) ListSupportAccounts(context.Context, *ListSupportAccountsRequest) (*ListSupportAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSupportAccounts not implemented")
}
func (*UnimplementedCloudSupportServer) GetCase(context.Context, *GetCaseRequest) (*common.Case, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCase not implemented")
}
func (*UnimplementedCloudSupportServer) ListCases(context.Context, *ListCasesRequest) (*ListCasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCases not implemented")
}
func (*UnimplementedCloudSupportServer) ListComments(context.Context, *ListCommentsRequest) (*ListCommentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListComments not implemented")
}
func (*UnimplementedCloudSupportServer) CreateCase(context.Context, *CreateCaseRequest) (*common.Case, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCase not implemented")
}
func (*UnimplementedCloudSupportServer) UpdateCase(context.Context, *UpdateCaseRequest) (*common.Case, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCase not implemented")
}
func (*UnimplementedCloudSupportServer) CreateComment(context.Context, *CreateCommentRequest) (*common.Comment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateComment not implemented")
}
func (*UnimplementedCloudSupportServer) GetIssueTaxonomy(context.Context, *GetIssueTaxonomyRequest) (*common.IssueTaxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIssueTaxonomy not implemented")
}

func RegisterCloudSupportServer(s *grpc.Server, srv CloudSupportServer) {
	s.RegisterService(&_CloudSupport_serviceDesc, srv)
}

func _CloudSupport_GetSupportAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSupportAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSupportServer).GetSupportAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v1alpha1.CloudSupport/GetSupportAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSupportServer).GetSupportAccount(ctx, req.(*GetSupportAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudSupport_ListSupportAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSupportAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSupportServer).ListSupportAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v1alpha1.CloudSupport/ListSupportAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSupportServer).ListSupportAccounts(ctx, req.(*ListSupportAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudSupport_GetCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSupportServer).GetCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v1alpha1.CloudSupport/GetCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSupportServer).GetCase(ctx, req.(*GetCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudSupport_ListCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSupportServer).ListCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v1alpha1.CloudSupport/ListCases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSupportServer).ListCases(ctx, req.(*ListCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudSupport_ListComments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCommentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSupportServer).ListComments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v1alpha1.CloudSupport/ListComments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSupportServer).ListComments(ctx, req.(*ListCommentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudSupport_CreateCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSupportServer).CreateCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v1alpha1.CloudSupport/CreateCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSupportServer).CreateCase(ctx, req.(*CreateCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudSupport_UpdateCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSupportServer).UpdateCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v1alpha1.CloudSupport/UpdateCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSupportServer).UpdateCase(ctx, req.(*UpdateCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudSupport_CreateComment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCommentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSupportServer).CreateComment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v1alpha1.CloudSupport/CreateComment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSupportServer).CreateComment(ctx, req.(*CreateCommentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudSupport_GetIssueTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIssueTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSupportServer).GetIssueTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v1alpha1.CloudSupport/GetIssueTaxonomy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSupportServer).GetIssueTaxonomy(ctx, req.(*GetIssueTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudSupport_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.support.v1alpha1.CloudSupport",
	HandlerType: (*CloudSupportServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSupportAccount",
			Handler:    _CloudSupport_GetSupportAccount_Handler,
		},
		{
			MethodName: "ListSupportAccounts",
			Handler:    _CloudSupport_ListSupportAccounts_Handler,
		},
		{
			MethodName: "GetCase",
			Handler:    _CloudSupport_GetCase_Handler,
		},
		{
			MethodName: "ListCases",
			Handler:    _CloudSupport_ListCases_Handler,
		},
		{
			MethodName: "ListComments",
			Handler:    _CloudSupport_ListComments_Handler,
		},
		{
			MethodName: "CreateCase",
			Handler:    _CloudSupport_CreateCase_Handler,
		},
		{
			MethodName: "UpdateCase",
			Handler:    _CloudSupport_UpdateCase_Handler,
		},
		{
			MethodName: "CreateComment",
			Handler:    _CloudSupport_CreateComment_Handler,
		},
		{
			MethodName: "GetIssueTaxonomy",
			Handler:    _CloudSupport_GetIssueTaxonomy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/support/v1alpha1/cloud_support.proto",
}
