// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchrum

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateAppMonitor = "CreateAppMonitor"

// CreateAppMonitorRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppMonitor for more information on using the CreateAppMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppMonitorRequest method.
//    req, resp := client.CreateAppMonitorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/CreateAppMonitor
func (c *CloudWatchRUM) CreateAppMonitorRequest(input *CreateAppMonitorInput) (req *request.Request, output *CreateAppMonitorOutput) {
	op := &request.Operation{
		Name:       opCreateAppMonitor,
		HTTPMethod: "POST",
		HTTPPath:   "/appmonitor",
	}

	if input == nil {
		input = &CreateAppMonitorInput{}
	}

	output = &CreateAppMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppMonitor API operation for CloudWatch RUM.
//
// Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data
// from your application and sends that data to RUM. The data includes performance
// and reliability information such as page load time, client-side errors, and
// user behavior.
//
// You use this operation only to create a new app monitor. To update an existing
// app monitor, use UpdateAppMonitor (https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_UpdateAppMonitor.html)
// instead.
//
// After you create an app monitor, sign in to the CloudWatch RUM console to
// get the JavaScript code snippet to add to your web application. For more
// information, see How do I find a code snippet that I've already generated?
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch RUM's
// API operation CreateAppMonitor for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   This operation attempted to create a resource that already exists.
//
//   * ServiceQuotaExceededException
//   This request exceeds a service quota.
//
//   * InternalServerException
//   Internal service exception.
//
//   * ValidationException
//   One of the arguments for the request is not valid.
//
//   * ThrottlingException
//   The request was throttled because of quota limits.
//
//   * AccessDeniedException
//   You don't have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/CreateAppMonitor
func (c *CloudWatchRUM) CreateAppMonitor(input *CreateAppMonitorInput) (*CreateAppMonitorOutput, error) {
	req, out := c.CreateAppMonitorRequest(input)
	return out, req.Send()
}

// CreateAppMonitorWithContext is the same as CreateAppMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) CreateAppMonitorWithContext(ctx aws.Context, input *CreateAppMonitorInput, opts ...request.Option) (*CreateAppMonitorOutput, error) {
	req, out := c.CreateAppMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppMonitor = "DeleteAppMonitor"

// DeleteAppMonitorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppMonitor for more information on using the DeleteAppMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppMonitorRequest method.
//    req, resp := client.DeleteAppMonitorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/DeleteAppMonitor
func (c *CloudWatchRUM) DeleteAppMonitorRequest(input *DeleteAppMonitorInput) (req *request.Request, output *DeleteAppMonitorOutput) {
	op := &request.Operation{
		Name:       opDeleteAppMonitor,
		HTTPMethod: "DELETE",
		HTTPPath:   "/appmonitor/{Name}",
	}

	if input == nil {
		input = &DeleteAppMonitorInput{}
	}

	output = &DeleteAppMonitorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppMonitor API operation for CloudWatch RUM.
//
// Deletes an existing app monitor. This immediately stops the collection of
// data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch RUM's
// API operation DeleteAppMonitor for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   This operation attempted to create a resource that already exists.
//
//   * ResourceNotFoundException
//   Resource not found.
//
//   * InternalServerException
//   Internal service exception.
//
//   * ValidationException
//   One of the arguments for the request is not valid.
//
//   * ThrottlingException
//   The request was throttled because of quota limits.
//
//   * AccessDeniedException
//   You don't have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/DeleteAppMonitor
func (c *CloudWatchRUM) DeleteAppMonitor(input *DeleteAppMonitorInput) (*DeleteAppMonitorOutput, error) {
	req, out := c.DeleteAppMonitorRequest(input)
	return out, req.Send()
}

// DeleteAppMonitorWithContext is the same as DeleteAppMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) DeleteAppMonitorWithContext(ctx aws.Context, input *DeleteAppMonitorInput, opts ...request.Option) (*DeleteAppMonitorOutput, error) {
	req, out := c.DeleteAppMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppMonitor = "GetAppMonitor"

// GetAppMonitorRequest generates a "aws/request.Request" representing the
// client's request for the GetAppMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppMonitor for more information on using the GetAppMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppMonitorRequest method.
//    req, resp := client.GetAppMonitorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/GetAppMonitor
func (c *CloudWatchRUM) GetAppMonitorRequest(input *GetAppMonitorInput) (req *request.Request, output *GetAppMonitorOutput) {
	op := &request.Operation{
		Name:       opGetAppMonitor,
		HTTPMethod: "GET",
		HTTPPath:   "/appmonitor/{Name}",
	}

	if input == nil {
		input = &GetAppMonitorInput{}
	}

	output = &GetAppMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppMonitor API operation for CloudWatch RUM.
//
// Retrieves the complete configuration information for one app monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch RUM's
// API operation GetAppMonitor for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Resource not found.
//
//   * InternalServerException
//   Internal service exception.
//
//   * ValidationException
//   One of the arguments for the request is not valid.
//
//   * ThrottlingException
//   The request was throttled because of quota limits.
//
//   * AccessDeniedException
//   You don't have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/GetAppMonitor
func (c *CloudWatchRUM) GetAppMonitor(input *GetAppMonitorInput) (*GetAppMonitorOutput, error) {
	req, out := c.GetAppMonitorRequest(input)
	return out, req.Send()
}

// GetAppMonitorWithContext is the same as GetAppMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) GetAppMonitorWithContext(ctx aws.Context, input *GetAppMonitorInput, opts ...request.Option) (*GetAppMonitorOutput, error) {
	req, out := c.GetAppMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppMonitorData = "GetAppMonitorData"

// GetAppMonitorDataRequest generates a "aws/request.Request" representing the
// client's request for the GetAppMonitorData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppMonitorData for more information on using the GetAppMonitorData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppMonitorDataRequest method.
//    req, resp := client.GetAppMonitorDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/GetAppMonitorData
func (c *CloudWatchRUM) GetAppMonitorDataRequest(input *GetAppMonitorDataInput) (req *request.Request, output *GetAppMonitorDataOutput) {
	op := &request.Operation{
		Name:       opGetAppMonitorData,
		HTTPMethod: "POST",
		HTTPPath:   "/appmonitor/{Name}/data",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAppMonitorDataInput{}
	}

	output = &GetAppMonitorDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppMonitorData API operation for CloudWatch RUM.
//
// Retrieves the raw performance events that RUM has collected from your web
// application, so that you can do your own processing or analysis of this data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch RUM's
// API operation GetAppMonitorData for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Resource not found.
//
//   * InternalServerException
//   Internal service exception.
//
//   * ValidationException
//   One of the arguments for the request is not valid.
//
//   * ThrottlingException
//   The request was throttled because of quota limits.
//
//   * AccessDeniedException
//   You don't have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/GetAppMonitorData
func (c *CloudWatchRUM) GetAppMonitorData(input *GetAppMonitorDataInput) (*GetAppMonitorDataOutput, error) {
	req, out := c.GetAppMonitorDataRequest(input)
	return out, req.Send()
}

// GetAppMonitorDataWithContext is the same as GetAppMonitorData with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppMonitorData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) GetAppMonitorDataWithContext(ctx aws.Context, input *GetAppMonitorDataInput, opts ...request.Option) (*GetAppMonitorDataOutput, error) {
	req, out := c.GetAppMonitorDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetAppMonitorDataPages iterates over the pages of a GetAppMonitorData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAppMonitorData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetAppMonitorData operation.
//    pageNum := 0
//    err := client.GetAppMonitorDataPages(params,
//        func(page *cloudwatchrum.GetAppMonitorDataOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatchRUM) GetAppMonitorDataPages(input *GetAppMonitorDataInput, fn func(*GetAppMonitorDataOutput, bool) bool) error {
	return c.GetAppMonitorDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetAppMonitorDataPagesWithContext same as GetAppMonitorDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) GetAppMonitorDataPagesWithContext(ctx aws.Context, input *GetAppMonitorDataInput, fn func(*GetAppMonitorDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetAppMonitorDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAppMonitorDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetAppMonitorDataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppMonitors = "ListAppMonitors"

// ListAppMonitorsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppMonitors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppMonitors for more information on using the ListAppMonitors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAppMonitorsRequest method.
//    req, resp := client.ListAppMonitorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/ListAppMonitors
func (c *CloudWatchRUM) ListAppMonitorsRequest(input *ListAppMonitorsInput) (req *request.Request, output *ListAppMonitorsOutput) {
	op := &request.Operation{
		Name:       opListAppMonitors,
		HTTPMethod: "POST",
		HTTPPath:   "/appmonitors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppMonitorsInput{}
	}

	output = &ListAppMonitorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppMonitors API operation for CloudWatch RUM.
//
// Returns a list of the Amazon CloudWatch RUM app monitors in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch RUM's
// API operation ListAppMonitors for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Internal service exception.
//
//   * ValidationException
//   One of the arguments for the request is not valid.
//
//   * ThrottlingException
//   The request was throttled because of quota limits.
//
//   * AccessDeniedException
//   You don't have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/ListAppMonitors
func (c *CloudWatchRUM) ListAppMonitors(input *ListAppMonitorsInput) (*ListAppMonitorsOutput, error) {
	req, out := c.ListAppMonitorsRequest(input)
	return out, req.Send()
}

// ListAppMonitorsWithContext is the same as ListAppMonitors with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppMonitors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) ListAppMonitorsWithContext(ctx aws.Context, input *ListAppMonitorsInput, opts ...request.Option) (*ListAppMonitorsOutput, error) {
	req, out := c.ListAppMonitorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppMonitorsPages iterates over the pages of a ListAppMonitors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppMonitors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAppMonitors operation.
//    pageNum := 0
//    err := client.ListAppMonitorsPages(params,
//        func(page *cloudwatchrum.ListAppMonitorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatchRUM) ListAppMonitorsPages(input *ListAppMonitorsInput, fn func(*ListAppMonitorsOutput, bool) bool) error {
	return c.ListAppMonitorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppMonitorsPagesWithContext same as ListAppMonitorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) ListAppMonitorsPagesWithContext(ctx aws.Context, input *ListAppMonitorsInput, fn func(*ListAppMonitorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppMonitorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppMonitorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppMonitorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/ListTagsForResource
func (c *CloudWatchRUM) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for CloudWatch RUM.
//
// Displays the tags associated with a CloudWatch RUM resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch RUM's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Resource not found.
//
//   * InternalServerException
//   Internal service exception.
//
//   * ValidationException
//   One of the arguments for the request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/ListTagsForResource
func (c *CloudWatchRUM) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRumEvents = "PutRumEvents"

// PutRumEventsRequest generates a "aws/request.Request" representing the
// client's request for the PutRumEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRumEvents for more information on using the PutRumEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRumEventsRequest method.
//    req, resp := client.PutRumEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/PutRumEvents
func (c *CloudWatchRUM) PutRumEventsRequest(input *PutRumEventsInput) (req *request.Request, output *PutRumEventsOutput) {
	op := &request.Operation{
		Name:       opPutRumEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/appmonitors/{Id}/",
	}

	if input == nil {
		input = &PutRumEventsInput{}
	}

	output = &PutRumEventsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("dataplane.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutRumEvents API operation for CloudWatch RUM.
//
// Sends telemetry events about your application performance and user behavior
// to CloudWatch RUM. The code snippet that RUM generates for you to add to
// your application includes PutRumEvents operations to send this data to RUM.
//
// Each PutRumEvents operation can send a batch of events from one user session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch RUM's
// API operation PutRumEvents for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Resource not found.
//
//   * InternalServerException
//   Internal service exception.
//
//   * ValidationException
//   One of the arguments for the request is not valid.
//
//   * ThrottlingException
//   The request was throttled because of quota limits.
//
//   * AccessDeniedException
//   You don't have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/PutRumEvents
func (c *CloudWatchRUM) PutRumEvents(input *PutRumEventsInput) (*PutRumEventsOutput, error) {
	req, out := c.PutRumEventsRequest(input)
	return out, req.Send()
}

// PutRumEventsWithContext is the same as PutRumEvents with the addition of
// the ability to pass a context and additional request options.
//
// See PutRumEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) PutRumEventsWithContext(ctx aws.Context, input *PutRumEventsInput, opts ...request.Option) (*PutRumEventsOutput, error) {
	req, out := c.PutRumEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/TagResource
func (c *CloudWatchRUM) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for CloudWatch RUM.
//
// Assigns one or more tags (key-value pairs) to the specified CloudWatch RUM
// resource. Currently, the only resources that can be tagged app monitors.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions by granting a user permission to access or
// change only resources with certain tag values.
//
// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
// strictly as strings of characters.
//
// You can use the TagResource action with a resource that already has tags.
// If you specify a new tag key for the resource, this tag is appended to the
// list of tags associated with the alarm. If you specify a tag key that is
// already associated with the resource, the new tag value that you specify
// replaces the previous value for that tag.
//
// You can associate as many as 50 tags with a resource.
//
// For more information, see Tagging Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch RUM's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Resource not found.
//
//   * InternalServerException
//   Internal service exception.
//
//   * ValidationException
//   One of the arguments for the request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/TagResource
func (c *CloudWatchRUM) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/UntagResource
func (c *CloudWatchRUM) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for CloudWatch RUM.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch RUM's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Resource not found.
//
//   * InternalServerException
//   Internal service exception.
//
//   * ValidationException
//   One of the arguments for the request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/UntagResource
func (c *CloudWatchRUM) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppMonitor = "UpdateAppMonitor"

// UpdateAppMonitorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppMonitor for more information on using the UpdateAppMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAppMonitorRequest method.
//    req, resp := client.UpdateAppMonitorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/UpdateAppMonitor
func (c *CloudWatchRUM) UpdateAppMonitorRequest(input *UpdateAppMonitorInput) (req *request.Request, output *UpdateAppMonitorOutput) {
	op := &request.Operation{
		Name:       opUpdateAppMonitor,
		HTTPMethod: "PATCH",
		HTTPPath:   "/appmonitor/{Name}",
	}

	if input == nil {
		input = &UpdateAppMonitorInput{}
	}

	output = &UpdateAppMonitorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAppMonitor API operation for CloudWatch RUM.
//
// Updates the configuration of an existing app monitor. When you use this operation,
// only the parts of the app monitor configuration that you specify in this
// operation are changed. For any parameters that you omit, the existing values
// are kept.
//
// You can't use this operation to change the tags of an existing app monitor.
// To change the tags of an existing app monitor, use TagResource (https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_TagResource.html).
//
// To create a new app monitor, use CreateAppMonitor (https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_CreateAppMonitor.html).
//
// After you update an app monitor, sign in to the CloudWatch RUM console to
// get the updated JavaScript code snippet to add to your web application. For
// more information, see How do I find a code snippet that I've already generated?
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch RUM's
// API operation UpdateAppMonitor for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   This operation attempted to create a resource that already exists.
//
//   * ResourceNotFoundException
//   Resource not found.
//
//   * InternalServerException
//   Internal service exception.
//
//   * ValidationException
//   One of the arguments for the request is not valid.
//
//   * ThrottlingException
//   The request was throttled because of quota limits.
//
//   * AccessDeniedException
//   You don't have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/UpdateAppMonitor
func (c *CloudWatchRUM) UpdateAppMonitor(input *UpdateAppMonitorInput) (*UpdateAppMonitorOutput, error) {
	req, out := c.UpdateAppMonitorRequest(input)
	return out, req.Send()
}

// UpdateAppMonitorWithContext is the same as UpdateAppMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchRUM) UpdateAppMonitorWithContext(ctx aws.Context, input *UpdateAppMonitorInput, opts ...request.Option) (*UpdateAppMonitorOutput, error) {
	req, out := c.UpdateAppMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient permissions to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A RUM app monitor collects telemetry data from your application and sends
// that data to RUM. The data includes performance and reliability information
// such as page load time, client-side errors, and user behavior.
type AppMonitor struct {
	_ struct{} `type:"structure"`

	// A structure that contains much of the configuration data for the app monitor.
	AppMonitorConfiguration *AppMonitorConfiguration `type:"structure"`

	// The date and time that this app monitor was created.
	Created *string `min:"19" type:"string"`

	// A structure that contains information about whether this app monitor stores
	// a copy of the telemetry data that RUM collects using CloudWatch Logs.
	DataStorage *DataStorage `type:"structure"`

	// The top-level internet domain name for which your application has administrative
	// authority.
	Domain *string `min:"1" type:"string"`

	// The unique ID of this app monitor.
	Id *string `min:"36" type:"string"`

	// The date and time of the most recent changes to this app monitor's configuration.
	LastModified *string `min:"19" type:"string"`

	// The name of the app monitor.
	Name *string `min:"1" type:"string"`

	// The current state of the app monitor.
	State *string `type:"string" enum:"StateEnum"`

	// The list of tag keys and values associated with this app monitor.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppMonitor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppMonitor) GoString() string {
	return s.String()
}

// SetAppMonitorConfiguration sets the AppMonitorConfiguration field's value.
func (s *AppMonitor) SetAppMonitorConfiguration(v *AppMonitorConfiguration) *AppMonitor {
	s.AppMonitorConfiguration = v
	return s
}

// SetCreated sets the Created field's value.
func (s *AppMonitor) SetCreated(v string) *AppMonitor {
	s.Created = &v
	return s
}

// SetDataStorage sets the DataStorage field's value.
func (s *AppMonitor) SetDataStorage(v *DataStorage) *AppMonitor {
	s.DataStorage = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *AppMonitor) SetDomain(v string) *AppMonitor {
	s.Domain = &v
	return s
}

// SetId sets the Id field's value.
func (s *AppMonitor) SetId(v string) *AppMonitor {
	s.Id = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *AppMonitor) SetLastModified(v string) *AppMonitor {
	s.LastModified = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppMonitor) SetName(v string) *AppMonitor {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *AppMonitor) SetState(v string) *AppMonitor {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AppMonitor) SetTags(v map[string]*string) *AppMonitor {
	s.Tags = v
	return s
}

// This structure contains much of the configuration data for the app monitor.
type AppMonitorConfiguration struct {
	_ struct{} `type:"structure"`

	// If you set this to true, the RUM web client sets two cookies, a session cookie
	// and a user cookie. The cookies allow the RUM web client to collect data relating
	// to the number of users an application has and the behavior of the application
	// across a sequence of events. Cookies are stored in the top-level domain of
	// the current page.
	AllowCookies *bool `type:"boolean"`

	// If you set this to true, RUM enables X-Ray tracing for the user sessions
	// that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests.
	// It also records an X-Ray segment for allowed HTTP requests. You can see traces
	// and segments from these user sessions in the X-Ray console and the CloudWatch
	// ServiceLens console. For more information, see What is X-Ray? (https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html)
	EnableXRay *bool `type:"boolean"`

	// A list of URLs in your website or application to exclude from RUM data collection.
	//
	// You can't include both ExcludedPages and IncludedPages in the same operation.
	ExcludedPages []*string `type:"list"`

	// A list of pages in the CloudWatch RUM console that are to be displayed with
	// a "favorite" icon.
	FavoritePages []*string `type:"list"`

	// The ARN of the guest IAM role that is attached to the Amazon Cognito identity
	// pool that is used to authorize the sending of data to RUM.
	GuestRoleArn *string `type:"string"`

	// The ID of the Amazon Cognito identity pool that is used to authorize the
	// sending of data to RUM.
	IdentityPoolId *string `min:"1" type:"string"`

	// If this app monitor is to collect data from only certain pages in your application,
	// this structure lists those pages.
	//
	//    <p>You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code>
	//    in the same operation.</p>
	IncludedPages []*string `type:"list"`

	// Specifies the percentage of user sessions to use for RUM data collection.
	// Choosing a higher percentage gives you more data but also incurs more costs.
	//
	// The number you specify is the percentage of user sessions that will be used.
	//
	// If you omit this parameter, the default of 10 is used.
	SessionSampleRate *float64 `type:"double"`

	// An array that lists the types of telemetry data that this app monitor is
	// to collect.
	//
	//    * errors indicates that RUM collects data about unhandled JavaScript errors
	//    raised by your application.
	//
	//    * performance indicates that RUM collects performance data about how your
	//    application and its resources are loaded and rendered. This includes Core
	//    Web Vitals.
	//
	//    * http indicates that RUM collects data about HTTP errors thrown by your
	//    application.
	Telemetries []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppMonitorConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppMonitorConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppMonitorConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppMonitorConfiguration"}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowCookies sets the AllowCookies field's value.
func (s *AppMonitorConfiguration) SetAllowCookies(v bool) *AppMonitorConfiguration {
	s.AllowCookies = &v
	return s
}

// SetEnableXRay sets the EnableXRay field's value.
func (s *AppMonitorConfiguration) SetEnableXRay(v bool) *AppMonitorConfiguration {
	s.EnableXRay = &v
	return s
}

// SetExcludedPages sets the ExcludedPages field's value.
func (s *AppMonitorConfiguration) SetExcludedPages(v []*string) *AppMonitorConfiguration {
	s.ExcludedPages = v
	return s
}

// SetFavoritePages sets the FavoritePages field's value.
func (s *AppMonitorConfiguration) SetFavoritePages(v []*string) *AppMonitorConfiguration {
	s.FavoritePages = v
	return s
}

// SetGuestRoleArn sets the GuestRoleArn field's value.
func (s *AppMonitorConfiguration) SetGuestRoleArn(v string) *AppMonitorConfiguration {
	s.GuestRoleArn = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *AppMonitorConfiguration) SetIdentityPoolId(v string) *AppMonitorConfiguration {
	s.IdentityPoolId = &v
	return s
}

// SetIncludedPages sets the IncludedPages field's value.
func (s *AppMonitorConfiguration) SetIncludedPages(v []*string) *AppMonitorConfiguration {
	s.IncludedPages = v
	return s
}

// SetSessionSampleRate sets the SessionSampleRate field's value.
func (s *AppMonitorConfiguration) SetSessionSampleRate(v float64) *AppMonitorConfiguration {
	s.SessionSampleRate = &v
	return s
}

// SetTelemetries sets the Telemetries field's value.
func (s *AppMonitorConfiguration) SetTelemetries(v []*string) *AppMonitorConfiguration {
	s.Telemetries = v
	return s
}

// A structure that contains information about the RUM app monitor.
type AppMonitorDetails struct {
	_ struct{} `type:"structure"`

	// The unique ID of the app monitor.
	Id *string `locationName:"id" type:"string"`

	// The name of the app monitor.
	Name *string `locationName:"name" type:"string"`

	// The version of the app monitor.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppMonitorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppMonitorDetails) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *AppMonitorDetails) SetId(v string) *AppMonitorDetails {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppMonitorDetails) SetName(v string) *AppMonitorDetails {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AppMonitorDetails) SetVersion(v string) *AppMonitorDetails {
	s.Version = &v
	return s
}

// A structure that includes some data about app monitors and their settings.
type AppMonitorSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the app monitor was created.
	Created *string `min:"19" type:"string"`

	// The unique ID of this app monitor.
	Id *string `min:"36" type:"string"`

	// The date and time of the most recent changes to this app monitor's configuration.
	LastModified *string `min:"19" type:"string"`

	// The name of this app monitor.
	Name *string `min:"1" type:"string"`

	// The current state of this app monitor.
	State *string `type:"string" enum:"StateEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppMonitorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppMonitorSummary) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *AppMonitorSummary) SetCreated(v string) *AppMonitorSummary {
	s.Created = &v
	return s
}

// SetId sets the Id field's value.
func (s *AppMonitorSummary) SetId(v string) *AppMonitorSummary {
	s.Id = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *AppMonitorSummary) SetLastModified(v string) *AppMonitorSummary {
	s.LastModified = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppMonitorSummary) SetName(v string) *AppMonitorSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *AppMonitorSummary) SetState(v string) *AppMonitorSummary {
	s.State = &v
	return s
}

// This operation attempted to create a resource that already exists.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the resource that is associated with the error.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`

	// The type of the resource that is associated with the error.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAppMonitorInput struct {
	_ struct{} `type:"structure"`

	// A structure that contains much of the configuration data for the app monitor.
	// If you are using Amazon Cognito for authorization, you must include this
	// structure in your request, and it must include the ID of the Amazon Cognito
	// identity pool to use for authorization. If you don't include AppMonitorConfiguration,
	// you must set up your own authorization method. For more information, see
	// Authorize your application to send data to Amazon Web Services (https://docs.aws.amazon.com/monitoring/CloudWatch-RUM-get-started-authorization.html).
	//
	// If you omit this argument, the sample rate used for RUM is set to 10% of
	// the user sessions.
	AppMonitorConfiguration *AppMonitorConfiguration `type:"structure"`

	// Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter
	// specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch
	// Logs in your account. This enables you to keep the telemetry data for more
	// than 30 days, but it does incur Amazon CloudWatch Logs charges.
	//
	// If you omit this parameter, the default is false.
	CwLogEnabled *bool `type:"boolean"`

	// The top-level internet domain name for which your application has administrative
	// authority.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// A name for the app monitor.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Assigns one or more tags (key-value pairs) to the app monitor.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	//
	// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
	// strictly as strings of characters.
	//
	//    <p>You can associate as many as 50 tags with an app monitor.</p> <p>For
	//    more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
	//    Amazon Web Services resources</a>.</p>
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppMonitorInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.AppMonitorConfiguration != nil {
		if err := s.AppMonitorConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AppMonitorConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppMonitorConfiguration sets the AppMonitorConfiguration field's value.
func (s *CreateAppMonitorInput) SetAppMonitorConfiguration(v *AppMonitorConfiguration) *CreateAppMonitorInput {
	s.AppMonitorConfiguration = v
	return s
}

// SetCwLogEnabled sets the CwLogEnabled field's value.
func (s *CreateAppMonitorInput) SetCwLogEnabled(v bool) *CreateAppMonitorInput {
	s.CwLogEnabled = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateAppMonitorInput) SetDomain(v string) *CreateAppMonitorInput {
	s.Domain = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppMonitorInput) SetName(v string) *CreateAppMonitorInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppMonitorInput) SetTags(v map[string]*string) *CreateAppMonitorInput {
	s.Tags = v
	return s
}

type CreateAppMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the new app monitor.
	Id *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppMonitorOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateAppMonitorOutput) SetId(v string) *CreateAppMonitorOutput {
	s.Id = &v
	return s
}

// A structure that contains the information about whether the app monitor stores
// copies of the data that RUM collects in CloudWatch Logs. If it does, this
// structure also contains the name of the log group.
type CwLog struct {
	_ struct{} `type:"structure"`

	// Indicated whether the app monitor stores copies of the data that RUM collects
	// in CloudWatch Logs.
	CwLogEnabled *bool `type:"boolean"`

	// The name of the log group where the copies are stored.
	CwLogGroup *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CwLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CwLog) GoString() string {
	return s.String()
}

// SetCwLogEnabled sets the CwLogEnabled field's value.
func (s *CwLog) SetCwLogEnabled(v bool) *CwLog {
	s.CwLogEnabled = &v
	return s
}

// SetCwLogGroup sets the CwLogGroup field's value.
func (s *CwLog) SetCwLogGroup(v string) *CwLog {
	s.CwLogGroup = &v
	return s
}

// A structure that contains information about whether this app monitor stores
// a copy of the telemetry data that RUM collects using CloudWatch Logs.
type DataStorage struct {
	_ struct{} `type:"structure"`

	// A structure that contains the information about whether the app monitor stores
	// copies of the data that RUM collects in CloudWatch Logs. If it does, this
	// structure also contains the name of the log group.
	CwLog *CwLog `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataStorage) GoString() string {
	return s.String()
}

// SetCwLog sets the CwLog field's value.
func (s *DataStorage) SetCwLog(v *CwLog) *DataStorage {
	s.CwLog = v
	return s
}

type DeleteAppMonitorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the app monitor to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppMonitorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteAppMonitorInput) SetName(v string) *DeleteAppMonitorInput {
	s.Name = &v
	return s
}

type DeleteAppMonitorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppMonitorOutput) GoString() string {
	return s.String()
}

type GetAppMonitorDataInput struct {
	_ struct{} `type:"structure"`

	// An array of structures that you can use to filter the results to those that
	// match one or more sets of key-value pairs that you specify.
	Filters []*QueryFilter `type:"list"`

	// The maximum number of results to return in one operation.
	MaxResults *int64 `type:"integer"`

	// The name of the app monitor that collected the data that you want to retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// Use the token returned by the previous operation to request the next page
	// of results.
	NextToken *string `type:"string"`

	// A structure that defines the time range that you want to retrieve results
	// from.
	//
	// TimeRange is a required field
	TimeRange *TimeRange `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppMonitorDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppMonitorDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppMonitorDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppMonitorDataInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeRange"))
	}
	if s.TimeRange != nil {
		if err := s.TimeRange.Validate(); err != nil {
			invalidParams.AddNested("TimeRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *GetAppMonitorDataInput) SetFilters(v []*QueryFilter) *GetAppMonitorDataInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAppMonitorDataInput) SetMaxResults(v int64) *GetAppMonitorDataInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAppMonitorDataInput) SetName(v string) *GetAppMonitorDataInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAppMonitorDataInput) SetNextToken(v string) *GetAppMonitorDataInput {
	s.NextToken = &v
	return s
}

// SetTimeRange sets the TimeRange field's value.
func (s *GetAppMonitorDataInput) SetTimeRange(v *TimeRange) *GetAppMonitorDataInput {
	s.TimeRange = v
	return s
}

type GetAppMonitorDataOutput struct {
	_ struct{} `type:"structure"`

	// The events that RUM collected that match your request.
	Events []*string `type:"list"`

	// A token that you can use in a subsequent operation to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppMonitorDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppMonitorDataOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *GetAppMonitorDataOutput) SetEvents(v []*string) *GetAppMonitorDataOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAppMonitorDataOutput) SetNextToken(v string) *GetAppMonitorDataOutput {
	s.NextToken = &v
	return s
}

type GetAppMonitorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The app monitor to retrieve information for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppMonitorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetAppMonitorInput) SetName(v string) *GetAppMonitorInput {
	s.Name = &v
	return s
}

type GetAppMonitorOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing all the configuration information for the app monitor.
	AppMonitor *AppMonitor `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppMonitorOutput) GoString() string {
	return s.String()
}

// SetAppMonitor sets the AppMonitor field's value.
func (s *GetAppMonitorOutput) SetAppMonitor(v *AppMonitor) *GetAppMonitorOutput {
	s.AppMonitor = v
	return s
}

// Internal service exception.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The value of a parameter in the request caused an error.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAppMonitorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in one operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Use the token returned by the previous operation to request the next page
	// of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppMonitorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppMonitorsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppMonitorsInput) SetMaxResults(v int64) *ListAppMonitorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppMonitorsInput) SetNextToken(v string) *ListAppMonitorsInput {
	s.NextToken = &v
	return s
}

type ListAppMonitorsOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain information about the returned app monitors.
	AppMonitorSummaries []*AppMonitorSummary `type:"list"`

	// A token that you can use in a subsequent operation to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppMonitorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppMonitorsOutput) GoString() string {
	return s.String()
}

// SetAppMonitorSummaries sets the AppMonitorSummaries field's value.
func (s *ListAppMonitorsOutput) SetAppMonitorSummaries(v []*AppMonitorSummary) *ListAppMonitorsOutput {
	s.AppMonitorSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppMonitorsOutput) SetNextToken(v string) *ListAppMonitorsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource that you want to see the tags of.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource that you are viewing.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The list of tag keys and values associated with the resource you specified.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceOutput) SetResourceArn(v string) *ListTagsForResourceOutput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type PutRumEventsInput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the app monitor that collected
	// this telemetry information.
	//
	// AppMonitorDetails is a required field
	AppMonitorDetails *AppMonitorDetails `type:"structure" required:"true"`

	// A unique identifier for this batch of RUM event data.
	//
	// BatchId is a required field
	BatchId *string `type:"string" required:"true"`

	// The ID of the app monitor that is sending this data.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"36" type:"string" required:"true"`

	// An array of structures that contain the telemetry event data.
	//
	// RumEvents is a required field
	RumEvents []*RumEvent `type:"list" required:"true"`

	// A structure that contains information about the user session that this batch
	// of events was collected from.
	//
	// UserDetails is a required field
	UserDetails *UserDetails `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRumEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRumEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRumEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRumEventsInput"}
	if s.AppMonitorDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("AppMonitorDetails"))
	}
	if s.BatchId == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchId"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.RumEvents == nil {
		invalidParams.Add(request.NewErrParamRequired("RumEvents"))
	}
	if s.UserDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("UserDetails"))
	}
	if s.RumEvents != nil {
		for i, v := range s.RumEvents {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RumEvents", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppMonitorDetails sets the AppMonitorDetails field's value.
func (s *PutRumEventsInput) SetAppMonitorDetails(v *AppMonitorDetails) *PutRumEventsInput {
	s.AppMonitorDetails = v
	return s
}

// SetBatchId sets the BatchId field's value.
func (s *PutRumEventsInput) SetBatchId(v string) *PutRumEventsInput {
	s.BatchId = &v
	return s
}

// SetId sets the Id field's value.
func (s *PutRumEventsInput) SetId(v string) *PutRumEventsInput {
	s.Id = &v
	return s
}

// SetRumEvents sets the RumEvents field's value.
func (s *PutRumEventsInput) SetRumEvents(v []*RumEvent) *PutRumEventsInput {
	s.RumEvents = v
	return s
}

// SetUserDetails sets the UserDetails field's value.
func (s *PutRumEventsInput) SetUserDetails(v *UserDetails) *PutRumEventsInput {
	s.UserDetails = v
	return s
}

type PutRumEventsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRumEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRumEventsOutput) GoString() string {
	return s.String()
}

// A structure that defines a key and values that you can use to filter the
// results. The only performance events that are returned are those that have
// values matching the ones that you specify in one of your QueryFilter structures.
//
// For example, you could specify Browser as the Name and specify Chrome,Firefox
// as the Values to return events generated only from those browsers.
//
// Specifying Invert as the Name works as a "not equal to" filter. For example,
// specify Invert as the Name and specify Chrome as the value to return all
// events except events from user sessions with the Chrome browser.
type QueryFilter struct {
	_ struct{} `type:"structure"`

	// The name of a key to search for. The filter returns only the events that
	// match the Name and Values that you specify.
	//
	// Valid values for Name are Browser | Device | Country | Page | OS | EventType
	// | Invert
	Name *string `type:"string"`

	// The values of the Name that are to be be included in the returned results.
	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *QueryFilter) SetName(v string) *QueryFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *QueryFilter) SetValues(v []*string) *QueryFilter {
	s.Values = v
	return s
}

// Resource not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the resource that is associated with the error.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`

	// The type of the resource that is associated with the error.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that contains the information for one performance event that
// RUM collects from a user session with your application.
type RumEvent struct {
	_ struct{} `type:"structure"`

	// A string containing details about the event.
	//
	// Details is a required field
	Details aws.JSONValue `locationName:"details" type:"jsonvalue" required:"true"`

	// A unique ID for this event.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Metadata about this event, which contains a JSON serialization of the identity
	// of the user for this session. The user information comes from information
	// such as the HTTP user-agent request header and document interface.
	Metadata aws.JSONValue `locationName:"metadata" type:"jsonvalue"`

	// The exact time that this event occurred.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" required:"true"`

	// The JSON schema that denotes the type of event this is, such as a page load
	// or a new session.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RumEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RumEvent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RumEvent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RumEvent"}
	if s.Details == nil {
		invalidParams.Add(request.NewErrParamRequired("Details"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetails sets the Details field's value.
func (s *RumEvent) SetDetails(v aws.JSONValue) *RumEvent {
	s.Details = v
	return s
}

// SetId sets the Id field's value.
func (s *RumEvent) SetId(v string) *RumEvent {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *RumEvent) SetMetadata(v aws.JSONValue) *RumEvent {
	s.Metadata = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *RumEvent) SetTimestamp(v time.Time) *RumEvent {
	s.Timestamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *RumEvent) SetType(v string) *RumEvent {
	s.Type = &v
	return s
}

// This request exceeds a service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch RUM resource that you're adding tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The list of key-value pairs to associate with the resource.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was throttled because of quota limits.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the service quota that was exceeded.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The value of a parameter in the request caused an error.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The ID of the service that is associated with the error.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that defines the time range that you want to retrieve results
// from.
type TimeRange struct {
	_ struct{} `type:"structure"`

	// The beginning of the time range to retrieve performance events from.
	//
	// After is a required field
	After *int64 `type:"long" required:"true"`

	// The end of the time range to retrieve performance events from. If you omit
	// this, the time range extends to the time that this operation is performed.
	Before *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeRange"}
	if s.After == nil {
		invalidParams.Add(request.NewErrParamRequired("After"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfter sets the After field's value.
func (s *TimeRange) SetAfter(v int64) *TimeRange {
	s.After = &v
	return s
}

// SetBefore sets the Before field's value.
func (s *TimeRange) SetBefore(v int64) *TimeRange {
	s.Before = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the CloudWatch RUM resource that you're removing tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAppMonitorInput struct {
	_ struct{} `type:"structure"`

	// A structure that contains much of the configuration data for the app monitor.
	// If you are using Amazon Cognito for authorization, you must include this
	// structure in your request, and it must include the ID of the Amazon Cognito
	// identity pool to use for authorization. If you don't include AppMonitorConfiguration,
	// you must set up your own authorization method. For more information, see
	// Authorize your application to send data to Amazon Web Services (https://docs.aws.amazon.com/monitoring/CloudWatch-RUM-get-started-authorization.html).
	AppMonitorConfiguration *AppMonitorConfiguration `type:"structure"`

	// Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter
	// specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch
	// Logs in your account. This enables you to keep the telemetry data for more
	// than 30 days, but it does incur Amazon CloudWatch Logs charges.
	CwLogEnabled *bool `type:"boolean"`

	// The top-level internet domain name for which your application has administrative
	// authority.
	Domain *string `min:"1" type:"string"`

	// The name of the app monitor to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppMonitorInput"}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.AppMonitorConfiguration != nil {
		if err := s.AppMonitorConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AppMonitorConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppMonitorConfiguration sets the AppMonitorConfiguration field's value.
func (s *UpdateAppMonitorInput) SetAppMonitorConfiguration(v *AppMonitorConfiguration) *UpdateAppMonitorInput {
	s.AppMonitorConfiguration = v
	return s
}

// SetCwLogEnabled sets the CwLogEnabled field's value.
func (s *UpdateAppMonitorInput) SetCwLogEnabled(v bool) *UpdateAppMonitorInput {
	s.CwLogEnabled = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *UpdateAppMonitorInput) SetDomain(v string) *UpdateAppMonitorInput {
	s.Domain = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppMonitorInput) SetName(v string) *UpdateAppMonitorInput {
	s.Name = &v
	return s
}

type UpdateAppMonitorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppMonitorOutput) GoString() string {
	return s.String()
}

// A structure that contains information about the user session that this batch
// of events was collected from.
type UserDetails struct {
	_ struct{} `type:"structure"`

	// The session ID that the performance events are from.
	SessionId *string `locationName:"sessionId" type:"string"`

	// The ID of the user for this user session. This ID is generated by RUM and
	// does not include any personally identifiable information about the user.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserDetails) GoString() string {
	return s.String()
}

// SetSessionId sets the SessionId field's value.
func (s *UserDetails) SetSessionId(v string) *UserDetails {
	s.SessionId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UserDetails) SetUserId(v string) *UserDetails {
	s.UserId = &v
	return s
}

// One of the arguments for the request is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// StateEnumCreated is a StateEnum enum value
	StateEnumCreated = "CREATED"

	// StateEnumDeleting is a StateEnum enum value
	StateEnumDeleting = "DELETING"

	// StateEnumActive is a StateEnum enum value
	StateEnumActive = "ACTIVE"
)

// StateEnum_Values returns all elements of the StateEnum enum
func StateEnum_Values() []string {
	return []string{
		StateEnumCreated,
		StateEnumDeleting,
		StateEnumActive,
	}
}

const (
	// TelemetryErrors is a Telemetry enum value
	TelemetryErrors = "errors"

	// TelemetryPerformance is a Telemetry enum value
	TelemetryPerformance = "performance"

	// TelemetryHttp is a Telemetry enum value
	TelemetryHttp = "http"
)

// Telemetry_Values returns all elements of the Telemetry enum
func Telemetry_Values() []string {
	return []string{
		TelemetryErrors,
		TelemetryPerformance,
		TelemetryHttp,
	}
}
