#
# Test driver

EXIT_NO_PROBLEMS=0
ERROR_FILE_ACCESS=1
ERROR_DIR_ACCESS=2
ERROR_FILE_FORMAT=3
ERROR_MEMORY=4

# File from command line has not been found
EXIT_FILE_NOT_FOUND=8

#  Exit codes for test mode
#  SFV file has not been found to verify at least one of specified files
EXIT_SFV_NOT_FOUND=9

#  Tere are at least one file with different CRC and at least one missing file
EXIT_TESTED_DIFFERENT_MISSING=10

#  Tere are at least one file with different CRC no  missing files
EXIT_TESTED_DIFFERENT=11

#  Tested file have the same SRC as expected but in there are at least one missing file
EXIT_TESTED_OK_MISSING=12

#  Files tested ok and its CRC has been found in database
EXIT_TESTED_OK_DUPLICATE=20

#  File has not been tested nor SFV found, But it's CRC has been found in database
EXIT_DUPLICATE=21


run_sfv()
{
    expect_rc=$1
    shift
    echo "run# pure-sfv $*"
    echo "Expected return [${expect_rc}]"

    # To avoid * and ? substitution!
    #./pure-sfv $*
    ./pure-sfv "$1" "$2" "$3" "$4" "$5" "$6" "$7" "$8" "$9"

    rc=$?
    if [ "${rc}" != "${expect_rc}" ]; then
        echo "return [${rc}] expected [${expect_rc}]"
        echo "Test <FAIL>"
        exit 1
    fi
    echo "Return [${rc}]"
    echo "Test <PASSED>"
}

remove_test_file()
{
    file_name=$1
    if [ -f "${file_name}" ]; then
        rm "${file_name}";
    else
        echo "Test [${file_name}] do not exists."
        echo "Test <FAIL>"
        exit 1
    fi
}

echo "Test one SFV file"
run_sfv 0 -d ../tests/test1/all.SFV

echo "Test one SFV file wrong name"
run_sfv ${EXIT_SFV_NOT_FOUND} -d -s ../tests/test1/all.sfv

echo "Test one SFV file wrong name but ingnore case so name would be OK"
run_sfv 0 -d -s ../tests/test1/all.sfv -i

echo "Test all SFV file"
run_sfv 0 -D ../tests/test1

echo "Test all SFV file and only *.bin"
run_sfv 0 -D ../tests/test1 "*.bin"

echo "Test non existent file"
run_sfv ${EXIT_FILE_NOT_FOUND} -D ../tests/test1 -f wrong_name

echo "Test different case for file names file"
run_sfv ${EXIT_TESTED_OK_MISSING} -d ../tests/test2_case/all.SFV

echo "Test different case for file names file, Ignore case"
run_sfv 0 -i -d ../tests/test2_case/all.SFV

echo "Test Missing files"
run_sfv ${EXIT_TESTED_OK_MISSING} -d ../tests/test3_missing/all.SFV

echo "Test Missing files Ignore data? files"
run_sfv 0 -d -E "data?" ../tests/test3_missing/all.SFV

echo "Test Missing files Only Test *.bin files"
run_sfv 0 -d -I "*.bin" ../tests/test3_missing/all.SFV

echo "Test Missing files Only Test *.bin exclude *2* files, wrong order!"
run_sfv 0 -d -I "*.bin" -E "*2*" ../tests/test3_missing/all.SFV

echo "Test Missing files Only Test *.bin exclude *2* files, correct order!"
run_sfv 0 -d -E "*2*" -I "*.bin" ../tests/test3_missing/all.SFV

echo "Test BAD SRC files and Missing"
run_sfv ${EXIT_TESTED_DIFFERENT_MISSING} -D ../tests/test4_bad_crc/

echo "Test BAD SRC files and Missing"
run_sfv ${EXIT_TESTED_DIFFERENT_MISSING} -d ../tests/test4_bad_crc/all.SFV

echo "Test BAD SRC files"
run_sfv ${EXIT_TESTED_DIFFERENT} -d -I "*.bin" ../tests/test4_bad_crc/all.SFV

echo "Test Ignore file test only data1 and data2"
run_sfv 0 -d -E "data3" -I "data?" ../tests/test4_bad_crc/all.SFV

echo "Test sub directory"
run_sfv 0 -D ../tests/test5_sub_dir -R

echo "Test sub Only directory 3"
run_sfv 0 -D ../tests/test5_sub_dir -R -s *3.SFV

echo "Test sub Only directory sub1.SFV"
run_sfv 0 -D ../tests/test5_sub_dir -R -s sub1.SFV

echo "Test sub Only *.dat files, there are not such files!"
run_sfv 0 -D ../tests/test5_sub_dir -R -I "*.dat"

echo "Test sub Only *.dat files, there are not such files! Ignor Empty Dir in Report."
run_sfv 0 -D ../tests/test5_sub_dir -R -I "*.dat" -X

echo "Test Nothing"
run_sfv 0 -D ../tests

echo "Test All"
run_sfv ${EXIT_TESTED_DIFFERENT_MISSING} -D ../tests -R

echo "Test All Quiet"
run_sfv ${EXIT_TESTED_DIFFERENT_MISSING} -q -D ../tests -R

echo "--------------- Create SFV tests --------------------"
run_sfv 0 -D ../tests/test1 -c -s test_sfv_create.sfv

echo "Test if created file is OK"
run_sfv 0 -D ../tests/test1 -s test_sfv_create.sfv

remove_test_file ../tests/test1/test_sfv_create.sfv

echo "Create and include only *bin"
run_sfv 0 -D ../tests/test1 -c -s test_sfv_create.sfv -I "*.bin"

echo "Test if created file is OK"
run_sfv 0 -D ../tests/test1 -s test_sfv_create.sfv

remove_test_file ../tests/test1/test_sfv_create.sfv


echo "Create and include only t1.bin"
run_sfv 0 -D ../tests/test1 -c -s test_sfv_create.sfv -I t1.bin

echo "Test if created file is OK"
run_sfv 0 -D ../tests/test1 -s test_sfv_create.sfv

remove_test_file ../tests/test1/test_sfv_create.sfv

echo "Create and include only wrong.bin"
run_sfv ${EXIT_FILE_NOT_FOUND} -D ../tests/test1 -c -s test_sfv_create.sfv -f wrong.bin

echo "Create files in each directory"
run_sfv 0 -D ../tests -c -s test_sfv_create.sfv -R

remove_test_file ../tests/test1/test_sfv_create.sfv
remove_test_file ../tests/test2_case/test_sfv_create.sfv
remove_test_file ../tests/test3_missing/test_sfv_create.sfv
remove_test_file ../tests/test4_bad_crc/test_sfv_create.sfv
remove_test_file ../tests/test5_sub_dir/sub_dir1/test_sfv_create.sfv
remove_test_file ../tests/test5_sub_dir/sub_dir2/test_sfv_create.sfv
remove_test_file ../tests/test5_sub_dir/sub_dir3/test_sfv_create.sfv
remove_test_file ../tests/test6_make_name/test_sfv_create.sfv

echo "Create files in each directory, where No No_SFV*.flag exists"
run_sfv 0 -D ../tests -c -s "No_SFV*.flag" -R -i -E "*.sfv"

#See if file names has been created properly.
remove_test_file ../tests/test1/test1.sfv
remove_test_file ../tests/test2_case/test2_case.sfv
remove_test_file ../tests/test3_missing/test3_missing.sfv
remove_test_file ../tests/test4_bad_crc/test4_bad_crc.sfv
remove_test_file ../tests/test5_sub_dir/sub_dir1/data.sfv
remove_test_file ../tests/test5_sub_dir/sub_dir2/sub_dir2.sfv
remove_test_file ../tests/test5_sub_dir/sub_dir3/the_data.sfv
remove_test_file ../tests/test6_make_name/the_data.sfv


