/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CompositeDataProvider;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.PyDataViewPanelFactory;
import com.jetbrains.python.debugger.containerview.PyDataViewerAbstractPanel;
import com.jetbrains.python.debugger.containerview.PyDataViewerCommunityPanel;
import com.jetbrains.python.debugger.containerview.PyDataViewerModel;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanelHelper;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0018J\b\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002J\b\u0010#\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "isPanelFromFactory", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/debugger/PyFrameAccessor;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFrameAccessor", "()Lcom/jetbrains/python/debugger/PyFrameAccessor;", "component", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel;", "getComponent", "()Lcom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel;", "setComponent", "(Lcom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel;)V", "getDataViewerModel", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerModel;", "addListener", "", "onNameChangedListener", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel$OnNameChangedListener;", "switchBetweenCommunityAndFactoriesTables", "isPanelsFromFactoryAvailable", "createPanelFromFactory", "dataViewerModel", "isSupportedByCommunityDataViewer", "debugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "setupDataProvider", "dispose", "Companion", "intellij.python.community.impl"})
public final class PyDataViewerPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PyFrameAccessor frameAccessor;
    private boolean isPanelFromFactory;
    @NotNull
    private PyDataViewerAbstractPanel component;
    @NotNull
    private static final DataKey<PyDataViewerPanel> PY_DATA_VIEWER_PANEL_KEY = DataKey.Companion.create("PY_DATA_VIEWER_PANEL_KEY");

    public PyDataViewerPanel(@NotNull Project project, @NotNull PyFrameAccessor frameAccessor, boolean isPanelFromFactory) {
        PyDataViewerAbstractPanel dataViewerPanel;
        PyDataViewerAbstractPanel pyDataViewerAbstractPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        super(new BorderLayout());
        this.project = project;
        this.frameAccessor = frameAccessor;
        this.isPanelFromFactory = isPanelFromFactory;
        PyDataViewerModel dataViewerModel = new PyDataViewerModel(this.project, this.frameAccessor);
        if (this.isPanelsFromFactoryAvailable()) {
            this.isPanelFromFactory = true;
            pyDataViewerAbstractPanel = this.createPanelFromFactory(dataViewerModel);
        } else {
            pyDataViewerAbstractPanel = new PyDataViewerCommunityPanel(dataViewerModel);
        }
        this.component = dataViewerPanel = pyDataViewerAbstractPanel;
        this.add(this.component);
        this.setupDataProvider();
        if (this.isPanelsFromFactoryAvailable() && !this.isPanelFromFactory) {
            PyDataViewerPanelHelper.INSTANCE.createGotItTooltip(this.component, this);
        }
    }

    public /* synthetic */ PyDataViewerPanel(Project project, PyFrameAccessor pyFrameAccessor, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(project, pyFrameAccessor, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PyFrameAccessor getFrameAccessor() {
        return this.frameAccessor;
    }

    @NotNull
    public final PyDataViewerAbstractPanel getComponent() {
        return this.component;
    }

    public final void setComponent(@NotNull PyDataViewerAbstractPanel pyDataViewerAbstractPanel) {
        Intrinsics.checkNotNullParameter((Object)pyDataViewerAbstractPanel, (String)"<set-?>");
        this.component = pyDataViewerAbstractPanel;
    }

    @NotNull
    public final PyDataViewerModel getDataViewerModel() {
        return this.component.getDataViewerModel();
    }

    public final void addListener(@NotNull PyDataViewerAbstractPanel.OnNameChangedListener onNameChangedListener) {
        Intrinsics.checkNotNullParameter((Object)onNameChangedListener, (String)"onNameChangedListener");
        this.component.addListener(onNameChangedListener);
    }

    public final void switchBetweenCommunityAndFactoriesTables() {
        this.isPanelFromFactory = !this.isPanelFromFactory;
        PyDataViewerModel dataViewerModel = this.getDataViewerModel();
        PyDebugValue debugValue = dataViewerModel.getDebugValue();
        if (debugValue != null && !this.isSupportedByCommunityDataViewer(debugValue)) {
            this.isPanelFromFactory = true;
            PyDataViewerPanelHelper.INSTANCE.showCommunityDataViewerRestrictionsBalloon(this.component, this);
            return;
        }
        this.component = this.isPanelFromFactory && this.isPanelsFromFactoryAvailable() ? this.createPanelFromFactory(dataViewerModel) : (PyDataViewerAbstractPanel)new PyDataViewerCommunityPanel(dataViewerModel);
        this.component.recreateTable();
        this.removeAll();
        this.add(this.component);
        if (debugValue != null) {
            PyDataViewerAbstractPanel.apply$default(this.component, debugValue, false, null, 4, null);
        } else {
            PyDataViewerAbstractPanel.apply$default(this.component, dataViewerModel.getSlicing(), false, null, 4, null);
        }
    }

    private final boolean isPanelsFromFactoryAvailable() {
        return !((Collection)PyDataViewPanelFactory.EP_NAME.getExtensionList()).isEmpty();
    }

    private final PyDataViewerAbstractPanel createPanelFromFactory(PyDataViewerModel dataViewerModel) {
        PyDataViewerAbstractPanel pyDataViewerAbstractPanel = ((PyDataViewPanelFactory)CollectionsKt.first((List)PyDataViewPanelFactory.EP_NAME.getExtensionList())).createDataViewerPanel(dataViewerModel);
        Intrinsics.checkNotNullExpressionValue((Object)pyDataViewerAbstractPanel, (String)"createDataViewerPanel(...)");
        return pyDataViewerAbstractPanel;
    }

    private final boolean isSupportedByCommunityDataViewer(PyDebugValue debugValue) {
        return !Intrinsics.areEqual((Object)debugValue.getTypeQualifier(), (Object)"polars.dataframe.frame");
    }

    private final void setupDataProvider() {
        DataProvider toolbarDataProvider = arg_0 -> PyDataViewerPanel.setupDataProvider$lambda$0(this, arg_0);
        Companion.addDataProvider(this, toolbarDataProvider);
    }

    public void dispose() {
    }

    private static final Object setupDataProvider$lambda$0(PyDataViewerPanel this$0, String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return PY_DATA_VIEWER_PANEL_KEY.is(dataId) ? this$0 : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel$Companion;", "", "<init>", "()V", "PY_DATA_VIEWER_PANEL_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel;", "getPY_DATA_VIEWER_PANEL_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "addDataProvider", "", "component", "Ljavax/swing/JComponent;", "provider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<PyDataViewerPanel> getPY_DATA_VIEWER_PANEL_KEY() {
            return PY_DATA_VIEWER_PANEL_KEY;
        }

        public final void addDataProvider(@NotNull JComponent component2, @NotNull DataProvider provider) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            DataProvider currentProvider = DataManager.getDataProvider((JComponent)component2);
            if (currentProvider != null) {
                DataManager.removeDataProvider((JComponent)component2);
                DataManager.registerDataProvider((JComponent)component2, (DataProvider)CompositeDataProvider.compose((DataProvider)currentProvider, (DataProvider)provider));
            } else {
                DataManager.registerDataProvider((JComponent)component2, (DataProvider)provider);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

