/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables.inline;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.editor.settings.JupyterSettingsKt;
import com.intellij.jupyter.core.editor.settings.JupyterShowInlineValuesSettingMode;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterInlineDebugRenderer;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.premium.JupyterLicence;
import com.intellij.jupyter.py.variables.JupyterVariablesService;
import com.intellij.jupyter.py.variables.PythonVariablesUtil;
import com.intellij.jupyter.py.variables.inline.JupyterDebuggerInlayListener;
import com.intellij.jupyter.py.variables.inline.JupyterFrameValues;
import com.intellij.jupyter.py.variables.inline.JupyterInlineCallback;
import com.intellij.jupyter.py.variables.inline.JupyterInlinePainter;
import com.intellij.jupyter.py.variables.inline.JupyterInlineService;
import com.intellij.jupyter.py.variables.inline.JupyterInlineValueVisitor;
import com.intellij.jupyter.py.variables.inline.JupyterNotebookSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.debugger.PyStackFrame;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\b\u0010 \u001a\u00020\u001bH\u0002J\b\u0010!\u001a\u00020\u001bH\u0002J\u0006\u0010\"\u001a\u00020\u001bJ\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J\b\u0010)\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlinePainter;", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineCallback;", "Lcom/jetbrains/python/debugger/PyStackFrame$PyStackFrameRefreshedListener;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "frameValues", "Lcom/intellij/jupyter/py/variables/inline/JupyterFrameValues;", "documentListener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "caretListener", "Lcom/intellij/openapi/editor/event/CaretListener;", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "session", "Lcom/intellij/jupyter/py/variables/inline/JupyterNotebookSession;", "settings", "Lcom/intellij/jupyter/core/editor/settings/JupyterSettings;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "jupyterEditor", "Lcom/intellij/openapi/editor/Editor;", "addLineMarkers", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "clearInlayValues", "registerInEditor", "initSettingsListener", "addCaretListener", "updateEditor", "frameChanged", "frameVars", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "scopeOwner", "Lcom/jetbrains/python/codeInsight/controlflow/ScopeOwner;", "stackFrameRefreshed", "refreshInlineValues", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterInlinePainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterInlinePainter.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlinePainter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,192:1\n1869#2:193\n1869#2,2:194\n1870#2:196\n30#3,2:197\n13472#4,2:199\n*S KotlinDebug\n*F\n+ 1 JupyterInlinePainter.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlinePainter\n*L\n67#1:193\n69#1:194,2\n67#1:196\n169#1:197,2\n185#1:199,2\n*E\n"})
public final class JupyterInlinePainter
implements JupyterInlineCallback,
PyStackFrame.PyStackFrameRefreshedListener,
Disposable.Default {
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @NotNull
    private JupyterFrameValues frameValues;
    @Nullable
    private DocumentListener documentListener;
    @Nullable
    private CaretListener caretListener;
    @NotNull
    private final VirtualFile originalFile;
    @NotNull
    private final JupyterNotebookSession session;
    @NotNull
    private final JupyterSettings settings;
    @Nullable
    private MessageBusConnection connection;
    @Nullable
    private final Editor jupyterEditor;

    /*
     * WARNING - void declaration
     */
    public JupyterInlinePainter(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile) {
        void it;
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        this.project = project;
        this.notebookFile = notebookFile;
        this.frameValues = new JupyterFrameValues(null);
        this.originalFile = this.notebookFile.getOriginFile();
        this.session = new JupyterNotebookSession(this.project, this.notebookFile.getFile());
        this.settings = JupyterSettings.Companion.getInstance();
        this.jupyterEditor = JupyterHelper.INSTANCE.getJupyterEditorByOriginalVirtualFile(this.originalFile);
        JupyterDebuggerInlayListener.Companion.getInstance(this.project).startListening();
        MessageBusConnection messageBusConnection2 = messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(JupyterInlineService.Companion.getDisposableTarget(this.project));
        JupyterInlinePainter jupyterInlinePainter = this;
        boolean bl = false;
        Topic topic = PyStackFrame.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        it.subscribe(topic, (Object)this);
        jupyterInlinePainter.connection = messageBusConnection;
        this.registerInEditor();
        this.initSettingsListener();
        this.addCaretListener();
    }

    private final void addLineMarkers(EditorImpl editor) {
        ApplicationManager.getApplication().invokeLater(() -> JupyterInlinePainter.addLineMarkers$lambda$1(this, editor));
    }

    private final void clearInlayValues(Editor editor) {
        Object[] objectArray = new Class[]{InlineDebugRenderer.class, JupyterInlineDebugRenderer.class};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List inlays;
            Class classType = (Class)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)editor.getInlayModel().getAfterLineEndElementsInRange(0, editor.getDocument().getTextLength(), classType), (String)"getAfterLineEndElementsInRange(...)");
            Iterable $this$forEach$iv2 = inlays;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Disposable disposable = (Disposable)element$iv2;
                boolean bl2 = false;
                Disposable disposable2 = disposable;
                Intrinsics.checkNotNull((Object)disposable2);
                Disposer.dispose((Disposable)disposable2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerInEditor() {
        void it;
        DocumentListener documentListener;
        if (this.jupyterEditor == null) {
            return;
        }
        if (!this.settings.getShowInlineValues()) {
            return;
        }
        if (!(this.jupyterEditor instanceof EditorEx)) {
            return;
        }
        if (!(this.jupyterEditor instanceof EditorImpl)) {
            return;
        }
        DocumentListener documentListener2 = this.documentListener;
        if (documentListener2 != null) {
            DocumentListener it2 = documentListener2;
            boolean bl = false;
            ((EditorImpl)this.jupyterEditor).getDocument().removeDocumentListener(it2);
        }
        DocumentListener documentListener3 = documentListener = new DocumentListener(this){
            final /* synthetic */ JupyterInlinePainter this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (JupyterInlinePainter.access$getProject$p(this.this$0).isDisposed()) {
                    return;
                }
                PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)JupyterInlinePainter.access$getProject$p(this.this$0));
                if (!docManager.isCommitted(event.getDocument())) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> registerInEditor.2.documentChanged$lambda$1(this.this$0));
            }

            private static final void documentChanged$lambda$1$lambda$0(JupyterInlinePainter this$0) {
                if (JupyterInlinePainter.access$getProject$p(this$0).isDisposed()) {
                    return;
                }
                JupyterInlinePainter.access$addLineMarkers(this$0, (EditorImpl)JupyterInlinePainter.access$getJupyterEditor$p(this$0));
            }

            private static final void documentChanged$lambda$1(JupyterInlinePainter this$0) {
                if (JupyterInlinePainter.access$getProject$p(this$0).isDisposed()) {
                    return;
                }
                ApplicationManager.getApplication().runReadAction(() -> registerInEditor.2.documentChanged$lambda$1$lambda$0(this$0));
            }
        };
        JupyterInlinePainter jupyterInlinePainter = this;
        boolean bl = false;
        ((EditorImpl)this.jupyterEditor).getDocument().addDocumentListener((DocumentListener)it, (Disposable)this);
        jupyterInlinePainter.documentListener = documentListener;
    }

    private final void initSettingsListener() {
        block1: {
            if (this.jupyterEditor == null) {
                return;
            }
            MessageBusConnection messageBusConnection = this.connection;
            if (messageBusConnection == null) break block1;
            messageBusConnection.subscribe(JupyterSettingsKt.getJUPYTER_SETTINGS_TOPIC(), (arg_0, arg_1) -> JupyterInlinePainter.initSettingsListener$lambda$7(this, arg_0, arg_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCaretListener() {
        void it;
        CaretListener caretListener;
        if (this.jupyterEditor == null) {
            return;
        }
        CaretListener caretListener2 = this.caretListener;
        if (caretListener2 != null) {
            CaretListener it2 = caretListener2;
            boolean bl = false;
            this.jupyterEditor.getCaretModel().removeCaretListener(it2);
        }
        CaretListener caretListener3 = caretListener = new CaretListener(this){
            private Integer prevLine;
            final /* synthetic */ JupyterInlinePainter this$0;
            {
                this.this$0 = $receiver;
            }

            public final Integer getPrevLine() {
                return this.prevLine;
            }

            public final void setPrevLine(Integer n) {
                this.prevLine = n;
            }

            public void caretPositionChanged(CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!JupyterInlinePainter.access$getSettings$p(this.this$0).getShowInlineValues()) {
                    return;
                }
                if (JupyterInlinePainter.access$getSettings$p(this.this$0).getShowInlineValuesMode() == JupyterShowInlineValuesSettingMode.ENTIRE_NOTEBOOK) {
                    return;
                }
                if (!(JupyterInlinePainter.access$getJupyterEditor$p(this.this$0) instanceof EditorImpl)) {
                    return;
                }
                if (JupyterInlinePainter.access$getProject$p(this.this$0).isDisposed()) {
                    return;
                }
                int line = e.getCaret().getLogicalPosition().line;
                Integer n = this.prevLine;
                int n2 = line;
                if (n != null && n == n2) {
                    return;
                }
                this.prevLine = line;
                JupyterInlinePainter.access$refreshInlineValues(this.this$0);
                ApplicationManager.getApplication().runReadAction(() -> addCaretListener.2.caretPositionChanged$lambda$0(this.this$0));
            }

            private static final void caretPositionChanged$lambda$0(JupyterInlinePainter this$0) {
                if (JupyterInlinePainter.access$getProject$p(this$0).isDisposed()) {
                    return;
                }
                JupyterInlinePainter.access$addLineMarkers(this$0, (EditorImpl)JupyterInlinePainter.access$getJupyterEditor$p(this$0));
            }
        };
        JupyterInlinePainter jupyterInlinePainter = this;
        boolean bl = false;
        this.jupyterEditor.getCaretModel().addCaretListener((CaretListener)it, (Disposable)this);
        jupyterInlinePainter.caretListener = caretListener;
    }

    public final void updateEditor() {
        this.registerInEditor();
        this.initSettingsListener();
        this.addCaretListener();
    }

    @Override
    public void frameChanged(@NotNull XValueChildrenList frameVars, @NotNull ScopeOwner scopeOwner) {
        Intrinsics.checkNotNullParameter((Object)frameVars, (String)"frameVars");
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        this.frameValues = new JupyterFrameValues(scopeOwner);
        this.frameValues.update(frameVars);
        this.refreshInlineValues();
    }

    public void stackFrameRefreshed() {
        if (this.project.isDisposed()) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<JupyterVariablesService> serviceClass$iv = JupyterVariablesService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        JupyterVariablesService service = (JupyterVariablesService)object;
        XValueChildrenList xValueChildrenList = service.getVariablesList(this.notebookFile);
        if (xValueChildrenList == null) {
            return;
        }
        XValueChildrenList values = xValueChildrenList;
        ApplicationManager.getApplication().runReadAction(() -> JupyterInlinePainter.stackFrameRefreshed$lambda$10(this, values));
    }

    private final void refreshInlineValues() {
        if (!this.settings.getShowInlineValues()) {
            return;
        }
        Document document = JupyterHelper.INSTANCE.getDocumentByOriginalVirtualFile(this.originalFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        ApplicationManager.getApplication().runReadAction(() -> JupyterInlinePainter.refreshInlineValues$lambda$12(this, document2));
    }

    private static final void addLineMarkers$lambda$1(JupyterInlinePainter this$0, EditorImpl $editor) {
        block2: {
            if (this$0.project.isDisposed()) {
                return;
            }
            this$0.clearInlayValues((Editor)$editor);
            if (JupyterLicence.INSTANCE.isUnpaidVersion()) {
                return;
            }
            PsiFile psiFile2 = PythonVariablesUtil.INSTANCE.getPythonJupyterPsiFile(this$0.project, this$0.originalFile);
            if (psiFile2 == null) break block2;
            psiFile2.accept((PsiElementVisitor)new JupyterInlineValueVisitor($editor, this$0.frameValues, this$0.session));
        }
    }

    private static final void initSettingsListener$lambda$7$lambda$6(JupyterInlinePainter this$0) {
        if (this$0.project.isDisposed()) {
            return;
        }
        this$0.addLineMarkers((EditorImpl)this$0.jupyterEditor);
    }

    private static final void initSettingsListener$lambda$7(JupyterInlinePainter this$0, JupyterSettings before, JupyterSettings after) {
        boolean modeUpdated;
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        if (this$0.project.isDisposed()) {
            return;
        }
        boolean bl = modeUpdated = before.getShowInlineValuesMode() != after.getShowInlineValuesMode();
        if (after.getShowInlineValues() && (modeUpdated || !before.getShowInlineValues())) {
            if (!(this$0.jupyterEditor instanceof EditorImpl)) {
                return;
            }
            ApplicationManager.getApplication().runReadAction(() -> JupyterInlinePainter.initSettingsListener$lambda$7$lambda$6(this$0));
        } else {
            this$0.clearInlayValues(this$0.jupyterEditor);
        }
    }

    private static final void stackFrameRefreshed$lambda$10(JupyterInlinePainter this$0, XValueChildrenList $values) {
        PsiFile psiFile2 = PythonVariablesUtil.INSTANCE.getPythonJupyterPsiFile(this$0.project, this$0.originalFile);
        ScopeOwner scopeOwner = psiFile2 instanceof ScopeOwner ? (ScopeOwner)psiFile2 : null;
        if (scopeOwner == null) {
            return;
        }
        ScopeOwner scopeOwner2 = scopeOwner;
        this$0.frameChanged($values, scopeOwner2);
    }

    private static final void refreshInlineValues$lambda$12(JupyterInlinePainter this$0, Document $document) {
        if (this$0.project.isDisposed()) {
            return;
        }
        Editor[] editorArray = EditorFactory.getInstance().getEditors($document);
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
        Object[] $this$forEach$iv = editorArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Editor editor = (Editor)element$iv;
            boolean bl = false;
            if (!(editor instanceof EditorImpl)) continue;
            this$0.addLineMarkers((EditorImpl)editor);
        }
    }

    public static final /* synthetic */ Project access$getProject$p(JupyterInlinePainter $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$addLineMarkers(JupyterInlinePainter $this, EditorImpl editor) {
        $this.addLineMarkers(editor);
    }

    public static final /* synthetic */ Editor access$getJupyterEditor$p(JupyterInlinePainter $this) {
        return $this.jupyterEditor;
    }

    public static final /* synthetic */ JupyterSettings access$getSettings$p(JupyterInlinePainter $this) {
        return $this.settings;
    }

    public static final /* synthetic */ void access$refreshInlineValues(JupyterInlinePainter $this) {
        $this.refreshInlineValues();
    }
}

