/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.TestOnly;

public final class PersistentFSConstants {
    @ApiStatus.Internal
    public static final int MAX_FILE_LENGTH_TO_CACHE = SystemProperties.getIntProperty("idea.vfs.max-file-length-to-cache", 0x100000);
    private static int ourMaxIntellisenseFileSize = Math.min(FileUtilRt.getUserFileSizeLimit(), FileUtilRt.LARGE_FOR_CONTENT_LOADING);

    @Deprecated
    public static int getMaxIntellisenseFileSize() {
        return ourMaxIntellisenseFileSize;
    }

    @TestOnly
    public static void setMaxIntellisenseFileSize(int sizeInBytes) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException("maxIntellisenseFileSize could be changed only in tests");
        }
        ourMaxIntellisenseFileSize = sizeInBytes;
    }

    private PersistentFSConstants() {
    }
}

