// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/compression/gzip/decompressor/v3/gzip.proto

package decompressorv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Gzip with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Gzip) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Gzip with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in GzipMultiError, or nil if none found.
func (m *Gzip) ValidateAll() error {
	return m.validate(true)
}

func (m *Gzip) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetWindowBits(); wrapper != nil {

		if val := wrapper.GetValue(); val < 9 || val > 15 {
			err := GzipValidationError{
				field:  "WindowBits",
				reason: "value must be inside range [9, 15]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if wrapper := m.GetChunkSize(); wrapper != nil {

		if val := wrapper.GetValue(); val < 4096 || val > 65536 {
			err := GzipValidationError{
				field:  "ChunkSize",
				reason: "value must be inside range [4096, 65536]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return GzipMultiError(errors)
	}

	return nil
}

// GzipMultiError is an error wrapping multiple validation errors returned by
// Gzip.ValidateAll() if the designated constraints aren't met.
type GzipMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GzipMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GzipMultiError) AllErrors() []error { return m }

// GzipValidationError is the validation error returned by Gzip.Validate if the
// designated constraints aren't met.
type GzipValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GzipValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GzipValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GzipValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GzipValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GzipValidationError) ErrorName() string { return "GzipValidationError" }

// Error satisfies the builtin error interface
func (e GzipValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGzip.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GzipValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GzipValidationError{}
