/*
 * exec: A plugin for the Video Disk Recorder
 * Copyright (C) 2007  Winfried Koehler
 * Licence GPL
 *
 * See the README file for copyright information and how to reach the author.
 *
 *
 * SUPPORT FOR OLD VDR VERSIONS < 1.5.7
 *
 * $Id$
 */

#ifndef __EXEC_COMPAT_H_
#define __EXEC_COMPAT_H_

#include <vdr/plugin.h>


/*
 * This header file gives some backward compatibility to older
 * Versions of VDR; nevertheless some of the functionality of
 * the plugin might be lost when trying to use the exec plugin
 * with older vdr versions < 1.5.7
 */



//***************** systemexec *************************************

int systemexec(const char *Command, bool Detached); 

//***************** systemexec *************************************



//***************** trNOOP and trVDR dummies ***********************
#if VDRVERSNUM<10507

#define trNOOP(s) (s)
#define trVDR(s) tr(s)

#endif //VDRVERSNUM < 10507
//***************** trNOOP and trVDR dummies ***********************


//***************** SystemExec *************************************
int SysExec(const char *Command, bool Detached = false);
//***************** SystemExec *************************************


//***************** DoShutdown *************************************
bool DoShutdown(bool force = false);
//***************** DoShutdown *************************************


//***************** ProgramWakeup **********************************
#if VDRVERSNUM < 10501 //1.5.1 introduced cPlugin::WakeupTime
void WarnNoWakeup(void);
#endif
//***************** ProgramWakeup **********************************


#endif
