//////////////////////////////////////////////////////////////////////////////l
//                                                                          //
//                  Network Security Analysis Tool                          //
//              AuditSet.h - auditing class declaration                     //
//                                                                          //
//   Copyright (C) 1999-2002 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef AUDITSET_H
#define AUDITSET_H
#pragma interface "auditset"

#include "nsat.h"
#ifdef HAVE_X11_XLIB_H
#include <X11/Xlib.h>
#endif
#include "services.h"

// how to close our sockets
#define SCLOSE(n)       close(n)

class AuditSet
{
  private:
  ofstream log;

  protected:

  struct sockaddr_in sin;	// socket address of peer

  unsigned int sl;		// sizeof peer

  unsigned int target;		// current host

  int timeout;			// connect timeout

  char *Hostname(void);		// get current hostname

  int firstopen;		// open port on the current host

  short smcheck;		// sendmail exploit check

    public:

  int icmptest(void);		// ping

  void plog(int);		// log a service

  void nstat(int);		// record

  void ftp(int);		// version

  void ssh(int);		// version

  void telnet(int);		// version / os / wingate check

  void smtp(int);		// version / commands check / spamcheck

  void nbind(int);		// iquery test

  void finger(int);		// exploit

  void http(int);		// webscan

  void pop2(int);		// version

  void pop3(int);		// version

  void pmap(int);		// rpc scan

  void nntp(int);		// version

  void smb(int);		// smb audit

  void imap(int);		// version

  void backdoor(int, int);	// try to issue shell cmd

  void nlps(int);		// exploit

  void ircd(int);		// try to log onto irc

  void xwin(int);		// open display

  void nbname(void);		// get netbios name

  void bo(void);		// send BO ping

#ifdef WITH_XPROBE
  void os(void);		// remote OS fingerprinting
#endif

  void snmp(void);		// snmp audit

    AuditSet(void);
   ~AuditSet(void);
};

struct portlist
  {
    int port;
    char *info;
    int vuln;
  };

#endif
