/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.plugins.wifi101.flashers.java;

import cc.arduino.plugins.wifi101.flashers.Flasher;
import cc.arduino.plugins.wifi101.flashers.java.FlasherSerialClient;
import cc.arduino.plugins.wifi101.flashers.java.SSLCertDownloader;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class NinaFlasher
extends Flasher {
    public byte[] md5Checksum;

    public NinaFlasher(String string, String string2, String string3, boolean bl, int n, List<String> list) {
        super(string, string2, string3, bl, n, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFirmware(String string) throws Exception {
        block7: {
            try (FlasherSerialClient flasherSerialClient = null;){
                this.file = this.openFirmwareFile();
                this.progress(10, "Connecting to programmer...");
                flasherSerialClient = new FlasherSerialClient();
                flasherSerialClient.open(string, this.baudrate);
                flasherSerialClient.hello();
                int n = flasherSerialClient.getMaximumPayload();
                byte[] byArray = this.getData();
                int n2 = byArray.length;
                int n3 = 0;
                int n4 = 0;
                this.progress(20, "Erasing target...");
                flasherSerialClient.eraseFlash(n3, n2);
                while (n4 < n2) {
                    this.progress(20 + n4 * 40 / n2, "Programming " + n2 + " bytes ...");
                    int n5 = n;
                    if (n4 + n5 > n2) {
                        n5 = n2 - n4;
                    }
                    flasherSerialClient.writeFlash(n3, Arrays.copyOfRange(byArray, n4, n4 + n5));
                    n4 += n5;
                    n3 += n5;
                }
                this.progress(55, "Verifying...");
                this.md5Checksum = NinaFlasher.getMD5Checksum(byArray);
                n3 = 0;
                byte[] byArray2 = flasherSerialClient.md5Flash(n3, n2);
                this.progress(75, "Verifying...");
                if (Arrays.equals(byArray2, this.md5Checksum)) {
                    this.progress(100, "Done!");
                    break block7;
                }
                throw new Exception("Error validating flashed firmware");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadCertificates(String string, List<String> list) throws Exception {
        try (FlasherSerialClient flasherSerialClient = null;){
            Object object;
            this.file = this.openFirmwareFile();
            this.progress(10, "Connecting to programmer...");
            flasherSerialClient = new FlasherSerialClient();
            flasherSerialClient.open(string, this.baudrate);
            flasherSerialClient.hello();
            int n = flasherSerialClient.getMaximumPayload();
            int n2 = list.size();
            String string2 = "";
            for (String object22 : list) {
                try {
                    object = new URL(object22);
                }
                catch (MalformedURLException n3) {
                    object = new URL("https://" + object22);
                }
                this.progress(30 + 20 * n2 / list.size(), "Downloading certificate from " + object22 + "...");
                Certificate[] malformedURLException = SSLCertDownloader.retrieveFromURL((URL)object);
                X509Certificate n4 = (X509Certificate)malformedURLException[malformedURLException.length - 1];
                string2 = NinaFlasher.convertToPem(n4) + "\n" + string2;
            }
            Object object3 = string2.getBytes();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write((byte[])object3);
            while (byteArrayOutputStream.size() % n != 0) {
                byteArrayOutputStream.write(0);
            }
            object = byteArrayOutputStream.toByteArray();
            int n3 = ((Object)object).length;
            int n4 = 65536;
            int n5 = 0;
            if (n3 > 131072) {
                throw new Exception("Too many certificates!");
            }
            this.progress(20, "Erasing target...");
            flasherSerialClient.eraseFlash(n4, n3);
            while (n5 < n3) {
                this.progress(20 + n5 * 40 / n3, "Programming " + n3 + " bytes ...");
                int n6 = n;
                if (n5 + n6 > n3) {
                    n6 = n3 - n5;
                }
                flasherSerialClient.writeFlash(n4, Arrays.copyOfRange((byte[])object, n5, n5 + n6));
                n5 += n6;
                n4 += n6;
            }
        }
    }

    protected static String convertToPem(X509Certificate x509Certificate) {
        Base64 base64 = new Base64(64, "\n".getBytes());
        String string = "-----BEGIN CERTIFICATE-----\n";
        String string2 = "-----END CERTIFICATE-----";
        try {
            byte[] byArray = x509Certificate.getEncoded();
            String string3 = new String(base64.encode(byArray));
            String string4 = string + string3 + string2;
            return string4;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static byte[] getMD5Checksum(byte[] byArray) throws Exception {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int n = byArray.length;
            if (n > 0) {
                messageDigest.update(byArray, 0, n);
            }
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new Exception("Error in MD5 checksum computation.");
        }
    }
}

