// libpngrewrite.h - part of pngrewrite
// Copyright (C) 2010 by Jason Summers

#ifndef LIBPNGREWRITE_H_INCLUDED
#define LIBPNGREWRITE_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#if defined(_WIN32) && !defined(__GNUC__) && !defined(PNGRW_WINDOWS)
#define PNGRW_WINDOWS
#endif

#ifdef PNGRW_WINDOWS
#include <tchar.h>
#define PNGRW_CHAR TCHAR
#else
#define PNGRW_CHAR char
#endif

#include <stdio.h>

struct pngrw_ctx;
struct pngrw_ctx *pngrw_create(void);
void pngrw_destroy(struct pngrw_ctx *ctx);

int pngrw_read_filename(struct pngrw_ctx *ctx, const PNGRW_CHAR *in_filename);
int pngrw_write_filename(struct pngrw_ctx *ctx, const PNGRW_CHAR *out_filename);

int pngrw_read_stdio(struct pngrw_ctx *ctx, FILE *infp);
int pngrw_write_stdio(struct pngrw_ctx *ctx, FILE *outfp);

typedef void (*pngrw_print_fn_type)(struct pngrw_ctx *ctx, const PNGRW_CHAR *s);

void pngrw_set_print_fn(struct pngrw_ctx *ctx, pngrw_print_fn_type prntfn);
void pngrw_set_error_fn(struct pngrw_ctx *ctx, pngrw_print_fn_type errfn);

void pngrw_set_userdata(struct pngrw_ctx *ctx, void *u);
void *pngrw_get_userdata(struct pngrw_ctx *ctx);
void pngrw_set_sort_by_frequency(struct pngrw_ctx *ctx, int n);

int pngrw_optimize_image(struct pngrw_ctx *ctx);

const PNGRW_CHAR *pngrw_get_version_string(void);

#ifdef __cplusplus
}
#endif

#endif // LIBPNGREWRITE_H_INCLUDED
