/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.importer;

import com.kreative.unicode.data.EncodingList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawImportEncodingList
extends JComboBox {
    private static final long serialVersionUID = 1L;

    public RawImportEncodingList() {
        super(RawImportEncodingList.getEncodingList());
        this.setEditable(false);
        this.setSelectedIndex(7);
    }

    public List<Integer> getSelectedEncoding() {
        if (this.getSelectedIndex() <= 0) {
            return null;
        }
        List list = (List)this.getSelectedItem();
        return list;
    }

    public void applySelectedEncoding(List<Integer> list) {
        if (this.getSelectedIndex() <= 0) {
            return;
        }
        List list2 = (List)this.getSelectedItem();
        int n = list.size();
        int n2 = list2.size();
        for (int i = 0; i < n; ++i) {
            list.set(i, i < n2 ? (Integer)list2.get(i) : -1);
        }
    }

    private static final Object[] getEncodingList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new String("Custom"));
        arrayList.add(new StartFrom(0));
        arrayList.add(new StartFrom(32));
        arrayList.add(new StartFrom(57344));
        arrayList.add(new StartFrom(57376));
        arrayList.add(new StartFrom(61440));
        arrayList.add(new StartFrom(61472));
        arrayList.add(new StartFrom(983040));
        arrayList.add(new StartFrom(0x100000));
        arrayList.addAll(EncodingList.instance().glyphLists());
        return arrayList.toArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StartFrom
    extends AbstractList<Integer> {
        private final int start;
        private final String name;

        public StartFrom(int n) {
            this.start = n;
            String string = Integer.toHexString(n).toUpperCase();
            while (string.length() < 4) {
                string = "0" + string;
            }
            this.name = "Start From U+" + string;
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Integer && (Integer)object >= this.start && (Integer)object < 0x110000;
        }

        @Override
        public Integer get(int n) {
            return this.start + n;
        }

        @Override
        public int indexOf(Object object) {
            return this.contains(object) ? (Integer)object - this.start : -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.contains(object) ? (Integer)object - this.start : -1;
        }

        @Override
        public int size() {
            return 0x110000 - this.start;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

