/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class SFontBitmapFontExporter
implements BitmapFontExporter {
    private int color;

    public SFontBitmapFontExporter() {
        this.color = 0;
    }

    public SFontBitmapFontExporter(int n) {
        this.color = n;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RenderedImage renderedImage = this.exportFontToImage(bitmapFont);
        ImageIO.write(renderedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        RenderedImage renderedImage = this.exportFontToImage(bitmapFont);
        ImageIO.write(renderedImage, "png", outputStream);
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        RenderedImage renderedImage = this.exportFontToImage(bitmapFont);
        ImageIO.write(renderedImage, "png", file);
    }

    public RenderedImage exportFontToImage(BitmapFont bitmapFont) {
        int n;
        int n2;
        BitmapFontGlyph[] bitmapFontGlyphArray = new BitmapFontGlyph[94];
        int[] nArray = new int[94];
        int[] nArray2 = new int[94];
        int[] nArray3 = new int[94];
        for (n2 = 0; n2 < 94; ++n2) {
            bitmapFontGlyphArray[n2] = (BitmapFontGlyph)bitmapFont.getCharacter(n2 + 33);
            if (bitmapFontGlyphArray[n2] == null) {
                bitmapFontGlyphArray[n2] = new BitmapFontGlyph(new byte[1][1], 0, 1, 1);
            }
            nArray[n2] = bitmapFontGlyphArray[n2].getGlyphOffset();
            nArray[n2] = nArray[n2] < 0 ? -nArray[n2] : 1;
            nArray2[n2] = bitmapFontGlyphArray[n2].getCharacterWidth();
            if (nArray2[n2] < 1) {
                nArray2[n2] = 1;
            }
            nArray3[n2] = bitmapFontGlyphArray[n2].getGlyphOffset() + bitmapFontGlyphArray[n2].getGlyphWidth();
            nArray3[n2] = nArray3[n2] > nArray2[n2] ? nArray3[n2] - nArray2[n2] : 1;
        }
        n2 = 0;
        while (n2 + 1 < 94) {
            int n3 = Math.max(nArray3[n2], nArray[n2 + 1]);
            nArray[n2 + 1] = n3;
            nArray3[n2] = n3;
            ++n2;
        }
        n2 = 0;
        for (n = 0; n < 94; ++n) {
            n2 += nArray[n] + nArray2[n] + nArray3[n];
        }
        n = 1 + bitmapFont.getLineAscent() + bitmapFont.getLineDescent() + bitmapFont.getLineGap();
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        int n4 = 0;
        for (int i = 0; i < 94; ++i) {
            int n5;
            for (n5 = 0; n5 < nArray[i]; ++n5) {
                bufferedImage.setRGB(n4 + n5, 0, -65281);
            }
            for (n5 = 0; n5 < nArray3[i]; ++n5) {
                bufferedImage.setRGB(n4 + nArray[i] + nArray2[i] + n5, 0, -65281);
            }
            byte[][] byArray = bitmapFontGlyphArray[i].getGlyph();
            int n6 = 0;
            int n7 = 1 + bitmapFont.getLineAscent() - bitmapFontGlyphArray[i].getGlyphAscent();
            while (n6 < byArray.length) {
                if (n7 > 0 && n7 < n) {
                    int n8 = 0;
                    int n9 = n4 + nArray[i] + bitmapFontGlyphArray[i].getGlyphOffset();
                    while (n8 < byArray[n6].length) {
                        bufferedImage.setRGB(n9, n7, (byArray[n6][n8] & 0xFF) << 24 | this.color & 0xFFFFFF);
                        ++n8;
                        ++n9;
                    }
                }
                ++n6;
                ++n7;
            }
            n4 += nArray[i] + nArray2[i] + nArray3[i];
        }
        return bufferedImage;
    }
}

