/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class DebugRockbox {
    public static void main(String[] stringArray) {
        for (String string : stringArray) {
            System.out.println(string);
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(string));
                DebugRockbox.debugRockbox(new DataInputStream(fileInputStream));
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("  ERROR: " + iOException);
            }
        }
    }

    private static void debugRockbox(DataInputStream dataInputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        System.out.println("Magic:\t" + new String(byArray));
        if (byArray[3] == 49) {
            byte[] byArray2 = new byte[64];
            dataInputStream.readFully(byArray2);
            byte[] byArray3 = new byte[256];
            dataInputStream.readFully(byArray3);
            System.out.println("Name:\t" + new String(byArray2).trim());
            System.out.println("Copyrt:\t" + new String(byArray3).trim());
        }
        int n2 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n3 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n4 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n5 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n6 = Integer.reverseBytes(dataInputStream.readInt());
        int n7 = Integer.reverseBytes(dataInputStream.readInt());
        int n8 = Integer.reverseBytes(dataInputStream.readInt());
        int n9 = Integer.reverseBytes(dataInputStream.readInt());
        int n10 = Integer.reverseBytes(dataInputStream.readInt());
        int n11 = Integer.reverseBytes(dataInputStream.readInt());
        System.out.println("MaxWid:\t" + n2);
        System.out.println("Height:\t" + n3);
        System.out.println("Ascent:\t" + n4);
        System.out.println("Depth:\t" + n5);
        System.out.println("FrstCh:\t" + n6);
        System.out.println("DfltCh:\t" + n7);
        System.out.println("NChars:\t" + n8);
        System.out.println("NBits:\t" + n9);
        System.out.println("NOffst:\t" + n10);
        System.out.println("NWidth:\t" + n11);
        byte[] byArray4 = byArray[3] == 49 ? new byte[(n9 * 2 + 3) / 4 * 4] : new byte[(n9 + 1) / 2 * 2];
        dataInputStream.readFully(byArray4);
        int[] nArray = new int[n10];
        int[] nArray2 = new int[n11];
        for (n = 0; n < n10; ++n) {
            nArray[n] = byArray[3] == 49 ? Integer.reverseBytes(dataInputStream.readInt()) : Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        }
        for (n = 0; n < n11; ++n) {
            nArray2[n] = dataInputStream.readUnsignedByte();
        }
        for (n = 0; n < n8; ++n) {
            byte[] byArray5;
            int n12;
            System.out.println("Glyph " + n + ":");
            int n13 = n < nArray2.length ? nArray2[n] : n2;
            int n14 = (n13 + 15) / 16 * 2;
            if (byArray[3] == 49) {
                n12 = n < nArray.length ? nArray[n] * 2 : n14 * n3 * n;
                byArray5 = DebugRockbox.swab(byArray4, n12, n13, n3);
            } else {
                n12 = n < nArray.length ? nArray[n] : (n3 + 7) / 8 * n2 * n;
                byArray5 = DebugRockbox.rotright(byArray4, n12, n13, n3);
            }
            for (n12 = 0; n12 < n3; ++n12) {
                for (int i = 0; i < n14; ++i) {
                    for (int j = 128; j != 0; j >>= 1) {
                        if ((byArray5[n12 * n14 + i] & j) == 0) {
                            System.out.print(".");
                            continue;
                        }
                        System.out.print("#");
                    }
                }
                System.out.println();
            }
        }
    }

    private static byte[] swab(byte[] byArray, int n, int n2, int n3) {
        int n4 = (n2 + 15) / 16 * 2;
        int n5 = n4 * n3;
        byte[] byArray2 = new byte[n5];
        for (int i = 0; i < n5; ++i) {
            byArray2[i ^ 1] = byArray[n++];
        }
        return byArray2;
    }

    private static byte[] rotright(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = (n2 + 15) / 16;
        int n7 = n6 * n3;
        int[] nArray = new int[n7];
        int n8 = 1;
        for (int i = 0; i < n3; ++i) {
            n5 = i * n6;
            n4 = 32768;
            for (int j = 0; j < n2; ++j) {
                if ((byArray[n + j] & n8) != 0) {
                    int n9 = n5;
                    nArray[n9] = nArray[n9] | n4;
                }
                if ((n4 >>= 1) != 0) continue;
                n4 = 32768;
                ++n5;
            }
            if ((n8 <<= 1) < 256) continue;
            n8 = 1;
            n += n2;
        }
        byte[] byArray2 = new byte[n7 * 2];
        n5 = 0;
        for (n4 = 0; n4 < n7; ++n4) {
            byArray2[n5++] = (byte)(nArray[n4] >> 8);
            byArray2[n5++] = (byte)(nArray[n4] >> 0);
        }
        return byArray2;
    }
}

