/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.truetype.CbdtEntry;
import com.kreative.bitsnpicas.truetype.CbdtEntryFormat17;
import com.kreative.bitsnpicas.truetype.CbdtEntryFormat18;
import com.kreative.bitsnpicas.truetype.CbdtEntryFormat19;
import com.kreative.bitsnpicas.truetype.CmapSubtable;
import com.kreative.bitsnpicas.truetype.CmapTable;
import com.kreative.bitsnpicas.truetype.EbdtComponent;
import com.kreative.bitsnpicas.truetype.EbdtEntry;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat1;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat2;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat5;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat6;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat7;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat8;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat9;
import com.kreative.bitsnpicas.truetype.EbdtTable;
import com.kreative.bitsnpicas.truetype.EblcBitmapSize;
import com.kreative.bitsnpicas.truetype.EblcGlyphIdOffsetPair;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable1;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable2;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable3;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable4;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable5;
import com.kreative.bitsnpicas.truetype.EblcTable;
import com.kreative.bitsnpicas.truetype.HheaTable;
import com.kreative.bitsnpicas.truetype.HmtxTable;
import com.kreative.bitsnpicas.truetype.HmtxTableEntry;
import com.kreative.bitsnpicas.truetype.ListBasedEbdtEntry;
import com.kreative.bitsnpicas.truetype.ListBasedTable;
import com.kreative.bitsnpicas.truetype.Os2Table;
import com.kreative.bitsnpicas.truetype.SbitBigGlyphMetrics;
import com.kreative.bitsnpicas.truetype.SbitLineMetrics;
import com.kreative.bitsnpicas.truetype.SbitSmallGlyphMetrics;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class ExtractCbdt {
    public static void main(String[] stringArray) {
        try {
            System.setProperty("apple.awt.UIElement", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String string : stringArray) {
            File file = new File(string);
            System.out.print("Processing " + file.getAbsolutePath() + "... ");
            try {
                int n;
                int n2;
                Object object;
                CmapTable cmapTable;
                Os2Table os2Table;
                byte[] byArray = new byte[(int)file.length()];
                FileInputStream fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                fileInputStream.close();
                TrueTypeFile trueTypeFile = new TrueTypeFile();
                trueTypeFile.decompile(byArray);
                EbdtTable ebdtTable = (EbdtTable)trueTypeFile.getByTableName("CBDT");
                EblcTable eblcTable = (EblcTable)trueTypeFile.getByTableName("CBLC");
                if (ebdtTable == null || eblcTable == null) {
                    System.out.println("no CBDT/CBLC table found.");
                    continue;
                }
                File file2 = new File(file.getParent(), file.getName() + ".cbdt.d");
                if (!file2.exists()) {
                    file2.mkdir();
                }
                File file3 = new File(file2, "fontinfo.txt");
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
                HheaTable hheaTable = (HheaTable)trueTypeFile.getByTableName("hhea");
                if (hheaTable != null) {
                    printWriter.println("ascent: " + hheaTable.ascent);
                    printWriter.println("descent: " + hheaTable.descent);
                    printWriter.println("lineGap: " + hheaTable.lineGap);
                    printWriter.println("advanceWidthMax: " + hheaTable.advanceWidthMax);
                }
                if ((os2Table = (Os2Table)trueTypeFile.getByTableName("OS/2")) != null) {
                    printWriter.println("vendorID: " + os2Table.getVendorIDString());
                    printWriter.println("typoAscent: " + os2Table.typoAscent);
                    printWriter.println("typoDescent: " + os2Table.typoDescent);
                    printWriter.println("typoLineGap: " + os2Table.typoLineGap);
                    printWriter.println("winAscent: " + os2Table.winAscent);
                    printWriter.println("winDescent: " + os2Table.winDescent);
                    printWriter.println("xHeight: " + os2Table.xHeight);
                    printWriter.println("capHeight: " + os2Table.capHeight);
                }
                if ((cmapTable = (CmapTable)trueTypeFile.getByTableName("cmap")) != null && (object = cmapTable.getBestSubtable()) != null) {
                    n2 = ((CmapSubtable)object).getGlyphIndex(32);
                    n = ((CmapSubtable)object).getGlyphIndex(160);
                    if (n2 != 0) {
                        printWriter.println("space.glyphId: " + n2);
                    }
                    if (n != 0) {
                        printWriter.println("nbsp.glyphId: " + n);
                    }
                }
                if ((object = (HmtxTable)trueTypeFile.getByTableName("hmtx")) != null) {
                    n = ((ListBasedTable)object).size();
                    for (n2 = 0; n2 < n; ++n2) {
                        printWriter.println("advanceWidth[" + n2 + "]: " + ((HmtxTableEntry)((ListBasedTable)object).get((int)n2)).advanceWidth);
                    }
                }
                printWriter.flush();
                printWriter.close();
                n = eblcTable.size();
                for (n2 = 0; n2 < n; ++n2) {
                    EblcBitmapSize eblcBitmapSize = (EblcBitmapSize)eblcTable.get(n2);
                    String string2 = "0000" + n2;
                    File file4 = new File(file2, string2 = string2.substring(string2.length() - 4));
                    if (!file4.exists()) {
                        file4.mkdir();
                    }
                    File file5 = new File(file4, "metadata.txt");
                    FileOutputStream fileOutputStream2 = new FileOutputStream(file5);
                    OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter((OutputStream)fileOutputStream2, "UTF-8");
                    PrintWriter printWriter2 = new PrintWriter((Writer)outputStreamWriter2, true);
                    printWriter2.println("indexSubTableArrayOffset: " + eblcBitmapSize.indexSubTableArrayOffset);
                    printWriter2.println("indexTablesSize: " + eblcBitmapSize.indexTablesSize);
                    printWriter2.println("numberOfIndexSubTables: " + eblcBitmapSize.numberOfIndexSubTables);
                    printWriter2.println("colorRef: " + eblcBitmapSize.colorRef);
                    ExtractCbdt.print(printWriter2, "hori", eblcBitmapSize.hori);
                    ExtractCbdt.print(printWriter2, "vert", eblcBitmapSize.vert);
                    printWriter2.println("startGlyphIndex: " + eblcBitmapSize.startGlyphIndex);
                    printWriter2.println("endGlyphIndex: " + eblcBitmapSize.endGlyphIndex);
                    printWriter2.println("ppemX: " + eblcBitmapSize.ppemX);
                    printWriter2.println("ppemY: " + eblcBitmapSize.ppemY);
                    printWriter2.println("bitDepth: " + eblcBitmapSize.bitDepth);
                    printWriter2.println("flags: " + eblcBitmapSize.flags);
                    int n3 = 0;
                    for (EblcIndexSubtable eblcIndexSubtable : eblcBitmapSize) {
                        int n4;
                        Iterator iterator;
                        StringBuffer stringBuffer;
                        EblcGlyphIdOffsetPair[] eblcGlyphIdOffsetPairArray;
                        printWriter2.println();
                        printWriter2.println("indexSubTable: " + n3++);
                        printWriter2.println("firstGlyphIndex: " + eblcIndexSubtable.header.firstGlyphIndex);
                        printWriter2.println("lastGlyphIndex: " + eblcIndexSubtable.header.lastGlyphIndex);
                        printWriter2.println("additionalOffsetToIndexSubtable: " + eblcIndexSubtable.header.additionalOffsetToIndexSubtable);
                        printWriter2.println("indexFormat: " + eblcIndexSubtable.header.indexFormat);
                        printWriter2.println("imageFormat: " + eblcIndexSubtable.header.imageFormat);
                        printWriter2.println("imageDataOffset: " + eblcIndexSubtable.header.imageDataOffset);
                        if (eblcIndexSubtable instanceof EblcIndexSubtable1) {
                            eblcGlyphIdOffsetPairArray = (EblcIndexSubtable1)eblcIndexSubtable;
                            stringBuffer = new StringBuffer("offsetArray:");
                            iterator = eblcGlyphIdOffsetPairArray.iterator();
                            while (iterator.hasNext()) {
                                n4 = (Integer)iterator.next();
                                stringBuffer.append(" ");
                                stringBuffer.append(n4);
                            }
                            printWriter2.println(stringBuffer);
                        }
                        if (eblcIndexSubtable instanceof EblcIndexSubtable2) {
                            eblcGlyphIdOffsetPairArray = (EblcIndexSubtable2)eblcIndexSubtable;
                            printWriter2.println("imageSize: " + eblcGlyphIdOffsetPairArray.imageSize);
                            ExtractCbdt.print(printWriter2, eblcGlyphIdOffsetPairArray.bigMetrics);
                        }
                        if (eblcIndexSubtable instanceof EblcIndexSubtable3) {
                            eblcGlyphIdOffsetPairArray = (EblcIndexSubtable3)eblcIndexSubtable;
                            stringBuffer = new StringBuffer("offsetArray:");
                            iterator = eblcGlyphIdOffsetPairArray.iterator();
                            while (iterator.hasNext()) {
                                n4 = (Integer)iterator.next();
                                stringBuffer.append(" ");
                                stringBuffer.append(n4);
                            }
                            printWriter2.println(stringBuffer);
                        }
                        if (eblcIndexSubtable instanceof EblcIndexSubtable4) {
                            eblcGlyphIdOffsetPairArray = (EblcIndexSubtable4)eblcIndexSubtable;
                            stringBuffer = new StringBuffer("glyphArray:");
                            for (EblcGlyphIdOffsetPair eblcGlyphIdOffsetPair : eblcGlyphIdOffsetPairArray) {
                                stringBuffer.append(" ");
                                stringBuffer.append(eblcGlyphIdOffsetPair.glyphID);
                                stringBuffer.append(",");
                                stringBuffer.append(eblcGlyphIdOffsetPair.offset);
                            }
                            printWriter2.println(stringBuffer);
                        }
                        if (eblcIndexSubtable instanceof EblcIndexSubtable5) {
                            eblcGlyphIdOffsetPairArray = (EblcIndexSubtable5)eblcIndexSubtable;
                            printWriter2.println("imageSize: " + eblcGlyphIdOffsetPairArray.imageSize);
                            ExtractCbdt.print(printWriter2, eblcGlyphIdOffsetPairArray.bigMetrics);
                        }
                        eblcGlyphIdOffsetPairArray = eblcIndexSubtable.getGlyphIdOffsetPairs();
                        int n5 = eblcGlyphIdOffsetPairArray.length - 1;
                        for (int i = 0; i < n5; ++i) {
                            EbdtComponent ebdtComponent;
                            Iterator iterator2;
                            Object object2;
                            Object object3;
                            EblcGlyphIdOffsetPair eblcGlyphIdOffsetPair = eblcGlyphIdOffsetPairArray[i];
                            EbdtEntry ebdtEntry = (EbdtEntry)ebdtTable.get(eblcGlyphIdOffsetPair.offset);
                            printWriter2.println();
                            printWriter2.println("glyph: " + eblcGlyphIdOffsetPair.glyphID);
                            printWriter2.println("offset: " + eblcGlyphIdOffsetPair.offset);
                            if (ebdtEntry instanceof EbdtEntryFormat1) {
                                object3 = (EbdtEntryFormat1)ebdtEntry;
                                ExtractCbdt.print(printWriter2, ((EbdtEntryFormat1)object3).smallMetrics);
                                printWriter2.println("imageData: <" + ((EbdtEntryFormat1)object3).imageData.length + "b>");
                            }
                            if (ebdtEntry instanceof EbdtEntryFormat2) {
                                object3 = (EbdtEntryFormat2)ebdtEntry;
                                ExtractCbdt.print(printWriter2, ((EbdtEntryFormat2)object3).smallMetrics);
                                printWriter2.println("imageData: <" + ((EbdtEntryFormat2)object3).imageData.length + "b>");
                            }
                            if (ebdtEntry instanceof EbdtEntryFormat5) {
                                object3 = (EbdtEntryFormat5)ebdtEntry;
                                printWriter2.println("imageData: <" + ((EbdtEntryFormat5)object3).imageData.length + "b>");
                            }
                            if (ebdtEntry instanceof EbdtEntryFormat6) {
                                object3 = (EbdtEntryFormat6)ebdtEntry;
                                ExtractCbdt.print(printWriter2, ((EbdtEntryFormat6)object3).bigMetrics);
                                printWriter2.println("imageData: <" + ((EbdtEntryFormat6)object3).imageData.length + "b>");
                            }
                            if (ebdtEntry instanceof EbdtEntryFormat7) {
                                object3 = (EbdtEntryFormat7)ebdtEntry;
                                ExtractCbdt.print(printWriter2, ((EbdtEntryFormat7)object3).bigMetrics);
                                printWriter2.println("imageData: <" + ((EbdtEntryFormat7)object3).imageData.length + "b>");
                            }
                            if (ebdtEntry instanceof EbdtEntryFormat8) {
                                object3 = (EbdtEntryFormat8)ebdtEntry;
                                ExtractCbdt.print(printWriter2, ((EbdtEntryFormat8)object3).smallMetrics);
                                object2 = new StringBuffer("components:");
                                iterator2 = ((ListBasedEbdtEntry)object3).iterator();
                                while (iterator2.hasNext()) {
                                    ebdtComponent = (EbdtComponent)iterator2.next();
                                    ((StringBuffer)object2).append(" ");
                                    ((StringBuffer)object2).append(ebdtComponent.glyphID);
                                    ((StringBuffer)object2).append(",");
                                    ((StringBuffer)object2).append(ebdtComponent.xOffset);
                                    ((StringBuffer)object2).append(",");
                                    ((StringBuffer)object2).append(ebdtComponent.yOffset);
                                }
                                printWriter2.println(object2);
                            }
                            if (ebdtEntry instanceof EbdtEntryFormat9) {
                                object3 = (EbdtEntryFormat9)ebdtEntry;
                                ExtractCbdt.print(printWriter2, ((EbdtEntryFormat9)object3).bigMetrics);
                                object2 = new StringBuffer("components:");
                                iterator2 = ((ListBasedEbdtEntry)object3).iterator();
                                while (iterator2.hasNext()) {
                                    ebdtComponent = (EbdtComponent)iterator2.next();
                                    ((StringBuffer)object2).append(" ");
                                    ((StringBuffer)object2).append(ebdtComponent.glyphID);
                                    ((StringBuffer)object2).append(",");
                                    ((StringBuffer)object2).append(ebdtComponent.xOffset);
                                    ((StringBuffer)object2).append(",");
                                    ((StringBuffer)object2).append(ebdtComponent.yOffset);
                                }
                                printWriter2.println(object2);
                            }
                            if (ebdtEntry instanceof CbdtEntryFormat17) {
                                object3 = (CbdtEntryFormat17)ebdtEntry;
                                ExtractCbdt.print(printWriter2, ((CbdtEntryFormat17)object3).glyphMetrics);
                                printWriter2.println("imageData: <" + ((CbdtEntryFormat17)object3).imageData.length + "b>");
                            }
                            if (ebdtEntry instanceof CbdtEntryFormat18) {
                                object3 = (CbdtEntryFormat18)ebdtEntry;
                                ExtractCbdt.print(printWriter2, ((CbdtEntryFormat18)object3).glyphMetrics);
                                printWriter2.println("imageData: <" + ((CbdtEntryFormat18)object3).imageData.length + "b>");
                            }
                            if (ebdtEntry instanceof CbdtEntryFormat19) {
                                object3 = (CbdtEntryFormat19)ebdtEntry;
                                printWriter2.println("imageData: <" + ((CbdtEntryFormat19)object3).imageData.length + "b>");
                            }
                            printWriter2.println("endGlyph");
                            if (!(ebdtEntry instanceof CbdtEntry)) continue;
                            object3 = new File(file4, "glyph_" + eblcGlyphIdOffsetPair.glyphID + ".png");
                            object2 = new FileOutputStream((File)object3);
                            ((FileOutputStream)object2).write(((CbdtEntry)ebdtEntry).imageData);
                            ((OutputStream)object2).flush();
                            ((FileOutputStream)object2).close();
                        }
                        printWriter2.println("endIndexSubTable");
                    }
                    printWriter2.flush();
                    printWriter2.close();
                }
                System.out.println("done.");
            }
            catch (Exception exception) {
                System.out.println("failed (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ").");
            }
        }
    }

    private static void print(PrintWriter printWriter, String string, SbitLineMetrics sbitLineMetrics) {
        printWriter.println(string + "Ascender: " + sbitLineMetrics.ascender);
        printWriter.println(string + "Descender: " + sbitLineMetrics.descender);
        printWriter.println(string + "WidthMax: " + sbitLineMetrics.widthMax);
        printWriter.println(string + "CaretSlopeNumerator: " + sbitLineMetrics.caretSlopeNumerator);
        printWriter.println(string + "CaretSlopeDenominator: " + sbitLineMetrics.caretSlopeDenominator);
        printWriter.println(string + "CaretOffset: " + sbitLineMetrics.caretOffset);
        printWriter.println(string + "MinOriginSB: " + sbitLineMetrics.minOriginSB);
        printWriter.println(string + "MinAdvanceSB: " + sbitLineMetrics.minAdvanceSB);
        printWriter.println(string + "MaxBeforeBL: " + sbitLineMetrics.maxBeforeBL);
        printWriter.println(string + "MinAfterBL: " + sbitLineMetrics.minAfterBL);
    }

    private static void print(PrintWriter printWriter, SbitSmallGlyphMetrics sbitSmallGlyphMetrics) {
        printWriter.println("height: " + sbitSmallGlyphMetrics.height);
        printWriter.println("width: " + sbitSmallGlyphMetrics.width);
        printWriter.println("bearingX: " + sbitSmallGlyphMetrics.bearingX);
        printWriter.println("bearingY: " + sbitSmallGlyphMetrics.bearingY);
        printWriter.println("advance: " + sbitSmallGlyphMetrics.advance);
    }

    private static void print(PrintWriter printWriter, SbitBigGlyphMetrics sbitBigGlyphMetrics) {
        printWriter.println("height: " + sbitBigGlyphMetrics.height);
        printWriter.println("width: " + sbitBigGlyphMetrics.width);
        printWriter.println("horiBearingX: " + sbitBigGlyphMetrics.horiBearingX);
        printWriter.println("horiBearingY: " + sbitBigGlyphMetrics.horiBearingY);
        printWriter.println("horiAdvance: " + sbitBigGlyphMetrics.horiAdvance);
        printWriter.println("vertBearingX: " + sbitBigGlyphMetrics.vertBearingX);
        printWriter.println("vertBearingY: " + sbitBigGlyphMetrics.vertBearingY);
        printWriter.println("vertAdvance: " + sbitBigGlyphMetrics.vertAdvance);
    }
}

