/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.data;

import com.kreative.unicode.data.GlyphList;
import com.kreative.unicode.data.UnicodeUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphLists
extends AbstractList<GlyphList> {
    private static GlyphLists instance = null;
    private final List<GlyphList> glyphLists;
    private final Map<String, GlyphList> glyphListMap;

    public static GlyphLists instance() {
        if (instance == null) {
            instance = new GlyphLists();
        }
        return instance;
    }

    private GlyphLists() {
        TreeSet<GlyphList> treeSet = new TreeSet<GlyphList>();
        HashMap<String, GlyphList> hashMap = new HashMap<String, GlyphList>();
        GlyphLists.add(GlyphLists.readBinaryStream(GlyphLists.class.getResourceAsStream("wgl4.pchgl")), treeSet, hashMap);
        GlyphLists.add(GlyphLists.readBinaryStream(GlyphLists.class.getResourceAsStream("kgl1.pchgl")), treeSet, hashMap);
        GlyphLists.readDirectory(UnicodeUtils.getTableDirectory("GlyphLists"), treeSet, hashMap);
        this.glyphLists = Arrays.asList(treeSet.toArray(new GlyphList[treeSet.size()]));
        this.glyphListMap = Collections.unmodifiableMap(hashMap);
    }

    private static void add(GlyphList glyphList, Collection<GlyphList> collection, Map<String, GlyphList> map) {
        if (glyphList != null) {
            String string = glyphList.getName().replaceAll("[^A-Za-z0-9]", "").toLowerCase();
            collection.add(glyphList);
            map.put(string, glyphList);
        }
    }

    private static void readDirectory(File file, Collection<GlyphList> collection, Map<String, GlyphList> map) {
        for (File file2 : file.listFiles()) {
            if (file2.getName().startsWith(".") || file2.getName().endsWith("\r")) continue;
            if (file2.isDirectory()) {
                GlyphLists.readDirectory(file2, collection, map);
                continue;
            }
            try {
                FileInputStream fileInputStream;
                String string = file2.getName().toLowerCase();
                if (string.endsWith(".pchgl")) {
                    fileInputStream = new FileInputStream(file2);
                    GlyphLists.add(GlyphLists.readBinaryStream(fileInputStream), collection, map);
                    fileInputStream.close();
                    continue;
                }
                if (!string.endsWith(".txt")) continue;
                fileInputStream = new FileInputStream(file2);
                String string2 = UnicodeUtils.stripExtension(file2.getName());
                GlyphLists.add(GlyphLists.readTextStream(fileInputStream, string2), collection, map);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static GlyphList readTextStream(InputStream inputStream, String string) {
        Object object;
        Object object2;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Scanner scanner = new Scanner(inputStream);
        while (scanner.hasNextLine()) {
            String[] stringArray;
            object2 = scanner.nextLine().trim();
            if (((String)object2).length() <= 0 || ((String)object2).charAt(0) == '#' || !((String)(object = (stringArray = ((String)object2).split("\\s+"))[0].trim().toLowerCase())).startsWith("0x")) continue;
            try {
                int n = Integer.parseInt(((String)object).substring(2), 16);
                treeSet.add(n);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        scanner.close();
        if (treeSet.isEmpty()) {
            return null;
        }
        object2 = new int[treeSet.size()];
        int n = 0;
        object = treeSet.iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            object2[n++] = n2;
        }
        return new GlyphList((int[])object2, string);
    }

    private static GlyphList readBinaryStream(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            String string = dataInputStream.readUTF();
            int[] nArray = new int[dataInputStream.readUnsignedShort()];
            for (int i = 0; i < nArray.length; ++i) {
                int n = dataInputStream.readUnsignedShort();
                if (n < 32) {
                    n <<= 16;
                    n |= dataInputStream.readUnsignedShort();
                }
                nArray[i] = n;
            }
            return new GlyphList(nArray, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean contains(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.glyphListMap.containsKey(string2);
    }

    @Override
    public boolean contains(Object object) {
        return this.glyphLists.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.glyphLists.containsAll(collection);
    }

    public GlyphList get(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.glyphListMap.get(string2);
    }

    @Override
    public GlyphList get(int n) {
        return this.glyphLists.get(n);
    }

    public int indexOf(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.glyphListMap.containsKey(string2) ? this.glyphLists.indexOf(this.glyphListMap.get(string2)) : -1;
    }

    @Override
    public int indexOf(Object object) {
        return this.glyphLists.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.glyphLists.isEmpty();
    }

    @Override
    public Iterator<GlyphList> iterator() {
        return this.glyphLists.iterator();
    }

    public int lastIndexOf(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.glyphListMap.containsKey(string2) ? this.glyphLists.lastIndexOf(this.glyphListMap.get(string2)) : -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.glyphLists.lastIndexOf(object);
    }

    @Override
    public ListIterator<GlyphList> listIterator() {
        return this.glyphLists.listIterator();
    }

    @Override
    public ListIterator<GlyphList> listIterator(int n) {
        return this.glyphLists.listIterator(n);
    }

    @Override
    public int size() {
        return this.glyphLists.size();
    }

    @Override
    public List<GlyphList> subList(int n, int n2) {
        return this.glyphLists.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.glyphLists.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.glyphLists.toArray(TArray);
    }
}

