/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.data;

import com.kreative.unicode.data.NameResolver;
import com.kreative.unicode.data.PuaaCache;
import com.kreative.unicode.data.UnicodeUtils;
import com.kreative.unicode.ttflib.PuaaEntry;
import com.kreative.unicode.ttflib.PuaaTable;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameDatabase {
    private static NameDatabase instance = null;
    private final NameResolver resolver = NameResolver.instance();
    private final Map<NameKey, NameValue> names = new HashMap<NameKey, NameValue>();
    private final LoaderThread thread = new LoaderThread();
    private static final Pattern CP_PATTERN = Pattern.compile("^\\s*([Uu][Nn][Ii]|[Uu][+]|[Uu]|[0][Xx]|[$])?([0-9A-Fa-f]{1,6})([Hh])?\\s*$");

    public static NameDatabase instance() {
        if (instance == null) {
            instance = new NameDatabase();
        }
        return instance;
    }

    private NameDatabase() {
        this.thread.start();
    }

    private synchronized NameValue getOrAdd(int n, String string, String string2) {
        NameKey nameKey = new NameKey(n, string, string2);
        NameValue nameValue = this.names.get(nameKey);
        if (nameValue == null) {
            nameValue = new NameValue();
            this.names.put(nameKey, nameValue);
        }
        return nameValue;
    }

    private synchronized void loadPuaaTable(PuaaTable puaaTable, String string) {
        List<PuaaEntry> list;
        Map<Integer, String> map;
        Map<Integer, String> map2 = puaaTable.getPropertyMap("Name");
        if (map2 == null || map2.isEmpty()) {
            return;
        }
        Map<Integer, String> map3 = puaaTable.getPropertyMap("General_Category");
        if (map3 == null) {
            map3 = new HashMap<Integer, String>();
        }
        if ((map = puaaTable.getPropertyMap("Unicode_1_Name")) == null) {
            map = new HashMap<Integer, String>();
        }
        if ((list = puaaTable.getPropertyEntries("Name_Alias")) == null) {
            list = new ArrayList<PuaaEntry>();
        }
        for (int n : map2.keySet()) {
            String string2;
            String string3 = map2.get(n);
            if (string3.startsWith("<") && string3.endsWith(">")) {
                if (!string3.equals("<control>")) continue;
                string3 = map.get(n);
                if (string3 == null) {
                    string3 = Integer.toHexString(n).toUpperCase();
                    if (string3.length() < 4) {
                        string3 = ("0000" + string3).substring(string3.length());
                    }
                    string3 = "CONTROL-" + string3;
                }
            }
            if ((string2 = map3.get(n)) == null) {
                string2 = "Cn";
            }
            NameValue nameValue = this.getOrAdd(n, string2, string3);
            if (string != null) {
                nameValue.fonts.add(string);
            }
            nameValue.aliases.add(string3);
            String string4 = map.get(n);
            if (string4 != null) {
                nameValue.aliases.add(string4);
            }
            for (PuaaEntry puaaEntry : list) {
                Object object;
                if (!puaaEntry.contains(n) || !((object = puaaEntry.getPropertyValue(n)) instanceof PuaaEntry.NameAlias)) continue;
                PuaaEntry.NameAlias nameAlias = (PuaaEntry.NameAlias)object;
                nameValue.aliases.add(nameAlias.alias);
            }
        }
    }

    private synchronized void loadPropertyMap(Map<Integer, String> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            String string = this.resolver.getCategory(entry.getKey());
            String string2 = this.resolver.getName(entry.getKey());
            NameValue nameValue = this.getOrAdd(entry.getKey(), string, string2);
            if (nameValue.aliases.isEmpty()) {
                nameValue.aliases.add(string2);
            }
            nameValue.aliases.add(entry.getValue());
        }
    }

    private void loadDirectory(File file) {
        for (File file2 : file.listFiles()) {
            PuaaTable puaaTable;
            if (file2.getName().startsWith(".") || file2.getName().endsWith("\r")) continue;
            if (file2.isDirectory()) {
                this.loadDirectory(file2);
                continue;
            }
            String string = file2.getName().toLowerCase();
            if (!string.endsWith(".ucd") && !string.endsWith(".ttf") && !string.endsWith(".otf") || (puaaTable = PuaaCache.getPuaaTable(file2)) == null) continue;
            String string2 = UnicodeUtils.stripExtension(file2.getName());
            this.loadPuaaTable(puaaTable, string2);
        }
    }

    public synchronized NameEntry find(String string) {
        Object object;
        Object object2;
        Object object3;
        int n;
        String[] stringArray = NameDatabase.querySplit(string);
        if (stringArray != null) {
            NameValue nameValue;
            n = -1;
            if (stringArray.length == 1 && ((Matcher)(object3 = CP_PATTERN.matcher(stringArray[0]))).matches() && (n = Integer.parseInt(((Matcher)object3).group(2), 16)) < 0x110000 && (nameValue = this.getOrAdd(n, (String)(object2 = this.resolver.getCategory(n)), (String)(object = this.resolver.getName(n)))).aliases.isEmpty()) {
                nameValue.aliases.add(object);
            }
            object3 = new ArrayList();
            object2 = this.names.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                if (((NameKey)object.getKey()).codePoint == n) {
                    object3.add(new NameEntry((NameKey)object.getKey(), (NameValue)object.getValue(), 0.0));
                    continue;
                }
                if (!NameDatabase.queryMatch(stringArray, (NameKey)object.getKey(), (NameValue)object.getValue())) continue;
                double d = NameDatabase.searchDistance(string, ((NameKey)object.getKey()).name);
                for (String string2 : ((NameValue)object.getValue()).aliases) {
                    double d2 = NameDatabase.searchDistance(string, string2);
                    if (!(d2 < d)) continue;
                    d = d2;
                }
                object3.add(new NameEntry((NameKey)object.getKey(), (NameValue)object.getValue(), d));
            }
            if (!object3.isEmpty()) {
                Collections.sort(object3);
                return (NameEntry)object3.get(0);
            }
        }
        if (string.length() > 0) {
            n = string.codePointAt(0);
            object = this.getOrAdd(n, (String)(object3 = this.resolver.getCategory(n)), (String)(object2 = this.resolver.getName(n)));
            if (((NameValue)object).aliases.isEmpty()) {
                ((NameValue)object).aliases.add(object2);
            }
            return new NameEntry(new NameKey(n, (String)object3, (String)object2), (NameValue)object, 0.0);
        }
        return null;
    }

    private static String[] querySplit(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim().toUpperCase()).length() == 0) {
            return null;
        }
        String[] stringArray = string.split("\\s+");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() >= 4) continue;
            stringArray[i] = " " + stringArray[i] + " ";
        }
        return stringArray;
    }

    private static boolean queryMatch(String[] stringArray, String string) {
        string = " " + string.toUpperCase() + " ";
        for (String string2 : stringArray) {
            if (string.contains(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean queryMatch(String[] stringArray, NameKey nameKey, NameValue nameValue) {
        if (NameDatabase.queryMatch(stringArray, nameKey.name)) {
            return true;
        }
        for (String string : nameValue.aliases) {
            if (!NameDatabase.queryMatch(stringArray, string)) continue;
            return true;
        }
        return false;
    }

    private static int phraseDistance(String string, String string2) {
        int n;
        if (string.equalsIgnoreCase(string2)) {
            return 0;
        }
        int n2 = string.length() + 1;
        int n3 = string2.length() + 1;
        int[][] nArray = new int[n2][n3];
        for (n = 0; n < n2; ++n) {
            nArray[n][0] = n;
        }
        for (n = 0; n < n3; ++n) {
            nArray[0][n] = n;
        }
        for (n = 1; n < n3; ++n) {
            for (int i = 1; i < n2; ++i) {
                char c;
                int n4 = nArray[i - 1][n] + 1;
                int n5 = nArray[i][n - 1] + 1;
                int n6 = nArray[i - 1][n - 1];
                char c2 = string.charAt(i - 1);
                if (c2 != (c = string2.charAt(n - 1))) {
                    ++n6;
                }
                if (n4 <= n5) {
                    if (n4 <= n6) {
                        nArray[i][n] = n4;
                        continue;
                    }
                    nArray[i][n] = n6;
                    continue;
                }
                nArray[i][n] = n5 <= n6 ? n5 : n6;
            }
        }
        return nArray[n2 - 1][n3 - 1];
    }

    private static int wordDistance(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return 0;
        }
        String[] stringArray = string.split("[^A-Za-z0-9]+");
        String[] stringArray2 = string2.split("[^A-Za-z0-9]+");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = string2.length();
            for (int j = 0; j < stringArray2.length; ++j) {
                int n3 = NameDatabase.phraseDistance(stringArray[i], stringArray2[j]);
                if (n3 < n2) {
                    n2 = n3;
                }
                if (n3 == 0) break;
            }
            n += n2;
        }
        return n;
    }

    private static double searchDistance(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return 0.0;
        }
        double d = NameDatabase.phraseDistance(string, string2);
        double d2 = NameDatabase.wordDistance(string, string2);
        return Math.min(d -= 0.8 * (double)Math.abs(string.length() - string2.length()), d2) * 0.8 + Math.max(d, d2) * 0.2;
    }

    private class LoaderThread
    extends Thread {
        private LoaderThread() {
        }

        public void run() {
            String[] stringArray;
            NameDatabase.this.loadPuaaTable(PuaaCache.getPuaaTable("unidata.ucd"), null);
            PuaaTable puaaTable = PuaaCache.getPuaaTable("extras.ucd");
            NameDatabase.this.loadPropertyMap(puaaTable.getPropertyMap("HTML_Entity"));
            NameDatabase.this.loadPropertyMap(puaaTable.getPropertyMap("PostScript_Name"));
            for (String string : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                Font font = new Font(string, 0, 12);
                PuaaTable puaaTable2 = PuaaCache.getPuaaTable(font);
                if (puaaTable2 == null) continue;
                NameDatabase.this.loadPuaaTable(puaaTable2, string);
            }
            NameDatabase.this.loadDirectory(UnicodeUtils.getTableDirectory("UnicodeData"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameEntry
    implements Comparable<NameEntry> {
        public final int codePoint;
        public final String category;
        public final String name;
        public final Set<String> aliases;
        public final Set<String> fonts;
        public final double searchDistance;

        private NameEntry(NameKey nameKey, NameValue nameValue, double d) {
            this.codePoint = nameKey.codePoint;
            this.category = nameKey.category;
            this.name = nameKey.name;
            this.aliases = Collections.unmodifiableSet(nameValue.aliases);
            this.fonts = Collections.unmodifiableSet(nameValue.fonts);
            this.searchDistance = d;
        }

        public boolean isPUA() {
            return this.codePoint >= 57344 && this.codePoint < 63744 || this.codePoint >= 983040;
        }

        public String shortestFontName() {
            String string = null;
            for (String string2 : this.fonts) {
                if (string != null && string2.length() >= string.length()) continue;
                string = string2;
            }
            return string;
        }

        @Override
        public int compareTo(NameEntry nameEntry) {
            if (this.isPUA() && !nameEntry.isPUA()) {
                return 1;
            }
            if (!this.isPUA() && nameEntry.isPUA()) {
                return -1;
            }
            if (this.searchDistance < nameEntry.searchDistance) {
                return -1;
            }
            if (this.searchDistance > nameEntry.searchDistance) {
                return 1;
            }
            if (this.codePoint < nameEntry.codePoint) {
                return -1;
            }
            if (this.codePoint > nameEntry.codePoint) {
                return 1;
            }
            return 0;
        }
    }

    private static class NameValue {
        private final Set<String> aliases = new HashSet<String>();
        private final Set<String> fonts = new HashSet<String>();

        private NameValue() {
        }
    }

    private static class NameKey {
        private final int codePoint;
        private final String category;
        private final String name;

        private NameKey(int n, String string, String string2) {
            this.codePoint = n;
            this.category = string;
            this.name = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof NameKey) {
                NameKey nameKey = (NameKey)object;
                return this.codePoint == nameKey.codePoint && this.category.equals(nameKey.category) && this.name.equals(nameKey.name);
            }
            return false;
        }

        public int hashCode() {
            return this.codePoint ^ this.category.hashCode() ^ this.name.hashCode();
        }
    }
}

