/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.fontmap;

import com.kreative.unicode.fontmap.FontMapEntry;
import com.kreative.unicode.fontmap.FontMapFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontMapController {
    private static FontMapController instance;
    private List<FontMapEntry> entries = new ArrayList<FontMapEntry>();
    private FontMapFrame frame = null;

    public static FontMapController getInstance() {
        if (instance == null) {
            instance = new FontMapController();
        }
        return instance;
    }

    private FontMapController() {
        try {
            File file = FontMapController.getPreferencesFile();
            if (file.exists()) {
                Scanner scanner = new Scanner((InputStream)new FileInputStream(file), "UTF-8");
                while (scanner.hasNextLine()) {
                    String[] stringArray = scanner.nextLine().split("=", 2);
                    if (stringArray.length != 2) continue;
                    FontMapEntry fontMapEntry = new FontMapEntry();
                    fontMapEntry.setCodePointsString(stringArray[0].trim());
                    fontMapEntry.setFontString(stringArray[1].trim());
                    this.entries.add(fontMapEntry);
                }
                scanner.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public List<FontMapEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<FontMapEntry> list) {
        this.entries.clear();
        this.entries.addAll(list);
        if (list.isEmpty()) {
            FontMapController.getPreferencesFile().delete();
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(FontMapController.getPreferencesFile());
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
                for (FontMapEntry fontMapEntry : list) {
                    printWriter.println(fontMapEntry.getCodePointsString() + " = " + fontMapEntry.getFontString());
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public FontMapEntry entryForString(String string) {
        for (FontMapEntry fontMapEntry : this.entries) {
            if (!fontMapEntry.containsAllCodePoints(string)) continue;
            return fontMapEntry;
        }
        return null;
    }

    public FontMapEntry entryForCodePoint(int n) {
        for (FontMapEntry fontMapEntry : this.entries) {
            if (!fontMapEntry.codePoints().get(n)) continue;
            return fontMapEntry;
        }
        return null;
    }

    public FontMapFrame getFrame() {
        if (this.frame == null) {
            this.frame = new FontMapFrame(this.entries);
            this.frame.setDefaultCloseOperation(0);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    FontMapController.this.setEntries(FontMapController.this.frame.getFontMap());
                    FontMapController.this.frame.dispose();
                    FontMapController.this.frame = null;
                }
            });
        }
        return this.frame;
    }

    private static File getPreferencesFile() {
        if (System.getProperty("os.name").toUpperCase().contains("MAC OS")) {
            File file;
            File file2 = new File(System.getProperty("user.home"));
            File file3 = new File(file2, "Library");
            if (!file3.exists()) {
                file3.mkdir();
            }
            if (!(file = new File(file3, "Preferences")).exists()) {
                file.mkdir();
            }
            return new File(file, "com.kreative.mapedit.fontmap.txt");
        }
        if (System.getProperty("os.name").toUpperCase().contains("WINDOWS")) {
            File file;
            File file4 = new File(System.getProperty("user.home"));
            File file5 = new File(file4, "Application Data");
            if (!file5.exists()) {
                file5.mkdir();
            }
            if (!(file = new File(file5, "Kreative")).exists()) {
                file.mkdir();
            }
            return new File(file, "MapEdit.FontMap.txt");
        }
        File file = new File(System.getProperty("user.home"));
        return new File(file, ".mapedit.fontmap.txt");
    }
}

