#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ncurses.h>
#include "ncdrawlib.h"
#include "nibbles.h"

cell *newCell(int x, int y)
{
cell *c;

if ((c = (cell *)malloc(sizeof(cell)))==NULL)
	{
	fprintf(stderr,"Out of memory, destruction imminent\n");
	return 0;
	}
c->xpos = x;
c->ypos = y;
c->next = NULL;
return c;
}

void freeCell(cell *c)
{
if (c==NULL)
	{
	fprintf(stderr,"Can't free(NULL). Houston, we have a problem");
	}
free(c);
}

player *newPlayer(map *m)
{
player *p;

if ((p = (player *)malloc(sizeof(player)))==NULL)
	{
	fprintf(stderr,"Out of memory, destruction imminent\n");
	return 0;
	}
p->cells = NULL;
return p;
}

void initPlayer(player *p, map *m)
{
cell *c, *n;

if (p->cells != NULL) // this is not the 1st time
	{
	// destroy all cells and the list
	n=NULL;
	for (c = p->cells; c != NULL; c = n)
		{
		n = c->next;
		free(c);
		}
	p->cells = NULL;
        }
else		// first time
	{
	p->lives = NUMLIVES;
	p->level = 1;
	p->score = 0;
	p->totalApples = 0;
	}
        
p->cells = newCell(m->startx,m->starty); // add a head
p->xd = 0;
p->yd = 0;
p->grow = STARTLEN;
}

void freePlayer(player *p)
{
cell *c, *n;

if (p==NULL)
	{
	fprintf(stderr,"Can't free(NULL). Houston, we have a problem");
	}

if (p->cells==NULL)
	{
	fprintf(stderr,"Can't free(cells as NULL). Houston, we have a problem");
	}

n=NULL;
for (c=p->cells; c!=NULL; c=n)
	{
	n=c->next;
	freeCell(c);
	}

free(p);
}

void drawPlayer(player *p, WINDOW *w)
{
cell *c;

for (c=p->cells; c!=NULL; c=c->next)
        {
	if (c==p->cells)
		mvwaddch(w,c->ypos,c->xpos, 'O' | COLOR_PAIR(4));
	else
		mvwaddch(w,c->ypos,c->xpos, 'o' | COLOR_PAIR(3));
	}

// FIXME, totally assuming 24x80
mvwprintw(w,23,0,"Lives: %d     Score: %d     Level: %d",p->lives,p->score,p->level);
wrefresh(w);
}

void wipePlayer(player *p, WINDOW *w)
{
cell *c;

for (c=p->cells; c!=NULL; c=c->next)
	{ 
	mvwaddch(w,c->ypos,c->xpos,' ');
	}
}

int movePlayer(player *p,map *m)
{
cell *newhead;
cell *tail;
cell *c;
int coll;

if (!(p->xd == 0 && p->yd == 0)) // only if moving
	{
	newhead = newCell(p->cells->xpos + p->xd, p->cells->ypos + p->yd);
	newhead->next = p->cells;
	p->cells = newhead;
	if (p->grow<=0)
		{
		tail=p->cells;
		c=tail;
		while (tail->next!=NULL) {
			c=tail;
			tail=tail->next;
		}
		freeCell(tail);
		c->next=NULL;
		}
	else
		p->grow--;

	coll = checkCollision(p,m);
	if (coll==1)
		explode(newhead->xpos,newhead->ypos,stdscr);
	return coll;
	}
else return 0;
}

int checkCollision(player *p, map *m)
{
cell *c,*d;
cell *head;

head = p->cells;

if (m->data[head->ypos*m->width+head->xpos] == WALL) // only need to see if the head is hitting things
	{
	return 1;       // hit a wall
	}
if (m->data[head->ypos*m->width+head->xpos] == APPLE)
	{
	p->grow = 4;
	m->numApples--;
	p->score += p->level;
	p->totalApples++;
	if (p->totalApples%APPLESNEEDEDFORLIFE==0) p->lives++;
	m->data[head->ypos*m->width+head->xpos] = EMPTY;
	return 0;
	}


for (c=p->cells; c->next!=NULL; c=c->next)
	{
	d=p->cells;
	while (d!=NULL)
		{
		if ( c!=d && (d->xpos == c->xpos && d->ypos == c->ypos))
			return 1;	// bit it's own tail
		d=d->next;
		}
	}
return 0;
}

void explode(int x,int y, WINDOW *w)
{
int i,j;

for (j=0;j<10;j++)
for (i=1;i<4;i++)
	{
	circle(w,x,y,i,' ',COLOR_PAIR((j%2)+7));
	usleep(50000);
	wrefresh(w);
	}
}
