---
title: "Cloudinary"
description: "Rclone docs for Cloudinary backend"
versionIntroduced: "v1.69"

---
# {{< icon "fa fa-cloud" >}} Cloudinary

This is a backend for the [Cloudinary](https://cloudinary.com/) platform

## About Cloudinary

[Cloudinary](https://cloudinary.com/) is an image and video API platform.
Trusted by 1.5 million developers and 10,000 enterprise and hyper-growth
companies as a critical part of their tech stack to deliver visually engaging
experiences.

## Accounts & Pricing

To use this backend, you need to [create a free account](https://cloudinary.com/users/register_free)
on Cloudinary. Start with a free plan with generous usage limits. Then, as your
requirements grow, upgrade to a plan that best fits your needs.
See [the pricing details](https://cloudinary.com/pricing).

## Securing Your Credentials

Please refer to the [docs](/docs/#configuration-encryption-cheatsheet)

## Configuration

Here is an example of making a Cloudinary configuration.

First, create a [cloudinary.com](https://cloudinary.com/users/register_free)
account and choose a plan.

You will need to log in and get the `API Key` and `API Secret` for your account
from the developer section.

Now run

```sh
rclone config
```

Follow the interactive setup process:

```text
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n

Enter the name for the new remote.
name> cloudinary-media-library

Option Storage.
Type of storage to configure.
Choose a number from below, or type in your own value.
[snip]
XX / cloudinary.com
\ (cloudinary)
[snip]
Storage> cloudinary

Option cloud_name.
You can find your cloudinary.com cloud_name in your [dashboard](https://console.cloudinary.com/pm/developer-dashboard)
Enter a value.
cloud_name> ****************************

Option api_key.
You can find your cloudinary.com api key in your [dashboard](https://console.cloudinary.com/pm/developer-dashboard)
Enter a value.
api_key> ****************************

Option api_secret.
You can find your cloudinary.com api secret in your [dashboard](https://console.cloudinary.com/pm/developer-dashboard)
This value must be a single character, one of the following: y, g.
y/g> y
Enter a value.
api_secret> ****************************

Option upload_prefix.
[Upload prefix](https://cloudinary.com/documentation/cloudinary_sdks#configuration_parameters) to specify alternative data center
Enter a value.
upload_prefix>

Option upload_preset.
[Upload presets](https://cloudinary.com/documentation/upload_presets) can be defined for different upload profiles
Enter a value.
upload_preset>

Edit advanced config?
y) Yes
n) No (default)
y/n> n

Configuration complete.
Options:
- type: cloudinary
- api_key: ****************************
- api_secret: ****************************
- cloud_name: ****************************
- upload_prefix:
- upload_preset:

Keep this "cloudinary-media-library" remote?
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> y
```

List directories in the top level of your Media Library

```sh
rclone lsd cloudinary-media-library:
```

Make a new directory.

```sh
rclone mkdir cloudinary-media-library:directory
```

List the contents of a directory.

```sh
rclone ls cloudinary-media-library:directory
```

### Modified time and hashes

Cloudinary stores md5 and timestamps for any successful Put automatically and read-only.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/cloudinary/cloudinary.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to cloudinary (Cloudinary).

#### --cloudinary-cloud-name

Cloudinary Environment Name

Properties:

- Config:      cloud_name
- Env Var:     RCLONE_CLOUDINARY_CLOUD_NAME
- Type:        string
- Required:    true

#### --cloudinary-api-key

Cloudinary API Key

Properties:

- Config:      api_key
- Env Var:     RCLONE_CLOUDINARY_API_KEY
- Type:        string
- Required:    true

#### --cloudinary-api-secret

Cloudinary API Secret

Properties:

- Config:      api_secret
- Env Var:     RCLONE_CLOUDINARY_API_SECRET
- Type:        string
- Required:    true

#### --cloudinary-upload-prefix

Specify the API endpoint for environments out of the US

Properties:

- Config:      upload_prefix
- Env Var:     RCLONE_CLOUDINARY_UPLOAD_PREFIX
- Type:        string
- Required:    false

#### --cloudinary-upload-preset

Upload Preset to select asset manipulation on upload

Properties:

- Config:      upload_preset
- Env Var:     RCLONE_CLOUDINARY_UPLOAD_PRESET
- Type:        string
- Required:    false

### Advanced options

Here are the Advanced options specific to cloudinary (Cloudinary).

#### --cloudinary-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_CLOUDINARY_ENCODING
- Type:        Encoding
- Default:     Slash,LtGt,DoubleQuote,Question,Asterisk,Pipe,Hash,Percent,BackSlash,Del,Ctl,RightSpace,InvalidUtf8,Dot

#### --cloudinary-eventually-consistent-delay

Wait N seconds for eventual consistency of the databases that support the backend operation

Properties:

- Config:      eventually_consistent_delay
- Env Var:     RCLONE_CLOUDINARY_EVENTUALLY_CONSISTENT_DELAY
- Type:        Duration
- Default:     0s

#### --cloudinary-adjust-media-files-extensions

Cloudinary handles media formats as a file attribute and strips it from the name, which is unlike most other file systems

Properties:

- Config:      adjust_media_files_extensions
- Env Var:     RCLONE_CLOUDINARY_ADJUST_MEDIA_FILES_EXTENSIONS
- Type:        bool
- Default:     true

#### --cloudinary-media-extensions

Cloudinary supported media extensions

Properties:

- Config:      media_extensions
- Env Var:     RCLONE_CLOUDINARY_MEDIA_EXTENSIONS
- Type:        stringArray
- Default:     [3ds 3g2 3gp ai arw avi avif bmp bw cr2 cr3 djvu dng eps3 fbx flif flv gif glb gltf hdp heic heif ico indd jp2 jpe jpeg jpg jxl jxr m2ts mov mp4 mpeg mts mxf obj ogv pdf ply png psd svg tga tif tiff ts u3ma usdz wdp webm webp wmv]

#### --cloudinary-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_CLOUDINARY_DESCRIPTION
- Type:        string
- Required:    false

{{< rem autogenerated options stop >}}
