set rcsId {$Id: labelfra.tcl,v 1.11 2000/11/01 11:58:47 jfontain Exp $}


class labelledFrame {}

proc labelledFrame::labelledFrame {this parentPath args} composite {[new frame $parentPath] $args} {
    composite::manage $this\
        [new frame $widget::($this,path) -relief groove -borderwidth 2] frame [new label $widget::($this,path)] label
    composite::complete $this
    place $composite::($this,frame,path) -bordermode ignore
    place $composite::($this,label,path) -bordermode ignore
    bind $composite::($this,label,path) <Configure> "labelledFrame::update $this"
}

proc labelledFrame::~labelledFrame {this} {}

proc labelledFrame::options {this} {
    return [list\
        [list -anchor nw nw]\
        [list -font $widget::option(button,font) $widget::option(button,font)]\
        [list -relief groove groove]\
        [list -text {} {}]\
    ]
}

proc labelledFrame::set-anchor {this value} {
    if {![regexp {^(nw|n|ne|sw|s|se)$} $value]} {
        error "bad side value \"$value\": must be nw, n, ne, sw, s or se"
    }
    placeLabel $this
}

proc labelledFrame::set-font {this value} {
    $composite::($this,label,path) configure -font $value                                         ;# generates a configuration event
}

proc labelledFrame::set-relief {this value} {
    $composite::($this,frame,path) configure -relief $value
}

proc labelledFrame::set-text {this value} {
    $composite::($this,label,path) configure -text $value
}

proc labelledFrame::placeLabel {this} {
    set path $composite::($this,label,path)
    set border [winfo reqheight $composite::($this,label,path)]
    place $path -anchor $composite::($this,-anchor)
    switch $composite::($this,-anchor) {
        nw {place $path -x $border -relx 0 -rely 0}
        n  {place $path -x 0 -relx 0.5 -rely 0}
        ne {place $path -x -$border -relx 1 -rely 0}
        sw {place $path -x $border -relx 0 -rely 1}
        s  {place $path -x 0 -relx 0.5 -rely 1}
        se {place $path  -x -$border -relx 1 -rely 1}
    }
}

proc labelledFrame::update {this} {
    set border [winfo reqheight $composite::($this,label,path)]
    $widget::($this,path) configure -borderwidth $border
    set half [expr {$border/2}]
    place $composite::($this,frame,path) -x $half -y $half -relwidth 1 -width -$border -relheight 1 -height -$border
    placeLabel $this
}
