/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.Date;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.update.PluginAutoUpdater;
import util.browserlauncher.Launch;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.io.ExecutionHandler;
import util.io.IOUtilities;
import util.io.Mirror;
import util.io.PropertiesSorted;
import util.ui.UiUtilities;

public class JREUpdater {
    public static final String FILENAME = "tvbjre";
    public static final String DEFAULT_DOWNLOAD_URL = "http://download.tvbrowser.org/jre/";
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(JREUpdater.class);
    public static final int INTERVAL = 13;

    public static boolean checkForUpdate(JLabel infoLabel) {
        boolean result = false;
        if (JREUpdater.hasTvBrowserJRE() && Settings.General.JRE_UPDATE_ENABLED.getBoolean()) {
            infoLabel.setText(LOCALIZER.msg("info.info", "Searching for TV-Browser JRE updates..."));
            File temp = new File(System.getProperty("java.io.tmpdir"), FILENAME);
            if (temp.isFile()) {
                temp.delete();
            }
            try {
                String[] parts;
                block23: {
                    Object url = "http://download.tvbrowser.org/jre/tvbjre";
                    if (PluginAutoUpdater.downloadMirrorList()) {
                        Mirror mirror = PluginAutoUpdater.getPluginUpdatesMirror();
                        if (mirror != null) {
                            url = mirror.getUrl();
                        }
                        if (!((String)url).endsWith("/")) {
                            url = (String)url + "/";
                        }
                        url = (String)url + FILENAME;
                    }
                    parts = null;
                    try {
                        if (IOUtilities.download(new URL((String)url), temp, 10000) && (parts = new String(IOUtilities.getBytesFromFile(temp)).split("\n")).length < 4) {
                            throw new IOException();
                        }
                    }
                    catch (IOException ioe1) {
                        if (!IOUtilities.download(new URL("http://download.tvbrowser.org/jre/tvbjre"), temp, 10000)) break block23;
                        parts = new String(IOUtilities.getBytesFromFile(temp)).split("\n");
                    }
                }
                String md5_32 = null;
                String md5_64 = null;
                if (parts != null && parts.length == 4) {
                    md5_32 = parts[2];
                    md5_64 = parts[3];
                }
                if (parts != null && parts.length == 2) {
                    int i;
                    Settings.General.JRE_UPDATE_DATE_LAST.setDate(Date.getCurrentDate());
                    String currentVersion = System.getProperty("java.version");
                    String[] sParts = parts[0].trim().split("\\.");
                    String[] cParts = currentVersion.split("\\.");
                    if (cParts.length < sParts.length) {
                        String[] newArr = new String[sParts.length];
                        System.arraycopy(cParts, 0, newArr, 0, cParts.length);
                        for (i = cParts.length; i < sParts.length; ++i) {
                            newArr[i] = "0";
                        }
                        cParts = newArr;
                    }
                    boolean update = false;
                    for (i = 0; i < Math.min(cParts.length, sParts.length); ++i) {
                        if (Integer.parseInt(cParts[i]) < Integer.parseInt(sParts[i])) {
                            update = true;
                            break;
                        }
                        if (Integer.parseInt(cParts[i]) > Integer.parseInt(sParts[i])) break;
                    }
                    if (update) {
                        String bits = System.getProperty("sun.arch.data.model");
                        String downloadUrl = parts[1].replace("%version%", parts[0]).replace("%arch%", "win" + bits);
                        File target = new File(Settings.getUserSettingsDirName(), "tvbrowser-jre_" + parts[0] + "_win" + bits + ".exe");
                        if (!target.isFile()) {
                            IOUtilities.download(new URL(downloadUrl), target, 30000);
                        }
                        if (target.isFile()) {
                            String md5 = IOUtilities.getMD5Hash(target);
                            if (bits.equals("64")) {
                                result = md5_64 == null || md5.equals(md5_64);
                            } else {
                                boolean bl = result = md5_32 == null || md5.equals(md5_32);
                            }
                            if (result) {
                                Settings.General.JRE_UPDATE.setString(target.getAbsolutePath());
                                JREUpdater.handlePossibleUpdate();
                            } else {
                                target.delete();
                            }
                        }
                    }
                    temp.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            infoLabel.setText("");
        }
        return result;
    }

    public static boolean hasTvBrowserJRE() {
        File release;
        boolean result = false;
        if (Launch.getOs() == 1 && (release = new File("java" + File.separator + "release")).isFile()) {
            PropertiesSorted prop = PropertiesSorted.load(release);
            result = prop.getProperty(FILENAME, "false").equals("true");
        }
        return result;
    }

    public static void handlePossibleUpdate() {
        if (JREUpdater.hasTvBrowserJRE() && !Settings.General.JRE_UPDATE.getString().equals(Settings.General.JRE_UPDATE.getDefault())) {
            if (JOptionPane.showOptionDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("info.message", "A New TV-Browser JRE is available for installation.\n\nIt's important to install JRE updates as soon as possible\nto prevent possible security risks.\n\nDo you want to install it now?"), LOCALIZER.msg("info.header", "New TV-Browser JRE available"), 0, 1, null, new String[]{LOCALIZER.msg("info.install", "Install JRE now"), Localizer.getLocalization("i18n_cancel")}, null) == 0) {
                Settings.General.JRE_UPDATE.setString(Settings.General.JRE_UPDATE.getString() + ";install");
                MainFrame.getInstance().quit();
            }
        } else {
            File[] installer = new File(Settings.getUserSettingsDirName()).listFiles(f -> f.getName().toLowerCase().endsWith(".exe") && f.getName().contains("tvbrowser-jre"));
            if (installer != null) {
                for (File file : installer) {
                    if (file.delete()) continue;
                    file.deleteOnExit();
                }
            }
        }
    }

    public static void doUpdateIfAvailable() {
        if (JREUpdater.hasTvBrowserJRE() && Settings.General.JRE_UPDATE.getString().endsWith(";install")) {
            String file = Settings.General.JRE_UPDATE.getString().substring(0, Settings.General.JRE_UPDATE.getString().lastIndexOf(";"));
            Settings.General.JRE_UPDATE.resetToDefault();
            try {
                Settings.storeSettings(false);
            }
            catch (TvBrowserException tvBrowserException) {
                // empty catch block
            }
            ExecutionHandler ex = new ExecutionHandler(new String[]{"cmd", "/c", file});
            try {
                ex.execute();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

