/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.protocolhandler;

import devplugin.Program;
import devplugin.ProgramFieldType;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.searchplugin.SearchPlugin;
import tvbrowser.ui.DontShowAgainOptionBox;
import tvbrowser.ui.mainframe.MainFrame;
import util.browserlauncher.Launch;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.io.ExecutionHandler;
import util.io.windows.registry.RegistryKey;
import util.io.windows.registry.RegistryValue;
import util.settings.BooleanProperty;
import util.settings.ByteProperty;
import util.settings.ChoiceProperty;
import util.settings.ColorProperty;
import util.settings.IntArrayProperty;
import util.settings.IntProperty;
import util.settings.StringArrayProperty;
import util.settings.StringProperty;
import util.ui.SearchFormSettings;
import util.ui.UiUtilities;

public class ProtocolHandler {
    private static final String ESCAPE_SLASH = "|||";
    private static final String ESCAPE_SEMICOLON = ":::";
    private static final String ESCAPE_COMMA = "%%%";
    private static final String ESCAPE_QUOTE = "\u00a7\u00a7\u00a7";
    private static final String MESSAGE_CONFIG = "config";
    private static final String MESSAGE_PLUGIN = "plugin";
    private static final String MESSAGE_ENABLE = "enable";
    private static final String MESSAGE_SHOW = "show";
    private static final String MESSAGE_SEARCH = "search";
    private static final String MESSAGE_PROGRAM = "program";
    private static final String MESSAGE_SETTINGS = "settings";
    private static final String MESSAGE_PLUGIN_UPDATE = "pluginUpdate";
    private static final String MESSAGE_SETTINGS_DIR = "settingsDir";
    private static final String KEY_SEARCH_WHERE = "where";
    private static final String KEY_SEARCH_CASE_SENSITIVE = "casesensitive";
    private static final String KEY_SEARCH_TEXT = "text";
    private static final String VALUE_SEARCH_WHERE_ALL = "all";
    private static final String VALUE_SEARCH_WHERE_TITLE = "title";
    private static final String KEY_SHOW_PROGRAM_ID = "id";
    private static final String MESSAGE_SEARCH_TYPE_EXACTLY = "exact";
    private static final String MESSAGE_SEARCH_TYPE_WHOLE_TERM = "term";
    private static final String MESSAGE_SEARCH_TYPE_KEYWORD = "keyword";
    private static final String MESSAGE_SEARCH_TYPE_BOOL = "bool";
    private static final String MESSAGE_SEARCH_TYPE_REGEX = "regex";
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ProtocolHandler.class);
    private static final Logger LOG = Logger.getLogger(ProtocolHandler.class.getName());
    private static ProtocolHandler INSTANCE;
    private boolean mIsEnabled;

    private ProtocolHandler() {
        INSTANCE = this;
        this.mIsEnabled = Settings.General.CAN_RECEIVE_PROTOCOL_MESSAGE.getBoolean();
        if (this.mIsEnabled) {
            File tvbprotocol;
            if (Launch.getOs() == 3) {
                boolean ask;
                String handler = null;
                ExecutionHandler h = ExecutionHandler.create("/usr/bin/xdg-mime", "query", "default", "x-scheme-handler/tvb");
                try {
                    h.execute(true);
                    h.getProcess().waitFor();
                    handler = h.getOutput().strip();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                File baseDir = new File("");
                File start = new File(baseDir.getAbsolutePath(), "/tvbrowser" + (TVBrowser.isTransportable() ? "-transportable" : "") + ".sh");
                File source = new File(System.getProperty("user.home") + "/.local/share/applications/tvbrowserWebstart.desktop");
                boolean bl = ask = handler == null || !source.isFile();
                if (handler != null && handler.equals("tvbrowser.desktop")) {
                    source = null;
                    boolean bl2 = ask = !baseDir.getAbsolutePath().startsWith("/usr/share/tvbrowser");
                }
                if (source != null && source.isFile()) {
                    try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), "UTF-8"));){
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            if (!line.startsWith("Exec")) continue;
                            ask = !line.contains(start.getAbsolutePath());
                            break;
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                if (source == null) {
                    source = new File("/usr/share/tvbrowser/tvbrowser.sh");
                }
                if (ask) {
                    if (!source.isFile() || DontShowAgainOptionBox.showOptionDialog("tvbProtocolWrongTarget", UiUtilities.getParentFrameOnMouseScreen(), LOCALIZER.msg("error.linux.msg", "Receiving protocol message with tvb:// is activated.\nProtocol message make it easier to configure TV-Browser.\nBut the protocol leads to another TV-Browser.\n\nShould the protocol instead lead to this TV-Browser?\n(The protocol messages are deactivted for this TV-Browser if not.)"), LOCALIZER.msg("error.linux.title", "tvb://\\-Protokoll leads to another TV-Browser"), 3, 1) == 0) {
                        this.enable(false);
                    } else {
                        Settings.General.CAN_RECEIVE_PROTOCOL_MESSAGE.setBoolean(false);
                        this.mIsEnabled = false;
                        try {
                            Settings.storeSettings(true);
                        }
                        catch (TvBrowserException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else if (Launch.getOs() == 1) {
                this.checkWindows();
            } else if (Launch.getOs() == 0 && !TVBrowser.isTransportable() && !(tvbprotocol = new File("/Applications/TV-Browser Protocol.app")).exists()) {
                DontShowAgainOptionBox.showOptionDialog("tvbProtocolMissing", UiUtilities.getParentFrameOnMouseScreen(), LOCALIZER.msg("error.mac.msg", "Receiving protocol message with tvb:// is activated.\nProtocol message make it easier to configure TV-Browser.\nBut the protocol app is missing.\n\nPlease make sure to also install the TV-Browser Protocol app from the DMG with TV-Browser."), LOCALIZER.msg("error.mac.title", "tvb:// protocol app missing"), 3, 2);
            }
        }
    }

    public static synchronized ProtocolHandler getInstance() {
        if (INSTANCE == null) {
            new ProtocolHandler();
        }
        return INSTANCE;
    }

    public synchronized void handleMessage(String message) {
        String[] parts;
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (Settings.General.CAN_RECEIVE_PROTOCOL_MESSAGE.getBoolean() && message != null && message.startsWith("tvb://") && (parts = message.substring(6).strip().split("/")).length > 1) {
            if (MESSAGE_CONFIG.equalsIgnoreCase(parts[0]) && parts[1].contains("=")) {
                this.configMessage(message, parts);
            } else if (MESSAGE_SHOW.equalsIgnoreCase(parts[0]) && parts[1].equals(MESSAGE_SETTINGS_DIR)) {
                Settings.openSettingsDir();
            } else if (MESSAGE_SHOW.equalsIgnoreCase(parts[0]) && (parts.length == 2 || parts.length == 3) && parts[parts.length - 1].contains("=")) {
                this.showMessage(parts);
            } else if (MESSAGE_PLUGIN.equalsIgnoreCase(parts[0]) && parts.length >= 3) {
                this.pluginMessage(parts);
            } else if (MESSAGE_SEARCH.equalsIgnoreCase(parts[0]) && parts.length == 3) {
                this.searchMessage(parts);
            }
        }
    }

    private void searchMessage(String[] parts) {
        SearchFormSettings settings = new SearchFormSettings("");
        if (MESSAGE_SEARCH_TYPE_EXACTLY.equals(parts[1])) {
            settings.setSearcherType(1);
        } else if (MESSAGE_SEARCH_TYPE_WHOLE_TERM.equals(parts[1])) {
            settings.setSearcherType(5);
        } else if (MESSAGE_SEARCH_TYPE_REGEX.equals(parts[1])) {
            settings.setSearcherType(3);
        } else if (MESSAGE_SEARCH_TYPE_BOOL.equals(parts[1])) {
            settings.setSearcherType(4);
        } else if (MESSAGE_SEARCH_TYPE_KEYWORD.equals(parts[1])) {
            settings.setSearcherType(2);
        }
        String[] values = parts[2].split(";");
        String searchText = null;
        for (String value : values) {
            int index = value.indexOf("=");
            if (index == -1) continue;
            String key = value.substring(0, index);
            String v = ProtocolHandler.unescape(value.substring(index + 1));
            if (key.equals(KEY_SEARCH_WHERE)) {
                if (v.equals(VALUE_SEARCH_WHERE_ALL)) {
                    settings.setSearchIn(2);
                    continue;
                }
                if (v.equals(VALUE_SEARCH_WHERE_TITLE)) {
                    settings.setSearchIn(1);
                    continue;
                }
                if (!v.contains(",")) continue;
                String[] fields = v.split(",");
                ArrayList<ProgramFieldType> progTypes = new ArrayList<ProgramFieldType>();
                for (String f : fields) {
                    try {
                        Field field = ProgramFieldType.class.getDeclaredField(f);
                        field.setAccessible(true);
                        progTypes.add((ProgramFieldType)field.get(null));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                        // empty catch block
                    }
                }
                if (progTypes.isEmpty()) continue;
                settings.setSearchIn(3);
                settings.setUserDefinedFieldTypes(progTypes.toArray(new ProgramFieldType[0]));
                continue;
            }
            if (key.equals(KEY_SEARCH_TEXT)) {
                searchText = v;
                continue;
            }
            if (!key.equals(KEY_SEARCH_CASE_SENSITIVE)) continue;
            settings.setCaseSensitive(v.equals("true") || v.equals("1"));
        }
        if (!searchText.isBlank()) {
            SearchPlugin.getInstance().openSearchDialog(searchText, settings, true);
        }
    }

    private void configMessage(String message, String[] parts) {
        if (0 == UiUtilities.showConfirmDialogOnMouseScreen(LOCALIZER.msg("receive.config.msg", "TV-Browser received changes of settings:\n{0}\n\nIf you haven't triggered the change, please cancel it now!\n\nDo you want to apply the changed settings?", message), LOCALIZER.msg("receive.config.title", "Apply settings change?"), 1, 3, true)) {
            try {
                String[] props;
                for (String prop : props = parts[1].split(";")) {
                    String name = prop.substring(0, prop.indexOf("="));
                    if (name.equals("CanReceiveProtocolMessages") || name.equals("ServerRestoreEnabled") || name.equals("General.CAN_RECEIVE_PROTOCOL_MESSAGE") || name.equals("General.SERVER_RESTORE_ENABLED") || name.indexOf(".") <= 0) continue;
                    String className = name.substring(0, name.lastIndexOf(".")).replace(".", "$");
                    String propName = name.substring(name.indexOf(".") + 1);
                    Field f = Class.forName("tvbrowser.core.Settings$" + className).getDeclaredField(propName);
                    Object p = f.get(null);
                    String value = prop.substring(prop.indexOf("=") + 1);
                    if (p instanceof BooleanProperty) {
                        if (!value.equals("true") && !value.equals("false") && !value.equals("1") && !value.equals("0")) continue;
                        ((BooleanProperty)p).setBoolean(value.equals("true") || value.equals("1"));
                        continue;
                    }
                    if (p instanceof IntProperty) {
                        try {
                            int v = Integer.parseInt(value);
                            ((IntProperty)p).setInt(v);
                        }
                        catch (NumberFormatException nfe) {
                            nfe.printStackTrace();
                        }
                        continue;
                    }
                    if (p instanceof IntArrayProperty) {
                        try {
                            String[] values = value.split(",");
                            int[] arr = new int[values.length];
                            for (int i = 0; i < arr.length; ++i) {
                                arr[i] = Integer.parseInt(values[i]);
                            }
                            ((IntArrayProperty)p).setIntArray(arr);
                        }
                        catch (NumberFormatException nfe) {
                            nfe.printStackTrace();
                        }
                        continue;
                    }
                    if (p instanceof ByteProperty) {
                        try {
                            byte v = Byte.parseByte(value);
                            ((ByteProperty)p).setByte(v);
                        }
                        catch (NumberFormatException nfe) {
                            nfe.printStackTrace();
                        }
                        continue;
                    }
                    if (p instanceof StringProperty) {
                        ((StringProperty)p).setString(ProtocolHandler.unescape(value));
                        continue;
                    }
                    if (p instanceof StringArrayProperty) {
                        String[] temp = value.split(",");
                        for (int i = 0; i < temp.length; ++i) {
                            temp[i] = ProtocolHandler.unescape(temp[i]);
                        }
                        ((StringArrayProperty)p).setStringArray(temp);
                        continue;
                    }
                    if (p instanceof ChoiceProperty) {
                        String v = ProtocolHandler.unescape(value);
                        if (!((ChoiceProperty)p).isAllowed(v)) continue;
                        ((ChoiceProperty)p).setString(v);
                        continue;
                    }
                    if (!(p instanceof ColorProperty)) continue;
                    try {
                        String[] values = value.split(",");
                        Color c = null;
                        if (values.length == 3) {
                            c = new Color(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]));
                        } else if (values.length == 4) {
                            c = new Color(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]));
                        }
                        if (c == null) continue;
                        ((ColorProperty)p).setColor(c);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Settings.storeSettings(true);
            }
            catch (TvBrowserException e) {
                e.printStackTrace();
            }
        }
    }

    private void showMessage(String[] parts) {
        if (parts[1].equals(MESSAGE_PROGRAM)) {
            this.showProgramMessage(parts);
        } else {
            String name = parts[1].substring(0, parts[1].indexOf("="));
            String value = parts[1].substring(parts[1].indexOf("=") + 1).replace("startup", "#startup".substring(1));
            if (name.equals(MESSAGE_SETTINGS)) {
                SwingUtilities.invokeLater(() -> PluginManagerImpl.getInstance().showSettings((value.contains(".") ? "" : "#") + value));
            } else if (name.equals(MESSAGE_PLUGIN_UPDATE)) {
                boolean select = false;
                String[] subParts = value.split(";");
                StringBuilder search = new StringBuilder();
                for (String subPart : subParts) {
                    if (subPart.toLowerCase().equals("select")) {
                        select = true;
                        continue;
                    }
                    search.append(subPart);
                }
                MainFrame.getInstance().showUpdatePluginsDlg(false, ProtocolHandler.unescape(search.toString()), select);
            }
        }
    }

    private void showProgramMessage(String[] parts) {
        int index = parts[2].indexOf("=");
        if (index != -1) {
            String key = parts[2].substring(0, index);
            String v = ProtocolHandler.unescape(parts[2].substring(index + 1));
            if (key.equals(KEY_SHOW_PROGRAM_ID)) {
                Program p = PluginManagerImpl.getInstance().getProgram(v);
                if (p != null) {
                    ProgramInfo.getInstance().showProgramInformation(p);
                }
                return;
            }
        }
    }

    private void pluginMessage(String[] parts) {
        if (MESSAGE_ENABLE.contentEquals(parts[1]) && parts.length == 3 && parts[2].contains("=")) {
            this.pluginEnableMessage(parts);
        } else if (MESSAGE_CONFIG.equals(parts[1]) && parts.length == 4) {
            this.pluginConfigMessage(parts);
        }
    }

    private void pluginEnableMessage(String[] parts) {
        String[] values = parts[2].split("=");
        PluginProxy p = PluginProxyManager.getInstance().getPluginForId("java." + values[0].toLowerCase() + "." + values[0]);
        if (p != null) {
            if (!p.isActivated() && (values[1].equals("true") || values[1].equals("1"))) {
                if (0 == UiUtilities.showConfirmDialogOnMouseScreen(LOCALIZER.msg("receive.plugin.enable.msg", "TV-Browser received the activation of the plugin '{0}'.\n\nDo you wan't to activate the plugin '{0}' now?", p.getInfo().getName()), LOCALIZER.msg("receive.plugin.enable.title", "Activate plugin '{0}'?", p.getInfo().getName()), 1, 3)) {
                    try {
                        PluginProxyManager.getInstance().activatePlugin(p, true);
                        try {
                            PluginProxyManager.getInstance().fireTvBrowserStartFinished(p);
                        }
                        catch (Throwable t) {
                            LOG.log(Level.WARNING, "A not catched error occured in 'fireTvBrowserStartFinishedThread' of Plugin '" + p + "'.", t);
                        }
                    }
                    catch (TvBrowserException e) {
                        e.printStackTrace();
                    }
                    MainFrame.getInstance().getToolbar().updatePluginButtons();
                    MainFrame.getInstance().updatePluginsMenu();
                }
            } else if (p.isActivated() && (values[1].equals("false") || values[1].equals("0")) && 0 == UiUtilities.showConfirmDialogOnMouseScreen(LOCALIZER.msg("receive.plugin.disable.msg", "TV-Browser received the deactivation of the plugin '{0}'.\n\nDo you wan't to deactivate the plugin '{0}' now?", p.getInfo().getName()), LOCALIZER.msg("receive.plugin.disable.title", "Dectivate plugin '{0}'?", p.getInfo().getName()), 1, 3)) {
                try {
                    PluginProxyManager.getInstance().deactivatePlugin(p);
                }
                catch (TvBrowserException e) {
                    e.printStackTrace();
                }
                MainFrame.getInstance().getToolbar().updatePluginButtons();
                MainFrame.getInstance().updatePluginsMenu();
            }
        }
        String[] deactivatedPlugins = PluginProxyManager.getInstance().getDeactivatedPluginIds();
        Settings.Plugins.DEACTIVATED.setStringArray(deactivatedPlugins);
        try {
            Settings.storeSettings(true);
        }
        catch (TvBrowserException e) {
            e.printStackTrace();
        }
    }

    private void pluginConfigMessage(String[] parts) {
        PluginProxy a = PluginProxyManager.getInstance().getActivatedPluginForId("java." + parts[2].toLowerCase() + "." + parts[2]);
        if (a != null) {
            a.receiveValues(0, parts[3].split(";"), null);
        } else {
            TvDataServiceProxy[] ps = TvDataServiceProxyManager.getInstance().getTvDataServices(new String[]{parts[2].toLowerCase() + "." + parts[2]});
            if (ps.length == 1 && ps[0].getId().equals(parts[2].toLowerCase() + "." + parts[2])) {
                ps[0].receiveProtocolMessage(parts[3].split(";"));
            }
        }
    }

    public void handleSettingsChanged() {
        if (this.mIsEnabled && !Settings.General.CAN_RECEIVE_PROTOCOL_MESSAGE.getBoolean()) {
            this.disable(true);
        } else if (!this.mIsEnabled && Settings.General.CAN_RECEIVE_PROTOCOL_MESSAGE.getBoolean()) {
            this.enable(true);
        }
    }

    private void checkWindows() {
        RegistryKey rKey = new RegistryKey("HKCU", "SOFTWARE\\classes\\tvb\\shell\\open\\command");
        RegistryValue v = rKey.getValue("");
        File exe = new File(TVBrowser.isTransportable() ? "tvbrowser-transportable.exe" : "tvbrowser.exe");
        if (v == null || !v.getData().contains(exe.getAbsolutePath())) {
            if (DontShowAgainOptionBox.showOptionDialog("tvbProtocolWrongTarget", UiUtilities.getParentFrameOnMouseScreen(), LOCALIZER.msg("error.win.msg", "Receiving protocol message with tvb:// is activated.\nProtocol message make it easier to configure TV-Browser.\nBut the protocol doesn't exists in Windows or leads to another TV-Browser.\n\nShould the protocol be created in Windows now to lead to this TV-Browser (Administrator rights are needed for this)?\n(The protocol messages are deactivted for this TV-Browser if not.)"), LOCALIZER.msg("error.win.title", "tvb:// protocol error"), 3, 1) == 0) {
                this.enableWindows();
            } else {
                Settings.General.CAN_RECEIVE_PROTOCOL_MESSAGE.setBoolean(false);
                this.mIsEnabled = false;
                try {
                    Settings.storeSettings(true);
                }
                catch (TvBrowserException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void enable(boolean fromSettings) {
        if (Launch.getOs() == 3) {
            File test = new File(System.getProperty("user.home") + "/.local/share/applications/tvbrowserWebstart.desktop");
            if (test.isFile()) {
                test.delete();
            }
            File target = new File("/usr/share/applications/tvbrowser.desktop");
            File baseDir = new File("");
            String name = "tvbrowser.desktop";
            if (!target.isFile() || !baseDir.getAbsolutePath().equals("/usr/share/tvbrowser")) {
                target = test;
                if (target.isFile()) {
                    target.delete();
                }
                ProtocolHandler.createDesktopFile(target, "TV-Browser Webstart", true);
                name = "tvbrowserWebstart.desktop";
            }
            ExecutionHandler h = ExecutionHandler.create("/usr/bin/xdg-mime", "default", name, "x-scheme-handler/tvb");
            try {
                h.execute();
                h.getProcess().waitFor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            h = ExecutionHandler.create("/usr/bin/xdg-desktop-menu", "forceupdate");
            try {
                h.execute();
                h.getProcess().waitFor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            h = ExecutionHandler.create("/usr/bin/xdg-mime", "query", "default", "x-scheme-handler/tvb");
            try {
                File apps;
                h.execute(true);
                h.getProcess().waitFor();
                if (h.getOutput().isBlank() && !(apps = new File(System.getProperty("user.home"), ".local/share/applications")).isDirectory()) {
                    apps.mkdirs();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (Launch.getOs() == 1) {
            this.enableWindows();
        }
        this.mIsEnabled = true;
    }

    private void enableWindows() {
        File exe = new File(TVBrowser.isTransportable() ? "tvbrowser-transportable.exe" : "tvbrowser.exe");
        RegistryKey key = new RegistryKey("HKCU", "SOFTWARE\\Classes\\tvb");
        key.setValue(new RegistryValue("\"\"", 1, "URL:tvb Protocol"));
        key.setValue(new RegistryValue("URL Protocol", 1, "\"\""));
        key = new RegistryKey("HKCU", "SOFTWARE\\Classes\\tvb\\DefaultIcon");
        key.setValue(new RegistryValue("\"\"", 1, "\\\"" + exe.getAbsolutePath() + "\\\""));
        key = new RegistryKey("HKCU", "SOFTWARE\\Classes\\tvb\\shell\\open\\command");
        key.setValue(new RegistryValue("\"\"", 1, "\\\"" + exe.getAbsolutePath() + "\\\" \\\"%1\\\""));
    }

    private void disable(boolean fromSettings) {
        if (Launch.getOs() == 3) {
            File target = new File(System.getProperty("user.home") + "/.local/share/applications/tvbrowserWebstart.desktop");
            if (target.isFile()) {
                target.delete();
            }
            ExecutionHandler h = ExecutionHandler.create("/usr/bin/sed", "-i", "/x-scheme-handler\\/tvb=/d", System.getProperty("user.home") + "/.config/mimeapps.list");
            try {
                h.execute();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            h = ExecutionHandler.create("/usr/bin/xdg-desktop-menu", "forceupdate");
            try {
                h.execute();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (Launch.getOs() == 1) {
            RegistryKey key = new RegistryKey("HKCU", "SOFTWARE\\Classes\\tvb");
            key.delete();
        }
        this.mIsEnabled = false;
    }

    public static void createDesktopFile(File target, String name, boolean isMimeHandler) {
        if (!target.getParentFile().isDirectory()) {
            target.mkdirs();
        }
        File baseDir = new File("");
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), "UTF-8"));){
            out.write("[Desktop Entry]\n");
            out.write("Version=1.0\n");
            out.write("Type=Application\n");
            out.write("Terminal=false\n");
            out.write("Name=" + name + "\n");
            out.write("Icon=" + baseDir.getAbsolutePath() + "/imgs/tvbrowser128.png\n");
            out.write("Exec=" + baseDir.getAbsolutePath() + "/tvbrowser" + (TVBrowser.isTransportable() ? "-transportable" : "") + ".sh %u\n");
            out.write("Comment=Themeable and easy to use TV Guide - written in Java\n");
            out.write("Categories=Video;AudioVideo;TV\n");
            out.write("Name[de]=" + name + "\n");
            out.write("GenericName=Digital TV Guide\n");
            out.write("GenericName[de]=Digitale TV-Zeitschrift\n");
            out.write("Comment[de]=Anpassbare und einfach zu benutzende TV-Zeitschrift - geschrieben in Java\n");
            out.write("StartupWMClass=tvbrowser-TVBrowser\n");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static String unescape(String value) {
        return URLDecoder.decode(value.replace(ESCAPE_COMMA, ",").replace(ESCAPE_QUOTE, "\"").replace(ESCAPE_SEMICOLON, ";").replace(ESCAPE_SLASH, "/"), Charset.defaultCharset());
    }
}

