/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.dlgs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import devplugin.ProgramFilter;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterList;
import tvbrowser.extras.common.LimitationConfiguration;
import tvbrowser.extras.favoritesplugin.FavoriteConfigurator;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FavoriteFilter;
import tvbrowser.extras.favoritesplugin.dlgs.ExclusionPanel;
import tvbrowser.extras.reminderplugin.RemindValue;
import tvbrowser.extras.reminderplugin.ReminderConstants;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.ChannelChooserDlg;
import util.ui.EnhancedPanelBuilder;
import util.ui.PluginChooserDlg;
import util.ui.TimePeriodChooser;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class EditFavoriteDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(EditFavoriteDialog.class);
    private Favorite mFavorite;
    private JCheckBox mReminderAfterDownloadCb;
    private JCheckBox mProvideFilter;
    private JCheckBox mUseReminderCb;
    private JComboBox<RemindValue> mReminderMinutesSelection;
    private JCheckBox mLimitChannelCb;
    private JCheckBox mLimitTimeCb;
    private JButton mChangeChannelsBtn;
    private JLabel mChannelLabel;
    private Channel[] mChannelArr;
    private JComboBox<LimitationConfiguration.DayLimitValue> mLimitDaysCB;
    private TimePeriodChooser mTimePeriodChooser;
    private JCheckBox mPassProgramsCheckBox;
    private ProgramReceiveTarget[] mPassProgramPlugins;
    private JLabel mPassProgramsLb;
    private JButton mChangePassProgramsBtn;
    private boolean mOkWasPressed;
    private FavoriteConfigurator mFavoriteConfigurator;
    private JLabel mName;
    private ExclusionPanel mExclusionPanel;

    public EditFavoriteDialog(Window parent, Favorite fav) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(fav);
    }

    private void init(Favorite fav) {
        try {
            UiUtilities.registerForClosing(this);
            this.mOkWasPressed = false;
            this.mFavorite = fav;
            this.mFavoriteConfigurator = this.mFavorite.createConfigurator();
            this.setTitle(LOCALIZER.msg("title", "Edit {0}", fav.getTypeName()));
            JPanel rootPn = new JPanel();
            rootPn.setLayout(new BorderLayout());
            rootPn.setBorder(Borders.DLU4);
            rootPn.setOpaque(true);
            EnhancedPanelBuilder pb = new EnhancedPanelBuilder("3dlu,default:grow,2dlu", "1dlu");
            pb.border(new EmptyBorder(10, 10, 10, 10));
            pb.addSeparatorRowFull(false, LOCALIZER.msg("section.head", "Favorite"));
            pb.addRow(this.createTitleChangePanel(), 2);
            pb.addRow(this.mFavoriteConfigurator.createConfigurationPanel(), 2);
            pb.addSeparatorRowFull(LOCALIZER.msg("section.details", "Details"));
            pb.addRow(this.createLimitPanel(), 2);
            pb.addSeparatorRowFull(LOCALIZER.msg("section.exclusions", "Exclusion Criteria"));
            this.mExclusionPanel = new ExclusionPanel(this.mFavorite.getExclusions(), this, this.mFavorite);
            pb.addRow("fill:60dlu:grow", (Component)this.mExclusionPanel, 2);
            pb.addSeparatorRowFull(LOCALIZER.msg("section.reminder", "Reminder"));
            pb.addRow(this.createReminderPanel(), 2);
            pb.addSeparatorRowFull(LOCALIZER.msg("section.extras", "Extras"));
            pb.addRow(this.createExtrasPanel(), 2);
            JButton cancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
            JButton okBtn = new JButton(Localizer.getLocalization("i18n_ok"));
            cancelBtn.addActionListener(e -> this.setVisible(false));
            okBtn.addActionListener(e -> this.saveAndClose());
            ButtonBarBuilder buttons = new ButtonBarBuilder();
            buttons.addGlue();
            buttons.addButton((JComponent[])new JButton[]{okBtn, cancelBtn});
            JScrollPane scrollPane = new JScrollPane(pb.getPanel());
            scrollPane.setBorder(null);
            scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            rootPn.add("Center", scrollPane);
            rootPn.add("South", buttons.getPanel());
            this.getRootPane().setDefaultButton(okBtn);
            pb.getPanel().setOpaque(true);
            this.setContentPane(rootPn);
            Settings.layoutWindow(fav.getClass().getCanonicalName(), this);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            if (d.height < this.getHeight()) {
                this.setSize(this.getWidth(), d.height);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private JPanel createTitleChangePanel() {
        CellConstraints cc = new CellConstraints();
        if (this.mFavorite.getName().length() < 1) {
            this.mName = new JLabel(LOCALIZER.msg("defaultName", "Is going to be created automatically"));
            this.mName.setEnabled(false);
        } else {
            this.mName = new JLabel(this.mFavorite.getName());
        }
        JPanel panel = new JPanel((LayoutManager)new FormLayout("pref,3dlu,30dlu:grow,3dlu,pref", "pref"));
        panel.add((Component)new JLabel(LOCALIZER.msg("name", "Name:")), cc.xy(1, 1));
        panel.add((Component)this.mName, cc.xy(3, 1));
        JButton changeTitle = new JButton(LOCALIZER.msg("changeName", "Change name"));
        changeTitle.setFocusable(false);
        changeTitle.addActionListener(e -> this.setFavoriteName());
        panel.add((Component)changeTitle, cc.xy(5, 1));
        return panel;
    }

    private void setFavoriteName() {
        String newName = (String)JOptionPane.showInputDialog(this, LOCALIZER.msg("name", "Name:"), LOCALIZER.msg("renameFav", "Rename Favorite"), -1, null, null, this.mName.getText());
        if (EditFavoriteDialog.isValidName(newName)) {
            this.mName.setText(newName);
            this.mName.setEnabled(true);
        } else if (this.mName.getText().compareTo(LOCALIZER.msg("defaultName", "Is going to be created automatically")) == 0) {
            this.mName.setEnabled(false);
        }
    }

    private static boolean isValidName(String name) {
        return name != null && name.length() > 0 && name.compareTo(LOCALIZER.msg("defaultName", "Is going to be created automatically")) != 0;
    }

    private String getChannelString(Channel[] channelArr) {
        if (channelArr != null && channelArr.length > 0) {
            Object result;
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < channelArr.length - 1; ++i) {
                buf.append(channelArr[i]).append(", ");
            }
            if (channelArr.length > 0) {
                buf.append(channelArr[channelArr.length - 1]);
            }
            if (((String)(result = buf.toString())).length() > 50) {
                result = ((String)result).substring(0, 50);
                int inx = ((String)result).lastIndexOf(44);
                result = ((String)result).substring(0, inx) + ", ...";
            }
            if (this.mChannelLabel != null) {
                this.mChannelLabel.setForeground(new JLabel().getForeground());
            }
            return result;
        }
        if (!this.mLimitChannelCb.isSelected()) {
            return LOCALIZER.msg("allChannels", "All channels");
        }
        return LOCALIZER.msg("noChannels", "No channels");
    }

    private void setLimitChannelEnabled(boolean enabled) {
        this.mChangeChannelsBtn.setEnabled(enabled);
        this.mChannelLabel.setEnabled(enabled);
        this.mChannelLabel.setText(this.getChannelString(this.mChannelArr));
        if (this.mChannelArr == null || this.mChannelArr.length < 1) {
            this.mChannelLabel.setForeground(Color.red);
        } else {
            this.mChannelLabel.setForeground(new JLabel().getForeground());
        }
    }

    private JPanel createLimitPanel() {
        int to;
        int from;
        if (this.mFavorite.getLimitationConfiguration().isLimitedByTime()) {
            from = this.mFavorite.getLimitationConfiguration().getTimeFrom();
            to = this.mFavorite.getLimitationConfiguration().getTimeTo();
        } else {
            from = 0;
            to = 1439;
        }
        this.mTimePeriodChooser = new TimePeriodChooser(from, to, 1);
        this.mChangeChannelsBtn = new JButton(LOCALIZER.msg("change", "Change"));
        this.mChannelArr = this.mFavorite.getLimitationConfiguration().getChannels();
        this.mLimitChannelCb = new JCheckBox(LOCALIZER.msg("channels", "Channels:") + " ");
        this.mLimitTimeCb = new JCheckBox(LOCALIZER.msg("time", "Time:") + " ");
        this.mChannelLabel = new JLabel(this.getChannelString(this.mChannelArr));
        this.mLimitDaysCB = new JComboBox<LimitationConfiguration.DayLimitValue>(LimitationConfiguration.DAYLIMIT_VALUE_ARRAY);
        this.mLimitDaysCB.setSelectedItem(this.mFavorite.getLimitationConfiguration().getDayLimitValue());
        boolean isLimitedByChannel = this.mFavorite.getLimitationConfiguration().isLimitedByChannel();
        boolean isLimitedByTime = this.mFavorite.getLimitationConfiguration().isLimitedByTime();
        this.mLimitChannelCb.setSelected(isLimitedByChannel);
        this.mLimitTimeCb.setSelected(isLimitedByTime);
        this.setLimitChannelEnabled(isLimitedByChannel);
        this.mTimePeriodChooser.setEnabled(isLimitedByTime);
        this.mLimitDaysCB.setEnabled(this.mLimitTimeCb.isSelected());
        this.mLimitChannelCb.addActionListener(e -> this.setLimitChannelEnabled(this.mLimitChannelCb.isSelected()));
        this.mLimitTimeCb.addActionListener(e -> {
            this.mTimePeriodChooser.setEnabled(this.mLimitTimeCb.isSelected());
            this.mLimitDaysCB.setEnabled(this.mLimitTimeCb.isSelected());
        });
        this.mChangeChannelsBtn.addActionListener(e -> {
            ChannelChooserDlg dlg = new ChannelChooserDlg((Window)this, this.mChannelArr, null, 1);
            UiUtilities.centerAndShow(dlg);
            Channel[] chArr = dlg.getChannels();
            if (chArr != null) {
                this.mChannelArr = dlg.getChannels();
                if (this.mChannelArr.length == 0) {
                    this.mLimitChannelCb.setSelected(false);
                    this.setLimitChannelEnabled(false);
                }
                this.mChannelLabel.setText(this.getChannelString(this.mChannelArr));
            }
        });
        JPanel limitPn = new JPanel(new BorderLayout());
        JPanel pn = new JPanel((LayoutManager)new FormLayout("pref, 3dlu, pref", "pref"));
        pn.add((Component)this.mTimePeriodChooser, CC.xy((int)1, (int)1));
        pn.add(this.mLimitDaysCB, CC.xy((int)3, (int)1));
        limitPn.add((Component)pn, "East");
        EnhancedPanelBuilder panelBuilder = new EnhancedPanelBuilder(new FormLayout("pref, pref:grow, pref"));
        panelBuilder.addRow(false, (Component)this.mLimitChannelCb, 1);
        panelBuilder.add(this.mChannelLabel, 2);
        panelBuilder.add(this.mChangeChannelsBtn, 3);
        panelBuilder.addRow(this.mLimitTimeCb, 1);
        panelBuilder.addFull(limitPn, 2);
        return panelBuilder.getPanel();
    }

    private JPanel createReminderPanel() {
        String[] s;
        JPanel panel = new JPanel((LayoutManager)new FormLayout("default,5dlu:grow,default", "default"));
        this.mUseReminderCb = new JCheckBox(LOCALIZER.msg("reminderWindow", "Reminder window"));
        panel.add((Component)this.mUseReminderCb, CC.xy((int)1, (int)1));
        this.mReminderMinutesSelection = ReminderConstants.getPreReminderMinutesSelection(this.mFavorite.getReminderMinutesDefault());
        panel.add(this.mReminderMinutesSelection, CC.xy((int)3, (int)1));
        this.mReminderMinutesSelection.setEnabled(false);
        this.mUseReminderCb.addItemListener(e -> this.mReminderMinutesSelection.setEnabled(e.getStateChange() == 1));
        for (String element : s = this.mFavorite.getReminderConfiguration().getReminderServices()) {
            if (!"window".equals(element)) continue;
            this.mUseReminderCb.setSelected(true);
            this.mReminderMinutesSelection.setEnabled(true);
        }
        return panel;
    }

    private static String getForwardPluginsLabelString(ProgramReceiveTarget[] receiveTargetArr) {
        ArrayList<ProgramReceiveIf> plugins = new ArrayList<ProgramReceiveIf>();
        for (int i = 0; i < receiveTargetArr.length; ++i) {
            ProgramReceiveIf target;
            if (plugins.contains(receiveTargetArr[i].getReceifeIfForIdOfTarget()) || (target = receiveTargetArr[i].getReceifeIfForIdOfTarget()) == null) continue;
            plugins.add(target);
        }
        ProgramReceiveIf[] pluginArr = plugins.toArray(new ProgramReceiveIf[plugins.size()]);
        if (pluginArr != null && pluginArr.length > 0) {
            StringBuilder buf = new StringBuilder();
            if (pluginArr.length > 0) {
                buf.append(pluginArr[0].toString());
            }
            if (pluginArr.length > 1) {
                buf.append(", ");
                buf.append(pluginArr[1].toString());
            }
            if (pluginArr.length > 2) {
                buf.append(" (");
                buf.append(pluginArr.length - 2);
                buf.append(' ');
                buf.append(LOCALIZER.msg("more", "more"));
                buf.append("...)");
            }
            return buf.toString();
        }
        return LOCALIZER.msg("dontpass", "don't pass programs");
    }

    private JPanel createExtrasPanel() {
        JPanel panel = new JPanel((LayoutManager)new FormLayout("default, default:grow, default", "default,3dlu,default,3dlu,default"));
        CellConstraints cc = new CellConstraints();
        this.mPassProgramPlugins = this.mFavorite.getForwardPlugins();
        this.mPassProgramsLb = new JLabel(EditFavoriteDialog.getForwardPluginsLabelString(this.mPassProgramPlugins));
        this.mChangePassProgramsBtn = new JButton(LOCALIZER.msg("change", "Change"));
        this.mChangePassProgramsBtn.addActionListener(e -> {
            PluginChooserDlg dlg = new PluginChooserDlg(2, this, this.mPassProgramPlugins, null, ReminderPluginProxy.getInstance(), FavoritesPlugin.getInstance().getClientPluginTargetIds());
            UiUtilities.centerAndShow(dlg);
            ProgramReceiveTarget[] pluginArr = dlg.getReceiveTargets();
            if (pluginArr != null) {
                this.mPassProgramPlugins = pluginArr;
                this.mPassProgramsLb.setText(EditFavoriteDialog.getForwardPluginsLabelString(this.mPassProgramPlugins));
                if (pluginArr.length == 0) {
                    this.mPassProgramsCheckBox.setSelected(false);
                    this.updatePassProgramsPanel();
                }
            }
        });
        this.mReminderAfterDownloadCb = new JCheckBox(LOCALIZER.msg("autoAlert", "Alert me, whenever a matching program is discovered"));
        panel.add((Component)this.mReminderAfterDownloadCb, cc.xyw(1, 1, 2));
        this.mProvideFilter = new JCheckBox(LOCALIZER.msg("provideFilter", "Provide filter for this Favorite program"));
        panel.add((Component)this.mProvideFilter, cc.xyw(1, 3, 2));
        this.mPassProgramsCheckBox = new JCheckBox(LOCALIZER.msg("passProgramsTo", "Pass programs to") + " ");
        panel.add((Component)this.mPassProgramsCheckBox, cc.xy(1, 5));
        panel.add((Component)this.mPassProgramsLb, cc.xy(2, 5));
        panel.add((Component)this.mChangePassProgramsBtn, cc.xy(3, 5));
        this.mReminderAfterDownloadCb.setSelected(this.mFavorite.isRemindAfterDownload());
        this.mProvideFilter.setSelected(this.mFavorite.isProvidingFilter());
        ArrayList<ProgramReceiveTarget> targets = new ArrayList<ProgramReceiveTarget>();
        if (this.mPassProgramPlugins != null || this.mPassProgramPlugins.length > 0) {
            for (ProgramReceiveTarget target : this.mPassProgramPlugins) {
                if (target.getReceifeIfForIdOfTarget() == null) continue;
                targets.add(target);
            }
        }
        this.mPassProgramPlugins = targets.toArray(new ProgramReceiveTarget[targets.size()]);
        this.mPassProgramsCheckBox.setSelected(this.mPassProgramPlugins != null && this.mPassProgramPlugins.length > 0 && !this.mPassProgramsLb.getText().equals(LOCALIZER.msg("dontpass", "don't pass programs")));
        this.mPassProgramsCheckBox.setEnabled(FavoritesPlugin.getInstance().getClientPluginTargetIds().length == 0);
        this.mPassProgramsCheckBox.addActionListener(e -> this.updatePassProgramsPanel());
        this.updatePassProgramsPanel();
        return panel;
    }

    private void updatePassProgramsPanel() {
        this.mPassProgramsLb.setEnabled(this.mPassProgramsCheckBox.isSelected());
        this.mChangePassProgramsBtn.setEnabled(this.mPassProgramsCheckBox.isSelected());
        if (!this.mPassProgramsCheckBox.isSelected()) {
            this.mPassProgramPlugins = new ProgramReceiveTarget[0];
        }
    }

    public boolean getOkWasPressed() {
        return this.mOkWasPressed;
    }

    private void saveAndClose() {
        if (!this.mFavoriteConfigurator.check()) {
            return;
        }
        this.mFavoriteConfigurator.save();
        if (this.mLimitTimeCb.isSelected()) {
            this.mFavorite.getLimitationConfiguration().setTime(this.mTimePeriodChooser.getFromTime(), this.mTimePeriodChooser.getToTime());
            this.mFavorite.getLimitationConfiguration().setDayLimit(((LimitationConfiguration.DayLimitValue)this.mLimitDaysCB.getSelectedItem()).getDay());
        } else {
            this.mFavorite.getLimitationConfiguration().setIsLimitedByTime(false);
            this.mFavorite.getLimitationConfiguration().setDayLimit(-1);
        }
        if (this.mLimitChannelCb.isSelected() && this.mChannelArr.length > 0) {
            this.mFavorite.getLimitationConfiguration().setChannels(this.mChannelArr);
        } else {
            this.mFavorite.getLimitationConfiguration().setIsLimitedByChannel(false);
        }
        this.mFavorite.setForwardPlugins(this.mPassProgramPlugins);
        this.mFavorite.setExclusions(this.mExclusionPanel.getExclusions());
        this.mFavorite.setRemindAfterDownload(this.mReminderAfterDownloadCb.isSelected());
        this.mFavorite.setProvideFilter(this.mProvideFilter.isSelected());
        boolean wasReminderEnabled = this.mFavorite.getReminderConfiguration().containsService("window");
        int reminderMinutesOld = this.mFavorite.getReminderMinutesDefault();
        if (this.mUseReminderCb.isSelected()) {
            this.mFavorite.setReminderMinutesDefault(ReminderConstants.getReminderMinutesSelected(this.mReminderMinutesSelection));
            this.mFavorite.getReminderConfiguration().setReminderServices(new String[]{"window"});
        } else {
            if (wasReminderEnabled) {
                ReminderPlugin.getInstance().removePrograms(this.mFavorite.getPrograms());
            }
            this.mFavorite.getReminderConfiguration().setReminderServices(new String[0]);
        }
        try {
            this.mFavorite.updatePrograms(false);
        }
        catch (TvBrowserException exc) {
            ErrorHandler.handle(LOCALIZER.msg("error.updateFavoriteFailed", "Could not update favorite"), exc);
            return;
        }
        for (ProgramReceiveTarget target : this.mPassProgramPlugins) {
            if (target.getSupportedEventType() == 2) continue;
            target.getReceifeIfForIdOfTarget().receivePrograms(1, this.mFavorite.getPrograms(), target);
        }
        if (this.mUseReminderCb.isSelected() && !wasReminderEnabled) {
            ReminderPlugin.getInstance().addPrograms(this.mFavorite.getPrograms(), this.mFavorite.getReminderMinutesDefault());
        } else if (this.mUseReminderCb.isSelected() && reminderMinutesOld != this.mFavorite.getReminderMinutesDefault()) {
            ReminderPlugin.getInstance().updatePrograms(this.mFavorite.getPrograms(), this.mFavorite.getReminderMinutesDefault(), reminderMinutesOld);
        }
        if (this.mName.getText().length() > 0 && this.mName.getText().compareTo(LOCALIZER.msg("defaultName", "Is going to be created automatically")) != 0) {
            this.mFavorite.setName(this.mName.getText());
        }
        this.mOkWasPressed = true;
        this.setVisible(false);
        ProgramFilter[] currentFilter = FilterList.getInstance().getFilterTreeModel().getAllFilters();
        FavoriteFilter test = new FavoriteFilter(this.mFavorite);
        FavoriteFilter found = null;
        for (ProgramFilter filter : currentFilter) {
            if (!filter.equals(test)) continue;
            found = (FavoriteFilter)filter;
            break;
        }
        if (!this.mFavorite.isProvidingFilter() && found != null) {
            FilterList.getInstance().getFilterTreeModel().deleteFilter(found, false);
        } else if (found == null && this.mFavorite.isProvidingFilter()) {
            FilterList.getInstance().getFilterTreeModel().addFilter(test);
        }
        FilterList.getInstance().store();
        MainFrame.getInstance().updateFilterMenu();
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

