/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.wizards;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.favoritesplugin.wizards.WizardStep;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class WizardDlg
extends JDialog
implements WindowClosingIf {
    protected static final Localizer mLocalizer = Localizer.getLocalizerFor(WizardDlg.class);
    private static final int CANCEL = 0;
    protected static final int FINISH = 2;
    private int mResult;
    private WizardStep mStep;
    private JButton mNextBtn;
    private JButton mBackBtn;
    private JButton mDoneBtn;
    private JButton mCancelBtn;
    private JPanel mCurrentContentPanel;
    private JPanel mButtonPanel;
    private WizardHandler mHandler;
    private Object mDataObject;

    public WizardDlg(Window parent, WizardHandler handler, WizardStep step) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(step, handler);
    }

    private void init(WizardStep step, WizardHandler handler) {
        this.setSize(Sizes.dialogUnitXAsPixel((int)450, (Component)this), Sizes.dialogUnitYAsPixel((int)180, (Component)this));
        UiUtilities.registerForClosing(this);
        this.mResult = 0;
        this.mHandler = handler;
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout((LayoutManager)new FormLayout("fill:default:grow", "fill:pref:grow, 3dlu, bottom:pref"));
        panel.setBorder(Borders.DLU4);
        this.switchToStep(step);
    }

    private JPanel createButtonPanel(int[] btns) {
        this.mDoneBtn = new JButton(mLocalizer.msg("done", "Done"));
        this.mDoneBtn.setEnabled(false);
        this.mCancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCancelBtn.setEnabled(false);
        this.mNextBtn = new JButton(Localizer.getLocalization("i18n_next") + " >>");
        this.mNextBtn.setEnabled(false);
        this.mBackBtn = new JButton("<< " + Localizer.getLocalization("i18n_back"));
        this.mBackBtn.setEnabled(false);
        JPanel panel = new JPanel((LayoutManager)new FormLayout("fill:pref:grow, pref, 3dlu, pref", "pref"));
        CellConstraints cc = new CellConstraints();
        if (!this.mStep.isSingleStep()) {
            FormLayout layout = new FormLayout("pref, 3dlu, pref", "pref");
            layout.setColumnGroups((int[][])new int[][]{{1, 3}});
            Object nextpanel = new JPanel((LayoutManager)layout);
            ((Container)nextpanel).add((Component)this.mBackBtn, cc.xy(1, 1));
            ((Container)nextpanel).add((Component)this.mNextBtn, cc.xy(3, 1));
            panel.add((Component)nextpanel, cc.xy(2, 1));
        }
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addButton((JComponent)this.mDoneBtn);
        builder.addRelatedGap();
        builder.addFixed((JComponent)this.mCancelBtn);
        panel.add((Component)builder.getPanel(), cc.xy(4, 1));
        for (int btn : btns) {
            if (btn == 2) {
                this.mDoneBtn.setEnabled(true);
                continue;
            }
            if (btn == 3) {
                this.mBackBtn.setEnabled(true);
                continue;
            }
            if (btn == 1) {
                this.mNextBtn.setEnabled(true);
                continue;
            }
            if (btn != 4) continue;
            this.mCancelBtn.setEnabled(true);
        }
        this.mDoneBtn.addActionListener(e -> {
            if (this.mStep.isValid()) {
                this.mDataObject = this.mStep.createDataObject(this.mDataObject);
                this.close(2);
            }
        });
        this.mCancelBtn.addActionListener(e -> this.close());
        this.mNextBtn.addActionListener(e -> {
            if (this.mStep.isValid()) {
                this.mDataObject = this.mStep.createDataObject(this.mDataObject);
                this.switchToStep(this.mStep.next());
            }
        });
        this.mBackBtn.addActionListener(e -> this.switchToStep(this.mStep.back()));
        if (this.mNextBtn.isEnabled() && !this.mStep.isSingleStep()) {
            this.getRootPane().setDefaultButton(this.mNextBtn);
        } else {
            this.getRootPane().setDefaultButton(this.mDoneBtn);
        }
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WizardDlg.this.mBackBtn.isEnabled()) {
                    WizardDlg.this.mBackBtn.dispatchEvent(new KeyEvent(WizardDlg.this.mBackBtn, 401, 0L, 0, 32, ' '));
                    WizardDlg.this.mBackBtn.dispatchEvent(new KeyEvent(WizardDlg.this.mBackBtn, 402, 0L, 0, 32, ' '));
                }
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(8, 0);
        this.getRootPane().getInputMap(2).put(stroke, "BACK");
        this.getRootPane().getActionMap().put("BACK", a);
        stroke = KeyStroke.getKeyStroke(8, 512);
        this.getRootPane().getInputMap(2).put(stroke, "BACK");
        this.getRootPane().getActionMap().put("BACK", a);
        return panel;
    }

    private void switchToStep(WizardStep step) {
        this.mStep = step;
        this.setTitle(step.getTitle());
        this.getContentPane().removeAll();
        CellConstraints cc = new CellConstraints();
        this.mCurrentContentPanel = this.mStep.getContent(this.mHandler);
        this.getContentPane().add((Component)this.mCurrentContentPanel, cc.xy(1, 1));
        this.mCurrentContentPanel.validate();
        this.mCurrentContentPanel.repaint();
        this.mButtonPanel = this.createButtonPanel(step.getButtons());
        this.getContentPane().add((Component)this.mButtonPanel, cc.xy(1, 3));
        this.getContentPane().validate();
        ((JPanel)this.getContentPane()).repaint();
        if (((JPanel)this.getContentPane()).getPreferredSize().height > this.getHeight()) {
            this.setSize(this.getWidth(), ((JPanel)this.getContentPane()).getPreferredSize().height + Sizes.dialogUnitYAsPixel((int)30, (Component)this));
        }
        this.mCurrentContentPanel.requestFocusInWindow();
    }

    public int getResult() {
        return this.mResult;
    }

    public Object getDataObject() {
        return this.mDataObject;
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    public void finish() {
        this.mDataObject = this.mStep.createDataObject(this.mDataObject);
        this.close(2);
    }

    public void close(int val) {
        this.mResult = val;
        this.close();
    }

    public void allowNext(boolean allow) {
        this.mNextBtn.setEnabled(allow);
        if (allow && !this.mStep.isSingleStep()) {
            this.getRootPane().setDefaultButton(this.mNextBtn);
        } else {
            this.getRootPane().setDefaultButton(this.mDoneBtn);
        }
    }

    public void allowFinish(boolean allow) {
        this.mDoneBtn.setEnabled(allow);
    }

    public void allowBack(boolean allow) {
        this.mBackBtn.setEnabled(allow);
    }

    public void allowCancel(boolean allow) {
        this.mCancelBtn.setEnabled(allow);
    }

    public void setDoneBtnText() {
        this.mDoneBtn.setText(this.mStep.getDoneBtnText());
    }

    public void focusFinish() {
        this.mDoneBtn.requestFocusInWindow();
    }
}

