/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Date;
import devplugin.Program;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import tvbrowser.core.Settings;
import tvbrowser.extras.reminderplugin.RemindValue;
import tvbrowser.extras.reminderplugin.ReminderConstants;
import tvbrowser.extras.reminderplugin.ReminderFrame;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.ProgramPanel;
import util.ui.ScrollableJPanel;
import util.ui.UiUtilities;

public class PanelReminder
extends ScrollableJPanel {
    private ReminderListItem mItem;
    private JLabel mHeader;
    private JLabel mCommentLabel;
    private ProgramPanel mProgramPanel;
    private JComboBox<RemindValue> mReminderCB;
    private JButton mCloseBt;
    private String mCloseBtText;
    private Timer mAutoCloseTimer;
    private int mRemainingSecs;
    private int mRemainingMinutes;
    private InterfaceClose<PanelReminder> mCloseInterface;
    private int mRunningMinutes;
    private int mOriginalMinutes;
    private final FormLayout mLayout;
    private final JPanel mContentPanel;
    private long mAutoCloseAtMillis;
    private int mLastUpdateMinute;

    public PanelReminder(ReminderListItem reminderListItem, InterfaceClose<PanelReminder> closeInterface) {
        int i;
        this.mItem = reminderListItem;
        this.mCloseInterface = closeInterface;
        this.mRemainingMinutes = 0;
        this.mCloseBtText = Localizer.getLocalization("i18n_close");
        this.mOriginalMinutes = reminderListItem.getMinutes();
        Program program = this.mItem.getProgram();
        this.mLayout = new FormLayout("5dlu,default:grow,20dlu,default,5dlu", "5dlu,default,default,5dlu,default,5dlu,default");
        this.mContentPanel = new JPanel((LayoutManager)this.mLayout){

            @Override
            protected void paintComponent(Graphics g) {
                Color c = g.getColor();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(c);
                super.paintComponent(g);
            }
        };
        this.setLayout((LayoutManager)new FormLayout("default:grow", "default"));
        this.add((Component)this.mContentPanel, CC.xy((int)1, (int)1));
        this.setOpaque(true);
        this.mContentPanel.setOpaque(false);
        new Thread("SHOW NEW REMINDER THREAD"){

            @Override
            public void run() {
                int opacity = 200;
                int count = 0;
                Color background = PanelReminder.this.mContentPanel.getBackground();
                while (opacity >= 0) {
                    PanelReminder.this.mContentPanel.setBackground(new Color(238, 118, 0, Math.max(0, opacity)));
                    if (count > 166) {
                        --opacity;
                    } else {
                        ++count;
                    }
                    try {
                        2.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                PanelReminder.this.mContentPanel.setBackground(background);
            }
        }.start();
        this.mHeader = new JLabel();
        this.mProgramPanel = new ProgramPanel(program, new ProgramPanelSettings(new PluginPictureSettings(0), false, 0, false, true, false));
        this.mProgramPanel.addPluginContextMenuMouseListener(ReminderPluginProxy.getInstance());
        this.mReminderCB = new JComboBox();
        int progMinutesAfterMidnight = program.getStartTime();
        int minutesAfterMidnight = IOUtilities.getMinutesAfterMidnight() + 1440 * program.getDate().getNumberOfDaysSince(Date.getCurrentDate());
        this.mRunningMinutes = 0;
        Date today = Date.getCurrentDate();
        String msg = null;
        if (program.isOnAir()) {
            this.mRunningMinutes = Math.max(this.mRunningMinutes, minutesAfterMidnight - progMinutesAfterMidnight);
        } else if (program.isExpired()) {
            this.mRunningMinutes = -1;
        }
        this.mRemainingSecs = ReminderConstants.getAutoCloseReminderTime(program);
        this.mAutoCloseAtMillis = System.currentTimeMillis() + (long)(1000 * this.mRemainingSecs);
        int seconds = this.mRemainingSecs;
        if (ReminderPlugin.getInstance().getSettings().isSet("showTimeCounter")) {
            seconds = 10;
        }
        this.mCloseBt = new JButton(this.getCloseButtonText(seconds));
        this.mCloseBt.setToolTipText(ReminderPlugin.LOCALIZER.msg("closeHint", "<html><b>Ctrl+Esc:</b> Close first Reminder and use selected value<br><b>Shift+Esc:</b> Close first Reminder and reschedule at next possible time<html>"));
        this.mCloseBt.addActionListener(e -> closeInterface.close(this));
        if (today.compareTo(program.getDate()) >= 0 && minutesAfterMidnight > progMinutesAfterMidnight) {
            msg = this.updateRunningTime();
        } else {
            msg = ReminderFrame.LOCALIZER.msg("soonStarts", "Soon starts");
            this.mRemainingMinutes = ReminderPlugin.getTimeToProgramStart(program);
        }
        if (msg != null) {
            this.mHeader.setText(msg);
        }
        this.updateCloseBtText();
        this.mAutoCloseTimer = new Timer(1000, e -> this.handleTimerEvent());
        this.mAutoCloseTimer.start();
        JPanel channelPanel = new JPanel((LayoutManager)new FormLayout("50dlu:grow,5dlu,default", "fill:0dlu:grow,default,default,default,fill:0dlu:grow"));
        channelPanel.add((Component)this.mProgramPanel, CC.xywh((int)1, (int)1, (int)1, (int)5));
        channelPanel.setOpaque(false);
        if (program.getLength() > 0) {
            JLabel endTime = new JLabel(ReminderFrame.LOCALIZER.msg("endTime", "until {0}", program.getEndTimeString()));
            channelPanel.add((Component)endTime, CC.xy((int)3, (int)2));
        }
        Object sortNumber = "";
        if (Settings.IconAndNames.SHOW_SORT_NUMBER_IN_PROGRAM_LISTS.getBoolean() && program.getChannel().getSortNumber().trim().length() > 0) {
            sortNumber = program.getChannel().getSortNumber() + ". ";
        }
        String channelName = (String)sortNumber + program.getChannel().getName();
        JLabel channelLabel = new JLabel();
        channelLabel.setToolTipText(channelName);
        channelLabel.setIcon(UiUtilities.createChannelIcon(program.getChannel().getIcon()));
        channelLabel.setHorizontalTextPosition(4);
        channelPanel.add((Component)channelLabel, CC.xy((int)3, (int)3));
        channelLabel = new JLabel(channelName);
        channelPanel.add((Component)channelLabel, CC.xy((int)3, (int)4));
        this.mContentPanel.add((Component)this.mHeader, CC.xyw((int)2, (int)2, (int)3));
        this.mContentPanel.add((Component)channelPanel, CC.xyw((int)2, (int)3, (int)3));
        int y = this.addComment(5);
        this.mContentPanel.add(this.mReminderCB, CC.xy((int)2, (int)y));
        this.mContentPanel.add((Component)this.mCloseBt, CC.xy((int)4, (int)y++));
        this.mContentPanel.add((Component)new JSeparator(0), CC.xyw((int)1, (int)(++y), (int)5));
        for (i = 0; i < ReminderConstants.REMIND_AFTER_VALUE_ARR.length && this.mRunningMinutes - Math.abs(ReminderConstants.REMIND_AFTER_VALUE_ARR[i].getMinutes()) < 0; ++i) {
            if (this.mRunningMinutes < 0 || Math.abs(ReminderConstants.REMIND_AFTER_VALUE_ARR[i].getMinutes()) >= program.getLength()) continue;
            this.mReminderCB.addItem(ReminderConstants.REMIND_AFTER_VALUE_ARR[i]);
        }
        this.mReminderCB.addItem(ReminderConstants.DONT_REMIND_AGAIN_VALUE);
        this.mReminderCB.setSelectedItem(ReminderConstants.DONT_REMIND_AGAIN_VALUE);
        i = 0;
        while (i < ReminderConstants.REMIND_BEFORE_VALUE_ARR.length && ReminderConstants.REMIND_BEFORE_VALUE_ARR[i].getMinutes() < this.mRemainingMinutes) {
            this.mReminderCB.addItem(ReminderConstants.REMIND_BEFORE_VALUE_ARR[i++]);
        }
        this.mReminderCB.setVisible(this.mReminderCB.getItemCount() > 1);
        this.updateRunningTime();
    }

    private int addComment(int y) {
        String comment = this.mItem.getComment();
        if (comment != null && comment.length() > 0) {
            if (this.mCommentLabel == null) {
                this.mLayout.insertRow(y - 1, RowSpec.decode((String)"default"));
                this.mLayout.insertRow(y - 1, RowSpec.decode((String)"2dlu"));
                this.mCommentLabel = new JLabel(comment);
                this.mContentPanel.add((Component)this.mCommentLabel, CC.xyw((int)2, (int)y, (int)3));
                y += 2;
            } else {
                this.mCommentLabel.setText(comment);
            }
        } else if (this.mCommentLabel != null) {
            this.mContentPanel.remove(this.mCommentLabel);
            this.mLayout.removeRow(5);
            this.mLayout.removeRow(4);
            this.mCommentLabel = null;
        }
        return y;
    }

    private void handleTimerEvent() {
        this.mRemainingSecs = Math.max(0, (int)(this.mAutoCloseAtMillis - System.currentTimeMillis()) / 1000);
        if (this.mRemainingSecs <= 0) {
            if (!ReminderPlugin.getInstance().getSettings().isAutoCloseNever()) {
                this.mCloseInterface.close(this);
            } else {
                this.stopTimer();
                this.updateRunningTime();
            }
        } else {
            this.updateCloseBtText();
            this.updateRunningTime();
        }
        if (this.mReminderCB.getItemCount() > 1 && this.mLastUpdateMinute != IOUtilities.getMinutesAfterMidnight()) {
            this.mLastUpdateMinute = IOUtilities.getMinutesAfterMidnight();
            int diff = this.mLastUpdateMinute - (this.mItem.getProgram().getStartTime() + 1440 * this.mItem.getProgram().getDate().getNumberOfDaysSince(Date.getCurrentDate()));
            this.mRemainingMinutes = !this.mItem.getProgram().isOnAir() && !this.mItem.getProgram().isExpired() ? ReminderPlugin.getTimeToProgramStart(this.mItem.getProgram()) : 0;
            int selectedIndex = this.mReminderCB.getSelectedIndex();
            RemindValue selectedValue = (RemindValue)this.mReminderCB.getSelectedItem();
            for (int i = this.mReminderCB.getItemCount() - 1; i >= 0; --i) {
                RemindValue test = this.mReminderCB.getItemAt(i);
                if (test.getMinutes() == -31 || (test.getMinutes() < 0 || this.mRemainingMinutes > test.getMinutes()) && diff < Math.abs(test.getMinutes())) continue;
                if (selectedValue != null && test.equals(selectedValue)) {
                    selectedValue = null;
                }
                this.mReminderCB.removeItemAt(i);
            }
            if (selectedValue == null) {
                this.mReminderCB.setSelectedIndex(Math.min(selectedIndex, this.mReminderCB.getItemCount() - 1));
            }
            if (this.mReminderCB.getItemCount() == 1) {
                this.mReminderCB.setVisible(false);
            }
        }
    }

    private void updateCloseBtText() {
        if (this.mRemainingSecs <= 10 || ReminderPlugin.getInstance().getSettings().isSet("showTimeCounter")) {
            this.mCloseBt.setText(this.getCloseButtonText(this.mRemainingSecs));
        }
    }

    private String getCloseButtonText(int seconds) {
        StringBuilder builder = new StringBuilder(this.mCloseBtText);
        if (!ReminderPlugin.getInstance().getSettings().isAutoCloseNever() && (this.mRemainingSecs <= 10 || ReminderPlugin.getInstance().getSettings().isSet("showTimeCounter"))) {
            builder.append(" (");
            if (seconds <= 60) {
                builder.append(seconds);
            } else {
                int minutes;
                if (seconds >= 3600) {
                    int hours = seconds / 3600;
                    builder.append(hours).append(":");
                    seconds -= 3600 * hours;
                }
                if ((minutes = seconds / 60) < 10 && minutes > -10) {
                    builder.append("0");
                }
                builder.append(minutes).append(":");
                if ((seconds -= 60 * minutes) < 10 && seconds > -10) {
                    builder.append("0");
                }
                builder.append(seconds);
            }
            builder.append(")");
        }
        return builder.toString();
    }

    private String updateRunningTime() {
        String msg = null;
        ReminderListItem reminder = this.mItem;
        Program program = reminder.getProgram();
        if (program.isOnAir()) {
            int progMinutesAfterMidnight = program.getHours() * 60 + program.getMinutes();
            int minutesRunning = IOUtilities.getMinutesAfterMidnight() - progMinutesAfterMidnight;
            if (minutesRunning < 0) {
                minutesRunning += 1440;
            }
            msg = minutesRunning == 0 ? ReminderFrame.LOCALIZER.msg("alreadyRunning", "Just started") : (minutesRunning == 1 ? ReminderFrame.LOCALIZER.msg("alreadyRunningMinute", "Already running {0} minute", minutesRunning) : ReminderFrame.LOCALIZER.msg("alreadyRunningMinutes", "Already running {0} minutes", minutesRunning));
        } else {
            msg = program.isExpired() ? ReminderFrame.LOCALIZER.msg("ended", "Program elapsed") : ReminderFrame.LOCALIZER.msg("soonStarts", "Soon starts");
        }
        if (this.mHeader != null) {
            this.mHeader.setText(msg);
        }
        return msg;
    }

    public ReminderListItem getItem() {
        return this.mItem;
    }

    public int getNextReminderTime(boolean ignoreNoReminderIfSelected) {
        int minutes = ((RemindValue)this.mReminderCB.getSelectedItem()).getMinutes();
        if (ignoreNoReminderIfSelected && minutes == -31) {
            for (int i = this.mReminderCB.getItemCount() - 1; i >= 0; --i) {
                if (this.mReminderCB.getItemAt(i).getMinutes() == -31) continue;
                minutes = this.mReminderCB.getItemAt(i).getMinutes();
                break;
            }
        }
        return minutes;
    }

    public void stopTimer() {
        if (this.mAutoCloseTimer != null && this.mAutoCloseTimer.isRunning()) {
            this.mAutoCloseTimer.stop();
        }
    }

    public boolean update() {
        boolean result = false;
        if (this.mOriginalMinutes != this.mItem.getMinutes()) {
            for (int i = 0; i < this.mReminderCB.getItemCount(); ++i) {
                RemindValue value = this.mReminderCB.getItemAt(i);
                if (value.getMinutes() != this.mItem.getMinutes()) continue;
                this.mReminderCB.setSelectedItem(value);
                break;
            }
            result = true;
        } else {
            this.addComment(5);
            this.repaint();
            this.revalidate();
        }
        return result;
    }

    public boolean containsItem(ReminderListItem item) {
        return this.mItem.equals(item);
    }

    public Program getProgram() {
        return this.mProgramPanel.getProgram();
    }

    public void setProgram(Program program) {
        if (program != this.mProgramPanel.getProgram()) {
            this.mProgramPanel.setProgram(program);
        }
    }

    public static interface InterfaceClose<T> {
        public void close(T var1);
    }
}

