/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.searchplugin;

import devplugin.ActionMenu;
import devplugin.ButtonAction;
import devplugin.Channel;
import devplugin.ContextMenuAction;
import devplugin.Program;
import devplugin.SettingsTab;
import devplugin.ThemeIcon;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import tvbrowser.core.settings.PluginSettings;
import tvbrowser.extras.searchplugin.RepetitionDialog;
import tvbrowser.extras.searchplugin.SearchDialog;
import tvbrowser.extras.searchplugin.SearchPluginProxy;
import tvbrowser.extras.searchplugin.SearchSettingsTab;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.SearchFormSettings;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class SearchPlugin {
    protected static final Localizer mLocalizer = Localizer.getLocalizerFor(SearchPlugin.class);
    private static final String DATAFILE_PREFIX = "searchplugin.SearchPlugin";
    private static SearchPlugin mInstance;
    private static SearchFormSettings[] mSearchHistory;
    private int mRepetitionTimeSelect = 3;
    private static boolean mAlwaysSearchExpert;
    private static KeyStroke STROKE_SEARCH_DIALOG;

    private SearchPlugin() {
        mAlwaysSearchExpert = false;
    }

    static KeyStroke getKeyStroke() {
        if (STROKE_SEARCH_DIALOG == null) {
            STROKE_SEARCH_DIALOG = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        }
        return STROKE_SEARCH_DIALOG;
    }

    void readData(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        int historySize = in.readInt();
        mSearchHistory = new SearchFormSettings[historySize];
        for (int i = 0; i < historySize; ++i) {
            SearchFormSettings settings;
            if (version > 1) {
                settings = new SearchFormSettings(in);
            } else {
                String searchText = (String)in.readObject();
                in.readBoolean();
                boolean searchInInfoText = in.readBoolean();
                boolean caseSensitive = in.readBoolean();
                int option = in.readInt();
                settings = new SearchFormSettings(searchText);
                if (searchInInfoText) {
                    settings.setSearchIn(2);
                } else {
                    settings.setSearchIn(1);
                }
                settings.setCaseSensitive(caseSensitive);
                switch (option) {
                    case 1: {
                        settings.setSearcherType(2);
                        break;
                    }
                    case 2: {
                        settings.setSearcherType(3);
                        break;
                    }
                    default: {
                        settings.setSearcherType(1);
                    }
                }
            }
            SearchPlugin.mSearchHistory[i] = settings;
        }
        if (version >= 3 && version <= 4) {
            in.readInt();
            in.readInt();
            in.readInt();
            in.readInt();
            in.readBoolean();
            int n = in.readInt();
            for (int i = 0; i < n; ++i) {
                in.readUTF();
            }
        }
        if (version >= 4) {
            this.mRepetitionTimeSelect = in.readInt();
        }
        if (version >= 6) {
            mAlwaysSearchExpert = in.readBoolean();
        }
    }

    void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(6);
        if (mSearchHistory == null) {
            out.writeInt(0);
        } else {
            out.writeInt(mSearchHistory.length);
            for (SearchFormSettings element : mSearchHistory) {
                element.writeData(out);
            }
        }
        out.writeInt(this.mRepetitionTimeSelect);
        out.writeBoolean(mAlwaysSearchExpert);
    }

    protected static ActionMenu getButtonAction() {
        ButtonAction action = new ButtonAction();
        action.setActionListener(e -> SearchPlugin.getInstance().openSearchDialog(""));
        action.setBigIcon(TVBrowserIcons.search(22));
        action.setSmallIcon(TVBrowserIcons.search(16));
        action.setShortDescription(mLocalizer.msg("description", "Allows searching programs containing a certain text."));
        action.setText(mLocalizer.ellipsisMsg("searchPrograms", "Search programs"));
        action.putValue("####KEYBOARD_ACCELERATOR####", SearchPlugin.getKeyStroke());
        return new ActionMenu(action);
    }

    protected static ActionMenu getContextMenuActions(Program program) {
        ContextMenuAction action = new ContextMenuAction();
        action.setText(mLocalizer.msg("searchRepetion", "Search repetition"));
        action.setSmallIcon(TVBrowserIcons.search(16));
        action.setActionListener(e -> SearchPlugin.searchRepetitions(program));
        return new ActionMenu(action);
    }

    public ThemeIcon getMarkIconFromTheme() {
        return new ThemeIcon("actions", "system-search", 16);
    }

    public static synchronized SearchPlugin getInstance() {
        if (mInstance == null) {
            mInstance = new SearchPlugin();
        }
        return mInstance;
    }

    protected static SearchFormSettings[] getSearchHistory() {
        return mSearchHistory;
    }

    protected static void setSearchHistory(SearchFormSettings[] history) {
        mSearchHistory = history;
    }

    public SettingsTab getSettingsTab() {
        return new SearchSettingsTab();
    }

    public static String getSearchPluginId() {
        return DATAFILE_PREFIX;
    }

    public String toString() {
        return SearchPlugin.getName();
    }

    static String getName() {
        return mLocalizer.msg("title", "Search");
    }

    public int getRepetitionTimeSelection() {
        return this.mRepetitionTimeSelect;
    }

    public void setRepetitionTimeSelection(int selectedIndex) {
        this.mRepetitionTimeSelect = selectedIndex;
    }

    public void openSearchDialog(String text, SearchFormSettings settings, boolean start) {
        Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        SearchDialog dlg = new SearchDialog(parent);
        if (settings != null) {
            dlg.setSearchSettings(settings);
        }
        dlg.setSearchText(text);
        if (start) {
            SwingUtilities.invokeLater(() -> dlg.search());
        } else {
            dlg.setVisible(true);
        }
    }

    protected void openSearchDialog(String text) {
        this.openSearchDialog(text, null, false);
    }

    private static void searchRepetitions(Program program) {
        try {
            if (mAlwaysSearchExpert) {
                SearchPlugin.getInstance().openSearchDialog(program.getTitle());
            } else {
                Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
                Channel channel = program.getChannel();
                RepetitionDialog dlg = new RepetitionDialog(parent, channel);
                dlg.setPatternText(program.getTitle());
                dlg.setVisible(true);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean getAlwaysSearchExpert() {
        return mAlwaysSearchExpert;
    }

    public static void setAlwaysSearchExpert(boolean value) {
        mAlwaysSearchExpert = value;
        PluginSettings.storeSettings(SearchPluginProxy.getInstance());
    }
}

