/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import devplugin.Channel;
import devplugin.PluginsProgramFilter;
import devplugin.ProgramFilter;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.InfoBitFilter;
import tvbrowser.core.filters.ParserException;
import tvbrowser.core.filters.PluginFilter;
import tvbrowser.core.filters.SeparatorFilter;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.core.filters.SingleChannelFilter;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.FavoriteFilter;
import tvbrowser.ui.mainframe.MainFrame;
import util.ui.ScrollableMenu;

public class FilterNode
extends DefaultMutableTreeNode {
    private static final String FAVORITE_FILTER_KEY = "FAVORITE_FILTER###";
    private static final String PLUGIN_FILTER_KEY = "PLUGIN_FILTER###";
    private static final String INFOBIT_FILTER_KEY = "INFOBIT_FILTER###";
    private static final String SINGLE_CHANNEL_FILTER_KEY = "SINGLE_CHANNEL_FILTER###";
    private boolean mWasExpanded;

    public FilterNode(Object userObject) {
        if (userObject instanceof ProgramFilter) {
            this.setAllowsChildren(false);
        }
        this.userObject = userObject;
    }

    protected FilterNode(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        try {
            if (in.readBoolean()) {
                int n = in.readInt();
                this.setUserObject(in.readUTF());
                this.mWasExpanded = in.readBoolean();
                boolean lastWasSeparator = false;
                for (int i = 0; i < n; ++i) {
                    FilterNode node = new FilterNode(in, version);
                    if (node.getUserObject() == null || lastWasSeparator && node.getUserObject() instanceof SeparatorFilter) continue;
                    this.add(node);
                    lastWasSeparator = node.getUserObject() instanceof SeparatorFilter;
                }
            } else {
                this.setAllowsChildren(false);
                String name = in.readUTF();
                if (name.equals("[SHOW_ALL_FITLER]")) {
                    this.userObject = new ShowAllFilter();
                } else if (name.equals("[SHOW_MARKED_PROGRAMS]")) {
                    this.userObject = new PluginFilter();
                } else if (name.equals("[SUBTITLE_FILTER]") || name.equals("[AUDIO_DESCRIPTION_FILTER]")) {
                    this.userObject = new InfoBitFilter(name);
                } else if (name.equals("[SEPARATOR]")) {
                    this.userObject = new SeparatorFilter();
                } else if (name.startsWith(INFOBIT_FILTER_KEY)) {
                    String infobitKey = name.substring(INFOBIT_FILTER_KEY.length());
                    this.userObject = new InfoBitFilter(infobitKey);
                } else if (name.startsWith(PLUGIN_FILTER_KEY)) {
                    String pluginKey = name.substring(PLUGIN_FILTER_KEY.length());
                    this.userObject = pluginKey;
                    this.setAllowsChildren(false);
                } else if (name.startsWith(FAVORITE_FILTER_KEY)) {
                    String filterKey = name.substring(FAVORITE_FILTER_KEY.length());
                    this.userObject = FavoritesPlugin.getInstance().getFilterForKeyValue(filterKey);
                } else if (name.startsWith(SINGLE_CHANNEL_FILTER_KEY)) {
                    SingleChannelFilter filter = new SingleChannelFilter(Channel.readData(in, true));
                    if (filter.isValidChannel()) {
                        this.userObject = filter;
                    }
                } else {
                    File userFilterFile = new File(FilterList.getFilterDirectory(), name + ".filter");
                    if (userFilterFile.isFile()) {
                        try {
                            this.userObject = new UserFilter(userFilterFile);
                        }
                        catch (ParserException parserException) {
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean isValidFilter() {
        return (!(this.userObject instanceof PluginsProgramFilter) || ((PluginsProgramFilter)this.userObject).getPluginAccessOfFilter() != null) && this.userObject != null;
    }

    public void store(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.isDirectoryNode());
        if (this.isDirectoryNode()) {
            ArrayList<FilterNode> filterNodeList = new ArrayList<FilterNode>();
            for (int i = 0; i < this.getChildCount(); ++i) {
                FilterNode test = (FilterNode)this.getChildAt(i);
                if (!test.isValidFilter()) continue;
                filterNodeList.add(test);
            }
            out.writeInt(filterNodeList.size());
            out.writeUTF(this.userObject.toString());
            out.writeBoolean(this.mWasExpanded);
            for (FilterNode node : filterNodeList) {
                node.store(out);
            }
        } else if (this.userObject instanceof ShowAllFilter) {
            out.writeUTF("[SHOW_ALL_FITLER]");
        } else if (this.userObject instanceof PluginFilter) {
            out.writeUTF("[SHOW_MARKED_PROGRAMS]");
        } else if (this.userObject instanceof SeparatorFilter) {
            out.writeUTF("[SEPARATOR]");
        } else if (this.userObject instanceof UserFilter) {
            UserFilter filter = (UserFilter)this.userObject;
            out.writeUTF(filter.getName());
            filter.store();
        } else if (this.userObject instanceof PluginsProgramFilter) {
            out.writeUTF(PLUGIN_FILTER_KEY + ((PluginsProgramFilter)this.userObject).getName());
        } else if (this.userObject instanceof InfoBitFilter) {
            out.writeUTF(INFOBIT_FILTER_KEY + ((InfoBitFilter)this.userObject).getKey());
        } else if (this.userObject instanceof FavoriteFilter) {
            out.writeUTF(FAVORITE_FILTER_KEY + ((FavoriteFilter)this.userObject).getKeyValue());
        } else if (this.userObject instanceof SingleChannelFilter) {
            ((SingleChannelFilter)this.userObject).store(SINGLE_CHANNEL_FILTER_KEY, out);
        }
    }

    @Override
    public String toString() {
        if (this.userObject instanceof String) {
            return this.userObject.toString();
        }
        if (this.userObject != null) {
            return ((ProgramFilter)this.userObject).getName();
        }
        return "NULL";
    }

    public boolean containsSeparator() {
        return this.userObject instanceof SeparatorFilter;
    }

    public boolean containsFilter() {
        return this.userObject instanceof ProgramFilter && !this.containsSeparator();
    }

    public boolean isDirectoryNode() {
        return this.userObject instanceof String;
    }

    public ProgramFilter getFilter() {
        if (this.containsFilter() || this.containsSeparator()) {
            return (ProgramFilter)this.userObject;
        }
        return null;
    }

    protected boolean wasExpanded() {
        return this.mWasExpanded || this.isRoot();
    }

    protected void setWasExpanded(boolean expanded) {
        this.mWasExpanded = expanded;
    }

    public FilterNode addFilter(ProgramFilter filter) {
        if (this.allowsChildren) {
            FilterNode childNode = new FilterNode(filter);
            super.add(childNode);
            return childNode;
        }
        return null;
    }

    public FilterNode addDirectory(String value) {
        if (this.allowsChildren) {
            FilterNode childNode = new FilterNode(value);
            super.add(childNode);
            return childNode;
        }
        return null;
    }

    public boolean contains(Object o) {
        if (o instanceof SeparatorFilter) {
            return this.containsSeparator() && this.userObject == o;
        }
        if (o instanceof ProgramFilter) {
            return this.containsFilter() && this.userObject == o;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof SeparatorFilter) {
            return this.containsSeparator() && this.userObject == o;
        }
        if (o instanceof ProgramFilter) {
            return this.containsFilter() && this.userObject == o;
        }
        return this == o;
    }

    public ProgramFilter[] getAllFilters() {
        try {
            if (this.isDirectoryNode()) {
                ProgramFilter[] filters = new ProgramFilter[]{};
                for (int i = 0; i < this.getChildCount(); ++i) {
                    ProgramFilter[] filter = ((FilterNode)this.getChildAt(i)).getAllFilters();
                    if (filter == null || filter.length <= 0) continue;
                    ProgramFilter[] newArr = new ProgramFilter[filters.length + filter.length];
                    System.arraycopy(filters, 0, newArr, 0, filters.length);
                    System.arraycopy(filter, 0, newArr, filters.length, filter.length);
                    filters = newArr;
                }
                return filters;
            }
            return new ProgramFilter[]{this.getFilter()};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDeletingAllowed() {
        return this.isDeletingAllowed(false);
    }

    public boolean isDeletingAllowed(boolean pluginCausedDeleting) {
        return !(this.userObject instanceof ShowAllFilter) && !(this.userObject instanceof PluginFilter) && (pluginCausedDeleting || !(this.userObject instanceof PluginsProgramFilter)) && !(this.userObject instanceof InfoBitFilter) && !(this.userObject instanceof SingleChannelFilter) && this.getChildCount() <= 0;
    }

    public boolean isUserDeletingAllowed() {
        return this.isDeletingAllowed() && !(this.userObject instanceof FavoriteFilter);
    }

    public boolean testAndSetToPluginsProgramFilter(PluginsProgramFilter filter) {
        boolean returnValue = false;
        if (this.allowsChildren) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                returnValue = returnValue || ((FilterNode)this.getChildAt(i)).testAndSetToPluginsProgramFilter(filter);
            }
        }
        if (filter != null && this.userObject instanceof String && this.toString().equals(filter.getName())) {
            this.userObject = filter;
            return true;
        }
        return returnValue;
    }

    public void createMenu(JMenu menu, ProgramFilter curFilter) {
        ButtonGroup group = new ButtonGroup();
        this.createMenuInternal(this, menu, group, curFilter);
    }

    private void createMenuInternal(FilterNode node, JMenu parent, ButtonGroup group, ProgramFilter curFilter) {
        if (this.allowsChildren) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                FilterNode test = (FilterNode)this.getChildAt(i);
                if (test.isDirectoryNode() && !test.isLeaf()) {
                    ScrollableMenu dir = new ScrollableMenu(test.getUserObject().toString());
                    parent.add(dir);
                    test.createMenuInternal(test, dir, group, curFilter);
                    continue;
                }
                if (test.containsFilter()) {
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(test.toString());
                    group.add(item);
                    item.addActionListener(e -> {
                        MainFrame.getInstance().setProgramFilter(test.getFilter());
                        item.setSelected(true);
                    });
                    parent.add(item);
                    if (curFilter != null && curFilter.getName().equals(test.getFilter().getName())) {
                        item.setSelected(true);
                    } else if (curFilter == null && test.getFilter() instanceof ShowAllFilter) {
                        item.setSelected(true);
                    }
                    String id = test.getFilter().getClass().getName();
                    String name = test.getFilter().getName();
                    if (Settings.General.FILTER_DEFAULT.getString().equals(id + "###" + name) || Settings.General.FILTER_DEFAULT.getString().trim().length() < 1 && test.getFilter() instanceof ShowAllFilter) {
                        item.setFont(item.getFont().deriveFont(1));
                    }
                    if (Settings.Markings.HIGHLIGHTING_FILTERS.containsKey(name)) {
                        item.setFont(item.getFont().deriveFont(item.getFont().getStyle() | 2));
                    }
                    if (!(test.getFilter() instanceof UserFilter)) continue;
                    item.setText(((UserFilter)test.getFilter()).getViewString());
                    continue;
                }
                if (!test.containsSeparator()) continue;
                parent.addSeparator();
            }
        }
    }
}

