/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import devplugin.Channel;
import devplugin.FilterChangeListenerV2;
import devplugin.PluginAccess;
import devplugin.PluginsProgramFilter;
import devplugin.ProgramFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.filters.ParserException;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.core.filters.SingleChannelFilter;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.ui.filter.dlgs.FilterNode;
import tvbrowser.ui.filter.dlgs.FilterTree;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.UiUtilities;

public class FilterTreeModel
extends DefaultTreeModel {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(FilterTreeModel.class);
    private static FilterTreeModel INSTANCE;
    private static ArrayList<FilterChangeListenerV2> CHANGE_LISTENER_LISTV2;

    public FilterTreeModel(TreeNode root) {
        super(root, true);
        CHANGE_LISTENER_LISTV2 = new ArrayList(0);
    }

    public static FilterTreeModel initInstance(ProgramFilter[] filterArr) {
        FilterNode rootNode = new FilterNode("");
        FilterTreeModel.fixRootNode(rootNode);
        for (ProgramFilter filter : filterArr) {
            rootNode.addFilter(filter);
        }
        INSTANCE = new FilterTreeModel(rootNode);
        return INSTANCE;
    }

    public static FilterTreeModel initInstance(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        FilterNode rootNode = new FilterNode(in, version);
        FilterTreeModel.fixRootNode(rootNode);
        INSTANCE = new FilterTreeModel(rootNode);
        return INSTANCE;
    }

    public void storeData(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        ((FilterNode)this.getRoot()).store(out);
    }

    private static void fixRootNode(FilterNode rootNode) {
        String rootLabel = LOCALIZER.msg("rootLabel", "All filters");
        if (StringUtils.isEmpty((CharSequence)rootLabel)) {
            rootLabel = "FILTERS_ROOT";
        }
        rootNode.setUserObject(rootLabel);
    }

    public static FilterTreeModel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = FilterTreeModel.initInstance(new ProgramFilter[0]);
        }
        return INSTANCE;
    }

    @Override
    public boolean isLeaf(Object nodeObject) {
        if (nodeObject instanceof FilterNode) {
            FilterNode node = (FilterNode)nodeObject;
            return node.getChildCount() == 0;
        }
        return super.isLeaf(nodeObject);
    }

    public void deleteFilter(ProgramFilter filter, boolean pluginCaused) {
        this.deleteFilter((FilterNode)this.getRoot(), filter, pluginCaused);
    }

    private void deleteFilter(FilterNode node, ProgramFilter filter, boolean pluginCaused) {
        if (node.isDirectoryNode()) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode child = e.nextElement();
                if (!(child instanceof FilterNode)) continue;
                if (((FilterNode)child).isDirectoryNode()) {
                    this.deleteFilter((FilterNode)child, filter, pluginCaused);
                    continue;
                }
                if (!((FilterNode)child).containsFilter() && !((FilterNode)child).containsSeparator() || !((FilterNode)child).contains(filter) || !((FilterNode)child).isDeletingAllowed(pluginCaused)) continue;
                node.remove((FilterNode)child);
                this.fireFilterRemoved(filter);
            }
        }
    }

    public void addFilter(ProgramFilter filter) {
        if (filter != null) {
            this.addFilter(filter, (FilterNode)this.getRoot(), null);
            this.fireFilterAdded(filter);
        }
    }

    public FilterNode addFilter(ProgramFilter filter, FilterNode parent, FilterTree tree) {
        if (filter != null) {
            if (parent == null) {
                parent = (FilterNode)this.getRoot();
            }
            FilterNode newNode = parent.addFilter(filter);
            this.fireFilterAdded(filter);
            if (tree != null) {
                this.reload(tree, parent);
            } else {
                this.reload(this.root);
            }
            return newNode;
        }
        return null;
    }

    public FilterNode addDirectory(String name, FilterNode parent) {
        if (parent == null) {
            parent = (FilterNode)this.getRoot();
        }
        FilterNode newNode = parent.addDirectory(name);
        this.reload(parent);
        return newNode;
    }

    public ProgramFilter[] getAllFilters() {
        return ((FilterNode)this.getRoot()).getAllFilters();
    }

    public void updateAvailableChannels(Channel[] channels, String directoryName, String aboveDirectory) {
        ArrayList<Channel> channelsToAddList = new ArrayList<Channel>();
        channelsToAddList.addAll(Arrays.asList(channels));
        FilterNode root = (FilterNode)this.getRoot();
        LinkedList<FilterNode> list = new LinkedList<FilterNode>();
        list.push(root);
        do {
            FilterNode node;
            if ((node = (FilterNode)list.pop()).isDirectoryNode()) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    list.push((FilterNode)node.getChildAt(i));
                }
            } else {
                if (node.getUserObject() instanceof SingleChannelFilter) {
                    SingleChannelFilter filter = (SingleChannelFilter)node.getUserObject();
                    boolean channelFound = false;
                    for (Channel ch : channels) {
                        if (!filter.containsChannel(ch)) continue;
                        channelFound = true;
                        channelsToAddList.remove(ch);
                        break;
                    }
                    if (channelFound) continue;
                    ((FilterNode)node.getParent()).remove(node);
                    this.fireFilterRemoved(filter);
                    continue;
                }
                if (!(node.getUserObject() instanceof UserFilter)) continue;
                ((UserFilter)node.getUserObject()).updateSingleChannelFilters(channels);
            }
        } while (!list.isEmpty());
        FilterNode channelDirectory = this.getDirectoryNode(directoryName, (FilterNode)this.getRoot());
        if (channelDirectory == null) {
            FilterNode aboveNode = this.getDirectoryNode(aboveDirectory, (FilterNode)this.getRoot());
            int index = aboveNode == null ? 0 : aboveNode.getParent().getIndex(aboveNode);
            channelDirectory = new FilterNode(directoryName);
            ((FilterNode)this.getRoot()).insert(channelDirectory, index + 1);
        }
        for (Channel ch : channelsToAddList) {
            channelDirectory.addFilter(new SingleChannelFilter(ch));
        }
    }

    public void addPluginsProgramFilters() {
        PluginAccess[] plugins;
        for (PluginAccess plugin : plugins = PluginManagerImpl.getInstance().getActivatedPlugins()) {
            PluginsProgramFilter[] filters = plugin.getAvailableFilter();
            if (filters == null) continue;
            for (PluginsProgramFilter filter : filters) {
                if (((FilterNode)this.getRoot()).testAndSetToPluginsProgramFilter(filter)) continue;
                this.addFilter(filter);
            }
        }
    }

    public FilterNode getDirectoryNode(String name, FilterNode parent) {
        if (parent == null) {
            parent = (FilterNode)this.getRoot();
        }
        LinkedList<FilterNode> toSearch = new LinkedList<FilterNode>();
        toSearch.push(parent);
        do {
            FilterNode node;
            if (!(node = (FilterNode)toSearch.pop()).isDirectoryNode()) continue;
            if (node.toString().equals(name)) {
                return node;
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                FilterNode child = (FilterNode)node.getChildAt(i);
                if (!child.isDirectoryNode()) continue;
                toSearch.push(child);
            }
        } while (!toSearch.isEmpty());
        return null;
    }

    public void createMenu(JMenu menu, ProgramFilter curFilter) {
        ((FilterNode)this.getRoot()).createMenu(menu, curFilter);
    }

    public void reload(FilterTree tree, TreeNode node) {
        super.reload(node);
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            if (!(child instanceof FilterNode) || !((FilterNode)child).isDirectoryNode()) continue;
            this.reload(tree, child);
        }
        FilterNode parent = (FilterNode)node;
        if (parent.wasExpanded()) {
            tree.expandPath(new TreePath(tree.getModel().getPathToRoot(node)));
        } else {
            tree.collapsePath(new TreePath(tree.getModel().getPathToRoot(node)));
        }
    }

    void fireFilterAdded(ProgramFilter filter) {
        for (FilterChangeListenerV2 listener : CHANGE_LISTENER_LISTV2) {
            listener.filterAdded(filter);
        }
        if (this.isDefaultFilter(filter)) {
            this.fireFilterDefaultChanged(filter);
        }
    }

    void fireFilterRemoved(ProgramFilter filter) {
        for (FilterChangeListenerV2 listener : CHANGE_LISTENER_LISTV2) {
            listener.filterRemoved(filter);
        }
        if (this.isDefaultFilter(filter)) {
            Settings.General.FILTER_DEFAULT.resetToDefault();
            this.fireFilterDefaultChanged(FilterManagerImpl.getInstance().getAllFilter());
        }
    }

    public void fireFilterTouched(ProgramFilter filter) {
        this.fireFilterTouched(new ProgramFilter[]{filter});
    }

    void fireFilterTouched(ProgramFilter[] filters) {
        for (FilterChangeListenerV2 listener : CHANGE_LISTENER_LISTV2) {
            listener.filterTouched(filters);
        }
    }

    void fireFilterDefaultChanged(ProgramFilter filter) {
        for (FilterChangeListenerV2 listener : CHANGE_LISTENER_LISTV2) {
            listener.filterDefaultChanged(filter);
        }
    }

    public void updateFilterComponent(String oldName, FilterComponent filterComponent) {
        UserFilter[] userFilters = FilterList.getInstance().getUserFilterArr();
        ArrayList<UserFilter> touched = new ArrayList<UserFilter>();
        for (UserFilter filter : userFilters) {
            if (!filter.containsRuleComponent(filterComponent.getName()) && !filter.containsRuleComponent(oldName)) continue;
            touched.add(filter);
            if (!oldName.equals(filterComponent.getName())) {
                String[] parts = filter.getRule().split("\\s+");
                StringBuilder newRule = new StringBuilder();
                for (int i = 0; i < parts.length; ++i) {
                    if (parts[i].equals(oldName)) {
                        parts[i] = filterComponent.getName();
                    }
                    if (newRule.length() > 0) {
                        newRule.append(" ");
                    }
                    newRule.append(parts[i]);
                }
                try {
                    filter.setRule(newRule.toString());
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
            filter.store();
        }
        if (!touched.isEmpty()) {
            this.fireFilterTouched(touched.toArray(new ProgramFilter[touched.size()]));
        }
    }

    public void registerFilterChangeListener(FilterChangeListenerV2 listener) {
        CHANGE_LISTENER_LISTV2.add(listener);
    }

    public void unregisterFilterChangeListener(FilterChangeListenerV2 listener) {
        CHANGE_LISTENER_LISTV2.remove(listener);
    }

    private boolean isDefaultFilter(ProgramFilter filter) {
        String filterId = Settings.General.FILTER_DEFAULT.getString();
        String filterName = null;
        if (StringUtils.isNotEmpty((CharSequence)filterId) && filter != null) {
            String[] filterValues = filterId.split("###");
            filterId = this.shortFilterClassName(filterValues[0]);
            filterName = filterValues[1];
            return this.shortFilterClassName(filter.getClass().getName()).equals(filterId) && filter.getName().equals(filterName);
        }
        return filter instanceof ShowAllFilter;
    }

    private String shortFilterClassName(String className) {
        int index = className.lastIndexOf(36);
        if (index > 0) {
            return className.substring(0, index);
        }
        return className;
    }

    public void sort(FilterNode node, Comparator<TreeNode> comp, String title) {
        String msg = LOCALIZER.msg("reallySort", "Do you really want to sort '{0}'?\n\nThe current order will get lost.", node.toString());
        int result = JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), msg, title, 0);
        if (result == 0) {
            this.sortNodeInternal(node, comp);
        }
    }

    private void sortNodeInternal(FilterNode node, Comparator<TreeNode> comp) {
        ArrayList<TreeNode> childNodes = Collections.list(node.children());
        Collections.sort(childNodes, comp);
        node.removeAllChildren();
        for (TreeNode child : childNodes) {
            if (!(child instanceof FilterNode)) continue;
            node.add((FilterNode)child);
            if (!((FilterNode)child).isDirectoryNode()) continue;
            this.sortNodeInternal((FilterNode)child, comp);
        }
    }
}

