/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.PluginsProgramFilter;
import devplugin.ProgramFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.tree.TreePath;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.InfoBitFilter;
import tvbrowser.core.filters.ParserException;
import tvbrowser.core.filters.PluginFilter;
import tvbrowser.core.filters.SeparatorFilter;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.core.filters.SingleChannelFilter;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.favoritesplugin.core.FavoriteFilter;
import tvbrowser.ui.filter.dlgs.EditFilterDlg;
import tvbrowser.ui.filter.dlgs.FilterHighlightingSelectionPanel;
import tvbrowser.ui.filter.dlgs.FilterNode;
import tvbrowser.ui.filter.dlgs.FilterTree;
import tvbrowser.ui.filter.dlgs.Utilities;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class SelectFilterDlg
extends JDialog
implements ActionListener,
WindowClosingIf {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(SelectFilterDlg.class);
    private static SelectFilterDlg INSTANCE;
    private JButton mHelpBtn;
    private JButton mNewFolder;
    private JButton mCopyBtn;
    private JButton mEditBtn;
    private JButton mRemoveBtn;
    private JButton mNewBtn;
    private JButton mOkBtn;
    private JButton mUpBtn;
    private JButton mDownBtn;
    private JButton mSeperator;
    private JButton mDefaultFilterBtn;
    private JButton mSortAlphabetically;
    private FilterList mFilterList;
    private FilterTree mFilterTree;
    private ArrayList<ProgramFilter> mTouchedFilterList;

    public static SelectFilterDlg create(Window parent) {
        if (INSTANCE == null) {
            new SelectFilterDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()));
        }
        return INSTANCE;
    }

    static SelectFilterDlg getInstance() {
        return INSTANCE;
    }

    private SelectFilterDlg(Window parent) {
        super(parent, LOCALIZER.msg("title", "Edit Filters"), Dialog.ModalityType.DOCUMENT_MODAL);
        INSTANCE = this;
        this.mTouchedFilterList = new ArrayList();
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("default,default:grow,default"));
        pb.border(Borders.DIALOG);
        UiUtilities.registerForClosing(this);
        this.mFilterList = FilterList.getInstance();
        this.mFilterTree = new FilterTree();
        this.mNewBtn = UiUtilities.createToolBarButton(FilterTree.LOCALIZER.msg("newFilter", "New Filter"), TVBrowserIcons.newIcon(22));
        this.mNewFolder = UiUtilities.createToolBarButton(FilterTree.LOCALIZER.msg("newFolder", "New folder"), IconLoader.getInstance().getIconFromTheme("actions", "folder-new", 22));
        this.mCopyBtn = UiUtilities.createToolBarButton(Localizer.getEllipsisLocalization("i18n_copy"), TVBrowserIcons.copy(22));
        this.mEditBtn = UiUtilities.createToolBarButton(Localizer.getEllipsisLocalization("i18n_edit"), TVBrowserIcons.edit(22));
        this.mRemoveBtn = UiUtilities.createToolBarButton(Localizer.getLocalization("i18n_delete"), TVBrowserIcons.delete(22));
        this.mSeperator = UiUtilities.createToolBarButton(FilterTree.LOCALIZER.msg("newSeparator", "Add separator"), IconLoader.getInstance().getIconFromTheme("emblems", "separator", 22));
        this.mDefaultFilterBtn = UiUtilities.createToolBarButton(Localizer.getLocalization("i18n_standard"), IconLoader.getInstance().getIconFromTheme("actions", "view-filter", 22));
        this.mUpBtn = UiUtilities.createToolBarButton(LOCALIZER.msg("up", "Move selected value up"), TVBrowserIcons.up(22));
        this.mDownBtn = UiUtilities.createToolBarButton(LOCALIZER.msg("down", "Move selected value down"), TVBrowserIcons.down(22));
        this.mSortAlphabetically = UiUtilities.createToolBarButton(LOCALIZER.msg("sortAlphabetically", "Sort filters alphabetically"), IconLoader.getInstance().getIconFromTheme("actions", "sort-list", 22));
        JToolBar toolbarPn = new JToolBar();
        toolbarPn.setBorder(BorderFactory.createEmptyBorder());
        toolbarPn.setFloatable(false);
        toolbarPn.add(this.mNewFolder);
        this.addToolbarSeperator(toolbarPn);
        toolbarPn.add(this.mNewBtn);
        toolbarPn.add(this.mEditBtn);
        toolbarPn.add(this.mCopyBtn);
        toolbarPn.add(this.mSeperator);
        toolbarPn.add(this.mRemoveBtn);
        this.addToolbarSeperator(toolbarPn);
        toolbarPn.add(this.mDefaultFilterBtn);
        this.addToolbarSeperator(toolbarPn);
        toolbarPn.add(this.mUpBtn);
        toolbarPn.add(this.mDownBtn);
        toolbarPn.add(this.mSortAlphabetically);
        this.mNewBtn.addActionListener(this);
        this.mCopyBtn.addActionListener(this);
        this.mEditBtn.addActionListener(this);
        this.mRemoveBtn.addActionListener(this);
        this.mSeperator.addActionListener(this);
        this.mDefaultFilterBtn.addActionListener(this);
        this.mUpBtn.addActionListener(this);
        this.mDownBtn.addActionListener(this);
        this.mNewFolder.addActionListener(this);
        this.mSortAlphabetically.addActionListener(this);
        this.mHelpBtn = Utilities.createHelpButton();
        this.mOkBtn = new JButton(Localizer.getLocalization("i18n_close"));
        this.mOkBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.mOkBtn);
        pb.getLayout().setColumnGroups((int[][])new int[][]{{1, 3}});
        JScrollPane scrollPane = new JScrollPane(this.mFilterTree);
        pb.addRowFull(false, (Component)toolbarPn);
        pb.addRowFull("4dlu,fill:default:grow", (Component)scrollPane);
        pb.addRow(this.mHelpBtn, 1);
        pb.add(this.mOkBtn, 3);
        this.updateBtns();
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectFilterDlg.this.close();
            }
        });
        this.add((Component)pb.getPanel(), "Center");
        Settings.layoutWindow("selectFilterDlg", this, new Dimension(500, 500));
    }

    private void addToolbarSeperator(JToolBar toolbarPn) {
        JPanel p = new JPanel();
        p.setSize(10, 10);
        p.setMaximumSize(new Dimension(10, 10));
        toolbarPn.add(p);
        toolbarPn.addSeparator();
        p = new JPanel();
        p.setSize(4, 10);
        p.setMaximumSize(new Dimension(4, 10));
        toolbarPn.add(p);
    }

    public void updateBtns() {
        if (this.mFilterTree.getSelectionCount() > 0) {
            FilterNode node = (FilterNode)this.mFilterTree.getSelectionPath().getLastPathComponent();
            int row = this.mFilterTree.getRowForPath(this.mFilterTree.getSelectionPath());
            this.mUpBtn.setEnabled(row > 1);
            this.mDownBtn.setEnabled(row > 0 && row != this.mFilterTree.getRowCount() - 1);
            if (node.containsFilter()) {
                String id = node.getFilter().getClass().getName();
                String name = node.getFilter().getName();
                this.mDefaultFilterBtn.setEnabled(!Settings.General.FILTER_DEFAULT.getString().equals(id + "###" + name) && (Settings.General.FILTER_DEFAULT.getString().trim().length() >= 1 || !(node.getFilter() instanceof ShowAllFilter)));
                this.mEditBtn.setEnabled(!(node.getFilter() instanceof ShowAllFilter) && !(node.getFilter() instanceof PluginFilter));
                this.mCopyBtn.setEnabled(this.mEditBtn.isEnabled());
            } else {
                this.mEditBtn.setEnabled(row > 0 && node.isDirectoryNode());
                this.mCopyBtn.setEnabled(false);
                this.mDefaultFilterBtn.setEnabled(false);
            }
            this.mRemoveBtn.setEnabled(row > 0 && node.isUserDeletingAllowed());
        } else {
            this.mCopyBtn.setEnabled(false);
            this.mUpBtn.setEnabled(false);
            this.mDownBtn.setEnabled(false);
            this.mDefaultFilterBtn.setEnabled(false);
            this.mRemoveBtn.setEnabled(false);
        }
    }

    public FilterList getFilterList() {
        return this.mFilterList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.mOkBtn) {
                this.close();
            } else {
                TreePath path1 = null;
                int[] selectionRows = this.mFilterTree.getSelectionRows();
                if (selectionRows != null && selectionRows.length > 0) {
                    path1 = this.mFilterTree.getPathForRow(selectionRows[0]);
                }
                if (path1 == null) {
                    path1 = new TreePath(this.mFilterTree.getRoot());
                }
                TreePath path = path1;
                FilterNode last = (FilterNode)path.getLastPathComponent();
                this.mFilterTree.setSelectionPath(path);
                if (e.getSource() == this.mNewBtn) {
                    this.createNewFilter(last);
                } else if (e.getSource() == this.mCopyBtn) {
                    this.copySelectedFilter(last);
                } else if (e.getSource() == this.mEditBtn) {
                    this.editSelectedFilter(last);
                } else if (e.getSource() == this.mRemoveBtn) {
                    this.deleteSelectedItem(last);
                } else if (e.getSource() == this.mUpBtn) {
                    this.mFilterTree.moveSelectedFilter(-1);
                    this.updateBtns();
                } else if (e.getSource() == this.mDownBtn) {
                    this.mFilterTree.moveSelectedFilter(1);
                    this.updateBtns();
                } else if (e.getSource() == this.mSeperator) {
                    this.addSeparator(last);
                } else if (e.getSource() == this.mDefaultFilterBtn) {
                    this.setDefaultFilter(last);
                } else if (e.getSource() == this.mNewFolder) {
                    this.createNewFolder(last);
                } else if (e.getSource() == this.mSortAlphabetically) {
                    this.mFilterTree.sortAlphabetically(last);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void editHighlighting(FilterNode node) {
        if (node.containsFilter()) {
            FilterHighlightingSelectionPanel highlighting = new FilterHighlightingSelectionPanel(node.getFilter());
            if (UiUtilities.showConfirmDialogOnMouseScreen(highlighting, LOCALIZER.msg("hightlightingSelection", "Select highlighting for filter: {0}", node.getFilter().getName()), 2, -1, true) == 0) {
                highlighting.save(node.getFilter());
            }
            this.mFilterTree.updateUI();
        }
    }

    @Override
    public void close() {
        MainFrame.updateFilterPanelLabel();
        MainFrame.getInstance().getProgramTableScrollPane().getProgramTable().repaint();
        this.mFilterList.store();
        new Thread("FIRE FILTER TOUCHED THREAD"){

            @Override
            public void run() {
                if (!SelectFilterDlg.this.mTouchedFilterList.isEmpty()) {
                    SelectFilterDlg.this.mFilterTree.getModel().fireFilterTouched(SelectFilterDlg.this.mTouchedFilterList.toArray(new ProgramFilter[SelectFilterDlg.this.mTouchedFilterList.size()]));
                    SelectFilterDlg.this.mTouchedFilterList.clear();
                }
            }
        }.start();
        this.setVisible(false);
        INSTANCE = null;
        this.dispose();
    }

    void copySelectedFilter(FilterNode node) {
        UserFilter filter = (UserFilter)node.getFilter();
        String name = filter.getName();
        int count = name.lastIndexOf("_");
        if (count != -1) {
            try {
                count = Integer.parseInt(name.substring(count + 1)) + 1;
                name = name.substring(0, name.lastIndexOf("_"));
            }
            catch (NumberFormatException nfe) {
                count = 1;
            }
        } else {
            count = 1;
        }
        while (this.mFilterList.containsFilter(name + "_" + count)) {
            ++count;
        }
        UserFilter filterNew = new UserFilter(name + "_" + count);
        try {
            filterNew.setRule(filter.getRule());
            EditFilterDlg dlg = new EditFilterDlg((Window)this, FilterList.getInstance(), filterNew, true);
            if (dlg.getOkWasPressed()) {
                FilterNode nodeNew = new FilterNode(filterNew);
                int[] rows = this.mFilterTree.getSelectionRows();
                FilterNode parent = (FilterNode)node.getParent();
                if (parent.equals(this.mFilterTree.getRoot()) || parent.isDirectoryNode()) {
                    parent.add(nodeNew);
                    this.mFilterTree.expandPath(new TreePath(parent.getPath()));
                } else {
                    ((FilterNode)parent.getParent()).insert(nodeNew, parent.getParent().getIndex(parent));
                }
                this.mFilterTree.getModel().fireFilterAdded(filterNew);
                this.mFilterTree.reload((FilterNode)node.getParent());
                this.mFilterTree.setSelectionRows(rows);
            }
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    void editSelectedFilter(final FilterNode node) {
        new Thread("EDIT SELECTED FILTER THREAD"){

            @Override
            public void run() {
                if (node.getFilter() instanceof FavoriteFilter || node.getFilter() instanceof PluginsProgramFilter || node.getFilter() instanceof InfoBitFilter || node.getFilter() instanceof SingleChannelFilter || node.getFilter() instanceof ShowAllFilter) {
                    SelectFilterDlg.this.editHighlighting(node);
                } else {
                    UserFilter filter = (UserFilter)node.getFilter();
                    EditFilterDlg dlg = new EditFilterDlg((Window)SelectFilterDlg.this, FilterList.getInstance(), filter, true);
                    if (dlg.getOkWasPressed()) {
                        SelectFilterDlg.this.mTouchedFilterList.add(filter);
                        SelectFilterDlg.this.mFilterTree.updateUI();
                    }
                    dlg.dispose();
                }
                SelectFilterDlg.this.updateBtns();
            }
        }.start();
    }

    void deleteSelectedItem(FilterNode node) {
        if (JOptionPane.showConfirmDialog(this, LOCALIZER.msg("delete", "Do you really want to delete the selected value?"), LOCALIZER.msg("deleteTitle", "Delete selected value..."), 0) == 0) {
            int[] rows = this.mFilterTree.getSelectionRows();
            if (node.isDirectoryNode() && node.getChildCount() < 1) {
                FilterNode parent = (FilterNode)node.getParent();
                parent.remove(node);
                this.mFilterTree.getModel().reload(parent);
            } else if ((node.containsFilter() || node.containsSeparator()) && node.isUserDeletingAllowed()) {
                ProgramFilter[] filters = node.getAllFilters();
                this.mFilterTree.getModel().removeNodeFromParent(node);
                for (ProgramFilter filter : filters) {
                    this.mFilterTree.getModel().fireFilterRemoved(filter);
                    Settings.Markings.HIGHLIGHTING_FILTERS.removeEntry(filter.getName());
                }
            } else if (node.getUserObject() instanceof String) {
                this.mFilterTree.getModel().removeNodeFromParent(node);
            }
            if (rows[0] > this.mFilterTree.getRowCount() - 1) {
                rows[0] = this.mFilterTree.getRowCount() - 1;
            }
            this.mFilterTree.updateUI();
            this.mFilterTree.setSelectionRows(rows);
            this.updateBtns();
        }
    }

    void createNewFilter(FilterNode parent) {
        EditFilterDlg dlg = new EditFilterDlg((Window)this, FilterList.getInstance(), null, true);
        UserFilter filter = dlg.getUserFilter();
        if (filter != null) {
            FilterNode node = new FilterNode(filter);
            int[] rows = this.mFilterTree.getSelectionRows();
            if (parent.equals(this.mFilterTree.getRoot()) || parent.isDirectoryNode()) {
                parent.add(node);
                this.mFilterTree.expandPath(new TreePath(parent.getPath()));
            } else {
                ((FilterNode)parent.getParent()).insert(node, parent.getParent().getIndex(parent));
            }
            this.mFilterTree.getModel().fireFilterAdded(filter);
            this.mFilterTree.reload((FilterNode)node.getParent());
            this.mFilterTree.setSelectionRows(rows);
        }
        this.updateBtns();
    }

    void createNewFolder(FilterNode parent) {
        String value = JOptionPane.showInputDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), FilterTree.LOCALIZER.msg("folderName", "Folder name:"), FilterTree.LOCALIZER.msg("newFolder", "New folder"));
        if (value != null && value.length() > 0) {
            FilterNode node = new FilterNode(value);
            if (parent.equals(this.mFilterTree.getRoot()) || parent.isDirectoryNode()) {
                parent.add(node);
                this.mFilterTree.expandPath(new TreePath(parent.getPath()));
            } else {
                ((FilterNode)parent.getParent()).insert(node, parent.getParent().getIndex(parent));
            }
            this.mFilterTree.reload((FilterNode)node.getParent());
        }
        this.updateBtns();
    }

    void addSeparator(FilterNode parent) {
        FilterNode node = new FilterNode(new SeparatorFilter());
        int[] rows = this.mFilterTree.getSelectionRows();
        if (parent.equals(this.mFilterTree.getRoot()) || parent.isDirectoryNode()) {
            parent.add(node);
            this.mFilterTree.expandPath(new TreePath(parent.getPath()));
        } else {
            ((FilterNode)parent.getParent()).insert(node, parent.getParent().getIndex(parent));
        }
        this.mFilterTree.reload((FilterNode)node.getParent());
        this.mFilterTree.setSelectionRows(rows);
        this.updateBtns();
    }

    void setDefaultFilter(FilterNode node) {
        String defaultFilterId = node.getFilter().getClass().getName() + "###" + node.getFilter().getName();
        Settings.General.FILTER_DEFAULT.setString(defaultFilterId);
        this.mFilterTree.updateUI();
        this.mFilterTree.getModel().fireFilterDefaultChanged(node.getFilter());
        this.updateBtns();
    }

    public static void updateFilterTreeUI() {
        if (INSTANCE != null) {
            SelectFilterDlg.INSTANCE.mFilterTree.updateUI();
        }
    }
}

