/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.finder.calendar;

import devplugin.Date;
import java.awt.Point;
import java.text.SimpleDateFormat;
import javax.swing.table.AbstractTableModel;
import tvbrowser.core.Settings;

public final class CalendarTableModel
extends AbstractTableModel {
    private static final int COLUMNS = 7;
    private static final int ROWS = 5;
    private Date[][] mDate = new Date[5][7];
    private Date mCurrentDate = Date.getCurrentDate();
    private int mFirstDayOfWeek = 2;

    public CalendarTableModel(Date firstDate) {
        this.updateContent(firstDate);
    }

    public void updateContent(Date firstDate) {
        Date date = firstDate;
        this.mFirstDayOfWeek = Settings.Locales.FIRST_DAY_OF_WEEK.getInt();
        while (date.getDayOfWeek() != this.mFirstDayOfWeek) {
            date = date.addDays(-1);
        }
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 7; ++x) {
                this.mDate[y][x] = date;
                date = date.addDays(1);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.mDate[rowIndex][columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        String[] days = new SimpleDateFormat().getDateFormatSymbols().getWeekdays();
        int index = column + this.mFirstDayOfWeek;
        if (index > 7) {
            index -= 7;
        }
        return days[index].substring(0, 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Date.class;
    }

    public void setCurrentDate(Date date) {
        this.mCurrentDate = date;
    }

    public Date getCurrentDate() {
        return this.mCurrentDate;
    }

    public Point getPositionOfDate(Date date) {
        for (int row = 0; row < 5; ++row) {
            for (int column = 0; column < 7; ++column) {
                if (!this.mDate[row][column].equals(date)) continue;
                return new Point(column, row);
            }
        }
        return null;
    }
}

