/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Date;
import devplugin.ProgramFilter;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.mainframe.FaytFilter;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;

public class FaytPanel
extends JPanel {
    private ProgramFilter mPreviousFilter;
    private JTextField mTextField = new JTextField();
    private String mText;
    private JButton mSearchCloseBtn;

    public FaytPanel() {
        this.mTextField.addCaretListener(new CaretListener(){

            @Override
            public synchronized void caretUpdate(CaretEvent e) {
                if (!FaytPanel.this.mText.equals(FaytPanel.this.mTextField.getText()) && FaytPanel.this.mPreviousFilter != null) {
                    FaytPanel.this.mText = FaytPanel.this.mTextField.getText();
                    FaytFilter.getInstance().setSearchString(FaytPanel.this.mText);
                    MainFrame.getInstance().setProgramFilter(FaytFilter.getInstance());
                }
            }
        });
        this.mSearchCloseBtn = new JButton(IconLoader.getInstance().getIconFromTheme("actions", "process-stop", 16));
        this.mSearchCloseBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mSearchCloseBtn.setPressedIcon(IconLoader.getInstance().getIconFromTheme("actions", "close-pressed", 16));
        this.mSearchCloseBtn.setToolTipText(Localizer.getLocalization("i18n_close"));
        this.mSearchCloseBtn.setContentAreaFilled(false);
        this.mSearchCloseBtn.setFocusable(false);
        this.mSearchCloseBtn.setOpaque(false);
        MouseListener[] ml = this.mSearchCloseBtn.getMouseListeners();
        for (int i = 0; i < ml.length; ++i) {
            if (ml[i] instanceof ToolTipManager) continue;
            this.mSearchCloseBtn.removeMouseListener(ml[i]);
        }
        this.setBorder(Borders.DLU2);
        this.setOpaque(false);
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("default,5dlu,100dlu", "default"), (JPanel)this);
        AbstractAction close = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FaytPanel.this.closeFayt();
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.mTextField.getInputMap(0).put(stroke, "CLOSE_SEARCH");
        this.mTextField.getActionMap().put("CLOSE_SEARCH", close);
        this.mSearchCloseBtn.getInputMap(0).put(stroke, "CLOSE_SEARCH");
        this.mSearchCloseBtn.getActionMap().put("CLOSE_SEARCH", close);
        this.mSearchCloseBtn.addMouseListener(new MouseAdapter(){
            boolean mOver;

            @Override
            public void mouseEntered(MouseEvent e) {
                this.mOver = true;
                JButton b = (JButton)e.getSource();
                if (b.isEnabled()) {
                    b.setIcon(IconLoader.getInstance().getIconFromTheme("status", "close-over", 16));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.mOver = false;
                JButton b = (JButton)e.getSource();
                if (b.isEnabled()) {
                    b.setIcon(IconLoader.getInstance().getIconFromTheme("actions", "process-stop", 16));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JButton b = (JButton)e.getSource();
                if (b.isEnabled()) {
                    b.setIcon(IconLoader.getInstance().getIconFromTheme("actions", "close-pressed", 16));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JButton b = (JButton)e.getSource();
                if (b.isEnabled()) {
                    b.setIcon(IconLoader.getInstance().getIconFromTheme("actions", "process-stop", 16));
                    if (this.mOver && SwingUtilities.isLeftMouseButton(e)) {
                        FaytPanel.this.closeFayt();
                    }
                }
            }
        });
        pb.add(this.mSearchCloseBtn, 1);
        pb.add(this.mTextField, 3);
    }

    public void setText(String value) {
        if (this.isVisible()) {
            this.mTextField.setText(this.mTextField.getText() + value);
        } else {
            this.setVisible(true);
            this.mPreviousFilter = MainFrame.getInstance().getProgramFilter();
            this.mText = value;
            this.mTextField.setText(value);
            FaytFilter.getInstance().setSearchString(this.mText);
            MainFrame.getInstance().setProgramFilter(FaytFilter.getInstance());
            SwingUtilities.invokeLater(() -> MainFrame.getInstance().getProgramTableScrollPane().requestFocusInWindow());
        }
    }

    public void deleteLastChar() {
        if (this.mText.length() > 0) {
            this.mTextField.requestFocus();
            this.mTextField.setText(this.mText.substring(0, this.mText.length() - 1));
        }
    }

    public synchronized void closeFayt() {
        this.setVisible(false);
        SwingUtilities.invokeLater(() -> {
            MainFrame.getInstance().setProgramFilter(this.mPreviousFilter);
            if (MainFrame.getInstance().getCurrentSelectedDate().equals(Date.getCurrentDate())) {
                SwingUtilities.invokeLater(() -> MainFrame.getInstance().scrollToNow());
            }
        });
    }
}

