/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe.toolbar;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.ToolBarDragAndDropSettings;
import util.i18n.Localizer;
import util.misc.OperatingSystem;
import util.ui.persona.Persona;

public class ContextMenu {
    public static final Localizer mLocalizer = Localizer.getLocalizerFor(ContextMenu.class);
    private JComponent mComponent;
    private JPopupMenu mMenu;

    public ContextMenu(JComponent component) {
        if (ToolBarDragAndDropSettings.getInstance() != null) {
            return;
        }
        this.mComponent = component;
        this.mMenu = new JPopupMenu();
    }

    public void show(int x, int y) {
        if (ToolBarDragAndDropSettings.getInstance() != null) {
            return;
        }
        this.update();
        this.mMenu.show(this.mComponent, x, y);
    }

    protected static JMenu getSubMenu() {
        JMenu menu = new JMenu(mLocalizer.msg("toolbar", "Toolbar"));
        if (!OperatingSystem.isMacOs() || TVBrowser.isTransportable()) {
            menu.add(ContextMenu.createViewMenuBarMenu());
        }
        menu.add(ContextMenu.createViewMenu());
        if (Settings.ToolBar.IS_VISIBLE.getBoolean()) {
            if (Persona.getInstance().getHeaderImage() != null) {
                menu.add(ContextMenu.createMoreBorderTopMenu());
                menu.add(ContextMenu.createMoreBorderBottomMenu());
            }
            menu.add(ContextMenu.createViewSearchMenu());
        }
        menu.addSeparator();
        menu.add(ContextMenu.createConfigureItem());
        return menu;
    }

    private void update() {
        this.mMenu.removeAll();
        if (!OperatingSystem.isMacOs() || TVBrowser.isTransportable()) {
            this.mMenu.add(ContextMenu.createViewMenuBarMenu());
        }
        this.mMenu.add(ContextMenu.createViewMenu());
        if (Settings.ToolBar.IS_VISIBLE.getBoolean()) {
            if (Persona.getInstance().getHeaderImage() != null) {
                this.mMenu.add(ContextMenu.createMoreBorderTopMenu());
                this.mMenu.add(ContextMenu.createMoreBorderBottomMenu());
            }
            this.mMenu.add(ContextMenu.createViewSearchMenu());
        }
        this.mMenu.addSeparator();
        if (ToolBarDragAndDropSettings.getInstance() == null) {
            this.mMenu.add(ContextMenu.createConfigureItem());
        }
    }

    private static JCheckBoxMenuItem createViewSearchMenu() {
        JCheckBoxMenuItem showSearch = new JCheckBoxMenuItem(ToolBarDragAndDropSettings.LOCALIZER.msg("showSearchField", "Show search field"));
        showSearch.setSelected(Settings.ToolBar.IS_SEARCH_FIELD_VISIBLE.getBoolean());
        showSearch.addActionListener(e -> MainFrame.getInstance().setShowSearchField(showSearch.isSelected()));
        return showSearch;
    }

    private static JCheckBoxMenuItem createMoreBorderTopMenu() {
        JCheckBoxMenuItem show = new JCheckBoxMenuItem(mLocalizer.msg("moreBorderTop", "Addtional free space above toolbar"));
        show.setSelected(Settings.ToolBar.ADDITIONAL_TOP_SPACE.getBoolean());
        show.addActionListener(e -> MainFrame.getInstance().setIsToolbarAdditonalTopSpace(show.isSelected()));
        return show;
    }

    private static JCheckBoxMenuItem createMoreBorderBottomMenu() {
        JCheckBoxMenuItem show = new JCheckBoxMenuItem(mLocalizer.msg("moreBorderBottom", "Add free spcace below toolbar"));
        show.setSelected(Settings.ToolBar.ADDITIONAL_BOTTOM_SPACE.getBoolean());
        show.addActionListener(e -> MainFrame.getInstance().setIsToolbarAdditonalBottomSpace(show.isSelected()));
        return show;
    }

    private static JCheckBoxMenuItem createViewMenuBarMenu() {
        JCheckBoxMenuItem show = new JCheckBoxMenuItem(mLocalizer.msg("showMenubar", "Show menubar"));
        show.setSelected(Settings.Window.MENU_BAR_VISIBLE.getBoolean());
        show.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        show.addActionListener(e -> MainFrame.getInstance().setShowMenubar(show.isSelected()));
        return show;
    }

    private static JCheckBoxMenuItem createViewMenu() {
        JCheckBoxMenuItem show = new JCheckBoxMenuItem(ToolBarDragAndDropSettings.LOCALIZER.msg("showToolbar", "Show toolbar"));
        show.setSelected(Settings.ToolBar.IS_VISIBLE.getBoolean());
        show.addActionListener(e -> MainFrame.getInstance().setShowToolbar(show.isSelected()));
        return show;
    }

    private static JMenuItem createConfigureItem() {
        JMenuItem item = new JMenuItem(mLocalizer.ellipsisMsg("configure", "Configure"));
        item.addActionListener(e -> new ToolBarDragAndDropSettings());
        return item;
    }
}

