/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.pluginview;

import devplugin.ActionMenu;
import devplugin.Date;
import devplugin.NodeFormatter;
import devplugin.Program;
import devplugin.ProgramItem;
import devplugin.ProgramReceiveTarget;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import util.i18n.Localizer;

public class Node
extends DefaultMutableTreeNode {
    public static final int ROOT = 0;
    public static final int PLUGIN_ROOT = 1;
    public static final int PROGRAM = 2;
    public static final int STRUCTURE_NODE = 3;
    public static final int CUSTOM_NODE = 4;
    private byte mType;
    private ArrayList<ActionMenu> mActionMenuList;
    private NodeFormatter mNodeFormatter;
    private boolean mShowLeafCount;
    private int mLeafCount = 0;
    private Icon mIcon;
    private ProgramReceiveTarget mReceiveTarget;
    private static NodeFormatter mDefaultNodeFormatter = new NodeFormatter(){

        @Override
        public String format(ProgramItem item) {
            if (item == null) {
                return "<null>";
            }
            Program program = item.getProgram();
            if (program == null) {
                return "<null>";
            }
            StringBuilder builder = new StringBuilder().append(program.getTimeString()).append("  ").append(program.getTitle()).append(" (").append(program.getChannel().getName()).append(')');
            return builder.toString();
        }
    };
    private static NodeFormatter mDefaultDateNodeFormatter = new NodeFormatter(){

        @Override
        public String format(ProgramItem item) {
            if (item == null) {
                return "<null>";
            }
            Program program = item.getProgram();
            if (program == null) {
                return "<null>";
            }
            int h = program.getHours();
            int m = program.getMinutes();
            StringBuilder builder = new StringBuilder().append(h).append(':').append(m < 10 ? "0" : "").append(m).append("  ").append(program.getTitle()).append(" (").append(program.getChannel().getName()).append(')');
            if (program.getDate().equals(Date.getCurrentDate().addDays(-1))) {
                builder.insert(0, " ").insert(0, Localizer.getLocalization("i18n_yesterday"));
            } else if (program.getDate().equals(Date.getCurrentDate())) {
                builder.insert(0, " ").insert(0, Localizer.getLocalization("i18n_today"));
            } else if (program.getDate().equals(Date.getCurrentDate().addDays(1))) {
                builder.insert(0, " ").insert(0, Localizer.getLocalization("i18n_tomorrow"));
            } else {
                builder.insert(0, " ").insert(0, program.getDate().toString());
            }
            return builder.toString();
        }
    };

    public Node(byte type, Object object) {
        super(object);
        this.mType = type;
        this.mActionMenuList = null;
        this.mShowLeafCount = type != 0;
    }

    public Node(int type, Object object) {
        this((byte)type, object);
    }

    public Node(ProgramItem programItem) {
        this(2, (Object)programItem);
        this.setAllowsChildren(false);
    }

    public void setIcon(Icon icon) {
        this.mIcon = icon;
    }

    public Icon getIcon() {
        return this.mIcon;
    }

    public void setProgramReceiveTarget(ProgramReceiveTarget receiveTarget) {
        this.mReceiveTarget = receiveTarget;
    }

    public ProgramReceiveTarget getProgramReceiveTarget() {
        return this.mReceiveTarget;
    }

    public void setNodeFormatter(NodeFormatter formatter) {
        this.mNodeFormatter = formatter;
    }

    public void setShowLeafCountEnabled(boolean enable) {
        this.mShowLeafCount = enable;
    }

    public boolean isShowLeafCount() {
        return this.mShowLeafCount;
    }

    public NodeFormatter getNodeFormatter() {
        return this.getNodeFormatter(false);
    }

    public NodeFormatter getNodeFormatter(boolean isWeekNodesEnabled) {
        if (this.mNodeFormatter != null) {
            return this.mNodeFormatter;
        }
        Node parentNode = (Node)this.getParent();
        if (parentNode != null) {
            return parentNode.getNodeFormatter();
        }
        return isWeekNodesEnabled ? mDefaultDateNodeFormatter : mDefaultNodeFormatter;
    }

    public void addActionMenu(ActionMenu menu) {
        if (this.mActionMenuList == null) {
            this.mActionMenuList = new ArrayList(1);
        }
        this.mActionMenuList.add(menu);
    }

    public void removeActionMenu(ActionMenu menu) {
        if (this.mActionMenuList == null) {
            return;
        }
        this.mActionMenuList.remove(menu);
    }

    public void removeAllActionMenus() {
        if (this.mActionMenuList == null) {
            return;
        }
        this.mActionMenuList.clear();
        this.mActionMenuList = null;
    }

    public ActionMenu[] getActionMenus() {
        if (this.mActionMenuList == null) {
            return new ActionMenu[0];
        }
        ActionMenu[] result = new ActionMenu[this.mActionMenuList.size()];
        this.mActionMenuList.toArray(result);
        return result;
    }

    public int getType() {
        return this.mType;
    }

    @Override
    public boolean isLeaf() {
        return !this.getAllowsChildren();
    }

    public void setLeafCount(int leafs) {
        this.mLeafCount = leafs;
    }

    @Override
    public int getLeafCount() {
        return this.mLeafCount;
    }

    public boolean isDirectoryNode() {
        return this.mType != 2;
    }
}

